/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.NamingManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class InitialContext
implements Context {
    private static final String[] colon_list = new String[]{"java.naming.factory.object", "java.naming.factory.url.pkgs", "java.naming.factory.state"};
    protected Context defaultInitCtx;
    protected boolean gotDefault;
    protected Hashtable myProps;

    protected void init(Hashtable hashtable) throws NamingException {
        InputStream inputStream;
        Properties properties;
        Object object;
        String[] stringArray = new String[]{"java.naming.dns.url", "java.naming.factory.initial", "java.naming.factory.object", "java.naming.provider.url", "java.naming.factory.state", "java.naming.factory.url.pkgs"};
        this.myProps = hashtable != null ? (Hashtable)hashtable.clone() : new Hashtable();
        Applet applet = (Applet)this.myProps.get("java.naming.applet");
        int n = stringArray.length - 1;
        while (n >= 0) {
            object = this.myProps.get(stringArray[n]);
            if (object == null) {
                if (applet != null) {
                    object = applet.getParameter(stringArray[n]);
                }
                if (object == null) {
                    object = System.getProperty(stringArray[n]);
                }
                if (object != null) {
                    this.myProps.put(stringArray[n], object);
                }
            }
            --n;
        }
        try {
            Enumeration enumeration = Thread.currentThread().getContextClassLoader().getResources("jndi.naming");
            while (enumeration.hasMoreElements()) {
                object = (URL)enumeration.nextElement();
                properties = new Properties();
                try {
                    inputStream = ((URL)object).openStream();
                    properties.load(inputStream);
                    inputStream.close();
                }
                catch (IOException iOException) {}
                InitialContext.merge(this.myProps, properties);
            }
        }
        catch (IOException iOException) {}
        String string = System.getProperty("gnu.classpath.home.url");
        if (string != null) {
            object = string + "/jndi.properties";
            properties = new Properties();
            try {
                inputStream = new URL((String)object).openStream();
                properties.load(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {}
            InitialContext.merge(this.myProps, properties);
        }
    }

    private static final void merge(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = hashtable.get(string);
            if (object == null) {
                hashtable.put(string, hashtable2.get(string));
                continue;
            }
            if (string.compareTo(colon_list[0]) != 0 && string.compareTo(colon_list[1]) != 0 && string.compareTo(colon_list[2]) != 0 && string.compareTo(colon_list[3]) != 0) continue;
            String string2 = (String)hashtable2.get(string);
            hashtable.put(string, (String)object + ':' + string2);
        }
    }

    protected Context getDefaultInitCtx() throws NamingException {
        if (!this.gotDefault) {
            this.defaultInitCtx = NamingManager.getInitialContext(this.myProps);
            this.gotDefault = true;
        }
        return this.defaultInitCtx;
    }

    protected Context getURLOrDefaultInitCtx(Name name) throws NamingException {
        if (name.size() > 0) {
            return this.getURLOrDefaultInitCtx(name.get(0));
        }
        return this.getDefaultInitCtx();
    }

    protected Context getURLOrDefaultInitCtx(String string) throws NamingException {
        Context context;
        String string2 = null;
        if (NamingManager.hasInitialContextFactoryBuilder()) {
            return this.getDefaultInitCtx();
        }
        int n = string.indexOf(58);
        int n2 = string.indexOf(47);
        if (n > 0 && (n2 == -1 || n < n2)) {
            string2 = string.substring(0, n);
        }
        if (string2 != null && (context = NamingManager.getURLContext(string2, this.myProps)) != null) {
            return context;
        }
        return this.getDefaultInitCtx();
    }

    public void bind(Name name, Object object) throws NamingException {
        this.getURLOrDefaultInitCtx(name).bind(name, object);
    }

    public void bind(String string, Object object) throws NamingException {
        this.getURLOrDefaultInitCtx(string).bind(string, object);
    }

    public Object lookup(Name name) throws NamingException {
        try {
            return this.getURLOrDefaultInitCtx(name).lookup(name);
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = NamingManager.getContinuationContext(cannotProceedException);
            return context.lookup(cannotProceedException.getRemainingName());
        }
    }

    public Object lookup(String string) throws NamingException {
        try {
            return this.getURLOrDefaultInitCtx(string).lookup(string);
        }
        catch (CannotProceedException cannotProceedException) {
            Context context = NamingManager.getContinuationContext(cannotProceedException);
            return context.lookup(cannotProceedException.getRemainingName());
        }
    }

    public void rebind(Name name, Object object) throws NamingException {
        this.getURLOrDefaultInitCtx(name).rebind(name, object);
    }

    public void rebind(String string, Object object) throws NamingException {
        this.getURLOrDefaultInitCtx(string).rebind(string, object);
    }

    public void unbind(Name name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).unbind(name);
    }

    public void unbind(String string) throws NamingException {
        this.getURLOrDefaultInitCtx(string).unbind(string);
    }

    public void rename(Name name, Name name2) throws NamingException {
        this.getURLOrDefaultInitCtx(name).rename(name, name2);
    }

    public void rename(String string, String string2) throws NamingException {
        this.getURLOrDefaultInitCtx(string).rename(string, string2);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).list(name);
    }

    public NamingEnumeration list(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).list(string);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).listBindings(name);
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).listBindings(string);
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).destroySubcontext(name);
    }

    public void destroySubcontext(String string) throws NamingException {
        this.getURLOrDefaultInitCtx(string).destroySubcontext(string);
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).createSubcontext(name);
    }

    public Context createSubcontext(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).createSubcontext(string);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookupLink(name);
    }

    public Object lookupLink(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).lookupLink(string);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).getNameParser(name);
    }

    public NameParser getNameParser(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).getNameParser(string);
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).composeName(name, name2);
    }

    public String composeName(String string, String string2) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).composeName(string, string2);
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        return this.myProps.put(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        return this.myProps.remove(string);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.myProps;
    }

    public void close() throws NamingException {
        this.myProps = null;
        this.defaultInitCtx = null;
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException();
    }

    private final /* synthetic */ void this() {
        this.gotDefault = false;
    }

    public InitialContext(Hashtable hashtable) throws NamingException {
        this.this();
        this.init(hashtable);
    }

    protected InitialContext(boolean bl) throws NamingException {
        this.this();
        if (!bl) {
            this.init(null);
        }
    }

    public InitialContext() throws NamingException {
        this.this();
        this.init(null);
    }
}

