/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import gnu.java.util.EmptyEnumeration;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefaultMutableTreeNode
implements Cloneable,
MutableTreeNode,
Serializable {
    private static final long serialVersionUID = -4298474751201349152L;
    public static final Enumeration EMPTY_ENUMERATION = EmptyEnumeration.getInstance();
    protected MutableTreeNode parent;
    protected Vector children;
    protected transient Object userObject;
    protected boolean allowsChildren;

    public Object clone() {
        return new DefaultMutableTreeNode(this.userObject, this.allowsChildren);
    }

    public String toString() {
        if (this.userObject == null) {
            return null;
        }
        return this.userObject.toString();
    }

    public void add(MutableTreeNode mutableTreeNode) {
        if (!this.allowsChildren) {
            throw new IllegalStateException();
        }
        if (mutableTreeNode == null) {
            throw new IllegalArgumentException();
        }
        if (this.isNodeAncestor(mutableTreeNode)) {
            throw new IllegalArgumentException("Cannot add ancestor node.");
        }
        this.children.add(mutableTreeNode);
        mutableTreeNode.setParent(this);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void remove(int n) {
        MutableTreeNode mutableTreeNode = (MutableTreeNode)this.children.remove(n);
        mutableTreeNode.setParent(null);
    }

    public void remove(MutableTreeNode mutableTreeNode) {
        if (mutableTreeNode == null) {
            throw new IllegalArgumentException("Null 'node' argument.");
        }
        if (mutableTreeNode.getParent() != this) {
            throw new IllegalArgumentException("The given 'node' is not a child of this node.");
        }
        this.children.remove(mutableTreeNode);
        mutableTreeNode.setParent(null);
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    public void insert(MutableTreeNode mutableTreeNode, int n) {
        if (!this.allowsChildren) {
            throw new IllegalStateException();
        }
        if (mutableTreeNode == null) {
            throw new IllegalArgumentException("Null 'node' argument.");
        }
        if (this.isNodeAncestor(mutableTreeNode)) {
            throw new IllegalArgumentException("Cannot insert ancestor node.");
        }
        this.children.insertElementAt(mutableTreeNode, n);
    }

    public TreeNode[] getPath() {
        return this.getPathToRoot(this, 0);
    }

    public Enumeration children() {
        if (this.children.size() == 0) {
            return EMPTY_ENUMERATION;
        }
        return this.children.elements();
    }

    public void setParent(MutableTreeNode mutableTreeNode) {
        this.parent = mutableTreeNode;
    }

    public TreeNode getChildAt(int n) {
        return (TreeNode)this.children.elementAt(n);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getIndex(TreeNode treeNode) {
        if (treeNode == null) {
            throw new IllegalArgumentException("Null 'node' argument.");
        }
        return this.children.indexOf(treeNode);
    }

    public void setAllowsChildren(boolean bl) {
        if (!bl) {
            this.removeAllChildren();
        }
        this.allowsChildren = bl;
    }

    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void removeFromParent() {
        this.parent.remove(this);
        this.parent = null;
    }

    public void removeAllChildren() {
        int n = this.getChildCount() - 1;
        while (n >= 0) {
            this.remove(n);
            --n;
        }
    }

    public boolean isNodeAncestor(TreeNode treeNode) {
        if (treeNode == null) {
            return false;
        }
        TreeNode treeNode2 = this;
        while (treeNode2 != null && treeNode2 != treeNode) {
            treeNode2 = treeNode2.getParent();
        }
        boolean bl = false;
        if (treeNode2 == treeNode) {
            bl = true;
        }
        return bl;
    }

    public boolean isNodeDescendant(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return false;
        }
        TreeNode treeNode = defaultMutableTreeNode;
        while (treeNode != null && treeNode != this) {
            treeNode = treeNode.getParent();
        }
        boolean bl = false;
        if (treeNode == this) {
            bl = true;
        }
        return bl;
    }

    public TreeNode getSharedAncestor(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreeNode treeNode = this;
        ArrayList arrayList = new ArrayList();
        while (treeNode != null) {
            arrayList.add(treeNode);
            treeNode = treeNode.getParent();
        }
        treeNode = defaultMutableTreeNode;
        while (treeNode != null) {
            if (arrayList.contains(treeNode)) {
                return treeNode;
            }
            treeNode = treeNode.getParent();
        }
        return null;
    }

    public boolean isNodeRelated(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return false;
        }
        boolean bl = false;
        if (defaultMutableTreeNode.getRoot() == this.getRoot()) {
            bl = true;
        }
        return bl;
    }

    public int getDepth() {
        if (!this.allowsChildren || this.children.size() == 0) {
            return 0;
        }
        Stack stack = new Stack();
        stack.push(new Integer(0));
        TreeNode treeNode = this.getChildAt(0);
        int n = 0;
        int n2 = 1;
        while (!stack.empty()) {
            int n3;
            int n4;
            if (treeNode.getChildCount() != 0) {
                treeNode = treeNode.getChildAt(0);
                stack.push(new Integer(0));
                ++n2;
                continue;
            }
            if (n2 > n) {
                n = n2;
            }
            do {
                treeNode = treeNode.getParent();
                n3 = treeNode.getChildCount();
                n4 = (Integer)stack.pop() + 1;
                --n2;
            } while (n4 >= n3 && treeNode != this);
            if (n4 >= n3) continue;
            treeNode = treeNode.getChildAt(n4);
            stack.push(new Integer(n4));
            ++n2;
        }
        return n;
    }

    public int getLevel() {
        int n = -1;
        TreeNode treeNode = this;
        do {
            treeNode = treeNode.getParent();
            ++n;
        } while (treeNode != null);
        return n;
    }

    protected TreeNode[] getPathToRoot(TreeNode treeNode, int n) {
        if (treeNode == null) {
            if (n == 0) {
                return null;
            }
            return new TreeNode[n];
        }
        TreeNode[] treeNodeArray = this.getPathToRoot(treeNode.getParent(), n + 1);
        treeNodeArray[treeNodeArray.length - n - 1] = treeNode;
        return treeNodeArray;
    }

    public Object[] getUserObjectPath() {
        TreeNode[] treeNodeArray = this.getPathToRoot(this, 0);
        Object[] objectArray = new Object[treeNodeArray.length];
        int n = 0;
        while (n < treeNodeArray.length) {
            objectArray[n] = ((DefaultMutableTreeNode)treeNodeArray[n]).getUserObject();
            ++n;
        }
        return objectArray;
    }

    public TreeNode getRoot() {
        TreeNode treeNode = this;
        TreeNode treeNode2 = treeNode.getParent();
        while (treeNode2 != null) {
            treeNode = treeNode2;
            treeNode2 = treeNode.getParent();
        }
        return treeNode;
    }

    public boolean isRoot() {
        boolean bl = false;
        if (this.parent == null) {
            bl = true;
        }
        return bl;
    }

    public DefaultMutableTreeNode getNextNode() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (this.getChildCount() != 0) {
            return (DefaultMutableTreeNode)this.getChildAt(0);
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = this;
        do {
            defaultMutableTreeNode = defaultMutableTreeNode2.getNextSibling();
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
        } while (defaultMutableTreeNode == null && defaultMutableTreeNode2 != null);
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getPreviousNode() {
        if (this.parent == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.getPreviousSibling();
        if (defaultMutableTreeNode == null) {
            return (DefaultMutableTreeNode)this.parent;
        }
        if (defaultMutableTreeNode.getChildCount() != 0) {
            return defaultMutableTreeNode.getLastLeaf();
        }
        return defaultMutableTreeNode;
    }

    public Enumeration preorderEnumeration() {
        return new PreorderEnumeration(this);
    }

    public Enumeration postorderEnumeration() {
        return new PostorderEnumeration(this);
    }

    public Enumeration breadthFirstEnumeration() {
        return new BreadthFirstEnumeration(this);
    }

    public Enumeration depthFirstEnumeration() {
        return this.postorderEnumeration();
    }

    public Enumeration pathFromAncestorEnumeration(TreeNode treeNode) {
        if (treeNode == null) {
            throw new IllegalArgumentException();
        }
        TreeNode treeNode2 = this;
        Vector vector = new Vector();
        vector.add(this);
        while (treeNode2 != treeNode && treeNode2 != null) {
            treeNode2 = treeNode2.getParent();
            vector.add(0, treeNode2);
        }
        if (treeNode2 != treeNode) {
            throw new IllegalArgumentException();
        }
        return vector.elements();
    }

    public boolean isNodeChild(TreeNode treeNode) {
        if (treeNode == null) {
            return false;
        }
        boolean bl = false;
        if (treeNode.getParent() == this) {
            bl = true;
        }
        return bl;
    }

    public TreeNode getFirstChild() {
        return (TreeNode)this.children.firstElement();
    }

    public TreeNode getLastChild() {
        return (TreeNode)this.children.lastElement();
    }

    public TreeNode getChildAfter(TreeNode treeNode) {
        if (treeNode == null || treeNode.getParent() != this) {
            throw new IllegalArgumentException();
        }
        int n = this.getIndex(treeNode) + 1;
        if (n == this.getChildCount()) {
            return null;
        }
        return this.getChildAt(n);
    }

    public TreeNode getChildBefore(TreeNode treeNode) {
        if (treeNode == null || treeNode.getParent() != this) {
            throw new IllegalArgumentException();
        }
        int n = this.getIndex(treeNode) - 1;
        if (n < 0) {
            return null;
        }
        return this.getChildAt(n);
    }

    public boolean isNodeSibling(TreeNode treeNode) {
        if (treeNode == null) {
            return false;
        }
        if (treeNode == this) {
            return true;
        }
        boolean bl = false;
        if (treeNode.getParent() == this.getParent() && this.getParent() != null) {
            bl = true;
        }
        return bl;
    }

    public int getSiblingCount() {
        if (this.parent == null) {
            return 1;
        }
        return this.parent.getChildCount();
    }

    public DefaultMutableTreeNode getNextSibling() {
        if (this.parent == null) {
            return null;
        }
        int n = this.parent.getIndex(this) + 1;
        if (n == this.parent.getChildCount()) {
            return null;
        }
        return (DefaultMutableTreeNode)this.parent.getChildAt(n);
    }

    public DefaultMutableTreeNode getPreviousSibling() {
        if (this.parent == null) {
            return null;
        }
        int n = this.parent.getIndex(this) - 1;
        if (n < 0) {
            return null;
        }
        return (DefaultMutableTreeNode)this.parent.getChildAt(n);
    }

    public boolean isLeaf() {
        boolean bl = false;
        if (this.children.size() == 0) {
            bl = true;
        }
        return bl;
    }

    public DefaultMutableTreeNode getFirstLeaf() {
        TreeNode treeNode = this;
        while (treeNode.getChildCount() > 0) {
            treeNode = treeNode.getChildAt(0);
        }
        return treeNode;
    }

    public DefaultMutableTreeNode getLastLeaf() {
        TreeNode treeNode = this;
        int n = treeNode.getChildCount();
        while (n > 0) {
            treeNode = treeNode.getChildAt(n - 1);
            n = treeNode.getChildCount();
        }
        return treeNode;
    }

    public DefaultMutableTreeNode getNextLeaf() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getNextSibling();
        if (defaultMutableTreeNode != null) {
            return defaultMutableTreeNode.getFirstLeaf();
        }
        if (this.parent != null) {
            return ((DefaultMutableTreeNode)this.parent).getNextLeaf();
        }
        return null;
    }

    public DefaultMutableTreeNode getPreviousLeaf() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getPreviousSibling();
        if (defaultMutableTreeNode != null) {
            return defaultMutableTreeNode.getLastLeaf();
        }
        if (this.parent != null) {
            return ((DefaultMutableTreeNode)this.parent).getPreviousLeaf();
        }
        return null;
    }

    public int getLeafCount() {
        int n = 0;
        Enumeration enumeration = this.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode = (TreeNode)enumeration.nextElement();
            if (!treeNode.isLeaf()) continue;
            ++n;
        }
        return n;
    }

    private final /* synthetic */ void this() {
        this.children = new Vector();
    }

    public DefaultMutableTreeNode() {
        this(null, true);
    }

    public DefaultMutableTreeNode(Object object) {
        this(object, true);
    }

    public DefaultMutableTreeNode(Object object, boolean bl) {
        this.this();
        this.userObject = object;
        this.allowsChildren = bl;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class PreorderEnumeration
    implements Enumeration {
        TreeNode next;
        Stack childrenEnums;

        public boolean hasMoreElements() {
            boolean bl = false;
            if (this.next != null) {
                bl = true;
            }
            return bl;
        }

        public Object nextElement() {
            if (this.next == null) {
                throw new NoSuchElementException("No more elements left.");
            }
            TreeNode treeNode = this.next;
            Enumeration enumeration = (Enumeration)this.childrenEnums.peek();
            this.next = this.traverse(enumeration);
            return treeNode;
        }

        private final TreeNode traverse(Enumeration enumeration) {
            if (enumeration.hasMoreElements()) {
                TreeNode treeNode = (TreeNode)enumeration.nextElement();
                this.childrenEnums.push(treeNode.children());
                return treeNode;
            }
            this.childrenEnums.pop();
            if (this.childrenEnums.isEmpty()) {
                return null;
            }
            return this.traverse((Enumeration)this.childrenEnums.peek());
        }

        private final /* synthetic */ void this() {
            this.childrenEnums = new Stack();
        }

        PreorderEnumeration(TreeNode treeNode) {
            this.this();
            this.next = treeNode;
            this.childrenEnums.push(treeNode.children());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class PostorderEnumeration
    implements Enumeration {
        Stack nodes;
        Stack childrenEnums;

        public boolean hasMoreElements() {
            return this.nodes.isEmpty() ^ true;
        }

        public Object nextElement() {
            if (this.nodes.isEmpty()) {
                throw new NoSuchElementException("No more elements left!");
            }
            Enumeration enumeration = (Enumeration)this.childrenEnums.peek();
            return this.traverse(enumeration);
        }

        private final Object traverse(Enumeration enumeration) {
            if (enumeration.hasMoreElements()) {
                TreeNode treeNode = (TreeNode)enumeration.nextElement();
                this.nodes.push(treeNode);
                Enumeration enumeration2 = treeNode.children();
                this.childrenEnums.push(enumeration2);
                return this.traverse(enumeration2);
            }
            this.childrenEnums.pop();
            Object object = this.nodes.peek();
            this.nodes.pop();
            return object;
        }

        private final /* synthetic */ void this() {
            this.nodes = new Stack();
            this.childrenEnums = new Stack();
        }

        PostorderEnumeration(TreeNode treeNode) {
            this.this();
            this.nodes.push(treeNode);
            this.childrenEnums.push(treeNode.children());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class BreadthFirstEnumeration
    implements Enumeration {
        LinkedList queue;

        public boolean hasMoreElements() {
            return this.queue.isEmpty() ^ true;
        }

        public Object nextElement() {
            if (this.queue.isEmpty()) {
                throw new NoSuchElementException("No more elements left.");
            }
            TreeNode treeNode = (TreeNode)this.queue.removeFirst();
            Enumeration enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                this.queue.add(enumeration.nextElement());
            }
            return treeNode;
        }

        private final /* synthetic */ void this() {
            this.queue = new LinkedList();
        }

        BreadthFirstEnumeration(TreeNode treeNode) {
            this.this();
            this.queue.add(treeNode);
        }
    }
}

