/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.validation;

import gnu.xml.validation.relaxng.RELAXNGSchemaFactory;
import gnu.xml.validation.xmlschema.XMLSchemaSchemaFactory;
import java.io.File;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public abstract class SchemaFactory {
    ErrorHandler errorHandler;

    public static final SchemaFactory newInstance(String string) {
        if ("http://www.w3.org/2001/XMLSchema".equals(string)) {
            return new XMLSchemaSchemaFactory();
        }
        if ("http://relaxng.org/ns/structure/1.0".equals(string)) {
            return new RELAXNGSchemaFactory();
        }
        throw new IllegalArgumentException(string);
    }

    public abstract boolean isSchemaLanguageSupported(String var1);

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public abstract LSResourceResolver getResourceResolver();

    public abstract void setResourceResolver(LSResourceResolver var1);

    public Schema newSchema(Source source) throws SAXException {
        return this.newSchema(new Source[]{source});
    }

    public Schema newSchema(File file) throws SAXException {
        return this.newSchema(new StreamSource(file));
    }

    public Schema newSchema(URL uRL) throws SAXException {
        return this.newSchema(new StreamSource(uRL.toString()));
    }

    public abstract Schema newSchema(Source[] var1) throws SAXException;

    public abstract Schema newSchema() throws SAXException;

    protected SchemaFactory() {
    }
}

