.\" $Header: /home/vikas/src/nocol/doc/RCS/nocol-prog.3,v 1.7 1997/07/13 12:04:05 vikas Exp $
.\"
.TH NOCOL-PROG 3 "May 1994"
.SH NAME
nocol-prog \- NOCOL design and data structures
.SH SYNOPSIS
This section describes the design and data structures in NOCOL. This section
is intended  to be a programmers aid to understanding the overall design of
NOCOL.
.SH DESCRIPTION
.LP
The original initiative for developing NOCOL was:
.in +.25i
.IP 1.
While monitoring a system, the severity of various events is pre-determined
by the monitors and the user can select the severity level at which he/she
should be notified.
.IP 2.
Display events only at the desired level of severity and nothing else.
.IP 3. 
Have only \fIone\fR set of monitoring agents on a network, and be able to
share the monitored data between multiple display agents, for a unique
consistent view of the monitored entities.
.IP 4.
A display module that can be run on a simple TTY terminal so that the
system can be monitored using a simple VT type terminal.
.IP 5.
To have the ability to add on monitoring agents as and when necessary with
minimum changes to existing monitors.
.IP 6.
To be able to add on additional (possibly intelligent) post-processors for the
data.
.IP 7.
To have the capability to monitor \fIany\fR entity (network routers, system
load, modem line usage, system processes, etc.) in any protocol desired (IP,
OSI, DECnet).

.SH DATA STRUCTURES
.LP
The \fIEVENT\fR data structure is defined in \fInocol.h\fR. All nocol data
must be a sequence of this structure. Other than that, the various modules
can be as independent as possible.

The various fields in the structure are:
.RS
.ta \w'#define'u +\w'fsid_t\0\0'u +\w'f_spare[7]\0\0'u
.sp .5
.nf
typedef struct
{
    char		sender;	/* sender/program name */
    SITE		site;	/* site name, address */
    VAR			var;	/* variable name, value, threshold, units */
    unsigned char	mon;	/* 1 to 12 for month */
    unsigned char	day;	/* 1 to 31 for day */
    unsigned char	hour;	/* 0 to 23 for hour */
    unsigned char	min;	/* 0 to 59 for minute */
    unsigned char	severity;	/* event severity 1->4 */
    unsigned char	logseverity;	/* severity at which event is logged */
    unsigned char	nocop;	/* ops flag indicating STATE */
} EVENT;
.fi
.RE
.LP
The \fIsender\fR  field is typically used to identify the monitoring program.
The site \fIname\fR is generally a hostname or a shorter identifiable
name of the entitity being monitored. The site \fIaddress\fR 
field is large and the intent is that it can accommodate IP, OSI or any other
address/identification needed by the monitoring programs so that once they
start up, they can work directly from the output data files by using the
EVENT structure and not having to parse configuration files, etc. every time.
In some monitors, it can also be the filename, or route being monitored.

The \fIvariable\fR  name field is self-explanatory\- it can be 
reachability, trap-type, thruput, bgp-route, load, diskio, etc.
The value, threshold and units are further used to give more information
about the variable.

The date and time fields record the time that the site was
.I first
detected in the current state.

The \fIseverity\fR of the event varies from 1 (=CRITICAL) to 4 (=INFO). 
The monitors generally escalate the severity in each pass, so that
there is a gradual and repeated test before an event is marked as
CRITICAL, etc. Furthermore, each monitor has its own MAX_SEVERITY
.RI ( e.g.
for the reachability monitor
.IR pingmon ,
the maximum possible severity level is CRITICAL while for the
.I tpmon
thruput monitor, the maximum possible severity level is WARNING).
Some monitors have three thresholds for the maximum severity (warning, error
and critical).
A nocol library call
.I update_event
has been provided to escalate/reset the severity and to log the
event if there is a change in the severity level.

The \fIloglevel\fR field is used to indicate the severity level at
which the event should be logged. This field is used by the logging
daemon in determining how/where to log the event.

The \fInocop\fR is for setting various boolean options associated with each
event (like status UP, DOWN, UNKNOWN, TEST, NODISPLAY)- note that UP, DOWN,
UNKNOWN are all mutually exclusive, the \fISETF_UPDOUN\fR macro accomplishes
the mutual exclusion.
The TEST flag is useful for the post-processors which perform an operation on
a site reaching a certain level of severity, and the NODISPLAY option is
useful if a particular site is not to be displayed in the 
.BR nocol (1)
display but other post-processors need to process the data.
Most of the monitors parse the config file and create an output data file
with the static structure values in it and the \fInocop\fR UNKNOWN flag set.
They then read a single event from the datafile and poll the site. New values
are inserted and the structure written back to disk.

.SH libnocol.a
.LP
A collection of useful routines have been merged into a NOCOL library\-
.I libnocol.a
with which all the various monitors are linked during compile time.
Functions to create a new 'pid' file and log the PID and hostname, 
to update an event's  values based on the new status, etc. are available.
Of these, 
.I update_event
is important\-  this function takes a pointer to an event, status
(UP or DOWN) and maximum severity level that the event can be escalated to.
It then updates the event's severity, loglevel and also logs the event to 
.I noclogd
if appropriate.

.SH PERLNOCOL
.LP
A PERL interface to NOCOL is provided, with a bunch of utility routines in
the
.I nocollib.pl
library. Utility routines for doing most of the standard tasks have been
provided in this file. Usually, two routines need to be written for
developing a new monitor\- one for reading the configuration file and the
other for doing the test. The provided samples should help in writing new
monitors using the PERL language.

.SH GENMON
The
.I genmon
program provides a generic monitoring interface for writing new monitors.
It converts text lines in the logfile format into nocol EVENT structures
and writes them out. Thus, a simple shell script that monitors anything
can call
.I genmon
with a text line and the program will convert the line into a NOCOL
event strutcure. See the 
.IR genmon (8)
manual page for more information on this program.

NOTE: The PERL interface provides more functionality instead of the
.B genmon
interface in writing simple new monitors.

.SH LOGGING
The various NOCOL monitors log events to a daemon-
.B noclogd
.I (8)
at port NLOG_PORT (see the
.I noclogd.h
include file for the port number). The function
.I eventlog()
is available in the 
.I libnocol.a 
library and can be called with the
event structure as a parameter. The monitor is responsible for filling
in the
.I loglevel
field in the EVENT structure, and the function
.I eventlog()
will log the event to the noclogd daemon.
As a design note, keep in mind that it is worthwhile logging ONLY when the
severity
.B changes
instead of logging every pass made.
Also, if a site is in CRITICAL
level (as an example), then it is typically logged at loglevel=CRITICAL
when the site first goes into CRITICAL state. Importantly, when the site
goes 
.I back
to INFO level, the monitor should log this event at the earlier CRITICAL 
status so that the person/programs
parsing the CRITICAL logs can see when the site came out of critical status.
The
.I update_event()
library call in NOCOL does this bit of 'complicated' manipulation of the
loglevel (sets loglevel to the old severity if the status changes to UP).

.SH DEVELOPING NEW MONITORS
To do additional development on a monitor, the 
.I pingmon, nsmon, tpmon
are very similar and based on the same logic so they should provide good
examples of how to do things.
Typical procedure flow is:
.RS
.sp .5
.nf
  - Read configuration file
  - Init nocol EVENT data structures
  - Do test
  - Update EVENT data structure
  - Write out to datafile (as a group or individually)
  - Sleep before next round of tests
.fi
.RE

The
.BR genmon (8)
program provides a simple and easy interface to developing new monitors
for monitoring practically
.IR anything .
A collection of useful PERL routines and library is also provided.

.\" --------------------------------------------
.SH AUTHOR
.nf
Vikas Aggarwal, vikas@navya.com.
.fi
Additions by a lot of other folks... the PERL routines were provided by
John M. Wobus (jmwobus@mailbox.syr.edu).
.SH SEE ALSO
netconsole(1) nocol-prog(3) perlnocol(3)
etherload(8) eventselect(8) genmon(8) noclogd(8) nocol-overview(8)
nocol-utility(8) nsmon(8) pingmon(8) portmon(8) 
tpmon(8) trapmon(8)

