require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_NETINET_IP_FIL_H_)) {
    eval 'sub _NETINET_IP_FIL_H_ () {1;}' unless defined(&_NETINET_IP_FIL_H_);
    require 'netinet/ip_compat.ph';
    require 'netinet/ipf_rb.ph';
    if( &NETBSD_GE_REV(104040000)) {
	require 'sys/callout.ph';
    }
    if(defined(&BSD)  && defined(&_KERNEL)) {
	if( &NETBSD_LT_REV(399000000) || defined(&__osf__) ||  &FREEBSD_LT_REV(500043)) {
	    require 'sys/select.ph';
	} else {
	    require 'sys/selinfo.ph';
	}
    }
    if(!defined(&linux) || !defined(&_KERNEL)) {
	require 'netinet/in.ph';
    }
    unless(defined(&SOLARIS)) {
	if((defined(&sun)  && (defined(&__svr4__) || defined(&__SVR4)))) {
	    eval 'sub SOLARIS () {1;}' unless defined(&SOLARIS);
	} else {
	    eval 'sub SOLARIS () {0;}' unless defined(&SOLARIS);
	}
    }
    if(defined(&__STDC__) || defined(&__GNUC__) || defined(&_AIX51)) {
	eval 'sub SIOCADAFR () { &_IOW(ord(\'r\'), 60, \'struct ipfobj\');}' unless defined(&SIOCADAFR);
	eval 'sub SIOCRMAFR () { &_IOW(ord(\'r\'), 61, \'struct ipfobj\');}' unless defined(&SIOCRMAFR);
	eval 'sub SIOCSETFF () { &_IOW(ord(\'r\'), 62, \'u_int\');}' unless defined(&SIOCSETFF);
	eval 'sub SIOCGETFF () { &_IOR(ord(\'r\'), 63, \'u_int\');}' unless defined(&SIOCGETFF);
	eval 'sub SIOCGETFS () { &_IOWR(ord(\'r\'), 64, \'struct ipfobj\');}' unless defined(&SIOCGETFS);
	eval 'sub SIOCIPFFL () { &_IOWR(ord(\'r\'), 65, \'int\');}' unless defined(&SIOCIPFFL);
	eval 'sub SIOCIPFFB () { &_IOR(ord(\'r\'), 66, \'int\');}' unless defined(&SIOCIPFFB);
	eval 'sub SIOCADIFR () { &_IOW(ord(\'r\'), 67, \'struct ipfobj\');}' unless defined(&SIOCADIFR);
	eval 'sub SIOCRMIFR () { &_IOW(ord(\'r\'), 68, \'struct ipfobj\');}' unless defined(&SIOCRMIFR);
	eval 'sub SIOCSWAPA () { &_IOR(ord(\'r\'), 69, \'u_int\');}' unless defined(&SIOCSWAPA);
	eval 'sub SIOCINAFR () { &_IOW(ord(\'r\'), 70, \'struct ipfobj\');}' unless defined(&SIOCINAFR);
	eval 'sub SIOCINIFR () { &_IOW(ord(\'r\'), 71, \'struct ipfobj\');}' unless defined(&SIOCINIFR);
	eval 'sub SIOCFRENB () { &_IOW(ord(\'r\'), 72, \'u_int\');}' unless defined(&SIOCFRENB);
	eval 'sub SIOCFRSYN () { &_IOW(ord(\'r\'), 73, \'u_int\');}' unless defined(&SIOCFRSYN);
	eval 'sub SIOCFRZST () { &_IOWR(ord(\'r\'), 74, \'struct ipfobj\');}' unless defined(&SIOCFRZST);
	eval 'sub SIOCZRLST () { &_IOWR(ord(\'r\'), 75, \'struct ipfobj\');}' unless defined(&SIOCZRLST);
	eval 'sub SIOCAUTHW () { &_IOWR(ord(\'r\'), 76, \'struct ipfobj\');}' unless defined(&SIOCAUTHW);
	eval 'sub SIOCAUTHR () { &_IOWR(ord(\'r\'), 77, \'struct ipfobj\');}' unless defined(&SIOCAUTHR);
	eval 'sub SIOCSTAT1 () { &_IOWR(ord(\'r\'), 78, \'struct ipfobj\');}' unless defined(&SIOCSTAT1);
	eval 'sub SIOCSTLCK () { &_IOWR(ord(\'r\'), 79, \'u_int\');}' unless defined(&SIOCSTLCK);
	eval 'sub SIOCSTPUT () { &_IOWR(ord(\'r\'), 80, \'struct ipfobj\');}' unless defined(&SIOCSTPUT);
	eval 'sub SIOCSTGET () { &_IOWR(ord(\'r\'), 81, \'struct ipfobj\');}' unless defined(&SIOCSTGET);
	eval 'sub SIOCSTGSZ () { &_IOWR(ord(\'r\'), 82, \'struct ipfobj\');}' unless defined(&SIOCSTGSZ);
	eval 'sub SIOCSTAT2 () { &_IOWR(ord(\'r\'), 83, \'struct ipfobj\');}' unless defined(&SIOCSTAT2);
	eval 'sub SIOCSETLG () { &_IOWR(ord(\'r\'), 84, \'int\');}' unless defined(&SIOCSETLG);
	eval 'sub SIOCGETLG () { &_IOWR(ord(\'r\'), 85, \'int\');}' unless defined(&SIOCGETLG);
	eval 'sub SIOCFUNCL () { &_IOWR(ord(\'r\'), 86, \'struct ipfunc_resolve\');}' unless defined(&SIOCFUNCL);
	eval 'sub SIOCIPFGETNEXT () { &_IOWR(ord(\'r\'), 87, \'struct ipfobj\');}' unless defined(&SIOCIPFGETNEXT);
	eval 'sub SIOCIPFGET () { &_IOWR(ord(\'r\'), 88, \'struct ipfobj\');}' unless defined(&SIOCIPFGET);
	eval 'sub SIOCIPFSET () { &_IOWR(ord(\'r\'), 89, \'struct ipfobj\');}' unless defined(&SIOCIPFSET);
	eval 'sub SIOCIPFL6 () { &_IOWR(ord(\'r\'), 90, \'int\');}' unless defined(&SIOCIPFL6);
	eval 'sub SIOCIPFITER () { &_IOWR(ord(\'r\'), 91, \'struct ipfobj\');}' unless defined(&SIOCIPFITER);
	eval 'sub SIOCGENITER () { &_IOWR(ord(\'r\'), 92, \'struct ipfobj\');}' unless defined(&SIOCGENITER);
	eval 'sub SIOCGTABL () { &_IOWR(ord(\'r\'), 93, \'struct ipfobj\');}' unless defined(&SIOCGTABL);
	eval 'sub SIOCIPFDELTOK () { &_IOWR(ord(\'r\'), 94, \'int\');}' unless defined(&SIOCIPFDELTOK);
	eval 'sub SIOCLOOKUPITER () { &_IOWR(ord(\'r\'), 95, \'struct ipfobj\');}' unless defined(&SIOCLOOKUPITER);
	eval 'sub SIOCGTQTAB () { &_IOWR(ord(\'r\'), 96, \'struct ipfobj\');}' unless defined(&SIOCGTQTAB);
	eval 'sub SIOCMATCHFLUSH () { &_IOWR(ord(\'r\'), 97, \'struct ipfobj\');}' unless defined(&SIOCMATCHFLUSH);
	eval 'sub SIOCIPFINTERROR () { &_IOR(ord(\'r\'), 98, \'int\');}' unless defined(&SIOCIPFINTERROR);
    } else {
	eval 'sub SIOCADAFR () { &_IOW("r", 60, \'struct ipfobj\');}' unless defined(&SIOCADAFR);
	eval 'sub SIOCRMAFR () { &_IOW("r", 61, \'struct ipfobj\');}' unless defined(&SIOCRMAFR);
	eval 'sub SIOCSETFF () { &_IOW("r", 62, \'u_int\');}' unless defined(&SIOCSETFF);
	eval 'sub SIOCGETFF () { &_IOR("r", 63, \'u_int\');}' unless defined(&SIOCGETFF);
	eval 'sub SIOCGETFS () { &_IOWR("r", 64, \'struct ipfobj\');}' unless defined(&SIOCGETFS);
	eval 'sub SIOCIPFFL () { &_IOWR("r", 65, \'int\');}' unless defined(&SIOCIPFFL);
	eval 'sub SIOCIPFFB () { &_IOR("r", 66, \'int\');}' unless defined(&SIOCIPFFB);
	eval 'sub SIOCADIFR () { &_IOW("r", 67, \'struct ipfobj\');}' unless defined(&SIOCADIFR);
	eval 'sub SIOCRMIFR () { &_IOW("r", 68, \'struct ipfobj\');}' unless defined(&SIOCRMIFR);
	eval 'sub SIOCSWAPA () { &_IOR("r", 69, \'u_int\');}' unless defined(&SIOCSWAPA);
	eval 'sub SIOCINAFR () { &_IOW("r", 70, \'struct ipfobj\');}' unless defined(&SIOCINAFR);
	eval 'sub SIOCINIFR () { &_IOW("r", 71, \'struct ipfobj\');}' unless defined(&SIOCINIFR);
	eval 'sub SIOCFRENB () { &_IOW("r", 72, \'u_int\');}' unless defined(&SIOCFRENB);
	eval 'sub SIOCFRSYN () { &_IOW("r", 73, \'u_int\');}' unless defined(&SIOCFRSYN);
	eval 'sub SIOCFRZST () { &_IOWR("r", 74, \'struct ipfobj\');}' unless defined(&SIOCFRZST);
	eval 'sub SIOCZRLST () { &_IOWR("r", 75, \'struct ipfobj\');}' unless defined(&SIOCZRLST);
	eval 'sub SIOCAUTHW () { &_IOWR("r", 76, \'struct ipfobj\');}' unless defined(&SIOCAUTHW);
	eval 'sub SIOCAUTHR () { &_IOWR("r", 77, \'struct ipfobj\');}' unless defined(&SIOCAUTHR);
	eval 'sub SIOCSTAT1 () { &_IOWR("r", 78, \'struct ipfobj\');}' unless defined(&SIOCSTAT1);
	eval 'sub SIOCSTLCK () { &_IOWR("r", 79, \'u_int\');}' unless defined(&SIOCSTLCK);
	eval 'sub SIOCSTPUT () { &_IOWR("r", 80, \'struct ipfobj\');}' unless defined(&SIOCSTPUT);
	eval 'sub SIOCSTGET () { &_IOWR("r", 81, \'struct ipfobj\');}' unless defined(&SIOCSTGET);
	eval 'sub SIOCSTGSZ () { &_IOWR("r", 82, \'struct ipfobj\');}' unless defined(&SIOCSTGSZ);
	eval 'sub SIOCSTAT2 () { &_IOWR("r", 83, \'struct ipfobj\');}' unless defined(&SIOCSTAT2);
	eval 'sub SIOCSETLG () { &_IOWR("r", 84, \'int\');}' unless defined(&SIOCSETLG);
	eval 'sub SIOCGETLG () { &_IOWR("r", 85, \'int\');}' unless defined(&SIOCGETLG);
	eval 'sub SIOCFUNCL () { &_IOWR("r", 86, \'struct ipfunc_resolve\');}' unless defined(&SIOCFUNCL);
	eval 'sub SIOCIPFGETNEXT () { &_IOWR("r", 87, \'struct ipfobj\');}' unless defined(&SIOCIPFGETNEXT);
	eval 'sub SIOCIPFGET () { &_IOWR("r", 88, \'struct ipfobj\');}' unless defined(&SIOCIPFGET);
	eval 'sub SIOCIPFSET () { &_IOWR("r", 89, \'struct ipfobj\');}' unless defined(&SIOCIPFSET);
	eval 'sub SIOCIPFL6 () { &_IOWR("r", 90, \'int\');}' unless defined(&SIOCIPFL6);
	eval 'sub SIOCIPFITER () { &_IOWR("r", 91, \'struct ipfobj\');}' unless defined(&SIOCIPFITER);
	eval 'sub SIOCGENITER () { &_IOWR("r", 92, \'struct ipfobj\');}' unless defined(&SIOCGENITER);
	eval 'sub SIOCGTABL () { &_IOWR("r", 93, \'struct ipfobj\');}' unless defined(&SIOCGTABL);
	eval 'sub SIOCIPFDELTOK () { &_IOWR("r", 94, \'int\');}' unless defined(&SIOCIPFDELTOK);
	eval 'sub SIOCLOOKUPITER () { &_IOWR("r", 95, \'struct ipfobj\');}' unless defined(&SIOCLOOKUPITER);
	eval 'sub SIOCGTQTAB () { &_IOWR("r", 96, \'struct ipfobj\');}' unless defined(&SIOCGTQTAB);
	eval 'sub SIOCMATCHFLUSH () { &_IOWR("r", 97, \'struct ipfobj\');}' unless defined(&SIOCMATCHFLUSH);
	eval 'sub SIOCIPFINTERROR () { &_IOR("r", 98, \'int\');}' unless defined(&SIOCIPFINTERROR);
    }
    eval 'sub SIOCADDFR () { &SIOCADAFR;}' unless defined(&SIOCADDFR);
    eval 'sub SIOCDELFR () { &SIOCRMAFR;}' unless defined(&SIOCDELFR);
    eval 'sub SIOCINSFR () { &SIOCINAFR;}' unless defined(&SIOCINSFR);
    eval 'sub SIOCATHST () { &SIOCSTAT1;}' unless defined(&SIOCATHST);
    eval 'sub SIOCGFRST () { &SIOCSTAT2;}' unless defined(&SIOCGFRST);
    if(defined(&USE_INET6)) {
    } else {
    }
    eval 'sub in4_addr () { ($in4->{s_addr});}' unless defined(&in4_addr);
    eval 'sub iplookupnum () { $i6[1];}' unless defined(&iplookupnum);
    eval 'sub iplookupname () { ($i6un->{name});}' unless defined(&iplookupname);
    eval 'sub iplookuptype () { ($i6un->{type});}' unless defined(&iplookuptype);
    eval 'sub iplookupsubtype () { ($i6un->{subtype});}' unless defined(&iplookupsubtype);
    eval 'sub iplookupptr () { $vptr[0];}' unless defined(&iplookupptr);
    eval 'sub iplookupfunc () { $lptr[1];}' unless defined(&iplookupfunc);
    eval 'sub I60 {
        my($x) = @_;
	    eval q(((( &u_32_t *)($x))[0]));
    }' unless defined(&I60);
    eval 'sub I61 {
        my($x) = @_;
	    eval q(((( &u_32_t *)($x))[1]));
    }' unless defined(&I61);
    eval 'sub I62 {
        my($x) = @_;
	    eval q(((( &u_32_t *)($x))[2]));
    }' unless defined(&I62);
    eval 'sub I63 {
        my($x) = @_;
	    eval q(((( &u_32_t *)($x))[3]));
    }' unless defined(&I63);
    eval 'sub HI60 {
        my($x) = @_;
	    eval q( &ntohl((( &u_32_t *)($x))[0]));
    }' unless defined(&HI60);
    eval 'sub HI61 {
        my($x) = @_;
	    eval q( &ntohl((( &u_32_t *)($x))[1]));
    }' unless defined(&HI61);
    eval 'sub HI62 {
        my($x) = @_;
	    eval q( &ntohl((( &u_32_t *)($x))[2]));
    }' unless defined(&HI62);
    eval 'sub HI63 {
        my($x) = @_;
	    eval q( &ntohl((( &u_32_t *)($x))[3]));
    }' unless defined(&HI63);
    eval 'sub IP6_EQ {
        my($a,$b) = @_;
	    eval q((( &I63($a) ==  &I63($b))  && ( &I62($a) ==  &I62($b))  && ( &I61($a) ==  &I61($b))  && ( &I60($a) ==  &I60($b))));
    }' unless defined(&IP6_EQ);
    eval 'sub IP6_NEQ {
        my($a,$b) = @_;
	    eval q((( &I63($a) !=  &I63($b)) || ( &I62($a) !=  &I62($b)) || ( &I61($a) !=  &I61($b)) || ( &I60($a) !=  &I60($b))));
    }' unless defined(&IP6_NEQ);
    eval 'sub IP6_ISZERO {
        my($a) = @_;
	    eval q((( &I60($a) |  &I61($a) |  &I62($a) |  &I63($a)) == 0));
    }' unless defined(&IP6_ISZERO);
    eval 'sub IP6_NOTZERO {
        my($a) = @_;
	    eval q((( &I60($a) |  &I61($a) |  &I62($a) |  &I63($a)) != 0));
    }' unless defined(&IP6_NOTZERO);
    eval 'sub IP6_ISONES {
        my($a) = @_;
	    eval q((( &I63($a) == 0xffffffff)  && ( &I62($a) == 0xffffffff)  && ( &I61($a) == 0xffffffff)  && ( &I60($a) == 0xffffffff)));
    }' unless defined(&IP6_ISONES);
    eval 'sub IP6_GT {
        my($a,$b) = @_;
	    eval q(( &ntohl( &HI60($a)) >  &ntohl( &HI60($b)) || ( &HI60($a) ==  &HI60($b)  && ( &ntohl( &HI61($a)) >  &ntohl( &HI61($b)) || ( &HI61($a) ==  &HI61($b)  && ( &ntohl( &HI62($a)) >  &ntohl( &HI62($b)) || ( &HI62($a) ==  &HI62($b)  &&  &ntohl( &HI63($a)) >  &ntohl( &HI63($b)))))))));
    }' unless defined(&IP6_GT);
    eval 'sub IP6_LT {
        my($a,$b) = @_;
	    eval q(( &ntohl( &HI60($a)) <  &ntohl( &HI60($b)) || ( &HI60($a) ==  &HI60($b)  && ( &ntohl( &HI61($a)) <  &ntohl( &HI61($b)) || ( &HI61($a) ==  &HI61($b)  && ( &ntohl( &HI62($a)) <  &ntohl( &HI62($b)) || ( &HI62($a) ==  &HI62($b)  &&  &ntohl( &HI63($a)) <  &ntohl( &HI63($b)))))))));
    }' unless defined(&IP6_LT);
    eval 'sub NLADD {
        my($n,$x) = @_;
	    eval q( &htonl( &ntohl($n) + ($x)));
    }' unless defined(&NLADD);
    eval 'sub IP6_INC {
        my($a) = @_;
	    eval q( &do {  &u_32_t * &_i6 = ( &u_32_t *)($a);  $_i6[3] =  &NLADD( $_i6[3], 1);  &if ( $_i6[3] == 0) {  $_i6[2] =  &NLADD( $_i6[2], 1);  &if ( $_i6[2] == 0) {  $_i6[1] =  &NLADD( $_i6[1], 1);  &if ( $_i6[1] == 0) {  $_i6[0] =  &NLADD( $_i6[0], 1); } } } }  &while (0));
    }' unless defined(&IP6_INC);
    eval 'sub IP6_ADD {
        my($a,$x,$d) = @_;
	    eval q( &do {  &i6addr_t * &_s = ( &i6addr_t *)($a);  &i6addr_t * &_d = ( &i6addr_t *)($d);  ($_$d->{i6[0]}) =  &NLADD( ($_s->{i6[0]}), $x);  &if ( &ntohl( ($_$d->{i6[0]})) <  &ntohl( ($_s->{i6[0]}))) {  ($_$d->{i6[1]}) =  &NLADD( ($_$d->{i6[1]}), 1);  &if ( &ntohl( ($_$d->{i6[1]})) <  &ntohl( ($_s->{i6[1]}))) {  ($_$d->{i6[2]}) =  &NLADD( ($_$d->{i6[2]}), 1);  &if ( &ntohl( ($_$d->{i6[2]})) <  &ntohl( ($_s->{i6[2]}))) {  ($_$d->{i6[3]}) =  &NLADD( ($_$d->{i6[3]}), 1); } } } }  &while (0));
    }' unless defined(&IP6_ADD);
    eval 'sub IP6_AND {
        my($a,$b,$d) = @_;
	    eval q( &do {  &i6addr_t * &_s1 = ( &i6addr_t *)($a);  &i6addr_t * &_s2 = ( &i6addr_t *)($b);  &i6addr_t * &_d = ( &i6addr_t *)($d);  ($_$d->{i6[0]}) =  ($_s1->{i6[0]}) &  ($_s2->{i6[0]});  ($_$d->{i6[1]}) =  ($_s1->{i6[1]}) &  ($_s2->{i6[1]});  ($_$d->{i6[2]}) =  ($_s1->{i6[2]}) &  ($_s2->{i6[2]});  ($_$d->{i6[3]}) =  ($_s1->{i6[3]}) &  ($_s2->{i6[3]}); }  &while (0));
    }' unless defined(&IP6_AND);
    eval 'sub IP6_ANDASSIGN {
        my($a,$m) = @_;
	    eval q( &do {  &i6addr_t * &_d = ( &i6addr_t *)($a);  &i6addr_t * &_m = ( &i6addr_t *)($m);  ($_d->{i6[0]}) &=  ($_$m->{i6[0]});  ($_d->{i6[1]}) &=  ($_$m->{i6[1]});  ($_d->{i6[2]}) &=  ($_$m->{i6[2]});  ($_d->{i6[3]}) &=  ($_$m->{i6[3]}); }  &while (0));
    }' unless defined(&IP6_ANDASSIGN);
    eval 'sub IP6_MASKEQ {
        my($a,$m,$b) = @_;
	    eval q(((( &I60($a) &  &I60($m)) ==  &I60($b))  && (( &I61($a) &  &I61($m)) ==  &I61($b))  && (( &I62($a) &  &I62($m)) ==  &I62($b))  && (( &I63($a) &  &I63($m)) ==  &I63($b))));
    }' unless defined(&IP6_MASKEQ);
    eval 'sub IP6_MASKNEQ {
        my($a,$m,$b) = @_;
	    eval q(((( &I60($a) &  &I60($m)) !=  &I60($b)) || (( &I61($a) &  &I61($m)) !=  &I61($b)) || (( &I62($a) &  &I62($m)) !=  &I62($b)) || (( &I63($a) &  &I63($m)) !=  &I63($b))));
    }' unless defined(&IP6_MASKNEQ);
    eval 'sub IP6_MERGE {
        my($a,$b,$c) = @_;
	    eval q( &do {  &i6addr_t * &_d, * &_s1, * &_s2;  &_d = ( &i6addr_t *)($a);  &_s1 = ( &i6addr_t *)($b);  &_s2 = ( &i6addr_t *)($c);  ($_d->{i6[0]}) |=  ($_s1->{i6[0]}) & ~ ($_s2->{i6[0]});  ($_d->{i6[1]}) |=  ($_s1->{i6[1]}) & ~ ($_s2->{i6[1]});  ($_d->{i6[2]}) |=  ($_s1->{i6[2]}) & ~ ($_s2->{i6[2]});  ($_d->{i6[3]}) |=  ($_s1->{i6[3]}) & ~ ($_s2->{i6[3]}); }  &while (0));
    }' unless defined(&IP6_MERGE);
    eval 'sub IP6_MASK {
        my($a,$b,$c) = @_;
	    eval q( &do {  &i6addr_t * &_d, * &_s1, * &_s2;  &_d = ( &i6addr_t *)($a);  &_s1 = ( &i6addr_t *)($b);  &_s2 = ( &i6addr_t *)($c);  ($_d->{i6[0]}) =  ($_s1->{i6[0]}) & ~ ($_s2->{i6[0]});  ($_d->{i6[1]}) =  ($_s1->{i6[1]}) & ~ ($_s2->{i6[1]});  ($_d->{i6[2]}) =  ($_s1->{i6[2]}) & ~ ($_s2->{i6[2]});  ($_d->{i6[3]}) =  ($_s1->{i6[3]}) & ~ ($_s2->{i6[3]}); }  &while (0));
    }' unless defined(&IP6_MASK);
    eval 'sub IP6_SETONES {
        my($a) = @_;
	    eval q( &do {  &i6addr_t * &_d = ( &i6addr_t *)($a);  ($_d->{i6[0]}) = 0xffffffff;  ($_d->{i6[1]}) = 0xffffffff;  ($_d->{i6[2]}) = 0xffffffff;  ($_d->{i6[3]}) = 0xffffffff; }  &while (0));
    }' unless defined(&IP6_SETONES);
    eval 'sub FI_TCPUDP () {0x1;}' unless defined(&FI_TCPUDP);
    eval 'sub FI_OPTIONS () {0x2;}' unless defined(&FI_OPTIONS);
    eval 'sub FI_FRAG () {0x4;}' unless defined(&FI_FRAG);
    eval 'sub FI_SHORT () {0x8;}' unless defined(&FI_SHORT);
    eval 'sub FI_NATED () {0x10;}' unless defined(&FI_NATED);
    eval 'sub FI_MULTICAST () {0x20;}' unless defined(&FI_MULTICAST);
    eval 'sub FI_BROADCAST () {0x40;}' unless defined(&FI_BROADCAST);
    eval 'sub FI_MBCAST () {0x80;}' unless defined(&FI_MBCAST);
    eval 'sub FI_STATE () {0x100;}' unless defined(&FI_STATE);
    eval 'sub FI_BADNAT () {0x200;}' unless defined(&FI_BADNAT);
    eval 'sub FI_BAD () {0x400;}' unless defined(&FI_BAD);
    eval 'sub FI_OOW () {0x800;}' unless defined(&FI_OOW);
    eval 'sub FI_ICMPERR () {0x1000;}' unless defined(&FI_ICMPERR);
    eval 'sub FI_FRAGBODY () {0x2000;}' unless defined(&FI_FRAGBODY);
    eval 'sub FI_BADSRC () {0x4000;}' unless defined(&FI_BADSRC);
    eval 'sub FI_LOWTTL () {0x8000;}' unless defined(&FI_LOWTTL);
    eval 'sub FI_CMP () {0x5cfe3;}' unless defined(&FI_CMP);
    eval 'sub FI_ICMPCMP () {0x3;}' unless defined(&FI_ICMPCMP);
    eval 'sub FI_WITH () {0x5effe;}' unless defined(&FI_WITH);
    eval 'sub FI_V6EXTHDR () {0x10000;}' unless defined(&FI_V6EXTHDR);
    eval 'sub FI_COALESCE () {0x20000;}' unless defined(&FI_COALESCE);
    eval 'sub FI_NEWNAT () {0x40000;}' unless defined(&FI_NEWNAT);
    eval 'sub FI_ICMPQUERY () {0x80000;}' unless defined(&FI_ICMPQUERY);
    eval 'sub FI_ENCAP () {0x100000;}' unless defined(&FI_ENCAP);
    eval 'sub FI_AH () {0x200000;}' unless defined(&FI_AH);
    eval 'sub FI_DOCKSUM () {0x10000000;}' unless defined(&FI_DOCKSUM);
    eval 'sub FI_NOCKSUM () {0x20000000;}' unless defined(&FI_NOCKSUM);
    eval 'sub FI_NOWILD () {0x40000000;}' unless defined(&FI_NOWILD);
    eval 'sub FI_IGNORE () {0x80000000;}' unless defined(&FI_IGNORE);
    eval 'sub fi_secmsk () { ($fi_ipso->{ipso_ripso[0]});}' unless defined(&fi_secmsk);
    eval 'sub fi_auth () { ($fi_ipso->{ipso_ripso[1]});}' unless defined(&fi_auth);
    eval 'sub fi_doi () { ($fi_ipso->{ipso_doi});}' unless defined(&fi_doi);
    eval 'sub fi_saddr () { ($fi_src->{in4}->{s_addr});}' unless defined(&fi_saddr);
    eval 'sub fi_daddr () { ($fi_dst->{in4}->{s_addr});}' unless defined(&fi_daddr);
    eval 'sub fi_srcnum () { ($fi_src->{iplookupnum});}' unless defined(&fi_srcnum);
    eval 'sub fi_dstnum () { ($fi_dst->{iplookupnum});}' unless defined(&fi_dstnum);
    eval 'sub fi_srcname () { ($fi_src->{iplookupname});}' unless defined(&fi_srcname);
    eval 'sub fi_dstname () { ($fi_dst->{iplookupname});}' unless defined(&fi_dstname);
    eval 'sub fi_srctype () { ($fi_src->{iplookuptype});}' unless defined(&fi_srctype);
    eval 'sub fi_dsttype () { ($fi_dst->{iplookuptype});}' unless defined(&fi_dsttype);
    eval 'sub fi_srcsubtype () { ($fi_src->{iplookupsubtype});}' unless defined(&fi_srcsubtype);
    eval 'sub fi_dstsubtype () { ($fi_dst->{iplookupsubtype});}' unless defined(&fi_dstsubtype);
    eval 'sub fi_srcptr () { ($fi_src->{iplookupptr});}' unless defined(&fi_srcptr);
    eval 'sub fi_dstptr () { ($fi_dst->{iplookupptr});}' unless defined(&fi_dstptr);
    eval 'sub fi_srcfunc () { ($fi_src->{iplookupfunc});}' unless defined(&fi_srcfunc);
    eval 'sub fi_dstfunc () { ($fi_dst->{iplookupfunc});}' unless defined(&fi_dstfunc);
    eval 'sub SI_W_SPORT () {0x100;}' unless defined(&SI_W_SPORT);
    eval 'sub SI_W_DPORT () {0x200;}' unless defined(&SI_W_DPORT);
    eval 'sub SI_WILDP () {( &SI_W_SPORT| &SI_W_DPORT);}' unless defined(&SI_WILDP);
    eval 'sub SI_W_SADDR () {0x400;}' unless defined(&SI_W_SADDR);
    eval 'sub SI_W_DADDR () {0x800;}' unless defined(&SI_W_DADDR);
    eval 'sub SI_WILDA () {( &SI_W_SADDR| &SI_W_DADDR);}' unless defined(&SI_WILDA);
    eval 'sub SI_NEWFR () {0x1000;}' unless defined(&SI_NEWFR);
    eval 'sub SI_CLONE () {0x2000;}' unless defined(&SI_CLONE);
    eval 'sub SI_CLONED () {0x4000;}' unless defined(&SI_CLONED);
    eval 'sub SI_NEWCLONE () {0x8000;}' unless defined(&SI_NEWCLONE);
    eval("sub FRB_BLOCKED () { 0; }") unless defined(&FRB_BLOCKED);
    eval("sub FRB_LOGFAIL () { 1; }") unless defined(&FRB_LOGFAIL);
    eval("sub FRB_PPSRATE () { 2; }") unless defined(&FRB_PPSRATE);
    eval("sub FRB_JUMBO () { 3; }") unless defined(&FRB_JUMBO);
    eval("sub FRB_MAKEFRIP () { 4; }") unless defined(&FRB_MAKEFRIP);
    eval("sub FRB_STATEADD () { 5; }") unless defined(&FRB_STATEADD);
    eval("sub FRB_UPDATEIPID () { 6; }") unless defined(&FRB_UPDATEIPID);
    eval("sub FRB_LOGFAIL2 () { 7; }") unless defined(&FRB_LOGFAIL2);
    eval("sub FRB_DECAPFRIP () { 8; }") unless defined(&FRB_DECAPFRIP);
    eval("sub FRB_AUTHNEW () { 9; }") unless defined(&FRB_AUTHNEW);
    eval("sub FRB_AUTHCAPTURE () { 10; }") unless defined(&FRB_AUTHCAPTURE);
    eval("sub FRB_COALESCE () { 11; }") unless defined(&FRB_COALESCE);
    eval("sub FRB_PULLUP () { 12; }") unless defined(&FRB_PULLUP);
    eval("sub FRB_AUTHFEEDBACK () { 13; }") unless defined(&FRB_AUTHFEEDBACK);
    eval("sub FRB_BADFRAG () { 14; }") unless defined(&FRB_BADFRAG);
    eval("sub FRB_NATV4 () { 15; }") unless defined(&FRB_NATV4);
    eval("sub FRB_NATV6 () { 16; }") unless defined(&FRB_NATV6);
    eval 'sub FRB_MAX_VALUE () {16;}' unless defined(&FRB_MAX_VALUE);
    eval("sub FI_CK_BAD () { -1; }") unless defined(&FI_CK_BAD);
    eval("sub FI_CK_NEEDED () { 0; }") unless defined(&FI_CK_NEEDED);
    eval("sub FI_CK_SUMOK () { 1; }") unless defined(&FI_CK_SUMOK);
    eval("sub FI_CK_L4PART () { 2; }") unless defined(&FI_CK_L4PART);
    eval("sub FI_CK_L4FULL () { 4; }") unless defined(&FI_CK_L4FULL);
    if(defined(&USE_INET6)) {
    }
    if(defined(&MENTAT)) {
    }
    if(defined(&__sgi)) {
    }
    eval 'sub fin_ip () { ($fin_ipu->{fip_ip});}' unless defined(&fin_ip);
    eval 'sub fin_ip6 () { ($fin_ipu->{fip_ip6});}' unless defined(&fin_ip6);
    eval 'sub fin_v () { ($fin_fi->{fi_v});}' unless defined(&fin_v);
    eval 'sub fin_p () { ($fin_fi->{fi_p});}' unless defined(&fin_p);
    eval 'sub fin_flx () { ($fin_fi->{fi_flx});}' unless defined(&fin_flx);
    eval 'sub fin_optmsk () { ($fin_fi->{fi_optmsk});}' unless defined(&fin_optmsk);
    eval 'sub fin_secmsk () { ($fin_fi->{fi_secmsk});}' unless defined(&fin_secmsk);
    eval 'sub fin_doi () { ($fin_fi->{fi_doi});}' unless defined(&fin_doi);
    eval 'sub fin_auth () { ($fin_fi->{fi_auth});}' unless defined(&fin_auth);
    eval 'sub fin_src () { ($fin_fi->{fi_src}->{in4});}' unless defined(&fin_src);
    eval 'sub fin_saddr () { ($fin_fi->{fi_saddr});}' unless defined(&fin_saddr);
    eval 'sub fin_dst () { ($fin_fi->{fi_dst}->{in4});}' unless defined(&fin_dst);
    eval 'sub fin_daddr () { ($fin_fi->{fi_daddr});}' unless defined(&fin_daddr);
    eval 'sub fin_data () { ($fin_fi->{fi_ports});}' unless defined(&fin_data);
    eval 'sub fin_sport () { ($fin_fi->{fi_ports[0]});}' unless defined(&fin_sport);
    eval 'sub fin_dport () { ($fin_fi->{fi_ports[1]});}' unless defined(&fin_dport);
    eval 'sub fin_tcpf () { ($fin_fi->{fi_tcpf});}' unless defined(&fin_tcpf);
    eval 'sub fin_src6 () { ($fin_fi->{fi_src});}' unless defined(&fin_src6);
    eval 'sub fin_dst6 () { ($fin_fi->{fi_dst});}' unless defined(&fin_dst6);
    eval 'sub fin_srcip6 () { ($fin_fi->{fi_src}->{in6});}' unless defined(&fin_srcip6);
    eval 'sub fin_dstip6 () { ($fin_fi->{fi_dst}->{in6});}' unless defined(&fin_dstip6);
    eval 'sub IPF_IN () {0;}' unless defined(&IPF_IN);
    eval 'sub IPF_OUT () {1;}' unless defined(&IPF_OUT);
    eval 'sub FI_CSIZE () { &offsetof( &fr_info_t,  &fin_icode);}' unless defined(&FI_CSIZE);
    eval 'sub FI_LCSIZE () { &offsetof( &fr_info_t,  &fin_dp);}' unless defined(&FI_LCSIZE);
    eval 'sub FI_COPYSIZE () { &offsetof( &fr_info_t,  &fin_dp);}' unless defined(&FI_COPYSIZE);
    eval 'sub IPFTAG_LEN () {16;}' unless defined(&IPFTAG_LEN);
    eval 'sub ipt_tag () { ($ipt_un->{iptu_tag});}' unless defined(&ipt_tag);
    eval 'sub ipt_num () { ($ipt_un->{iptu_num});}' unless defined(&ipt_num);
    eval("sub FRD_NORMAL () { 0; }") unless defined(&FRD_NORMAL);
    eval("sub FRD_DSTLIST () { 1; }") unless defined(&FRD_DSTLIST);
    eval 'sub fd_ip6 () { ($fd_addr->{adf_addr});}' unless defined(&fd_ip6);
    eval 'sub fd_ip () { ($fd_ip6->{in4});}' unless defined(&fd_ip);
    eval("sub FR_NONE () { 0; }") unless defined(&FR_NONE);
    eval("sub FR_EQUAL () { 1; }") unless defined(&FR_EQUAL);
    eval("sub FR_NEQUAL () { 2; }") unless defined(&FR_NEQUAL);
    eval("sub FR_LESST () { 3; }") unless defined(&FR_LESST);
    eval("sub FR_GREATERT () { 4; }") unless defined(&FR_GREATERT);
    eval("sub FR_LESSTE () { 5; }") unless defined(&FR_LESSTE);
    eval("sub FR_GREATERTE () { 6; }") unless defined(&FR_GREATERTE);
    eval("sub FR_OUTRANGE () { 7; }") unless defined(&FR_OUTRANGE);
    eval("sub FR_INRANGE () { 8; }") unless defined(&FR_INRANGE);
    eval("sub FR_INCRANGE () { 9; }") unless defined(&FR_INCRANGE);
    eval 'sub ftu_scmp () { ($ftu_src->{frp_cmp});}' unless defined(&ftu_scmp);
    eval 'sub ftu_dcmp () { ($ftu_dst->{frp_cmp});}' unless defined(&ftu_dcmp);
    eval 'sub ftu_sport () { ($ftu_src->{frp_port});}' unless defined(&ftu_sport);
    eval 'sub ftu_dport () { ($ftu_dst->{frp_port});}' unless defined(&ftu_dport);
    eval 'sub ftu_stop () { ($ftu_src->{frp_top});}' unless defined(&ftu_stop);
    eval 'sub ftu_dtop () { ($ftu_dst->{frp_top});}' unless defined(&ftu_dtop);
    eval 'sub FR_TCPFMAX () {0x3f;}' unless defined(&FR_TCPFMAX);
    eval("sub FRI_NONE () { -1; }") unless defined(&FRI_NONE);
    eval("sub FRI_NORMAL () { 0; }") unless defined(&FRI_NORMAL);
    eval("sub FRI_DYNAMIC () { 1; }") unless defined(&FRI_DYNAMIC);
    eval("sub FRI_LOOKUP () { 2; }") unless defined(&FRI_LOOKUP);
    eval("sub FRI_RANGE () { 3; }") unless defined(&FRI_RANGE);
    eval("sub FRI_NETWORK () { 4; }") unless defined(&FRI_NETWORK);
    eval("sub FRI_BROADCAST () { 5; }") unless defined(&FRI_BROADCAST);
    eval("sub FRI_PEERADDR () { 6; }") unless defined(&FRI_PEERADDR);
    eval("sub FRI_NETMASKED () { 7; }") unless defined(&FRI_NETMASKED);
    eval("sub FRI_SPLIT () { 8; }") unless defined(&FRI_SPLIT);
    eval("sub FRI_INTERFACE () { 9; }") unless defined(&FRI_INTERFACE);
    eval 'sub fri_dlookup () { ($fri_mip->{fi_dst});}' unless defined(&fri_dlookup);
    eval 'sub fri_slookup () { ($fri_mip->{fi_src});}' unless defined(&fri_slookup);
    eval 'sub fri_dstnum () { ($fri_mip->{fi_dstnum});}' unless defined(&fri_dstnum);
    eval 'sub fri_srcnum () { ($fri_mip->{fi_srcnum});}' unless defined(&fri_srcnum);
    eval 'sub fri_dstname () { ($fri_mip->{fi_dstname});}' unless defined(&fri_dstname);
    eval 'sub fri_srcname () { ($fri_mip->{fi_srcname});}' unless defined(&fri_srcname);
    eval 'sub fri_dstptr () { ($fri_mip->{fi_dstptr});}' unless defined(&fri_dstptr);
    eval 'sub fri_srcptr () { ($fri_mip->{fi_srcptr});}' unless defined(&fri_srcptr);
    eval("sub FR_T_NONE () { 0; }") unless defined(&FR_T_NONE);
    eval("sub FR_T_IPF () { 1; }") unless defined(&FR_T_IPF);
    eval("sub FR_T_BPFOPC () { 2; }") unless defined(&FR_T_BPFOPC);
    eval("sub FR_T_CALLFUNC () { 3; }") unless defined(&FR_T_CALLFUNC);
    eval("sub FR_T_COMPIPF () { 4; }") unless defined(&FR_T_COMPIPF);
    eval("sub FR_T_IPFEXPR () { 5; }") unless defined(&FR_T_IPFEXPR);
    eval("sub FR_T_BUILTIN () { 0x40000000; }") unless defined(&FR_T_BUILTIN);
    eval("sub FR_T_IPF_BUILTIN () { 1; }") unless defined(&FR_T_IPF_BUILTIN);
    eval("sub FR_T_BPFOPC_BUILTIN () { 2; }") unless defined(&FR_T_BPFOPC_BUILTIN);
    eval("sub FR_T_CALLFUNC_BUILTIN () { 3; }") unless defined(&FR_T_CALLFUNC_BUILTIN);
    eval("sub FR_T_COMPIPF_BUILTIN () { 4; }") unless defined(&FR_T_COMPIPF_BUILTIN);
    eval("sub FR_T_IPFEXPR_BUILTIN () { 5; }") unless defined(&FR_T_IPFEXPR_BUILTIN);
    eval 'sub fr_lastpkt () { ($fr_lpu->{frp_lastpkt});}' unless defined(&fr_lastpkt);
    eval 'sub fr_caddr () { ($fr_dun->{fru_caddr});}' unless defined(&fr_caddr);
    eval 'sub fr_data () { ($fr_dun->{fru_data});}' unless defined(&fr_data);
    eval 'sub fr_dfunc () { ($fr_dun->{fru_func});}' unless defined(&fr_dfunc);
    eval 'sub fr_ipf () { ($fr_dun->{fru_ipf});}' unless defined(&fr_ipf);
    eval 'sub fr_ip () { ($fr_ipf->{fri_ip});}' unless defined(&fr_ip);
    eval 'sub fr_mip () { ($fr_ipf->{fri_mip});}' unless defined(&fr_mip);
    eval 'sub fr_icmpm () { ($fr_ipf->{fri_icmpm});}' unless defined(&fr_icmpm);
    eval 'sub fr_icmp () { ($fr_ipf->{fri_icmp});}' unless defined(&fr_icmp);
    eval 'sub fr_tuc () { ($fr_ipf->{fri_tuc});}' unless defined(&fr_tuc);
    eval 'sub fr_satype () { ($fr_ipf->{fri_satype});}' unless defined(&fr_satype);
    eval 'sub fr_datype () { ($fr_ipf->{fri_datype});}' unless defined(&fr_datype);
    eval 'sub fr_sifpidx () { ($fr_ipf->{fri_sifpidx});}' unless defined(&fr_sifpidx);
    eval 'sub fr_difpidx () { ($fr_ipf->{fri_difpidx});}' unless defined(&fr_difpidx);
    eval 'sub fr_proto () { ($fr_ip->{fi_p});}' unless defined(&fr_proto);
    eval 'sub fr_mproto () { ($fr_mip->{fi_p});}' unless defined(&fr_mproto);
    eval 'sub fr_ttl () { ($fr_ip->{fi_ttl});}' unless defined(&fr_ttl);
    eval 'sub fr_mttl () { ($fr_mip->{fi_ttl});}' unless defined(&fr_mttl);
    eval 'sub fr_tos () { ($fr_ip->{fi_tos});}' unless defined(&fr_tos);
    eval 'sub fr_mtos () { ($fr_mip->{fi_tos});}' unless defined(&fr_mtos);
    eval 'sub fr_tcpfm () { ($fr_tuc->{ftu_tcpfm});}' unless defined(&fr_tcpfm);
    eval 'sub fr_tcpf () { ($fr_tuc->{ftu_tcpf});}' unless defined(&fr_tcpf);
    eval 'sub fr_scmp () { ($fr_tuc->{ftu_scmp});}' unless defined(&fr_scmp);
    eval 'sub fr_dcmp () { ($fr_tuc->{ftu_dcmp});}' unless defined(&fr_dcmp);
    eval 'sub fr_dport () { ($fr_tuc->{ftu_dport});}' unless defined(&fr_dport);
    eval 'sub fr_sport () { ($fr_tuc->{ftu_sport});}' unless defined(&fr_sport);
    eval 'sub fr_stop () { ($fr_tuc->{ftu_stop});}' unless defined(&fr_stop);
    eval 'sub fr_dtop () { ($fr_tuc->{ftu_dtop});}' unless defined(&fr_dtop);
    eval 'sub fr_dst () { ($fr_ip->{fi_dst}->{in4});}' unless defined(&fr_dst);
    eval 'sub fr_dst6 () { ($fr_ip->{fi_dst});}' unless defined(&fr_dst6);
    eval 'sub fr_daddr () { ($fr_ip->{fi_dst}->{in4}->{s_addr});}' unless defined(&fr_daddr);
    eval 'sub fr_src () { ($fr_ip->{fi_src}->{in4});}' unless defined(&fr_src);
    eval 'sub fr_src6 () { ($fr_ip->{fi_src});}' unless defined(&fr_src6);
    eval 'sub fr_saddr () { ($fr_ip->{fi_src}->{in4}->{s_addr});}' unless defined(&fr_saddr);
    eval 'sub fr_dmsk () { ($fr_mip->{fi_dst}->{in4});}' unless defined(&fr_dmsk);
    eval 'sub fr_dmsk6 () { ($fr_mip->{fi_dst});}' unless defined(&fr_dmsk6);
    eval 'sub fr_dmask () { ($fr_mip->{fi_dst}->{in4}->{s_addr});}' unless defined(&fr_dmask);
    eval 'sub fr_smsk () { ($fr_mip->{fi_src}->{in4});}' unless defined(&fr_smsk);
    eval 'sub fr_smsk6 () { ($fr_mip->{fi_src});}' unless defined(&fr_smsk6);
    eval 'sub fr_smask () { ($fr_mip->{fi_src}->{in4}->{s_addr});}' unless defined(&fr_smask);
    eval 'sub fr_dstnum () { ($fr_ip->{fi_dstnum});}' unless defined(&fr_dstnum);
    eval 'sub fr_srcnum () { ($fr_ip->{fi_srcnum});}' unless defined(&fr_srcnum);
    eval 'sub fr_dlookup () { ($fr_ip->{fi_dst});}' unless defined(&fr_dlookup);
    eval 'sub fr_slookup () { ($fr_ip->{fi_src});}' unless defined(&fr_slookup);
    eval 'sub fr_dstname () { ($fr_ip->{fi_dstname});}' unless defined(&fr_dstname);
    eval 'sub fr_srcname () { ($fr_ip->{fi_srcname});}' unless defined(&fr_srcname);
    eval 'sub fr_dsttype () { ($fr_ip->{fi_dsttype});}' unless defined(&fr_dsttype);
    eval 'sub fr_srctype () { ($fr_ip->{fi_srctype});}' unless defined(&fr_srctype);
    eval 'sub fr_dstsubtype () { ($fr_ip->{fi_dstsubtype});}' unless defined(&fr_dstsubtype);
    eval 'sub fr_srcsubtype () { ($fr_ip->{fi_srcsubtype});}' unless defined(&fr_srcsubtype);
    eval 'sub fr_dstptr () { ($fr_mip->{fi_dstptr});}' unless defined(&fr_dstptr);
    eval 'sub fr_srcptr () { ($fr_mip->{fi_srcptr});}' unless defined(&fr_srcptr);
    eval 'sub fr_dstfunc () { ($fr_mip->{fi_dstfunc});}' unless defined(&fr_dstfunc);
    eval 'sub fr_srcfunc () { ($fr_mip->{fi_srcfunc});}' unless defined(&fr_srcfunc);
    eval 'sub fr_optbits () { ($fr_ip->{fi_optmsk});}' unless defined(&fr_optbits);
    eval 'sub fr_optmask () { ($fr_mip->{fi_optmsk});}' unless defined(&fr_optmask);
    eval 'sub fr_secbits () { ($fr_ip->{fi_secmsk});}' unless defined(&fr_secbits);
    eval 'sub fr_secmask () { ($fr_mip->{fi_secmsk});}' unless defined(&fr_secmask);
    eval 'sub fr_authbits () { ($fr_ip->{fi_auth});}' unless defined(&fr_authbits);
    eval 'sub fr_authmask () { ($fr_mip->{fi_auth});}' unless defined(&fr_authmask);
    eval 'sub fr_doi () { ($fr_ip->{fi_doi});}' unless defined(&fr_doi);
    eval 'sub fr_doimask () { ($fr_mip->{fi_doi});}' unless defined(&fr_doimask);
    eval 'sub fr_flx () { ($fr_ip->{fi_flx});}' unless defined(&fr_flx);
    eval 'sub fr_mflx () { ($fr_mip->{fi_flx});}' unless defined(&fr_mflx);
    eval 'sub fr_ifa () { $fr_ifas[0];}' unless defined(&fr_ifa);
    eval 'sub fr_oifa () { $fr_ifas[2];}' unless defined(&fr_oifa);
    eval 'sub fr_tif () { $fr_tifs[0];}' unless defined(&fr_tif);
    eval 'sub fr_rif () { $fr_tifs[1];}' unless defined(&fr_rif);
    eval 'sub FR_NOLOGTAG () {0;}' unless defined(&FR_NOLOGTAG);
    eval 'sub FR_CMPSIZ () {($sizeof{\'struct frentry\'} -  &offsetof(\'struct frentry\',  &fr_func));}' unless defined(&FR_CMPSIZ);
    eval 'sub FR_NAME {
        my($_f, $_n) = @_;
	    eval q(($_f)-> &fr_names + ($_f)->$_n);
    }' unless defined(&FR_NAME);
    eval 'sub FR_BLOCK () {0x1;}' unless defined(&FR_BLOCK);
    eval 'sub FR_PASS () {0x2;}' unless defined(&FR_PASS);
    eval 'sub FR_AUTH () {0x3;}' unless defined(&FR_AUTH);
    eval 'sub FR_PREAUTH () {0x4;}' unless defined(&FR_PREAUTH);
    eval 'sub FR_ACCOUNT () {0x5;}' unless defined(&FR_ACCOUNT);
    eval 'sub FR_SKIP () {0x6;}' unless defined(&FR_SKIP);
    eval 'sub FR_DECAPSULATE () {0x8;}' unless defined(&FR_DECAPSULATE);
    eval 'sub FR_CALL () {0x9;}' unless defined(&FR_CALL);
    eval 'sub FR_CMDMASK () {0xf;}' unless defined(&FR_CMDMASK);
    eval 'sub FR_LOG () {0x10;}' unless defined(&FR_LOG);
    eval 'sub FR_LOGB () {0x11;}' unless defined(&FR_LOGB);
    eval 'sub FR_LOGP () {0x12;}' unless defined(&FR_LOGP);
    eval 'sub FR_LOGMASK () {( &FR_LOG| &FR_CMDMASK);}' unless defined(&FR_LOGMASK);
    eval 'sub FR_CALLNOW () {0x20;}' unless defined(&FR_CALLNOW);
    eval 'sub FR_NOTSRCIP () {0x40;}' unless defined(&FR_NOTSRCIP);
    eval 'sub FR_NOTDSTIP () {0x80;}' unless defined(&FR_NOTDSTIP);
    eval 'sub FR_QUICK () {0x100;}' unless defined(&FR_QUICK);
    eval 'sub FR_KEEPFRAG () {0x200;}' unless defined(&FR_KEEPFRAG);
    eval 'sub FR_KEEPSTATE () {0x400;}' unless defined(&FR_KEEPSTATE);
    eval 'sub FR_FASTROUTE () {0x800;}' unless defined(&FR_FASTROUTE);
    eval 'sub FR_RETRST () {0x1000;}' unless defined(&FR_RETRST);
    eval 'sub FR_RETICMP () {0x2000;}' unless defined(&FR_RETICMP);
    eval 'sub FR_FAKEICMP () {0x3000;}' unless defined(&FR_FAKEICMP);
    eval 'sub FR_OUTQUE () {0x4000;}' unless defined(&FR_OUTQUE);
    eval 'sub FR_INQUE () {0x8000;}' unless defined(&FR_INQUE);
    eval 'sub FR_LOGBODY () {0x10000;}' unless defined(&FR_LOGBODY);
    eval 'sub FR_LOGFIRST () {0x20000;}' unless defined(&FR_LOGFIRST);
    eval 'sub FR_LOGORBLOCK () {0x40000;}' unless defined(&FR_LOGORBLOCK);
    eval 'sub FR_STLOOSE () {0x80000;}' unless defined(&FR_STLOOSE);
    eval 'sub FR_FRSTRICT () {0x100000;}' unless defined(&FR_FRSTRICT);
    eval 'sub FR_STSTRICT () {0x200000;}' unless defined(&FR_STSTRICT);
    eval 'sub FR_NEWISN () {0x400000;}' unless defined(&FR_NEWISN);
    eval 'sub FR_NOICMPERR () {0x800000;}' unless defined(&FR_NOICMPERR);
    eval 'sub FR_STATESYNC () {0x1000000;}' unless defined(&FR_STATESYNC);
    eval 'sub FR_COPIED () {0x2000000;}' unless defined(&FR_COPIED);
    eval 'sub FR_INACTIVE () {0x4000000;}' unless defined(&FR_INACTIVE);
    eval 'sub FR_NOMATCH () {0x8000000;}' unless defined(&FR_NOMATCH);
    eval 'sub FR_RETMASK () {( &FR_RETICMP| &FR_RETRST| &FR_FAKEICMP);}' unless defined(&FR_RETMASK);
    eval 'sub FR_ISBLOCK {
        my($x) = @_;
	    eval q(((($x) &  &FR_CMDMASK) ==  &FR_BLOCK));
    }' unless defined(&FR_ISBLOCK);
    eval 'sub FR_ISPASS {
        my($x) = @_;
	    eval q(((($x) &  &FR_CMDMASK) ==  &FR_PASS));
    }' unless defined(&FR_ISPASS);
    eval 'sub FR_ISAUTH {
        my($x) = @_;
	    eval q(((($x) &  &FR_CMDMASK) ==  &FR_AUTH));
    }' unless defined(&FR_ISAUTH);
    eval 'sub FR_ISPREAUTH {
        my($x) = @_;
	    eval q(((($x) &  &FR_CMDMASK) ==  &FR_PREAUTH));
    }' unless defined(&FR_ISPREAUTH);
    eval 'sub FR_ISACCOUNT {
        my($x) = @_;
	    eval q(((($x) &  &FR_CMDMASK) ==  &FR_ACCOUNT));
    }' unless defined(&FR_ISACCOUNT);
    eval 'sub FR_ISSKIP {
        my($x) = @_;
	    eval q(((($x) &  &FR_CMDMASK) ==  &FR_SKIP));
    }' unless defined(&FR_ISSKIP);
    eval 'sub FR_ISDECAPS {
        my($x) = @_;
	    eval q(((($x) &  &FR_CMDMASK) ==  &FR_DECAPSULATE));
    }' unless defined(&FR_ISDECAPS);
    eval 'sub FR_ISNOMATCH {
        my($x) = @_;
	    eval q((($x) &  &FR_NOMATCH));
    }' unless defined(&FR_ISNOMATCH);
    eval 'sub FR_INOUT () {( &FR_INQUE| &FR_OUTQUE);}' unless defined(&FR_INOUT);
    eval 'sub FF_LOGPASS () {0x10000000;}' unless defined(&FF_LOGPASS);
    eval 'sub FF_LOGBLOCK () {0x20000000;}' unless defined(&FF_LOGBLOCK);
    eval 'sub FF_LOGNOMATCH () {0x40000000;}' unless defined(&FF_LOGNOMATCH);
    eval 'sub FF_LOGGING () {( &FF_LOGPASS| &FF_LOGBLOCK| &FF_LOGNOMATCH);}' unless defined(&FF_LOGGING);
    eval 'sub FF_BLOCKNONIP () {0x80000000;}' unless defined(&FF_BLOCKNONIP);
    eval 'sub ipl_sec () { ($ipl_time->{tv_sec});}' unless defined(&ipl_sec);
    eval 'sub ipl_usec () { ($ipl_time->{tv_usec});}' unless defined(&ipl_usec);
    eval 'sub IPL_MAGIC () {0x49504c4d;}' unless defined(&IPL_MAGIC);
    eval 'sub IPL_MAGIC_NAT () {0x49504c4e;}' unless defined(&IPL_MAGIC_NAT);
    eval 'sub IPL_MAGIC_STATE () {0x49504c53;}' unless defined(&IPL_MAGIC_STATE);
    eval 'sub IPLOG_SIZE () {$sizeof{ &iplog_t};}' unless defined(&IPLOG_SIZE);
    if((defined(&NetBSD)  && ((defined(&NetBSD) ? &NetBSD : undef) <= 1991011)  && ((defined(&NetBSD) ? &NetBSD : undef) >= 199603)) || (defined(&OpenBSD)  && ((defined(&OpenBSD) ? &OpenBSD : undef) >= 199603))) {
    } else {
    }
    unless(defined(&IPF_LOGGING)) {
	eval 'sub IPF_LOGGING () {0;}' unless defined(&IPF_LOGGING);
    }
    unless(defined(&IPF_DEFAULT_PASS)) {
	eval 'sub IPF_DEFAULT_PASS () { &FR_PASS;}' unless defined(&IPF_DEFAULT_PASS);
    }
    eval 'sub DEFAULT_IPFLOGSIZE () {32768;}' unless defined(&DEFAULT_IPFLOGSIZE);
    unless(defined(&IPFILTER_LOGSIZE)) {
	eval 'sub IPFILTER_LOGSIZE () { &DEFAULT_IPFLOGSIZE;}' unless defined(&IPFILTER_LOGSIZE);
    } else {
	if((defined(&IPFILTER_LOGSIZE) ? &IPFILTER_LOGSIZE : undef) < 8192) {
	    die("IPFILTER_LOGSIZE\ too\ small\.\ \ Must\ be\ \>\=\ 8192");
	}
    }
    eval 'sub IPF_OPTCOPY () {0x7ff00;}' unless defined(&IPF_OPTCOPY);
    unless(defined(&IPL_NAME)) {
	if((defined(&SOLARIS) ? &SOLARIS : undef)) {
	    eval 'sub IPL_NAME () {"/dev/ipf";}' unless defined(&IPL_NAME);
	} else {
	    eval 'sub IPL_NAME () {"/dev/ipl";}' unless defined(&IPL_NAME);
	}
    }
    eval 'sub IPNAT_NAME () {"/dev/ipnat";}' unless defined(&IPNAT_NAME);
    eval 'sub IPSTATE_NAME () {"/dev/ipstate";}' unless defined(&IPSTATE_NAME);
    eval 'sub IPAUTH_NAME () {"/dev/ipauth";}' unless defined(&IPAUTH_NAME);
    eval 'sub IPSYNC_NAME () {"/dev/ipsync";}' unless defined(&IPSYNC_NAME);
    eval 'sub IPSCAN_NAME () {"/dev/ipscan";}' unless defined(&IPSCAN_NAME);
    eval 'sub IPLOOKUP_NAME () {"/dev/iplookup";}' unless defined(&IPLOOKUP_NAME);
    eval 'sub IPL_LOGIPF () {0;}' unless defined(&IPL_LOGIPF);
    eval 'sub IPL_LOGNAT () {1;}' unless defined(&IPL_LOGNAT);
    eval 'sub IPL_LOGSTATE () {2;}' unless defined(&IPL_LOGSTATE);
    eval 'sub IPL_LOGAUTH () {3;}' unless defined(&IPL_LOGAUTH);
    eval 'sub IPL_LOGSYNC () {4;}' unless defined(&IPL_LOGSYNC);
    eval 'sub IPL_LOGSCAN () {5;}' unless defined(&IPL_LOGSCAN);
    eval 'sub IPL_LOGLOOKUP () {6;}' unless defined(&IPL_LOGLOOKUP);
    eval 'sub IPL_LOGCOUNT () {7;}' unless defined(&IPL_LOGCOUNT);
    eval 'sub IPL_LOGMAX () {7;}' unless defined(&IPL_LOGMAX);
    eval 'sub IPL_LOGSIZE () { &IPL_LOGMAX + 1;}' unless defined(&IPL_LOGSIZE);
    eval 'sub IPL_LOGALL () {-1;}' unless defined(&IPL_LOGALL);
    eval 'sub IPL_LOGNONE () {-2;}' unless defined(&IPL_LOGNONE);
    eval 'sub f_fin () { $f_ipf[0];}' unless defined(&f_fin);
    eval 'sub f_fout () { $f_ipf[1];}' unless defined(&f_fout);
    eval 'sub f_acctin () { $f_acct[0];}' unless defined(&f_acctin);
    eval 'sub f_acctout () { $f_acct[1];}' unless defined(&f_acctout);
    eval 'sub IPF_FEAT_LKM () {0x1;}' unless defined(&IPF_FEAT_LKM);
    eval 'sub IPF_FEAT_LOG () {0x2;}' unless defined(&IPF_FEAT_LOG);
    eval 'sub IPF_FEAT_LOOKUP () {0x4;}' unless defined(&IPF_FEAT_LOOKUP);
    eval 'sub IPF_FEAT_BPF () {0x8;}' unless defined(&IPF_FEAT_BPF);
    eval 'sub IPF_FEAT_COMPILED () {0x10;}' unless defined(&IPF_FEAT_COMPILED);
    eval 'sub IPF_FEAT_CKSUM () {0x20;}' unless defined(&IPF_FEAT_CKSUM);
    eval 'sub IPF_FEAT_SYNC () {0x40;}' unless defined(&IPF_FEAT_SYNC);
    eval 'sub IPF_FEAT_SCAN () {0x80;}' unless defined(&IPF_FEAT_SCAN);
    eval 'sub IPF_FEAT_IPV6 () {0x100;}' unless defined(&IPF_FEAT_IPV6);
    eval 'sub FG_NAME {
        my($g) = @_;
	    eval q((*($g)-> &fg_name == ord(\'\\\\0\') ? \\"\\" : ($g)-> &fg_name));
    }' unless defined(&FG_NAME);
    eval 'sub TCP_WSCALE_MAX () {14;}' unless defined(&TCP_WSCALE_MAX);
    eval 'sub TCP_WSCALE_SEEN () {0x1;}' unless defined(&TCP_WSCALE_SEEN);
    eval 'sub TCP_WSCALE_FIRST () {0x2;}' unless defined(&TCP_WSCALE_FIRST);
    eval 'sub TCP_SACK_PERMIT () {0x4;}' unless defined(&TCP_SACK_PERMIT);
    if(defined(&sparc)) {
    } else {
    }
    eval 'sub gr_flags () { ($gr_un->{gru_flags});}' unless defined(&gr_flags);
    eval 'sub gr_bits () { ($gr_un->{gru_bits});}' unless defined(&gr_bits);
    eval 'sub gr_ptype () { ($gr_bits->{grb_ptype});}' unless defined(&gr_ptype);
    eval 'sub gr_C () { ($gr_bits->{grb_C});}' unless defined(&gr_C);
    eval 'sub gr_R () { ($gr_bits->{grb_R});}' unless defined(&gr_R);
    eval 'sub gr_K () { ($gr_bits->{grb_K});}' unless defined(&gr_K);
    eval 'sub gr_S () { ($gr_bits->{grb_S});}' unless defined(&gr_S);
    eval 'sub gr_s () { ($gr_bits->{grb_s});}' unless defined(&gr_s);
    eval 'sub gr_recur () { ($gr_bits->{grb_recur});}' unless defined(&gr_recur);
    eval 'sub gr_A () { ($gr_bits->{grb_A});}' unless defined(&gr_A);
    eval 'sub gr_ver () { ($gr_bits->{grb_ver});}' unless defined(&gr_ver);
    eval 'sub GRE_REV {
        my($x) = @_;
	    eval q((( &ntohs($x) >> 13) & 7));
    }' unless defined(&GRE_REV);
    eval 'sub TQE_RULEBASED () {0x1;}' unless defined(&TQE_RULEBASED);
    eval 'sub TQE_DELETE () {0x2;}' unless defined(&TQE_DELETE);
    eval 'sub IFQF_USER () {0x1;}' unless defined(&IFQF_USER);
    eval 'sub IFQF_DELETE () {0x2;}' unless defined(&IFQF_DELETE);
    eval 'sub IFQF_PROXY () {0x4;}' unless defined(&IFQF_PROXY);
    eval 'sub IPFTQ_INIT {
        my($x,$y,$z) = @_;
	    eval q( &do { ($x)-> &ifq_ttl = ($y); ($x)-> &ifq_head =  &NULL; ($x)-> &ifq_ref = 1; ($x)-> &ifq_tail = ($x)-> &ifq_head;  &MUTEX_INIT(($x)-> &ifq_lock, ($z)); }  &while (0));
    }' unless defined(&IPFTQ_INIT);
    eval 'sub IPF_HZ_MULT () {1;}' unless defined(&IPF_HZ_MULT);
    eval 'sub IPF_HZ_DIVIDE () {2;}' unless defined(&IPF_HZ_DIVIDE);
    eval 'sub IPF_TTLVAL {
        my($x) = @_;
	    eval q(((($x) /  &IPF_HZ_MULT) *  &IPF_HZ_DIVIDE));
    }' unless defined(&IPF_TTLVAL);
    eval 'sub IPFOBJ_FRENTRY () {0;}' unless defined(&IPFOBJ_FRENTRY);
    eval 'sub IPFOBJ_IPFSTAT () {1;}' unless defined(&IPFOBJ_IPFSTAT);
    eval 'sub IPFOBJ_IPFINFO () {2;}' unless defined(&IPFOBJ_IPFINFO);
    eval 'sub IPFOBJ_AUTHSTAT () {3;}' unless defined(&IPFOBJ_AUTHSTAT);
    eval 'sub IPFOBJ_FRAGSTAT () {4;}' unless defined(&IPFOBJ_FRAGSTAT);
    eval 'sub IPFOBJ_IPNAT () {5;}' unless defined(&IPFOBJ_IPNAT);
    eval 'sub IPFOBJ_NATSTAT () {6;}' unless defined(&IPFOBJ_NATSTAT);
    eval 'sub IPFOBJ_STATESAVE () {7;}' unless defined(&IPFOBJ_STATESAVE);
    eval 'sub IPFOBJ_NATSAVE () {8;}' unless defined(&IPFOBJ_NATSAVE);
    eval 'sub IPFOBJ_NATLOOKUP () {9;}' unless defined(&IPFOBJ_NATLOOKUP);
    eval 'sub IPFOBJ_IPSTATE () {10;}' unless defined(&IPFOBJ_IPSTATE);
    eval 'sub IPFOBJ_STATESTAT () {11;}' unless defined(&IPFOBJ_STATESTAT);
    eval 'sub IPFOBJ_FRAUTH () {12;}' unless defined(&IPFOBJ_FRAUTH);
    eval 'sub IPFOBJ_TUNEABLE () {13;}' unless defined(&IPFOBJ_TUNEABLE);
    eval 'sub IPFOBJ_NAT () {14;}' unless defined(&IPFOBJ_NAT);
    eval 'sub IPFOBJ_IPFITER () {15;}' unless defined(&IPFOBJ_IPFITER);
    eval 'sub IPFOBJ_GENITER () {16;}' unless defined(&IPFOBJ_GENITER);
    eval 'sub IPFOBJ_GTABLE () {17;}' unless defined(&IPFOBJ_GTABLE);
    eval 'sub IPFOBJ_LOOKUPITER () {18;}' unless defined(&IPFOBJ_LOOKUPITER);
    eval 'sub IPFOBJ_STATETQTAB () {19;}' unless defined(&IPFOBJ_STATETQTAB);
    eval 'sub IPFOBJ_IPFEXPR () {20;}' unless defined(&IPFOBJ_IPFEXPR);
    eval 'sub IPFOBJ_PROXYCTL () {21;}' unless defined(&IPFOBJ_PROXYCTL);
    eval 'sub IPFOBJ_FRIPF () {22;}' unless defined(&IPFOBJ_FRIPF);
    eval 'sub IPFOBJ_COUNT () {23;}' unless defined(&IPFOBJ_COUNT);
    eval 'sub ipft_addr () { ($ipft_una->{ipftp_void});}' unless defined(&ipft_addr);
    eval 'sub ipft_plong () { ($ipft_una->{ipftp_long});}' unless defined(&ipft_plong);
    eval 'sub ipft_pint () { ($ipft_una->{ipftp_int});}' unless defined(&ipft_pint);
    eval 'sub ipft_pshort () { ($ipft_una->{ipftp_short});}' unless defined(&ipft_pshort);
    eval 'sub ipft_pchar () { ($ipft_una->{ipftp_char});}' unless defined(&ipft_pchar);
    eval 'sub IPFT_RDONLY () {1;}' unless defined(&IPFT_RDONLY);
    eval 'sub IPFT_WRDISABLED () {2;}' unless defined(&IPFT_WRDISABLED);
    eval 'sub ipft_vlong () { ($ipft_un->{ipftu_long});}' unless defined(&ipft_vlong);
    eval 'sub ipft_vint () { ($ipft_un->{ipftu_int});}' unless defined(&ipft_vint);
    eval 'sub ipft_vshort () { ($ipft_un->{ipftu_short});}' unless defined(&ipft_vshort);
    eval 'sub ipft_vchar () { ($ipft_un->{ipftu_char});}' unless defined(&ipft_vchar);
    eval 'sub IPFHASH {
        my($x,$y) = @_;
	    eval q( &typedef \'struct struct\' {  &ipfrwlock_t  &ipfh_lock; \'struct x\' * &ipfh_head; } $y);
    }' unless defined(&IPFHASH);
    if(defined(&__hpux)) {
	eval 'sub IPF_SMAJ () {0;}' unless defined(&IPF_SMAJ);
    }
    if(!defined(&CDEV_MAJOR)  && defined (&__FreeBSD_version)  && ((defined(&__FreeBSD_version) ? &__FreeBSD_version : undef) >= 220000)) {
	eval 'sub CDEV_MAJOR () {79;}' unless defined(&CDEV_MAJOR);
    }
    if((defined(&NetBSD)  && ((defined(&NetBSD) ? &NetBSD : undef) > 199609)  && ((defined(&NetBSD) ? &NetBSD : undef) <= 1991011)) || (defined(&NetBSD1_2)  && (defined(&NetBSD1_2) ? &NetBSD1_2 : undef) > 1) || (defined(&__FreeBSD__)  && ((defined(&__FreeBSD_version) ? &__FreeBSD_version : undef) >= 500043))) {
	if(((defined(&NetBSD) ? &NetBSD : undef) >= 199905)  && !defined(&PFIL_HOOKS)) {
	    eval 'sub PFIL_HOOKS () {1;}' unless defined(&PFIL_HOOKS);
	}
	if(defined(&PFIL_HOOKS)) {
	    eval 'sub NETBSD_PF () {1;}' unless defined(&NETBSD_PF);
	}
    }
    if(defined(&_KERNEL)) {
	eval 'sub FR_VERBOSE {
	    my($verb_pr) = @_;
    	    eval q();
	}' unless defined(&FR_VERBOSE);
	eval 'sub FR_DEBUG {
	    my($verb_pr) = @_;
    	    eval q();
	}' unless defined(&FR_DEBUG);
    } else {
	eval 'sub FR_VERBOSE {
	    my($verb_pr) = @_;
    	    eval q( &ipfkverbose $verb_pr);
	}' unless defined(&FR_VERBOSE);
	eval 'sub FR_DEBUG {
	    my($verb_pr) = @_;
    	    eval q( &ipfkdebug $verb_pr);
	}' unless defined(&FR_DEBUG);
    }
    eval 'sub F_IN () {0;}' unless defined(&F_IN);
    eval 'sub F_OUT () {1;}' unless defined(&F_OUT);
    eval 'sub F_ACIN () {2;}' unless defined(&F_ACIN);
    eval 'sub F_ACOUT () {3;}' unless defined(&F_ACOUT);
    eval 'sub IPFGENITER_IPF () {0;}' unless defined(&IPFGENITER_IPF);
    eval 'sub IPFGENITER_NAT () {1;}' unless defined(&IPFGENITER_NAT);
    eval 'sub IPFGENITER_IPNAT () {2;}' unless defined(&IPFGENITER_IPNAT);
    eval 'sub IPFGENITER_FRAG () {3;}' unless defined(&IPFGENITER_FRAG);
    eval 'sub IPFGENITER_AUTH () {4;}' unless defined(&IPFGENITER_AUTH);
    eval 'sub IPFGENITER_STATE () {5;}' unless defined(&IPFGENITER_STATE);
    eval 'sub IPFGENITER_NATFRAG () {6;}' unless defined(&IPFGENITER_NATFRAG);
    eval 'sub IPFGENITER_HOSTMAP () {7;}' unless defined(&IPFGENITER_HOSTMAP);
    eval 'sub IPFGENITER_LOOKUP () {8;}' unless defined(&IPFGENITER_LOOKUP);
    eval 'sub IPFTABLE_BUCKETS () {1;}' unless defined(&IPFTABLE_BUCKETS);
    eval 'sub IPFTABLE_BUCKETS_NATIN () {2;}' unless defined(&IPFTABLE_BUCKETS_NATIN);
    eval 'sub IPFTABLE_BUCKETS_NATOUT () {3;}' unless defined(&IPFTABLE_BUCKETS_NATOUT);
    eval 'sub IPF_EXP_IP_PR () {0x1;}' unless defined(&IPF_EXP_IP_PR);
    eval 'sub IPF_EXP_IP_ADDR () {0x2;}' unless defined(&IPF_EXP_IP_ADDR);
    eval 'sub IPF_EXP_IP_SRCADDR () {0x3;}' unless defined(&IPF_EXP_IP_SRCADDR);
    eval 'sub IPF_EXP_IP_DSTADDR () {0x4;}' unless defined(&IPF_EXP_IP_DSTADDR);
    eval 'sub IPF_EXP_IP6_ADDR () {0x5;}' unless defined(&IPF_EXP_IP6_ADDR);
    eval 'sub IPF_EXP_IP6_SRCADDR () {0x6;}' unless defined(&IPF_EXP_IP6_SRCADDR);
    eval 'sub IPF_EXP_IP6_DSTADDR () {0x7;}' unless defined(&IPF_EXP_IP6_DSTADDR);
    eval 'sub IPF_EXP_TCP_FLAGS () {0x60001;}' unless defined(&IPF_EXP_TCP_FLAGS);
    eval 'sub IPF_EXP_TCP_PORT () {0x60002;}' unless defined(&IPF_EXP_TCP_PORT);
    eval 'sub IPF_EXP_TCP_SPORT () {0x60003;}' unless defined(&IPF_EXP_TCP_SPORT);
    eval 'sub IPF_EXP_TCP_DPORT () {0x60004;}' unless defined(&IPF_EXP_TCP_DPORT);
    eval 'sub IPF_EXP_UDP_PORT () {0x110002;}' unless defined(&IPF_EXP_UDP_PORT);
    eval 'sub IPF_EXP_UDP_SPORT () {0x110003;}' unless defined(&IPF_EXP_UDP_SPORT);
    eval 'sub IPF_EXP_UDP_DPORT () {0x110004;}' unless defined(&IPF_EXP_UDP_DPORT);
    eval 'sub IPF_EXP_IDLE_GT () {0x1000001;}' unless defined(&IPF_EXP_IDLE_GT);
    eval 'sub IPF_EXP_TCP_STATE () {0x1060002;}' unless defined(&IPF_EXP_TCP_STATE);
    eval 'sub IPF_EXP_END () {0xffffffff;}' unless defined(&IPF_EXP_END);
    eval 'sub ONE_DAY () { &IPF_TTLVAL(1* 86400);}' unless defined(&ONE_DAY);
    eval 'sub FIVE_DAYS () {(5*  &ONE_DAY);}' unless defined(&FIVE_DAYS);
    if(defined(&__FreeBSD_version)  && ((defined(&__FreeBSD_version) ? &__FreeBSD_version : undef) >= 300000)  && defined(&_KERNEL)) {
    }
    if(defined(&linux)  && defined(&_KERNEL)) {
    }
    if( &NETBSD_GE_REV(104040000)) {
    }
    if((defined(&SOLARIS) ? &SOLARIS : undef)) {
	if((defined(&SOLARIS2) ? &SOLARIS2 : undef) >= 7) {
	} else {
	}
    }
    if(defined(&_KERNEL)) {
	if((defined(&SOLARIS) ? &SOLARIS : undef)) {
	    if(defined(&INSTANCES)) {
	    }
	} else {
	    if(defined(&linux)  && defined(&_KERNEL)) {
	    } else {
	    }
	}
    }
    eval 'sub IPFERROR {
        my($_e) = @_;
	    eval q( &do {  ($softc->{ipf_interror}) = ($_e);  &DT1( &user_error, \'int\', $_e); }  &while (0));
    }' unless defined(&IPFERROR);
    unless(defined(&_KERNEL)) {
    } else {
	if(defined(&__NetBSD__)  && defined(&PFIL_HOOKS)) {
	}
	if(defined(&MENTAT)) {
	    if((defined(&SOLARIS) ? &SOLARIS : undef)) {
		if((defined(&SOLARIS2) ? &SOLARIS2 : undef) >= 7) {
		} else {
		}
	    }
	    if(defined(&__hpux)) {
	    }
	} else {
	    if(defined(&__sgi)) {
		require 'sys/cred.ph';
	    } else {
		if(defined(&IPFILTER_LKM)) {
		}
		if( &BSDOS_GE_REV(199510) ||  &FREEBSD_GE_REV(220000) || (defined(&NetBSD)  && ((defined(&NetBSD) ? &NetBSD : undef) >= 199511)) || defined(&__OpenBSD__)) {
		    if(defined(&__NetBSD__) ||  &BSDOS_GE_REV(199701) || defined(&__OpenBSD__) ||  &FREEBSD_GE_REV(300000)) {
			if(((defined(&__FreeBSD_version) ? &__FreeBSD_version : undef) >= 500024)) {
			    if(((defined(&__FreeBSD_version) ? &__FreeBSD_version : undef) >= 502116)) {
			    } else {
			    }
			} else {
			    if( &NETBSD_GE_REV(499001000)) {
			    } else {
				if( &NETBSD_GE_REV(399001400)) {
				} else {
				}
			    }
			}
		    } else {
		    }
		} else {
		    if(defined(&linux)) {
		    } else {
		    }
		}
	    }
	}
	if(defined(&__FreeBSD_version)) {
	}
	if(defined(&INSTANCES)) {
	}
    }
    if(defined(&USE_INET6)) {
    }
    if((defined(&__FreeBSD_version)  && ((defined(&__FreeBSD_version) ? &__FreeBSD_version : undef) < 501000)) || !defined(&_KERNEL) || defined(&linux)) {
    }
    if(defined(&USE_INET6)) {
    }
    if(defined(&USE_INET6)) {
    }
    if(defined(&IPFILTER_LOOKUP)) {
    }
    if(defined(&USE_INET6)) {
    }
    if(defined(&IPFILTER_COMPAT)) {
    }
}
1;
