# prefix.pl is in the public domain.
# Written by Thomas Morgan <tmorgan@pobox.com>

$add_ons .= '+prefix.pl' unless $add_ons =~ /\+prefix\.pl/;

$set{"PREFIX"} = " ";
$set{"CMDPREFIX"} = "/";

$cmdprefix = "\\/";
$oldprefix = $set{"PREFIX"};

sub hook_prefix {
  $_[0] = "$set{'PREFIX'}$_[0]" unless $_[0] =~ s/^$cmdprefix//;
  $_[0] = "/$_[0]";
}
&addhook("command", "prefix");

sub set_prefix {
  local($prefix) = $_[0];
  $prefix =~ s/^\'//, $prefix =~ s/\'$//;
  $oldprefix = $set{"PREFIX"};
  $set{"PREFIX"} = $prefix;
}
&addset("prefix", "prefix");

&addhelp("set prefix", <<"EOH");
This is the prefix to be prepended to each line typed without
the command prefix.  The default is ' ', which is like 'say '.  To
emulate ircII's command_mode, set this to ''.  Be sure to use the
single quotes.
EOH

sub set_cmdprefix {
  $set{"CMDPREFIX"} = $cmdprefix = $_[0];
  $cmdprefix =~ s/^\'//, $cmdprefix =~ s/\'$//;
  $cmdprefix =~ s/\W/\\$&/g;
}
&addset("cmdprefix", "cmdprefix");

&addhelp("set cmdprefix", <<"EOH");
This is the prefix that determines whether an input line is a
command.  The default is '/'.  Be sure to use single quotes when
setting this.
EOH

sub cmd_query {
  if ($args) {
    &doset("PREFIX", "msg $args ");
    $query = $args;
    &tell("*** Starting conversation with $query");
    &dostatus;
  } else {
    &doset("PREFIX", $oldprefix);
    &tell("*** Ending conversation with $query");
    $query = '';
    &dostatus;
  }
}
&addcmd("query");
