package TDS::Navigator::FewDays;
# $Id: FewDays.pm,v 1.8 2000/12/08 02:02:32 tom Exp $
################################################################

use strict;
use vars qw(@ISA
	    $Template $HrefTemplateDynamic $HrefTemplateStatic);

use DateTime::Date;

use TDS::Navigator::Base;

@ISA = qw(TDS::Navigator::Base);

attributes qw();

{
    $HrefTemplateDynamic = "./?%year%0m%{0d}R";
    $HrefTemplateStatic = "d%year%0m%part.%suffix\#%0d";
}

################################################################
sub AsPrev ($$)
{
    my ($self, $label, $base_day) = @_;

    my $d;
    if (ref $base_day){
	$d = $base_day->Dup;
    } else {
	$d = new DateTime::Date;
	$d->SetTime(time(), $TDS::System::TZ);
    }
    $d->Decrement('1D');
    return $self->AsHTML($label, $d->GetParams);
}

1;
