/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefaultTreeCellEditor
implements ActionListener,
TreeCellEditor,
TreeSelectionListener {
    static int ICON_TEXT_GAP;
    static int TREE_ICON_GAP;
    static int CLICK_COUNT_TO_START;
    private EventListenerList listenerList;
    protected TreeCellEditor realEditor;
    protected DefaultTreeCellRenderer renderer;
    protected Container editingContainer;
    protected transient Component editingComponent;
    protected boolean canEdit;
    protected transient int offset;
    protected transient JTree tree;
    protected transient TreePath lastPath;
    protected transient Timer timer;
    protected transient int lastRow;
    protected Color borderSelectionColor;
    protected transient Icon editingIcon;
    protected Font font;
    private TreePath tPath;
    static /* synthetic */ Class class$javax$swing$event$CellEditorListener;

    private final void configureEditingComponent(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer, TreeCellEditor treeCellEditor) {
        if (jTree != null && this.lastPath != null) {
            Object object = this.lastPath.getLastPathComponent();
            boolean bl = jTree.getModel().isLeaf(object);
            boolean bl2 = jTree.isExpanded(this.lastPath);
            this.determineOffset(jTree, object, true, bl2, bl, this.lastRow);
            if (bl) {
                defaultTreeCellRenderer.setIcon(defaultTreeCellRenderer.getLeafIcon());
            } else if (bl2) {
                defaultTreeCellRenderer.setIcon(defaultTreeCellRenderer.getOpenIcon());
            } else {
                defaultTreeCellRenderer.setIcon(defaultTreeCellRenderer.getClosedIcon());
            }
            this.editingIcon = defaultTreeCellRenderer.getIcon();
            this.editingComponent = this.getTreeCellEditorComponent(jTree, object, true, bl2, bl, this.lastRow);
        }
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    public void setBorderSelectionColor(Color color) {
        this.borderSelectionColor = color;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setFont(Font font) {
        this.font = font != null ? font : this.renderer.getFont();
    }

    public Font getFont() {
        return this.font;
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        if (this.realEditor == null) {
            this.realEditor = this.createTreeCellEditor();
        }
        return this.realEditor.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n);
    }

    public Object getCellEditorValue() {
        return this.realEditor.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (this.editingComponent == null) {
            this.configureEditingComponent(this.tree, this.renderer, this.realEditor);
        }
        if (this.editingComponent != null && this.realEditor.isCellEditable(eventObject)) {
            this.prepareForEditing();
            return true;
        }
        return false;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        if (this.editingComponent != null) {
            this.stopEditingTimer();
            this.tree.stopEditing();
            this.editingComponent = null;
            return true;
        }
        return false;
    }

    public void cancelCellEditing() {
        if (this.editingComponent != null) {
            this.tree.cancelEditing();
            this.editingComponent = null;
        }
        this.stopEditingTimer();
    }

    private final void stopEditingTimer() {
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.realEditor.addCellEditorListener(cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.realEditor.removeCellEditorListener(cellEditorListener);
    }

    public CellEditorListener[] getCellEditorListeners() {
        Class clazz = class$javax$swing$event$CellEditorListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$CellEditorListener = DefaultTreeCellEditor.class("[Ljavax.swing.event.CellEditorListener;", false);
        }
        return (CellEditorListener[])this.listenerList.getListeners(clazz);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.tPath = this.lastPath;
        this.lastPath = treeSelectionEvent.getNewLeadSelectionPath();
        this.lastRow = this.tree.getRowForPath(this.lastPath);
        this.stopCellEditing();
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    protected void setTree(JTree jTree) {
        this.tree = jTree;
    }

    protected boolean shouldStartEditingTimer(EventObject eventObject) {
        return eventObject instanceof MouseEvent && ((MouseEvent)eventObject).getClickCount() == 1;
    }

    protected void startEditingTimer() {
        if (this.timer != null) {
            this.timer.start();
        }
    }

    protected boolean canEditImmediately(EventObject eventObject) {
        return eventObject == null || !(eventObject instanceof MouseEvent) || ((MouseEvent)eventObject).getClickCount() > 2 && this.inHitRegion(((MouseEvent)eventObject).getX(), ((MouseEvent)eventObject).getY());
    }

    protected boolean inHitRegion(int n, int n2) {
        Rectangle rectangle = this.tree.getPathBounds(this.lastPath);
        return rectangle.contains(n, n2);
    }

    protected void determineOffset(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        this.renderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, true);
        Icon icon = this.renderer.getIcon();
        this.offset = icon != null ? this.renderer.getIconTextGap() + icon.getIconWidth() : 0;
    }

    protected void prepareForEditing() {
        this.editingContainer.removeAll();
        this.editingContainer.add(this.editingComponent);
    }

    protected Container createContainer() {
        return new EditorContainer();
    }

    protected TreeCellEditor createTreeCellEditor() {
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new DefaultTextField(UIManager.getBorder("Tree.selectionBorder")));
        defaultCellEditor.addCellEditorListener(new RealEditorListener());
        defaultCellEditor.setClickCountToStart(CLICK_COUNT_TO_START);
        this.realEditor = defaultCellEditor;
        return defaultCellEditor;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.listenerList = new EventListenerList();
    }

    public DefaultTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
        this(jTree, defaultTreeCellRenderer, null);
    }

    public DefaultTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer, TreeCellEditor treeCellEditor) {
        this.this();
        this.setTree(jTree);
        this.renderer = defaultTreeCellRenderer;
        if (treeCellEditor == null) {
            treeCellEditor = this.createTreeCellEditor();
        } else {
            treeCellEditor.addCellEditorListener(new RealEditorListener());
        }
        this.realEditor = treeCellEditor;
        this.lastPath = jTree.getLeadSelectionPath();
        jTree.addTreeSelectionListener(this);
        this.editingContainer = this.createContainer();
        this.setFont(UIManager.getFont("Tree.font"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
        this.editingIcon = defaultTreeCellRenderer.getIcon();
    }

    static {
        TREE_ICON_GAP = ICON_TEXT_GAP = 3;
        CLICK_COUNT_TO_START = 3;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class EditorContainer
    extends Container {
        static final long serialVersionUID = 6470339600449699810L;

        public void EditorContainer() {
        }

        public void setBounds(Rectangle rectangle) {
            super.setBounds(rectangle);
            this.doLayout();
        }

        public void paint(Graphics graphics) {
            if (DefaultTreeCellEditor.this.editingIcon != null) {
                DefaultTreeCellEditor.this.editingIcon.paintIcon(this, graphics, TREE_ICON_GAP, 0);
            }
            super.paint(graphics);
        }

        public void doLayout() {
            int n = DefaultTreeCellEditor.this.editingIcon != null ? TREE_ICON_GAP + DefaultTreeCellEditor.this.editingIcon.getIconWidth() + ICON_TEXT_GAP : 0;
            Rectangle rectangle = this.getBounds();
            Component component = this.getComponent(0);
            component.setLocation(n, 0);
            component.setSize(rectangle.width - n - TREE_ICON_GAP, rectangle.height);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class DefaultTextField
    extends JTextField {
        static final long serialVersionUID = -6629304544265300143L;
        protected Border border;

        public Font getFont() {
            Font font = super.getFont();
            if (font == null) {
                Container container = this.getParent();
                if (container != null) {
                    return container.getFont();
                }
                return null;
            }
            return font;
        }

        public Border getBorder() {
            return this.border;
        }

        public Dimension getPreferredSize() {
            String string = this.getText();
            Font font = this.getFont();
            if (font != null) {
                FontMetrics fontMetrics = this.getToolkit().getFontMetrics(font);
                return new Dimension(SwingUtilities.computeStringWidth(fontMetrics, string), fontMetrics.getHeight());
            }
            return DefaultTreeCellEditor.this.renderer.getPreferredSize();
        }

        public DefaultTextField(Border border) {
            this.border = border;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class RealEditorListener
    implements CellEditorListener {
        public void editingCanceled(ChangeEvent changeEvent) {
            DefaultTreeCellEditor.this.cancelCellEditing();
        }

        public void editingStopped(ChangeEvent changeEvent) {
            DefaultTreeCellEditor.this.stopCellEditing();
        }

        RealEditorListener() {
        }
    }
}

