/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleKeyBinding;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DebugGraphics;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.plaf.ComponentUI;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class JComponent
extends Container
implements Serializable {
    private static final long serialVersionUID = -7908749299918704233L;
    static boolean isPaintingDoubleBuffered = false;
    private static transient Rectangle rectCache;
    private static Locale defaultLocale;
    public static final String TOOL_TIP_TEXT_KEY = "ToolTipText";
    public static final int UNDEFINED_CONDITION = -1;
    public static final int WHEN_FOCUSED = 0;
    public static final int WHEN_ANCESTOR_OF_FOCUSED_COMPONENT = 1;
    public static final int WHEN_IN_FOCUSED_WINDOW = 2;
    protected AccessibleContext accessibleContext;
    Dimension preferredSize;
    Dimension minimumSize;
    Dimension maximumSize;
    float alignmentX;
    float alignmentY;
    Border border;
    String toolTipText;
    boolean doubleBuffered;
    int debugGraphicsOptions;
    boolean opaque;
    protected ComponentUI ui;
    boolean requestFocusEnabled;
    boolean autoscrolls;
    protected EventListenerList listenerList;
    private SwingPropertyChangeSupport changeSupport;
    private Hashtable clientProperties;
    private InputMap inputMap_whenFocused;
    private InputMap inputMap_whenAncestorOfFocused;
    private InputMap inputMap_whenInFocusedWindow;
    private ActionMap actionMap;
    private boolean verifyInputWhenFocusTarget;
    private InputVerifier inputVerifier;
    private TransferHandler transferHandler;
    boolean isCompletelyDirty;
    static /* synthetic */ Class class$javax$swing$event$AncestorListener;
    static /* synthetic */ Class class$java$beans$VetoableChangeListener;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

    private final Hashtable getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new Hashtable();
        }
        return this.clientProperties;
    }

    public final Object getClientProperty(Object key) {
        return this.getClientProperties().get(key);
    }

    public final void putClientProperty(Object key, Object value) {
        Hashtable t = this.getClientProperties();
        Object old = t.get(key);
        if (value != null) {
            t.put(key, value);
        } else {
            t.remove(key);
        }
        this.firePropertyChange(key.toString(), old, value);
    }

    public void removeAncestorListener(AncestorListener listener) {
        Class clazz = class$javax$swing$event$AncestorListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$AncestorListener = JComponent.class("[Ljavax.swing.event.AncestorListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyName, listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        Class clazz = class$java$beans$VetoableChangeListener;
        if (clazz == null) {
            clazz = class$java$beans$VetoableChangeListener = JComponent.class("[Ljava.beans.VetoableChangeListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public void addAncestorListener(AncestorListener listener) {
        Class clazz = class$javax$swing$event$AncestorListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$AncestorListener = JComponent.class("[Ljavax.swing.event.AncestorListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        Class clazz = class$java$beans$PropertyChangeListener;
        if (clazz == null) {
            clazz = class$java$beans$PropertyChangeListener = JComponent.class("[Ljava.beans.PropertyChangeListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        Class clazz = class$java$beans$VetoableChangeListener;
        if (clazz == null) {
            clazz = class$java$beans$VetoableChangeListener = JComponent.class("[Ljava.beans.VetoableChangeListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public AncestorListener[] getAncestorListeners() {
        Class clazz = class$javax$swing$event$AncestorListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$AncestorListener = JComponent.class("[Ljavax.swing.event.AncestorListener;", false);
        }
        return (AncestorListener[])this.getListeners(clazz);
    }

    public VetoableChangeListener[] getVetoableChangeListeners() {
        Class clazz = class$java$beans$VetoableChangeListener;
        if (clazz == null) {
            clazz = class$java$beans$VetoableChangeListener = JComponent.class("[Ljava.beans.VetoableChangeListener;", false);
        }
        return (VetoableChangeListener[])this.getListeners(clazz);
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String property) {
        return this.changeSupport == null ? new PropertyChangeListener[]{} : this.changeSupport.getPropertyChangeListeners(property);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, (Object)oldValue, (Object)newValue);
        }
    }

    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, new Byte(oldValue), new Byte(newValue));
        }
    }

    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, new Character(oldValue), new Character(newValue));
        }
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, new Double(oldValue), new Double(newValue));
        }
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, new Float(oldValue), new Float(newValue));
        }
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, new Integer(oldValue), new Integer(newValue));
        }
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, new Long(oldValue), new Long(newValue));
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, new Short(oldValue), new Short(newValue));
        }
    }

    protected void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        VetoableChangeListener[] listeners = this.getVetoableChangeListeners();
        PropertyChangeEvent evt = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].vetoableChange(evt);
            ++i;
        }
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    public float getAlignmentX() {
        return this.alignmentX;
    }

    public float getAlignmentY() {
        return this.alignmentY;
    }

    public boolean getAutoscrolls() {
        return this.autoscrolls;
    }

    public void setBorder(Border newBorder) {
        Border oldBorder = this.getBorder();
        if (oldBorder == newBorder) {
            return;
        }
        this.border = newBorder;
        this.firePropertyChange("border", oldBorder, newBorder);
        this.repaint();
    }

    public Border getBorder() {
        return this.border;
    }

    public Rectangle getBounds(Rectangle rv) {
        if (rv == null) {
            return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        rv.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return rv;
    }

    protected Graphics getComponentGraphics(Graphics g) {
        Graphics g2 = g;
        int options = this.getDebugGraphicsOptions();
        if (options != -1) {
            if (!(g2 instanceof DebugGraphics)) {
                g2 = new DebugGraphics(g);
            }
            DebugGraphics dg = (DebugGraphics)g2;
            dg.setDebugOptions(dg.getDebugOptions() | options);
        }
        g2.setFont(this.getFont());
        g2.setColor(this.getForeground());
        return g2;
    }

    public int getDebugGraphicsOptions() {
        String option = System.getProperty("gnu.javax.swing.DebugGraphics");
        int options = this.debugGraphicsOptions;
        if (option != null && option.length() != 0) {
            if (options < 0) {
                options = 0;
            }
            if (option.equals("LOG")) {
                options |= 1;
            } else if (option.equals("FLASH")) {
                options |= 2;
            }
        }
        return options;
    }

    public Insets getInsets() {
        if (this.border == null) {
            return super.getInsets();
        }
        return this.getBorder().getBorderInsets(this);
    }

    public Insets getInsets(Insets insets) {
        Insets t = this.getInsets();
        if (insets == null) {
            return t;
        }
        insets.left = t.left;
        insets.right = t.right;
        insets.top = t.top;
        insets.bottom = t.bottom;
        return insets;
    }

    public Point getLocation(Point rv) {
        if (rv == null) {
            return new Point(this.getX(), this.getY());
        }
        rv.setLocation(this.getX(), this.getY());
        return rv;
    }

    public Dimension getMaximumSize() {
        Dimension p;
        Dimension s;
        if (this.maximumSize != null) {
            return this.maximumSize;
        }
        if (this.ui != null && (s = this.ui.getMaximumSize(this)) != null) {
            return p;
        }
        p = super.getMaximumSize();
        return p;
    }

    public Dimension getMinimumSize() {
        Dimension p;
        Dimension s;
        if (this.minimumSize != null) {
            return this.minimumSize;
        }
        if (this.ui != null && (s = this.ui.getMinimumSize(this)) != null) {
            return p;
        }
        p = super.getMinimumSize();
        return p;
    }

    public Dimension getPreferredSize() {
        Dimension s;
        Dimension prefSize = null;
        if (this.preferredSize != null) {
            prefSize = this.preferredSize;
        } else if (this.ui != null && (s = this.ui.getPreferredSize(this)) != null) {
            prefSize = s;
        }
        if (prefSize == null) {
            prefSize = super.getPreferredSize();
        }
        if (this.minimumSize != null && prefSize != null && (this.minimumSize.width > prefSize.width || this.minimumSize.height > prefSize.height)) {
            prefSize = new Dimension(Math.max(this.minimumSize.width, prefSize.width), Math.max(this.minimumSize.height, prefSize.height));
        }
        return prefSize;
    }

    public boolean isMaximumSizeSet() {
        boolean bl = false;
        if (this.maximumSize != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isMinimumSizeSet() {
        boolean bl = false;
        if (this.minimumSize != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isPreferredSizeSet() {
        boolean bl = false;
        if (this.preferredSize != null) {
            bl = true;
        }
        return bl;
    }

    public Component getNextFocusableComponent() {
        return null;
    }

    public KeyStroke[] getRegisteredKeyStrokes() {
        return null;
    }

    public JRootPane getRootPane() {
        JRootPane p = SwingUtilities.getRootPane(this);
        return p;
    }

    public Dimension getSize(Dimension rv) {
        if (rv == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        rv.setSize(this.getWidth(), this.getHeight());
        return rv;
    }

    public JToolTip createToolTip() {
        JToolTip toolTip = new JToolTip();
        toolTip.setComponent(this);
        toolTip.setTipText(this.toolTipText);
        return toolTip;
    }

    public Point getToolTipLocation(MouseEvent event) {
        return null;
    }

    public void setToolTipText(String text) {
        if (text == null) {
            ToolTipManager.sharedInstance().unregisterComponent(this);
            this.toolTipText = null;
            return;
        }
        String oldText = this.toolTipText;
        this.toolTipText = text;
        if (oldText == null) {
            ToolTipManager.sharedInstance().registerComponent(this);
        }
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public String getToolTipText(MouseEvent event) {
        return this.getToolTipText();
    }

    public Container getTopLevelAncestor() {
        Container c;
        Container peek = c = this.getParent();
        while (peek != null) {
            c = peek;
            peek = peek.getParent();
        }
        return c;
    }

    public void computeVisibleRect(Rectangle rect) {
        Container c = this.getParent();
        if (c != null && c instanceof JComponent) {
            ((JComponent)c).computeVisibleRect(rect);
            rect.translate(-this.getX(), -this.getY());
            Rectangle2D.intersect(rect, new Rectangle(0, 0, this.getWidth(), this.getHeight()), rect);
        } else {
            rect.setRect(0.0, 0.0, this.getWidth(), this.getHeight());
        }
    }

    public Rectangle getVisibleRect() {
        Rectangle r = new Rectangle();
        this.computeVisibleRect(r);
        return r;
    }

    public void grabFocus() {
    }

    public boolean isDoubleBuffered() {
        return this.doubleBuffered;
    }

    public static boolean isLightweightComponent(Component c) {
        return c.getPeer() instanceof LightweightPeer;
    }

    public boolean isManagingFocus() {
        return false;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    public boolean isPaintingTile() {
        return false;
    }

    public boolean isRequestFocusEnabled() {
        return this.requestFocusEnabled;
    }

    public boolean isValidateRoot() {
        return false;
    }

    public void paint(Graphics g) {
        RepaintManager rm = RepaintManager.currentManager(this);
        if (!isPaintingDoubleBuffered && this.isDoubleBuffered() && rm.isDoubleBufferingEnabled()) {
            this.paintDoubleBuffered(g);
        } else {
            if (g.getClip() == null) {
                g.setClip(0, 0, this.getWidth(), this.getHeight());
            }
            this.paintComponent(g);
            this.paintBorder(g);
            this.paintChildren(g);
            Rectangle clip = g.getClipBounds();
            if (clip.x == 0 && clip.y == 0 && clip.width == this.getWidth() && clip.height == this.getHeight()) {
                RepaintManager.currentManager(this).markCompletelyClean(this);
            }
        }
    }

    protected void paintBorder(Graphics g) {
        if (this.getBorder() != null) {
            this.getBorder().paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void paintChildren(Graphics g) {
        Shape originalClip = g.getClip();
        Rectangle inner = SwingUtilities.calculateInnerArea(this, rectCache);
        g.clipRect(inner.x, inner.y, inner.width, inner.height);
        Component[] children = this.getComponents();
        int i = children.length - 1;
        while (true) {
            if (i < 0) {
                g.setClip(originalClip);
                return;
            }
            if (children[i].isVisible()) {
                Rectangle bounds = children[i].getBounds(rectCache);
                Rectangle oldClip = g.getClipBounds();
                if (oldClip == null) {
                    oldClip = bounds;
                }
                if (g.hitClip(bounds.x, bounds.y, bounds.width, bounds.height)) {
                    Object var10_9;
                    boolean translated = false;
                    try {
                        g.clipRect(bounds.x, bounds.y, bounds.width, bounds.height);
                        g.translate(bounds.x, bounds.y);
                        translated = true;
                        children[i].paint(g);
                    }
                    catch (Throwable throwable) {
                        var10_9 = null;
                        if (translated) {
                            g.translate(-bounds.x, -bounds.y);
                        }
                        g.setClip(oldClip);
                        throw throwable;
                    }
                    {
                        var10_9 = null;
                        if (translated) {
                            g.translate(-bounds.x, -bounds.y);
                        }
                        g.setClip(oldClip);
                    }
                }
            }
            --i;
        }
    }

    protected void paintComponent(Graphics g) {
        if (this.ui != null) {
            Graphics g2 = g;
            if (!(g instanceof Graphics2D)) {
                g2 = g.create();
            }
            this.ui.update(this.getComponentGraphics(g2), this);
            if (!(g instanceof Graphics2D)) {
                g2.dispose();
            }
        }
    }

    public void paintImmediately(int x, int y, int w, int h) {
        this.paintImmediately(new Rectangle(x, y, w, h));
    }

    public void paintImmediately(Rectangle r) {
        Component root = this.findPaintRoot(r);
        if (root == null) {
            return;
        }
        if (root == null || !root.isShowing()) {
            return;
        }
        Rectangle rootClip = SwingUtilities.convertRectangle(this, r, root);
        if (root instanceof JComponent) {
            ((JComponent)root).paintImmediately2(rootClip);
        } else {
            root.repaint(rootClip.x, rootClip.y, rootClip.width, rootClip.height);
        }
    }

    void paintImmediately2(Rectangle r) {
        RepaintManager rm = RepaintManager.currentManager(this);
        Graphics g = this.getGraphics();
        g.setClip(r.x, r.y, r.width, r.height);
        if (rm.isDoubleBufferingEnabled() && this.isDoubleBuffered()) {
            this.paintDoubleBuffered(g);
        } else {
            this.paintSimple(g);
        }
        g.dispose();
    }

    void paintDoubleBuffered(Graphics g) {
        Rectangle r = g.getClipBounds();
        if (r == null) {
            r = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        }
        RepaintManager rm = RepaintManager.currentManager(this);
        Image buffer = rm.getOffscreenBuffer(this, this.getWidth(), this.getHeight());
        Graphics g2 = buffer.getGraphics();
        g2 = this.getComponentGraphics(g2);
        g2.setClip(r.x, r.y, r.width, r.height);
        isPaintingDoubleBuffered = true;
        this.paint(g2);
        isPaintingDoubleBuffered = false;
        g2.dispose();
        g.drawImage(buffer, 0, 0, this);
    }

    void paintSimple(Graphics g) {
        Graphics g2 = this.getComponentGraphics(g);
        this.paint(g2);
    }

    protected String paramString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.paramString());
        sb.append(",alignmentX=").append(this.getAlignmentX());
        sb.append(",alignmentY=").append(this.getAlignmentY());
        sb.append(",border=");
        if (this.getBorder() != null) {
            sb.append(this.getBorder());
        }
        sb.append(",maximumSize=");
        if (this.getMaximumSize() != null) {
            sb.append(this.getMaximumSize());
        }
        sb.append(",minimumSize=");
        if (this.getMinimumSize() != null) {
            sb.append(this.getMinimumSize());
        }
        sb.append(",preferredSize=");
        if (this.getPreferredSize() != null) {
            sb.append(this.getPreferredSize());
        }
        return sb.toString();
    }

    public void registerKeyboardAction(ActionListener act, KeyStroke stroke, int cond) {
        this.registerKeyboardAction(act, null, stroke, cond);
    }

    public void registerKeyboardAction(ActionListener act, String cmd, KeyStroke stroke, int cond) {
        this.getInputMap(cond).put(stroke, new ActionListenerProxy(act, cmd));
    }

    public final void setInputMap(int condition, InputMap map) {
        this.enableEvents(8L);
        switch (condition) {
            case 0: {
                this.inputMap_whenFocused = map;
                break;
            }
            case 1: {
                this.inputMap_whenAncestorOfFocused = map;
                break;
            }
            case 2: {
                this.inputMap_whenInFocusedWindow = map;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public final InputMap getInputMap(int condition) {
        this.enableEvents(8L);
        switch (condition) {
            case 0: {
                if (this.inputMap_whenFocused == null) {
                    this.inputMap_whenFocused = new InputMap();
                }
                return this.inputMap_whenFocused;
            }
            case 1: {
                if (this.inputMap_whenAncestorOfFocused == null) {
                    this.inputMap_whenAncestorOfFocused = new InputMap();
                }
                return this.inputMap_whenAncestorOfFocused;
            }
            case 2: {
                if (this.inputMap_whenInFocusedWindow == null) {
                    this.inputMap_whenInFocusedWindow = new InputMap();
                }
                return this.inputMap_whenInFocusedWindow;
            }
        }
        return null;
    }

    public final InputMap getInputMap() {
        return this.getInputMap(0);
    }

    public final ActionMap getActionMap() {
        if (this.actionMap == null) {
            this.actionMap = new ActionMap();
        }
        return this.actionMap;
    }

    public final void setActionMap(ActionMap map) {
        this.actionMap = map;
    }

    public int getConditionForKeyStroke(KeyStroke ks) {
        if (this.inputMap_whenFocused != null && this.inputMap_whenFocused.get(ks) != null) {
            return 0;
        }
        if (this.inputMap_whenAncestorOfFocused != null && this.inputMap_whenAncestorOfFocused.get(ks) != null) {
            return 1;
        }
        if (this.inputMap_whenInFocusedWindow != null && this.inputMap_whenInFocusedWindow.get(ks) != null) {
            return 2;
        }
        return -1;
    }

    public ActionListener getActionForKeyStroke(KeyStroke ks) {
        Object cmd = this.getInputMap().get(ks);
        if (cmd != null) {
            if (cmd instanceof ActionListenerProxy) {
                return (ActionListenerProxy)cmd;
            }
            if (cmd instanceof String) {
                return this.getActionMap().get(cmd);
            }
        }
        return null;
    }

    protected void processComponentKeyEvent(KeyEvent e) {
    }

    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        this.processComponentKeyEvent(e);
        if (e.isConsumed()) {
            return;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
        boolean bl = false;
        if (e.getID() == 401) {
            bl = true;
        }
        if (this.processKeyBinding(keyStroke, e, 0, bl)) {
            e.consume();
        } else {
            KeyStroke keyStroke2 = KeyStroke.getKeyStrokeForEvent(e);
            boolean bl2 = false;
            if (e.getID() == 401) {
                bl2 = true;
            }
            if (this.processKeyBinding(keyStroke2, e, 1, bl2)) {
                e.consume();
            } else {
                Container current = this;
                while ((current = current.getParent()) instanceof JComponent) {
                    KeyStroke keyStroke3 = KeyStroke.getKeyStrokeForEvent(e);
                    boolean bl3 = false;
                    if (e.getID() == 401) {
                        bl3 = true;
                    }
                    if (((JComponent)current).processKeyBinding(keyStroke3, e, 1, bl3)) {
                        e.consume();
                        break;
                    }
                    if (current instanceof Window || current instanceof Applet || current instanceof JInternalFrame) break;
                }
                if (e.isConsumed()) {
                    return;
                }
            }
        }
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (this.isEnabled()) {
            Object cmd;
            Action act = null;
            InputMap map = this.getInputMap(condition);
            if (map != null && (cmd = map.get(ks)) != null) {
                act = cmd instanceof ActionListenerProxy ? (Action)cmd : this.getActionMap().get(cmd);
            }
            if (act != null && act.isEnabled()) {
                return SwingUtilities.notifyAction(act, ks, e, this, e.getModifiers());
            }
        }
        return false;
    }

    public void unregisterKeyboardAction(KeyStroke aKeyStroke) {
    }

    public void resetKeyboardActions() {
        if (this.inputMap_whenFocused != null) {
            this.inputMap_whenFocused.clear();
        }
        if (this.inputMap_whenAncestorOfFocused != null) {
            this.inputMap_whenAncestorOfFocused.clear();
        }
        if (this.inputMap_whenInFocusedWindow != null) {
            this.inputMap_whenInFocusedWindow.clear();
        }
        if (this.actionMap != null) {
            this.actionMap.clear();
        }
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        Rectangle dirty = new Rectangle(x, y, width, height);
        Rectangle vis = this.getVisibleRect();
        dirty = dirty.intersection(vis);
        RepaintManager.currentManager(this).addDirtyRegion(this, dirty.x, dirty.y, dirty.width, dirty.height);
    }

    public void repaint(Rectangle r) {
        this.repaint(0L, (int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    public boolean requestDefaultFocus() {
        return false;
    }

    public void revalidate() {
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public final void run() {
                    JComponent.this.revalidate();
                }
            });
        } else {
            this.invalidate();
            RepaintManager.currentManager(this).addInvalidComponent(this);
        }
    }

    public void scrollRectToVisible(Rectangle r) {
        Container p = this.getParent();
        if (p instanceof JComponent) {
            ((JComponent)p).scrollRectToVisible(r);
        }
    }

    public void setAlignmentX(float a) {
        this.alignmentX = a;
    }

    public void setAlignmentY(float a) {
        this.alignmentY = a;
    }

    public void setAutoscrolls(boolean a) {
        this.autoscrolls = a;
    }

    public void setDebugGraphicsOptions(int debugOptions) {
        this.debugGraphicsOptions = debugOptions;
    }

    public void setDoubleBuffered(boolean db) {
        this.doubleBuffered = db;
    }

    public void setEnabled(boolean enable) {
        if (enable == this.isEnabled()) {
            return;
        }
        super.setEnabled(enable);
        this.firePropertyChange("enabled", enable ^ true, enable);
        this.repaint();
    }

    public void setFont(Font f) {
        if (f == this.getFont()) {
            return;
        }
        super.setFont(f);
        this.revalidate();
        this.repaint();
    }

    public void setBackground(Color bg) {
        if (bg == this.getBackground()) {
            return;
        }
        super.setBackground(bg);
        this.repaint();
    }

    public void setForeground(Color fg) {
        if (fg == this.getForeground()) {
            return;
        }
        super.setForeground(fg);
        this.repaint();
    }

    public void setMaximumSize(Dimension max) {
        Dimension oldMaximumSize = this.maximumSize;
        this.maximumSize = max;
        this.firePropertyChange("maximumSize", oldMaximumSize, this.maximumSize);
    }

    public void setMinimumSize(Dimension min) {
        Dimension oldMinimumSize = this.minimumSize;
        this.minimumSize = min;
        this.firePropertyChange("minimumSize", oldMinimumSize, this.minimumSize);
    }

    public void setPreferredSize(Dimension pref) {
        Dimension oldPreferredSize = this.preferredSize;
        this.preferredSize = pref;
        this.firePropertyChange("preferredSize", oldPreferredSize, this.preferredSize);
    }

    public void setNextFocusableComponent(Component aComponent) {
    }

    public void setRequestFocusEnabled(boolean e) {
        this.requestFocusEnabled = e;
    }

    public TransferHandler getTransferHandler() {
        return this.transferHandler;
    }

    public void setTransferHandler(TransferHandler newHandler) {
        if (this.transferHandler == newHandler) {
            return;
        }
        TransferHandler oldHandler = this.transferHandler;
        this.transferHandler = newHandler;
        this.firePropertyChange("transferHandler", oldHandler, newHandler);
    }

    public void setOpaque(boolean isOpaque) {
        boolean oldOpaque = this.opaque;
        this.opaque = isOpaque;
        this.firePropertyChange("opaque", oldOpaque, this.opaque);
    }

    public void setVisible(boolean v) {
        if (this.isVisible() == v) {
            return;
        }
        super.setVisible(v);
        if (v) {
            this.fireAncestorEvent(this, 1);
        } else {
            this.fireAncestorEvent(this, 2);
        }
        Container parent = this.getParent();
        if (parent != null) {
            parent.repaint(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        this.revalidate();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public String getUIClassID() {
        return "ComponentUI";
    }

    protected void setUI(ComponentUI newUI) {
        if (this.ui != null) {
            this.ui.uninstallUI(this);
        }
        ComponentUI oldUI = this.ui;
        this.ui = newUI;
        if (this.ui != null) {
            this.ui.installUI(this);
        }
        this.firePropertyChange("UI", oldUI, newUI);
        this.revalidate();
        this.repaint();
    }

    public void updateUI() {
        System.out.println("update UI not overwritten in class: " + this);
    }

    public static Locale getDefaultLocale() {
        return defaultLocale;
    }

    public static void setDefaultLocale(Locale l) {
        defaultLocale = l;
    }

    public InputVerifier getInputVerifier() {
        return this.inputVerifier;
    }

    public void setInputVerifier(InputVerifier verifier) {
        InputVerifier oldVerifier = this.inputVerifier;
        this.inputVerifier = verifier;
        this.firePropertyChange("inputVerifier", oldVerifier, verifier);
    }

    public boolean getVerifyInputWhenFocusTarget() {
        return this.verifyInputWhenFocusTarget;
    }

    public void setVerifyInputWhenFocusTarget(boolean verifyInputWhenFocusTarget) {
        if (this.verifyInputWhenFocusTarget == verifyInputWhenFocusTarget) {
            return;
        }
        this.verifyInputWhenFocusTarget = verifyInputWhenFocusTarget;
        this.firePropertyChange("verifyInputWhenFocusTarget", verifyInputWhenFocusTarget ^ true, verifyInputWhenFocusTarget);
    }

    public void requestFocus() {
        if (this.isRequestFocusEnabled()) {
            super.requestFocus();
        }
    }

    public boolean requestFocus(boolean temporary) {
        return super.requestFocus(temporary);
    }

    public boolean requestFocusInWindow() {
        if (this.isRequestFocusEnabled()) {
            return super.requestFocusInWindow();
        }
        return false;
    }

    public boolean requestFocusInWindow(boolean temporary) {
        return super.requestFocusInWindow(temporary);
    }

    public void addNotify() {
        super.addNotify();
        InputMap input = this.getInputMap();
        ActionMap actions = this.getActionMap();
        Container parent = this.getParent();
        while (parent != null && parent instanceof JComponent) {
            JComponent jParent = (JComponent)parent;
            InputMap parentInput = jParent.getInputMap();
            ActionMap parentAction = jParent.getActionMap();
            KeyStroke[] ikeys = input.keys();
            int i = 0;
            while (i < ikeys.length) {
                Object o = input.get(ikeys[i]);
                parentInput.put(ikeys[i], o);
                ++i;
            }
            Object[] akeys = actions.keys();
            int i2 = 0;
            while (i2 < akeys.length) {
                Action a = actions.get(akeys[i2]);
                parentAction.put(akeys[i2], a);
                ++i2;
            }
            parent = jParent.getParent();
        }
        this.fireAncestorEvent(this, 1);
        this.firePropertyChange("ancestor", null, parent);
    }

    public void removeNotify() {
        super.removeNotify();
        InputMap input = this.getInputMap();
        ActionMap actions = this.getActionMap();
        Container parent = this.getParent();
        while (parent != null && parent instanceof JComponent) {
            JComponent jParent = (JComponent)parent;
            InputMap parentInput = jParent.getInputMap();
            ActionMap parentAction = jParent.getActionMap();
            KeyStroke[] ikeys = input.allKeys();
            int i = 0;
            while (i < ikeys.length) {
                parentInput.remove(ikeys[i]);
                ++i;
            }
            Object[] akeys = actions.allKeys();
            int i2 = 0;
            while (i2 < akeys.length) {
                parentAction.remove(akeys[i2]);
                ++i2;
            }
            parent = jParent.getParent();
        }
        this.fireAncestorEvent(this, 2);
        this.firePropertyChange("ancestor", parent, null);
    }

    public boolean contains(int x, int y) {
        if (this.ui == null) {
            return super.contains(x, y);
        }
        return this.ui.contains(this, x, y);
    }

    public void disable() {
        super.disable();
    }

    public void enable() {
        super.enable();
    }

    public Graphics getGraphics() {
        return super.getGraphics();
    }

    public int getX() {
        return super.getX();
    }

    public int getY() {
        return super.getY();
    }

    public int getHeight() {
        return super.getHeight();
    }

    public int getWidth() {
        return super.getWidth();
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public void print(Graphics g) {
        boolean doubleBufferState = this.isDoubleBuffered();
        this.setDoubleBuffered(false);
        this.printComponent(g);
        this.printBorder(g);
        this.printChildren(g);
        this.setDoubleBuffered(doubleBufferState);
    }

    public void printAll(Graphics g) {
        this.print(g);
    }

    public void printComponent(Graphics g) {
        this.paintComponent(g);
    }

    public void printChildren(Graphics g) {
        this.paintChildren(g);
    }

    public void printBorder(Graphics g) {
        this.paintBorder(g);
    }

    protected void processMouseMotionEvent(MouseEvent ev) {
        super.processMouseMotionEvent(ev);
    }

    public void reshape(int x, int y, int w, int h) {
        int oldX = this.getX();
        int oldY = this.getY();
        super.reshape(x, y, w, h);
        if (oldX != this.getX() || oldY != this.getY()) {
            this.fireAncestorEvent(this, 3);
        }
    }

    void fireAncestorEvent(JComponent ancestor, int id) {
        int i;
        AncestorListener[] listeners = this.getAncestorListeners();
        if (listeners.length > 0) {
            AncestorEvent ev = new AncestorEvent(this, id, ancestor, ancestor.getParent());
            i = 0;
            while (i < listeners.length) {
                switch (id) {
                    case 3: {
                        listeners[i].ancestorMoved(ev);
                        break;
                    }
                    case 1: {
                        listeners[i].ancestorAdded(ev);
                        break;
                    }
                    case 2: {
                        listeners[i].ancestorRemoved(ev);
                        break;
                    }
                }
                ++i;
            }
        }
        Component[] children = this.getComponents();
        i = 0;
        while (i < children.length) {
            if (children[i] instanceof JComponent) {
                JComponent jc = (JComponent)children[i];
                jc.fireAncestorEvent(ancestor, id);
            }
            ++i;
        }
    }

    private final Component findPaintRoot(Rectangle c) {
        Component p = this.findOverlapFreeParent(c);
        if (p == null) {
            return null;
        }
        Component root = this.findOpaqueParent(p);
        return root;
    }

    private final Component findOverlapFreeParent(Rectangle clip) {
        Rectangle currentClip = clip;
        Container found = this;
        Container parent = this;
        while (parent != null && !(parent instanceof Window)) {
            Container newParent = parent.getParent();
            if (newParent == null) break;
            if (newParent instanceof JComponent && ((JComponent)newParent).isOptimizedDrawingEnabled()) {
                parent = newParent;
                continue;
            }
            Rectangle parRect = new Rectangle(0, 0, newParent.getWidth(), newParent.getHeight());
            Rectangle target = SwingUtilities.convertRectangle(found, currentClip, newParent);
            if (target.contains(parRect) || target.intersects(parRect)) {
                found = newParent;
                currentClip = target;
                parent = newParent;
                continue;
            }
            Component[] children = newParent.getComponents();
            boolean skip = true;
            int i = children.length - 1;
            while (i >= 0) {
                if (children[i] == parent) {
                    skip = false;
                }
                if (!skip) {
                    Component c = children[i];
                    Rectangle compBounds = c.getBounds();
                    if (compBounds.contains(target)) {
                        return null;
                    }
                    if (compBounds.intersects(target)) {
                        found = newParent;
                        currentClip = target;
                        break;
                    }
                }
                --i;
            }
            parent = newParent;
        }
        return found;
    }

    private final Component findOpaqueParent(Component c) {
        Container p;
        Component found = c;
        while (!(found instanceof JComponent && ((JComponent)found).isOpaque() || !(found instanceof JComponent) || (p = found.getParent()) == null)) {
            found = p;
        }
        return found;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.alignmentX = 0.5f;
        this.alignmentY = 0.5f;
        this.doubleBuffered = true;
        this.opaque = false;
        this.autoscrolls = false;
        this.listenerList = new EventListenerList();
        this.isCompletelyDirty = false;
    }

    public JComponent() {
        this.this();
        super.setLayout(new FlowLayout());
        this.setDropTarget(new DropTarget());
        defaultLocale = Locale.getDefault();
        this.debugGraphicsOptions = -1;
        this.setRequestFocusEnabled(true);
    }

    private static class ActionListenerProxy
    extends AbstractAction {
        ActionListener target;
        String bindingCommandName;

        public void actionPerformed(ActionEvent e) {
            ActionEvent derivedEvent = new ActionEvent(e.getSource(), e.getID(), this.bindingCommandName, e.getModifiers());
            this.target.actionPerformed(derivedEvent);
        }

        public ActionListenerProxy(ActionListener li, String cmd) {
            this.target = li;
            this.bindingCommandName = cmd;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public abstract class AccessibleJComponent
    extends Container.AccessibleAWTContainer
    implements AccessibleExtendedComponent {
        private static final long serialVersionUID = -7047089700479897799L;
        protected ContainerListener accessibleContainerHandler;
        protected FocusListener accessibleFocusHandler;
        private SwingPropertyChangeSupport changeSupport = new SwingPropertyChangeSupport(this);

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.removePropertyChangeListener(listener);
        }

        public int getAccessibleChildrenCount() {
            int count = 0;
            Component[] children = JComponent.this.getComponents();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof Accessible) {
                    ++count;
                }
                ++i;
            }
            return count;
        }

        public Accessible getAccessibleChild(int i) {
            int index = 0;
            Component[] children = JComponent.this.getComponents();
            Accessible found = null;
            int j = 0;
            while (index != i) {
                if (children[j] instanceof Accessible) {
                    ++index;
                }
                if (index == i) {
                    found = (Accessible)((Object)children[index]);
                }
                ++j;
            }
            return found;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return super.getAccessibleStateSet();
        }

        public String getAccessibleName() {
            return null;
        }

        public String getAccessibleDescription() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SWING_COMPONENT;
        }

        protected String getBorderTitle(Border border) {
            String title = null;
            if (border instanceof CompoundBorder) {
                CompoundBorder compound = (CompoundBorder)border;
                Border inner = compound.getInsideBorder();
                title = this.getBorderTitle(inner);
                if (title == null) {
                    Border outer = compound.getOutsideBorder();
                    title = this.getBorderTitle(outer);
                }
            } else if (border instanceof TitledBorder) {
                TitledBorder titled = (TitledBorder)border;
                title = titled.getTitle();
            }
            return title;
        }

        public String getToolTipText() {
            return JComponent.this.getToolTipText();
        }

        public String getTitledBorderText() {
            return this.getBorderTitle(JComponent.this.getBorder());
        }

        public AccessibleKeyBinding getAccessibleKeyBinding() {
            return null;
        }

        protected AccessibleJComponent() {
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        protected class AccessibleContainerHandler
        implements ContainerListener {
            public void componentAdded(ContainerEvent event) {
            }

            public void componentRemoved(ContainerEvent valevent) {
            }

            protected AccessibleContainerHandler() {
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        protected class AccessibleFocusHandler
        implements FocusListener {
            public void focusGained(FocusEvent event) {
            }

            public void focusLost(FocusEvent valevent) {
            }

            protected AccessibleFocusHandler() {
            }
        }
    }
}

