/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SimpleTimeZone
extends TimeZone {
    private static final int DOM_MODE = 1;
    private static final int DOW_IN_MONTH_MODE = 2;
    private static final int DOW_GE_DOM_MODE = 3;
    private static final int DOW_LE_DOM_MODE = 4;
    private static final byte[] monthArr = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final long serialVersionUID = -403250971215465050L;
    public static final int STANDARD_TIME = 1;
    public static final int WALL_TIME = 0;
    public static final int UTC_TIME = 2;
    private int rawOffset;
    private boolean useDaylight;
    private int dstSavings;
    private int startYear;
    private int startMode;
    private int startMonth;
    private int startDay;
    private int startDayOfWeek;
    private int startTime;
    private int startTimeMode;
    private int endMonth;
    private int endMode;
    private int endDay;
    private int endDayOfWeek;
    private int endTime;
    private int endTimeMode;
    private byte[] monthLength;
    private int serialVersionOnStream;

    public void setStartYear(int n) {
        this.startYear = n;
        this.useDaylight = true;
    }

    private final int checkRule(int n, int n2, int n3) {
        if (n < 0 || n > 11) {
            throw new IllegalArgumentException("month out of range");
        }
        int n4 = this.getDaysInMonth(n, 1);
        if (n3 == 0) {
            if (n2 <= 0 || n2 > n4) {
                throw new IllegalArgumentException("day out of range");
            }
            return 1;
        }
        if (n3 > 0) {
            if (Math.abs(n2) > (n4 + 6) / 7) {
                throw new IllegalArgumentException("dayOfWeekInMonth out of range");
            }
            if (n3 > 7) {
                throw new IllegalArgumentException("dayOfWeek out of range");
            }
            return 2;
        }
        if (n2 == 0 || Math.abs(n2) > n4) {
            throw new IllegalArgumentException("day out of range");
        }
        if (n3 < -7) {
            throw new IllegalArgumentException("dayOfWeek out of range");
        }
        if (n2 < 0) {
            return 4;
        }
        return 3;
    }

    public void setStartRule(int n, int n2, int n3, int n4) {
        this.startMode = this.checkRule(n, n2, n3);
        this.startMonth = n;
        this.startDay = n2;
        this.startDayOfWeek = Math.abs(n3);
        this.startTime = this.startTimeMode == 0 || this.startTimeMode == 1 ? n4 : n4 + this.rawOffset;
        this.useDaylight = true;
    }

    public void setStartRule(int n, int n2, int n3, int n4, boolean bl) {
        this.startDay = bl ? Math.abs(n2) : -Math.abs(n2);
        this.startDayOfWeek = bl ? Math.abs(n3) : -Math.abs(n3);
        this.startMode = n3 != 0 ? 4 - bl : this.checkRule(n, n2, n3);
        this.startDay = Math.abs(this.startDay);
        this.startDayOfWeek = Math.abs(this.startDayOfWeek);
        this.startMonth = n;
        this.startTime = this.startTimeMode == 0 || this.startTimeMode == 1 ? n4 : n4 + this.rawOffset;
        this.useDaylight = true;
    }

    public void setStartRule(int n, int n2, int n3) {
        this.setStartRule(n, n2, 0, n3);
    }

    public void setEndRule(int n, int n2, int n3, int n4) {
        this.endMode = this.checkRule(n, n2, n3);
        this.endMonth = n;
        this.endDay = n2;
        this.endDayOfWeek = Math.abs(n3);
        this.endTime = this.endTimeMode == 0 ? n4 : (this.endTimeMode == 1 ? n4 + this.dstSavings : n4 + this.rawOffset + this.dstSavings);
        this.useDaylight = true;
    }

    public void setEndRule(int n, int n2, int n3, int n4, boolean bl) {
        this.endDay = bl ? Math.abs(n2) : -Math.abs(n2);
        this.endDayOfWeek = bl ? Math.abs(n3) : -Math.abs(n3);
        this.endMode = n3 != 0 ? 4 - bl : this.checkRule(n, n2, n3);
        this.endDay = Math.abs(this.endDay);
        this.endDayOfWeek = Math.abs(this.endDayOfWeek);
        this.endMonth = n;
        this.endTime = this.endTimeMode == 0 ? n4 : (this.endTimeMode == 1 ? n4 + this.dstSavings : n4 + this.rawOffset + this.dstSavings);
        this.useDaylight = true;
    }

    public void setEndRule(int n, int n2, int n3) {
        this.setEndRule(n, n2, 0, n3);
    }

    public int getOffset(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.getDaysInMonth(n3, n2);
        if (n4 < 1 || n4 > n7) {
            throw new IllegalArgumentException("day out of range");
        }
        if (n5 < 1 || n5 > 7) {
            throw new IllegalArgumentException("dayOfWeek out of range");
        }
        if (n3 < 0 || n3 > 11) {
            throw new IllegalArgumentException("month out of range:" + n3);
        }
        int n8 = 0;
        if (this.useDaylight && n == 1 && n2 >= this.startYear) {
            boolean bl = this.isBefore(n2, n3, n4, n5, n6, this.startMode, this.startMonth, this.startDay, this.startDayOfWeek, this.startTime) ^ true;
            boolean bl2 = this.isBefore(n2, n3, n4, n5, n6 + this.dstSavings, this.endMode, this.endMonth, this.endDay, this.endDayOfWeek, this.endTime);
            if (this.startMonth < this.endMonth) {
                int n9 = 0;
                if (bl && bl2) {
                    n9 = this.dstSavings;
                }
                n8 = n9;
            } else {
                int n10 = 0;
                if (bl2 || bl) {
                    n10 = this.dstSavings;
                }
                n8 = n10;
            }
        }
        return this.rawOffset + n8;
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public void setRawOffset(int n) {
        this.rawOffset = n;
    }

    public int getDSTSavings() {
        return this.dstSavings;
    }

    public void setDSTSavings(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("illegal value for dstSavings");
        }
        this.dstSavings = n;
    }

    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    private final int getDaysInMonth(int n, int n2) {
        if (n == 1) {
            if ((n2 & 3) != 0) {
                return 28;
            }
            if (n2 < 1582) {
                return 29;
            }
            int n3 = 0;
            if (n2 % 100 != 0 || n2 % 400 == 0) {
                n3 = 1;
            }
            return n3 + 28;
        }
        return monthArr[n];
    }

    private final boolean isBefore(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        if (n2 != n7) {
            boolean bl = false;
            if (n2 < n7) {
                bl = true;
            }
            return bl;
        }
        switch (n6) {
            case 1: {
                if (n3 == n8) break;
                boolean bl = false;
                if (n3 < n8) {
                    bl = true;
                }
                return bl;
            }
            case 2: {
                n3 += n9 - n4;
                n3 = n8 < 0 ? (n3 -= this.getDaysInMonth(n2, n) + 7) : (n3 += 6);
                int n11 = n3 / 7;
                if (n11 != n8) {
                    boolean bl = false;
                    if (n11 < n8) {
                        bl = true;
                    }
                    return bl;
                }
                if (n4 == n9) break;
                boolean bl = false;
                if (n4 < n9) {
                    bl = true;
                }
                return bl;
            }
            case 4: {
                n8 = Math.abs(n8) - 6;
            }
            case 3: {
                if ((n3 -= (n4 < n9 ? 7 : 0) + n4 - n9) < n8) {
                    return true;
                }
                if (n4 == n9 && n3 < n8 + 7) break;
                return false;
            }
        }
        boolean bl = false;
        if (n5 < n10) {
            bl = true;
        }
        return bl;
    }

    public boolean inDaylightTime(Date date) {
        Calendar calendar = Calendar.getInstance(this);
        calendar.setTime(date);
        boolean bl = false;
        if (calendar.get(16) != 0) {
            bl = true;
        }
        return bl;
    }

    public synchronized int hashCode() {
        int n = 0;
        if (this.useDaylight) {
            n = this.startMonth ^ this.startDay ^ this.startDayOfWeek ^ this.startTime ^ this.endMonth ^ this.endDay ^ this.endDayOfWeek ^ this.endTime;
        }
        return this.rawOffset ^ n;
    }

    public synchronized boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone simpleTimeZone = (SimpleTimeZone)object;
        if (simpleTimeZone.hashCode() != this.hashCode() || !this.getID().equals(simpleTimeZone.getID()) || this.rawOffset != simpleTimeZone.rawOffset || this.useDaylight != simpleTimeZone.useDaylight) {
            return false;
        }
        if (!this.useDaylight) {
            return true;
        }
        boolean bl = false;
        if (this.startYear == simpleTimeZone.startYear && this.startMonth == simpleTimeZone.startMonth && this.startDay == simpleTimeZone.startDay && this.startDayOfWeek == simpleTimeZone.startDayOfWeek && this.startTime == simpleTimeZone.startTime && this.startTimeMode == simpleTimeZone.startTimeMode && this.endMonth == simpleTimeZone.endMonth && this.endDay == simpleTimeZone.endDay && this.endDayOfWeek == simpleTimeZone.endDayOfWeek && this.endTime == simpleTimeZone.endTime && this.endTimeMode == simpleTimeZone.endTimeMode) {
            bl = true;
        }
        return bl;
    }

    public boolean hasSameRules(TimeZone timeZone) {
        if (this == timeZone) {
            return true;
        }
        if (!(timeZone instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone simpleTimeZone = (SimpleTimeZone)timeZone;
        if (simpleTimeZone.hashCode() != this.hashCode() || this.rawOffset != simpleTimeZone.rawOffset || this.useDaylight != simpleTimeZone.useDaylight) {
            return false;
        }
        if (!this.useDaylight) {
            return true;
        }
        boolean bl = false;
        if (this.startYear == simpleTimeZone.startYear && this.startMonth == simpleTimeZone.startMonth && this.startDay == simpleTimeZone.startDay && this.startDayOfWeek == simpleTimeZone.startDayOfWeek && this.startTime == simpleTimeZone.startTime && this.startTimeMode == simpleTimeZone.startTimeMode && this.endMonth == simpleTimeZone.endMonth && this.endDay == simpleTimeZone.endDay && this.endDayOfWeek == simpleTimeZone.endDayOfWeek && this.endTime == simpleTimeZone.endTime && this.endTimeMode == simpleTimeZone.endTimeMode) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        return this.getClass().getName() + "[id=" + this.getID() + ",offset=" + this.rawOffset + ",dstSavings=" + this.dstSavings + ",useDaylight=" + this.useDaylight + (this.useDaylight ? ",startYear=" + this.startYear + ",startMode=" + this.startMode + ",startMonth=" + this.startMonth + ",startDay=" + this.startDay + ",startDayOfWeek=" + this.startDayOfWeek + ",startTime=" + this.startTime + ",startTimeMode=" + this.startTimeMode + ",endMode=" + this.endMode + ",endMonth=" + this.endMonth + ",endDay=" + this.endDay + ",endDayOfWeek=" + this.endDayOfWeek + ",endTime=" + this.endTime + ",endTimeMode=" + this.endTimeMode : "") + ']';
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream == 0) {
            this.dstSavings = 3600000;
            this.endMode = 2;
            this.startMode = 2;
            this.startTimeMode = 0;
            this.endTimeMode = 0;
            this.serialVersionOnStream = 2;
        } else {
            int n = objectInputStream.readInt();
            byte[] byArray = new byte[n];
            objectInputStream.read(byArray, 0, n);
            if (n >= 4) {
                this.startDay = byArray[0];
                this.startDayOfWeek = byArray[1];
                this.endDay = byArray[2];
                this.endDayOfWeek = byArray[3];
            }
        }
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        byte[] byArray = new byte[]{(byte)this.startDay, (byte)this.startDayOfWeek, (byte)this.endDay, (byte)this.endDayOfWeek};
        switch (this.startMode) {
            case 1: {
                this.startDayOfWeek = 1;
            }
            case 3: 
            case 4: {
                this.startDay = (this.startDay + 6) / 7;
            }
        }
        switch (this.endMode) {
            case 1: {
                this.endDayOfWeek = 1;
            }
            case 3: 
            case 4: {
                this.endDay = (this.endDay + 6) / 7;
            }
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(byArray.length);
        objectOutputStream.write(byArray, 0, byArray.length);
    }

    private final /* synthetic */ void this() {
        this.dstSavings = 3600000;
        this.startTimeMode = 0;
        this.endTimeMode = 0;
        this.monthLength = monthArr;
        this.serialVersionOnStream = 2;
    }

    public SimpleTimeZone(int n, String string) {
        this.this();
        this.rawOffset = n;
        this.setID(string);
        this.useDaylight = false;
        this.startYear = 0;
    }

    public SimpleTimeZone(int n, String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.this();
        this.rawOffset = n;
        this.setID(string);
        this.useDaylight = true;
        this.setStartRule(n2, n3, n4, n5);
        this.setEndRule(n6, n7, n8, n9);
        if (n2 == n6) {
            throw new IllegalArgumentException("startMonth and endMonth must be different");
        }
        this.startYear = 0;
    }

    public SimpleTimeZone(int n, String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this(n, string, n2, n3, n4, n5, n6, n7, n8, n9);
        this.dstSavings = n10;
    }

    public SimpleTimeZone(int n, String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        this.this();
        this.rawOffset = n;
        this.setID(string);
        this.useDaylight = true;
        if (n6 < 0 || n6 > 2) {
            throw new IllegalArgumentException("startTimeMode must be one of WALL_TIME, STANDARD_TIME, or UTC_TIME");
        }
        if (n11 < 0 || n11 > 2) {
            throw new IllegalArgumentException("endTimeMode must be one of WALL_TIME, STANDARD_TIME, or UTC_TIME");
        }
        this.startTimeMode = n6;
        this.endTimeMode = n11;
        this.setStartRule(n2, n3, n4, n5);
        this.setEndRule(n7, n8, n9, n10);
        if (n2 == n7) {
            throw new IllegalArgumentException("startMonth and endMonth must be different");
        }
        this.startYear = 0;
        this.dstSavings = n12;
    }
}

