/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class TitledBorder
extends AbstractBorder {
    public static final int DEFAULT_POSITION = 0;
    public static final int ABOVE_TOP = 1;
    public static final int TOP = 2;
    public static final int BELOW_TOP = 3;
    public static final int ABOVE_BOTTOM = 4;
    public static final int BOTTOM = 5;
    public static final int BELOW_BOTTOM = 6;
    public static final int DEFAULT_JUSTIFICATION = 0;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final int LEADING = 4;
    public static final int TRAILING = 5;
    protected static final int EDGE_SPACING = 2;
    protected static final int TEXT_INSET_H = 5;
    protected static final int TEXT_SPACING = 2;
    static final long serialVersionUID = 8012999415147721601L;
    protected String title;
    protected Border border;
    protected int titlePosition;
    protected int titleJustification;
    protected Font titleFont;
    protected Color titleColor;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        Measurements measurements = this.getMeasurements(component);
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        int n7 = n3 - (measurements.outerSpacing.left + measurements.outerSpacing.right);
        int n8 = n4 - (measurements.outerSpacing.top + measurements.outerSpacing.bottom);
        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class BorderPainter {
            private Component c;
            private Border b;
            private int x;
            private int y;
            private int width;
            private int height;

            public void paint(Graphics graphics) {
                if (this.b != null) {
                    this.b.paintBorder(this.c, graphics, this.x, this.y, this.width, this.height);
                }
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private final void paint(Graphics graphics, int n, int n2, int n3, int n4) {
                Shape shape = graphics.getClip();
                try {
                    graphics.clipRect(n, n2, n3, n4);
                    this.paint(graphics);
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    graphics.setClip(shape);
                    throw throwable;
                }
                {
                    Object var8_9 = null;
                    graphics.setClip(shape);
                    return;
                }
            }

            public void paintExcept(Graphics graphics, int n, int n2, int n3, int n4) {
                int n5 = n2 - this.y;
                if (n5 > 0) {
                    this.paint(graphics, this.x, this.y, this.width, n5);
                }
                if ((n5 = n4) > 0) {
                    this.paint(graphics, this.x, n2, n - this.x, n5);
                    this.paint(graphics, n + n3, n2, this.x + this.width - (n + n3), n5);
                }
                if ((n5 = this.height - (n2 - this.y + n4)) > 0) {
                    this.paint(graphics, this.x, this.y + this.height - n5, this.width, n5);
                }
            }

            public BorderPainter(Component component, Border border, int n, int n2, int n3, int n4) {
                this.c = component;
                this.b = border;
                this.x = n;
                this.y = n2;
                this.width = n3;
                this.height = n4;
            }
        }
        BorderPainter borderPainter = new BorderPainter(component, this.getBorder(), n + measurements.outerSpacing.left, n2 + measurements.outerSpacing.top, n7, n8);
        switch (this.getRealTitleJustification(component)) {
            case 1: {
                n6 = n + 2 + 5;
                break;
            }
            case 2: {
                n6 = n + (n7 - measurements.textWidth) / 2;
                break;
            }
            case 3: {
                n6 = n + n7 - (measurements.textWidth + 5);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (this.titlePosition) {
            case 1: {
                n5 = n2 + 2;
                break;
            }
            default: {
                n5 = n2 + measurements.outerSpacing.top + measurements.borderInsets.top - measurements.textAscent + measurements.lineHeight;
                break;
            }
            case 3: {
                n5 = n2 + measurements.outerSpacing.top + measurements.borderInsets.top + 2;
                break;
            }
            case 4: {
                n5 = n2 + n4 - measurements.outerSpacing.bottom - measurements.borderInsets.bottom - 2 - (measurements.textAscent + measurements.textDescent);
                break;
            }
            case 5: 
            case 6: {
                n5 = n2 + n4 - (measurements.textAscent + measurements.textDescent);
            }
        }
        if (measurements.trimmedText == null) {
            borderPainter.paint(graphics);
            return;
        }
        try {
            graphics.setFont(measurements.font);
            graphics.setColor(this.getTitleColor());
            graphics.drawString(measurements.trimmedText, n6, n5 + measurements.textAscent);
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            graphics.setFont(font);
            graphics.setColor(color);
            throw throwable;
        }
        {
            Object var16_17 = null;
            graphics.setFont(font);
            graphics.setColor(color);
            borderPainter.paintExcept(graphics, n6, n5, measurements.textWidth, measurements.textAscent + measurements.textDescent);
        }
    }

    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        return this.getMeasurements(component).getContentInsets(insets);
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public String getTitle() {
        return this.title;
    }

    public Border getBorder() {
        if (this.border != null) {
            return this.border;
        }
        return UIManager.getBorder("TitledBorder.border");
    }

    public int getTitlePosition() {
        return this.titlePosition;
    }

    public int getTitleJustification() {
        return this.titleJustification;
    }

    public Font getTitleFont() {
        if (this.titleFont != null) {
            return this.titleFont;
        }
        return UIManager.getFont("TitledBorder.font");
    }

    public Color getTitleColor() {
        if (this.titleColor != null) {
            return this.titleColor;
        }
        return UIManager.getColor("TitledBorder.titleColor");
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public void setTitlePosition(int n) {
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException();
        }
        this.titlePosition = n;
    }

    public void setTitleJustification(int n) {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException();
        }
        this.titleJustification = n;
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
    }

    public void setTitleColor(Color color) {
        this.titleColor = color;
    }

    public Dimension getMinimumSize(Component component) {
        return this.getMeasurements(component).getMinimumSize();
    }

    protected Font getFont(Component component) {
        Font font = this.getTitleFont();
        if (font != null) {
            return font;
        }
        return new Font("Dialog", 0, 12);
    }

    private final int getRealTitleJustification(Component component) {
        switch (this.titleJustification) {
            case 0: 
            case 4: {
                if (component == null || component.getComponentOrientation().isLeftToRight()) {
                    return 1;
                }
                return 3;
            }
            case 5: {
                if (component == null || component.getComponentOrientation().isLeftToRight()) {
                    return 3;
                }
                return 1;
            }
        }
        return this.titleJustification;
    }

    private final Measurements getMeasurements(Component component) {
        Measurements measurements = new Measurements();
        measurements.font = this.getFont(component);
        FontMetrics fontMetrics = component.getFontMetrics(measurements.font);
        measurements.border = this.getBorder();
        measurements.borderInsets = measurements.border != null ? measurements.border.getBorderInsets(component) : new Insets(0, 0, 0, 0);
        if (this.title != null) {
            measurements.trimmedText = this.title.trim();
            if (measurements.trimmedText.length() == 0) {
                measurements.trimmedText = null;
            }
        }
        if (measurements.trimmedText != null) {
            measurements.textAscent = fontMetrics.getAscent();
            measurements.textDescent = fontMetrics.getDescent() + fontMetrics.getLeading();
            FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), false, false);
            LineMetrics lineMetrics = measurements.font.getLineMetrics(measurements.trimmedText, 0, measurements.trimmedText.length(), fontRenderContext);
            measurements.lineHeight = (int)lineMetrics.getStrikethroughOffset();
            if (measurements.lineHeight == 0) {
                measurements.lineHeight = (int)(0.3333 * (double)measurements.textAscent);
            }
            measurements.textWidth = fontMetrics.stringWidth(measurements.trimmedText) + 3;
        } else {
            measurements.textAscent = 0;
            measurements.textDescent = 0;
        }
        measurements.innerSpacing = new Insets(2, 2, 2, 2);
        measurements.outerSpacing = new Insets(2, 2, 2, 2);
        switch (this.titlePosition) {
            case 1: {
                measurements.outerSpacing.top += measurements.textAscent + measurements.textDescent + 2;
                break;
            }
            case 2: {
                measurements.outerSpacing.top += measurements.textDescent + measurements.lineHeight;
                measurements.innerSpacing.top += measurements.textAscent - measurements.lineHeight;
                break;
            }
            case 3: {
                measurements.innerSpacing.top += measurements.textAscent + measurements.textDescent + 2;
                break;
            }
            case 4: {
                measurements.innerSpacing.bottom += measurements.textAscent + measurements.textDescent + 2;
                break;
            }
            case 5: {
                measurements.innerSpacing.bottom += Math.max(measurements.textAscent - measurements.lineHeight, 0);
                measurements.outerSpacing.bottom += measurements.textDescent + measurements.lineHeight;
                break;
            }
            case 6: {
                measurements.outerSpacing.bottom += measurements.textAscent + measurements.textDescent;
                break;
            }
            default: {
                measurements.outerSpacing.top += measurements.textAscent;
            }
        }
        return measurements;
    }

    public TitledBorder(String string) {
        this(null, string, 4, 2, null, null);
    }

    public TitledBorder(Border border) {
        this(border, "", 4, 2, null, null);
    }

    public TitledBorder(Border border, String string) {
        this(border, string, 4, 2, null, null);
    }

    public TitledBorder(Border border, String string, int n, int n2) {
        this(border, string, n, n2, null, null);
    }

    public TitledBorder(Border border, String string, int n, int n2, Font font) {
        this(border, string, n, n2, font, null);
    }

    public TitledBorder(Border border, String string, int n, int n2, Font font, Color color) {
        this.border = border;
        this.title = string;
        this.setTitleJustification(n);
        this.setTitlePosition(n2);
        this.titleFont = font;
        this.titleColor = color;
    }

    private static class Measurements {
        Font font;
        int textAscent;
        int textDescent;
        int lineHeight;
        String trimmedText;
        int textWidth;
        Border border;
        Insets outerSpacing;
        Insets borderInsets;
        Insets innerSpacing;

        public Insets getContentInsets(Insets insets) {
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            insets.left = this.outerSpacing.left + this.borderInsets.left + this.innerSpacing.left;
            insets.right = this.outerSpacing.right + this.borderInsets.right + this.innerSpacing.right;
            insets.top = this.outerSpacing.top + this.borderInsets.top + this.innerSpacing.top;
            insets.bottom = this.outerSpacing.bottom + this.borderInsets.bottom + this.innerSpacing.bottom;
            return insets;
        }

        public Dimension getMinimumSize() {
            Insets insets = this.getContentInsets(null);
            int n = Math.max(insets.left + insets.right, this.textWidth + 10);
            return new Dimension(n, insets.top + insets.bottom);
        }

        private Measurements() {
        }
    }
}

