/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.core;

import java.util.Iterator;
import java.util.Set;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.spi.MidiDeviceProvider;
import javax.sound.midi.spi.MidiFileReader;
import javax.sound.midi.spi.MidiFileWriter;
import javax.sound.midi.spi.SoundbankReader;
import org.tritonus.core.TInit;
import org.tritonus.share.ArraySet;
import org.tritonus.share.TDebug;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TMidiConfig {
    private static Set sm_midiDeviceProviders = null;
    private static Set sm_midiFileReaders = null;
    private static Set sm_midiFileWriters = null;
    private static Set sm_soundbankReaders = null;
    private static MidiDevice.Info sm_defaultMidiDeviceInfo = null;
    private static MidiDevice.Info sm_defaultSequencerInfo = null;
    private static MidiDevice.Info sm_defaultSynthesizerInfo = null;
    static /* synthetic */ Class class$javax$sound$midi$spi$MidiDeviceProvider;
    static /* synthetic */ Class class$javax$sound$midi$spi$MidiFileReader;
    static /* synthetic */ Class class$javax$sound$midi$spi$MidiFileWriter;
    static /* synthetic */ Class class$javax$sound$midi$spi$SoundbankReader;

    private static final void init() {
        TMidiConfig.getMidiDeviceProvidersImpl();
        TMidiConfig.getMidiFileReadersImpl();
        TMidiConfig.getMidiFileWritersImpl();
        TMidiConfig.getSoundbankReadersImpl();
    }

    private static final void registerMidiDeviceProviders() {
        TInit.ProviderRegistrationAction providerRegistrationAction = null;
        providerRegistrationAction = new TInit.ProviderRegistrationAction(){

            public final void register(Object object) throws Exception {
                MidiDeviceProvider midiDeviceProvider = (MidiDeviceProvider)object;
                TMidiConfig.addMidiDeviceProvider(midiDeviceProvider);
            }
        };
        Class clazz = class$javax$sound$midi$spi$MidiDeviceProvider;
        if (clazz == null) {
            clazz = class$javax$sound$midi$spi$MidiDeviceProvider = TMidiConfig.class("[Ljavax.sound.midi.spi.MidiDeviceProvider;", false);
        }
        TInit.registerClasses(clazz, providerRegistrationAction);
    }

    private static final void registerMidiFileReaders() {
        TInit.ProviderRegistrationAction providerRegistrationAction = null;
        providerRegistrationAction = new TInit.ProviderRegistrationAction(){

            public final void register(Object object) throws Exception {
                MidiFileReader midiFileReader = (MidiFileReader)object;
                TMidiConfig.addMidiFileReader(midiFileReader);
            }
        };
        Class clazz = class$javax$sound$midi$spi$MidiFileReader;
        if (clazz == null) {
            clazz = class$javax$sound$midi$spi$MidiFileReader = TMidiConfig.class("[Ljavax.sound.midi.spi.MidiFileReader;", false);
        }
        TInit.registerClasses(clazz, providerRegistrationAction);
    }

    private static final void registerMidiFileWriters() {
        TInit.ProviderRegistrationAction providerRegistrationAction = null;
        providerRegistrationAction = new TInit.ProviderRegistrationAction(){

            public final void register(Object object) throws Exception {
                MidiFileWriter midiFileWriter = (MidiFileWriter)object;
                TMidiConfig.addMidiFileWriter(midiFileWriter);
            }
        };
        Class clazz = class$javax$sound$midi$spi$MidiFileWriter;
        if (clazz == null) {
            clazz = class$javax$sound$midi$spi$MidiFileWriter = TMidiConfig.class("[Ljavax.sound.midi.spi.MidiFileWriter;", false);
        }
        TInit.registerClasses(clazz, providerRegistrationAction);
    }

    private static final void registerSoundbankReaders() {
        TInit.ProviderRegistrationAction providerRegistrationAction = null;
        providerRegistrationAction = new TInit.ProviderRegistrationAction(){

            public final void register(Object object) throws Exception {
                SoundbankReader soundbankReader = (SoundbankReader)object;
                TMidiConfig.addSoundbankReader(soundbankReader);
            }
        };
        Class clazz = class$javax$sound$midi$spi$SoundbankReader;
        if (clazz == null) {
            clazz = class$javax$sound$midi$spi$SoundbankReader = TMidiConfig.class("[Ljavax.sound.midi.spi.SoundbankReader;", false);
        }
        TInit.registerClasses(clazz, providerRegistrationAction);
    }

    public static synchronized void addMidiDeviceProvider(MidiDeviceProvider midiDeviceProvider) {
        TMidiConfig.getMidiDeviceProvidersImpl().add(midiDeviceProvider);
        if (TMidiConfig.getDefaultMidiDeviceInfo() == null || TMidiConfig.getDefaultSynthesizerInfo() == null || TMidiConfig.getDefaultSequencerInfo() == null) {
            MidiDevice.Info[] infoArray = midiDeviceProvider.getDeviceInfo();
            int n = 0;
            while (n < infoArray.length) {
                MidiDevice midiDevice;
                block11: {
                    midiDevice = null;
                    try {
                        midiDevice = midiDeviceProvider.getDevice(infoArray[n]);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (!TDebug.TraceAllExceptions) break block11;
                        TDebug.out(illegalArgumentException);
                    }
                }
                if (midiDevice instanceof Synthesizer) {
                    if (TMidiConfig.getDefaultSynthesizerInfo() == null) {
                        sm_defaultSynthesizerInfo = infoArray[n];
                    }
                } else if (midiDevice instanceof Sequencer) {
                    if (TMidiConfig.getDefaultSequencerInfo() == null) {
                        sm_defaultSequencerInfo = infoArray[n];
                    }
                } else if (TMidiConfig.getDefaultMidiDeviceInfo() == null) {
                    sm_defaultMidiDeviceInfo = infoArray[n];
                }
                ++n;
            }
        }
    }

    public static synchronized void removeMidiDeviceProvider(MidiDeviceProvider midiDeviceProvider) {
        TMidiConfig.getMidiDeviceProvidersImpl().remove(midiDeviceProvider);
    }

    public static synchronized Iterator getMidiDeviceProviders() {
        return TMidiConfig.getMidiDeviceProvidersImpl().iterator();
    }

    private static final synchronized Set getMidiDeviceProvidersImpl() {
        if (sm_midiDeviceProviders == null) {
            sm_midiDeviceProviders = new ArraySet();
            TMidiConfig.registerMidiDeviceProviders();
        }
        return sm_midiDeviceProviders;
    }

    public static synchronized void addMidiFileReader(MidiFileReader midiFileReader) {
        if (TDebug.TraceMidiConfig) {
            TDebug.out("TMidiConfig.addMidiFileReader(): adding " + midiFileReader);
        }
        TMidiConfig.getMidiFileReadersImpl().add(midiFileReader);
        if (TDebug.TraceMidiConfig) {
            TDebug.out("TMidiConfig.addMidiFileReader(): size " + sm_midiFileReaders.size());
        }
    }

    public static synchronized void removeMidiFileReader(MidiFileReader midiFileReader) {
        TMidiConfig.getMidiFileReadersImpl().remove(midiFileReader);
    }

    public static synchronized Iterator getMidiFileReaders() {
        return TMidiConfig.getMidiFileReadersImpl().iterator();
    }

    private static final synchronized Set getMidiFileReadersImpl() {
        if (sm_midiFileReaders == null) {
            sm_midiFileReaders = new ArraySet();
            TMidiConfig.registerMidiFileReaders();
        }
        return sm_midiFileReaders;
    }

    public static synchronized void addMidiFileWriter(MidiFileWriter midiFileWriter) {
        TMidiConfig.getMidiFileWritersImpl().add(midiFileWriter);
    }

    public static synchronized void removeMidiFileWriter(MidiFileWriter midiFileWriter) {
        TMidiConfig.getMidiFileWritersImpl().remove(midiFileWriter);
    }

    public static synchronized Iterator getMidiFileWriters() {
        return TMidiConfig.getMidiFileWritersImpl().iterator();
    }

    private static final synchronized Set getMidiFileWritersImpl() {
        if (sm_midiFileWriters == null) {
            sm_midiFileWriters = new ArraySet();
            TMidiConfig.registerMidiFileWriters();
        }
        return sm_midiFileWriters;
    }

    public static synchronized void addSoundbankReader(SoundbankReader soundbankReader) {
        TMidiConfig.getSoundbankReadersImpl().add(soundbankReader);
    }

    public static synchronized void removeSoundbankReader(SoundbankReader soundbankReader) {
        TMidiConfig.getSoundbankReadersImpl().remove(soundbankReader);
    }

    public static synchronized Iterator getSoundbankReaders() {
        return TMidiConfig.getSoundbankReadersImpl().iterator();
    }

    private static final synchronized Set getSoundbankReadersImpl() {
        if (sm_soundbankReaders == null) {
            sm_soundbankReaders = new ArraySet();
            TMidiConfig.registerSoundbankReaders();
        }
        return sm_soundbankReaders;
    }

    public static MidiDevice.Info getDefaultMidiDeviceInfo() {
        return sm_defaultMidiDeviceInfo;
    }

    public static MidiDevice.Info getDefaultSynthesizerInfo() {
        return sm_defaultSynthesizerInfo;
    }

    public static MidiDevice.Info getDefaultSequencerInfo() {
        return sm_defaultSequencerInfo;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private TMidiConfig() {
    }

    static {
        TMidiConfig.init();
    }
}

