/*
 * Decompiled with CFR 0.152.
 */
package jmapps.rtp;

import com.sun.media.ui.TabControl;
import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.media.control.BufferControl;
import javax.media.rtp.SessionManager;
import jmapps.rtp.PanelOverallRtpStats;
import jmapps.rtp.PanelParticipants;
import jmapps.ui.JMDialog;
import jmapps.ui.JMPanel;

public class SessionControlDialog
extends JMDialog {
    private SessionManager mngrSession;

    public SessionControlDialog(Frame frame, SessionManager mngrSession) {
        super(frame, JMFI18N.getResource("jmstudio.rtpsessionctrl.title"), false);
        this.mngrSession = mngrSession;
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout(6, 6));
        JMPanel panelContent = new JMPanel(new BorderLayout(6, 6));
        panelContent.setEmptyBorder(6, 6, 6, 6);
        this.add((Component)panelContent, "Center");
        TabControl tabControl = new TabControl(0);
        panelContent.add((Component)tabControl, "Center");
        JMPanel panel = this.createOverallStatsPanel();
        tabControl.addPage(panel, JMFI18N.getResource("jmstudio.rtpsessionctrl.panel.overall"));
        panel = this.createParticipantsPanel();
        tabControl.addPage(panel, JMFI18N.getResource("jmstudio.rtpsessionctrl.panel.participants"));
        panel = this.createBufferControlPanel();
        tabControl.addPage(panel, JMFI18N.getResource("jmstudio.rtpsessionctrl.panel.bufferctrl"));
        panel = new JMPanel(new BorderLayout(6, 6));
        panelContent.add((Component)panel, "South");
        JMPanel panelButtons = this.createButtonPanel(new String[]{JMDialog.ACTION_CLOSE});
        panel.add((Component)panelButtons, "East");
        this.pack();
        this.setResizable(false);
    }

    private JMPanel createOverallStatsPanel() {
        PanelOverallRtpStats panelStats = new PanelOverallRtpStats(this.mngrSession);
        return panelStats;
    }

    private JMPanel createParticipantsPanel() {
        PanelParticipants panelParticipants = new PanelParticipants(this.mngrSession);
        return panelParticipants;
    }

    private JMPanel createBufferControlPanel() {
        Component component = null;
        JMPanel panelBufferControl = new JMPanel(new FlowLayout());
        BufferControl bufferControl = (BufferControl)this.mngrSession.getControl("javax.media.control.BufferControl");
        if (bufferControl != null) {
            component = bufferControl.getControlComponent();
        }
        if (component != null) {
            panelBufferControl.add(component);
        }
        return panelBufferControl;
    }

    public void actionPerformed(ActionEvent event) {
        String strAction = event.getActionCommand();
        if (strAction.equals(JMDialog.ACTION_CLOSE)) {
            this.setAction(JMDialog.ACTION_CLOSE);
            this.setVisible(false);
        }
    }

    public void windowClosing(WindowEvent event) {
        this.setAction(JMDialog.ACTION_CLOSE);
        this.setVisible(false);
    }
}

