# $Id: jitworkaround.tcl 1024 2007-03-07 15:58:27Z sergei $

###############################################################################
# JIT workaround: when receving <presence/> stanza with name attribute and
# roster item doesn't have name, fill the name
#

namespace eval jitworkaround {}

proc jitworkaround::process_subscribed {connid from type x args} {
    variable names

    if {$type != "subscribed"} return

    set newname ""
    foreach {opt val} $args {
	switch -- $opt {
	    -name { set newname $val }
	}
    }

    if {$newname == ""} return

    set jid [roster::find_jid $connid $from]

    if {$jid == ""} {
	set names($connid,$from) $newname
    } elseif {[roster::itemconfig $connid $jid -name] == ""} {
	roster::itemconfig $connid $jid -name $newname
	roster::send_item $connid $jid
	::redraw_roster
    }
}

hook::add client_presence_hook \
    [namespace current]::jitworkaround::process_subscribed

###############################################################################

proc jitworkaround::set_received_name {connid jid name groups subsc ask} {
    variable names

    if {$subsc == "remove"} return

    if {[info exists names($connid,$jid)]} {
	if {[roster::itemconfig $connid $jid -name] == ""} {
	    roster::itemconfig $connid $jid -name $names($connid,$jid)
	    roster::send_item $connid $jid
	}
	unset names($connid,$jid)
    }
}

hook::add roster_item_hook \
    [namespace current]::jitworkaround::set_received_name 60
hook::add roster_push_hook \
    [namespace current]::jitworkaround::set_received_name 60

###############################################################################

