/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.igoweb.igoweb.client.CChannel;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.swing.ChatPane;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.swing.GCLayout;

public class ModerationPane
extends ChatPane {
    private static final SimpleAttributeSet SELECTED_ATTRIBUTE = new SimpleAttributeSet();
    private static final SimpleAttributeSet NONSELECTED_ATTRIBUTE = new SimpleAttributeSet();
    private static final SimpleAttributeSet SENT_ATTRIBUTE;
    private static final String SAVED_MODERATION_PANES_PREFIX = "a";
    private JTabbedPane tabPane;
    private final LinkedList<CChannel.Chat> pausedComments = new LinkedList();
    private final LinkedList<PosChatPair> posChats = new LinkedList();
    private static final int MAX_BUFFERED_COMMENTS = 100;
    private final JCheckBox pauseBut = new JCheckBox(Defs.getString(-903340495));
    private final JButton acceptBut = new JButton(Defs.getString(-903340541));
    private Position selectionStart;
    private Position selectionEnd;
    private boolean dirty = false;

    public ModerationPane(Client client, CChannel channel) {
        super(client, channel, 100);
        this.setShowRanks(true);
        this.acceptBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ModerationPane.this.acceptPressed();
            }
        });
        this.acceptBut.setEnabled(false);
        this.pauseBut.setSelected(false);
        this.pauseBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ModerationPane.this.pausePressed();
            }
        });
        this.getTextPane().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                ModerationPane.this.handleTextPaneClick(event);
            }
        });
    }

    private void setTabPane(JTabbedPane jtp) {
        this.tabPane = jtp;
        jtp.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                int curIndex = ModerationPane.this.tabPane.getSelectedIndex();
                if (curIndex >= 0) {
                    ModerationPane.this.tabPane.setBackgroundAt(curIndex, null);
                }
            }
        });
    }

    public static JComponent buildModerationTabs(Client client, JComponent mainChatPane, CChannel channel) {
        JTabbedPane jtp = new JTabbedPane();
        jtp.add(Defs.getString(-903340497), mainChatPane);
        String chanKey = SAVED_MODERATION_PANES_PREFIX + channel.id;
        ModerationPane mp = (ModerationPane)client.objects.get(chanKey);
        if (mp == null) {
            mp = new ModerationPane(client, channel);
            mp.setTabPane(jtp);
            client.objects.put(chanKey, mp);
        } else {
            mp.setTabPane(jtp);
            mp.restart();
        }
        JPanel panel = new JPanel(new GCLayout());
        panel.add("xSpan=2,xGrow=t,yGrow=t", mp);
        panel.add("x=0,xSpan=1,yGrow=f", mp.pauseBut);
        panel.add("xGrow=f", mp.acceptBut);
        jtp.add(Defs.getString(-903340496), panel);
        return jtp;
    }

    @Override
    protected void handleChat(CChannel.Chat chat) {
        int ioc;
        if (!chat.moderated || chat.announcement) {
            return;
        }
        if (this.tabPane != null && this.tabPane.getSelectedComponent() != this.getParent() && (ioc = this.tabPane.indexOfComponent(this.getParent())) >= 0) {
            this.tabPane.setBackgroundAt(ioc, UIManager.getColor("org.igoweb.selTextBg"));
        }
        if (this.pauseBut.isSelected()) {
            if (this.pausedComments.isEmpty()) {
                this.pauseBut.setFont(this.pauseBut.getFont().deriveFont(1));
            }
            this.pausedComments.add(chat);
            if (this.pausedComments.size() > 100) {
                this.pausedComments.removeFirst();
            }
        } else {
            this.dirty = true;
            int delta = -1;
            if (this.selectionStart != null) {
                delta = this.selectionEnd.getOffset() - this.selectionStart.getOffset();
            }
            this.append(chat);
            try {
                Position newStart;
                if (this.posChats.isEmpty()) {
                    newStart = this.getDocument().getStartPosition();
                } else {
                    int newOff;
                    for (newOff = this.getDocument().getLength() - (chat.text.length() + chat.user.name.length()); newOff > 0 && this.getDocument().getText(newOff, 1).charAt(0) != '\n'; --newOff) {
                    }
                    newStart = this.getDocument().createPosition(newOff == 0 ? 0 : newOff + 1);
                }
                this.posChats.add(new PosChatPair(newStart, chat));
            }
            catch (BadLocationException excep) {
                throw new RuntimeException(excep);
            }
            while (this.posChats.size() > 1 && this.posChats.get((int)1).position.getOffset() == this.posChats.get((int)0).position.getOffset()) {
                this.posChats.removeFirst();
            }
            if (delta >= 0 && delta != this.selectionEnd.getOffset() - this.selectionStart.getOffset()) {
                try {
                    this.selectionEnd = this.getDocument().createPosition(this.selectionStart.getOffset() + delta);
                }
                catch (BadLocationException excep) {
                    throw new RuntimeException(excep.toString());
                }
            }
            if (this.selectionStart != null && this.selectionStart.getOffset() == this.selectionEnd.getOffset()) {
                this.selectionStart = null;
                this.selectionEnd = null;
                this.acceptBut.setEnabled(false);
            }
        }
    }

    private void acceptPressed() {
        if (this.selectionStart != null) {
            int start = this.selectionStart.getOffset();
            int len = this.selectionEnd.getOffset() - start;
            if (len < 4) {
                return;
            }
            CChannel.Chat chat = null;
            for (PosChatPair posChat : this.posChats) {
                if (start < posChat.position.getOffset()) break;
                chat = posChat.chat;
            }
            if (chat == null) {
                return;
            }
            this.getDocument().setCharacterAttributes(start, len, SENT_ATTRIBUTE, false);
            this.selectionStart = null;
            this.selectionEnd = null;
            this.getChannel().sendModeratedComment(chat.user.name, chat.text);
            this.acceptBut.setEnabled(false);
        }
    }

    private void pausePressed() {
        if (!this.pauseBut.isSelected()) {
            this.pauseBut.setFont(this.pauseBut.getFont().deriveFont(0));
            Iterator iter = this.pausedComments.iterator();
            while (iter.hasNext()) {
                this.handleChat((CChannel.Chat)iter.next());
            }
            this.pausedComments.clear();
        }
    }

    private void handleTextPaneClick(MouseEvent event) {
        int start;
        int clickOffset = this.getTextPane().viewToModel(event.getPoint());
        Element paragraph = this.getDocument().getParagraphElement(clickOffset);
        if (this.selectionStart != null && (start = this.selectionStart.getOffset()) != paragraph.getStartOffset()) {
            this.getDocument().setCharacterAttributes(start, this.selectionEnd.getOffset() - start, NONSELECTED_ATTRIBUTE, false);
            this.selectionStart = null;
            this.selectionEnd = null;
        }
        if (StyleConstants.getForeground(SENT_ATTRIBUTE).equals(StyleConstants.getForeground(this.getDocument().getCharacterElement(clickOffset).getAttributes()))) {
            this.acceptBut.setEnabled(false);
            return;
        }
        if (this.selectionStart == null) {
            int paraStart = paragraph.getStartOffset();
            int paraEnd = paragraph.getEndOffset();
            try {
                this.selectionStart = this.getDocument().createPosition(paraStart);
                this.selectionEnd = this.getDocument().createPosition(paraEnd);
            }
            catch (BadLocationException excep) {
                throw new RuntimeException(excep.toString());
            }
            this.getDocument().setCharacterAttributes(paraStart, paraEnd - paraStart, SELECTED_ATTRIBUTE, false);
        }
        this.acceptBut.setEnabled(true);
        if (event.getClickCount() == 2) {
            this.acceptPressed();
        }
    }

    @Override
    protected void handleChannelEvent(Event event) {
        if (event.type == 16) {
            this.client.objects.remove(SAVED_MODERATION_PANES_PREFIX + this.getChannel().id);
        } else {
            super.handleChannelEvent(event);
        }
    }

    private void restart() {
        if (this.dirty) {
            this.append(" ");
        }
        if (!this.pausedComments.isEmpty() && this.pausedComments.getLast().user != null) {
            this.handleChat(new CChannel.Chat(null, null, false, true));
        }
        this.dirty = false;
    }

    static {
        StyleConstants.setBackground(SELECTED_ATTRIBUTE, UIManager.getColor("org.igoweb.selTextBg"));
        StyleConstants.setBackground(NONSELECTED_ATTRIBUTE, UIManager.getColor("org.igoweb.outputBg"));
        SENT_ATTRIBUTE = new SimpleAttributeSet(NONSELECTED_ATTRIBUTE);
        StyleConstants.setForeground(SENT_ATTRIBUTE, UIManager.getColor("org.igoweb.stdBg").darker());
    }

    private static class PosChatPair {
        public final Position position;
        public final CChannel.Chat chat;

        public PosChatPair(Position position, CChannel.Chat chat) {
            this.position = position;
            this.chat = chat;
        }
    }
}

