/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import org.sablecc.sablecc.Cast;
import org.sablecc.sablecc.MacroExpander;
import org.sablecc.sablecc.ResolveAstIds;
import org.sablecc.sablecc.TypedLinkedList;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.AAstAlt;
import org.sablecc.sablecc.node.AAstProd;
import org.sablecc.sablecc.node.AElem;
import org.sablecc.sablecc.node.APlusUnOp;
import org.sablecc.sablecc.node.AProductions;
import org.sablecc.sablecc.node.AQMarkUnOp;
import org.sablecc.sablecc.node.AStarUnOp;

public class GenAlts
extends DepthFirstAdapter {
    private MacroExpander macros;
    private ResolveAstIds ast_ids;
    private File pkgDir;
    private String pkgName;
    private List elemList;
    private String currentProd;
    ElemInfo info;

    public GenAlts(ResolveAstIds ast_ids) {
        this.ast_ids = ast_ids;
        try {
            this.macros = new MacroExpander(new InputStreamReader(this.getClass().getResourceAsStream("alternatives.txt")));
        }
        catch (IOException e) {
            throw new RuntimeException("unable to open alternatives.txt.");
        }
        this.pkgDir = new File(ast_ids.astIds.pkgDir, "node");
        String string = this.pkgName = ast_ids.astIds.pkgName.equals("") ? "node" : ast_ids.astIds.pkgName + ".node";
        if (!this.pkgDir.exists() && !this.pkgDir.mkdir()) {
            throw new RuntimeException("Unable to create " + this.pkgDir.getAbsolutePath());
        }
    }

    @Override
    public void inAAstProd(AAstProd node) {
        this.currentProd = (String)this.ast_ids.ast_names.get(node);
    }

    @Override
    public void inAAstAlt(AAstAlt node) {
        this.elemList = new TypedLinkedList(ElemInfoCast.instance);
    }

    @Override
    public void caseAProductions(AProductions node) {
    }

    @Override
    public void inAElem(AElem node) {
        this.info = new ElemInfo();
        this.info.name = (String)this.ast_ids.ast_names.get(node);
        this.info.type = (String)this.ast_ids.ast_elemTypes.get(node);
        this.info.operator = 0;
        if (node.getUnOp() != null) {
            node.getUnOp().apply(new DepthFirstAdapter(){

                @Override
                public void caseAStarUnOp(AStarUnOp node) {
                    GenAlts.this.info.operator = 1;
                }

                @Override
                public void caseAQMarkUnOp(AQMarkUnOp node) {
                    GenAlts.this.info.operator = 2;
                }

                @Override
                public void caseAPlusUnOp(APlusUnOp node) {
                    GenAlts.this.info.operator = 3;
                }
            });
        }
        this.elemList.add(this.info);
        this.info = null;
    }

    @Override
    public void outAAstAlt(AAstAlt node) {
        BufferedWriter file;
        String name = (String)this.ast_ids.ast_names.get(node);
        try {
            file = new BufferedWriter(new FileWriter(new File(this.pkgDir, name + ".java")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, name + ".java").getAbsolutePath());
        }
        try {
            Iterator i;
            ElemInfo info2;
            boolean hasList = false;
            for (ElemInfo info2 : this.elemList) {
                if (info2 == null) continue;
                switch (info2.operator) {
                    case 1: 
                    case 3: {
                        hasList = true;
                    }
                }
            }
            this.macros.apply(file, "AlternativeHeader1", new String[]{this.pkgName});
            if (hasList) {
                this.macros.apply(file, "AlternativeHeaderList", new String[0]);
            }
            this.macros.apply(file, "AlternativeHeader2", new String[]{this.ast_ids.astIds.pkgName.equals("") ? "analysis" : this.ast_ids.astIds.pkgName + ".analysis", name, this.currentProd});
            for (ElemInfo info2 : this.elemList) {
                if (info2 == null) continue;
                switch (info2.operator) {
                    case 0: 
                    case 2: {
                        this.macros.apply(file, "NodeElement", new String[]{info2.type, GenAlts.nodeName(info2.name)});
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.macros.apply(file, "ListElement", new String[]{info2.type, GenAlts.nodeName(info2.name)});
                    }
                }
            }
            this.macros.apply(file, "ConstructorHeader", new String[]{name});
            this.macros.apply(file, "ConstructorBodyHeader", null);
            this.macros.apply(file, "ConstructorBodyTail", null);
            if (this.elemList.size() > 0) {
                this.macros.apply(file, "ConstructorHeader", new String[]{name});
                i = this.elemList.iterator();
                while (i.hasNext()) {
                    info2 = (ElemInfo)i.next();
                    if (info2 == null) continue;
                    switch (info2.operator) {
                        case 0: 
                        case 2: {
                            this.macros.apply(file, "ConstructorHeaderDeclNode", new String[]{info2.type, GenAlts.nodeName(info2.name), i.hasNext() ? "," : ""});
                            break;
                        }
                        case 1: 
                        case 3: {
                            this.macros.apply(file, "ConstructorHeaderDeclList", new String[]{info2.type, GenAlts.nodeName(info2.name), i.hasNext() ? "," : ""});
                        }
                    }
                }
                this.macros.apply(file, "ConstructorBodyHeader", null);
                for (ElemInfo info2 : this.elemList) {
                    if (info2 == null) continue;
                    switch (info2.operator) {
                        case 0: 
                        case 2: {
                            this.macros.apply(file, "ConstructorBodyNode", new String[]{info2.name, GenAlts.nodeName(info2.name)});
                            break;
                        }
                        case 1: 
                        case 3: {
                            this.macros.apply(file, "ConstructorBodyList", new String[]{info2.name, GenAlts.nodeName(info2.name)});
                        }
                    }
                }
                this.macros.apply(file, "ConstructorBodyTail", null);
            }
            this.macros.apply(file, "CloneHeader", new String[]{name});
            i = this.elemList.iterator();
            while (i.hasNext()) {
                info2 = (ElemInfo)i.next();
                if (info2 == null) continue;
                switch (info2.operator) {
                    case 0: 
                    case 2: {
                        this.macros.apply(file, "CloneBodyNode", new String[]{info2.type, GenAlts.nodeName(info2.name), i.hasNext() ? "," : ""});
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.macros.apply(file, "CloneBodyList", new String[]{GenAlts.nodeName(info2.name), i.hasNext() ? "," : ""});
                    }
                }
            }
            this.macros.apply(file, "CloneTail", null);
            this.macros.apply(file, "Apply", new String[]{name});
            for (ElemInfo info2 : this.elemList) {
                if (info2 == null) continue;
                switch (info2.operator) {
                    case 0: 
                    case 2: {
                        this.macros.apply(file, "GetSetNode", new String[]{info2.type, info2.name, GenAlts.nodeName(info2.name)});
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.macros.apply(file, "GetSetList", new String[]{info2.name, GenAlts.nodeName(info2.name), info2.type});
                    }
                }
            }
            this.macros.apply(file, "ToStringHeader", null);
            for (ElemInfo info2 : this.elemList) {
                if (info2 == null) continue;
                switch (info2.operator) {
                    case 0: 
                    case 2: {
                        this.macros.apply(file, "ToStringBodyNode", new String[]{GenAlts.nodeName(info2.name)});
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.macros.apply(file, "ToStringBodyList", new String[]{GenAlts.nodeName(info2.name)});
                    }
                }
            }
            this.macros.apply(file, "ToStringTail", null);
            this.macros.apply(file, "RemoveChildHeader", null);
            for (ElemInfo info2 : this.elemList) {
                if (info2 == null) continue;
                switch (info2.operator) {
                    case 0: 
                    case 2: {
                        this.macros.apply(file, "RemoveChildNode", new String[]{GenAlts.nodeName(info2.name)});
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.macros.apply(file, "RemoveChildList", new String[]{GenAlts.nodeName(info2.name)});
                    }
                }
            }
            this.macros.apply(file, "RemoveChildTail", null);
            this.macros.apply(file, "ReplaceChildHeader", null);
            for (ElemInfo info2 : this.elemList) {
                if (info2 == null) continue;
                switch (info2.operator) {
                    case 0: 
                    case 2: {
                        this.macros.apply(file, "ReplaceChildNode", new String[]{GenAlts.nodeName(info2.name), info2.name, info2.type});
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.macros.apply(file, "ReplaceChildList", new String[]{GenAlts.nodeName(info2.name), info2.type});
                    }
                }
            }
            this.macros.apply(file, "ReplaceChildTail", null);
            this.macros.apply(file, "AlternativeTail", null);
        }
        catch (IOException e) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, name + ".java").getAbsolutePath());
        }
        try {
            file.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.elemList = null;
    }

    public static String nodeName(String s) {
        StringBuffer result = new StringBuffer(s);
        if (result.length() > 0) {
            result.setCharAt(0, Character.toLowerCase(result.charAt(0)));
        }
        return result.toString();
    }

    private static class ElemInfoCast
    implements Cast {
        public static final ElemInfoCast instance = new ElemInfoCast();

        private ElemInfoCast() {
        }

        @Override
        public Object cast(Object o) {
            return (ElemInfo)o;
        }
    }

    private static class ElemInfo {
        static final int NONE = 0;
        static final int STAR = 1;
        static final int QMARK = 2;
        static final int PLUS = 3;
        String name;
        String type;
        int operator;

        private ElemInfo() {
        }
    }
}

