/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.canvas;

import java.awt.Point;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import org.diylc.common.IPlugInPort;

class CanvasTargetListener
implements DropTargetListener {
    private IPlugInPort presenter;
    private Point currentPoint = null;
    private boolean lastAccept;

    public CanvasTargetListener(IPlugInPort iPlugInPort) {
        this.presenter = iPlugInPort;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.getLocation().equals(this.currentPoint)) {
            if (this.lastAccept) {
                dropTargetDragEvent.acceptDrag(3);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
            return;
        }
        try {
            this.currentPoint = dropTargetDragEvent.getLocation();
            if (this.presenter.dragOver(this.currentPoint)) {
                dropTargetDragEvent.acceptDrag(3);
                this.lastAccept = true;
            } else {
                dropTargetDragEvent.rejectDrag();
                this.lastAccept = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            dropTargetDragEvent.rejectDrag();
            this.lastAccept = false;
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.presenter.dragEnded(dropTargetDropEvent.getLocation());
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        this.presenter.dragActionChanged(dropTargetDragEvent.getDropAction());
    }
}

