/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UIManager
implements Serializable {
    private static final long serialVersionUID = -5547433830339189365L;
    static LookAndFeelInfo[] installed = new LookAndFeelInfo[]{new LookAndFeelInfo("Metal", "javax.swing.plaf.metal.MetalLookAndFeel"), new LookAndFeelInfo("GNU", "gnu.javax.swing.plaf.gnu.GNULookAndFeel")};
    static LookAndFeel[] auxLookAndFeels;
    static LookAndFeel currentLookAndFeel;
    static UIDefaults currentUIDefaults;
    static UIDefaults userUIDefaults;
    static PropertyChangeSupport listeners;
    static /* synthetic */ Class class$javax$swing$UIManager;

    public static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        listeners.removePropertyChangeListener(propertyChangeListener);
    }

    public static PropertyChangeListener[] getPropertyChangeListeners() {
        return listeners.getPropertyChangeListeners();
    }

    public static void addAuxiliaryLookAndFeel(LookAndFeel lookAndFeel) {
        if (lookAndFeel == null) {
            throw new NullPointerException("Null 'laf' argument.");
        }
        if (auxLookAndFeels == null) {
            auxLookAndFeels = new LookAndFeel[1];
            UIManager.auxLookAndFeels[0] = lookAndFeel;
            return;
        }
        LookAndFeel[] lookAndFeelArray = new LookAndFeel[auxLookAndFeels.length + 1];
        System.arraycopy(auxLookAndFeels, 0, lookAndFeelArray, 0, auxLookAndFeels.length);
        auxLookAndFeels = lookAndFeelArray;
        UIManager.auxLookAndFeels[UIManager.auxLookAndFeels.length - 1] = lookAndFeel;
    }

    public static boolean removeAuxiliaryLookAndFeel(LookAndFeel lookAndFeel) {
        if (auxLookAndFeels == null) {
            return false;
        }
        int n = auxLookAndFeels.length;
        if (n == 1 && auxLookAndFeels[0] == lookAndFeel) {
            auxLookAndFeels = null;
            return true;
        }
        int n2 = 0;
        while (n2 < n) {
            if (auxLookAndFeels[n2] == lookAndFeel) {
                LookAndFeel[] lookAndFeelArray = new LookAndFeel[auxLookAndFeels.length - 1];
                if (n2 == 0) {
                    System.arraycopy(auxLookAndFeels, 1, lookAndFeelArray, 0, n - 1);
                } else if (n2 == n - 1) {
                    System.arraycopy(auxLookAndFeels, 0, lookAndFeelArray, 0, n - 1);
                } else {
                    System.arraycopy(auxLookAndFeels, 0, lookAndFeelArray, 0, n2);
                    System.arraycopy(auxLookAndFeels, n2 + 1, lookAndFeelArray, n2, n - n2 - 1);
                }
                auxLookAndFeels = lookAndFeelArray;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static LookAndFeel[] getAuxiliaryLookAndFeels() {
        return auxLookAndFeels;
    }

    public static Object get(Object object) {
        Object object2 = null;
        if (userUIDefaults != null) {
            object2 = userUIDefaults.get(object);
        }
        if (object2 == null) {
            object2 = UIManager.getLookAndFeelDefaults().get(object);
        }
        return object2;
    }

    public static Object get(Object object, Locale locale) {
        Object object2 = null;
        if (userUIDefaults != null) {
            object2 = userUIDefaults.get(object, locale);
        }
        if (object2 == null) {
            object2 = UIManager.getLookAndFeelDefaults().get(object, locale);
        }
        return object2;
    }

    public static boolean getBoolean(Object object) {
        Boolean bl = (Boolean)UIManager.get(object);
        boolean bl2 = false;
        if (bl != null) {
            bl2 = bl;
        }
        return bl2;
    }

    public static boolean getBoolean(Object object, Locale locale) {
        Boolean bl = (Boolean)UIManager.get(object, locale);
        boolean bl2 = false;
        if (bl != null) {
            bl2 = bl;
        }
        return bl2;
    }

    public static Border getBorder(Object object) {
        return (Border)UIManager.get(object);
    }

    public static Border getBorder(Object object, Locale locale) {
        return (Border)UIManager.get(object, locale);
    }

    public static Color getColor(Object object) {
        return (Color)UIManager.get(object);
    }

    public static Color getColor(Object object, Locale locale) {
        return (Color)UIManager.get(object);
    }

    public static String getCrossPlatformLookAndFeelClassName() {
        return "javax.swing.plaf.metal.MetalLookAndFeel";
    }

    public static UIDefaults getDefaults() {
        return currentUIDefaults;
    }

    public static Dimension getDimension(Object object) {
        return (Dimension)UIManager.get(object);
    }

    public static Dimension getDimension(Object object, Locale locale) {
        return (Dimension)UIManager.get(object, locale);
    }

    public static Font getFont(Object object) {
        return (Font)UIManager.get(object);
    }

    public static Font getFont(Object object, Locale locale) {
        return (Font)UIManager.get(object, locale);
    }

    public static Icon getIcon(Object object) {
        return (Icon)UIManager.get(object);
    }

    public static Icon getIcon(Object object, Locale locale) {
        return (Icon)UIManager.get(object, locale);
    }

    public static Insets getInsets(Object object) {
        Object object2 = UIManager.get(object);
        if (object2 instanceof Insets) {
            return (Insets)object2;
        }
        return null;
    }

    public static Insets getInsets(Object object, Locale locale) {
        Object object2 = UIManager.get(object, locale);
        if (object2 instanceof Insets) {
            return (Insets)object2;
        }
        return null;
    }

    public static LookAndFeelInfo[] getInstalledLookAndFeels() {
        return installed;
    }

    public static int getInt(Object object) {
        Integer n = (Integer)UIManager.get(object);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public static int getInt(Object object, Locale locale) {
        Integer n = (Integer)UIManager.get(object, locale);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public static LookAndFeel getLookAndFeel() {
        return currentLookAndFeel;
    }

    public static UIDefaults getLookAndFeelDefaults() {
        return currentUIDefaults;
    }

    public static String getString(Object object) {
        return (String)UIManager.get(object);
    }

    public static String getString(Object object, Locale locale) {
        return (String)UIManager.get(object, locale);
    }

    public static String getSystemLookAndFeelClassName() {
        return UIManager.getCrossPlatformLookAndFeelClassName();
    }

    public static ComponentUI getUI(JComponent jComponent) {
        ComponentUI componentUI = null;
        if (userUIDefaults != null && userUIDefaults.get(jComponent.getUIClassID()) != null) {
            componentUI = userUIDefaults.getUI(jComponent);
        }
        if (componentUI == null) {
            componentUI = currentUIDefaults.getUI(jComponent);
        }
        return componentUI;
    }

    public static void installLookAndFeel(String string, String string2) {
        UIManager.installLookAndFeel(new LookAndFeelInfo(string, string2));
    }

    public static void installLookAndFeel(LookAndFeelInfo lookAndFeelInfo) {
    }

    public static Object put(Object object, Object object2) {
        Object object3 = UIManager.get(object);
        if (userUIDefaults == null) {
            userUIDefaults = new UIDefaults();
        }
        userUIDefaults.put(object, object2);
        return object3;
    }

    public static void setInstalledLookAndFeels(LookAndFeelInfo[] lookAndFeelInfoArray) {
    }

    public static void setLookAndFeel(LookAndFeel lookAndFeel) throws UnsupportedLookAndFeelException {
        if (lookAndFeel != null && !lookAndFeel.isSupportedLookAndFeel()) {
            throw new UnsupportedLookAndFeelException(lookAndFeel.getName());
        }
        LookAndFeel lookAndFeel2 = currentLookAndFeel;
        if (lookAndFeel2 != null) {
            lookAndFeel2.uninitialize();
        }
        currentLookAndFeel = lookAndFeel;
        if (lookAndFeel != null) {
            lookAndFeel.initialize();
            currentUIDefaults = lookAndFeel.getDefaults();
        } else {
            currentUIDefaults = null;
        }
        listeners.firePropertyChange("lookAndFeel", lookAndFeel2, lookAndFeel);
    }

    public static void setLookAndFeel(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        Class clazz = Class.forName(string);
        LookAndFeel lookAndFeel = (LookAndFeel)clazz.newInstance();
        UIManager.setLookAndFeel(lookAndFeel);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        Class clazz = class$javax$swing$UIManager;
        if (clazz == null) {
            clazz = class$javax$swing$UIManager = UIManager.class("[Ljavax.swing.UIManager;", false);
        }
        listeners = new PropertyChangeSupport(clazz);
        String string = System.getProperty("swing.defaultlaf");
        try {
            if (string != null) {
                Class clazz2 = Class.forName(string);
                LookAndFeel lookAndFeel = (LookAndFeel)clazz2.newInstance();
                UIManager.setLookAndFeel(lookAndFeel);
            } else {
                UIManager.setLookAndFeel(new MetalLookAndFeel());
            }
        }
        catch (Exception exception) {
            System.err.println("cannot initialize Look and Feel: " + string);
            System.err.println("error: " + exception.toString());
            System.err.println("falling back to Metal Look and Feel");
            try {
                UIManager.setLookAndFeel(new MetalLookAndFeel());
            }
            catch (Exception exception2) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"There must be no problem installing the MetalLookAndFeel."))).initCause(exception2);
            }
        }
    }

    public static class LookAndFeelInfo {
        String name;
        String clazz;

        public String getName() {
            return this.name;
        }

        public String getClassName() {
            return this.clazz;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append('[');
            stringBuffer.append(this.getName());
            stringBuffer.append(' ');
            stringBuffer.append(this.getClassName());
            stringBuffer.append(']');
            return stringBuffer.toString();
        }

        public LookAndFeelInfo(String string, String string2) {
            this.name = string;
            this.clazz = string2;
        }
    }
}

