/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectUtil;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Method
extends AccessibleObject
implements Member {
    int slot;
    byte[] vmData;
    private String name;
    private Class declaringClass;
    private Class returnType;
    private Class[] parameterTypes;
    private Class[] exceptionTypes;
    private char[] paramTypes;
    private char resultType;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public final Class getDeclaringClass() {
        if (this.declaringClass == null) {
            this.declaringClass = Method.nativeGetDeclaringClass(this.vmData);
        }
        return this.declaringClass;
    }

    private static final native Class nativeGetDeclaringClass(byte[] var0);

    public final String getName() {
        if (this.name == null) {
            this.name = Method.nativeGetName(this.vmData);
        }
        return this.name;
    }

    public static final native String nativeGetName(byte[] var0);

    public final int getModifiers() {
        return Method.nativeGetModifiers(this.vmData);
    }

    private static final native int nativeGetModifiers(byte[] var0);

    public final Class getReturnType() {
        if (this.returnType == null) {
            this.returnType = ReflectUtil.getReturnType(Method.nativeGetDescriptor(this.vmData), this.getDeclaringClass().getClassLoader());
        }
        return this.returnType;
    }

    public final Class[] getParameterTypes() {
        if (this.parameterTypes == null) {
            this.parameterTypes = ReflectUtil.getParameterTypes(Method.nativeGetDescriptor(this.vmData), this.getDeclaringClass().getClassLoader());
        }
        return this.parameterTypes;
    }

    public final Class[] getExceptionTypes() {
        if (this.exceptionTypes == null) {
            this.exceptionTypes = Method.nativeGetExceptionTypes(this.vmData);
        }
        return this.exceptionTypes;
    }

    public static final native Class[] nativeGetExceptionTypes(byte[] var0);

    public final boolean equals(Object o) {
        if (!(o instanceof Method)) {
            return false;
        }
        Method that = (Method)o;
        if (this.getDeclaringClass() != that.getDeclaringClass()) {
            return false;
        }
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        if (this.getReturnType() != that.getReturnType()) {
            return false;
        }
        return Arrays.equals(this.getParameterTypes(), that.getParameterTypes());
    }

    public final int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public final String toString() {
        int i;
        StringBuffer sb = new StringBuffer(128);
        Modifier.toString(this.getModifiers(), sb).append(' ');
        sb.append(Method.getUserTypeName(this.getReturnType().getName())).append(' ');
        sb.append(this.getDeclaringClass().getName()).append('.');
        sb.append(this.getName()).append('(');
        Class[] c = this.getParameterTypes();
        if (c.length > 0) {
            sb.append(Method.getUserTypeName(c[0].getName()));
            i = 1;
            while (i < c.length) {
                sb.append(',').append(Method.getUserTypeName(c[i].getName()));
                ++i;
            }
        }
        sb.append(')');
        c = this.getExceptionTypes();
        if (c.length > 0) {
            sb.append(" throws ").append(c[0].getName());
            i = 1;
            while (i < c.length) {
                sb.append(',').append(c[i].getName());
                ++i;
            }
        }
        return sb.toString();
    }

    private static final String getUserTypeName(String typeSpec) {
        int pos = 0;
        String typeName = "";
        String arrayPart = "";
        while (typeSpec.charAt(pos) == '[') {
            arrayPart = arrayPart + "[]";
            ++pos;
        }
        switch (typeSpec.charAt(pos)) {
            case 'Z': {
                typeName = "boolean";
                break;
            }
            case 'B': {
                typeName = "byte";
                break;
            }
            case 'C': {
                typeName = "char";
                break;
            }
            case 'D': {
                typeName = "double";
                break;
            }
            case 'F': {
                typeName = "float";
                break;
            }
            case 'I': {
                typeName = "int";
                break;
            }
            case 'J': {
                typeName = "long";
                break;
            }
            case 'S': {
                typeName = "short";
                break;
            }
            case 'L': {
                typeName = typeSpec.substring(pos + 1, typeSpec.length() - 1);
                break;
            }
            default: {
                typeName = typeSpec;
                break;
            }
        }
        return typeName + arrayPart;
    }

    public final Object invoke(Object o, Object[] args) throws IllegalAccessException, InvocationTargetException {
        Object[] result;
        Object[] wrapper;
        char[] paramTypes;
        if (args == null) {
            args = new Object[]{};
        } else {
            Class clazz = args.getClass();
            Class clazz2 = array$Ljava$lang$Object;
            if (clazz2 == null) {
                clazz2 = array$Ljava$lang$Object = Method.class("[Ljava.lang.Object;", true);
            }
            if (clazz != clazz2) {
                Object[] newArgs = new Object[args.length];
                System.arraycopy(args, 0, newArgs, 0, args.length);
                args = paramTypes;
            }
        }
        paramTypes = this.getParamTypes();
        Class[] parameterTypes = this.getParameterTypes();
        int count = paramTypes.length;
        if (count != args.length) {
            throw new IllegalArgumentException("incorrect number of arguments");
        }
        try {
            int i = 0;
            while (i < count) {
                switch (paramTypes[i]) {
                    case 'Z': {
                        wrapper = new boolean[]{(Boolean)args[i]};
                        args[i] = wrapper;
                        break;
                    }
                    case 'B': {
                        wrapper = new byte[1];
                        wrapper[0] = (Byte)args[i];
                        args[i] = wrapper;
                        break;
                    }
                    case 'S': {
                        wrapper = new short[1];
                        wrapper[0] = (Short)args[i];
                        args[i] = wrapper;
                        break;
                    }
                    case 'C': {
                        wrapper = new char[1];
                        wrapper[0] = ((Character)args[i]).charValue();
                        args[i] = wrapper;
                        break;
                    }
                    case 'I': {
                        wrapper = new int[1];
                        wrapper[0] = (Integer)args[i];
                        args[i] = wrapper;
                        break;
                    }
                    case 'J': {
                        wrapper = new long[1];
                        wrapper[0] = ((Long)args[i]).longValue();
                        args[i] = wrapper;
                        break;
                    }
                    case 'F': {
                        wrapper = new float[1];
                        wrapper[0] = ((Float)args[i]).floatValue();
                        args[i] = wrapper;
                        break;
                    }
                    case 'D': {
                        wrapper = new double[1];
                        wrapper[0] = ((Double)args[i]).doubleValue();
                        args[i] = wrapper;
                        break;
                    }
                    case 'L': {
                        if (args[i] == null || parameterTypes[i].isAssignableFrom(args[i].getClass())) break;
                        throw new IllegalArgumentException("argument of incorrect type");
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                ++i;
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("argument of incorrect type");
        }
        switch (this.resultType) {
            case 'Z': {
                result = wrapper = new boolean[1];
                break;
            }
            case 'B': {
                result = wrapper = (Object[])new byte[1];
                break;
            }
            case 'S': {
                result = wrapper = (Object[])new short[1];
                break;
            }
            case 'C': {
                result = wrapper = (Object[])new char[1];
                break;
            }
            case 'I': {
                result = wrapper = (Object[])new int[1];
                break;
            }
            case 'J': {
                result = wrapper = (Object[])new long[1];
                break;
            }
            case 'F': {
                result = wrapper = (Object[])new float[1];
                break;
            }
            case 'D': {
                result = wrapper = (Object[])new double[1];
                break;
            }
            case 'L': {
                result = wrapper = (Object[])new Object[1];
                break;
            }
            case 'V': {
                result = null;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        Method.invokeNative(this.vmData, paramTypes, this.resultType, o, args, result);
        switch (this.resultType) {
            case 'Z': {
                wrapper = result;
                return new Boolean(wrapper[0]);
            }
            case 'B': {
                wrapper = (byte[])result;
                return new Byte(wrapper[0]);
            }
            case 'S': {
                wrapper = (short[])result;
                return new Short(wrapper[0]);
            }
            case 'C': {
                wrapper = (char[])result;
                return new Character(wrapper[0]);
            }
            case 'I': {
                wrapper = (int[])result;
                return new Integer(wrapper[0]);
            }
            case 'J': {
                wrapper = (long[])result;
                return new Long(wrapper[0]);
            }
            case 'F': {
                wrapper = (float[])result;
                return new Float((float)wrapper[0]);
            }
            case 'D': {
                wrapper = (double[])result;
                return new Double((double)wrapper[0]);
            }
            case 'L': {
                wrapper = result;
                return wrapper[0];
            }
            case 'V': {
                return null;
            }
        }
        throw new InternalError();
    }

    private static final native void invokeNative(byte[] var0, char[] var1, char var2, Object var3, Object[] var4, Object var5) throws IllegalAccessException, InvocationTargetException;

    private static final native String nativeGetDescriptor(byte[] var0);

    private final char[] getParamTypes() {
        if (this.paramTypes == null) {
            char c;
            char[] array = Method.nativeGetDescriptor(this.vmData).toCharArray();
            int count = 0;
            int i = 0;
            block9: while ((c = array[++i]) != ')') {
                switch (c) {
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'S': 
                    case 'Z': {
                        array[count++] = c;
                        break;
                    }
                    case 'L': {
                        array[count++] = 76;
                        while (array[++i] != ';') {
                        }
                        break;
                    }
                    case '[': {
                        array[count++] = 76;
                        while (array[++i] == '[') {
                        }
                        if (array[i] != 'L') continue block9;
                        while (array[++i] != ';') {
                        }
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
            c = array[++i];
            switch (c) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'L': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    this.resultType = c;
                    break;
                }
                case '[': {
                    this.resultType = (char)76;
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
            char[] types = new char[count];
            System.arraycopy(array, 0, types, 0, count);
            this.paramTypes = types;
        }
        return this.paramTypes;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private Method(byte[] vmData) {
        this.vmData = vmData;
    }

    private Method(Class declaringClass, String name, int slot) {
        this.declaringClass = declaringClass;
        this.name = name;
        this.slot = slot;
    }
}

