/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleRole;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.RootPaneUI;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JRootPane
extends JComponent
implements Accessible {
    private static final long serialVersionUID = 8690748000348575668L;
    public static final int NONE = 0;
    public static final int FRAME = 1;
    public static final int PLAIN_DIALOG = 2;
    public static final int INFORMATION_DIALOG = 3;
    public static final int ERROR_DIALOG = 4;
    public static final int COLOR_CHOOSER_DIALOG = 5;
    public static final int FILE_CHOOSER_DIALOG = 6;
    public static final int QUESTION_DIALOG = 7;
    public static final int WARNING_DIALOG = 8;
    protected Component glassPane;
    protected JLayeredPane layeredPane;
    protected JMenuBar menuBar;
    protected Container contentPane;
    protected JButton defaultButton;
    protected Action defaultPressAction;
    protected Action defaultReleaseAction;
    private int windowDecorationStyle;

    public void setJMenuBar(JMenuBar m) {
        JLayeredPane jlPane = this.getLayeredPane();
        if (this.menuBar != null) {
            jlPane.remove(this.menuBar);
        }
        this.menuBar = m;
        if (this.menuBar != null) {
            jlPane.add((Component)this.menuBar, JLayeredPane.FRAME_CONTENT_LAYER);
        }
    }

    public void setMenuBar(JMenuBar m) {
        this.setJMenuBar(m);
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public JMenuBar getMenuBar() {
        return this.getJMenuBar();
    }

    public boolean isValidateRoot() {
        return true;
    }

    public Container getContentPane() {
        if (this.contentPane == null) {
            this.setContentPane(this.createContentPane());
        }
        return this.contentPane;
    }

    public void setContentPane(Container p) {
        if (p == null) {
            throw new IllegalComponentStateException("cannot have a null content pane");
        }
        if (this.contentPane != null && this.contentPane.getParent() == this.layeredPane) {
            this.layeredPane.remove(this.contentPane);
        }
        this.contentPane = p;
        this.getLayeredPane().add((Component)this.contentPane, JLayeredPane.FRAME_CONTENT_LAYER);
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
    }

    public Component getGlassPane() {
        if (this.glassPane == null) {
            this.setGlassPane(this.createGlassPane());
        }
        return this.glassPane;
    }

    public void setGlassPane(Component f) {
        if (this.glassPane != null) {
            this.remove(this.glassPane);
        }
        this.glassPane = f;
        this.glassPane.setVisible(false);
        this.add(this.glassPane, 0);
    }

    public JLayeredPane getLayeredPane() {
        if (this.layeredPane == null) {
            this.setLayeredPane(this.createLayeredPane());
        }
        return this.layeredPane;
    }

    public void setLayeredPane(JLayeredPane f) {
        if (this.layeredPane != null) {
            this.remove(this.layeredPane);
        }
        this.layeredPane = f;
        this.add((Component)f, -1);
    }

    protected LayoutManager createRootLayout() {
        return new RootLayout();
    }

    protected Container createContentPane() {
        JPanel p = new JPanel();
        p.setName(this.getName() + ".contentPane");
        p.setLayout(new BorderLayout());
        return p;
    }

    protected Component createGlassPane() {
        JPanel p = new JPanel();
        p.setName(this.getName() + ".glassPane");
        p.setVisible(false);
        p.setOpaque(false);
        return p;
    }

    protected JLayeredPane createLayeredPane() {
        JLayeredPane l = new JLayeredPane();
        l.setLayout(null);
        return l;
    }

    public RootPaneUI getUI() {
        return (RootPaneUI)this.ui;
    }

    public void setUI(RootPaneUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((RootPaneUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "RootPaneUI";
    }

    public JButton getDefaultButton() {
        return this.defaultButton;
    }

    public void setDefaultButton(JButton newButton) {
        if (this.defaultButton == newButton) {
            return;
        }
        JButton oldButton = this.defaultButton;
        this.defaultButton = newButton;
        this.firePropertyChange("defaultButton", oldButton, newButton);
    }

    public int getWindowDecorationStyle() {
        return this.windowDecorationStyle;
    }

    public void setWindowDecorationStyle(int style) {
        if (style != 0 && style != 1 && style != 3 && style != 4 && style != 5 && style != 6 && style != 7 && style != 8 && style != 2) {
            throw new IllegalArgumentException("invalid style");
        }
        int oldStyle = this.windowDecorationStyle;
        this.windowDecorationStyle = style;
        this.firePropertyChange("windowDecorationStyle", oldStyle, style);
    }

    private final /* synthetic */ void this() {
        this.windowDecorationStyle = 0;
    }

    public JRootPane() {
        this.this();
        this.setLayout(this.createRootLayout());
        this.getGlassPane();
        this.getLayeredPane();
        this.getContentPane();
        this.updateUI();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class RootLayout
    implements LayoutManager2,
    Serializable {
        private static final long serialVersionUID = -4100116998559815027L;

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public float getLayoutAlignmentX(Container target) {
            return target.getAlignmentX();
        }

        public float getLayoutAlignmentY(Container target) {
            return target.getAlignmentY();
        }

        public void invalidateLayout(Container target) {
        }

        public void layoutContainer(Container c) {
            int containerWidth = c.getBounds().width - JRootPane.this.getInsets().left - JRootPane.this.getInsets().right;
            int containerHeight = c.getBounds().height - JRootPane.this.getInsets().top - JRootPane.this.getInsets().bottom;
            Dimension contentPaneSize = JRootPane.this.contentPane.getPreferredSize();
            if (containerWidth == 0 && containerHeight == 0) {
                if (JRootPane.this.menuBar != null) {
                    Dimension menuBarSize = JRootPane.this.menuBar.getPreferredSize();
                    int maxWidth = Math.max(menuBarSize.width, contentPaneSize.width);
                    JRootPane.this.menuBar.setBounds(0, 0, maxWidth, menuBarSize.height);
                    JRootPane.this.glassPane.setBounds(0, 0, maxWidth, menuBarSize.height + contentPaneSize.height);
                    JRootPane.this.contentPane.setBounds(0, menuBarSize.height, maxWidth, contentPaneSize.height);
                    JRootPane.this.layeredPane.setBounds(0, 0, maxWidth, menuBarSize.height + contentPaneSize.height);
                } else {
                    JRootPane.this.glassPane.setBounds(0, 0, contentPaneSize.width, contentPaneSize.height);
                    JRootPane.this.contentPane.setBounds(0, 0, contentPaneSize.width, contentPaneSize.height);
                    JRootPane.this.layeredPane.setBounds(0, 0, contentPaneSize.width, contentPaneSize.height);
                }
            } else {
                if (JRootPane.this.menuBar != null) {
                    Dimension menuBarSize = JRootPane.this.menuBar.getPreferredSize();
                    if (menuBarSize.height > containerHeight) {
                        menuBarSize.height = containerHeight;
                    }
                    JRootPane.this.menuBar.setBounds(0, 0, containerWidth, menuBarSize.height);
                    JRootPane.this.glassPane.setBounds(0, 0, containerWidth, containerHeight);
                    JRootPane.this.contentPane.setBounds(0, menuBarSize.height, containerWidth, containerHeight - menuBarSize.height);
                } else {
                    JRootPane.this.glassPane.setBounds(0, 0, containerWidth, containerHeight);
                    JRootPane.this.contentPane.setBounds(0, 0, containerWidth, containerHeight);
                }
                JRootPane.this.layeredPane.setBounds(0, 0, containerWidth, containerHeight);
            }
        }

        public Dimension maximumLayoutSize(Container target) {
            return this.preferredLayoutSize(target);
        }

        public Dimension minimumLayoutSize(Container target) {
            return this.preferredLayoutSize(target);
        }

        public Dimension preferredLayoutSize(Container c) {
            Dimension prefSize;
            Dimension containerSize = c.getSize();
            Dimension contentPaneSize = JRootPane.this.contentPane.getPreferredSize();
            if (containerSize.width == 0 && containerSize.height == 0) {
                if (JRootPane.this.menuBar != null) {
                    Dimension menuBarSize = JRootPane.this.menuBar.getPreferredSize();
                    int maxWidth = Math.max(menuBarSize.width, contentPaneSize.width);
                    prefSize = new Dimension(maxWidth, contentPaneSize.height + menuBarSize.height);
                } else {
                    prefSize = contentPaneSize;
                }
            } else {
                prefSize = c.getSize();
            }
            return prefSize;
        }

        public void removeLayoutComponent(Component comp) {
        }

        protected RootLayout() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJRootPane
    extends JComponent.AccessibleJComponent {
        private static final long serialVersionUID = 1082432482784468088L;

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.ROOT_PANE;
        }

        protected AccessibleJRootPane() {
        }
    }
}

