/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import gnu.xml.xpath.Expr;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

final class ProcessingInstructionNode
extends TemplateNode {
    final String name;

    final TemplateNode clone(Stylesheet stylesheet) {
        ProcessingInstructionNode ret = new ProcessingInstructionNode(this.name);
        if (this.children != null) {
            ret.children = this.children.clone(stylesheet);
        }
        if (this.next != null) {
            ret.next = this.next.clone(stylesheet);
        }
        return ret;
    }

    final void doApply(Stylesheet stylesheet, QName mode, Node context, int pos, int len, Node parent, Node nextSibling) throws TransformerException {
        Document doc;
        String data = null;
        Document document = doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        if (this.children != null) {
            DocumentFragment fragment = doc.createDocumentFragment();
            this.children.apply(stylesheet, mode, context, pos, len, fragment, null);
            data = Expr.stringValue(fragment);
        }
        ProcessingInstruction pi = doc.createProcessingInstruction(this.name, data);
        if (nextSibling != null) {
            parent.insertBefore(pi, nextSibling);
        } else {
            parent.appendChild(pi);
        }
        if (this.next != null) {
            this.next.apply(stylesheet, mode, context, pos, len, parent, nextSibling);
        }
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        buf.append('[');
        buf.append("name=");
        buf.append(this.name);
        buf.append(']');
        return buf.toString();
    }

    ProcessingInstructionNode(String name) {
        this.name = name;
    }
}

