/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.util;

import com.google.protobuf.ByteString;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import java.util.ServiceLoader;
import org.campagnelab.goby.reads.ReadCodec;

public class CodecHelper {
    private static final ServiceLoader<ReadCodec> readCodecLoader = ServiceLoader.load(ReadCodec.class);
    private static Byte2ObjectMap<ReadCodec> codeToReadCodec = new Byte2ObjectOpenHashMap(5);

    public static void reload() {
        readCodecLoader.reload();
        for (ReadCodec next : readCodecLoader) {
            codeToReadCodec.put(next.registrationCode(), (Object)next);
        }
    }

    public static ReadCodec locateReadCodec(ByteString compressedData) {
        if (codeToReadCodec.size() == 0) {
            CodecHelper.reload();
        }
        byte codecId = compressedData.byteAt(0);
        return (ReadCodec)codeToReadCodec.get(codecId);
    }

    static {
        CodecHelper.reload();
    }
}

