/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.zip.InflaterFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;

public class AsyncBlockCompressedInputStream
extends BlockCompressedInputStream {
    private static final int READ_AHEAD_BUFFERS = (int)Math.ceil((double)Defaults.NON_ZERO_BUFFER_SIZE / 65536.0);
    private static final Executor threadpool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        }
    });
    private final BlockingQueue<BlockCompressedInputStream.DecompressedBlock> mResult = new ArrayBlockingQueue<BlockCompressedInputStream.DecompressedBlock>(READ_AHEAD_BUFFERS);
    private final BlockingQueue<byte[]> freeBuffers = new ArrayBlockingQueue<byte[]>(READ_AHEAD_BUFFERS);
    private final Semaphore running = new Semaphore(1);
    private volatile boolean mAbort = false;

    public AsyncBlockCompressedInputStream(InputStream stream) {
        super(stream, true);
    }

    public AsyncBlockCompressedInputStream(InputStream stream, InflaterFactory inflaterFactory) {
        super(stream, true, inflaterFactory);
    }

    public AsyncBlockCompressedInputStream(File file) throws IOException {
        super(file);
    }

    public AsyncBlockCompressedInputStream(File file, InflaterFactory inflaterFactory) throws IOException {
        super(file, inflaterFactory);
    }

    public AsyncBlockCompressedInputStream(URL url) {
        super(url);
    }

    public AsyncBlockCompressedInputStream(URL url, InflaterFactory inflaterFactory) {
        super(url, inflaterFactory);
    }

    public AsyncBlockCompressedInputStream(SeekableStream strm) {
        super(strm);
    }

    public AsyncBlockCompressedInputStream(SeekableStream strm, InflaterFactory inflaterFactory) {
        super(strm, inflaterFactory);
    }

    @Override
    protected BlockCompressedInputStream.DecompressedBlock nextBlock(byte[] bufferAvailableForReuse) {
        if (bufferAvailableForReuse != null) {
            this.freeBuffers.offer(bufferAvailableForReuse);
        }
        return this.nextBlockSync();
    }

    @Override
    protected void prepareForSeek() {
        this.flushReadAhead();
        super.prepareForSeek();
    }

    @Override
    public void close() throws IOException {
        boolean isInterrupted = Thread.interrupted();
        this.mAbort = true;
        try {
            this.flushReadAhead();
            super.close();
        }
        finally {
            if (isInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void flushReadAhead() {
        boolean abortStatus = this.mAbort;
        this.mAbort = true;
        try {
            this.running.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for decompression thread", e);
        }
        this.mResult.clear();
        this.mAbort = abortStatus;
        this.running.release();
    }

    private void ensureReadAhead() {
        if (this.running.tryAcquire()) {
            this.tryQueueTask();
        }
    }

    private void tryQueueTask() {
        if (this.mAbort) {
            this.running.release();
            return;
        }
        if (this.mResult.remainingCapacity() == 0) {
            this.running.release();
            if (this.mResult.remainingCapacity() > 0) {
                this.ensureReadAhead();
                return;
            }
            return;
        }
        threadpool.execute(new AsyncBlockCompressedInputStreamRunnable());
    }

    private BlockCompressedInputStream.DecompressedBlock nextBlockSync() {
        BlockCompressedInputStream.DecompressedBlock nextBlock;
        this.ensureReadAhead();
        try {
            nextBlock = this.mResult.take();
        }
        catch (InterruptedException e) {
            return new BlockCompressedInputStream.DecompressedBlock(0L, 0, e);
        }
        this.ensureReadAhead();
        return nextBlock;
    }

    private class AsyncBlockCompressedInputStreamRunnable
    implements Runnable {
        private AsyncBlockCompressedInputStreamRunnable() {
        }

        @Override
        public void run() {
            BlockCompressedInputStream.DecompressedBlock decompressed = AsyncBlockCompressedInputStream.this.processNextBlock((byte[])AsyncBlockCompressedInputStream.this.freeBuffers.poll());
            if (!AsyncBlockCompressedInputStream.this.mResult.offer(decompressed)) {
                AsyncBlockCompressedInputStream.this.running.release();
                throw new IllegalStateException("Decompression buffer full");
            }
            AsyncBlockCompressedInputStream.this.tryQueueTask();
        }
    }
}

