/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin.impl;

import com.l2fprod.gui.plaf.skin.DefaultButton;
import com.l2fprod.gui.plaf.skin.SkinProgress;
import com.l2fprod.gui.plaf.skin.impl.AbstractSkinComponent;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.UIManager;

public abstract class AbstractSkinProgress
extends AbstractSkinComponent
implements SkinProgress {
    protected DefaultButton progressBarBackHorizontal;
    protected DefaultButton progressBarHorizontal;
    protected DefaultButton progressBarBackVertical;
    protected DefaultButton progressBarVertical;
    protected int orientation = 0;
    protected final Dimension minimumSize = new Dimension(50, 17);
    protected boolean useWindow = Boolean.TRUE.equals(UIManager.get("ProgressBar.windowAnimation"));

    public final Dimension getMinimumSize(JProgressBar progress) {
        if (1 == progress.getOrientation()) {
            return this.progressBarBackVertical.getMinimumSize();
        }
        return this.progressBarBackHorizontal.getMinimumSize();
    }

    public final boolean status() {
        return this.progressBarHorizontal != null;
    }

    public final boolean installSkin(JComponent c) {
        return true;
    }

    protected final void paintBackBar(Graphics g, JProgressBar progress) {
        if (1 == progress.getOrientation()) {
            if (this.progressBarBackVertical != null) {
                this.progressBarBackVertical.paint(g, 0, 0, progress.getWidth(), progress.getHeight(), progress);
            }
        } else if (this.progressBarBackHorizontal != null) {
            this.progressBarBackHorizontal.paint(g, 0, 0, progress.getWidth(), progress.getHeight(), progress);
        }
    }

    public final boolean paintProgress(Graphics g, JProgressBar progress) {
        int height = 0;
        int width = 0;
        int y = 0;
        int x = 0;
        this.paintBackBar(g, progress);
        if (progress.getValue() > progress.getMinimum()) {
            if (1 == progress.getOrientation()) {
                height = (int)((double)progress.getValue() * (double)progress.getHeight() / (double)progress.getMaximum());
                y = progress.getHeight() - height;
                width = progress.getWidth();
                this.progressBarVertical.paint(g, x, y, width, height, progress);
            } else {
                y = 0;
                width = (int)((double)progress.getValue() * (double)progress.getWidth() / (double)progress.getMaximum());
                height = progress.getHeight();
                this.progressBarHorizontal.paint(g, x, y, width, height, progress);
            }
        }
        return true;
    }

    public final boolean paintIndeterminateProgress(Graphics g, JProgressBar progress, Rectangle rec) {
        this.paintBackBar(g, progress);
        if (1 == progress.getOrientation()) {
            if (this.useWindow) {
                this.progressBarVertical.paintWindow(g, progress.getWidth(), progress.getHeight(), rec.x, rec.y, rec.width, rec.height, progress);
            } else {
                this.progressBarVertical.paint(g, rec.x, rec.y, rec.width, rec.height, progress);
            }
        } else if (this.useWindow) {
            this.progressBarHorizontal.paintWindow(g, progress.getWidth(), progress.getHeight(), rec.x, rec.y, rec.width, rec.height, progress);
        } else {
            this.progressBarHorizontal.paint(g, rec.x, rec.y, rec.width, rec.height, progress);
        }
        return true;
    }
}

