<?php

error_reporting(-1);

if (function_exists('ini_set')) {
    @ini_set('display_errors', 1);
    @ini_set('display_startup_errors', 1);
    @ini_set('opcache.enable_cli', '0');

    if (isset($_GET['opcache_reset']) && $_GET['opcache_reset'] === md5(Phar::running(false))) {
        $GLOBALS['opcacheEnabled'] = @ini_get('opcache.enable');
    } else {
        $GLOBALS['opcacheEnabled'] = @ini_set('opcache.enable', '0');
    }
}

if (PHP_VERSION_ID < 50509) {
    die('You are using PHP '.PHP_VERSION." but you need least PHP 5.5.9 to run the Contao Manager.\n");
}

if (!extension_loaded('Phar')) {
    echo 'PHP\'s phar extension is missing. Contao Manager requires it to run. Enable the extension or recompile php without --disable-phar then try again.' . PHP_EOL;
    exit(1);
}

if (PHP_VERSION_ID < 70205) {
    Phar::mapPhar('contao-manager.phar');
    @include 'phar://contao-manager.phar/downgrade.php';
    die('<script>setTimeout(function() { window.location.reload(true) }, 1000)</script>');
}

if (function_exists('date_default_timezone_set') && function_exists('date_default_timezone_get')) {
    date_default_timezone_set(@date_default_timezone_get());
}

if ('cli' === PHP_SAPI || !isset($_SERVER['REQUEST_URI'])) {
    if (isset($_SERVER['argv'][1]) && 'test' === $_SERVER['argv'][1]) {
        die(json_encode(['version' => PHP_VERSION, 'version_id' => PHP_VERSION_ID, 'sapi' => PHP_SAPI]));
    }

    Phar::mapPhar('contao-manager.phar');
    require 'phar://contao-manager.phar/api/console';
} else {
    function rewrites()
    {
        // The function argument is unreliable across servers, Nginx for example is always empty
        list(,$url) = explode(basename(__FILE__), $_SERVER['REQUEST_URI'], 2);

        if (strpos($url, '..')) {
            return false;
        }

        if ('' === $url) {
            header('Location: /'.basename(__FILE__).'/');
            exit;
        }

        if (0 === strpos($url, '/api/')) {
            return '/dist/api.php'.$url;
        }

        if (!empty($url) && is_file('phar://'.__FILE__.'/dist'.$url)) {
            return '/dist'.$url;
        }

        return '/dist/index.html';
    }

    Phar::webPhar(
        null,
        'index.html',
        null,
        array(
            'log' => 'text/plain',
            'txt' => 'text/plain',
            'php' => Phar::PHP, // parse as PHP
            'css' => 'text/css',
            'gif' => 'image/gif',
            'html' => 'text/html',
            'ico' => 'image/x-ico',
            'jpg' => 'image/jpeg',
            'jpeg' => 'image/jpeg',
            'js' => 'application/x-javascript',
            'png' => 'image/png',
            'svg' => 'image/svg+xml',
            'json' => 'application/json'
        ),
        'rewrites'
    );
}

__HALT_COMPILER(); ?>
(v )
                 .box/bin/check-requirements.php  me  ^ʨ         .box/.requirements.php	  me	  if.         .box/vendor/autoload.php   me   s      ,   .box/vendor/composer/autoload_namespaces.php   me   t!פ         .box/vendor/composer/LICENSE.  me.         $   .box/vendor/composer/ClassLoader.php>  me>  5Ky      &   .box/vendor/composer/autoload_psr4.php6  me6   0Ӥ      *   .box/vendor/composer/autoload_classmap.php,
  me,
  ӽǤ      (   .box/vendor/composer/autoload_static.phpK  meK  ?      &   .box/vendor/composer/autoload_real.php   me   yi\      .   .box/vendor/composer/semver/src/Comparator.phpu  meu  	74      *   .box/vendor/composer/semver/src/Semver.php  me  ׯ      1   .box/vendor/composer/semver/src/VersionParser.php9  me9  Wz      B   .box/vendor/composer/semver/src/Constraint/ConstraintInterface.php  me  wQ      >   .box/vendor/composer/semver/src/Constraint/MultiConstraint.php~  me~  5[e      9   .box/vendor/composer/semver/src/Constraint/Constraint.php'&  me'&  `         .box/src/Terminal.php
  me
  %V         .box/src/IO.php   me   [l%      !   .box/src/IsExtensionFulfilled.phpv  mev  '0Ҥ         .box/src/Checker.php  me  )W>      "   .box/src/IsPhpVersionFulfilled.php  me  !83      "   .box/src/RequirementCollection.php  me  Wb?         .box/src/Printer.php  me  )8AV         .box/src/IsFulfilled.phpv   mev   %*H         .box/src/Requirement.phpm  mem  B         LICENSE  me  p         dist/index.htmlb!  meb!            dist/api.php--  me  fd         dist/css/app.a9bbe961.css& me&        #   dist/css/chunk-vendors.e94d59f6.cssل  meل  O         dist/js/716-legacy.fe76ad03.js  me           dist/js/486-legacy.57687748.js
  me
  <'         dist/js/606-legacy.b2749c38.js  me  K         dist/js/477-legacy.af30486c.js  me  b         dist/js/606.9b8de109.js  me  AK         dist/js/540-legacy.ff66b145.js\  me\  !         dist/js/557-legacy.20f3f31a.js  me  ~>n         dist/js/523.5cd13a0a.js%
  me%
  -h         dist/js/953.9ee534da.js  me  S         dist/js/721-legacy.1171d135.js'  me'  F*         dist/js/367-legacy.63846bd9.jsT  meT  DTx         dist/js/560-legacy.9e06a119.js  me  lK         dist/js/710.3935c7a1.js| me|          dist/js/581-legacy.06d31426.js  me  P6         dist/js/560.9e06a119.js  me  lK         dist/js/553.185d25f6.jsE  meE  ٤         dist/js/551-legacy.64bff36a.jsi  mei  (Ǥ         dist/js/874-legacy.b224e448.js
  me
  _:         dist/js/542.d2c16b19.js  me  B
         dist/js/769.b25e985b.jsJ
  meJ
  ֭         dist/js/669-legacy.3e71dbf5.js  me           dist/js/194.a4186ef7.jse
  mee
  jp         dist/js/669.3e71dbf5.js  me           dist/js/28-legacy.e44c5c50.jsw  mew  Ig0         dist/js/518-legacy.3245ef3b.js  me  0         dist/js/120-legacy.6f92589c.js
  me
  }^ݤ         dist/js/139-legacy.5c0071ca.jsU  meU  x0L6         dist/js/486.57687748.js
  me
  <'         dist/js/638-legacy.b5c80b23.js@  me@  c         dist/js/367.63846bd9.jsT  meT  DTx         dist/js/554.6d242bb5.js  me  :"         dist/js/140-legacy.686354c2.js=  me=  3N      (   dist/js/chunk-vendors-legacy.8131a05f.jsS meS v!         dist/js/710-legacy.3935c7a1.js| me|          dist/js/716.fe76ad03.js  me           dist/js/app.1ba94aee.js me 䱤         dist/js/139.5c0071ca.jsU  meU  x0L6         dist/js/180-legacy.8dfeddb5.jsW
  meW
  q3ܤ         dist/js/706.bcc0a7d7.jsߕ  meߕ   B         dist/js/851.f0f7ce97.jsI  meI  惣         dist/js/164.5ae18c19.js_  me_  pX         dist/js/app-legacy.4548ebe5.js me cB         dist/js/518.3245ef3b.js  me  0         dist/js/52.68515644.jsW
  meW
  k         dist/js/557.20f3f31a.js  me  ~>n         dist/js/551.64bff36a.jsi  mei  (Ǥ         dist/js/581.06d31426.js  me  P6         dist/js/958-legacy.18ef1cc5.jsS  meS  CIsƤ         dist/js/44.31475fcc.js   me            dist/js/553-legacy.185d25f6.jsE  meE  ٤         dist/js/523-legacy.5cd13a0a.js%
  me%
  -h         dist/js/643-legacy.bbc22e0a.js  me  R j         dist/js/638.b5c80b23.js@  me@  c         dist/js/194-legacy.a4186ef7.jse
  mee
  jp         dist/js/554-legacy.6a208c8e.js  me  '~         dist/js/542-legacy.d2c16b19.js  me  B
         dist/js/715-legacy.5da18439.jse  mee  2(         dist/js/219-legacy.76497ed6.jsh  meh  w         dist/js/140.686354c2.js=  me=  3N         dist/js/953-legacy.9ee534da.js  me  S         dist/js/44-legacy.31475fcc.js   me            dist/js/643.bbc22e0a.js  me  R j         dist/js/721.1171d135.js'  me'  F*         dist/js/706-legacy.bcc0a7d7.jsߕ  meߕ   B         dist/js/219.76497ed6.jsh  meh  w         dist/js/958.18ef1cc5.jsS  meS  CIsƤ         dist/js/874.b224e448.js
  me
  _:      !   dist/js/chunk-vendors.41a4e2b1.js me vA         dist/js/52-legacy.68515644.jsW
  meW
  k         dist/js/540.ff66b145.js\  me\  !         dist/js/851-legacy.f0f7ce97.jsI  meI  惣         dist/js/477.af30486c.js  me  b         dist/js/120.6f92589c.js
  me
  }^ݤ         dist/js/180.8dfeddb5.jsW
  meW
  q3ܤ         dist/js/715.5da18439.jse  mee  2(         dist/js/164-legacy.5ae18c19.js_  me_  pX         dist/js/28.e44c5c50.jsw  mew  Ig0         dist/js/769-legacy.b25e985b.jsJ
  meJ
  ֭      !   dist/img/button-show.2336e1d9.svgS  meS  U         dist/img/favers.31587387.svgO  meO  fڤ      $   dist/img/button-details.78532630.svg  me  EΤ         dist/img/funding.8a3c0e0e.svgB  meB  rAݤ         dist/img/task.30a3fdc0.svgt  met  PƤ          dist/img/button-add.759df12e.svg   me   O
         dist/img/logo.9c3b3279.svg  me  
ͤ      %   dist/img/button-download.ce5cd0d3.svg-  me-  F      "   dist/img/button-cloud.5015c41d.svg  me  2攕      !   dist/img/button-edit.d4a8737e.svg  me  uC      #   dist/img/server-config.1a2d0888.svgg  meg  RN      "   dist/img/button-power.6b957f3a.svg/  me/  ^S         dist/img/sad.c9a06488.svg6  me6  lE1         dist/img/updated.455f42dc.svg[  me[  ~z;      $   dist/img/create-project.b22522ee.svg   me   ʅ      #   dist/img/document-root.0e6dd2e4.svg   me   D         dist/img/language.95d0a00b.svg  me  ῤ      $   dist/img/button-console.93e68609.svg   me   o۪      !   dist/img/button-hide.6a3eaaf7.svg  me  q      "   dist/img/button-check.8170bc92.svg   me   jG1      &   dist/img/button-cloud-off.37842942.svg  me  4N         dist/img/offline.1f95ae24.svg  me  9         dist/img/person.00d78897.svg   me   w*      !   dist/img/button-lock.98988f08.svgc  mec  5=6z      "   dist/img/symfony-logo.9bfb375e.svg
  me
  y3         dist/img/php-logo.e15778f8.svg&	  me&	  5û         dist/img/warning.a0297242.svg   me   J         dist/img/user.129e863d.svg   me   cǤ      "   dist/img/button-trash.a2f11028.svgt  met  T[      #   dist/img/button-update.c63bd5a5.svgX  meX  tPɤ      '   dist/img/search-by-algolia.47401192.svg  me  w1      '   dist/img/widget-radio--off.4e93f443.svg  me        !   dist/img/button-save.7704614c.svg	  me	  G         dist/img/hint.ba2ac97e.svg!  me!           dist/img/database.7f0a8c49.svg  me  <	      (   dist/img/button-maintenance.18fa2ce6.svgB  meB  /Ӥ         dist/img/lock.3c42a55f.svgf  mef  gG      )   dist/img/widget-checkbox--on.c05d996c.svg   me   Ts>         dist/img/recovery.70ee118a.svg   me   OTM`         dist/img/boot.c1251f6b.svg  me  b      "   dist/img/link-funding.c73bb011.svg   me   i      !   dist/img/button-gear.75fa79f0.svg  me  3      #   dist/img/button-unlock.51b76e07.svgi  mei  
      !   dist/img/button-more.e3eb2622.svg  me  v         dist/img/private.c66d3582.svg1  me1  :D      #   dist/img/button-search.6f2edfbf.svgH  meH  2Z          dist/img/button-run.5c7703ae.svg  me  7      &   dist/img/widget-radio--on.181461b6.svg:  me:  j
M          dist/img/link-blank.d5149b7c.svg   me   dY$      #   dist/img/button-upload.b489ceec.svg/  me/  }      %   dist/img/button-database.1f267fe1.svg   me   }l      !   dist/img/button-link.e4488c1f.svg   me   6         dist/img/close.88e95867.svg   me   F$         dist/img/downloads.aa84cdf1.svg*  me*  =P      *   dist/img/widget-checkbox--off.73856538.svg   me   ~          dist/img/link-blank.c018a22c.svg   me   1o      (   dist/icons/task-active/favicon-16x16.png3  me3  K       "   dist/icons/task-active/favicon.ico:  me:  8      (   dist/icons/task-active/favicon-32x32.pngF  meF  )fx      '   dist/icons/task-error/favicon-16x16.png;  me;        !   dist/icons/task-error/favicon.ico:  me:  u      '   dist/icons/task-error/favicon-32x32.pngB  meB        )   dist/icons/task-success/favicon-16x16.pngU  meU  {ؤ      #   dist/icons/task-success/favicon.ico:  me:  TIm      )   dist/icons/task-success/favicon-32x32.pngq  meq  ?.         dist/api.php  me           dist/assets/favicon-16x16.png  me           dist/assets/mstile-310x310.png  me  =I      &   dist/assets/android-chrome-384x384.png	'  me	'  @H      3   dist/assets/apple-touch-startup-image-1125x2436.png  me  *OW      2   dist/assets/apple-touch-startup-image-1792x828.pngC  meC   .+      2   dist/assets/apple-touch-startup-image-1334x750.pngE  meE  +v         dist/assets/mstile-144x144.png  me  Ҥ         dist/assets/favicon.ico  me  }*~      (   dist/assets/apple-touch-icon-120x120.png
  me
  !J      3   dist/assets/apple-touch-startup-image-2732x2048.pngr mer       &   dist/assets/android-chrome-192x192.pngm  mem  "u,          dist/assets/apple-touch-icon.png'  me'  8      3   dist/assets/apple-touch-startup-image-1242x2688.png
  me
  r2      &   dist/assets/android-chrome-256x256.png  me  X3@      3   dist/assets/apple-touch-startup-image-2436x1125.png*  me*  J)         dist/assets/mstile-70x70.png  me  eݺ=      2   dist/assets/apple-touch-startup-image-640x1136.pngV  meV  ӣ      3   dist/assets/apple-touch-startup-image-1170x2532.pngr  mer        *   dist/assets/apple-touch-icon-1024x1024.png  me  y      (   dist/assets/apple-touch-icon-152x152.png  me  K      3   dist/assets/apple-touch-startup-image-1620x2160.png+ me+ פ      3   dist/assets/apple-touch-startup-image-1668x2388.png> me> h[      2   dist/assets/apple-touch-startup-image-828x1792.pngx  mex  KtS      3   dist/assets/apple-touch-startup-image-2048x1536.png~W me~W x      (   dist/assets/apple-touch-icon-180x180.png'  me'  8      (   dist/assets/yandex-browser-manifest.json   me   p#Ȥ      3   dist/assets/apple-touch-startup-image-2224x1668.png me &I         dist/assets/favicon-48x48.png  me  .i         dist/assets/mstile-310x150.png%  me%  {      3   dist/assets/apple-touch-startup-image-1242x2208.png  me  ^w      (   dist/assets/apple-touch-icon-114x114.pngS	  meS	  U      &   dist/assets/apple-touch-icon-76x76.png*  me*  <&      &   dist/assets/android-chrome-512x512.png8  me8  =l?      2   dist/assets/apple-touch-startup-image-1136x640.pngk  mek  .      3   dist/assets/apple-touch-startup-image-2532x1170.png|  me|  ~Z      3   dist/assets/apple-touch-startup-image-2208x1242.png0 me0 =:      &   dist/assets/apple-touch-icon-57x57.png  me  1@      2   dist/assets/apple-touch-startup-image-750x1334.pngj  mej  3Fä      ,   dist/assets/apple-touch-icon-precomposed.png'  me'  8      3   dist/assets/apple-touch-startup-image-2160x1620.pngv mev k;      3   dist/assets/apple-touch-startup-image-1284x2778.png  me        3   dist/assets/apple-touch-startup-image-1668x2224.png8 me8 ϳ      3   dist/assets/apple-touch-startup-image-2688x1242.png  me  S      &   dist/assets/apple-touch-icon-72x72.png  me  O      3   dist/assets/apple-touch-startup-image-2778x1284.png% me%       3   dist/assets/apple-touch-startup-image-1536x2048.png me gl      3   dist/assets/apple-touch-startup-image-2388x1668.png me so.         dist/assets/mstile-150x150.png  me  z          dist/assets/manifest.webmanifest  me  `l      $   dist/assets/android-chrome-36x36.png+  me+        $   dist/assets/android-chrome-96x96.png  me  Af      (   dist/assets/apple-touch-icon-167x167.png
  me
  uD      $   dist/assets/android-chrome-72x72.png  me  hQ\      &   dist/assets/apple-touch-icon-60x60.png  me        3   dist/assets/apple-touch-startup-image-2048x2732.png7 me7 M_Ť      (   dist/assets/apple-touch-icon-144x144.png  me  A0      $   dist/assets/yandex-browser-50x50.pngX  meX  X         dist/assets/browserconfig.xmlr  mer  v,      $   dist/assets/android-chrome-48x48.png  me  .i         dist/assets/favicon-32x32.png  me  #      &   dist/assets/android-chrome-144x144.png  me  Ҥ      %   api/HttpKernel/ApiProblemResponse.php
  me
  F$X      
   api/console--A  meA  C~Ƥ         api/Config/UploadsConfig.php  me  4         api/Config/UserConfig.php!  me!  H         api/Config/ManagerConfig.php  me           api/Config/AbstractConfig.php  me  5qn¤         api/Config/ComposerConfig.php  me           api/Config/PartialConfig.php  me  ;Τ         api/Config/AuthConfig.php  me  T6      *   api/Security/PasswordlessAuthenticator.phph  meh  ̟      #   api/Security/TokenAuthenticator.php  me  Qkb         api/Security/UserProvider.php
  me
  de         api/Security/User.php  me  ۾Ť      !   api/Security/JwtAuthenticator.php		  me		  A      -   api/Security/AbstractBrowserAuthenticator.php  me  %0QŤ      #   api/Security/LoginAuthenticator.phpf	  mef	  ⴤ         api/Security/JwtManager.php  me  e H3      .   api/TaskOperation/Composer/RemoveOperation.php  me  EA      2   api/TaskOperation/Composer/ClearCacheOperation.php  me  ȝe      4   api/TaskOperation/Composer/DumpAutoloadOperation.php  me  rǀ      /   api/TaskOperation/Composer/InstallOperation.php  me  J\      .   api/TaskOperation/Composer/UpdateOperation.php  me  4      /   api/TaskOperation/Composer/RequireOperation.php  me  |gO      5   api/TaskOperation/Composer/CreateProjectOperation.php  me  ;t      -   api/TaskOperation/Composer/CloudOperation.php0  me0   ᜤ      8   api/TaskOperation/Filesystem/InstallUploadsOperation.php  me  2      6   api/TaskOperation/Filesystem/RemoveVendorOperation.php  me  #0      7   api/TaskOperation/Filesystem/RemoveUploadsOperation.php&	  me&	  8GJ¤      5   api/TaskOperation/Filesystem/RemoveCacheOperation.php  me  2)=      1   api/TaskOperation/Manager/SelfUpdateOperation.php0  me0  pUT      -   api/TaskOperation/AbstractInlineOperation.php  me  =x      1   api/TaskOperation/SponsoredOperationInterface.php  me  o&!      #   api/TaskOperation/ConsoleOutput.php)  me)  -      .   api/TaskOperation/AbstractProcessOperation.php
  me
  _      5   api/TaskOperation/Contao/MaintenanceModeOperation.php7  me7  jJB      2   api/TaskOperation/Contao/BackupCreateOperation.php  me        1   api/TaskOperation/Contao/CacheWarmupOperation.php  me  ݤ      2   api/TaskOperation/Contao/CreateContaoOperation.phpP  meP  Q	U      3   api/TaskOperation/Contao/BackupRestoreOperation.php  me  դ      0   api/TaskOperation/Contao/CacheClearOperation.php  me  i      ,   api/TaskOperation/TaskOperationInterface.php  me  j         api/Composer/CloudResolver.phpH  meH  /         api/Composer/CloudChanges.php&  me&  <T         api/Composer/CloudJob.php	  me	  R`}         api/Composer/CloudException.php  me  à         api/Composer/Environment.php@$  me@$  ^      #   api/Resources/cache/annotations.php  me  RҤ      2   api/Resources/cache/url_generating_routes.php.meta!  me!  '[      D   api/Resources/cache/pools/system/OsQ8hrw2r5/R/Z/LAZJaY04hjh8xPg33m7Q   me   e޸¤      D   api/Resources/cache/pools/system/OsQ8hrw2r5/R/A/7KUIQcX1-otParycxm4g  me  >      D   api/Resources/cache/pools/system/OsQ8hrw2r5/R/P/2D3NGVsB2klPFDF4unVg   me   Nq      D   api/Resources/cache/pools/system/OsQ8hrw2r5/U/0/UOEV-iZUDwJO3IZrD4jg  me  ە}      D   api/Resources/cache/pools/system/OsQ8hrw2r5/U/I/kTkBor3QesIhvAUCBjGg  me  
JZ      D   api/Resources/cache/pools/system/OsQ8hrw2r5/U/I/fdJRp068D3mGBmrtZWBA   me   @      D   api/Resources/cache/pools/system/OsQ8hrw2r5/U/Z/-SP2SMqd3fksOPgcjXAg   me         D   api/Resources/cache/pools/system/OsQ8hrw2r5/U/T/ACEmMTkeKq2zJNrQp1YA   me   {h      D   api/Resources/cache/pools/system/OsQ8hrw2r5/U/O/MNUfyeybfwQ1np4Jgl6w  me  `U      D   api/Resources/cache/pools/system/OsQ8hrw2r5/U/Q/RC7h6P3ZN9qrj5AJpv-Q   me   4֤      D   api/Resources/cache/pools/system/OsQ8hrw2r5/U/B/aFGbCjH4No5dIE86tm1w  me  13F      D   api/Resources/cache/pools/system/OsQ8hrw2r5/9/T/nyDVAEYeU58Up2Kq4Bmw   me   &`m      D   api/Resources/cache/pools/system/OsQ8hrw2r5/9/X/Ei+Xa-YpA3jDTw3bQMXQ   me   C,|      D   api/Resources/cache/pools/system/OsQ8hrw2r5/9/W/DCuPAEECfl7gjXqA25sg   me   7[      D   api/Resources/cache/pools/system/OsQ8hrw2r5/0/G/27i4Mke1ocWZYgjzErXw   me   {      D   api/Resources/cache/pools/system/OsQ8hrw2r5/0/G/4moiUYMtI6IqqTqMzblA   me   Ӻh      D   api/Resources/cache/pools/system/OsQ8hrw2r5/7/R/0nGqYSuyHzbuPMBNjX0A  me  61      D   api/Resources/cache/pools/system/OsQ8hrw2r5/7/I/vvQtFDwqqVkBfPVfQEDA   me         D   api/Resources/cache/pools/system/OsQ8hrw2r5/7/G/LmnxNwNp3t4fkK8J7MEA   me   oʤ      D   api/Resources/cache/pools/system/OsQ8hrw2r5/7/M/rmeNbVB5DeCBdaxgCl2g   me   S}Hy      D   api/Resources/cache/pools/system/OsQ8hrw2r5/7/V/Slraxjry7zIhnWaIz3Gg   me   $      D   api/Resources/cache/pools/system/OsQ8hrw2r5/7/V/bBR5rKuDenloX+mtT-Gg  me  /Y      D   api/Resources/cache/pools/system/OsQ8hrw2r5/7/X/5+VJwRInhQxngCplj3eA   me   i      D   api/Resources/cache/pools/system/OsQ8hrw2r5/7/B/Ep4F96GUQiFMkLh75w0g  me  ͏      D   api/Resources/cache/pools/system/OsQ8hrw2r5/I/H/OY1FHCvqAS0P1S5LT-wg   me   tF      D   api/Resources/cache/pools/system/OsQ8hrw2r5/I/V/FDTFq9HdFPtnwD0MTd4A   me   2ɤ      D   api/Resources/cache/pools/system/OsQ8hrw2r5/I/Y/WYfL3JD4aUS3cK6t7u3g   me   SD      D   api/Resources/cache/pools/system/OsQ8hrw2r5/I/W/4X-GtvI4JB4nNVcUy2JQ   me   Ud      D   api/Resources/cache/pools/system/OsQ8hrw2r5/N/9/V6Rdtb4jnA6+azeCCjsw   me   
Ӥ      D   api/Resources/cache/pools/system/OsQ8hrw2r5/N/Z/Tu6kTd9yUFIEmzTlJipA   me   }f_      D   api/Resources/cache/pools/system/OsQ8hrw2r5/N/A/PIILre824TeYHtR3JjSg   me   ?٤      D   api/Resources/cache/pools/system/OsQ8hrw2r5/N/-/Imp8dIyNcyFCr3RH-xRw   me   N-      D   api/Resources/cache/pools/system/OsQ8hrw2r5/N/J/C51v9J7ULPkrAjRvpMCA  me        D   api/Resources/cache/pools/system/OsQ8hrw2r5/N/J/GqfF4qBBlmsg7SvOAKIg   me   d      D   api/Resources/cache/pools/system/OsQ8hrw2r5/N/C/PZXpa3z02m60JGDzjfIw   me   M      D   api/Resources/cache/pools/system/OsQ8hrw2r5/N/L/gCe+wHAPasIwlCfS3ogg  me  3E      D   api/Resources/cache/pools/system/OsQ8hrw2r5/G/Z/latXG9ggiuXZNoa8Eqow   me   Eq      D   api/Resources/cache/pools/system/OsQ8hrw2r5/G/A/KZH6256TOL39f4ObPRXg   me   D      D   api/Resources/cache/pools/system/OsQ8hrw2r5/G/M/fT53C+-yl8hOLH3VmLAA   me   9      D   api/Resources/cache/pools/system/OsQ8hrw2r5/G/4/+a9LPIVE6fUVq7pjQJsg  me  }zO&      D   api/Resources/cache/pools/system/OsQ8hrw2r5/+/7/V3hwwqO1oa5TQJAKaGcw   me   J&b      D   api/Resources/cache/pools/system/OsQ8hrw2r5/6/K/PCCDQzufWJzzLxMZNGiQ   me   e=0      D   api/Resources/cache/pools/system/OsQ8hrw2r5/6/K/-q0MYe9pysPbCWOG18PA   me   i      D   api/Resources/cache/pools/system/OsQ8hrw2r5/Z/-/n+kGfS8uBJDSk3Ieq5YQ   me         D   api/Resources/cache/pools/system/OsQ8hrw2r5/Z/F/rLwo5ESj++dtcAgvVwXA  me  aT      D   api/Resources/cache/pools/system/OsQ8hrw2r5/Z/C/RIaqUMyxqNPdHJEyTrYg  me  W      D   api/Resources/cache/pools/system/OsQ8hrw2r5/Z/X/T+jMZ2pToPP1OZ9J0E4g   me   "      D   api/Resources/cache/pools/system/OsQ8hrw2r5/Z/K/wj2D6nO2qHqFZ3bsnQVw  me  ٤      D   api/Resources/cache/pools/system/OsQ8hrw2r5/Z/L/6BwioJyuQxWkxKei7HEw   me         D   api/Resources/cache/pools/system/OsQ8hrw2r5/1/S/NNDhBH1Aow3f4VPKTWnA   me   vK      D   api/Resources/cache/pools/system/OsQ8hrw2r5/1/3/6A4lCP0BNlgEko8v-TsA   me   J%      D   api/Resources/cache/pools/system/OsQ8hrw2r5/1/E/ZgZxupE8C17NYevudlVg   me   E      D   api/Resources/cache/pools/system/OsQ8hrw2r5/1/B/Tii38M0BR1cwTM+uYWBQ   me         D   api/Resources/cache/pools/system/OsQ8hrw2r5/8/J/XOe97mjD0WUWEm5CIuqwv   mev         D   api/Resources/cache/pools/system/OsQ8hrw2r5/T/R/8-UGopXIcK5EBHRU14kw  me  UO=      D   api/Resources/cache/pools/system/OsQ8hrw2r5/T/R/sW08sUZWg-6banDCH2-Q   me   )      D   api/Resources/cache/pools/system/OsQ8hrw2r5/T/N/Au+QEfDh3WPMluNyeldg   me   K\      D   api/Resources/cache/pools/system/OsQ8hrw2r5/T/S/F24haDgeS+QoMfuFZdAA   me   ؐS      D   api/Resources/cache/pools/system/OsQ8hrw2r5/T/O/uWCgNRwAoVl3ZvvDe8fw   me   S      D   api/Resources/cache/pools/system/OsQ8hrw2r5/T/D/y5Wd01yQp6EMeTe-Usww   me   (gѤ      D   api/Resources/cache/pools/system/OsQ8hrw2r5/T/W/f+pXqNq24DTiccv7Y2yQ   me   ӵe      D   api/Resources/cache/pools/system/OsQ8hrw2r5/S/N/09R1sWgEyovhSP8yo4dw   me   <^Ҥ      D   api/Resources/cache/pools/system/OsQ8hrw2r5/S/A/HOTbPtyMxx9jQW53nHYw   me   2\      D   api/Resources/cache/pools/system/OsQ8hrw2r5/S/O/fGCLQbg3F0OOYlaPNz1Q   me   {      D   api/Resources/cache/pools/system/OsQ8hrw2r5/S/P/f+VrsqWwJCIGWSbMGsBg   me   Ur      D   api/Resources/cache/pools/system/OsQ8hrw2r5/S/P/VeJkVIItnwBQN9PcO9vw  me  0      D   api/Resources/cache/pools/system/OsQ8hrw2r5/S/P/Oj0vJ6JMF2HEamn4SJJQ   me   쎂      D   api/Resources/cache/pools/system/OsQ8hrw2r5/A/7/z8lyPuBMM5Yj6xapSqJQ   me   >5      D   api/Resources/cache/pools/system/OsQ8hrw2r5/A/N/Fk7c3J+nTIDxSQtlGZhQ   me   #s      D   api/Resources/cache/pools/system/OsQ8hrw2r5/A/A/B+GGgc7wTs2QF5lA1UQw  me        D   api/Resources/cache/pools/system/OsQ8hrw2r5/A/O/zkQYN1br6r2EJXKGYosw   me   (LO      D   api/Resources/cache/pools/system/OsQ8hrw2r5/A/P/GkQGsahBzeJMo+cRMhTw   me   I      D   api/Resources/cache/pools/system/OsQ8hrw2r5/A/P/gdnFqbWQoLJkGctqgvew   me   ].      D   api/Resources/cache/pools/system/OsQ8hrw2r5/A/W/tdk22APgGrq8bXup2ILQ   me   |+      D   api/Resources/cache/pools/system/OsQ8hrw2r5/-/7/pB1GuYSfTqDWswsp-GGw   me   	      D   api/Resources/cache/pools/system/OsQ8hrw2r5/-/A/Pio+HqrwbHA-vjKaKQIA   me   B      D   api/Resources/cache/pools/system/OsQ8hrw2r5/F/R/tbBU+MxR5rV1Htdjnb9g  me  mB      D   api/Resources/cache/pools/system/OsQ8hrw2r5/F/7/g2wbRsxLOsH8jWtyh0Ag   me   1q
      D   api/Resources/cache/pools/system/OsQ8hrw2r5/F/O/QK+PzWAT5fubrPfojomQ  me  h*      D   api/Resources/cache/pools/system/OsQ8hrw2r5/F/J/rVdlCFOpiVQbA1VOVLkA   me   7      D   api/Resources/cache/pools/system/OsQ8hrw2r5/F/W/m8cf6BPeiPbqCZGazZzQ  me  )      D   api/Resources/cache/pools/system/OsQ8hrw2r5/O/I/MyaY3WAUKnzcblXn6MRA   me   !      D   api/Resources/cache/pools/system/OsQ8hrw2r5/O/Z/Je5ks7GkiNY9RDTGMZRw  me  n)      D   api/Resources/cache/pools/system/OsQ8hrw2r5/O/T/-UM-bxgKxDx8fQBu-gJg   me   G      D   api/Resources/cache/pools/system/OsQ8hrw2r5/O/M/RnWlDkfy0H1NGFvJcmXg  me  '6V      D   api/Resources/cache/pools/system/OsQ8hrw2r5/O/V/Wu0gDCYRESB-UFqCjEqw   me   㠌J      D   api/Resources/cache/pools/system/OsQ8hrw2r5/O/4/ZbuR7rSan7QmqcyHno1w  me  @4      D   api/Resources/cache/pools/system/OsQ8hrw2r5/O/X/KI1FBtjE4f4HEt-LP2vw   me         D   api/Resources/cache/pools/system/OsQ8hrw2r5/O/3/JfqSSAuCpNTNUjM2iXNQ   me   
jR      D   api/Resources/cache/pools/system/OsQ8hrw2r5/H/T/uqBvMcblHFy+UCbOF7Qw   me   M<      D   api/Resources/cache/pools/system/OsQ8hrw2r5/H/J/iAoNEJ3EyEpAPi-Fep1g   me   
      D   api/Resources/cache/pools/system/OsQ8hrw2r5/H/V/nG2KxyRbTzExzbdCMcGg   me   wĤ      D   api/Resources/cache/pools/system/OsQ8hrw2r5/H/2/YGNEyazPh14BqnQp0yiw   me   AY      D   api/Resources/cache/pools/system/OsQ8hrw2r5/H/W/1UkXYuOmaHArDiXwAs9g  me  ?      D   api/Resources/cache/pools/system/OsQ8hrw2r5/M/F/rKH5qWKVya9sQZTdDkxQ   me   $:      D   api/Resources/cache/pools/system/OsQ8hrw2r5/M/H/Hb88Rpe4YJP+fCxHGt7A  me  K      D   api/Resources/cache/pools/system/OsQ8hrw2r5/M/V/4ez107KY-wes1Elt1SoA   me         D   api/Resources/cache/pools/system/OsQ8hrw2r5/M/L/i6cJOd7uINIx0zVILCGA   me   -      D   api/Resources/cache/pools/system/OsQ8hrw2r5/M/2/tH7oSLMSkT5QhSrtarOw   me   7      D   api/Resources/cache/pools/system/OsQ8hrw2r5/J/+/-hri6Ku8aRxDOQwdkcrg  me         D   api/Resources/cache/pools/system/OsQ8hrw2r5/J/M/W+Yk6l0-sY1Gr6NiGeQw  me  Λڤ      D   api/Resources/cache/pools/system/OsQ8hrw2r5/J/J/ZI3dlsBQbp5p5E7GPfQg   me   f      D   api/Resources/cache/pools/system/OsQ8hrw2r5/J/X/3WTOwDNz5ZJCduG0uebw   me         D   api/Resources/cache/pools/system/OsQ8hrw2r5/J/Y/EzzpwETJoQ-5KRWfQKVA  me  9      D   api/Resources/cache/pools/system/OsQ8hrw2r5/C/R/KjFWvG5VoK9VJZMgKVjQ   me   V      D   api/Resources/cache/pools/system/OsQ8hrw2r5/C/9/RgP-Pc8QLoz3o7FedUPg  me  i      D   api/Resources/cache/pools/system/OsQ8hrw2r5/C/8/1kfbh1Hu6GYndVt4eXyg   me   W<fs      D   api/Resources/cache/pools/system/OsQ8hrw2r5/C/C/+5oLMLH7HbZvaDKwBfGw   me   hפ      D   api/Resources/cache/pools/system/OsQ8hrw2r5/C/4/ll4nwxx04P5NKyrM2pYQ  me  3      D   api/Resources/cache/pools/system/OsQ8hrw2r5/D/Z/jPYFTAOGyJ45DwH38E1g   me   5K      D   api/Resources/cache/pools/system/OsQ8hrw2r5/D/-/UO-EwuwB-u-7oesVLuDA   me         D   api/Resources/cache/pools/system/OsQ8hrw2r5/D/E/j94Cuv6W0dX+8WU-efCQ   me   7XѤ      D   api/Resources/cache/pools/system/OsQ8hrw2r5/D/E/5nyzeCEX4xPQcrisnaBA   me   DS      D   api/Resources/cache/pools/system/OsQ8hrw2r5/V/R/fRKwvMg0AlxYpg-Tf69w   me   Y%$      D   api/Resources/cache/pools/system/OsQ8hrw2r5/Q/U/xcE1afObqXOdANLnUs3A   me   yF      D   api/Resources/cache/pools/system/OsQ8hrw2r5/Q/0/93N9zx32mug1cI5z2s4w   me    `      D   api/Resources/cache/pools/system/OsQ8hrw2r5/Q/Z/1q0C15avf68uHkiUqFnA  me  H=      D   api/Resources/cache/pools/system/OsQ8hrw2r5/Q/Z/+axg0pUChZ+lK4XKCbeg  me  .
+ʤ      D   api/Resources/cache/pools/system/OsQ8hrw2r5/Q/F/Z0XRJCnmHFFvu3KRGuXg   me   j{j      D   api/Resources/cache/pools/system/OsQ8hrw2r5/Q/F/K3zds+i42tmuftsOFRXA   me   1i(m      D   api/Resources/cache/pools/system/OsQ8hrw2r5/Q/H/4QQeaEo-pXFebKAz8WUw   me   L      D   api/Resources/cache/pools/system/OsQ8hrw2r5/Q/C/3SeSt+CYISb1fU9tntXQ   me   `	ʤ      D   api/Resources/cache/pools/system/OsQ8hrw2r5/Q/3/hA0y6ZqLZnB+js6Rrt9A   me         D   api/Resources/cache/pools/system/OsQ8hrw2r5/4/P/sXzW9pvn6Jyx42u45tnA   me   pA6      D   api/Resources/cache/pools/system/OsQ8hrw2r5/X/V/X0GKI0dk0dmt1bHpxFrQ  me  T      D   api/Resources/cache/pools/system/OsQ8hrw2r5/X/L/2RCZeTvE4vNUYdEeD8kQ   me   4      D   api/Resources/cache/pools/system/OsQ8hrw2r5/X/Y/1NRb2AwJ-DfAf25-HS-A  me  R"      D   api/Resources/cache/pools/system/OsQ8hrw2r5/3/H/nIVsJP4BQ2ZvTEJpUD9A  me  8      D   api/Resources/cache/pools/system/OsQ8hrw2r5/E/R/+QVa5nTbrtKk1O4TBUvA   me   "h      D   api/Resources/cache/pools/system/OsQ8hrw2r5/E/6/09VeOWKmApL5ebfJ277w  me  Fd      D   api/Resources/cache/pools/system/OsQ8hrw2r5/E/6/nar+OcYC3FrG-rbkQQuQ   me   O      D   api/Resources/cache/pools/system/OsQ8hrw2r5/B/+/OmLTSK1RWUNPgx1WJynw   me   MrԤ      D   api/Resources/cache/pools/system/OsQ8hrw2r5/B/Z/WoCo5DSN-u7oA3dqnfOQ  me  W      D   api/Resources/cache/pools/system/OsQ8hrw2r5/B/A/JvhWrxMgogkaks0ilgIw   me   , 汤      D   api/Resources/cache/pools/system/OsQ8hrw2r5/B/K/tI0MSKVFmzQ0iIPUvpAw   me   @N      D   api/Resources/cache/pools/system/OsQ8hrw2r5/B/W/NqRfYMBbBjvEscMtHNsQ   me   ÃFU      D   api/Resources/cache/pools/system/OsQ8hrw2r5/K/F/SVhOX7E51RwBEuLldMSg   me   BY      D   api/Resources/cache/pools/system/OsQ8hrw2r5/K/O/u84jJZFwiRYqb3-3spRQ  me  #      D   api/Resources/cache/pools/system/OsQ8hrw2r5/K/C/83yLgStnUy0gT92PWPig  me  81      D   api/Resources/cache/pools/system/OsQ8hrw2r5/K/3/IpTXFAUdvPy9avle9VQQ   me   $      D   api/Resources/cache/pools/system/OsQ8hrw2r5/K/5/zxk-hZ4j5aoQ5j42Vk-Q   me         D   api/Resources/cache/pools/system/OsQ8hrw2r5/L/N/gd+rUc-BOFQUwHUanLAw   me    :l      D   api/Resources/cache/pools/system/OsQ8hrw2r5/L/N/EvvdF0xE661BhVrSaW7Q   me   W+[      D   api/Resources/cache/pools/system/OsQ8hrw2r5/L/F/KLKFIFScN8hAv5RMufNA   me   J      D   api/Resources/cache/pools/system/OsQ8hrw2r5/L/O/Ppox1+ljfyH-MDsSmKSg   me   2Q%      D   api/Resources/cache/pools/system/OsQ8hrw2r5/L/J/gByqdoXQ3ZFIpzkc7f1Q   me   I      D   api/Resources/cache/pools/system/OsQ8hrw2r5/L/C/DerUzJQpsga9boNSegiw   me   w      D   api/Resources/cache/pools/system/OsQ8hrw2r5/L/E/yE5leVw4INdqVAgsQ-ew   me   Wi      D   api/Resources/cache/pools/system/OsQ8hrw2r5/L/B/ZoZOZqbf4xxNAlg2wUOA   me   ⛤      D   api/Resources/cache/pools/system/OsQ8hrw2r5/L/L/lcDNdli9LIZJfesvvjsQ   me   S      D   api/Resources/cache/pools/system/OsQ8hrw2r5/2/B/Wmb+tbAPbG5C6wvuwh8w   me   t      D   api/Resources/cache/pools/system/OsQ8hrw2r5/Y/+/AloVHu2zHzIZQjasnC4A   me   :      D   api/Resources/cache/pools/system/OsQ8hrw2r5/Y/O/1O1lk4oGBd9xmauZILEgw   mew   ؚb      D   api/Resources/cache/pools/system/OsQ8hrw2r5/Y/L/ooSCge2IaoDuW2sK3VJQ   me   5^      D   api/Resources/cache/pools/system/OsQ8hrw2r5/5/9/BNIpfruiG93eGnUYnDMQ   me   Ū      D   api/Resources/cache/pools/system/OsQ8hrw2r5/5/G/tWg3smQrTYtf50nQ1W-g  me  :      D   api/Resources/cache/pools/system/OsQ8hrw2r5/5/6/LxtX2NxxtjXI2Dy2-K5w   me         D   api/Resources/cache/pools/system/OsQ8hrw2r5/P/H/nF3ybhOV0g-6B9sznW3w6  me6  C(!      D   api/Resources/cache/pools/system/OsQ8hrw2r5/P/M/94MyiLeo1YMkLo1khFJA  me  z      D   api/Resources/cache/pools/system/OsQ8hrw2r5/P/D/pMhOvAGnM5kfbu7bUCwA  me  %դ      D   api/Resources/cache/pools/system/OsQ8hrw2r5/P/Q/DLUN9ugv9cE+9WFJBCNg   me   Ss)      D   api/Resources/cache/pools/system/OsQ8hrw2r5/P/B/Ym6mL-Y3xQrh7wsiAFLQ   me         D   api/Resources/cache/pools/system/OsQ8hrw2r5/P/K/u9WOEgIRwowWDuKvbP5g   me   4      D   api/Resources/cache/pools/system/OsQ8hrw2r5/P/Y/fjreYGXENpzWzRLX+ALw   me         D   api/Resources/cache/pools/system/OsQ8hrw2r5/P/P/2tkLuSbKDvskXdIPZmzw   me   Pt      D   api/Resources/cache/pools/system/OsQ8hrw2r5/W/M/MF1oMu6AVXXk0aq0TQ+Q   me   l$      @   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.php  me  qc      E   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.php.lock    me              E   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.php.metae mee Yiq      -   api/Resources/cache/url_generating_routes.php%  me%  `      +   api/Resources/cache/url_matching_routes.php,  me,  V.      0   api/Resources/cache/url_matching_routes.php.meta!  me!  '[      H   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.preload.phpT  meT  9       @   api/Resources/cache/Symfony/Config/Framework/HttpCacheConfig.php  me  Bg
ؤ      <   api/Resources/cache/Symfony/Config/Framework/CacheConfig.php&  me&  P      @   api/Resources/cache/Symfony/Config/Framework/FragmentsConfig.php
  me
  T.      J   api/Resources/cache/Symfony/Config/Framework/Form/CsrfProtectionConfig.php  me  aܱ      P   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptionsConfig.php;  me;  /r      i   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig/RetryFailed/HttpCodeConfig.php  me  xA      d   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig/PeerFingerprintConfig.php	  me	  .      `   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig/RetryFailedConfig.php  me  ^l      N   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig.php%L  me%L  Ag      e   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptions/RetryFailed/HttpCodeConfig.php  me  Q      `   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptions/PeerFingerprintConfig.php	  me	  N`G      \   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptions/RetryFailedConfig.php  me  j      I   api/Resources/cache/Symfony/Config/Framework/Serializer/MappingConfig.php%  me%  zƤ      A   api/Resources/cache/Symfony/Config/Framework/ValidationConfig.php#  me#  lT3~      B   api/Resources/cache/Symfony/Config/Framework/RateLimiterConfig.phpN
  meN
  x#      U   api/Resources/cache/Symfony/Config/Framework/RateLimiter/LimiterConfig/RateConfig.phpi  mei  +Ť      J   api/Resources/cache/Symfony/Config/Framework/RateLimiter/LimiterConfig.php|  me|  L)҇      A   api/Resources/cache/Symfony/Config/Framework/Cache/PoolConfig.php  me  ;p      A   api/Resources/cache/Symfony/Config/Framework/SerializerConfig.php  me  |/      E   api/Resources/cache/Symfony/Config/Framework/CsrfProtectionConfig.php5  me5  g%      =   api/Resources/cache/Symfony/Config/Framework/AssetsConfig.php`  me`  H      N   api/Resources/cache/Symfony/Config/Framework/Notifier/AdminRecipientConfig.phpV  meV  ͤ      @   api/Resources/cache/Symfony/Config/Framework/MessengerConfig.php$  me$  '      =   api/Resources/cache/Symfony/Config/Framework/RouterConfig.php  me  f      A   api/Resources/cache/Symfony/Config/Framework/TranslatorConfig.phpS#  meS#  J       @   api/Resources/cache/Symfony/Config/Framework/WorkflowsConfig.php  me   n      J   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig.phpt(  met(  ޅ!      [   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/AuditTrailConfig.phpL  meL  m      ]   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/MarkingStoreConfig.php	  me	        [   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/TransitionConfig.php  me  Jvx      V   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/PlaceConfig.php  me  !	      :   api/Resources/cache/Symfony/Config/Framework/EsiConfig.php+  me+  bF      >   api/Resources/cache/Symfony/Config/Framework/WebLinkConfig.php/  me/  h      F   api/Resources/cache/Symfony/Config/Framework/Mailer/EnvelopeConfig.php  me  cJˤ      D   api/Resources/cache/Symfony/Config/Framework/Mailer/HeaderConfig.php  me  ٤      :   api/Resources/cache/Symfony/Config/Framework/SsiConfig.php+  me+  q      T   api/Resources/cache/Symfony/Config/Framework/Translator/PseudoLocalizationConfig.php}  me}  4      J   api/Resources/cache/Symfony/Config/Framework/Translator/ProviderConfig.php	  me	  P      ?   api/Resources/cache/Symfony/Config/Framework/ProfilerConfig.php  me  r      >   api/Resources/cache/Symfony/Config/Framework/SecretsConfig.php
  me
  3      E   api/Resources/cache/Symfony/Config/Framework/PropertyAccessConfig.php  me  Лh      J   api/Resources/cache/Symfony/Config/Framework/Messenger/TransportConfig.php*  me*        ]   api/Resources/cache/Symfony/Config/Framework/Messenger/Serializer/SymfonySerializerConfig.php"  me"  %<      K   api/Resources/cache/Symfony/Config/Framework/Messenger/SerializerConfig.phpl  mel  Za      ^   api/Resources/cache/Symfony/Config/Framework/Messenger/TransportConfig/RetryStrategyConfig.php5  me5        H   api/Resources/cache/Symfony/Config/Framework/Messenger/RoutingConfig.php<  me<  ~̤      U   api/Resources/cache/Symfony/Config/Framework/Messenger/BusConfig/MiddlewareConfig.php  me  ̳      D   api/Resources/cache/Symfony/Config/Framework/Messenger/BusConfig.php
  me
  =      C   api/Resources/cache/Symfony/Config/Framework/PropertyInfoConfig.php3  me3  N      =   api/Resources/cache/Symfony/Config/Framework/MailerConfig.php  me  5      :   api/Resources/cache/Symfony/Config/Framework/UidConfig.php
  me
  6      @   api/Resources/cache/Symfony/Config/Framework/ExceptionConfig.phpK  meK  r      >   api/Resources/cache/Symfony/Config/Framework/SessionConfig.php4  me4  e@      A   api/Resources/cache/Symfony/Config/Framework/HttpClientConfig.php  me  ܤ      @   api/Resources/cache/Symfony/Config/Framework/PhpErrorsConfig.php  me        ?   api/Resources/cache/Symfony/Config/Framework/NotifierConfig.php  me  StVȤ      >   api/Resources/cache/Symfony/Config/Framework/RequestConfig.php  me  :      B   api/Resources/cache/Symfony/Config/Framework/AnnotationsConfig.php}  me}  
j(      E   api/Resources/cache/Symfony/Config/Framework/Assets/PackageConfig.php   me         X   api/Resources/cache/Symfony/Config/Framework/Validation/NotCompromisedPasswordConfig.php5  me5  	6      I   api/Resources/cache/Symfony/Config/Framework/Validation/MappingConfig.php%  me%  ,      M   api/Resources/cache/Symfony/Config/Framework/Validation/AutoMappingConfig.phpM  meM  BФ      ;   api/Resources/cache/Symfony/Config/Framework/LockConfig.php  me        ;   api/Resources/cache/Symfony/Config/Framework/FormConfig.php  me  
      P   api/Resources/cache/Symfony/Config/Security/ProviderConfig/Memory/UserConfig.php  me  U`      I   api/Resources/cache/Symfony/Config/Security/ProviderConfig/LdapConfig.php~  me~  b      K   api/Resources/cache/Symfony/Config/Security/ProviderConfig/MemoryConfig.phpE	  meE	        J   api/Resources/cache/Symfony/Config/Security/ProviderConfig/ChainConfig.phpV  meV  BFc)      D   api/Resources/cache/Symfony/Config/Security/PasswordHasherConfig.php  me  T      >   api/Resources/cache/Symfony/Config/Security/ProviderConfig.php  me  p      =   api/Resources/cache/Symfony/Config/Security/EncoderConfig.phpz  mez  ؤ      >   api/Resources/cache/Symfony/Config/Security/FirewallConfig.phpp  mep  Y      O   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RememberMeConfig.php0  me0  aܤ      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/FormLoginConfig.phpA  meA  w      R   api/Resources/cache/Symfony/Config/Security/FirewallConfig/JsonLoginLdapConfig.phpp)  mep)        N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/HttpBasicConfig.php  me  &      J   api/Resources/cache/Symfony/Config/Security/FirewallConfig/GuardConfig.php  me  'i      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/JsonLoginConfig.php  me  }      X   api/Resources/cache/Symfony/Config/Security/FirewallConfig/Logout/DeleteCookieConfig.php.  me.  [r      O   api/Resources/cache/Symfony/Config/Security/FirewallConfig/SwitchUserConfig.php
  me
  [B      T   api/Resources/cache/Symfony/Config/Security/FirewallConfig/LoginThrottlingConfig.php
  me
  n      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/LoginLinkConfig.php]3  me]3  
k      f   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RememberMe/TokenProvider/DoctrineConfig.php  me  Ҥ      ]   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RememberMe/TokenProviderConfig.php)  me)  Tפ      R   api/Resources/cache/Symfony/Config/Security/FirewallConfig/FormLoginLdapConfig.phpxM  mexM  5W      R   api/Resources/cache/Symfony/Config/Security/FirewallConfig/HttpBasicLdapConfig.php  me  
ĞȤ      I   api/Resources/cache/Symfony/Config/Security/FirewallConfig/X509Config.php*
  me*
  y      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/AnonymousConfig.php  me  +f      O   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RemoteUserConfig.php  me  &      K   api/Resources/cache/Symfony/Config/Security/FirewallConfig/LogoutConfig.php  me  ʿ,      K   api/Resources/cache/Symfony/Config/Security/AccessDecisionManagerConfig.php  me  I      C   api/Resources/cache/Symfony/Config/Security/AccessControlConfig.php  me  ϐ      5   api/Resources/cache/Symfony/Config/SecurityConfig.php:  me:  m      4   api/Resources/cache/Symfony/Config/MonologConfig.php  me  tˤ      <   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig.php me yդ      V   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ProcessPsr3MessagesConfig.php
  me
  Ӭx      L   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/PublisherConfig.php  me        H   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/RedisConfig.php  me  =      P   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ElasticsearchConfig.php  me  p7      Q   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/EmailPrototypeConfig.phpV  meV  ˊ      H   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/MongoConfig.php  me  d%7      R   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/VerbosityLevelsConfig.php  me  Q,C      I   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/PredisConfig.php6  me6  |!v      S   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ExcludedHttpCodeConfig.php[  me[        K   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ChannelsConfig.php  me  v      6   api/Resources/cache/Symfony/Config/FrameworkConfig.php  me  M      T   api/Resources/cache/ContainerUyuaDAM/getSecurity_Firewall_Map_Context_ApiService.php
  me
  ͜      F   api/Resources/cache/ContainerUyuaDAM/getComposerController2Service.php  me  a ;U      N   api/Resources/cache/ContainerUyuaDAM/getConsole_Command_SecretsListService.php  me  Hi      P   api/Resources/cache/ContainerUyuaDAM/getConsole_Command_SecretsRemoveService.php  me  Wؤ      C   api/Resources/cache/ContainerUyuaDAM/getGraphicsLibCheckService.php  me  >ڤ      C   api/Resources/cache/ContainerUyuaDAM/getPhpCliControllerService.phpe  mee  i_      D   api/Resources/cache/ContainerUyuaDAM/getTaskDeleteCommandService.php  me  L      ]   api/Resources/cache/ContainerUyuaDAM/get_Security_Command_UserPasswordEncoder_LazyService.php  me  Th      `   api/Resources/cache/ContainerUyuaDAM/get_Console_Command_SecretsEncryptFromLocal_LazyService.php  me  \jҤ      G   api/Resources/cache/ContainerUyuaDAM/getConstraintControllerService.php\  me\  A      4   api/Resources/cache/ContainerUyuaDAM/removed-ids.phpʎ  meʎ  
      G   api/Resources/cache/ContainerUyuaDAM/getProcessRunnerCommandService.phpP  meP        C   api/Resources/cache/ContainerUyuaDAM/getJwtAuthenticatorService.php  me  lڤ      C   api/Resources/cache/ContainerUyuaDAM/getContaoControllerService.php>  me>  w      E   api/Resources/cache/ContainerUyuaDAM/getSecurity_AccessMapService.php:  me:  *5Eu      H   api/Resources/cache/ContainerUyuaDAM/getIntegrityCheckFactoryService.php  me  k      J   api/Resources/cache/ContainerUyuaDAM/get_ServiceLocator_DieSC3PService.php  me  /      Q   api/Resources/cache/ContainerUyuaDAM/getConsole_Command_ContainerDebugService.php  me  9      W   api/Resources/cache/ContainerUyuaDAM/get_Console_Command_ContainerDebug_LazyService.php  me  Di1      a   api/Resources/cache/ContainerUyuaDAM/getSecurity_Authentication_Listener_Anonymous_ApiService.php  me  ͤ      F   api/Resources/cache/ContainerUyuaDAM/getJwtCookieControllerService.php  me  v%ʤ      E   api/Resources/cache/ContainerUyuaDAM/getRouter_CacheWarmerService.php  me  -m      D   api/Resources/cache/ContainerUyuaDAM/getBackupRestoreTaskService.php  me        H   api/Resources/cache/ContainerUyuaDAM/getConsole_CommandLoaderService.php  me  ^b      <   api/Resources/cache/ContainerUyuaDAM/getCache_AppService.php  me  h/      M   api/Resources/cache/ContainerUyuaDAM/getConsole_Command_SecretsSetService.php  me  t"匤      T   api/Resources/cache/ContainerUyuaDAM/getSecurity_Command_UserPasswordHashService.php  me  ߎ      H   api/Resources/cache/ContainerUyuaDAM/getConsoleProcessFactoryService.phpc  mec  V	V      \   api/Resources/cache/ContainerUyuaDAM/get_Console_Command_ConfigDumpReference_LazyService.php  me  MT      C   api/Resources/cache/ContainerUyuaDAM/getCache_AppClearerService.phpj  mej  :Ť      A   api/Resources/cache/ContainerUyuaDAM/getUserControllerService.php  me  ]      N   api/Resources/cache/ContainerUyuaDAM/getConsole_Command_RouterDebugService.php  me  Z      Q   api/Resources/cache/ContainerUyuaDAM/Contao_ManagerApi_ApiKernelProdContainer.php  me  hE      K   api/Resources/cache/ContainerUyuaDAM/getAnnotations_CachedReaderService.phpl  mel  1      W   api/Resources/cache/ContainerUyuaDAM/get_Console_Command_CachePoolPrune_LazyService.phpj  mej  ?44      D   api/Resources/cache/ContainerUyuaDAM/getTaskUpdateCommandService.php  me  H      A   api/Resources/cache/ContainerUyuaDAM/getTaskControllerService.php  me  ?\      L   api/Resources/cache/ContainerUyuaDAM/getMaintenanceModeControllerService.php  me  ݡ      A   api/Resources/cache/ContainerUyuaDAM/getFileControllerService.php.  me.  CIǤ      A   api/Resources/cache/ContainerUyuaDAM/getRouting_LoaderService.php  me  cj
      >   api/Resources/cache/ContainerUyuaDAM/getEnvironmentService.php  me        C   api/Resources/cache/ContainerUyuaDAM/getServicesResetterService.php<  me<  Ӄ      D   api/Resources/cache/ContainerUyuaDAM/getOpcacheControllerService.phpj  mej  w      P   api/Resources/cache/ContainerUyuaDAM/getConsole_Command_AssetsInstallService.php  me  }L      E   api/Resources/cache/ContainerUyuaDAM/getLoginAuthenticatorService.php.  me.  y ۤ      O   api/Resources/cache/ContainerUyuaDAM/getSecurity_EventDispatcher_ApiService.php   me   V¤      ?   api/Resources/cache/ContainerUyuaDAM/getCache_SystemService.php  me  ן      A   api/Resources/cache/ContainerUyuaDAM/getMonolog_LoggerService.php  me  3      X   api/Resources/cache/ContainerUyuaDAM/get_Console_Command_CachePoolDelete_LazyService.php  me  Α      J   api/Resources/cache/ContainerUyuaDAM/getMonolog_Logger_SecurityService.php  me  \@      @   api/Resources/cache/ContainerUyuaDAM/getUpdateCommandService.php  me  ojZ      U   api/Resources/cache/ContainerUyuaDAM/getSecurity_Access_AuthenticatedVoterService.phpA  meA  V*"ۤ      ?   api/Resources/cache/ContainerUyuaDAM/getProcessCheckService.php  me  \Cj      D   api/Resources/cache/ContainerUyuaDAM/getSessionControllerService.php  me  )      A   api/Resources/cache/ContainerUyuaDAM/getSelfUpdateTaskService.php  me  b"      F   api/Resources/cache/ContainerUyuaDAM/getCache_GlobalClearerService.phpH  meH  	C
      >   api/Resources/cache/ContainerUyuaDAM/getTaskManagerService.phpA  meA  o      H   api/Resources/cache/ContainerUyuaDAM/getConsole_ErrorListenerService.php  me  &I      K   api/Resources/cache/ContainerUyuaDAM/getUploadPackagesControllerService.php  me  Mn      <   api/Resources/cache/ContainerUyuaDAM/getContaoApiService.php]  me]  #Ojɤ      C   api/Resources/cache/ContainerUyuaDAM/getMemoryLimitCheckService.php  me   ej      W   api/Resources/cache/ContainerUyuaDAM/get_Security_Command_DebugFirewall_LazyService.php  me  f      B   api/Resources/cache/ContainerUyuaDAM/getSysTempDirCheckService.php  me  7q
      ]   api/Resources/cache/ContainerUyuaDAM/getSecurity_Authentication_Listener_Guard_ApiService.php  me  8B      V   api/Resources/cache/ContainerUyuaDAM/get_Console_Command_SecretsRemove_LazyService.phpl  mel  oMm      R   api/Resources/cache/ContainerUyuaDAM/getSecurity_Authentication_ManagerService.php  me  gUH      W   api/Resources/cache/ContainerUyuaDAM/getSecurity_Authentication_GuardHandlerService.phpl  mel  sr      C   api/Resources/cache/ContainerUyuaDAM/getConfigControllerService.php[  me[  y      =   api/Resources/cache/ContainerUyuaDAM/getSelfUpdateService.php  me  d      C   api/Resources/cache/ContainerUyuaDAM/getTaskAbortCommandService.php  me  t      @   api/Resources/cache/ContainerUyuaDAM/getCloudResolverService.phpG  meG  z$      ^   api/Resources/cache/ContainerUyuaDAM/get_Console_Command_SecretsDecryptToLocal_LazyService.php  me  kƤ      R   api/Resources/cache/ContainerUyuaDAM/getSecurity_EncoderFactory_GenericService.php  me  T3      F   api/Resources/cache/ContainerUyuaDAM/getAccessKeyControllerService.php  me  6<$      C   api/Resources/cache/ContainerUyuaDAM/getPhpWebControllerService.php  me  a}"      P   api/Resources/cache/ContainerUyuaDAM/getConsole_Command_ContainerLintService.php  me        N   api/Resources/cache/ContainerUyuaDAM/get_Console_Command_About_LazyService.php?  me?  J(,6      T   api/Resources/cache/ContainerUyuaDAM/get_Console_Command_RouterMatch_LazyService.phpq  meq  [;8      =   api/Resources/cache/ContainerUyuaDAM/getTranslatorService.php  me        G   api/Resources/cache/ContainerUyuaDAM/getSelfUpdateControllerService.phpy  mey  ˘      K   api/Resources/cache/ContainerUyuaDAM/getSecurity_ChannelListenerService.php  me  4
l      D   api/Resources/cache/ContainerUyuaDAM/getManagerControllerService.php  me  #k|$      C   api/Resources/cache/ContainerUyuaDAM/getBackupControllerService.phpy  mey  q      Q   api/Resources/cache/ContainerUyuaDAM/get_Console_Command_YamlLint_LazyService.phpZ  meZ  c-u      ^   api/Resources/cache/ContainerUyuaDAM/get_Container_Private_Security_PasswordEncoderService.phpG  meG  _0
      @   api/Resources/cache/ContainerUyuaDAM/getSecrets_VaultService.php  me  `t      V   api/Resources/cache/ContainerUyuaDAM/getConsole_Command_ConfigDumpReferenceService.php  me  B      N   api/Resources/cache/ContainerUyuaDAM/getConsole_Command_CacheWarmupService.php  me  (      B   api/Resources/cache/ContainerUyuaDAM/getLoaderInterfaceService.php  me  )      C   api/Resources/cache/ContainerUyuaDAM/getBackupCreateTaskService.php  me  ]LϤ      a   api/Resources/cache/ContainerUyuaDAM/getSecurity_Authentication_Provider_Anonymous_ApiService.php<  me<  ܲU      R   api/Resources/cache/ContainerUyuaDAM/getConsole_Command_CachePoolDeleteService.php  me  $!8      B   api/Resources/cache/ContainerUyuaDAM/getCloudControllerService.phpb  meb  6ˤ      <   api/Resources/cache/ContainerUyuaDAM/getSetupTaskService.phpW  meW  {      S   api/Resources/cache/ContainerUyuaDAM/get_Console_Command_SecretsSet_LazyService.phpR  meR  g|      E   api/Resources/cache/ContainerUyuaDAM/getTemplateControllerService.phpq  meq  mʝ
      ]   api/Resources/cache/ContainerUyuaDAM/get_Console_Command_EventDispatcherDebug_LazyService.php  me  Ĥ      V   api/Resources/cache/ContainerUyuaDAM/get_Console_Command_CachePoolList_LazyService.phpl  mel  ؙ      W   api/Resources/cache/ContainerUyuaDAM/getSecurity_Command_UserPasswordEncoderService.php  me  -٠      W   api/Resources/cache/ContainerUyuaDAM/getConsole_Command_EventDispatcherDebugService.phpp  mep  _Ĥ      K   api/Resources/cache/ContainerUyuaDAM/getArgumentResolver_ServiceService.php  me  1N+Ť      T   api/Resources/cache/ContainerUyuaDAM/get_Console_Command_CacheWarmup_LazyService.phpV  meV  ^NIg      F   api/Resources/cache/ContainerUyuaDAM/getCache_SystemClearerService.php  me  Ƥ      G   api/Resources/cache/ContainerUyuaDAM/getMonolog_Logger_TasksService.php  me  5{D      F   api/Resources/cache/ContainerUyuaDAM/getAdminUserControllerService.php  me  7_      H   api/Resources/cache/ContainerUyuaDAM/getIntegrityCheckCommandService.php  me        V   api/Resources/cache/ContainerUyuaDAM/get_Console_Command_AssetsInstall_LazyService.php  me        E   api/Resources/cache/ContainerUyuaDAM/getPhpExtensionsCheckService.php  me        A   api/Resources/cache/ContainerUyuaDAM/getAuthControllerService.php  me  Q      ]   api/Resources/cache/ContainerUyuaDAM/getSecurity_Authentication_Provider_Guard_ApiService.php	  me	  29Ƥ      L   api/Resources/cache/ContainerUyuaDAM/getInstallToolLockControllerService.php  me  `F]      E   api/Resources/cache/ContainerUyuaDAM/getComposerControllerService.php  me  +$      >   api/Resources/cache/ContainerUyuaDAM/getCacheWarmerService.php%  me%  /      E   api/Resources/cache/ContainerUyuaDAM/getRedirectControllerService.phpB  meB  =eݤ      E   api/Resources/cache/ContainerUyuaDAM/getAnnotations_ReaderService.php  me  >"      @   api/Resources/cache/ContainerUyuaDAM/getUploadsConfigService.php  me        N   api/Resources/cache/ContainerUyuaDAM/getDatabaseMigrationControllerService.php  me        J   api/Resources/cache/ContainerUyuaDAM/get_ServiceLocator_4uC2EhjService.php  me  {As      K   api/Resources/cache/ContainerUyuaDAM/getConsole_Command_YamlLintService.php  me  @      G   api/Resources/cache/ContainerUyuaDAM/getConfigBuilder_WarmerService.php  me  Bm^q      L   api/Resources/cache/ContainerUyuaDAM/getPasswordlessAuthenticatorService.phpL  meL  ۻ$      A   api/Resources/cache/ContainerUyuaDAM/getClearCacheTaskService.php  me  Fᩤ      H   api/Resources/cache/ContainerUyuaDAM/getRootPackageControllerService.php  me  l      Q   api/Resources/cache/ContainerUyuaDAM/getSecurity_PasswordHasherFactoryService.phpa  mea  i,      @   api/Resources/cache/ContainerUyuaDAM/getContaoConsoleService.php  me  #P      @   api/Resources/cache/ContainerUyuaDAM/getManagerConfigService.php  me  M(4Y      M   api/Resources/cache/ContainerUyuaDAM/getSecurity_UserValueResolverService.php  me  Mg      X   api/Resources/cache/ContainerUyuaDAM/get_Console_Command_DebugAutowiring_LazyService.php  me  >a>      Q   api/Resources/cache/ContainerUyuaDAM/getSecurity_Command_DebugFirewallService.php  me  {      J   api/Resources/cache/ContainerUyuaDAM/getAnnotations_CacheWarmerService.php6  me6  N Ӥ      W   api/Resources/cache/ContainerUyuaDAM/get_Console_Command_CachePoolClear_LazyService.phpj  mej  (Ф      R   api/Resources/cache/ContainerUyuaDAM/get_Container_Private_CacheClearerService.php  me  &y      M   api/Resources/cache/ContainerUyuaDAM/getConsole_Command_CacheClearService.php  me  B[      J   api/Resources/cache/ContainerUyuaDAM/get_ServiceLocator_XUrKPVUService.php	  me	  n#Ѥ      D   api/Resources/cache/ContainerUyuaDAM/getPhpinfoControllerService.phpj  mej  r      P   api/Resources/cache/ContainerUyuaDAM/getConsole_Command_CachePoolListService.php  me  vә      E   api/Resources/cache/ContainerUyuaDAM/getAllowUrlFopenCheckService.php  me  9v      C   api/Resources/cache/ContainerUyuaDAM/getRebuildCacheTaskService.phpo  meo  s	ld      [   api/Resources/cache/ContainerUyuaDAM/get_Console_Command_SecretsGenerateKey_LazyService.php  me  X?      T   api/Resources/cache/ContainerUyuaDAM/get_Console_Command_RouterDebug_LazyService.phpi  mei  O値      Q   api/Resources/cache/ContainerUyuaDAM/getConsole_Command_CachePoolClearService.php  me  V      @   api/Resources/cache/ContainerUyuaDAM/getLogControllerService.php)  me)  G      L   api/Resources/cache/ContainerUyuaDAM/getContainer_EnvVarProcessorService.php  me  1>*      >   api/Resources/cache/ContainerUyuaDAM/getInstallTaskService.php"  me"  ±      T   api/Resources/cache/ContainerUyuaDAM/getContainer_EnvVarProcessorsLocatorService.php3  me3  Yդ      D   api/Resources/cache/ContainerUyuaDAM/getExceptionListenerService.php  me  :      ?   api/Resources/cache/ContainerUyuaDAM/getSymlinkCheckService.php  me  {]      :   api/Resources/cache/ContainerUyuaDAM/getRequestService.php  me  )4      ?   api/Resources/cache/ContainerUyuaDAM/getSessionCheckService.php  me  [      L   api/Resources/cache/ContainerUyuaDAM/getMissingPackagesControllerService.php  me  W      U   api/Resources/cache/ContainerUyuaDAM/getConsole_Command_SecretsGenerateKeyService.php  me  6%      =   api/Resources/cache/ContainerUyuaDAM/getUpdateTaskService.php  me  :¤      T   api/Resources/cache/ContainerUyuaDAM/get_Console_Command_SecretsList_LazyService.phpP  meP  I\      A   api/Resources/cache/ContainerUyuaDAM/getComposerConfigService.php  me  \
      Z   api/Resources/cache/ContainerUyuaDAM/getConsole_Command_SecretsEncryptFromLocalService.phpB  meB  ?      J   api/Resources/cache/ContainerUyuaDAM/getSecurity_AccessListenerService.php  me  7T٤      Q   api/Resources/cache/ContainerUyuaDAM/getConsole_Command_CachePoolPruneService.phpy  mey  ɤ      Z   api/Resources/cache/ContainerUyuaDAM/get_Security_Command_UserPasswordHash_LazyService.php  me  C      T   api/Resources/cache/ContainerUyuaDAM/get_Console_Command_ConfigDebug_LazyService.phpo  meo   Ф      E   api/Resources/cache/ContainerUyuaDAM/getDatabaseControllerService.phpk  mek        J   api/Resources/cache/ContainerUyuaDAM/get_ServiceLocator_3CSu656Service.php  me  oE}      X   api/Resources/cache/ContainerUyuaDAM/getConsole_Command_SecretsDecryptToLocalService.phpF  meF  \      J   api/Resources/cache/ContainerUyuaDAM/getLocalPackagesControllerService.php  me  Ѿ      ?   api/Resources/cache/ContainerUyuaDAM/getAboutCommandService.php  me  ;      E   api/Resources/cache/ContainerUyuaDAM/getTokenAuthenticatorService.php  me  C>      R   api/Resources/cache/ContainerUyuaDAM/getConsole_Command_DebugAutowiringService.php  me  0I      =   api/Resources/cache/ContainerUyuaDAM/getServerInfoService.php6  me6  7      N   api/Resources/cache/ContainerUyuaDAM/getConsole_Command_RouterMatchService.php~  me~  PC      B   api/Resources/cache/ContainerUyuaDAM/getErrorControllerService.phpl  mel  #,      J   api/Resources/cache/ContainerUyuaDAM/get_ServiceLocator_XRi_MOZService.php  me        S   api/Resources/cache/ContainerUyuaDAM/get_Console_Command_CacheClear_LazyService.phpH  meH        H   api/Resources/cache/ContainerUyuaDAM/getConsole_Command_AboutService.php  me  pj      C   api/Resources/cache/ContainerUyuaDAM/getDumpAutoloadTaskService.php  me  LJC      V   api/Resources/cache/ContainerUyuaDAM/get_Console_Command_ContainerLint_LazyService.php  me  ä      N   api/Resources/cache/ContainerUyuaDAM/getConsole_Command_ConfigDebugService.php  me  o
      #   api/Resources/cache/annotations.map)  me)  8J)f      #   api/Resources/config/config_dev.yml  me  =y      $   api/Resources/config/config_prod.yml   me   ݣ      !   api/Resources/config/services.yml  me  gѤ         api/Resources/config/config.yml9  me9  zH         api/Resources/i18n/cs.yml  me  e%ߤ         api/Resources/i18n/br.yml  me           api/Resources/i18n/es.yml  me           api/Resources/i18n/pt.yml  me  ۛ|         api/Resources/i18n/de.yml.  me.  (L         api/Resources/i18n/it.yml  me  k         api/Resources/i18n/pl.yml  me  6T         api/Resources/i18n/fa.yml;	  me;	  1,         api/Resources/i18n/sv.yml  me  {͜Ԥ         api/Resources/i18n/en.yml  me  fZ/         api/Resources/i18n/ja.yml  me  Pf         api/Resources/i18n/ru.yml  me           api/Resources/i18n/sr.yml  me  G         api/Resources/i18n/fr.yml  me  >{[         api/Resources/i18n/lv.ymlN  meN  'ݤ         api/Resources/i18n/tr.yml  me  f         api/Resources/i18n/nl.yml  me  4         api/Resources/i18n/zh.yml
  me
  ֤         api/ApiApplication.php5  me5  4      #   api/Tests/Composer/CloudJobTest.php  me  ^      !   api/Controller/FileController.phpI  meI  Ye@      !   api/Controller/UserController.php  me  @H          api/Controller/LogController.php<  me<  l       (   api/Controller/Config/AuthController.php  me  Q      2   api/Controller/Config/AbstractConfigController.php)  me)  s      ,   api/Controller/Config/ComposerController.php7  me7  r      +   api/Controller/Config/ManagerController.php3  me3  &Y      !   api/Controller/TaskController.php  me  /      *   api/Controller/Server/PhpWebController.php  me  ;ۉ      *   api/Controller/Server/ContaoController.php"  me"  Rˤ      ,   api/Controller/Server/DatabaseController.php  me  o      -   api/Controller/Server/AdminUserController.php[
  me[
        +   api/Controller/Server/PhpinfoController.php  me  p%      +   api/Controller/Server/OpcacheController.php_  me_  ؚ      *   api/Controller/Server/ConfigController.php  me  @n-      ,   api/Controller/Server/ComposerController.php  me  oϤ      *   api/Controller/Server/PhpCliController.php  me  $      .   api/Controller/Server/SelfUpdateController.php  me  	쟤      $   api/Controller/SessionController.php  me        5   api/Controller/Packages/MissingPackagesController.php]	  me]	  T
v      4   api/Controller/Packages/UploadPackagesController.php@'  me@'  
      1   api/Controller/Packages/RootPackageController.php  me  %I      +   api/Controller/Packages/CloudController.php[  me[  ى      3   api/Controller/Packages/LocalPackagesController.php  me  㦜      '   api/Controller/ConstraintController.php  me  ;rs      3   api/Controller/Contao/InstallToolLockController.phpc  mec  G?      5   api/Controller/Contao/DatabaseMigrationController.phpL#  meL#  #      -   api/Controller/Contao/AccessKeyController.php
  me
  	ؤ      *   api/Controller/Contao/BackupController.php  me  <4      3   api/Controller/Contao/MaintenanceModeController.php  me  Cӗh      -   api/Controller/Contao/JwtCookieController.phpz  mez  Ҵٝ         api/ApiKernel.php"'  me"'           api/System/ServerInfo.php  me  Z$         api/System/Request.php  me  8         api/System/SelfUpdate.phpn  men           api/Task/TaskStatus.phpG  meG  HK      &   api/Task/Composer/DumpAutoloadTask.php  me  (      $   api/Task/Composer/ClearCacheTask.phpd  med  :	      #   api/Task/Manager/SelfUpdateTask.php  me  ݤ         api/Task/AbstractTask.phpT  meT  ۤ         api/Task/Packages/SetupTask.php.  me.  &L          api/Task/Packages/UpdateTask.php")  me")  59      !   api/Task/Packages/InstallTask.phpU
  meU
  sE      *   api/Task/Packages/AbstractPackagesTask.php<  me<  iz=      $   api/Task/Contao/BackupCreateTask.phph  meh  "=      %   api/Task/Contao/BackupRestoreTask.phpS  meS  0      $   api/Task/Contao/RebuildCacheTask.php3
  me3
  ]`         api/Task/TaskManager.php  me  =p$         api/Task/TaskInterface.php  me  ]$         api/Task/TaskConfig.php}
  me}
  HYq      %   api/Command/IntegrityCheckCommand.php*	  me*	  \w         api/Command/UpdateCommand.php7  me7  <          api/Command/TaskAbortCommand.php  me  >Ϥ      !   api/Command/TaskUpdateCommand.phpL  meL  TԤ      $   api/Command/ProcessRunnerCommand.php  me  g|0         api/Command/AboutCommand.php  me  5      !   api/Command/TaskDeleteCommand.php"  me"  +v         api/I18n/Translator.phpt  met  ߤ      %   api/Exception/ApiProblemException.phps  mes  
Q\      (   api/Exception/ProcessOutputException.php  me  Z
      &   api/Exception/InvalidJsonException.php  me  껤      "   api/Exception/RequestException.php  me  W91      )   api/IntegrityCheck/AllowUrlFopenCheck.php!  me!  -.      '   api/IntegrityCheck/GraphicsLibCheck.php  me        &   api/IntegrityCheck/SysTempDirCheck.php  me  P      .   api/IntegrityCheck/IntegrityCheckInterface.phpz  mez  {	|      #   api/IntegrityCheck/ProcessCheck.php  me  nW$      #   api/IntegrityCheck/SymlinkCheck.php  me  ߠ      #   api/IntegrityCheck/SessionCheck.php  me  5ˋ      '   api/IntegrityCheck/MemoryLimitCheck.php  me        )   api/IntegrityCheck/PhpExtensionsCheck.php  me  P      -   api/IntegrityCheck/AbstractIntegrityCheck.php  me  :{      ,   api/IntegrityCheck/IntegrityCheckFactory.php  me  7'         api/Process/ContaoApi.php  me  U      !   api/Process/ProcessController.phpe  mee  xƤ      %   api/Process/Forker/AbstractForker.php  me  [ 2      &   api/Process/Forker/ForkerInterface.phpd  med  /^      #   api/Process/Forker/DisownForker.php  me  ]       "   api/Process/Forker/NohupForker.php  me  !      )   api/Process/Forker/WindowsStartForker.php  me  
      #   api/Process/Forker/InlineForker.php  me  Ѷ#         api/Process/Utf8Process.php  me  SҤ         api/Process/ProcessRunner.php  me  ä         api/Process/AbstractProcess.php  me  /
         api/Process/ContaoConsole.php!  me!  vE      #   api/Process/PhpExecutableFinder.phpn  men  L	      %   api/Process/ConsoleProcessFactory.php  me  `         api/console8  me8  i.      $   api/EventListener/LocaleListener.php  me  .ʴ,      '   api/EventListener/ExceptionListener.phpQ
  meQ
  Hq      &   api/EventListener/SecurityListener.php  me  _m      )   api/EventListener/JsonRequestListener.php  me  ĩ      
   downgrade.php0  me0  q2      $   vendor/seld/phar-utils/composer.lock/  me/  cւ(         vendor/seld/phar-utils/LICENSE"  me"  ?e          vendor/seld/phar-utils/README.mde  mee  :N      $   vendor/seld/phar-utils/composer.json;  me;  =      %   vendor/seld/phar-utils/src/Linter.php
  me
  #:	      )   vendor/seld/phar-utils/src/Timestamps.phpk  mek  F         vendor/seld/jsonlint/LICENSE"  me"  asy      !   vendor/seld/jsonlint/bin/jsonlint  me   
      !   vendor/seld/jsonlint/CHANGELOG.md	  me	  ݣʤ         vendor/seld/jsonlint/README.md  me  p'j      "   vendor/seld/jsonlint/composer.jsonT  meT  z|s      @   vendor/seld/jsonlint/src/Seld/JsonLint/DuplicateKeyException.php  me  ArQ      ;   vendor/seld/jsonlint/src/Seld/JsonLint/ParsingException.php  me  m2;      0   vendor/seld/jsonlint/src/Seld/JsonLint/Lexer.php"  me"  ;      4   vendor/seld/jsonlint/src/Seld/JsonLint/Undefined.php*  me*        5   vendor/seld/jsonlint/src/Seld/JsonLint/JsonParser.php}Y  me}Y  3q      "   vendor/seld/signal-handler/LICENSE"  me"  ?e      (   vendor/seld/signal-handler/composer.json  me  c      0   vendor/seld/signal-handler/src/SignalHandler.phpO  meO  ,C         vendor/autoload.php  me  l         vendor/bin/yaml-lint
  me
  8<h      "   vendor/bin/patch-type-declarations`
  me`
  +դ         vendor/bin/validate-json0
  me0
  ̤         vendor/bin/composer	
  me	
  k?ۤ         vendor/bin/var-dump-server?
  me?
  &j         vendor/bin/jsonlint  me  X      '   vendor/composer/autoload_namespaces.php   me   /t      &   vendor/composer/xdebug-handler/LICENSE)  me)  #;^      +   vendor/composer/xdebug-handler/CHANGELOG.mdv  mev        (   vendor/composer/xdebug-handler/README.mdg3  meg3  p      ,   vendor/composer/xdebug-handler/composer.jsonq  meq  iL      0   vendor/composer/xdebug-handler/src/PhpConfig.php  me  ]      -   vendor/composer/xdebug-handler/src/Status.php  me  ?Ȥ      4   vendor/composer/xdebug-handler/src/XdebugHandler.phpO  meO  I      .   vendor/composer/xdebug-handler/src/Process.php$  me$        +   vendor/composer/class-map-generator/LICENSE  me  DӤ      -   vendor/composer/class-map-generator/README.mdP  meP  7ta      1   vendor/composer/class-map-generator/composer.json  me  \1%ޤ      =   vendor/composer/class-map-generator/src/ClassMapGenerator.php3  me3  `      :   vendor/composer/class-map-generator/src/PhpFileCleaner.php  me  Ҥ      4   vendor/composer/class-map-generator/src/FileList.phpc  mec  r5      9   vendor/composer/class-map-generator/src/PhpFileParser.php?  me?  %Kq      4   vendor/composer/class-map-generator/src/ClassMap.php  me  C:V         vendor/composer/LICENSE.  me.            vendor/composer/ClassLoader.php?  me?  2@u      +   vendor/composer/composer/phpstan/rules.neon  me  ~d      1   vendor/composer/composer/res/composer-schema.jsonV  meV  F      <   vendor/composer/composer/res/composer-repository-schema.json  me  |0      &   vendor/composer/composer/composer.lockK meK 29          vendor/composer/composer/LICENSE,  me,  Vg      %   vendor/composer/composer/bin/composer  me        $   vendor/composer/composer/bin/compile  me  \0      &   vendor/composer/composer/composer.jsonI
  meI
        S   vendor/composer/composer/src/Composer/PHPStan/RuleReasonDataReturnTypeExtension.php
  me
  
      K   vendor/composer/composer/src/Composer/PHPStan/ConfigReturnTypeExtension.php"  me"  X      1   vendor/composer/composer/src/Composer/Factory.php]~  me]~  Ov'      H   vendor/composer/composer/src/Composer/Repository/RepositoryInterface.php#  me#  }      R   vendor/composer/composer/src/Composer/Repository/InstalledFilesystemRepository.php  me  J=      F   vendor/composer/composer/src/Composer/Repository/PackageRepository.phpl  mel  +Z%      H   vendor/composer/composer/src/Composer/Repository/LockArrayRepository.php  me  Ȥ      G   vendor/composer/composer/src/Composer/Repository/PlatformRepository.php  me        F   vendor/composer/composer/src/Composer/Repository/RepositoryFactory.php    me    )      Q   vendor/composer/composer/src/Composer/Repository/InstalledRepositoryInterface.php  me  +      P   vendor/composer/composer/src/Composer/Repository/WritableRepositoryInterface.php@  me@  ek      D   vendor/composer/composer/src/Composer/Repository/RepositoryUtils.phpH	  meH	  ;ر      P   vendor/composer/composer/src/Composer/Repository/RepositorySecurityException.php  me  l	Ф      H   vendor/composer/composer/src/Composer/Repository/CompositeRepository.php  me  $	)      D   vendor/composer/composer/src/Composer/Repository/ArrayRepository.phpw(  mew(  x)      L   vendor/composer/composer/src/Composer/Repository/WritableArrayRepository.php	  me	  X      B   vendor/composer/composer/src/Composer/Repository/VcsRepository.php"Q  me"Q  BԾ      G   vendor/composer/composer/src/Composer/Repository/ComposerRepository.php me )G(Ф      C   vendor/composer/composer/src/Composer/Repository/PearRepository.php`  me`        B   vendor/composer/composer/src/Composer/Repository/RepositorySet.php@  me@  ![      G   vendor/composer/composer/src/Composer/Repository/ArtifactRepository.php  me  	=x      J   vendor/composer/composer/src/Composer/Repository/RootPackageRepository.php:  me:  V>      F   vendor/composer/composer/src/Composer/Repository/RepositoryManager.php  me  nH      E   vendor/composer/composer/src/Composer/Repository/Vcs/GitHubDriver.phpJV  meJV  !q      B   vendor/composer/composer/src/Composer/Repository/Vcs/VcsDriver.php  me  rO      B   vendor/composer/composer/src/Composer/Repository/Vcs/SvnDriver.php4  me4  매      A   vendor/composer/composer/src/Composer/Repository/Vcs/HgDriver.php  me  ٤      G   vendor/composer/composer/src/Composer/Repository/Vcs/PerforceDriver.php  me  %6ɤ      K   vendor/composer/composer/src/Composer/Repository/Vcs/GitBitbucketDriver.php8  me8  Mn      B   vendor/composer/composer/src/Composer/Repository/Vcs/GitDriver.php"  me"  QǪȤ      E   vendor/composer/composer/src/Composer/Repository/Vcs/GitLabDriver.phpR  meR  #      K   vendor/composer/composer/src/Composer/Repository/Vcs/VcsDriverInterface.php
  me
  O
4ۤ      E   vendor/composer/composer/src/Composer/Repository/Vcs/FossilDriver.php  me  {Yߤ      C   vendor/composer/composer/src/Composer/Repository/PathRepository.php!  me!  O      J   vendor/composer/composer/src/Composer/Repository/VersionCacheInterface.phpd  med  ~      K   vendor/composer/composer/src/Composer/Repository/CanonicalPackagesTrait.php  me  =      E   vendor/composer/composer/src/Composer/Repository/FilterRepository.php  me  X      H   vendor/composer/composer/src/Composer/Repository/InstalledRepository.php3  me3  !      N   vendor/composer/composer/src/Composer/Repository/AdvisoryProviderInterface.php  me  XD@      I   vendor/composer/composer/src/Composer/Repository/FilesystemRepository.php>  me>  /l      M   vendor/composer/composer/src/Composer/Repository/InstalledArrayRepository.php  me  f~      T   vendor/composer/composer/src/Composer/Repository/ConfigurableRepositoryInterface.php  me  F*'      O   vendor/composer/composer/src/Composer/Repository/InvalidRepositoryException.php  me  f=      <   vendor/composer/composer/src/Composer/Util/PackageSorter.phpN  meN  8
      >   vendor/composer/composer/src/Composer/Util/ConfigValidator.php[$  me[$   zf      2   vendor/composer/composer/src/Composer/Util/Git.phpZ  meZ  KOܤ      2   vendor/composer/composer/src/Composer/Util/Svn.php%  me%  Bͤ      =   vendor/composer/composer/src/Composer/Util/NoProxyPattern.php)  me)  x      =   vendor/composer/composer/src/Composer/Util/ComposerMirror.phpG	  meG	  |u      :   vendor/composer/composer/src/Composer/Util/PackageInfo.phpA  meA  #R      9   vendor/composer/composer/src/Composer/Util/AuthHelper.php8  me8        2   vendor/composer/composer/src/Composer/Util/Zip.phpR
  meR
  Aä      7   vendor/composer/composer/src/Composer/Util/Silencer.php;  me;  <I      9   vendor/composer/composer/src/Composer/Util/Filesystem.phpr  mer  Md      2   vendor/composer/composer/src/Composer/Util/Tar.php  me        5   vendor/composer/composer/src/Composer/Util/GitHub.php!  me!        5   vendor/composer/composer/src/Composer/Util/GitLab.php/  me/  0      8   vendor/composer/composer/src/Composer/Util/Bitbucket.php1&  me1&  A.(      =   vendor/composer/composer/src/Composer/Util/HttpDownloader.php)H  me)H  s%G      8   vendor/composer/composer/src/Composer/Util/IniHelper.phpm  mem  7r      7   vendor/composer/composer/src/Composer/Util/Platform.phpB"  meB"        C   vendor/composer/composer/src/Composer/Util/StreamContextFactory.php"  me"  ,@I      8   vendor/composer/composer/src/Composer/Util/TlsHelper.phpr  mer  y      2   vendor/composer/composer/src/Composer/Util/Url.php  me  ?%      7   vendor/composer/composer/src/Composer/Util/Perforce.phpJ  meJ  ˆ      @   vendor/composer/composer/src/Composer/Util/Http/ProxyManager.php^  me^  2<?      ?   vendor/composer/composer/src/Composer/Util/Http/ProxyHelper.php  me  (z+      <   vendor/composer/composer/src/Composer/Util/Http/Response.php  me  >      @   vendor/composer/composer/src/Composer/Util/Http/RequestProxy.php  me  Hh9      B   vendor/composer/composer/src/Composer/Util/Http/CurlDownloader.phpt  met  !      @   vendor/composer/composer/src/Composer/Util/Http/CurlResponse.php  me  1'ɤ      ?   vendor/composer/composer/src/Composer/Util/MetadataMinifier.php  me  #`      >   vendor/composer/composer/src/Composer/Util/ProcessExecutor.php/8  me/8  @_      1   vendor/composer/composer/src/Composer/Util/Hg.php  me  ˤ      ?   vendor/composer/composer/src/Composer/Util/RemoteFilesystem.phpk  mek        ;   vendor/composer/composer/src/Composer/Util/ErrorHandler.php	  me	  cFޤ      9   vendor/composer/composer/src/Composer/Util/SyncHelper.php
  me
  ެpQ      3   vendor/composer/composer/src/Composer/Util/Loop.php2  me2        A   vendor/composer/composer/src/Composer/Config/JsonConfigSource.php()  me()        F   vendor/composer/composer/src/Composer/Config/ConfigSourceInterface.phpf  mef  (פ      =   vendor/composer/composer/src/Composer/SelfUpdate/Versions.php  me  .]!      9   vendor/composer/composer/src/Composer/SelfUpdate/Keys.php  me  -*      /   vendor/composer/composer/src/Composer/Cache.php+  me+  2v      ?   vendor/composer/composer/src/Composer/EventDispatcher/Event.php  me  ~ k      R   vendor/composer/composer/src/Composer/EventDispatcher/ScriptExecutionException.php  me  ;;      I   vendor/composer/composer/src/Composer/EventDispatcher/EventDispatcher.phpu  meu  Uc      R   vendor/composer/composer/src/Composer/EventDispatcher/EventSubscriberInterface.phpu  meu  h_}      9   vendor/composer/composer/src/Composer/PartialComposer.phpF	  meF	  =      :   vendor/composer/composer/src/Composer/Platform/Runtime.php  me  H.      ?   vendor/composer/composer/src/Composer/Platform/HhvmDetector.php  me  8       :   vendor/composer/composer/src/Composer/Platform/Version.php
  me
  Ԥ      5   vendor/composer/composer/src/Composer/IO/BufferIO.php  me  /a      6   vendor/composer/composer/src/Composer/IO/ConsoleIO.phpK)  meK)  51      3   vendor/composer/composer/src/Composer/IO/BaseIO.php  me  f$)      3   vendor/composer/composer/src/Composer/IO/NullIO.php	  me	  {      8   vendor/composer/composer/src/Composer/IO/IOInterface.phpZ   meZ   
      =   vendor/composer/composer/src/Composer/Plugin/PluginEvents.phpe  mee  1+ˤ      C   vendor/composer/composer/src/Composer/Plugin/PreCommandRunEvent.php2  me2  :q@      K   vendor/composer/composer/src/Composer/Plugin/Capability/CommandProvider.php  me  d,      F   vendor/composer/composer/src/Composer/Plugin/Capability/Capability.php  me  Lk      G   vendor/composer/composer/src/Composer/Plugin/PluginBlockedException.php  me  Nu      =   vendor/composer/composer/src/Composer/Plugin/CommandEvent.phpy  mey  /      @   vendor/composer/composer/src/Composer/Plugin/PluginInterface.php?  me?  #?"      >   vendor/composer/composer/src/Composer/Plugin/PluginManager.phpx  mex  ̼      E   vendor/composer/composer/src/Composer/Plugin/PreFileDownloadEvent.php9  me9        F   vendor/composer/composer/src/Composer/Plugin/PostFileDownloadEvent.php}
  me}
         8   vendor/composer/composer/src/Composer/Plugin/Capable.php  me  u      C   vendor/composer/composer/src/Composer/Plugin/PrePoolCreateEvent.php  me  H      B   vendor/composer/composer/src/Composer/Downloader/RarDownloader.php
  me
        R   vendor/composer/composer/src/Composer/Downloader/VcsCapableDownloaderInterface.phpC  meC  H      B   vendor/composer/composer/src/Composer/Downloader/VcsDownloader.php3  me3  j      H   vendor/composer/composer/src/Composer/Downloader/FilesystemException.php  me  J      D   vendor/composer/composer/src/Composer/Downloader/DownloadManager.phpR<  meR<  H      B   vendor/composer/composer/src/Composer/Downloader/TarDownloader.php  me  K7J      E   vendor/composer/composer/src/Composer/Downloader/FossilDownloader.php  me  i[      Q   vendor/composer/composer/src/Composer/Downloader/MaxFileSizeExceededException.php  me  `ܤ      H   vendor/composer/composer/src/Composer/Downloader/DownloaderInterface.php  me  x      A   vendor/composer/composer/src/Composer/Downloader/XzDownloader.phpu  meu  b      A   vendor/composer/composer/src/Composer/Downloader/HgDownloader.php  me  |      B   vendor/composer/composer/src/Composer/Downloader/SvnDownloader.php"  me"  -e      C   vendor/composer/composer/src/Composer/Downloader/FileDownloader.phptN  metN  VadN      J   vendor/composer/composer/src/Composer/Downloader/ChangeReportInterface.php'  me'  }s$      G   vendor/composer/composer/src/Composer/Downloader/TransportException.php  me  ;*s      F   vendor/composer/composer/src/Composer/Downloader/ArchiveDownloader.php!  me!  
      L   vendor/composer/composer/src/Composer/Downloader/DvcsDownloaderInterface.php6  me6  1N}      C   vendor/composer/composer/src/Composer/Downloader/PharDownloader.php  me  /&֤      C   vendor/composer/composer/src/Composer/Downloader/PathDownloader.php2  me2  ȞO      G   vendor/composer/composer/src/Composer/Downloader/PerforceDownloader.php
  me
  R.      B   vendor/composer/composer/src/Composer/Downloader/GitDownloader.php9b  me9b        B   vendor/composer/composer/src/Composer/Downloader/ZipDownloader.php4  me4  #Ϥ      C   vendor/composer/composer/src/Composer/Downloader/GzipDownloader.php  me  ~o      0   vendor/composer/composer/src/Composer/Config.php_  me_  0M      6   vendor/composer/composer/src/Composer/Script/Event.php  me  D]      =   vendor/composer/composer/src/Composer/Script/ScriptEvents.php  me  KGꮤ      M   vendor/composer/composer/src/Composer/Question/StrictConfirmationQuestion.php  me  z2      2   vendor/composer/composer/src/Composer/Composer.php  me  w=T      F   vendor/composer/composer/src/Composer/Json/JsonValidationException.phpl  mel  exˤ      <   vendor/composer/composer/src/Composer/Json/JsonFormatter.php  me  곤      7   vendor/composer/composer/src/Composer/Json/JsonFile.php2  me2  <^=      >   vendor/composer/composer/src/Composer/Json/JsonManipulator.phpP  meP         ;   vendor/composer/composer/src/Composer/InstalledVersions.php?  me?  Fb      W   vendor/composer/composer/src/Composer/DependencyResolver/Operation/InstallOperation.phpz  mez  =~i      b   vendor/composer/composer/src/Composer/DependencyResolver/Operation/MarkAliasInstalledOperation.phpx  mex  nҤ      Y   vendor/composer/composer/src/Composer/DependencyResolver/Operation/OperationInterface.php  me  }|(̤      V   vendor/composer/composer/src/Composer/DependencyResolver/Operation/UpdateOperation.phpw  mew  c;      V   vendor/composer/composer/src/Composer/DependencyResolver/Operation/SolverOperation.php  me  Iw      Y   vendor/composer/composer/src/Composer/DependencyResolver/Operation/UninstallOperation.phpb  meb  &Yl      d   vendor/composer/composer/src/Composer/DependencyResolver/Operation/MarkAliasUninstalledOperation.php~  me~        H   vendor/composer/composer/src/Composer/DependencyResolver/Transaction.php7  me7  aT      L   vendor/composer/composer/src/Composer/DependencyResolver/PolicyInterface.phpx  mex  -]      Q   vendor/composer/composer/src/Composer/DependencyResolver/LocalRepoTransaction.php(  me(  tʺ      K   vendor/composer/composer/src/Composer/DependencyResolver/RuleWatchGraph.phpA  meA  >      H   vendor/composer/composer/src/Composer/DependencyResolver/GenericRule.php  me  6|      L   vendor/composer/composer/src/Composer/DependencyResolver/LockTransaction.php  me  Siߤ      C   vendor/composer/composer/src/Composer/DependencyResolver/Solver.phpg  meg  ӂu      A   vendor/composer/composer/src/Composer/DependencyResolver/Rule.phpN  meN  UG      J   vendor/composer/composer/src/Composer/DependencyResolver/Rule2Literals.php
  me
  7|K      T   vendor/composer/composer/src/Composer/DependencyResolver/SolverProblemsException.php^  me^  |!8      O   vendor/composer/composer/src/Composer/DependencyResolver/SolverBugException.php  me  /d      J   vendor/composer/composer/src/Composer/DependencyResolver/DefaultPolicy.php'  me'  X      J   vendor/composer/composer/src/Composer/DependencyResolver/RuleWatchNode.php  me  '      D   vendor/composer/composer/src/Composer/DependencyResolver/RuleSet.php=  me=  _4      A   vendor/composer/composer/src/Composer/DependencyResolver/Pool.php   me   ?6lJ      N   vendor/composer/composer/src/Composer/DependencyResolver/MultiConflictRule.php
  me
  _      D   vendor/composer/composer/src/Composer/DependencyResolver/Request.phpa!  mea!  j      J   vendor/composer/composer/src/Composer/DependencyResolver/PoolOptimizer.phpL  meL  5ߤ      M   vendor/composer/composer/src/Composer/DependencyResolver/RuleSetGenerator.php6  me6  NkǤ      F   vendor/composer/composer/src/Composer/DependencyResolver/Decisions.php  me  3N      H   vendor/composer/composer/src/Composer/DependencyResolver/PoolBuilder.phpC  meC  !A      D   vendor/composer/composer/src/Composer/DependencyResolver/Problem.phpr  mer  ϒۤ      L   vendor/composer/composer/src/Composer/DependencyResolver/RuleSetIterator.php@
  me@
  w      K   vendor/composer/composer/src/Composer/DependencyResolver/RuleWatchChain.php  me  ]      D   vendor/composer/composer/src/Composer/Autoload/AutoloadGenerator.php  me  	̤      >   vendor/composer/composer/src/Composer/Autoload/ClassLoader.phpg>  meg>  v      D   vendor/composer/composer/src/Composer/Autoload/ClassMapGenerator.php  me  I%c       A   vendor/composer/composer/src/Composer/Command/SuggestsCommand.php;  me;  :&|      ?   vendor/composer/composer/src/Composer/Command/SearchCommand.php  me  .H      =   vendor/composer/composer/src/Composer/Command/BumpCommand.php+&  me+&  Q\      @   vendor/composer/composer/src/Composer/Command/ArchiveCommand.php!  me!  +ä      >   vendor/composer/composer/src/Composer/Command/AuditCommand.php1
  me1
  T      A   vendor/composer/composer/src/Composer/Command/ValidateCommand.php$  me$  Y      =   vendor/composer/composer/src/Composer/Command/FundCommand.php  me  {      G   vendor/composer/composer/src/Composer/Command/PackageDiscoveryTrait.php
O  me
O  )	w      D   vendor/composer/composer/src/Composer/Command/ScriptAliasCommand.php
  me
  \       F   vendor/composer/composer/src/Composer/Command/CreateProjectCommand.phpH\  meH\  zڤ      =   vendor/composer/composer/src/Composer/Command/BaseCommand.php=  me=  s      A   vendor/composer/composer/src/Composer/Command/OutdatedCommand.php  me  X      E   vendor/composer/composer/src/Composer/Command/DumpAutoloadCommand.phpJ  meJ  C      =   vendor/composer/composer/src/Composer/Command/HomeCommand.phpa  mea  Tq      B   vendor/composer/composer/src/Composer/Command/ReinstallCommand.php  me        ?   vendor/composer/composer/src/Composer/Command/RemoveCommand.php;  me;  1f      =   vendor/composer/composer/src/Composer/Command/ShowCommand.php me K      @   vendor/composer/composer/src/Composer/Command/InstallCommand.php  me  
q      =   vendor/composer/composer/src/Composer/Command/InitCommand.php_X  me_X  b      B   vendor/composer/composer/src/Composer/Command/RunScriptCommand.php  me  rm      ?   vendor/composer/composer/src/Composer/Command/ConfigCommand.php  me  `]      A   vendor/composer/composer/src/Composer/Command/LicensesCommand.php  me  8$䂤      ?   vendor/composer/composer/src/Composer/Command/UpdateCommand.phpq?  meq?  n      ?   vendor/composer/composer/src/Composer/Command/StatusCommand.phpv   mev   y	0      G   vendor/composer/composer/src/Composer/Command/BaseDependencyCommand.phpL-  meL-        @   vendor/composer/composer/src/Composer/Command/DependsCommand.php  me  vN      B   vendor/composer/composer/src/Composer/Command/ProhibitsCommand.php  me   &      J   vendor/composer/composer/src/Composer/Command/CheckPlatformReqsCommand.php  me  Yj      C   vendor/composer/composer/src/Composer/Command/SelfUpdateCommand.phph  meh  HW      @   vendor/composer/composer/src/Composer/Command/RequireCommand.phps  mes  	NL      A   vendor/composer/composer/src/Composer/Command/CompletionTrait.php  me  |ޤ      C   vendor/composer/composer/src/Composer/Command/ClearCacheCommand.php  me  Q      A   vendor/composer/composer/src/Composer/Command/DiagnoseCommand.phpz  mez        ?   vendor/composer/composer/src/Composer/Command/GlobalCommand.php3  me3         >   vendor/composer/composer/src/Composer/Command/AboutCommand.php  me  
      =   vendor/composer/composer/src/Composer/Command/ExecCommand.php>  me>  Ƙi      3   vendor/composer/composer/src/Composer/Installer.php  me  ƕ      m   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/PlatformRequirementFilterInterface.php  me         m   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/IgnoreAllPlatformRequirementFilter.php  me  u      n   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/IgnoreListPlatformRequirementFilter.php  me  f      q   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/IgnoreNothingPlatformRequirementFilter.php  me  u      k   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/PlatformRequirementFilterFactory.php  me  $¤      A   vendor/composer/composer/src/Composer/Installer/PackageEvents.php"  me"  ]m      C   vendor/composer/composer/src/Composer/Installer/BinaryInstaller.php7  me7  `      C   vendor/composer/composer/src/Composer/Installer/PluginInstaller.phpw  mew  0\      K   vendor/composer/composer/src/Composer/Installer/BinaryPresenceInterface.php  me  <P      C   vendor/composer/composer/src/Composer/Installer/InstallerEvents.php  me  "e      @   vendor/composer/composer/src/Composer/Installer/PackageEvent.php  me  T      B   vendor/composer/composer/src/Composer/Installer/InstallerEvent.php  me  r>      D   vendor/composer/composer/src/Composer/Installer/LibraryInstaller.php&,  me&,        F   vendor/composer/composer/src/Composer/Installer/InstallerInterface.php1  me1  K;      H   vendor/composer/composer/src/Composer/Installer/MetapackageInstaller.php  me  ն٤      D   vendor/composer/composer/src/Composer/Installer/ProjectInstaller.php
  me
        M   vendor/composer/composer/src/Composer/Installer/SuggestedPackagesReporter.php  me  vӤ      G   vendor/composer/composer/src/Composer/Installer/InstallationManager.php4_  me4_  &      A   vendor/composer/composer/src/Composer/Installer/NoopInstaller.phpY  meY  ^.      C   vendor/composer/composer/src/Composer/Advisory/SecurityAdvisory.php  me  ݭ      J   vendor/composer/composer/src/Composer/Advisory/PartialSecurityAdvisory.php  me  u      :   vendor/composer/composer/src/Composer/Advisory/Auditor.php8  me8  n      J   vendor/composer/composer/src/Composer/Advisory/IgnoredSecurityAdvisory.phpk  mek  K`      R   vendor/composer/composer/src/Composer/Exception/IrrecoverableDownloadException.php  me        B   vendor/composer/composer/src/Composer/Exception/NoSslException.php  me  ;P      2   vendor/composer/composer/src/Composer/Compiler.php)-  me)-  ?      9   vendor/composer/composer/src/Composer/Package/Package.phpB  meB  %9      6   vendor/composer/composer/src/Composer/Package/Link.php
  me
  +H      J   vendor/composer/composer/src/Composer/Package/CompletePackageInterface.php  me  }{+      I   vendor/composer/composer/src/Composer/Package/Archiver/ArchiveManager.php$  me$  k      P   vendor/composer/composer/src/Composer/Package/Archiver/ArchivableFilesFinder.php  me         G   vendor/composer/composer/src/Composer/Package/Archiver/PharArchiver.php  me  ǁM      L   vendor/composer/composer/src/Composer/Package/Archiver/BaseExcludeFilter.php  me  @ݤ      P   vendor/composer/composer/src/Composer/Package/Archiver/ArchivableFilesFilter.php  me  ߵ      K   vendor/composer/composer/src/Composer/Package/Archiver/GitExcludeFilter.php  me  ^      P   vendor/composer/composer/src/Composer/Package/Archiver/ComposerExcludeFilter.php  me  ޣ      L   vendor/composer/composer/src/Composer/Package/Archiver/ArchiverInterface.php  me  ;w      F   vendor/composer/composer/src/Composer/Package/Archiver/ZipArchiver.php  me        F   vendor/composer/composer/src/Composer/Package/CompleteAliasPackage.php  me  lN(      >   vendor/composer/composer/src/Composer/Package/AliasPackage.php'  me'  /      8   vendor/composer/composer/src/Composer/Package/Locker.phpN  meN  ]+      B   vendor/composer/composer/src/Composer/Package/PackageInterface.php-  me-  ɴk^      G   vendor/composer/composer/src/Composer/Package/Version/VersionBumper.php  me  OC      I   vendor/composer/composer/src/Composer/Package/Version/StabilityFilter.phpQ  meQ  Tw      H   vendor/composer/composer/src/Composer/Package/Version/VersionGuesser.phppB  mepB        I   vendor/composer/composer/src/Composer/Package/Version/VersionSelector.phps/  mes/  Ӥ      G   vendor/composer/composer/src/Composer/Package/Version/VersionParser.php  me  
?      N   vendor/composer/composer/src/Composer/Package/Loader/ValidatingArrayLoader.php`q  me`q  Mn      P   vendor/composer/composer/src/Composer/Package/Loader/InvalidPackageException.phpo  meo  ,Ҥ      D   vendor/composer/composer/src/Composer/Package/Loader/ArrayLoader.phpF  meF  l      H   vendor/composer/composer/src/Composer/Package/Loader/LoaderInterface.phpj  mej  7      J   vendor/composer/composer/src/Composer/Package/Loader/RootPackageLoader.php+  me+  JH$@      C   vendor/composer/composer/src/Composer/Package/Loader/JsonLoader.phpc  mec  ܝ@      =   vendor/composer/composer/src/Composer/Package/BasePackage.php  me  գ      C   vendor/composer/composer/src/Composer/Package/Comparer/Comparer.phpu  meu  L`      B   vendor/composer/composer/src/Composer/Package/RootAliasPackage.php  me  r      A   vendor/composer/composer/src/Composer/Package/CompletePackage.php@  me@  ew      F   vendor/composer/composer/src/Composer/Package/RootPackageInterface.php  me  7      =   vendor/composer/composer/src/Composer/Package/RootPackage.php@  me@  B:      D   vendor/composer/composer/src/Composer/Package/Dumper/ArrayDumper.phpZ  meZ  -]      =   vendor/composer/composer/src/Composer/Console/Application.phps  mes  GΤ      C   vendor/composer/composer/src/Composer/Console/GithubActionError.phpl  mel  g`+      E   vendor/composer/composer/src/Composer/Console/Input/InputArgument.php
  me
  Pu=      C   vendor/composer/composer/src/Composer/Console/Input/InputOption.php  me  j       E   vendor/composer/composer/src/Composer/Console/HtmlOutputFormatter.php1  me1  g?Ѥ      *   vendor/composer/composer/src/bootstrap.php7  me7  t      (   vendor/composer/ca-bundle/res/cacert.pemOu meOu 	      !   vendor/composer/ca-bundle/LICENSE  me  *!^`      #   vendor/composer/ca-bundle/README.md1  me1  >VuĤ      '   vendor/composer/ca-bundle/composer.json  me   ä      *   vendor/composer/ca-bundle/src/CaBundle.phpD  meD  ʪ      !   vendor/composer/autoload_psr4.php}  me}  CV      %   vendor/composer/autoload_classmap.phpF meF y@6p      "   vendor/composer/platform_check.php  me  UԤ      #   vendor/composer/autoload_static.phpȚ meȚ ^z      !   vendor/composer/autoload_real.php  me  Rue      ,   vendor/composer/semver/phpstan-baseline.neon  me  i%m         vendor/composer/semver/LICENSE  me  Bh      #   vendor/composer/semver/CHANGELOG.md%  me%  5          vendor/composer/semver/README.mdH
  meH
   }Τ      $   vendor/composer/semver/composer.json  me  .      /   vendor/composer/semver/src/CompilingMatcher.php
  me
  x      '   vendor/composer/semver/src/Interval.phpu  meu         )   vendor/composer/semver/src/Comparator.php<
  me<
  <L      (   vendor/composer/semver/src/Intervals.phpLP  meLP  K.      %   vendor/composer/semver/src/Semver.phpr
  mer
  Τ      ,   vendor/composer/semver/src/VersionParser.php!T  me!T  U      =   vendor/composer/semver/src/Constraint/ConstraintInterface.php  me  겤      9   vendor/composer/semver/src/Constraint/MultiConstraint.php#  me#  o      4   vendor/composer/semver/src/Constraint/Constraint.php2  me2  *      <   vendor/composer/semver/src/Constraint/MatchAllConstraint.php,  me,  [j<      =   vendor/composer/semver/src/Constraint/MatchNoneConstraint.php(  me(  h      /   vendor/composer/semver/src/Constraint/Bound.php
  me
        "   vendor/composer/autoload_files.php*  me*  +T      %   vendor/composer/InstalledVersions.php?  me?  Fb         vendor/composer/installed.phpK  meK  [<         vendor/composer/pcre/LICENSE  me  hg^         vendor/composer/pcre/README.md>!  me>!        "   vendor/composer/pcre/composer.json1  me1  m"      (   vendor/composer/pcre/src/MatchResult.php  me  ڇҤ      "   vendor/composer/pcre/src/Regex.php  me        6   vendor/composer/pcre/src/MatchAllWithOffsetsResult.php  me        3   vendor/composer/pcre/src/MatchWithOffsetsResult.php  me  o      7   vendor/composer/pcre/src/MatchAllStrictGroupsResult.phpx  mex  FA      9   vendor/composer/pcre/src/UnexpectedNullMatchException.php"  me"  _      4   vendor/composer/pcre/src/MatchStrictGroupsResult.php  me        +   vendor/composer/pcre/src/MatchAllResult.php  me  iIE      *   vendor/composer/pcre/src/ReplaceResult.php  me  /      !   vendor/composer/pcre/src/Preg.phpH  meH  Ԥ      *   vendor/composer/pcre/src/PcreException.php  me  g[/      )   vendor/composer/metadata-minifier/LICENSE  me  hg^      +   vendor/composer/metadata-minifier/README.mdL  meL  Mv<      3   vendor/composer/metadata-minifier/phpstan.neon.distB   meB   #f      /   vendor/composer/metadata-minifier/composer.json  me  D0פ      :   vendor/composer/metadata-minifier/src/MetadataMinifier.php
  me
         6   vendor/composer/spdx-licenses/res/spdx-exceptions.json  me  "m      4   vendor/composer/spdx-licenses/res/spdx-licenses.json  me  
x       %   vendor/composer/spdx-licenses/LICENSE  me  Bh      *   vendor/composer/spdx-licenses/CHANGELOG.mdS  meS  p+      '   vendor/composer/spdx-licenses/README.md<  me<  se      /   vendor/composer/spdx-licenses/phpstan.neon.dist   me   -      +   vendor/composer/spdx-licenses/composer.json  me   '      2   vendor/composer/spdx-licenses/src/SpdxLicenses.php%  me%  ]H
      &   vendor/paragonie/random_compat/LICENSEJ  meJ  >       =   vendor/paragonie/random_compat/dist/random_compat.phar.pubkey   me   *A|      A   vendor/paragonie/random_compat/dist/random_compat.phar.pubkey.asc  me  ١i      3   vendor/paragonie/random_compat/other/build_phar.phpI  meI   c      ,   vendor/paragonie/random_compat/build-phar.sh   me   t8Q      1   vendor/paragonie/random_compat/psalm-autoload.php  me        -   vendor/paragonie/random_compat/lib/random.phpJ  meJ  .N      ,   vendor/paragonie/random_compat/composer.json  me  ŀM      (   vendor/paragonie/random_compat/psalm.xmlT  meT  D         vendor/doctrine/lexer/LICENSE)  me)  `XQ         vendor/doctrine/lexer/README.mdo  meo  6q          vendor/doctrine/lexer/UPGRADE.mdw  mew  oK      #   vendor/doctrine/lexer/composer.json  me  VL¤      #   vendor/doctrine/lexer/src/Token.php  me  @D      +   vendor/doctrine/lexer/src/AbstractLexer.php  me  x	      #   vendor/doctrine/annotations/LICENSE)  me)  ``      %   vendor/doctrine/annotations/README.md  me  5פ      I   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/PhpParser.php	  me	  b7      S   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/AnnotationException.php  me        O   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/FileCacheReader.php!   me!   W[      c   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/Annotation/NamedArgumentConstructor.php  me  \      [   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/Annotation/IgnoreAnnotation.php  me  ז&ߤ      U   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/Annotation/Attributes.php6  me6  :פ      O   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/Annotation/Enum.phpE  meE  Z'      T   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/Annotation/Attribute.phpu  meu  Bʤ      Q   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/Annotation/Target.php
	  me
	  5      S   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/Annotation/Required.php   me   hf      M   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/IndexedReader.php 	  me 	  7Ku      F   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/Reader.php	  me	  F      J   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/Annotation.php
  me
  |Τ      V   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/SimpleAnnotationReader.phpa
  mea
        O   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/PsrCachedReader.php  me  g      I   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/DocParser.php  me  C      L   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/CachedReader.php  me  DP5)      K   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/TokenParser.php  me  p#      `   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/ImplicitlyIgnoredAnnotationNames.php  me  M      P   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/AnnotationReader.php,  me,  (m      R   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/AnnotationRegistry.php
  me
  'L{x      H   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/DocLexer.php
  me
  U)      b   vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/NamedArgumentConstructorAnnotation.phpi  mei  !      )   vendor/doctrine/annotations/composer.json  me  Ф      %   vendor/doctrine/annotations/psalm.xml  me   C,      $   vendor/doctrine/deprecations/LICENSE)  me)  "0      &   vendor/doctrine/deprecations/README.md$  me$  qU      U   vendor/doctrine/deprecations/lib/Doctrine/Deprecations/PHPUnit/VerifyDeprecations.php  me  K      F   vendor/doctrine/deprecations/lib/Doctrine/Deprecations/Deprecation.php\$  me\$  L_      *   vendor/doctrine/deprecations/composer.json  me  ;R      %   vendor/firebase/php-jwt/composer.lock/  me/  ݝ         vendor/firebase/php-jwt/LICENSE  me  -nK      #   vendor/firebase/php-jwt/package.xml[  me[  2t      !   vendor/firebase/php-jwt/README.md  me  H      %   vendor/firebase/php-jwt/composer.json  me  @      9   vendor/firebase/php-jwt/src/SignatureInvalidException.phpu   meu   Ͻ      4   vendor/firebase/php-jwt/src/BeforeValidException.phpp   mep   +Ȥ      0   vendor/firebase/php-jwt/src/ExpiredException.phpl   mel   Sֶ
      #   vendor/firebase/php-jwt/src/JWT.php5  me5        (   vendor/justinrainbow/json-schema/LICENSE   me         2   vendor/justinrainbow/json-schema/bin/validate-json  me        F   vendor/justinrainbow/json-schema/dist/schema/json-schema-draft-03.json  me  -aߤ      F   vendor/justinrainbow/json-schema/dist/schema/json-schema-draft-04.json  me  Nߤ      *   vendor/justinrainbow/json-schema/README.mdz  mez  ˱      .   vendor/justinrainbow/json-schema/composer.json  me  Kj_      ;   vendor/justinrainbow/json-schema/src/JsonSchema/Rfc3339.php  me  ̤      =   vendor/justinrainbow/json-schema/src/JsonSchema/Validator.php
  me
         I   vendor/justinrainbow/json-schema/src/JsonSchema/UriRetrieverInterface.php  me  hJ      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/ObjectConstraint.php}  me}  ҍN      G   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/Factory.php  me  "9{      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/NumberConstraint.php
  me
  iä      N   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeConstraint.php  me  D      N   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/BaseConstraint.php$  me$  A{      N   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/EnumConstraint.php  me  Yhb      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/StringConstraint.php  me  	s.      S   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/ConstraintInterface.php7  me7  J,=      T   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/CollectionConstraint.php  me  q|      J   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/Constraint.php  me  yꎼ      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/FormatConstraint.php-#  me-#  yF¤      \   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeCheck/TypeCheckInterface.php  me  y      Y   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeCheck/StrictTypeCheck.php:  me:  *9      X   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeCheck/LooseTypeCheck.php  me  r(      S   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/UndefinedConstraint.php<  me<  (      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/SchemaConstraint.php   me   2e      F   vendor/justinrainbow/json-schema/src/JsonSchema/Entity/JsonPointer.php4
  me4
        H   vendor/justinrainbow/json-schema/src/JsonSchema/UriResolverInterface.php   me   "      K   vendor/justinrainbow/json-schema/src/JsonSchema/Iterator/ObjectIterator.php
  me
  hl      A   vendor/justinrainbow/json-schema/src/JsonSchema/SchemaStorage.php  me  uu      X   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/UriRetrieverInterface.php  me  -,      T   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/AbstractRetriever.php  me  _Ǥ      G   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/Curl.php  me  x(      R   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/FileGetContents.php^
  me^
        R   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/PredefinedArray.php
  me
  /8      D   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/UriRetriever.php$  me$  Aq      C   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/UriResolver.php  me  _9<      W   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/ResourceNotFoundException.phpb  meb  `      P   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/ExceptionInterface.phpX   meX   [      N   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/RuntimeException.phpo  meo  Cr      W   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidSourceUriException.phpj  mej  *5      V   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidArgumentException.php  me  N      ^   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/UnresolvableJsonPointerException.php  me  ZHe      Q   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/ValidationException.php'  me'  Aj      T   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidConfigException.php_  me_  P      S   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/JsonDecodingException.php  me  ϭ      T   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidSchemaException.php\  me\  @S6      R   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/UriResolverException.phpX  meX  Ӕ      ]   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidSchemaMediaTypeException.phpe  mee  U3$      J   vendor/justinrainbow/json-schema/src/JsonSchema/SchemaStorageInterface.php.  me.  VԠg      1   vendor/crell/api-problem/docker/php/81/Dockerfile  me  L>      1   vendor/crell/api-problem/docker/php/81/xdebug.inil   mel   b0      >   vendor/crell/api-problem/docker/php/conf.d/error_reporting.ini   me   lc¤      !   vendor/crell/api-problem/Makefile]  me]  Zib      *   vendor/crell/api-problem/phpstan.neon.dist0   me0   b      +   vendor/crell/api-problem/docker-compose.ymlb  meb  Ruv      &   vendor/crell/api-problem/composer.json  me  @      %   vendor/crell/api-problem/default-.env  me  ]h	Q      4   vendor/crell/api-problem/src/JsonEncodeException.php   me   ewF      .   vendor/crell/api-problem/src/HttpConverter.phpe
  mee
  ΊE      3   vendor/crell/api-problem/src/JsonParseException.phpH  meH  %P(      .   vendor/crell/api-problem/src/JsonException.php  me  5-      +   vendor/crell/api-problem/src/ApiProblem.phpH  meH  |o         vendor/psr/cache/CHANGELOG.md  me  -	G         vendor/psr/cache/README.md  me  m         vendor/psr/cache/LICENSE.txt8  me8  Df         vendor/psr/cache/composer.json3  me3  ̥P      /   vendor/psr/cache/src/CacheItemPoolInterface.php+  me+  S%Ĥ      +   vendor/psr/cache/src/CacheItemInterface.php  me  J      1   vendor/psr/cache/src/InvalidArgumentException.php:  me:  MY      '   vendor/psr/cache/src/CacheException.php   me   w"'      #   vendor/psr/event-dispatcher/LICENSE(  me(  }]      %   vendor/psr/event-dispatcher/README.mdE  meE  S      )   vendor/psr/event-dispatcher/composer.jsonb  meb  q      =   vendor/psr/event-dispatcher/src/ListenerProviderInterface.php  me  bh      <   vendor/psr/event-dispatcher/src/EventDispatcherInterface.php  me        ;   vendor/psr/event-dispatcher/src/StoppableEventInterface.php!  me!  T>q         vendor/psr/container/LICENSEy  mey  Op         vendor/psr/container/README.mdB  meB  g?      "   vendor/psr/container/composer.jsonu  meu  g      7   vendor/psr/container/src/NotFoundExceptionInterface.php   me   B@      /   vendor/psr/container/src/ContainerInterface.php  me  M      8   vendor/psr/container/src/ContainerExceptionInterface.php   me   &         vendor/psr/log/LICENSE=  me=  pO         vendor/psr/log/README.mdB  meB  '      /   vendor/psr/log/Psr/Log/LoggerAwareInterface.php8  me8  "#      #   vendor/psr/log/Psr/Log/LogLevel.phpH  meH  u      3   vendor/psr/log/Psr/Log/Test/LoggerInterfaceTest.php_  me_  
 .      *   vendor/psr/log/Psr/Log/Test/TestLogger.php  me  0      )   vendor/psr/log/Psr/Log/Test/DummyTest.php
  me
  4B      +   vendor/psr/log/Psr/Log/LoggerAwareTrait.php  me        3   vendor/psr/log/Psr/Log/InvalidArgumentException.phpo   meo   MWd      %   vendor/psr/log/Psr/Log/NullLogger.php  me  ;      *   vendor/psr/log/Psr/Log/LoggerInterface.php1  me1  M      &   vendor/psr/log/Psr/Log/LoggerTrait.php^
  me^
  кڤ      )   vendor/psr/log/Psr/Log/AbstractLogger.php(  me(  D         vendor/psr/log/composer.jsoni  mei           vendor/monolog/monolog/LICENSE'  me'        #   vendor/monolog/monolog/CHANGELOG.mdԖ  meԖ  Z          vendor/monolog/monolog/README.mdH  meH  \      !   vendor/monolog/monolog/UPGRADE.md_  me_  ƻ,      $   vendor/monolog/monolog/composer.json2
  me2
  gS      >   vendor/monolog/monolog/src/Monolog/Handler/SendGridHandler.phpY  meY  o      @   vendor/monolog/monolog/src/Monolog/Handler/InsightOpsHandler.php  me  7i      :   vendor/monolog/monolog/src/Monolog/Handler/TestHandler.php  me  a      ;   vendor/monolog/monolog/src/Monolog/Handler/IFTTTHandler.phpw  mew  C      H   vendor/monolog/monolog/src/Monolog/Handler/WebRequestRecognizerTrait.php  me  zP      <   vendor/monolog/monolog/src/Monolog/Handler/SocketHandler.php/  me/  \6      C   vendor/monolog/monolog/src/Monolog/Handler/SymfonyMailerHandler.phpA  meA  [oˤ      :   vendor/monolog/monolog/src/Monolog/Handler/NoopHandler.php  me  >u'      <   vendor/monolog/monolog/src/Monolog/Handler/BufferHandler.php`  me`  l      <   vendor/monolog/monolog/src/Monolog/Handler/SyslogHandler.php  me  \=/      =   vendor/monolog/monolog/src/Monolog/Handler/RollbarHandler.php  me  
ä      D   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossedHandler.php!  me!  CV      >   vendor/monolog/monolog/src/Monolog/Handler/OverflowHandler.phpy  mey  KY      =   vendor/monolog/monolog/src/Monolog/Handler/HandlerWrapper.phpB
  meB
  T+"      Y   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ActivationStrategyInterface.php  me  fj      Z   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ErrorLevelActivationStrategy.phpy  mey  1      \   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ChannelLevelActivationStrategy.php	  me	  G/      ;   vendor/monolog/monolog/src/Monolog/Handler/GroupHandler.php  me        C   vendor/monolog/monolog/src/Monolog/Handler/ElasticsearchHandler.php  me  4|      >   vendor/monolog/monolog/src/Monolog/Handler/SamplingHandler.php  me  /      6   vendor/monolog/monolog/src/Monolog/Handler/Handler.php  me  5(      >   vendor/monolog/monolog/src/Monolog/Handler/AbstractHandler.php
  me
  .Ƥ      A   vendor/monolog/monolog/src/Monolog/Handler/SwiftMailerHandler.php  me  擝      >   vendor/monolog/monolog/src/Monolog/Handler/FlowdockHandler.php
  me
  ec9      >   vendor/monolog/monolog/src/Monolog/Handler/PushoverHandler.php  me  <N\      J   vendor/monolog/monolog/src/Monolog/Handler/ProcessableHandlerInterface.php  me  &ک      H   vendor/monolog/monolog/src/Monolog/Handler/MissingExtensionException.php  me   
l      D   vendor/monolog/monolog/src/Monolog/Handler/AbstractSyslogHandler.php
  me
  Ax      ?   vendor/monolog/monolog/src/Monolog/Handler/SyslogUdpHandler.phpP  meP  n*      D   vendor/monolog/monolog/src/Monolog/Handler/BrowserConsoleHandler.php$  me$  %b3      <   vendor/monolog/monolog/src/Monolog/Handler/FilterHandler.php"  me"  {ƻ      9   vendor/monolog/monolog/src/Monolog/Handler/SqsHandler.php  me  -kA      B   vendor/monolog/monolog/src/Monolog/Handler/RotatingFileHandler.php+  me+  }|      C   vendor/monolog/monolog/src/Monolog/Handler/FallbackGroupHandler.php  me  JY      B   vendor/monolog/monolog/src/Monolog/Handler/NativeMailerHandler.php  me  6      =   vendor/monolog/monolog/src/Monolog/Handler/MongoDBHandler.php?
  me?
  5(ۤ      =   vendor/monolog/monolog/src/Monolog/Handler/ProcessHandler.phpC  meC  Vʤ      F   vendor/monolog/monolog/src/Monolog/Handler/FormattableHandlerTrait.php+  me+  >G/      :   vendor/monolog/monolog/src/Monolog/Handler/GelfHandler.php  me        A   vendor/monolog/monolog/src/Monolog/Handler/ZendMonitorHandler.php+  me+  IPR      @   vendor/monolog/monolog/src/Monolog/Handler/PHPConsoleHandler.php)  me)  %      >   vendor/monolog/monolog/src/Monolog/Handler/ErrorLogHandler.phpK
  meK
  ?&      @   vendor/monolog/monolog/src/Monolog/Handler/LogEntriesHandler.php  me  [eD      >   vendor/monolog/monolog/src/Monolog/Handler/LogmaticHandler.php
  me
  0!Ƥ      C   vendor/monolog/monolog/src/Monolog/Handler/DeduplicationHandler.php  me  .X      =   vendor/monolog/monolog/src/Monolog/Handler/FirePHPHandler.php  me  	K      8   vendor/monolog/monolog/src/Monolog/Handler/Curl/Util.phpA  meA  z      E   vendor/monolog/monolog/src/Monolog/Handler/DoctrineCouchDBHandler.php  me  ;uĤ      >   vendor/monolog/monolog/src/Monolog/Handler/DynamoDbHandler.php	  me	  u      J   vendor/monolog/monolog/src/Monolog/Handler/FormattableHandlerInterface.phpk  mek  0Ѥ      A   vendor/monolog/monolog/src/Monolog/Handler/RedisPubSubHandler.phpa  mea  C^a      :   vendor/monolog/monolog/src/Monolog/Handler/MailHandler.phpO	  meO	  j      <   vendor/monolog/monolog/src/Monolog/Handler/StreamHandler.php  me  %d      <   vendor/monolog/monolog/src/Monolog/Handler/LogglyHandler.php?  me?  G<      B   vendor/monolog/monolog/src/Monolog/Handler/SlackWebhookHandler.php  me  Rj      >   vendor/monolog/monolog/src/Monolog/Handler/ElasticaHandler.php
  me
  r<      F   vendor/monolog/monolog/src/Monolog/Handler/WhatFailureGroupHandler.php  me  NBJ      ?   vendor/monolog/monolog/src/Monolog/Handler/ChromePHPHandler.php9  me9  ;      @   vendor/monolog/monolog/src/Monolog/Handler/Slack/SlackRecord.php'  me'  z]      9   vendor/monolog/monolog/src/Monolog/Handler/PsrHandler.php	  me	  K삤      >   vendor/monolog/monolog/src/Monolog/Handler/NewRelicHandler.phpa  mea  !      F   vendor/monolog/monolog/src/Monolog/Handler/ProcessableHandlerTrait.php  me        ?   vendor/monolog/monolog/src/Monolog/Handler/HandlerInterface.php  me  ԍ&      ;   vendor/monolog/monolog/src/Monolog/Handler/SlackHandler.phpk  mek  $D      ?   vendor/monolog/monolog/src/Monolog/Handler/FleepHookHandler.php
  me
  9%       :   vendor/monolog/monolog/src/Monolog/Handler/NullHandler.phpd  med  P6      :   vendor/monolog/monolog/src/Monolog/Handler/AmqpHandler.php)  me)   <      A   vendor/monolog/monolog/src/Monolog/Handler/TelegramBotHandler.php  me  <      >   vendor/monolog/monolog/src/Monolog/Handler/MandrillHandler.php	  me	  k      H   vendor/monolog/monolog/src/Monolog/Handler/AbstractProcessingHandler.php  me  <      =   vendor/monolog/monolog/src/Monolog/Handler/CouchDBHandler.php  me  `7      ;   vendor/monolog/monolog/src/Monolog/Handler/RedisHandler.php  me  )      :   vendor/monolog/monolog/src/Monolog/Handler/CubeHandler.php  me  ݢŤ      B   vendor/monolog/monolog/src/Monolog/Handler/SyslogUdp/UdpSocket.php  me  %      -   vendor/monolog/monolog/src/Monolog/Logger.phpAX  meAX  3Ѥ      C   vendor/monolog/monolog/src/Monolog/Attribute/AsMonologProcessor.php  me  _ʏ      8   vendor/monolog/monolog/src/Monolog/DateTimeImmutable.phpJ  meJ  s      4   vendor/monolog/monolog/src/Monolog/Test/TestCase.php  me  b#E>      /   vendor/monolog/monolog/src/Monolog/Registry.php  me  gä      B   vendor/monolog/monolog/src/Monolog/Processor/HostnameProcessor.php  me  3Y      G   vendor/monolog/monolog/src/Monolog/Processor/PsrLogMessageProcessor.php  me  cä      =   vendor/monolog/monolog/src/Monolog/Processor/WebProcessor.php
  me
  	      I   vendor/monolog/monolog/src/Monolog/Processor/MemoryPeakUsageProcessor.phpR  meR  @      C   vendor/monolog/monolog/src/Monolog/Processor/ProcessIdProcessor.phpo  meo  Ф      C   vendor/monolog/monolog/src/Monolog/Processor/MercurialProcessor.phpb  meb  9Ť      =   vendor/monolog/monolog/src/Monolog/Processor/TagProcessor.phpn  men  커      =   vendor/monolog/monolog/src/Monolog/Processor/GitProcessor.php  me  
2      @   vendor/monolog/monolog/src/Monolog/Processor/MemoryProcessor.php5  me5  y[*      G   vendor/monolog/monolog/src/Monolog/Processor/IntrospectionProcessor.php  me  ֱ      =   vendor/monolog/monolog/src/Monolog/Processor/UidProcessor.php7  me7  `      C   vendor/monolog/monolog/src/Monolog/Processor/ProcessorInterface.php  me  L      E   vendor/monolog/monolog/src/Monolog/Processor/MemoryUsageProcessor.php?  me?  9٤      :   vendor/monolog/monolog/src/Monolog/ResettableInterface.php  me  I{      4   vendor/monolog/monolog/src/Monolog/SignalHandler.php  me  r.      B   vendor/monolog/monolog/src/Monolog/Formatter/LogmaticFormatter.php  me  ʓh#      B   vendor/monolog/monolog/src/Monolog/Formatter/ElasticaFormatter.php1  me1  قȤ      >   vendor/monolog/monolog/src/Monolog/Formatter/LineFormatter.phpL  meL  ~:      >   vendor/monolog/monolog/src/Monolog/Formatter/JsonFormatter.php  me  Fɤ      B   vendor/monolog/monolog/src/Monolog/Formatter/FlowdockFormatter.php	  me	  Ϭ}      C   vendor/monolog/monolog/src/Monolog/Formatter/FormatterInterface.php  me  =c      B   vendor/monolog/monolog/src/Monolog/Formatter/LogstashFormatter.php&
  me&
  P      @   vendor/monolog/monolog/src/Monolog/Formatter/LogglyFormatter.php'  me'  lN      G   vendor/monolog/monolog/src/Monolog/Formatter/ElasticsearchFormatter.phpM  meM  Jl      @   vendor/monolog/monolog/src/Monolog/Formatter/ScalarFormatter.php  me  m"o      A   vendor/monolog/monolog/src/Monolog/Formatter/MongoDBFormatter.php   me   y      C   vendor/monolog/monolog/src/Monolog/Formatter/ChromePHPFormatter.php  me  `2Q      A   vendor/monolog/monolog/src/Monolog/Formatter/FluentdFormatter.php  me  5X      E   vendor/monolog/monolog/src/Monolog/Formatter/GelfMessageFormatter.php  me  N      B   vendor/monolog/monolog/src/Monolog/Formatter/WildfireFormatter.php}  me}  ֻˤ      L   vendor/monolog/monolog/src/Monolog/Formatter/GoogleCloudLoggingFormatter.php  me        D   vendor/monolog/monolog/src/Monolog/Formatter/NormalizerFormatter.php$   me$   vä      >   vendor/monolog/monolog/src/Monolog/Formatter/HtmlFormatter.php  me  ٨פ      0   vendor/monolog/monolog/src/Monolog/LogRecord.php  me  b	9      3   vendor/monolog/monolog/src/Monolog/ErrorHandler.php9)  me9)  @L      ,   vendor/monolog/monolog/src/Monolog/Utils.php %  me %  Fk      !   vendor/studio24/rotate/LICENSE.md>  me>  3ä      "   vendor/studio24/rotate/phpunit.xml   me   gE          vendor/studio24/rotate/README.md  me  ?/      $   vendor/studio24/rotate/composer.json  me  WѤ      .   vendor/studio24/rotate/src/RotateException.php_   me_    ;      %   vendor/studio24/rotate/src/Rotate.php#  me#  j      -   vendor/studio24/rotate/src/FilenameFormat.php  me  =D      -   vendor/studio24/rotate/src/RotateAbstract.php  me  D      6   vendor/studio24/rotate/src/FilenameFormatException.phpg   meg   ܙ      %   vendor/studio24/rotate/src/Delete.php|#  me|#  ؤ      0   vendor/studio24/rotate/src/DirectoryIterator.phpk  mek  mA      G   vendor/symfony/framework-bundle/DataCollector/AbstractDataCollector.php#  me#  N      E   vendor/symfony/framework-bundle/DataCollector/RouterDataCollector.php  me  cv      U   vendor/symfony/framework-bundle/DataCollector/TemplateAwareDataCollectorInterface.phpU  meU  ~suܤ      '   vendor/symfony/framework-bundle/LICENSE,  me,  U      7   vendor/symfony/framework-bundle/Test/KernelTestCase.phpt  met  b0      B   vendor/symfony/framework-bundle/Test/DomCrawlerAssertionsTrait.php  me  X,      >   vendor/symfony/framework-bundle/Test/MailerAssertionsTrait.php  me  Ѕ>I      B   vendor/symfony/framework-bundle/Test/BrowserKitAssertionsTrait.php   me   '6      9   vendor/symfony/framework-bundle/Test/TestBrowserToken.phpq  meq  E      4   vendor/symfony/framework-bundle/Test/WebTestCase.php  me        ?   vendor/symfony/framework-bundle/Test/WebTestAssertionsTrait.php  me  jo      6   vendor/symfony/framework-bundle/Test/TestContainer.php  me  C      ,   vendor/symfony/framework-bundle/CHANGELOG.md1}  me1}  $      :   vendor/symfony/framework-bundle/Translation/Translator.php)  me)  &_      7   vendor/symfony/framework-bundle/Secrets/SodiumVault.php#  me#  B[z      7   vendor/symfony/framework-bundle/Secrets/DotenvVault.phpA  meA  Ȟ      9   vendor/symfony/framework-bundle/Secrets/AbstractVault.php  me  ,s>U      I   vendor/symfony/framework-bundle/Resources/bin/check-unused-known-tags.php  me  1      8   vendor/symfony/framework-bundle/Resources/config/esi.php  me        @   vendor/symfony/framework-bundle/Resources/config/translation.php  me   =դ      ?   vendor/symfony/framework-bundle/Resources/config/serializer.php$  me$  V      ?   vendor/symfony/framework-bundle/Resources/config/form_debug.php  me  "      >   vendor/symfony/framework-bundle/Resources/config/validator.php
  me
  ;      @   vendor/symfony/framework-bundle/Resources/config/annotations.phpw
  mew
  u]      >   vendor/symfony/framework-bundle/Resources/config/profiling.php  me  +$      ;   vendor/symfony/framework-bundle/Resources/config/mailer.php
  me
  "R      F   vendor/symfony/framework-bundle/Resources/config/fragment_listener.phpw  mew  Vg      F   vendor/symfony/framework-bundle/Resources/config/translation_debug.php  me  $      C   vendor/symfony/framework-bundle/Resources/config/notifier_debug.php  me  /T_2      A   vendor/symfony/framework-bundle/Resources/config/rate_limiter.php  me  |s      9   vendor/symfony/framework-bundle/Resources/config/lock.php  me  z      H   vendor/symfony/framework-bundle/Resources/config/identity_translator.php!  me!        @   vendor/symfony/framework-bundle/Resources/config/http_client.php  me  ,      A   vendor/symfony/framework-bundle/Resources/config/mailer_debug.php  me  `܄       =   vendor/symfony/framework-bundle/Resources/config/services.php  me  <Ƥ      :   vendor/symfony/framework-bundle/Resources/config/cache.php~   me~   Kg      <   vendor/symfony/framework-bundle/Resources/config/session.php>  me>  ~*      F   vendor/symfony/framework-bundle/Resources/config/mailer_transports.php7  me7  Щ      J   vendor/symfony/framework-bundle/Resources/config/translation_providers.php1  me1  ܩ      :   vendor/symfony/framework-bundle/Resources/config/debug.php  me  "5V      F   vendor/symfony/framework-bundle/Resources/config/fragment_renderer.php	  me	         =   vendor/symfony/framework-bundle/Resources/config/web_link.phpW  meW  
      <   vendor/symfony/framework-bundle/Resources/config/routing.php  me  D*s      G   vendor/symfony/framework-bundle/Resources/config/schema/symfony-1.0.xsdY  meY  ZKh      =   vendor/symfony/framework-bundle/Resources/config/notifier.phpA  meA  IA      F   vendor/symfony/framework-bundle/Resources/config/http_client_debug.php  me  "5$      <   vendor/symfony/framework-bundle/Resources/config/request.php  me  kP?      9   vendor/symfony/framework-bundle/Resources/config/test.php  me  ȧ      D   vendor/symfony/framework-bundle/Resources/config/validator_debug.php  me  GU      C   vendor/symfony/framework-bundle/Resources/config/error_renderer.php/  me/        >   vendor/symfony/framework-bundle/Resources/config/mime_type.php  me  H̤      >   vendor/symfony/framework-bundle/Resources/config/messenger.php  me  PX      <   vendor/symfony/framework-bundle/Resources/config/console.phpN,  meN,  .=ߤ      8   vendor/symfony/framework-bundle/Resources/config/uid.php=  me=  S      B   vendor/symfony/framework-bundle/Resources/config/property_info.php	  me	  j      8   vendor/symfony/framework-bundle/Resources/config/ssi.php  me  5{      8   vendor/symfony/framework-bundle/Resources/config/web.php  me  ]|      D   vendor/symfony/framework-bundle/Resources/config/messenger_debug.php  me  o灤      ?   vendor/symfony/framework-bundle/Resources/config/collectors.phpM  meM  %fB      C   vendor/symfony/framework-bundle/Resources/config/routing/errors.xml  me  >      <   vendor/symfony/framework-bundle/Resources/config/secrets.php  me  *n      9   vendor/symfony/framework-bundle/Resources/config/form.php  me  `      >   vendor/symfony/framework-bundle/Resources/config/form_csrf.phpD  meD  A3U      =   vendor/symfony/framework-bundle/Resources/config/workflow.php  me  V/      B   vendor/symfony/framework-bundle/Resources/config/security_csrf.php}  me}  jnk      H   vendor/symfony/framework-bundle/Resources/config/notifier_transports.php9  me9        ?   vendor/symfony/framework-bundle/Resources/config/debug_prod.php  me  U      D   vendor/symfony/framework-bundle/Resources/config/property_access.php  me  Bʤ      ;   vendor/symfony/framework-bundle/Resources/config/assets.phpl
  mel
  Cd|<      @   vendor/symfony/framework-bundle/Resources/config/cache_debug.php  me  %]      1   vendor/symfony/framework-bundle/KernelBrowser.php  me  rI馤      D   vendor/symfony/framework-bundle/CacheWarmer/ValidatorCacheWarmer.php
  me
  W      H   vendor/symfony/framework-bundle/CacheWarmer/ConfigBuilderCacheWarmer.phpN  meN  u8f      J   vendor/symfony/framework-bundle/CacheWarmer/AbstractPhpFileCacheWarmer.php
  me
        A   vendor/symfony/framework-bundle/CacheWarmer/RouterCacheWarmer.php8  me8        G   vendor/symfony/framework-bundle/CacheWarmer/TranslationsCacheWarmer.php  me  A      E   vendor/symfony/framework-bundle/CacheWarmer/SerializerCacheWarmer.php!  me!  e{      K   vendor/symfony/framework-bundle/CacheWarmer/CachePoolClearerCacheWarmer.php  me  	#A
      F   vendor/symfony/framework-bundle/CacheWarmer/AnnotationsCacheWarmer.php<  me<  OY      A   vendor/symfony/framework-bundle/Controller/AbstractController.phpJ  meJ  og0      A   vendor/symfony/framework-bundle/Controller/TemplateController.php  me  hu      A   vendor/symfony/framework-bundle/Controller/ControllerResolver.phpG  meG  ,uߤ      A   vendor/symfony/framework-bundle/Controller/RedirectController.phpn  men  hs>      )   vendor/symfony/framework-bundle/README.md  me  ^)J      7   vendor/symfony/framework-bundle/HttpCache/HttpCache.php
  me
  @.F      3   vendor/symfony/framework-bundle/FrameworkBundle.phpI-  meI-        >   vendor/symfony/framework-bundle/Command/SecretsListCommand.php
  me
  _      @   vendor/symfony/framework-bundle/Command/SecretsRemoveCommand.php7
  me7
  C      =   vendor/symfony/framework-bundle/Command/CacheClearCommand.php_'  me_'  cQ?      <   vendor/symfony/framework-bundle/Command/XliffLintCommand.php  me  J L0      H   vendor/symfony/framework-bundle/Command/SecretsDecryptToLocalCommand.php  me  f`פ      A   vendor/symfony/framework-bundle/Command/AbstractConfigCommand.php  me  p      >   vendor/symfony/framework-bundle/Command/RouterDebugCommand.php  me  h      D   vendor/symfony/framework-bundle/Command/TranslationUpdateCommand.phpsH  mesH  ym      F   vendor/symfony/framework-bundle/Command/ConfigDumpReferenceCommand.php  me  kzE      @   vendor/symfony/framework-bundle/Command/AssetsInstallCommand.php(  me(  q8      A   vendor/symfony/framework-bundle/Command/CachePoolPruneCommand.php  me  }=      A   vendor/symfony/framework-bundle/Command/CachePoolClearCommand.php  me  ͉f      @   vendor/symfony/framework-bundle/Command/ContainerLintCommand.phpP  meP  KA      J   vendor/symfony/framework-bundle/Command/SecretsEncryptFromLocalCommand.php  me  #E      B   vendor/symfony/framework-bundle/Command/DebugAutowiringCommand.php  me  j%      >   vendor/symfony/framework-bundle/Command/CacheWarmupCommand.php\  me\  hӗ      ?   vendor/symfony/framework-bundle/Command/WorkflowDumpCommand.php  me  }[      G   vendor/symfony/framework-bundle/Command/EventDispatcherDebugCommand.phph  meh  /      A   vendor/symfony/framework-bundle/Command/ContainerDebugCommand.php12  me12  #      C   vendor/symfony/framework-bundle/Command/TranslationDebugCommand.phpN<  meN<  5      ;   vendor/symfony/framework-bundle/Command/YamlLintCommand.php<  me<  =      @   vendor/symfony/framework-bundle/Command/CachePoolListCommand.phpI  meI  z      F   vendor/symfony/framework-bundle/Command/SecretsGenerateKeysCommand.phpr  mer  N      B   vendor/symfony/framework-bundle/Command/CachePoolDeleteCommand.php  me  ]nM      D   vendor/symfony/framework-bundle/Command/BuildDebugContainerTrait.phpL
  meL
  )Hf      8   vendor/symfony/framework-bundle/Command/AboutCommand.php  me  ]      >   vendor/symfony/framework-bundle/Command/RouterMatchCommand.phpE  meE  m`      =   vendor/symfony/framework-bundle/Command/SecretsSetCommand.php  me  I.Ҥ      >   vendor/symfony/framework-bundle/Command/ConfigDebugCommand.php`!  me`!  oK*      J   vendor/symfony/framework-bundle/Routing/RedirectableCompiledUrlMatcher.php6  me6  L9d      @   vendor/symfony/framework-bundle/Routing/RouteLoaderInterface.php  me  b       2   vendor/symfony/framework-bundle/Routing/Router.php  me  .      <   vendor/symfony/framework-bundle/Routing/DelegatingLoader.php
  me
  Fޤ      J   vendor/symfony/framework-bundle/Routing/AnnotatedRouteControllerLoader.php  me  @      E   vendor/symfony/framework-bundle/DependencyInjection/Configuration.php  me  RӤ      J   vendor/symfony/framework-bundle/DependencyInjection/FrameworkExtension.php  me  _       ^   vendor/symfony/framework-bundle/DependencyInjection/Compiler/ContainerBuilderDebugDumpPass.php  me  br      `   vendor/symfony/framework-bundle/DependencyInjection/Compiler/TestServiceContainerRealRefPass.phpm  mem  V      c   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AddExpressionLanguageProvidersPass.php  me  \\b      O   vendor/symfony/framework-bundle/DependencyInjection/Compiler/UnusedTagsPass.phpM  meM  Zt      R   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AssetsContextPass.php  me  Ƅ      X   vendor/symfony/framework-bundle/DependencyInjection/Compiler/ErrorLoggerCompilerPass.php  me  7      Z   vendor/symfony/framework-bundle/DependencyInjection/Compiler/WorkflowGuardListenerPass.php  me  f      `   vendor/symfony/framework-bundle/DependencyInjection/Compiler/TestServiceContainerWeakRefPass.php  me  P      V   vendor/symfony/framework-bundle/DependencyInjection/Compiler/LoggingTranslatorPass.php	  me	  R      L   vendor/symfony/framework-bundle/DependencyInjection/Compiler/SessionPass.php  me  3	      \   vendor/symfony/framework-bundle/DependencyInjection/Compiler/DataCollectorTranslatorPass.php  me  ל      _   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AddAnnotationsCachedReaderPass.php  me  4FcԤ      M   vendor/symfony/framework-bundle/DependencyInjection/Compiler/ProfilerPass.php	  me	  2ɤ      j   vendor/symfony/framework-bundle/DependencyInjection/Compiler/RemoveUnusedSessionMarshallingHandlerPass.php  me  _n      Y   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AddDebugLogProcessorPass.php  me   &Ƥ      -   vendor/symfony/framework-bundle/composer.jsonh  meh  $w      ;   vendor/symfony/framework-bundle/Kernel/MicroKernelTrait.php"  me"  E      7   vendor/symfony/framework-bundle/Console/Application.phpB  meB  򚬤      E   vendor/symfony/framework-bundle/Console/Descriptor/TextDescriptor.phpUf  meUf  }'      D   vendor/symfony/framework-bundle/Console/Descriptor/XmlDescriptor.phpa  mea  ra      A   vendor/symfony/framework-bundle/Console/Descriptor/Descriptor.phpQ3  meQ3  O      E   vendor/symfony/framework-bundle/Console/Descriptor/JsonDescriptor.php<  me<  $      I   vendor/symfony/framework-bundle/Console/Descriptor/MarkdownDescriptor.phpB  meB  ;B$      C   vendor/symfony/framework-bundle/Console/Helper/DescriptorHelper.php  me  p      Q   vendor/symfony/framework-bundle/EventListener/SuggestMissingPackageSubscriber.php
  me
  cT      A   vendor/symfony/framework-bundle/Session/ServiceSessionFactory.php  me   pUۤ      D   vendor/symfony/framework-bundle/Session/DeprecatedSessionFactory.php4  me4  MU      %   vendor/symfony/monolog-bundle/LICENSE)  me)  Ǥ      *   vendor/symfony/monolog-bundle/CHANGELOG.md  me  :L      :   vendor/symfony/monolog-bundle/Resources/config/monolog.xml.  me.   0yK      E   vendor/symfony/monolog-bundle/Resources/config/schema/monolog-1.0.xsd'  me'  )X      <   vendor/symfony/monolog-bundle/SwiftMailer/MessageFactory.php  me        '   vendor/symfony/monolog-bundle/README.mdY  meY        /   vendor/symfony/monolog-bundle/MonologBundle.php  me  @g      F   vendor/symfony/monolog-bundle/DependencyInjection/MonologExtension.phpi  mei  ve      C   vendor/symfony/monolog-bundle/DependencyInjection/Configuration.php  me  vr      P   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/AddProcessorsPass.php  me  R      P   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/LoggerChannelPass.php  me        O   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/DebugHandlerPass.php
  me
  HS      Q   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/FixEmptyLoggerPass.php  me  DN      Z   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/AddSwiftMailerTransportPass.php  me   *Q      +   vendor/symfony/monolog-bundle/composer.json  me  Ǉ      %   vendor/symfony/polyfill-php73/LICENSE,  me,        '   vendor/symfony/polyfill-php73/Php73.phps  mes  D\      ?   vendor/symfony/polyfill-php73/Resources/stubs/JsonException.phpE  meE  8S      +   vendor/symfony/polyfill-php73/bootstrap.php  me  |      '   vendor/symfony/polyfill-php73/README.md/  me/  m      +   vendor/symfony/polyfill-php73/composer.json  me  =Ǥ      *   vendor/symfony/polyfill-php80/PhpToken.php  me  s`      %   vendor/symfony/polyfill-php80/LICENSE,  me,  K      :   vendor/symfony/polyfill-php80/Resources/stubs/PhpToken.phpw  mew  =7T8      <   vendor/symfony/polyfill-php80/Resources/stubs/ValueError.php>  me>  g      ;   vendor/symfony/polyfill-php80/Resources/stubs/Attribute.php  me  MK<      E   vendor/symfony/polyfill-php80/Resources/stubs/UnhandledMatchError.phpG  meG  ֈ+      <   vendor/symfony/polyfill-php80/Resources/stubs/Stringable.php  me  t]\ڤ      +   vendor/symfony/polyfill-php80/bootstrap.php  me  .Ĥ      '   vendor/symfony/polyfill-php80/README.md  me  "tF      '   vendor/symfony/polyfill-php80/Php80.php  me  H      +   vendor/symfony/polyfill-php80/composer.jsonb  meb         7   vendor/symfony/monolog-bridge/Handler/MailerHandler.php  me  wI      8   vendor/symfony/monolog-bridge/Handler/ConsoleHandler.phpf  mef         S   vendor/symfony/monolog-bridge/Handler/FingersCrossed/HttpCodeActivationStrategy.php  me  E      S   vendor/symfony/monolog-bridge/Handler/FingersCrossed/NotFoundActivationStrategy.php  me  A      <   vendor/symfony/monolog-bridge/Handler/SwiftMailerHandler.php	  me	  Yl8      :   vendor/symfony/monolog-bridge/Handler/ServerLogHandler.phpm  mem  W!      9   vendor/symfony/monolog-bridge/Handler/NotifierHandler.php^	  me^	  `Zj      8   vendor/symfony/monolog-bridge/Handler/FirePHPHandler.php  me  AĬ      :   vendor/symfony/monolog-bridge/Handler/ChromePhpHandler.phpY  meY        F   vendor/symfony/monolog-bridge/Handler/ElasticsearchLogstashHandler.php  me  h      (   vendor/symfony/monolog-bridge/Logger.php	  me	  ,	I      %   vendor/symfony/monolog-bridge/LICENSE,  me,  U      *   vendor/symfony/monolog-bridge/CHANGELOG.md
  me
  Ez      :   vendor/symfony/monolog-bridge/Processor/TokenProcessor.phpg  meg  V      D   vendor/symfony/monolog-bridge/Processor/SwitchUserTokenProcessor.php$  me$  xsz      8   vendor/symfony/monolog-bridge/Processor/WebProcessor.php  me  \OL      :   vendor/symfony/monolog-bridge/Processor/RouteProcessor.php-	  me-	  pF7      C   vendor/symfony/monolog-bridge/Processor/ConsoleCommandProcessor.phpn  men  
K      B   vendor/symfony/monolog-bridge/Processor/AbstractTokenProcessor.php4  me4  2uƤ      :   vendor/symfony/monolog-bridge/Processor/DebugProcessor.php  me  
f      '   vendor/symfony/monolog-bridge/README.md  me  =~      <   vendor/symfony/monolog-bridge/Formatter/ConsoleFormatter.php  me  =      >   vendor/symfony/monolog-bridge/Formatter/VarDumperFormatter.php  me  -[֞      H   vendor/symfony/monolog-bridge/Messenger/ResetLoggersWorkerSubscriber.php_  me_  #wd      :   vendor/symfony/monolog-bridge/Command/ServerLogCommand.phpv  mev  [,      +   vendor/symfony/monolog-bridge/composer.json:  me:  o2      9   vendor/symfony/cache/DataCollector/CacheDataCollector.php  me  z      "   vendor/symfony/cache/CacheItem.php2  me2  8r      #   vendor/symfony/cache/Psr16Cache.php
"  me
"  mNt         vendor/symfony/cache/LICENSE,  me,  X      +   vendor/symfony/cache/PruneableInterface.php  me  U      !   vendor/symfony/cache/CHANGELOG.md  me  OF.      5   vendor/symfony/cache/Traits/RedisClusterNodeProxy.phpX  meX  X      *   vendor/symfony/cache/Traits/RedisTrait.php.l  me.l  !      *   vendor/symfony/cache/Traits/ProxyTrait.phpZ  meZ  nq      5   vendor/symfony/cache/Traits/FilesystemCommonTrait.php  me  u      1   vendor/symfony/cache/Traits/RedisClusterProxy.php  me  Pv      *   vendor/symfony/cache/Traits/RedisProxy.php,  me,  kp      .   vendor/symfony/cache/Traits/ContractsTrait.phpi  mei  G      /   vendor/symfony/cache/Traits/FilesystemTrait.php  me  C      4   vendor/symfony/cache/Traits/AbstractAdapterTrait.php1  me1  v      )   vendor/symfony/cache/DoctrineProvider.php
  me
  ;w      -   vendor/symfony/cache/Adapter/ProxyAdapter.php:!  me:!  hHФ      ,   vendor/symfony/cache/Adapter/ApcuAdapter.php  me  >i:      ;   vendor/symfony/cache/Adapter/CouchbaseCollectionAdapter.phpq  meq  P      1   vendor/symfony/cache/Adapter/TraceableAdapter.php|  me|  Vt      +   vendor/symfony/cache/Adapter/PdoAdapter.phppT  mepT  U4      -   vendor/symfony/cache/Adapter/ArrayAdapter.php,  me,  K      5   vendor/symfony/cache/Adapter/RedisTagAwareAdapter.php1  me1  X5      7   vendor/symfony/cache/Adapter/CouchbaseBucketAdapter.phpT  meT  ώ      ,   vendor/symfony/cache/Adapter/NullAdapter.php
  me
  s      4   vendor/symfony/cache/Adapter/ParameterNormalizer.php  me  oe      0   vendor/symfony/cache/Adapter/TagAwareAdapter.phpE,  meE,  N      0   vendor/symfony/cache/Adapter/PhpFilesAdapter.php(  me(  (]ˤ      4   vendor/symfony/cache/Adapter/DoctrineDbalAdapter.phpC  meC  `V      9   vendor/symfony/cache/Adapter/TagAwareAdapterInterface.php  me  :      1   vendor/symfony/cache/Adapter/MemcachedAdapter.php6  me6         -   vendor/symfony/cache/Adapter/RedisAdapter.php  me  eR!=      1   vendor/symfony/cache/Adapter/AdapterInterface.php
  me
  ڑ      :   vendor/symfony/cache/Adapter/FilesystemTagAwareAdapter.phpH  meH  !¤      9   vendor/symfony/cache/Adapter/TraceableTagAwareAdapter.php  me  ;K      -   vendor/symfony/cache/Adapter/Psr16Adapter.php  me   Ó      -   vendor/symfony/cache/Adapter/ChainAdapter.php$  me$  -/      2   vendor/symfony/cache/Adapter/FilesystemAdapter.php  me  (Acb      0   vendor/symfony/cache/Adapter/DoctrineAdapter.php*  me*  t      0   vendor/symfony/cache/Adapter/AbstractAdapter.phpz!  mez!  >֤      8   vendor/symfony/cache/Adapter/AbstractTagAwareAdapter.php?2  me?2  Jx|      0   vendor/symfony/cache/Adapter/PhpArrayAdapter.php1  me1  ;դ      %   vendor/symfony/cache/LockRegistry.php@  me@  B'      ,   vendor/symfony/cache/ResettableInterface.php  me  NR         vendor/symfony/cache/README.md  me  `t:      9   vendor/symfony/cache/Messenger/EarlyExpirationHandler.php	  me	  I4t      9   vendor/symfony/cache/Messenger/EarlyExpirationMessage.php[
  me[
  g#      <   vendor/symfony/cache/Messenger/EarlyExpirationDispatcher.phpf	  mef	  yOK      5   vendor/symfony/cache/Marshaller/DefaultMarshaller.php  me  }ȵ      5   vendor/symfony/cache/Marshaller/DeflateMarshaller.php  me  UIf      7   vendor/symfony/cache/Marshaller/MarshallerInterface.phpG  meG  |ѷ      6   vendor/symfony/cache/Marshaller/TagAwareMarshaller.php%  me%  =	Ԥ      4   vendor/symfony/cache/Marshaller/SodiumMarshaller.php	  me	  6      :   vendor/symfony/cache/DependencyInjection/CachePoolPass.phpy-  mey-  O      @   vendor/symfony/cache/DependencyInjection/CachePoolPrunerPass.php  me  '      ?   vendor/symfony/cache/DependencyInjection/CacheCollectorPass.php  me        A   vendor/symfony/cache/DependencyInjection/CachePoolClearerPass.phpN  meN  jc      1   vendor/symfony/cache/Exception/LogicException.php  me  9d      ;   vendor/symfony/cache/Exception/InvalidArgumentException.php  me  j      1   vendor/symfony/cache/Exception/CacheException.php  me  Q4      "   vendor/symfony/cache/composer.json  me  A.      -   vendor/symfony/polyfill-ctype/bootstrap80.phpr  mer  F)      %   vendor/symfony/polyfill-ctype/LICENSE,  me,        +   vendor/symfony/polyfill-ctype/bootstrap.php@  me@  jQ9      '   vendor/symfony/polyfill-ctype/README.md^  me^  lHk      '   vendor/symfony/polyfill-ctype/Ctype.php  me   /      +   vendor/symfony/polyfill-ctype/composer.json  me  ӹ      %   vendor/symfony/polyfill-php81/LICENSE,  me,  0      F   vendor/symfony/polyfill-php81/Resources/stubs/ReturnTypeWillChange.php  me  5+      @   vendor/symfony/polyfill-php81/Resources/stubs/CURLStringFile.php  me  X(P      +   vendor/symfony/polyfill-php81/bootstrap.php  me  <P      '   vendor/symfony/polyfill-php81/README.md  me        '   vendor/symfony/polyfill-php81/Php81.php  me  3E      +   vendor/symfony/polyfill-php81/composer.json  me  0      F   vendor/symfony/security-bundle/DataCollector/SecurityDataCollector.php5  me5  j      &   vendor/symfony/security-bundle/LICENSE,  me,  U      +   vendor/symfony/security-bundle/CHANGELOG.md6  me6  @E      G   vendor/symfony/security-bundle/Security/LegacyLogoutHandlerListener.php,  me,  i      ?   vendor/symfony/security-bundle/Security/LazyFirewallContext.php	  me	  
ä      =   vendor/symfony/security-bundle/Security/UserAuthenticator.phpc  mec  1      ;   vendor/symfony/security-bundle/Security/FirewallContext.phpk  mek  (RS      7   vendor/symfony/security-bundle/Security/FirewallMap.php8	  me8	   &      :   vendor/symfony/security-bundle/Security/FirewallConfig.php@  me@  ;_      >   vendor/symfony/security-bundle/Security/FirewallAwareTrait.php  me  t      C   vendor/symfony/security-bundle/Resources/config/templating_twig.php  me  @']      F   vendor/symfony/security-bundle/Resources/config/security_listeners.php  me  we      U   vendor/symfony/security-bundle/Resources/config/security_authenticator_login_link.php	  me	  +      G   vendor/symfony/security-bundle/Resources/config/security_rememberme.php
  me
        9   vendor/symfony/security-bundle/Resources/config/guard.php  me  B{ˤ      C   vendor/symfony/security-bundle/Resources/config/security_legacy.phpq  meq  )	      B   vendor/symfony/security-bundle/Resources/config/security_debug.php3  me3  6!H!      A   vendor/symfony/security-bundle/Resources/config/debug_console.php   me         G   vendor/symfony/security-bundle/Resources/config/schema/security-1.0.xsdP  meP  |A      ;   vendor/symfony/security-bundle/Resources/config/console.php  me  ,g      C   vendor/symfony/security-bundle/Resources/config/password_hasher.php  me  ް      >   vendor/symfony/security-bundle/Resources/config/collectors.php  me  u|      J   vendor/symfony/security-bundle/Resources/config/security_authenticator.php.  me.  ΘL      <   vendor/symfony/security-bundle/Resources/config/security.phpI-  meI-  E      V   vendor/symfony/security-bundle/Resources/config/security_authenticator_remember_me.php8  me8  \&+      A   vendor/symfony/security-bundle/Resources/views/Collector/icon.svg  me  r      K   vendor/symfony/security-bundle/Resources/views/Collector/security.html.twig\  me\  O\      D   vendor/symfony/security-bundle/CacheWarmer/ExpressionCacheWarmer.php3  me3  ;Z3z      1   vendor/symfony/security-bundle/SecurityBundle.phpS  meS  ?      (   vendor/symfony/security-bundle/README.md  me  [A      H   vendor/symfony/security-bundle/RememberMe/DecoratedRememberMeHandler.php  me  =/g      L   vendor/symfony/security-bundle/RememberMe/FirewallAwareRememberMeHandler.php@  me@  G٤      ?   vendor/symfony/security-bundle/Command/DebugFirewallCommand.phpR$  meR$  (D5      E   vendor/symfony/security-bundle/Command/UserPasswordEncoderCommand.php  me  
◪      J   vendor/symfony/security-bundle/LoginLink/FirewallAwareLoginLinkHandler.php  me  ʤ      H   vendor/symfony/security-bundle/DependencyInjection/MainConfiguration.phpB  meB  S      X   vendor/symfony/security-bundle/DependencyInjection/Security/UserProvider/LdapFactory.phpV	  meV	  J[      \   vendor/symfony/security-bundle/DependencyInjection/Security/UserProvider/InMemoryFactory.php
  me
  qv      i   vendor/symfony/security-bundle/DependencyInjection/Security/UserProvider/UserProviderFactoryInterface.php  me  @      b   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/GuardAuthenticationFactory.php  me  ʖ      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/LoginLinkFactory.php@  me@  y      \   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/HttpBasicLdapFactory.php  me  )\n      \   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/JsonLoginLdapFactory.phpE	  meE	  b`դ      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/FormLoginFactory.php  me  UO      \   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/FormLoginLdapFactory.php	  me	  .      b   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/CustomAuthenticatorFactory.php  me  R      `   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/SecurityFactoryInterface.phpL  meL  aѤ      Y   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/RemoteUserFactory.phpM  meM  1Ϥ      e   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/AuthenticatorFactoryInterface.php  me        Y   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/RememberMeFactory.phpV?  meV?  95      W   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/AbstractFactory.php  me  $<      S   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/X509Factory.php  me  #S      h   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/FirewallListenerFactoryInterface.phpq  meq  !e      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/AnonymousFactory.php"  me"  5I      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/JsonLoginFactory.php  me        X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/HttpBasicFactory.php>  me>  yC٤      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/LdapFactoryTrait.phpm	  mem	  盤      ^   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/LoginThrottlingFactory.php  me  V      H   vendor/symfony/security-bundle/DependencyInjection/SecurityExtension.phpW  meW  6_ؤ      b   vendor/symfony/security-bundle/DependencyInjection/Compiler/AddExpressionLanguageProvidersPass.phpe  mee  8Ƥ      ^   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterTokenUsageTrackingPass.phpd	  med	  πΤ      j   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterCsrfTokenClearingLogoutHandlerPass.php}  me}  {      W   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterLdapLocatorPass.phpP  meP  a5       h   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterGlobalSecurityEventListenersPass.php
  me
  ϗ       Y   vendor/symfony/security-bundle/DependencyInjection/Compiler/SortFirewallListenersPass.php  me  \Un      e   vendor/symfony/security-bundle/DependencyInjection/Compiler/ReplaceDecoratedRememberMeHandlerPass.php	  me	  A      ^   vendor/symfony/security-bundle/DependencyInjection/Compiler/AddSessionDomainConstraintPass.php  me        U   vendor/symfony/security-bundle/DependencyInjection/Compiler/AddSecurityVotersPass.php
  me
  q      V   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterEntryPointPass.php  me  9paB      [   vendor/symfony/security-bundle/DependencyInjection/Compiler/CleanRememberMeVerifierPass.php  me  L2i      X   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterCsrfFeaturesPass.phpp	  mep	  e}      ,   vendor/symfony/security-bundle/composer.json#
  me#
  K      B   vendor/symfony/security-bundle/Debug/TraceableFirewallListener.php  me  A˖      8   vendor/symfony/security-bundle/Debug/WrappedListener.php  me  (      ?   vendor/symfony/security-bundle/Debug/TraceableListenerTrait.php  me        <   vendor/symfony/security-bundle/Debug/WrappedLazyListener.phpH  meH  Ǫ`      A   vendor/symfony/security-bundle/EventListener/FirewallListener.php  me  %      =   vendor/symfony/security-bundle/EventListener/VoteListener.phpo  meo  g      4   vendor/symfony/config/ResourceCheckerConfigCache.php_  me_  X         vendor/symfony/config/LICENSE,  me,  U      '   vendor/symfony/config/Util/XmlUtils.php&  me&  {o      <   vendor/symfony/config/Util/Exception/XmlParsingException.php  me  䢗      <   vendor/symfony/config/Util/Exception/InvalidXmlException.php4  me4        "   vendor/symfony/config/CHANGELOG.md  me  QyȤ      .   vendor/symfony/config/ConfigCacheInterface.php  me  O2      .   vendor/symfony/config/FileLocatorInterface.php?  me?  ,c      %   vendor/symfony/config/ConfigCache.php  me  ō      5   vendor/symfony/config/ConfigCacheFactoryInterface.php  me  EizĤ      %   vendor/symfony/config/FileLocator.php	  me	  2      2   vendor/symfony/config/ResourceCheckerInterface.php  me  åؤ         vendor/symfony/config/README.mdT  meT        '   vendor/symfony/config/Loader/Loader.php  me  l      +   vendor/symfony/config/Loader/FileLoader.php  me  
=Ol      2   vendor/symfony/config/Loader/ParamConfigurator.phpj  mej  O3      0   vendor/symfony/config/Loader/LoaderInterface.php  me  q7      8   vendor/symfony/config/Loader/LoaderResolverInterface.php  me  o[ߤ      /   vendor/symfony/config/Loader/LoaderResolver.php  me  YM      1   vendor/symfony/config/Loader/DelegatingLoader.php  me  x9      /   vendor/symfony/config/Loader/GlobFileLoader.php  me  .ο      .   vendor/symfony/config/Definition/FloatNode.php  me  D      -   vendor/symfony/config/Definition/BaseNode.phpG?  meG?  (`      0   vendor/symfony/config/Definition/NumericNode.php  me  7      0   vendor/symfony/config/Definition/IntegerNode.phpv  mev  H*      ;   vendor/symfony/config/Definition/PrototypeNodeInterface.phpU  meU  bnB      8   vendor/symfony/config/Definition/PrototypedArrayNode.php|,  me|,  &,      .   vendor/symfony/config/Definition/Processor.php
  me
        2   vendor/symfony/config/Definition/NodeInterface.php	  me	  m)Ȥ      -   vendor/symfony/config/Definition/EnumNode.php  me  #¤      0   vendor/symfony/config/Definition/BooleanNode.php  me  Mޤ      .   vendor/symfony/config/Definition/ArrayNode.php.  me.  c٤      /   vendor/symfony/config/Definition/ScalarNode.php  me  ݜͤ      ;   vendor/symfony/config/Definition/ConfigurationInterface.php  me  _+      8   vendor/symfony/config/Definition/Builder/ExprBuilder.php  me        ?   vendor/symfony/config/Definition/Builder/EnumNodeDefinition.php  me  nŤ      9   vendor/symfony/config/Definition/Builder/MergeBuilder.php  me  E#      B   vendor/symfony/config/Definition/Builder/NumericNodeDefinition.php  me        8   vendor/symfony/config/Definition/Builder/NodeBuilder.php  me  Q      C   vendor/symfony/config/Definition/Builder/VariableNodeDefinition.phpP  meP  q      @   vendor/symfony/config/Definition/Builder/ArrayNodeDefinition.php>  me>  #$      B   vendor/symfony/config/Definition/Builder/BuilderAwareInterface.phpQ  meQ  Wج      >   vendor/symfony/config/Definition/Builder/ValidationBuilder.php  me  "      8   vendor/symfony/config/Definition/Builder/TreeBuilder.php  me  AJ      B   vendor/symfony/config/Definition/Builder/IntegerNodeDefinition.php-  me-  ܩǤ      @   vendor/symfony/config/Definition/Builder/NodeParentInterface.php  me  ʤ      A   vendor/symfony/config/Definition/Builder/NormalizationBuilder.php  me  w      B   vendor/symfony/config/Definition/Builder/BooleanNodeDefinition.php4  me4  ~֤      J   vendor/symfony/config/Definition/Builder/ParentNodeDefinitionInterface.php  me  WG֤      A   vendor/symfony/config/Definition/Builder/ScalarNodeDefinition.php  me  Bڤ      @   vendor/symfony/config/Definition/Builder/FloatNodeDefinition.php"  me"  Uf+      ;   vendor/symfony/config/Definition/Builder/NodeDefinition.php"  me"  6$      D   vendor/symfony/config/Definition/Exception/DuplicateKeyException.phpS  meS  g      I   vendor/symfony/config/Definition/Exception/InvalidDefinitionException.php  me  re      C   vendor/symfony/config/Definition/Exception/InvalidTypeException.php  me  2      @   vendor/symfony/config/Definition/Exception/UnsetKeyException.php*  me*  %2d      L   vendor/symfony/config/Definition/Exception/InvalidConfigurationException.phpO  meO  36A*      J   vendor/symfony/config/Definition/Exception/ForbiddenOverwriteException.php_  me_  :      8   vendor/symfony/config/Definition/Exception/Exception.php  me  RrO      1   vendor/symfony/config/Definition/VariableNode.php
  me
  ͤ      ?   vendor/symfony/config/Definition/Dumper/YamlReferenceDumper.php7!  me7!        >   vendor/symfony/config/Definition/Dumper/XmlReferenceDumper.phpK)  meK)  4^      @   vendor/symfony/config/Resource/SelfCheckingResourceInterface.php  me        /   vendor/symfony/config/Resource/FileResource.php  me  D[      :   vendor/symfony/config/Resource/ReflectionClassResource.php$  me$  ?EU      >   vendor/symfony/config/Resource/SelfCheckingResourceChecker.php  me  9ڤ      3   vendor/symfony/config/Resource/ComposerResource.phpD  meD  >pf      8   vendor/symfony/config/Resource/FileExistenceResource.php  me  I      4   vendor/symfony/config/Resource/ResourceInterface.php  me  (      9   vendor/symfony/config/Resource/ClassExistenceResource.phpP  meP  MW      4   vendor/symfony/config/Resource/DirectoryResource.php
  me
  gd      /   vendor/symfony/config/Resource/GlobResource.php  me  h2      8   vendor/symfony/config/Builder/ConfigBuilderInterface.php  me  {O      (   vendor/symfony/config/Builder/Method.php  me  5_      .   vendor/symfony/config/Builder/ClassBuilder.php  me  ^NI      *   vendor/symfony/config/Builder/Property.php  me  	      A   vendor/symfony/config/Builder/ConfigBuilderGeneratorInterface.php  me        8   vendor/symfony/config/Builder/ConfigBuilderGenerator.phpH  meH  ʤ      7   vendor/symfony/config/Exception/LoaderLoadException.phpn  men  o      N   vendor/symfony/config/Exception/FileLoaderImportCircularReferenceException.php$  me$  2WS      D   vendor/symfony/config/Exception/FileLocatorFileNotFoundException.php   me   Ĥ      #   vendor/symfony/config/composer.json  me  a      ,   vendor/symfony/config/ConfigCacheFactory.php\  me\        ;   vendor/symfony/config/ResourceCheckerConfigCacheFactory.php:  me:   4      D   vendor/symfony/security-http/RateLimiter/DefaultLoginRateLimiter.php	  me	  #J      6   vendor/symfony/security-http/Attribute/CurrentUser.php  me  ޤ      $   vendor/symfony/security-http/LICENSE,  me,  U      5   vendor/symfony/security-http/Util/TargetPathTrait.phpT  meT  m      )   vendor/symfony/security-http/CHANGELOG.md5  me5        ,   vendor/symfony/security-http/FirewallMap.phpb  meb  y      )   vendor/symfony/security-http/Firewall.php  me  ,h      >   vendor/symfony/security-http/Logout/LogoutHandlerInterface.php  me  p7Y      <   vendor/symfony/security-http/Logout/SessionLogoutHandler.php  me  j      E   vendor/symfony/security-http/Logout/LogoutSuccessHandlerInterface.php  me  Z설      C   vendor/symfony/security-http/Logout/CookieClearingLogoutHandler.php  me  |V^      F   vendor/symfony/security-http/Logout/CsrfTokenClearingLogoutHandler.php  me  	Ȥ      :   vendor/symfony/security-http/Logout/LogoutUrlGenerator.php  me  'Ww      C   vendor/symfony/security-http/Logout/DefaultLogoutSuccessHandler.phpl  mel        /   vendor/symfony/security-http/SecurityEvents.php  me  7      8   vendor/symfony/security-http/Firewall/AccessListener.php  me  _訤      9   vendor/symfony/security-http/Firewall/ContextListener.php@  me@        I   vendor/symfony/security-http/Firewall/AnonymousAuthenticationListener.phpr  mer  +      :   vendor/symfony/security-http/Firewall/AbstractListener.phpj  mej  *Ȇ      <   vendor/symfony/security-http/Firewall/RememberMeListener.phpk  mek  .      F   vendor/symfony/security-http/Firewall/AuthenticatorManagerListener.phpL  meL  p
Ť      E   vendor/symfony/security-http/Firewall/BasicAuthenticationListener.phpo  meo  CJ      J   vendor/symfony/security-http/Firewall/AbstractPreAuthenticatedListener.php  me  2      ;   vendor/symfony/security-http/Firewall/ExceptionListener.php(  me(  '7      C   vendor/symfony/security-http/Firewall/FirewallListenerInterface.php"  me"  P2lI      9   vendor/symfony/security-http/Firewall/ChannelListener.php  me  &z$      T   vendor/symfony/security-http/Firewall/UsernamePasswordJsonAuthenticationListener.php'  me'  .E      <   vendor/symfony/security-http/Firewall/SwitchUserListener.php$  me$  H      8   vendor/symfony/security-http/Firewall/LogoutListener.php  me  Hr5      T   vendor/symfony/security-http/Firewall/UsernamePasswordFormAuthenticationListener.phpC  meC        H   vendor/symfony/security-http/Firewall/AbstractAuthenticationListener.phpz&  mez&  Pqܤ      D   vendor/symfony/security-http/Firewall/X509AuthenticationListener.php	  me	   T%      J   vendor/symfony/security-http/Firewall/RemoteUserAuthenticationListener.php  me  ]@z      =   vendor/symfony/security-http/Controller/UserValueResolver.phpI  meI  8&      &   vendor/symfony/security-http/README.md  me  QT`I      G   vendor/symfony/security-http/RememberMe/RememberMeServicesInterface.php  me  x|i      R   vendor/symfony/security-http/RememberMe/PersistentTokenBasedRememberMeServices.php+  me+  WO      <   vendor/symfony/security-http/RememberMe/ResponseListener.php  me  PS(      H   vendor/symfony/security-http/RememberMe/TokenBasedRememberMeServices.php  me  wT      G   vendor/symfony/security-http/RememberMe/PersistentRememberMeHandler.phpv  mev  ;=f      F   vendor/symfony/security-http/RememberMe/RememberMeHandlerInterface.php
  me
  	~¤      =   vendor/symfony/security-http/RememberMe/RememberMeDetails.php8  me8  Ϣ      E   vendor/symfony/security-http/RememberMe/AbstractRememberMeHandler.php&  me&  &Zˤ      F   vendor/symfony/security-http/RememberMe/AbstractRememberMeServices.php*  me*  Yd      F   vendor/symfony/security-http/RememberMe/SignatureRememberMeHandler.php_
  me_
  CȤ      M   vendor/symfony/security-http/EntryPoint/AuthenticationEntryPointInterface.php  me  3i      I   vendor/symfony/security-http/EntryPoint/RetryAuthenticationEntryPoint.php6  me6  }]*-      I   vendor/symfony/security-http/EntryPoint/BasicAuthenticationEntryPoint.php  me  yOQ      N   vendor/symfony/security-http/EntryPoint/Exception/NotAnEntryPointException.php5  me5  aYܤ      H   vendor/symfony/security-http/EntryPoint/FormAuthenticationEntryPoint.php  me  x      *   vendor/symfony/security-http/HttpUtils.php  me  \      5   vendor/symfony/security-http/FirewallMapInterface.php  me  9J      L   vendor/symfony/security-http/Authenticator/Token/PostAuthenticationToken.php  me  3Ȥ      P   vendor/symfony/security-http/Authenticator/InteractiveAuthenticatorInterface.php  me  =       M   vendor/symfony/security-http/Authenticator/AbstractLoginFormAuthenticator.php	  me	  J
      E   vendor/symfony/security-http/Authenticator/AuthenticatorInterface.php  me  ʰY      D   vendor/symfony/security-http/Authenticator/AbstractAuthenticator.php	  me	        E   vendor/symfony/security-http/Authenticator/HttpBasicAuthenticator.php[  me[  /3      E   vendor/symfony/security-http/Authenticator/LoginLinkAuthenticator.php  me  .      E   vendor/symfony/security-http/Authenticator/JsonLoginAuthenticator.php   me   ]o      N   vendor/symfony/security-http/Authenticator/Passport/SelfValidatingPassport.php  me  YWW      I   vendor/symfony/security-http/Authenticator/Passport/PassportInterface.php-  me-  C      @   vendor/symfony/security-http/Authenticator/Passport/Passport.php 
  me 
        E   vendor/symfony/security-http/Authenticator/Passport/PassportTrait.phpE  meE        M   vendor/symfony/security-http/Authenticator/Passport/UserPassportInterface.phpG  meG  ׶a      X   vendor/symfony/security-http/Authenticator/Passport/Credentials/CredentialsInterface.php  me  P      U   vendor/symfony/security-http/Authenticator/Passport/Credentials/CustomCredentials.php  me  \qx      W   vendor/symfony/security-http/Authenticator/Passport/Credentials/PasswordCredentials.php+  me+  H#r      W   vendor/symfony/security-http/Authenticator/Passport/Badge/PreAuthenticatedUserBadge.php  me  yΤ      L   vendor/symfony/security-http/Authenticator/Passport/Badge/CsrfTokenBadge.php>  me>  Rۤ      R   vendor/symfony/security-http/Authenticator/Passport/Badge/PasswordUpgradeBadge.php  me  !RMg      G   vendor/symfony/security-http/Authenticator/Passport/Badge/UserBadge.php4
  me4
  Eh      M   vendor/symfony/security-http/Authenticator/Passport/Badge/RememberMeBadge.php  me  i_$      L   vendor/symfony/security-http/Authenticator/Passport/Badge/BadgeInterface.php  me  ˙Au      @   vendor/symfony/security-http/Authenticator/X509Authenticator.php.  me.        F   vendor/symfony/security-http/Authenticator/RemoteUserAuthenticator.php  me  /q!      E   vendor/symfony/security-http/Authenticator/FormLoginAuthenticator.phpT!  meT!  m      T   vendor/symfony/security-http/Authenticator/AbstractPreAuthenticatedAuthenticator.php  me        K   vendor/symfony/security-http/Authenticator/Debug/TraceableAuthenticator.php  me  @b      Z   vendor/symfony/security-http/Authenticator/Debug/TraceableAuthenticatorManagerListener.php   me   w       F   vendor/symfony/security-http/Authenticator/RememberMeAuthenticator.phpI  meI  J'[Ԥ      K   vendor/symfony/security-http/Authorization/AccessDeniedHandlerInterface.php  me  bP      3   vendor/symfony/security-http/AccessMapInterface.phpa  mea  u      ;   vendor/symfony/security-http/LoginLink/LoginLinkDetails.phpB  meB  LZ
      ;   vendor/symfony/security-http/LoginLink/LoginLinkHandler.php  me  Z      @   vendor/symfony/security-http/LoginLink/LoginLinkNotification.php
  me
  ;;d      D   vendor/symfony/security-http/LoginLink/LoginLinkHandlerInterface.php  me  2AΤ      W   vendor/symfony/security-http/LoginLink/Exception/InvalidLoginLinkExceptionInterface.php  me  HF      N   vendor/symfony/security-http/LoginLink/Exception/InvalidLoginLinkException.php  me        \   vendor/symfony/security-http/LoginLink/Exception/InvalidLoginLinkAuthenticationException.php  me  M      N   vendor/symfony/security-http/LoginLink/Exception/ExpiredLoginLinkException.phpI  meI  Z      I   vendor/symfony/security-http/Authentication/NoopAuthenticationManager.php  me  Jp      S   vendor/symfony/security-http/Authentication/DefaultAuthenticationFailureHandler.php>  me>  C[      M   vendor/symfony/security-http/Authentication/AuthenticatorManagerInterface.php  me  1      R   vendor/symfony/security-http/Authentication/CustomAuthenticationSuccessHandler.php~  me~  
Ť      U   vendor/symfony/security-http/Authentication/AuthenticationFailureHandlerInterface.php  me  ^      C   vendor/symfony/security-http/Authentication/AuthenticationUtils.php+	  me+	  pq      R   vendor/symfony/security-http/Authentication/CustomAuthenticationFailureHandler.php  me  9      U   vendor/symfony/security-http/Authentication/AuthenticationSuccessHandlerInterface.php  me  T      J   vendor/symfony/security-http/Authentication/UserAuthenticatorInterface.php  me  
>      D   vendor/symfony/security-http/Authentication/AuthenticatorManager.php;  me;        S   vendor/symfony/security-http/Authentication/DefaultAuthenticationSuccessHandler.php&  me&  zC      *   vendor/symfony/security-http/AccessMap.phpz  mez  /      8   vendor/symfony/security-http/Event/LoginFailureEvent.php
  me
        8   vendor/symfony/security-http/Event/LoginSuccessEvent.php  me  9u_      ;   vendor/symfony/security-http/Event/DeauthenticatedEvent.phpL  meL  b      8   vendor/symfony/security-http/Event/LazyResponseEvent.php  me  @      6   vendor/symfony/security-http/Event/SwitchUserEvent.php[  me[  8oӤ      F   vendor/symfony/security-http/Event/AuthenticationTokenCreatedEvent.php  me        9   vendor/symfony/security-http/Event/CheckPassportEvent.php  me  /aJ      <   vendor/symfony/security-http/Event/InteractiveLoginEvent.php0  me0  X      2   vendor/symfony/security-http/Event/LogoutEvent.php  me  %      @   vendor/symfony/security-http/Event/TokenDeauthenticatedEvent.php  me  "C      D   vendor/symfony/security-http/Impersonate/ImpersonateUrlGenerator.php"
  me"
  T      2   vendor/symfony/security-http/ParameterBagUtils.php%
  me%
  E      *   vendor/symfony/security-http/composer.json3  me3        D   vendor/symfony/security-http/EventListener/SessionLogoutListener.php  me  t      D   vendor/symfony/security-http/EventListener/DefaultLogoutListener.php\  me\  O4HE      H   vendor/symfony/security-http/EventListener/PasswordMigratingListener.php  me  -1      A   vendor/symfony/security-http/EventListener/RememberMeListener.php	  me	  x      F   vendor/symfony/security-http/EventListener/LoginThrottlingListener.php  me  [%      C   vendor/symfony/security-http/EventListener/UserProviderListener.phpq  meq  p\      K   vendor/symfony/security-http/EventListener/CookieClearingLogoutListener.php  me  h@      G   vendor/symfony/security-http/EventListener/CheckCredentialsListener.php  me  6+?      G   vendor/symfony/security-http/EventListener/RememberMeLogoutListener.php  me  ͤ      F   vendor/symfony/security-http/EventListener/SessionStrategyListener.php  me  1#6)      N   vendor/symfony/security-http/EventListener/CsrfTokenClearingLogoutListener.phpi  mei  ='9      B   vendor/symfony/security-http/EventListener/UserCheckerListener.php  me  Ӗ      E   vendor/symfony/security-http/EventListener/CsrfProtectionListener.phpg  meg  !z      P   vendor/symfony/security-http/EventListener/CheckRememberMeConditionsListener.php
  me
        O   vendor/symfony/security-http/Session/SessionAuthenticationStrategyInterface.php(  me(  ୃԤ      F   vendor/symfony/security-http/Session/SessionAuthenticationStrategy.php7  me7  ?5Ǵ      <   vendor/symfony/event-dispatcher/EventDispatcherInterface.php  me  ʦv      =   vendor/symfony/event-dispatcher/Attribute/AsEventListener.php  me  $      '   vendor/symfony/event-dispatcher/LICENSE,  me,  U      ,   vendor/symfony/event-dispatcher/CHANGELOG.md,  me,  *פ      >   vendor/symfony/event-dispatcher/LegacyEventDispatcherProxy.php  me  |2      3   vendor/symfony/event-dispatcher/EventDispatcher.php $  me $  ;N      )   vendor/symfony/event-dispatcher/README.mdW  meW  ,fB      <   vendor/symfony/event-dispatcher/EventSubscriberInterface.php  me  A{)      <   vendor/symfony/event-dispatcher/ImmutableEventDispatcher.php  me  4zS      0   vendor/symfony/event-dispatcher/GenericEvent.php  me  wD      M   vendor/symfony/event-dispatcher/DependencyInjection/RegisterListenersPass.php%  me%  4      K   vendor/symfony/event-dispatcher/DependencyInjection/AddEventAliasesPass.php  me  n      -   vendor/symfony/event-dispatcher/composer.json  me  S      B   vendor/symfony/event-dispatcher/Debug/TraceableEventDispatcher.php.  me.  -X'      9   vendor/symfony/event-dispatcher/Debug/WrappedListener.php.  me.  Q䦌      +   vendor/symfony/var-dumper/Cloner/Cursor.phpH  meH  cq      .   vendor/symfony/var-dumper/Cloner/VarCloner.php5  me5  ѵ      4   vendor/symfony/var-dumper/Cloner/ClonerInterface.php  me   Mf      4   vendor/symfony/var-dumper/Cloner/DumperInterface.phpG  meG  g      3   vendor/symfony/var-dumper/Cloner/AbstractCloner.php\  me\  )      )   vendor/symfony/var-dumper/Cloner/Data.php6  me6  k      )   vendor/symfony/var-dumper/Cloner/Stub.php  me  J&      !   vendor/symfony/var-dumper/LICENSE,  me,  .z      5   vendor/symfony/var-dumper/Test/VarDumperTestTrait.php
  me
        &   vendor/symfony/var-dumper/CHANGELOG.md  me  /h      .   vendor/symfony/var-dumper/Caster/GmpCaster.php
  me
  "       5   vendor/symfony/var-dumper/Caster/ReflectionCaster.phpY9  meY9  {7{      /   vendor/symfony/var-dumper/Caster/StubCaster.phpt  met  ߤ      2   vendor/symfony/var-dumper/Caster/SymfonyCaster.php
  me
  /Q]      .   vendor/symfony/var-dumper/Caster/FrameStub.php  me  aa      7   vendor/symfony/var-dumper/Caster/ProxyManagerCaster.php  me  ;      /   vendor/symfony/var-dumper/Caster/DateCaster.php  me  6Y      .   vendor/symfony/var-dumper/Caster/PdoCaster.php  me  9      6   vendor/symfony/var-dumper/Caster/XmlResourceCaster.phpW	  meW	  =      3   vendor/symfony/var-dumper/Caster/ResourceCaster.phpc  mec  >*      4   vendor/symfony/var-dumper/Caster/ExceptionCaster.phpW?  meW?  W)sT      -   vendor/symfony/var-dumper/Caster/DsCaster.phpS  meS  c      -   vendor/symfony/var-dumper/Caster/LinkStub.phpb
  meb
  (17      4   vendor/symfony/var-dumper/Caster/MemcachedCaster.php	  me	  ֤      3   vendor/symfony/var-dumper/Caster/DoctrineCaster.php  me  l      2   vendor/symfony/var-dumper/Caster/RdKafkaCaster.php  me  ęs      1   vendor/symfony/var-dumper/Caster/MysqliCaster.php  me        ,   vendor/symfony/var-dumper/Caster/ImgStub.php  me  ͤ      .   vendor/symfony/var-dumper/Caster/ClassStub.php2  me2  +S      .   vendor/symfony/var-dumper/Caster/TraceStub.php  me  _      1   vendor/symfony/var-dumper/Caster/CutArrayStub.php  me  QG      0   vendor/symfony/var-dumper/Caster/PgSqlCaster.php  me  x      +   vendor/symfony/var-dumper/Caster/Caster.php  me  ;
ߤ      .   vendor/symfony/var-dumper/Caster/SplCaster.php  me  `      .   vendor/symfony/var-dumper/Caster/ConstStub.php  me  }      /   vendor/symfony/var-dumper/Caster/DsPairStub.phpb  meb  P-      /   vendor/symfony/var-dumper/Caster/IntlCaster.php)  me)  ˵J      0   vendor/symfony/var-dumper/Caster/RedisCaster.php  me  ("mt      0   vendor/symfony/var-dumper/Caster/FiberCaster.phpA  meA  >zӤ      2   vendor/symfony/var-dumper/Caster/ImagineCaster.php  me  |gdߤ      /   vendor/symfony/var-dumper/Caster/AmqpCaster.php  me  YR      .   vendor/symfony/var-dumper/Caster/DOMCaster.php!  me!  *	      /   vendor/symfony/var-dumper/Caster/UuidCaster.php  me  E7      4   vendor/symfony/var-dumper/Caster/XmlReaderCaster.php6  me6  z      -   vendor/symfony/var-dumper/Caster/ArgsStub.php	  me	  ͨ      -   vendor/symfony/var-dumper/Caster/EnumStub.php  me  `"      ,   vendor/symfony/var-dumper/Caster/CutStub.php  me  $N      7   vendor/symfony/var-dumper/Resources/bin/var-dump-server  me  '      :   vendor/symfony/var-dumper/Resources/css/htmlDescriptor.css  me  Dva      8   vendor/symfony/var-dumper/Resources/js/htmlDescriptor.jsb  meb  h|      6   vendor/symfony/var-dumper/Resources/functions/dump.php+  me+  7      /   vendor/symfony/var-dumper/Server/Connection.php
  me
  SJn      /   vendor/symfony/var-dumper/Server/DumpServer.php

  me

  ڤ      #   vendor/symfony/var-dumper/README.md_  me_  Fq      7   vendor/symfony/var-dumper/Command/ServerDumpCommand.php  me  l+      H   vendor/symfony/var-dumper/Command/Descriptor/DumpDescriptorInterface.php  me  a*      >   vendor/symfony/var-dumper/Command/Descriptor/CliDescriptor.php
  me
  F      ?   vendor/symfony/var-dumper/Command/Descriptor/HtmlDescriptor.php  me  "      ?   vendor/symfony/var-dumper/Exception/ThrowingCasterException.php  me  Q	k      1   vendor/symfony/var-dumper/Dumper/ServerDumper.php~  me~  NHΤ      8   vendor/symfony/var-dumper/Dumper/DataDumperInterface.php  me  ׌.      M   vendor/symfony/var-dumper/Dumper/ContextProvider/ContextProviderInterface.php(  me(  EFf      K   vendor/symfony/var-dumper/Dumper/ContextProvider/RequestContextProvider.php  me  p      G   vendor/symfony/var-dumper/Dumper/ContextProvider/CliContextProvider.php  me  y9.L      J   vendor/symfony/var-dumper/Dumper/ContextProvider/SourceContextProvider.php  me  C^)      3   vendor/symfony/var-dumper/Dumper/AbstractDumper.phpR  meR  	ܾQ      .   vendor/symfony/var-dumper/Dumper/CliDumper.phpRV  meRV  8h      9   vendor/symfony/var-dumper/Dumper/ContextualizedDumper.php  me  y5|      /   vendor/symfony/var-dumper/Dumper/HtmlDumper.phpc  mec  Ms      '   vendor/symfony/var-dumper/composer.jsonq  meq  T      '   vendor/symfony/var-dumper/VarDumper.php  me  /:      !   vendor/symfony/filesystem/LICENSE,  me,  U      &   vendor/symfony/filesystem/CHANGELOG.md  me  I      (   vendor/symfony/filesystem/Filesystem.phpu  meu  g      "   vendor/symfony/filesystem/Path.phpe  mee        #   vendor/symfony/filesystem/README.md  me        <   vendor/symfony/filesystem/Exception/IOExceptionInterface.php  me  yp      :   vendor/symfony/filesystem/Exception/ExceptionInterface.php  me  (l`Ф      8   vendor/symfony/filesystem/Exception/RuntimeException.php  me  A      3   vendor/symfony/filesystem/Exception/IOException.php  me         @   vendor/symfony/filesystem/Exception/InvalidArgumentException.php  me  $
      =   vendor/symfony/filesystem/Exception/FileNotFoundException.php  me   [:      '   vendor/symfony/filesystem/composer.json`  me`  tӺ      G   vendor/symfony/security-csrf/TokenStorage/NativeSessionTokenStorage.php
  me
  '      A   vendor/symfony/security-csrf/TokenStorage/SessionTokenStorage.php  me  "      L   vendor/symfony/security-csrf/TokenStorage/ClearableTokenStorageInterface.php  me  @M      C   vendor/symfony/security-csrf/TokenStorage/TokenStorageInterface.phpz  mez  W-m      $   vendor/symfony/security-csrf/LICENSE,  me,  U      )   vendor/symfony/security-csrf/CHANGELOG.md   me         *   vendor/symfony/security-csrf/CsrfToken.php  me  ϗ      &   vendor/symfony/security-csrf/README.md  me   Ъ      :   vendor/symfony/security-csrf/CsrfTokenManagerInterface.php  me  c      E   vendor/symfony/security-csrf/TokenGenerator/UriSafeTokenGenerator.php  me  bwx      G   vendor/symfony/security-csrf/TokenGenerator/TokenGeneratorInterface.php&  me&  Hvܤ      1   vendor/symfony/security-csrf/CsrfTokenManager.php  me        A   vendor/symfony/security-csrf/Exception/TokenNotFoundException.php  me   U      *   vendor/symfony/security-csrf/composer.jsonl  mel  Sˤ      D   vendor/symfony/security-guard/Token/PostAuthenticationGuardToken.php  me  9v      C   vendor/symfony/security-guard/Token/PreAuthenticationGuardToken.phpm  mem  Q      ;   vendor/symfony/security-guard/Token/GuardTokenInterface.php  me  nɚ      8   vendor/symfony/security-guard/AuthenticatorInterface.php  me  Nn      %   vendor/symfony/security-guard/LICENSE,  me,  U      <   vendor/symfony/security-guard/AbstractGuardAuthenticator.php  me  Ȍ      *   vendor/symfony/security-guard/CHANGELOG.md   me         F   vendor/symfony/security-guard/Provider/GuardAuthenticationProvider.phpK%  meK%  e      @   vendor/symfony/security-guard/PasswordAuthenticatedInterface.phpv  mev  Q:L      F   vendor/symfony/security-guard/Firewall/GuardAuthenticationListener.php]-  me]-  <      '   vendor/symfony/security-guard/README.md  me  @      ;   vendor/symfony/security-guard/GuardAuthenticatorHandler.php  me  $6      N   vendor/symfony/security-guard/Authenticator/AbstractFormLoginAuthenticator.php  me  d$      H   vendor/symfony/security-guard/Authenticator/GuardBridgeAuthenticator.php  me  -tM      +   vendor/symfony/security-guard/composer.json  me  z      7   vendor/symfony/polyfill-intl-normalizer/bootstrap80.php  me  ,      /   vendor/symfony/polyfill-intl-normalizer/LICENSE,  me,  H      6   vendor/symfony/polyfill-intl-normalizer/Normalizer.php8$  me8$  &(C      F   vendor/symfony/polyfill-intl-normalizer/Resources/stubs/Normalizer.php  me  %      L   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/combiningClass.php.  me.  Cb      T   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/canonicalDecomposition.phpx  mex        R   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/canonicalComposition.php=  me=  V{      X   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/compatibilityDecomposition.php  me  [
+      5   vendor/symfony/polyfill-intl-normalizer/bootstrap.php  me  #p      1   vendor/symfony/polyfill-intl-normalizer/README.md  me  +tK      5   vendor/symfony/polyfill-intl-normalizer/composer.jsonx  mex  ~O      F   vendor/symfony/event-dispatcher-contracts/EventDispatcherInterface.php  me  K}      3   vendor/symfony/event-dispatcher-contracts/Event.php  me  %ߤ      1   vendor/symfony/event-dispatcher-contracts/LICENSE)  me)  5古      6   vendor/symfony/event-dispatcher-contracts/CHANGELOG.md   me   h{#      3   vendor/symfony/event-dispatcher-contracts/README.md\  me\  ͗      7   vendor/symfony/event-dispatcher-contracts/composer.json  me  $>ɤ      8   vendor/symfony/property-access/PropertyPathInterface.phpa  mea  ,      7   vendor/symfony/property-access/PropertyPathIterator.php  me  d      &   vendor/symfony/property-access/LICENSE,  me,  U      @   vendor/symfony/property-access/PropertyPathIteratorInterface.php$  me$  F8      +   vendor/symfony/property-access/CHANGELOG.md  me  {r      <   vendor/symfony/property-access/PropertyAccessorInterface.php  me  `ml:      /   vendor/symfony/property-access/PropertyPath.php  me  Z      :   vendor/symfony/property-access/PropertyAccessorBuilder.php
  me
  _ͤ      (   vendor/symfony/property-access/README.md1  me1  !Q      3   vendor/symfony/property-access/PropertyAccessor.phpN~  meN~  e      1   vendor/symfony/property-access/PropertyAccess.php  me        6   vendor/symfony/property-access/PropertyPathBuilder.php#  me#  1>      <   vendor/symfony/property-access/Exception/AccessException.php  me  KW      K   vendor/symfony/property-access/Exception/UninitializedPropertyException.php  me  ,      ?   vendor/symfony/property-access/Exception/ExceptionInterface.php  me  l      A   vendor/symfony/property-access/Exception/OutOfBoundsException.php  me  ؤ      =   vendor/symfony/property-access/Exception/RuntimeException.php  me  Cn      E   vendor/symfony/property-access/Exception/InvalidArgumentException.php  me  IF[3      I   vendor/symfony/property-access/Exception/InvalidPropertyPathException.php  me  zޤ      D   vendor/symfony/property-access/Exception/UnexpectedTypeException.phps  mes  >r      A   vendor/symfony/property-access/Exception/NoSuchIndexException.php  me  NQp      D   vendor/symfony/property-access/Exception/NoSuchPropertyException.php  me  ?      ,   vendor/symfony/property-access/composer.json  me  S[      %   vendor/symfony/finder/SplFileInfo.php(  me(  a8      5   vendor/symfony/finder/Comparator/NumberComparator.php
  me
        /   vendor/symfony/finder/Comparator/Comparator.php  me  pe,      3   vendor/symfony/finder/Comparator/DateComparator.php  me            vendor/symfony/finder/Finder.phpX  meX  1pr         vendor/symfony/finder/LICENSE,  me,  U      "   vendor/symfony/finder/CHANGELOG.md  me  sn         vendor/symfony/finder/Glob.phpF  meF  )h         vendor/symfony/finder/README.md  me  C      /   vendor/symfony/finder/Iterator/LazyIterator.php  me  zz      ;   vendor/symfony/finder/Iterator/VcsIgnoredFilterIterator.php  me  K      <   vendor/symfony/finder/Iterator/FilecontentFilterIterator.php  me  (      =   vendor/symfony/finder/Iterator/MultiplePcreFilterIterator.php  me  %      :   vendor/symfony/finder/Iterator/SizeRangeFilterIterator.php  me        9   vendor/symfony/finder/Iterator/FilenameFilterIterator.php  me        :   vendor/symfony/finder/Iterator/DateRangeFilterIterator.php  me  Q      7   vendor/symfony/finder/Iterator/CustomFilterIterator.php/  me/  ~N<      =   vendor/symfony/finder/Iterator/RecursiveDirectoryIterator.php  me  9ޤ      A   vendor/symfony/finder/Iterator/ExcludeDirectoryFilterIterator.php
  me
  ܤ      3   vendor/symfony/finder/Iterator/SortableIterator.phpf  mef  򺩤      ;   vendor/symfony/finder/Iterator/DepthRangeFilterIterator.php  me  `(d      9   vendor/symfony/finder/Iterator/FileTypeFilterIterator.php}  me}  /u      5   vendor/symfony/finder/Iterator/PathFilterIterator.php  me  zΤ      #   vendor/symfony/finder/Gitignore.php!  me!  HWkJ      9   vendor/symfony/finder/Exception/AccessDeniedException.php  me        >   vendor/symfony/finder/Exception/DirectoryNotFoundException.php  me  )      #   vendor/symfony/finder/composer.jsonF  meF  i      >   vendor/symfony/http-kernel/DataCollector/DumpDataCollector.php&*  me&*        @   vendor/symfony/http-kernel/DataCollector/MemoryDataCollector.php	  me	  aϤ      G   vendor/symfony/http-kernel/DataCollector/LateDataCollectorInterface.php  me  |7r      @   vendor/symfony/http-kernel/DataCollector/RouterDataCollector.phpr	  mer	  6v      >   vendor/symfony/http-kernel/DataCollector/TimeDataCollector.php  me        C   vendor/symfony/http-kernel/DataCollector/DataCollectorInterface.php  me        A   vendor/symfony/http-kernel/DataCollector/RequestDataCollector.php;  me;  j      >   vendor/symfony/http-kernel/DataCollector/AjaxDataCollector.php^  me^  0      :   vendor/symfony/http-kernel/DataCollector/DataCollector.php
  me
  Rɓ      @   vendor/symfony/http-kernel/DataCollector/LoggerDataCollector.php)  me)  TFN      @   vendor/symfony/http-kernel/DataCollector/ConfigDataCollector.phpQ  meQ  F:ߤ      ?   vendor/symfony/http-kernel/DataCollector/EventDataCollector.php  me  E      C   vendor/symfony/http-kernel/DataCollector/ExceptionDataCollector.php  me  zP      5   vendor/symfony/http-kernel/Attribute/AsController.php  me  ݤ      :   vendor/symfony/http-kernel/Attribute/ArgumentInterface.php&  me&  ߓ
      "   vendor/symfony/http-kernel/LICENSE,  me,  U      R   vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactoryInterface.php  me  )#      B   vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadata.php  me  .T      I   vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactory.php
  me
  nz      '   vendor/symfony/http-kernel/CHANGELOG.mdeB  meeB  y      1   vendor/symfony/http-kernel/Config/FileLocator.php}  me}  S      /   vendor/symfony/http-kernel/HttpClientKernel.php  me  WuL      2   vendor/symfony/http-kernel/TerminableInterface.php  me  +      A   vendor/symfony/http-kernel/CacheClearer/CacheClearerInterface.php  me  炱      =   vendor/symfony/http-kernel/CacheClearer/ChainCacheClearer.php_  me_  (.      <   vendor/symfony/http-kernel/CacheClearer/Psr6CacheClearer.php  me        5   vendor/symfony/http-kernel/Resources/welcome.html.php}  me}  K@      )   vendor/symfony/http-kernel/HttpKernel.php)  me)  ;l      ?   vendor/symfony/http-kernel/CacheWarmer/CacheWarmerAggregate.phpB  meB  w5      6   vendor/symfony/http-kernel/CacheWarmer/CacheWarmer.php  me  t      <   vendor/symfony/http-kernel/CacheWarmer/WarmableInterface.phpr  mer        ?   vendor/symfony/http-kernel/CacheWarmer/CacheWarmerInterface.php  me  {w]b      ,   vendor/symfony/http-kernel/Bundle/Bundle.phpg  meg  ta֤      5   vendor/symfony/http-kernel/Bundle/BundleInterface.phpL  meL  'K      .   vendor/symfony/http-kernel/KernelInterface.php[  me[  ܵy      :   vendor/symfony/http-kernel/Controller/ArgumentResolver.php  me  #S      =   vendor/symfony/http-kernel/Controller/ControllerReference.php5  me5  Ul      9   vendor/symfony/http-kernel/Controller/ErrorController.php  me  aoͤ      E   vendor/symfony/http-kernel/Controller/ContainerControllerResolver.php
  me
  _c	n      P   vendor/symfony/http-kernel/Controller/ArgumentResolver/VariadicValueResolver.php  me  ܵ      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/ServiceValueResolver.phpS  meS  g%      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/DefaultValueResolver.php  me  {      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/RequestValueResolver.php  me        O   vendor/symfony/http-kernel/Controller/ArgumentResolver/SessionValueResolver.php  me  r7      X   vendor/symfony/http-kernel/Controller/ArgumentResolver/RequestAttributeValueResolver.php  me  :;)'      [   vendor/symfony/http-kernel/Controller/ArgumentResolver/NotTaggedControllerValueResolver.php2  me2        Q   vendor/symfony/http-kernel/Controller/ArgumentResolver/TraceableValueResolver.php  me  ۵      C   vendor/symfony/http-kernel/Controller/ArgumentResolverInterface.phpG  meG  ^M      E   vendor/symfony/http-kernel/Controller/ControllerResolverInterface.phph  meh  3      C   vendor/symfony/http-kernel/Controller/TraceableArgumentResolver.phpT  meT        <   vendor/symfony/http-kernel/Controller/ControllerResolver.php8  me8        E   vendor/symfony/http-kernel/Controller/TraceableControllerResolver.php8  me8  ܍4      H   vendor/symfony/http-kernel/Controller/ArgumentValueResolverInterface.php  me  ~      $   vendor/symfony/http-kernel/README.md  me         E   vendor/symfony/http-kernel/Fragment/FragmentUriGeneratorInterface.php;  me;  ?      >   vendor/symfony/http-kernel/Fragment/InlineFragmentRenderer.php7  me7   ޤ      ;   vendor/symfony/http-kernel/Fragment/SsiFragmentRenderer.phpA  meA  ,      I   vendor/symfony/http-kernel/Fragment/AbstractSurrogateFragmentRenderer.phpJ  meJ  `A      A   vendor/symfony/http-kernel/Fragment/FragmentRendererInterface.php  me  䴀      <   vendor/symfony/http-kernel/Fragment/FragmentUriGenerator.php%  me%  ~2\      ;   vendor/symfony/http-kernel/Fragment/EsiFragmentRenderer.phpA  meA  lY^$      @   vendor/symfony/http-kernel/Fragment/HIncludeFragmentRenderer.php*
  me*
  ז{      7   vendor/symfony/http-kernel/Fragment/FragmentHandler.php  me  f٤      @   vendor/symfony/http-kernel/Fragment/RoutableFragmentRenderer.php  me  ݤ      +   vendor/symfony/http-kernel/KernelEvents.phpd  med  Z$      ,   vendor/symfony/http-kernel/HttpCache/Esi.php6
  me6
  ד'      2   vendor/symfony/http-kernel/HttpCache/HttpCache.phpd  med  }tQC      .   vendor/symfony/http-kernel/HttpCache/Store.php9  me9  J݉Ԥ      ;   vendor/symfony/http-kernel/HttpCache/SurrogateInterface.php  me        G   vendor/symfony/http-kernel/HttpCache/ResponseCacheStrategyInterface.php  me  H      >   vendor/symfony/http-kernel/HttpCache/ResponseCacheStrategy.php(#  me(#   |      7   vendor/symfony/http-kernel/HttpCache/StoreInterface.php  me  ȴ      ,   vendor/symfony/http-kernel/HttpCache/Ssi.php
  me
  H      :   vendor/symfony/http-kernel/HttpCache/AbstractSurrogate.php  me  [      :   vendor/symfony/http-kernel/HttpCache/SubRequestHandler.php1  me1  イ      2   vendor/symfony/http-kernel/HttpKernelInterface.php  me  ~8      )   vendor/symfony/http-kernel/Log/Logger.php(  me(  K_/      7   vendor/symfony/http-kernel/Log/DebugLoggerInterface.php  me  q<      ;   vendor/symfony/http-kernel/Profiler/FileProfilerStorage.phpR"  meR"        /   vendor/symfony/http-kernel/Profiler/Profile.php  me  >P6      0   vendor/symfony/http-kernel/Profiler/Profiler.php4  me4  Te      @   vendor/symfony/http-kernel/Profiler/ProfilerStorageInterface.php  me  5g      G   vendor/symfony/http-kernel/DependencyInjection/FragmentRendererPass.php=
  me=
  #      C   vendor/symfony/http-kernel/DependencyInjection/ServicesResetter.phph  meh  Q      R   vendor/symfony/http-kernel/DependencyInjection/RegisterLocaleAwareServicesPass.php`  me`  e`      H   vendor/symfony/http-kernel/DependencyInjection/ResettableServicePass.php	  me	  Q:      R   vendor/symfony/http-kernel/DependencyInjection/MergeExtensionConfigurationPass.php  me  )      Q   vendor/symfony/http-kernel/DependencyInjection/AddAnnotatedClassesToCachePass.phpI  meI  ڤ      H   vendor/symfony/http-kernel/DependencyInjection/ConfigurableExtension.php  me  ;t      =   vendor/symfony/http-kernel/DependencyInjection/LoggerPass.php0  me0  s-      <   vendor/symfony/http-kernel/DependencyInjection/Extension.phpR  meR  P@      V   vendor/symfony/http-kernel/DependencyInjection/ControllerArgumentValueResolverPass.php
  me
  `P      Y   vendor/symfony/http-kernel/DependencyInjection/RegisterControllerArgumentLocatorsPass.php'-  me'-        \   vendor/symfony/http-kernel/DependencyInjection/RemoveEmptyControllerArgumentLocatorsPass.php  me  >      M   vendor/symfony/http-kernel/DependencyInjection/LazyLoadingFragmentHandler.php  me  P      E   vendor/symfony/http-kernel/Exception/TooManyRequestsHttpException.php  me  @b[Ť      >   vendor/symfony/http-kernel/Exception/ConflictHttpException.php#  me#  6uG      6   vendor/symfony/http-kernel/Exception/HttpException.php(  me(  $      B   vendor/symfony/http-kernel/Exception/UnauthorizedHttpException.php  me  O0F      A   vendor/symfony/http-kernel/Exception/InvalidMetadataException.phpj  mej  ;녤      D   vendor/symfony/http-kernel/Exception/LengthRequiredHttpException.php)  me)  	      I   vendor/symfony/http-kernel/Exception/UnprocessableEntityHttpException.php7  me7  
      H   vendor/symfony/http-kernel/Exception/PreconditionFailedHttpException.php-  me-  pjϤ      :   vendor/symfony/http-kernel/Exception/GoneHttpException.php  me  h      J   vendor/symfony/http-kernel/Exception/UnsupportedMediaTypeHttpException.php/  me/  x稤      H   vendor/symfony/http-kernel/Exception/UnexpectedSessionUsageException.php  me  Zis      H   vendor/symfony/http-kernel/Exception/ServiceUnavailableHttpException.php  me  
      ?   vendor/symfony/http-kernel/Exception/HttpExceptionInterface.php  me  <ͯ      B   vendor/symfony/http-kernel/Exception/AccessDeniedHttpException.php\  me\  ~&դ      @   vendor/symfony/http-kernel/Exception/BadRequestHttpException.php%  me%  4]      Q   vendor/symfony/http-kernel/Exception/ControllerDoesNotReturnResponseException.phpE  meE  :      C   vendor/symfony/http-kernel/Exception/NotAcceptableHttpException.php(  me(  /      J   vendor/symfony/http-kernel/Exception/PreconditionRequiredHttpException.php]  me]  !F3      >   vendor/symfony/http-kernel/Exception/NotFoundHttpException.php*  me*        F   vendor/symfony/http-kernel/Exception/MethodNotAllowedHttpException.php  me  Z(^      4   vendor/symfony/http-kernel/Event/ControllerEvent.php  me        3   vendor/symfony/http-kernel/Event/ExceptionEvent.php  me  -ү      7   vendor/symfony/http-kernel/Event/FinishRequestEvent.php  me  TY      2   vendor/symfony/http-kernel/Event/ResponseEvent.php  me  ~      3   vendor/symfony/http-kernel/Event/TerminateEvent.php}  me}  i+      =   vendor/symfony/http-kernel/Event/ControllerArgumentsEvent.phpV  meV  +Ƥ      0   vendor/symfony/http-kernel/Event/KernelEvent.phpS	  meS	  m      1   vendor/symfony/http-kernel/Event/RequestEvent.php  me  gS      .   vendor/symfony/http-kernel/Event/ViewEvent.php:  me:  W<      (   vendor/symfony/http-kernel/composer.json
  me
  }_      2   vendor/symfony/http-kernel/RebootableInterface.php!  me!  1Ƥ      %   vendor/symfony/http-kernel/Kernel.phps  mes  Z      (   vendor/symfony/http-kernel/UriSigner.php  me  Mu      =   vendor/symfony/http-kernel/Debug/TraceableEventDispatcher.php
  me
  ;֌      6   vendor/symfony/http-kernel/Debug/FileLinkFormatter.php
  me
  IH      0   vendor/symfony/http-kernel/HttpKernelBrowser.php  me  M֤      E   vendor/symfony/http-kernel/EventListener/StreamedResponseListener.php  me  y      =   vendor/symfony/http-kernel/EventListener/ResponseListener.phps  mes  b      ;   vendor/symfony/http-kernel/EventListener/LocaleListener.php  me  '      =   vendor/symfony/http-kernel/EventListener/FragmentListener.php  me  T      D   vendor/symfony/http-kernel/EventListener/AbstractSessionListener.php3  me3  鑍0      @   vendor/symfony/http-kernel/EventListener/TestSessionListener.php  me  Hb      D   vendor/symfony/http-kernel/EventListener/ValidateRequestListener.php  me  A      K   vendor/symfony/http-kernel/EventListener/DisallowRobotsIndexingListener.php  me  "v      F   vendor/symfony/http-kernel/EventListener/AddRequestFormatsListener.php  me  	
ܤ      =   vendor/symfony/http-kernel/EventListener/ProfilerListener.php  me   u      >   vendor/symfony/http-kernel/EventListener/SurrogateListener.php:  me:  *      B   vendor/symfony/http-kernel/EventListener/DebugHandlersListener.php
  me
  &g      H   vendor/symfony/http-kernel/EventListener/AbstractTestSessionListener.php  me  Ng      @   vendor/symfony/http-kernel/EventListener/LocaleAwareListener.php	  me	  s      9   vendor/symfony/http-kernel/EventListener/DumpListener.php@  me@        :   vendor/symfony/http-kernel/EventListener/ErrorListener.php$  me$  ^}      <   vendor/symfony/http-kernel/EventListener/SessionListener.php8  me8  s      ;   vendor/symfony/http-kernel/EventListener/RouterListener.php\  me\  t         vendor/symfony/yaml/LICENSE,  me,  U         vendor/symfony/yaml/Parser.php  me  ^4          vendor/symfony/yaml/CHANGELOG.md6  me6  W         vendor/symfony/yaml/Escaper.php  me  
      +   vendor/symfony/yaml/Resources/bin/yaml-lint  me  3VԈ         vendor/symfony/yaml/README.md  me  ـT      !   vendor/symfony/yaml/Unescaper.php  me  <L         vendor/symfony/yaml/Dumper.php  me  V         vendor/symfony/yaml/Inline.php'  me'  ̤         vendor/symfony/yaml/Yaml.php  me  xw      +   vendor/symfony/yaml/Command/LintCommand.php=(  me=(  ُ      /   vendor/symfony/yaml/Exception/DumpException.php  me  ?<̤      4   vendor/symfony/yaml/Exception/ExceptionInterface.php  me  ,P      2   vendor/symfony/yaml/Exception/RuntimeException.php  me  #OU      0   vendor/symfony/yaml/Exception/ParseException.phpq  meq  8      '   vendor/symfony/yaml/Tag/TaggedValue.php  me  .|      !   vendor/symfony/yaml/composer.json=  me=  K'      )   vendor/symfony/string/CodePointString.php  me  }Ѥ         vendor/symfony/string/LICENSE,  me,  զ_Ϥ      "   vendor/symfony/string/CHANGELOG.mdD  meD        (   vendor/symfony/string/AbstractString.phpO  meO  ,}'      -   vendor/symfony/string/Resources/functions.phpl  mel        <   vendor/symfony/string/Resources/data/wcswidth_table_zero.php  me  °jj      <   vendor/symfony/string/Resources/data/wcswidth_table_wide.php  me  }NM      3   vendor/symfony/string/Inflector/FrenchInflector.php  me  .7      6   vendor/symfony/string/Inflector/InflectorInterface.phpR  meR  _      4   vendor/symfony/string/Inflector/EnglishInflector.php0@  me0@  7          vendor/symfony/string/README.md+  me+  L      /   vendor/symfony/string/AbstractUnicodeString.phpKi  meKi  7<      $   vendor/symfony/string/LazyString.phpt  met  Τ      $   vendor/symfony/string/ByteString.php<  me<  u֤      '   vendor/symfony/string/UnicodeString.php2  me2  cŤ      6   vendor/symfony/string/Exception/ExceptionInterface.php_  me_  :      4   vendor/symfony/string/Exception/RuntimeException.php~  me~  )Ʉ      <   vendor/symfony/string/Exception/InvalidArgumentException.php  me  B;8      #   vendor/symfony/string/composer.json  me  ~&      2   vendor/symfony/string/Slugger/SluggerInterface.php  me        .   vendor/symfony/string/Slugger/AsciiSlugger.php#  me#  6%      4   vendor/symfony/security-core/Role/SwitchUserRole.php  me  'v      <   vendor/symfony/security-core/Role/RoleHierarchyInterface.php]  me]  Բ'      *   vendor/symfony/security-core/Role/Role.php  me  i֜      3   vendor/symfony/security-core/Role/RoleHierarchy.php  me  xw      C   vendor/symfony/security-core/Validator/Constraints/UserPassword.php  me  Y      L   vendor/symfony/security-core/Validator/Constraints/UserPasswordValidator.phpP  meP  *㏤      $   vendor/symfony/security-core/LICENSE,  me,  U      D   vendor/symfony/security-core/Test/AccessDecisionStrategyTestCase.php	  me	        B   vendor/symfony/security-core/Signature/ExpiredSignatureStorage.php  me        N   vendor/symfony/security-core/Signature/Exception/InvalidSignatureException.php  me  [.ܤ      N   vendor/symfony/security-core/Signature/Exception/ExpiredSignatureException.php  me  (:      :   vendor/symfony/security-core/Signature/SignatureHasher.php  me  i      )   vendor/symfony/security-core/CHANGELOG.md  me  sڱ      ;   vendor/symfony/security-core/Encoder/LegacyEncoderTrait.php  me  O%      @   vendor/symfony/security-core/Encoder/EncoderFactoryInterface.php  me  Յ      <   vendor/symfony/security-core/Encoder/BasePasswordEncoder.php
  me
  ;-      >   vendor/symfony/security-core/Encoder/Pbkdf2PasswordEncoder.php-  me-  m9Ԥ      7   vendor/symfony/security-core/Encoder/EncoderFactory.phpK!  meK!  -      A   vendor/symfony/security-core/Encoder/PlaintextPasswordEncoder.php  me  ]䟤      A   vendor/symfony/security-core/Encoder/PasswordEncoderInterface.php  me  oM      >   vendor/symfony/security-core/Encoder/PasswordHasherAdapter.php*  me*  I      >   vendor/symfony/security-core/Encoder/SodiumPasswordEncoder.php  me  +	      A   vendor/symfony/security-core/Encoder/MigratingPasswordEncoder.php  me  l      E   vendor/symfony/security-core/Encoder/MessageDigestPasswordEncoder.php  me  K      D   vendor/symfony/security-core/Encoder/SelfSaltingEncoderInterface.php  me  s      D   vendor/symfony/security-core/Encoder/LegacyPasswordHasherEncoder.php%  me%  Ah      <   vendor/symfony/security-core/Encoder/UserPasswordEncoder.php2  me2  
Xh4      >   vendor/symfony/security-core/Encoder/PasswordHasherEncoder.phpF  meF  ڈդ      >   vendor/symfony/security-core/Encoder/NativePasswordEncoder.php  me        >   vendor/symfony/security-core/Encoder/EncoderAwareInterface.phpC  meC  w      E   vendor/symfony/security-core/Encoder/UserPasswordEncoderInterface.php6  me6  '      C   vendor/symfony/security-core/Resources/translations/security.sq.xlf"  me"  |99      C   vendor/symfony/security-core/Resources/translations/security.ru.xlfw  mew  {T       C   vendor/symfony/security-core/Resources/translations/security.hy.xlf  me  \Ul      C   vendor/symfony/security-core/Resources/translations/security.fr.xlf9  me9  =Ĥ      C   vendor/symfony/security-core/Resources/translations/security.fa.xlfd  med  7      C   vendor/symfony/security-core/Resources/translations/security.pl.xlf  me  Mo      C   vendor/symfony/security-core/Resources/translations/security.sv.xlf  me  cuy      C   vendor/symfony/security-core/Resources/translations/security.el.xlf  me  n(      H   vendor/symfony/security-core/Resources/translations/security.sr_Cyrl.xlf'  me'  $M      C   vendor/symfony/security-core/Resources/translations/security.en.xlfa  mea  _<      C   vendor/symfony/security-core/Resources/translations/security.ja.xlf  me  s      F   vendor/symfony/security-core/Resources/translations/security.pt_BR.xlf  me  ;=      C   vendor/symfony/security-core/Resources/translations/security.no.xlf  me  \      C   vendor/symfony/security-core/Resources/translations/security.vi.xlf  me  ?%      C   vendor/symfony/security-core/Resources/translations/security.ur.xlfl  mel  qs      C   vendor/symfony/security-core/Resources/translations/security.nn.xlf  me  8I      C   vendor/symfony/security-core/Resources/translations/security.nl.xlf  me  atX      C   vendor/symfony/security-core/Resources/translations/security.cy.xlf  me  RT      C   vendor/symfony/security-core/Resources/translations/security.af.xlf  me  !h      C   vendor/symfony/security-core/Resources/translations/security.lv.xlf-  me-  Ee      C   vendor/symfony/security-core/Resources/translations/security.ar.xlf  me  yR      C   vendor/symfony/security-core/Resources/translations/security.lb.xlf  me  |      C   vendor/symfony/security-core/Resources/translations/security.tr.xlf  me  ʮ      C   vendor/symfony/security-core/Resources/translations/security.lt.xlf  me  r      F   vendor/symfony/security-core/Resources/translations/security.zh_CN.xlf  me  X      C   vendor/symfony/security-core/Resources/translations/security.ca.xlf  me  jm      C   vendor/symfony/security-core/Resources/translations/security.be.xlfk  mek  J      C   vendor/symfony/security-core/Resources/translations/security.th.xlf  me  jŤ      C   vendor/symfony/security-core/Resources/translations/security.uz.xlf  me  :4Ť      C   vendor/symfony/security-core/Resources/translations/security.mk.xlf  me  g      C   vendor/symfony/security-core/Resources/translations/security.bs.xlf"  me"  _      C   vendor/symfony/security-core/Resources/translations/security.bg.xlf/  me/  uۤ      H   vendor/symfony/security-core/Resources/translations/security.sr_Latn.xlf  me  3G      C   vendor/symfony/security-core/Resources/translations/security.uk.xlf9  me9  WD;      F   vendor/symfony/security-core/Resources/translations/security.zh_TW.xlf  me  F:o      C   vendor/symfony/security-core/Resources/translations/security.cs.xlf  me  }      C   vendor/symfony/security-core/Resources/translations/security.tl.xlf&  me&  c       C   vendor/symfony/security-core/Resources/translations/security.my.xlf,  me,  OO      C   vendor/symfony/security-core/Resources/translations/security.nb.xlf  me  \      C   vendor/symfony/security-core/Resources/translations/security.mn.xlfG  meG  jy      C   vendor/symfony/security-core/Resources/translations/security.az.xlf  me  3      C   vendor/symfony/security-core/Resources/translations/security.eu.xlf  me  	      C   vendor/symfony/security-core/Resources/translations/security.he.xlf
  me
  ?      C   vendor/symfony/security-core/Resources/translations/security.hr.xlf  me  #      C   vendor/symfony/security-core/Resources/translations/security.pt.xlf  me  ?      C   vendor/symfony/security-core/Resources/translations/security.et.xlf  me  ]MU      C   vendor/symfony/security-core/Resources/translations/security.de.xlf/  me/  @      C   vendor/symfony/security-core/Resources/translations/security.sl.xlf  me  Qj      C   vendor/symfony/security-core/Resources/translations/security.it.xlf  me  A      C   vendor/symfony/security-core/Resources/translations/security.gl.xlf  me  eȤ      C   vendor/symfony/security-core/Resources/translations/security.es.xlf  me  -      C   vendor/symfony/security-core/Resources/translations/security.hu.xlf  me  q      C   vendor/symfony/security-core/Resources/translations/security.da.xlfz  mez  ,Ť      C   vendor/symfony/security-core/Resources/translations/security.fi.xlf  me  H|?      C   vendor/symfony/security-core/Resources/translations/security.id.xlf  me  YK{Ӥ      C   vendor/symfony/security-core/Resources/translations/security.sk.xlf  me  k      C   vendor/symfony/security-core/Resources/translations/security.ro.xlf  me  Y      9   vendor/symfony/security-core/User/InMemoryUserChecker.php  me  X$      3   vendor/symfony/security-core/User/UserInterface.php
  me
  f^      ;   vendor/symfony/security-core/User/UserProviderInterface.php	  me	  %TX      *   vendor/symfony/security-core/User/User.php  me  b      9   vendor/symfony/security-core/User/MissingUserProvider.php  me  ɺ      N   vendor/symfony/security-core/User/LegacyPasswordAuthenticatedUserInterface.php1  me1  ,      ?   vendor/symfony/security-core/User/PasswordUpgraderInterface.php  me        2   vendor/symfony/security-core/User/InMemoryUser.php  me  ܿ{      :   vendor/symfony/security-core/User/InMemoryUserProvider.php}  me}  $      8   vendor/symfony/security-core/User/EquatableInterface.php  me  -\      H   vendor/symfony/security-core/User/PasswordAuthenticatedUserInterface.php  me  hΤ      :   vendor/symfony/security-core/User/UserCheckerInterface.php,  me,  	      1   vendor/symfony/security-core/User/UserChecker.php  me  c'      7   vendor/symfony/security-core/User/ChainUserProvider.php  me  e{      &   vendor/symfony/security-core/README.md  me  EK      L   vendor/symfony/security-core/Authorization/AuthorizationCheckerInterface.phpW  meW  "      I   vendor/symfony/security-core/Authorization/ExpressionLanguageProvider.php  me  `u      M   vendor/symfony/security-core/Authorization/TraceableAccessDecisionManager.php  me  {0      D   vendor/symfony/security-core/Authorization/AccessDecisionManager.php`  me`  C      M   vendor/symfony/security-core/Authorization/AccessDecisionManagerInterface.php  me  ҟ      C   vendor/symfony/security-core/Authorization/Voter/VoterInterface.php  me  >      L   vendor/symfony/security-core/Authorization/Voter/CacheableVoterInterface.php~  me~  9      D   vendor/symfony/security-core/Authorization/Voter/ExpressionVoter.php
  me
  &      G   vendor/symfony/security-core/Authorization/Voter/RoleHierarchyVoter.phpU  meU  `F      C   vendor/symfony/security-core/Authorization/Voter/TraceableVoter.php  me  ^      :   vendor/symfony/security-core/Authorization/Voter/Voter.php

  me

        >   vendor/symfony/security-core/Authorization/Voter/RoleVoter.php  me        G   vendor/symfony/security-core/Authorization/Voter/AuthenticatedVoter.phpZ  meZ  P㳤      A   vendor/symfony/security-core/Authorization/ExpressionLanguage.php  me        C   vendor/symfony/security-core/Authorization/AuthorizationChecker.php  me  t      H   vendor/symfony/security-core/Authorization/Strategy/PriorityStrategy.php/  me/  cR      I   vendor/symfony/security-core/Authorization/Strategy/UnanimousStrategy.phpO  meO  ȅ1٤      K   vendor/symfony/security-core/Authorization/Strategy/AffirmativeStrategy.phpV  meV        I   vendor/symfony/security-core/Authorization/Strategy/ConsensusStrategy.php  me        W   vendor/symfony/security-core/Authorization/Strategy/AccessDecisionStrategyInterface.php]  me]  pf      )   vendor/symfony/security-core/Security.php  me  h}      @   vendor/symfony/security-core/Exception/AccessDeniedException.php  me  a      D   vendor/symfony/security-core/Exception/InvalidCsrfTokenException.php  me        :   vendor/symfony/security-core/Exception/LogoutException.php  me  y'פ      9   vendor/symfony/security-core/Exception/LogicException.php  me  $2      @   vendor/symfony/security-core/Exception/LazyResponseException.php  me  _K      S   vendor/symfony/security-core/Exception/CustomUserMessageAuthenticationException.php  me  2+V      =   vendor/symfony/security-core/Exception/ExceptionInterface.php  me  ^      B   vendor/symfony/security-core/Exception/BadCredentialsException.php  me  nh      ;   vendor/symfony/security-core/Exception/RuntimeException.php  me  >
      <   vendor/symfony/security-core/Exception/DisabledException.php  me  [Ω      A   vendor/symfony/security-core/Exception/TokenNotFoundException.php  me  |jˤ      D   vendor/symfony/security-core/Exception/ProviderNotFoundException.php  me  =x      F   vendor/symfony/security-core/Exception/SessionUnavailableException.php  me  aE      C   vendor/symfony/security-core/Exception/InvalidArgumentException.php  me  W.      B   vendor/symfony/security-core/Exception/AccountExpiredException.php  me  MҤ      I   vendor/symfony/security-core/Exception/AuthenticationExpiredException.phpc  mec  #m      D   vendor/symfony/security-core/Exception/UsernameNotFoundException.php  me  ӯn      V   vendor/symfony/security-core/Exception/TooManyLoginAttemptsAuthenticationException.php  me  xܤ      ?   vendor/symfony/security-core/Exception/CookieTheftException.php  me  k      I   vendor/symfony/security-core/Exception/AuthenticationServiceException.php  me  4!      C   vendor/symfony/security-core/Exception/UnsupportedUserException.phpJ  meJ  jۤ      A   vendor/symfony/security-core/Exception/AccountStatusException.phpB  meB  G      R   vendor/symfony/security-core/Exception/CustomUserMessageAccountStatusException.php  me  Z^      N   vendor/symfony/security-core/Exception/InsufficientAuthenticationException.phpB  meB  -      :   vendor/symfony/security-core/Exception/LockedException.php  me  8      B   vendor/symfony/security-core/Exception/AuthenticationException.php  me  yP      @   vendor/symfony/security-core/Exception/UserNotFoundException.phpv	  mev	        U   vendor/symfony/security-core/Exception/AuthenticationCredentialsNotFoundException.php  me  l.      F   vendor/symfony/security-core/Exception/CredentialsExpiredException.php  me  EXΤ      C   vendor/symfony/security-core/Authentication/Token/AbstractToken.php9'  me9'  ي      ?   vendor/symfony/security-core/Authentication/Token/NullToken.php
  me
  Sˤ      D   vendor/symfony/security-core/Authentication/Token/AnonymousToken.php  me  k{      W   vendor/symfony/security-core/Authentication/Token/Storage/UsageTrackingTokenStorage.php  me        J   vendor/symfony/security-core/Authentication/Token/Storage/TokenStorage.phpv  mev  d=      S   vendor/symfony/security-core/Authentication/Token/Storage/TokenStorageInterface.php  me  kcZޤ      E   vendor/symfony/security-core/Authentication/Token/RememberMeToken.php  me  [      E   vendor/symfony/security-core/Authentication/Token/SwitchUserToken.phpi  mei  8      K   vendor/symfony/security-core/Authentication/Token/PreAuthenticatedToken.php  me  ڎ~      D   vendor/symfony/security-core/Authentication/Token/TokenInterface.phpz  mez  ʒ      K   vendor/symfony/security-core/Authentication/Token/UsernamePasswordToken.php
  me
  q      T   vendor/symfony/security-core/Authentication/AuthenticationTrustResolverInterface.phpw  mew  6      K   vendor/symfony/security-core/Authentication/AuthenticationTrustResolver.php  me  C      S   vendor/symfony/security-core/Authentication/Provider/UserAuthenticationProvider.phpF  meF  jʞ      R   vendor/symfony/security-core/Authentication/Provider/DaoAuthenticationProvider.php  me  R{      W   vendor/symfony/security-core/Authentication/Provider/LdapBindAuthenticationProvider.php  me  I	      X   vendor/symfony/security-core/Authentication/Provider/AuthenticationProviderInterface.phpY  meY  'Xs      _   vendor/symfony/security-core/Authentication/Provider/PreAuthenticatedAuthenticationProvider.php
  me
  %J      Y   vendor/symfony/security-core/Authentication/Provider/RememberMeAuthenticationProvider.php!  me!  M      X   vendor/symfony/security-core/Authentication/Provider/AnonymousAuthenticationProvider.php  me  `      M   vendor/symfony/security-core/Authentication/AuthenticationProviderManager.php  me  Ա      S   vendor/symfony/security-core/Authentication/RememberMe/PersistentTokenInterface.php
  me
  Ӥ      P   vendor/symfony/security-core/Authentication/RememberMe/InMemoryTokenProvider.php  me        M   vendor/symfony/security-core/Authentication/RememberMe/CacheTokenVerifier.php	  me	  Jp      J   vendor/symfony/security-core/Authentication/RememberMe/PersistentToken.php  me  0@f      Q   vendor/symfony/security-core/Authentication/RememberMe/TokenVerifierInterface.php  me  ä      Q   vendor/symfony/security-core/Authentication/RememberMe/TokenProviderInterface.php  me  GU=      N   vendor/symfony/security-core/Authentication/AuthenticationManagerInterface.php  me  {<      A   vendor/symfony/security-core/Event/AuthenticationSuccessEvent.phpu  meu        :   vendor/symfony/security-core/Event/AuthenticationEvent.phpX  meX  +Y      A   vendor/symfony/security-core/Event/AuthenticationFailureEvent.phps  mes  KGM      0   vendor/symfony/security-core/Event/VoteEvent.php   me   (͐      *   vendor/symfony/security-core/composer.jsonu  meu  9      5   vendor/symfony/security-core/AuthenticationEvents.php  me  E      ,   vendor/symfony/deprecation-contracts/LICENSE)  me)  2      1   vendor/symfony/deprecation-contracts/CHANGELOG.md   me   h{#      1   vendor/symfony/deprecation-contracts/function.php  me  rg      .   vendor/symfony/deprecation-contracts/README.md  me  3      2   vendor/symfony/deprecation-contracts/composer.jsonS  meS  IN>      (   vendor/symfony/routing/CompiledRoute.php}  me}  _         vendor/symfony/routing/LICENSE,  me,  U      (   vendor/symfony/routing/RouteCompiler.phpB9  meB9  c      #   vendor/symfony/routing/CHANGELOG.md/  me/  	      )   vendor/symfony/routing/RequestContext.php  me  tK      +   vendor/symfony/routing/Annotation/Route.phpy  mey  #L      :   vendor/symfony/routing/Matcher/RequestMatcherInterface.php?  me?  С      =   vendor/symfony/routing/Matcher/ExpressionLanguageProvider.php  me        -   vendor/symfony/routing/Matcher/UrlMatcher.phpW$  meW$  Y      B   vendor/symfony/routing/Matcher/RedirectableUrlMatcherInterface.php  me  ۤ      6   vendor/symfony/routing/Matcher/UrlMatcherInterface.php  me        5   vendor/symfony/routing/Matcher/CompiledUrlMatcher.php  me  *g      6   vendor/symfony/routing/Matcher/TraceableUrlMatcher.php  me  6      B   vendor/symfony/routing/Matcher/Dumper/CompiledUrlMatcherDumper.php1J  me1J  mK.      7   vendor/symfony/routing/Matcher/Dumper/MatcherDumper.php!  me!  !Ҵ      @   vendor/symfony/routing/Matcher/Dumper/MatcherDumperInterface.php  me  SQ      A   vendor/symfony/routing/Matcher/Dumper/CompiledUrlMatcherTrait.php;  me;  6H      @   vendor/symfony/routing/Matcher/Dumper/StaticPrefixCollection.php  me  7      9   vendor/symfony/routing/Matcher/RedirectableUrlMatcher.phpa  mea  |:          vendor/symfony/routing/README.md  me  .      9   vendor/symfony/routing/Generator/CompiledUrlGenerator.php
  me
  PgZ      1   vendor/symfony/routing/Generator/UrlGenerator.phpZ=  meZ=  5      F   vendor/symfony/routing/Generator/ConfigurableRequirementsInterface.php  me  )      :   vendor/symfony/routing/Generator/UrlGeneratorInterface.php
  me
  #Ѵ%      D   vendor/symfony/routing/Generator/Dumper/GeneratorDumperInterface.php  me  )_      F   vendor/symfony/routing/Generator/Dumper/CompiledUrlGeneratorDumper.php  me  9ݥ      ;   vendor/symfony/routing/Generator/Dumper/GeneratorDumper.php'  me'  V6      *   vendor/symfony/routing/RouteCollection.php,  me,  n      7   vendor/symfony/routing/RequestContextAwareInterface.php/  me/  h3      7   vendor/symfony/routing/Loader/AnnotationClassLoader.phpO4  meO4  &ϮR      0   vendor/symfony/routing/Loader/YamlFileLoader.php0  me0  {!      6   vendor/symfony/routing/Loader/AnnotationFileLoader.php
  me
  #      <   vendor/symfony/routing/Loader/schema/routing/routing-1.0.xsd6  me6  Vܤ      /   vendor/symfony/routing/Loader/PhpFileLoader.phpJ	  meJ	  |%      /   vendor/symfony/routing/Loader/XmlFileLoader.phpqE  meqE  }[
      .   vendor/symfony/routing/Loader/ObjectLoader.php  me  _ʲҤ      ?   vendor/symfony/routing/Loader/Configurator/Traits/HostTrait.php  me  Es2      A   vendor/symfony/routing/Loader/Configurator/Traits/PrefixTrait.php	
  me	
  $      I   vendor/symfony/routing/Loader/Configurator/Traits/LocalizedRouteTrait.php&
  me&
  p eݤ      @   vendor/symfony/routing/Loader/Configurator/Traits/RouteTrait.php  me  =/'
      >   vendor/symfony/routing/Loader/Configurator/Traits/AddTrait.php9  me9        @   vendor/symfony/routing/Loader/Configurator/RouteConfigurator.php  me  /7      E   vendor/symfony/routing/Loader/Configurator/CollectionConfigurator.php  me  vŤ      @   vendor/symfony/routing/Loader/Configurator/AliasConfigurator.php  me  }      B   vendor/symfony/routing/Loader/Configurator/RoutingConfigurator.php  me  蝤      A   vendor/symfony/routing/Loader/Configurator/ImportConfigurator.php  me  Ww      1   vendor/symfony/routing/Loader/ContainerLoader.php  me  {)      1   vendor/symfony/routing/Loader/DirectoryLoader.php&  me&  \      0   vendor/symfony/routing/Loader/GlobFileLoader.phpK  meK  x      /   vendor/symfony/routing/Loader/ClosureLoader.phpR  meR  f:+      ;   vendor/symfony/routing/Loader/AnnotationDirectoryLoader.php
  me
  JT          vendor/symfony/routing/Route.php<0  me<0  ֩      1   vendor/symfony/routing/RouteCollectionBuilder.php%  me%  YM      *   vendor/symfony/routing/RouterInterface.php"  me"  WF      !   vendor/symfony/routing/Router.php0  me0  x      1   vendor/symfony/routing/RouteCompilerInterface.php   me             vendor/symfony/routing/Alias.php	  me	        B   vendor/symfony/routing/DependencyInjection/RoutingResolverPass.php  me  g<      >   vendor/symfony/routing/Exception/ResourceNotFoundException.php2  me2  FL"1      7   vendor/symfony/routing/Exception/ExceptionInterface.php  me  &      ;   vendor/symfony/routing/Exception/RouteNotFoundException.php  me  	C      5   vendor/symfony/routing/Exception/RuntimeException.php  me  $>G      H   vendor/symfony/routing/Exception/MissingMandatoryParametersException.php@  me@  Tv      =   vendor/symfony/routing/Exception/InvalidArgumentException.php  me  ֤      >   vendor/symfony/routing/Exception/MethodNotAllowedException.phpJ  meJ  u#      =   vendor/symfony/routing/Exception/NoConfigurationException.php  me  r      D   vendor/symfony/routing/Exception/RouteCircularReferenceException.php>  me>  \T      >   vendor/symfony/routing/Exception/InvalidParameterException.php  me  !N      $   vendor/symfony/routing/composer.json  me        ?   vendor/symfony/service-contracts/ServiceSubscriberInterface.php  me  L      @   vendor/symfony/service-contracts/Attribute/SubscribedService.php2  me2  UȤ      7   vendor/symfony/service-contracts/Attribute/Required.php  me  `e      (   vendor/symfony/service-contracts/LICENSE)  me)  5古      <   vendor/symfony/service-contracts/Test/ServiceLocatorTest.php  me  b'L      -   vendor/symfony/service-contracts/CHANGELOG.md   me   h{#      *   vendor/symfony/service-contracts/README.mdL  meL  Ȥ      3   vendor/symfony/service-contracts/ResetInterface.php  me  {Ф      =   vendor/symfony/service-contracts/ServiceProviderInterface.php  me  yl      ;   vendor/symfony/service-contracts/ServiceSubscriberTrait.php  me        8   vendor/symfony/service-contracts/ServiceLocatorTrait.php  me  0"i      .   vendor/symfony/service-contracts/composer.json  me  x#S      9   vendor/symfony/property-info/PhpStan/NameScopeFactory.php  me  w      2   vendor/symfony/property-info/PhpStan/NameScope.php  me  ~w      ?   vendor/symfony/property-info/PropertyInfoExtractorInterface.php  me  U-R      %   vendor/symfony/property-info/Type.php!  me!  B      $   vendor/symfony/property-info/LICENSE,  me,  H      6   vendor/symfony/property-info/Util/PhpDocTypeHelper.php(  me(  7ׅo      7   vendor/symfony/property-info/Util/PhpStanTypeHelper.php^  me^  Zⶳ      )   vendor/symfony/property-info/CHANGELOG.md  me  :      ;   vendor/symfony/property-info/PropertyInfoCacheExtractor.php
  me
  Kai      D   vendor/symfony/property-info/PropertyWriteInfoExtractorInterface.php  me  xBy\      A   vendor/symfony/property-info/PropertyAccessExtractorInterface.php  me  2$C      ?   vendor/symfony/property-info/PropertyTypeExtractorInterface.phpQ  meQ        1   vendor/symfony/property-info/PropertyReadInfo.php  me  KΤ      ;   vendor/symfony/property-info/Extractor/PhpStanExtractor.php(  me(  rc      >   vendor/symfony/property-info/Extractor/SerializerExtractor.php  me  8      ?   vendor/symfony/property-info/Extractor/ConstructorExtractor.php  me  X5      T   vendor/symfony/property-info/Extractor/ConstructorArgumentTypeExtractorInterface.php  me  jv\      >   vendor/symfony/property-info/Extractor/ReflectionExtractor.php&  me&  b      :   vendor/symfony/property-info/Extractor/PhpDocExtractor.php/  me/  Z      F   vendor/symfony/property-info/PropertyDescriptionExtractorInterface.phpP  meP  &      2   vendor/symfony/property-info/PropertyWriteInfo.phpc  mec  4b(}      &   vendor/symfony/property-info/README.md  me  '7      C   vendor/symfony/property-info/PropertyReadInfoExtractorInterface.php  me  :|`դ      H   vendor/symfony/property-info/PropertyInitializableExtractorInterface.php  me  OW      6   vendor/symfony/property-info/PropertyInfoExtractor.php^  me^  ji      ?   vendor/symfony/property-info/PropertyListExtractorInterface.php  me  J$      P   vendor/symfony/property-info/DependencyInjection/PropertyInfoConstructorPass.php  me  E      E   vendor/symfony/property-info/DependencyInjection/PropertyInfoPass.php  me  ֤      *   vendor/symfony/property-info/composer.json  me  X)      3   vendor/symfony/http-foundation/StreamedResponse.phpE  meE  񠈤      :   vendor/symfony/http-foundation/RequestMatcherInterface.php  me  XY      5   vendor/symfony/http-foundation/BinaryFileResponse.php6  me6  C      +   vendor/symfony/http-foundation/InputBag.phpA  meA  m      I   vendor/symfony/http-foundation/RateLimiter/AbstractRequestRateLimiter.php  me  c      J   vendor/symfony/http-foundation/RateLimiter/RequestRateLimiterInterface.php
  me
  ¤      &   vendor/symfony/http-foundation/LICENSE,  me,  U      J   vendor/symfony/http-foundation/Test/Constraint/ResponseCookieValueSame.php  me  i      D   vendor/symfony/http-foundation/Test/Constraint/ResponseHasCookie.php  me  *      I   vendor/symfony/http-foundation/Test/Constraint/ResponseStatusCodeSame.phpU  meU  Q      G   vendor/symfony/http-foundation/Test/Constraint/ResponseIsSuccessful.php  me  -      J   vendor/symfony/http-foundation/Test/Constraint/ResponseIsUnprocessable.php  me  F      G   vendor/symfony/http-foundation/Test/Constraint/ResponseIsRedirected.php  me  Ƥ      D   vendor/symfony/http-foundation/Test/Constraint/ResponseHasHeader.php  me  Y      L   vendor/symfony/http-foundation/Test/Constraint/RequestAttributeValueSame.php  me  f,      E   vendor/symfony/http-foundation/Test/Constraint/ResponseFormatSame.phpb  meb  t$ؤ      E   vendor/symfony/http-foundation/Test/Constraint/ResponseHeaderSame.php:  me:  0W      ,   vendor/symfony/http-foundation/ServerBag.php  me  (      +   vendor/symfony/http-foundation/CHANGELOG.mdD=  meD=  N|      ,   vendor/symfony/http-foundation/File/File.php7  me7  qsF      .   vendor/symfony/http-foundation/File/Stream.phpE  meE  Z      4   vendor/symfony/http-foundation/File/UploadedFile.phpa(  mea(  i$p      G   vendor/symfony/http-foundation/File/Exception/AccessDeniedException.phpi  mei  Y      A   vendor/symfony/http-foundation/File/Exception/NoFileException.php  me  -A      F   vendor/symfony/http-foundation/File/Exception/IniSizeFileException.php  me  I      J   vendor/symfony/http-foundation/File/Exception/CannotWriteFileException.php  me  :ݤ      H   vendor/symfony/http-foundation/File/Exception/ExtensionFileException.php  me  )      ?   vendor/symfony/http-foundation/File/Exception/FileException.php  me  j2      A   vendor/symfony/http-foundation/File/Exception/UploadException.php  me  S      I   vendor/symfony/http-foundation/File/Exception/UnexpectedTypeException.php3  me3  t*      G   vendor/symfony/http-foundation/File/Exception/FormSizeFileException.php  me  m;      G   vendor/symfony/http-foundation/File/Exception/FileNotFoundException.phpY  meY  {WɈ      F   vendor/symfony/http-foundation/File/Exception/PartialFileException.php  me  *      G   vendor/symfony/http-foundation/File/Exception/NoTmpDirFileException.php  me  n      +   vendor/symfony/http-foundation/Response.phpH  meH  N"      )   vendor/symfony/http-foundation/Cookie.php-  me-  Cw      /   vendor/symfony/http-foundation/AcceptHeader.php<  me<  d      1   vendor/symfony/http-foundation/RequestMatcher.php:  me:  &      4   vendor/symfony/http-foundation/ResponseHeaderBag.php  me  &G      .   vendor/symfony/http-foundation/HeaderUtils.php$  me$  p      /   vendor/symfony/http-foundation/RequestStack.phps  mes  ˾'      3   vendor/symfony/http-foundation/RedirectResponse.php  me  Ek      /   vendor/symfony/http-foundation/JsonResponse.phpw  mew  (v      (   vendor/symfony/http-foundation/README.md  me  %      *   vendor/symfony/http-foundation/Request.php
 me
       ;   vendor/symfony/http-foundation/ExpressionRequestMatcher.php  me   L      /   vendor/symfony/http-foundation/ParameterBag.php  me  Dd      *   vendor/symfony/http-foundation/IpUtils.php  me  άͤ      3   vendor/symfony/http-foundation/AcceptHeaderItem.phpQ
  meQ
  1      ,   vendor/symfony/http-foundation/UrlHelper.php  me  {      ,   vendor/symfony/http-foundation/HeaderBag.php0  me0  ȥ_      *   vendor/symfony/http-foundation/FileBag.php(  me(  ɿ      H   vendor/symfony/http-foundation/Exception/ConflictingHeadersException.php  me  .>+w      F   vendor/symfony/http-foundation/Exception/RequestExceptionInterface.php  me  R      @   vendor/symfony/http-foundation/Exception/BadRequestException.php  me  դ      I   vendor/symfony/http-foundation/Exception/SuspiciousOperationException.php  me  㝜      :   vendor/symfony/http-foundation/Exception/JsonException.php  me  ~|mW      E   vendor/symfony/http-foundation/Exception/SessionNotFoundException.phpY  meY  1      ,   vendor/symfony/http-foundation/composer.jsonD  meD  b1      J   vendor/symfony/http-foundation/Session/Attribute/AttributeBagInterface.php  me        K   vendor/symfony/http-foundation/Session/Attribute/NamespacedAttributeBag.php  me  "      A   vendor/symfony/http-foundation/Session/Attribute/AttributeBag.php  me  z<      B   vendor/symfony/http-foundation/Session/SessionFactoryInterface.php  me  f*      2   vendor/symfony/http-foundation/Session/Session.php  me  U/6      7   vendor/symfony/http-foundation/Session/SessionUtils.phpt  met  OY      M   vendor/symfony/http-foundation/Session/Storage/Handler/NullSessionHandler.php  me  Uޤ      Q   vendor/symfony/http-foundation/Session/Storage/Handler/AbstractSessionHandler.php=  me=        P   vendor/symfony/http-foundation/Session/Storage/Handler/SessionHandlerFactory.php  me  '      L   vendor/symfony/http-foundation/Session/Storage/Handler/PdoSessionHandler.php  me  3      T   vendor/symfony/http-foundation/Session/Storage/Handler/MarshallingSessionHandler.phpm	  mem	  8      S   vendor/symfony/http-foundation/Session/Storage/Handler/NativeFileSessionHandler.php  me  :^      R   vendor/symfony/http-foundation/Session/Storage/Handler/MigratingSessionHandler.phpJ  meJ  ]Eq      M   vendor/symfony/http-foundation/Session/Storage/Handler/IdentityMarshaller.php  me  R=p      P   vendor/symfony/http-foundation/Session/Storage/Handler/MongoDbSessionHandler.php  me  DT      N   vendor/symfony/http-foundation/Session/Storage/Handler/RedisSessionHandler.php  me  d      O   vendor/symfony/http-foundation/Session/Storage/Handler/StrictSessionHandler.php
  me
  oqФ      R   vendor/symfony/http-foundation/Session/Storage/Handler/MemcachedSessionHandler.phpW
  meW
  Rj      G   vendor/symfony/http-foundation/Session/Storage/NativeSessionStorage.php?  me?        J   vendor/symfony/http-foundation/Session/Storage/SessionStorageInterface.php=  me=  ʒ      P   vendor/symfony/http-foundation/Session/Storage/MockFileSessionStorageFactory.php  me  
TҤ      L   vendor/symfony/http-foundation/Session/Storage/Proxy/SessionHandlerProxy.phpy
  mey
  s      F   vendor/symfony/http-foundation/Session/Storage/Proxy/AbstractProxy.php	  me	  &.      N   vendor/symfony/http-foundation/Session/Storage/NativeSessionStorageFactory.phpc  mec        J   vendor/symfony/http-foundation/Session/Storage/PhpBridgeSessionStorage.php  me   3      Q   vendor/symfony/http-foundation/Session/Storage/SessionStorageFactoryInterface.phpw  mew  ]n      H   vendor/symfony/http-foundation/Session/Storage/ServiceSessionFactory.php  me  }       I   vendor/symfony/http-foundation/Session/Storage/MockFileSessionStorage.php  me  B      Q   vendor/symfony/http-foundation/Session/Storage/PhpBridgeSessionStorageFactory.php  me  *5>      >   vendor/symfony/http-foundation/Session/Storage/MetadataBag.php  me  91      J   vendor/symfony/http-foundation/Session/Storage/MockArraySessionStorage.php  me  C      ;   vendor/symfony/http-foundation/Session/SessionInterface.phpq  meq   te      C   vendor/symfony/http-foundation/Session/Flash/AutoExpireFlashBag.php
  me
  Ճ5      B   vendor/symfony/http-foundation/Session/Flash/FlashBagInterface.phpf  mef  3      9   vendor/symfony/http-foundation/Session/Flash/FlashBag.php
  me
  ۖV      9   vendor/symfony/http-foundation/Session/SessionFactory.php  me  bE;      :   vendor/symfony/http-foundation/Session/SessionBagProxy.php2  me2  W@      >   vendor/symfony/http-foundation/Session/SessionBagInterface.php\  me\  hI      ,   vendor/symfony/var-exporter/Instantiator.php  me  Yd      #   vendor/symfony/var-exporter/LICENSE,  me,        (   vendor/symfony/var-exporter/CHANGELOG.md   me         /   vendor/symfony/var-exporter/Internal/Values.php  me  `ǿ      1   vendor/symfony/var-exporter/Internal/Hydrator.phpr  mer  :c      1   vendor/symfony/var-exporter/Internal/Registry.php>  me>  M,      2   vendor/symfony/var-exporter/Internal/Reference.php;  me;  *Q/ˤ      1   vendor/symfony/var-exporter/Internal/Exporter.phpA  meA  h'      %   vendor/symfony/var-exporter/README.md  me  8      +   vendor/symfony/var-exporter/VarExporter.php  me   
      <   vendor/symfony/var-exporter/Exception/ExceptionInterface.phpd  med        @   vendor/symfony/var-exporter/Exception/ClassNotFoundException.php1  me1  w w      F   vendor/symfony/var-exporter/Exception/NotInstantiableTypeException.php>  me>  }      )   vendor/symfony/var-exporter/composer.json  me  ҽe      E   vendor/symfony/error-handler/ErrorEnhancer/ErrorEnhancerInterface.php	  me	  ޺      I   vendor/symfony/error-handler/ErrorEnhancer/ClassNotFoundErrorEnhancer.php  me  pn[      M   vendor/symfony/error-handler/ErrorEnhancer/UndefinedFunctionErrorEnhancer.phpK  meK  -      K   vendor/symfony/error-handler/ErrorEnhancer/UndefinedMethodErrorEnhancer.php  me  a      $   vendor/symfony/error-handler/LICENSE,  me,  զ_Ϥ      )   vendor/symfony/error-handler/CHANGELOG.md|  me|  n:t      B   vendor/symfony/error-handler/Resources/bin/patch-type-declarations
  me
  R      M   vendor/symfony/error-handler/Resources/bin/extract-tentative-return-types.php   me   mE      ?   vendor/symfony/error-handler/Resources/views/exception.html.php>  me>  ˚      <   vendor/symfony/error-handler/Resources/views/traces.html.php]	  me]	  m}      A   vendor/symfony/error-handler/Resources/views/traces_text.html.php  me  j+2      :   vendor/symfony/error-handler/Resources/views/logs.html.php)	  me)	  _&      ;   vendor/symfony/error-handler/Resources/views/trace.html.phpU  meU  4K'      ;   vendor/symfony/error-handler/Resources/views/error.html.php  me  < z      D   vendor/symfony/error-handler/Resources/views/exception_full.html.php  me        ?   vendor/symfony/error-handler/Resources/assets/css/exception.css@7  me@7  |vN      D   vendor/symfony/error-handler/Resources/assets/css/exception_full.css
  me
  *bc      ;   vendor/symfony/error-handler/Resources/assets/css/error.css  me  %7      J   vendor/symfony/error-handler/Resources/assets/images/icon-minus-square.svgQ  meQ  p      B   vendor/symfony/error-handler/Resources/assets/images/icon-book.svg  me        E   vendor/symfony/error-handler/Resources/assets/images/icon-support.svgz  mez  S̤      F   vendor/symfony/error-handler/Resources/assets/images/chevron-right.svg  me        J   vendor/symfony/error-handler/Resources/assets/images/symfony-ghost.svg.php   me   9꒤      I   vendor/symfony/error-handler/Resources/assets/images/icon-plus-square.svg  me  U      E   vendor/symfony/error-handler/Resources/assets/images/symfony-logo.svg  me  %0ɤ      B   vendor/symfony/error-handler/Resources/assets/images/icon-copy.svg	  me	  "Ȗ      G   vendor/symfony/error-handler/Resources/assets/images/favicon.png.base64  me  "i^      K   vendor/symfony/error-handler/Resources/assets/images/icon-plus-square-o.svg  me  -      L   vendor/symfony/error-handler/Resources/assets/images/icon-minus-square-o.svg  me  s0      =   vendor/symfony/error-handler/Resources/assets/js/exception.js4  me4  2d      8   vendor/symfony/error-handler/Internal/TentativeTypes.php  me        &   vendor/symfony/error-handler/Debug.phpB  meB  ;~      F   vendor/symfony/error-handler/ErrorRenderer/SerializerErrorRenderer.php7  me7  Ƥ      ?   vendor/symfony/error-handler/ErrorRenderer/CliErrorRenderer.php  me  0      E   vendor/symfony/error-handler/ErrorRenderer/ErrorRendererInterface.php  me  5g      @   vendor/symfony/error-handler/ErrorRenderer/HtmlErrorRenderer.php`  me`  j      &   vendor/symfony/error-handler/README.md=  me=  \      1   vendor/symfony/error-handler/DebugClassLoader.phpq  meq  rP      0   vendor/symfony/error-handler/BufferingLogger.php"  me"  i9-      -   vendor/symfony/error-handler/ErrorHandler.phpt  met        /   vendor/symfony/error-handler/ThrowableUtils.php  me  ~+G      7   vendor/symfony/error-handler/Error/OutOfMemoryError.php[  me[  N      ;   vendor/symfony/error-handler/Error/UndefinedMethodError.php^  me^  +3
      1   vendor/symfony/error-handler/Error/FatalError.php
  me
  ڐ ڤ      =   vendor/symfony/error-handler/Error/UndefinedFunctionError.php`  me`  ]W,      9   vendor/symfony/error-handler/Error/ClassNotFoundError.php\  me\  3Xޤ      ;   vendor/symfony/error-handler/Exception/FlattenException.php(  me(  i	      ?   vendor/symfony/error-handler/Exception/SilencedErrorContext.php]  me]  SƤ      *   vendor/symfony/error-handler/composer.json:  me:  P      4   vendor/symfony/cache-contracts/CallbackInterface.phpG  meG        0   vendor/symfony/cache-contracts/ItemInterface.php$  me$        &   vendor/symfony/cache-contracts/LICENSE)  me)  5古      +   vendor/symfony/cache-contracts/CHANGELOG.md   me   h{#      1   vendor/symfony/cache-contracts/CacheInterface.php	  me	  C      (   vendor/symfony/cache-contracts/README.mdH  meH  Z#      -   vendor/symfony/cache-contracts/CacheTrait.php)
  me)
  _      9   vendor/symfony/cache-contracts/TagAwareCacheInterface.php	  me	        ,   vendor/symfony/cache-contracts/composer.jsong  meg  (      7   vendor/symfony/dependency-injection/EnvVarProcessor.php*  me*  Y      ;   vendor/symfony/dependency-injection/ContainerAwareTrait.phpj  mej  N      B   vendor/symfony/dependency-injection/ExpressionLanguageProvider.php  me  s      1   vendor/symfony/dependency-injection/Container.php(7  me(7  XE      8   vendor/symfony/dependency-injection/ReverseContainer.php	  me	        0   vendor/symfony/dependency-injection/Variable.php  me  VB#      D   vendor/symfony/dependency-injection/Extension/ExtensionInterface.php  me  Ƥ      ;   vendor/symfony/dependency-injection/Extension/Extension.php  me  sj      K   vendor/symfony/dependency-injection/Extension/PrependExtensionInterface.php8  me8  %i      Q   vendor/symfony/dependency-injection/Extension/ConfigurationExtensionInterface.phpS  meS  )      ?   vendor/symfony/dependency-injection/Attribute/Autoconfigure.php\  me\  SH      >   vendor/symfony/dependency-injection/Attribute/AsTaggedItem.php  me  k      8   vendor/symfony/dependency-injection/Attribute/Target.php  me  
S      6   vendor/symfony/dependency-injection/Attribute/When.php  me  Xˤ      @   vendor/symfony/dependency-injection/Attribute/TaggedIterator.php=  me=  *"      B   vendor/symfony/dependency-injection/Attribute/AutoconfigureTag.php  me  	       ?   vendor/symfony/dependency-injection/Attribute/TaggedLocator.php<  me<  Eͤ      +   vendor/symfony/dependency-injection/LICENSE,  me,  U      0   vendor/symfony/dependency-injection/CHANGELOG.md9  me9        Q   vendor/symfony/dependency-injection/Config/ContainerParametersResourceChecker.phpu  meu  ʔs
      J   vendor/symfony/dependency-injection/Config/ContainerParametersResource.php  me  J`      J   vendor/symfony/dependency-injection/Argument/ReferenceSetArgumentTrait.phpF  meF  k[      A   vendor/symfony/dependency-injection/Argument/AbstractArgument.php  me  v      D   vendor/symfony/dependency-injection/Argument/RewindableGenerator.php  me  ?~\      G   vendor/symfony/dependency-injection/Argument/ServiceLocatorArgument.phpB  meB  p3      >   vendor/symfony/dependency-injection/Argument/BoundArgument.php  me  a      A   vendor/symfony/dependency-injection/Argument/IteratorArgument.php  me  ba      G   vendor/symfony/dependency-injection/Argument/TaggedIteratorArgument.php
  me
  2C      B   vendor/symfony/dependency-injection/Argument/ArgumentInterface.phpG  meG  ﺔ      ?   vendor/symfony/dependency-injection/Argument/ServiceLocator.php9  me9  ͞$      G   vendor/symfony/dependency-injection/Argument/ServiceClosureArgument.php  me  vA      8   vendor/symfony/dependency-injection/ContainerBuilder.phpP  meP  
Q      7   vendor/symfony/dependency-injection/ChildDefinition.php
  me
  g      1   vendor/symfony/dependency-injection/Reference.php  me  ^].      J   vendor/symfony/dependency-injection/ParameterBag/ParameterBagInterface.php:
  me:
  ˒-      O   vendor/symfony/dependency-injection/ParameterBag/EnvPlaceholderParameterBag.php   me   +L{      A   vendor/symfony/dependency-injection/ParameterBag/ParameterBag.php{  me{  ݇      J   vendor/symfony/dependency-injection/ParameterBag/ContainerBagInterface.phpw  mew  s      A   vendor/symfony/dependency-injection/ParameterBag/ContainerBag.php  me  BS      G   vendor/symfony/dependency-injection/ParameterBag/FrozenParameterBag.php_  me_  nȤ      2   vendor/symfony/dependency-injection/Definition.phpW  meW  $Sɤ      @   vendor/symfony/dependency-injection/EnvVarProcessorInterface.php  me  }o>X      -   vendor/symfony/dependency-injection/README.mdC  meC  <      :   vendor/symfony/dependency-injection/ContainerInterface.php#
  me#
  a
|      9   vendor/symfony/dependency-injection/Loader/FileLoader.php5)  me5)  *      =   vendor/symfony/dependency-injection/Loader/YamlFileLoader.php  me  _Ӥ      O   vendor/symfony/dependency-injection/Loader/schema/dic/services/services-1.0.xsdr9  mer9  -0      <   vendor/symfony/dependency-injection/Loader/PhpFileLoader.phpY!  meY!  E      <   vendor/symfony/dependency-injection/Loader/XmlFileLoader.php  me  D      <   vendor/symfony/dependency-injection/Loader/IniFileLoader.php  me  uq7      P   vendor/symfony/dependency-injection/Loader/Configurator/ServicesConfigurator.php  me  F$j      P   vendor/symfony/dependency-injection/Loader/Configurator/DefaultsConfigurator.php  me  ƭb      Q   vendor/symfony/dependency-injection/Loader/Configurator/ReferenceConfigurator.php  me  *b      M   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ClassTrait.php/  me/  ݅      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/CallTrait.phpL  meL        Q   vendor/symfony/dependency-injection/Loader/Configurator/Traits/SyntheticTrait.php  me        P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/PropertyTrait.phpd  med  k      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ArgumentTrait.php  me  萯      T   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ConfiguratorTrait.php  me  ސ      N   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ParentTrait.php  me        O   vendor/symfony/dependency-injection/Loader/Configurator/Traits/FactoryTrait.php  me  ֍      K   vendor/symfony/dependency-injection/Loader/Configurator/Traits/TagTrait.php  me  s      N   vendor/symfony/dependency-injection/Loader/Configurator/Traits/PublicTrait.php  me  Z$Ѫ      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/DecorateTrait.phpy  mey  л*/      U   vendor/symfony/dependency-injection/Loader/Configurator/Traits/AutoconfigureTrait.phpC  meC  V      Q   vendor/symfony/dependency-injection/Loader/Configurator/Traits/DeprecateTrait.phpR  meR  ]*      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/BindTrait.phpS  meS  #       L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/LazyTrait.php6  me6  ~q      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/FileTrait.phpE  meE  L      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/AbstractTrait.php  me  F-      M   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ShareTrait.phpJ  meJ  @	      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/AutowireTrait.phpK  meK        P   vendor/symfony/dependency-injection/Loader/Configurator/AbstractConfigurator.php  me  '0      X   vendor/symfony/dependency-injection/Loader/Configurator/ClosureReferenceConfigurator.php  me  #y      K   vendor/symfony/dependency-injection/Loader/Configurator/EnvConfigurator.php0  me0  pe      W   vendor/symfony/dependency-injection/Loader/Configurator/AbstractServiceConfigurator.php  me  Crڠ      R   vendor/symfony/dependency-injection/Loader/Configurator/InstanceofConfigurator.php  me  BрY      Q   vendor/symfony/dependency-injection/Loader/Configurator/ContainerConfigurator.php  me  Ɣ      M   vendor/symfony/dependency-injection/Loader/Configurator/AliasConfigurator.php  me  RF,b      U   vendor/symfony/dependency-injection/Loader/Configurator/InlineServiceConfigurator.php  me  (Ё      Q   vendor/symfony/dependency-injection/Loader/Configurator/PrototypeConfigurator.php
  me
  h      R   vendor/symfony/dependency-injection/Loader/Configurator/ParametersConfigurator.php  me  o9-      O   vendor/symfony/dependency-injection/Loader/Configurator/ServiceConfigurator.php#  me#  s˜ۤ      >   vendor/symfony/dependency-injection/Loader/DirectoryLoader.phpa  mea  Ǥ      =   vendor/symfony/dependency-injection/Loader/GlobFileLoader.php  me  9$      <   vendor/symfony/dependency-injection/Loader/ClosureLoader.php  me  [      =   vendor/symfony/dependency-injection/LazyProxy/ProxyHelper.php
  me
  <      K   vendor/symfony/dependency-injection/LazyProxy/PhpDumper/DumperInterface.php  me  lݴ      F   vendor/symfony/dependency-injection/LazyProxy/PhpDumper/NullDumper.php  me  aY      V   vendor/symfony/dependency-injection/LazyProxy/Instantiator/RealServiceInstantiator.php  me  5'פ      T   vendor/symfony/dependency-injection/LazyProxy/Instantiator/InstantiatorInterface.phpx  mex  9|      :   vendor/symfony/dependency-injection/ExpressionLanguage.phpd  med  b      6   vendor/symfony/dependency-injection/ServiceLocator.php>  me>  J      6   vendor/symfony/dependency-injection/TypedReference.php  me  2)      -   vendor/symfony/dependency-injection/Alias.php  me  v%      U   vendor/symfony/dependency-injection/Exception/ParameterCircularReferenceException.php  me  ?u      @   vendor/symfony/dependency-injection/Exception/LogicException.php  me  }|Ȥ      F   vendor/symfony/dependency-injection/Exception/EnvNotFoundException.php  me  &      L   vendor/symfony/dependency-injection/Exception/ParameterNotFoundException.phpQ
  meQ
  \      D   vendor/symfony/dependency-injection/Exception/ExceptionInterface.php~  me~        F   vendor/symfony/dependency-injection/Exception/OutOfBoundsException.php  me  On      S   vendor/symfony/dependency-injection/Exception/ServiceCircularReferenceException.php  me   +      J   vendor/symfony/dependency-injection/Exception/ServiceNotFoundException.php$  me$   r      B   vendor/symfony/dependency-injection/Exception/RuntimeException.php	  me	  
      J   vendor/symfony/dependency-injection/Exception/InvalidArgumentException.php'  me'        H   vendor/symfony/dependency-injection/Exception/BadMethodCallException.php  me  ,w      K   vendor/symfony/dependency-injection/Exception/AutowiringFailedException.php  me  e      O   vendor/symfony/dependency-injection/Exception/InvalidParameterTypeException.php0  me0  I      G   vendor/symfony/dependency-injection/Exception/EnvParameterException.php  me  =&)      @   vendor/symfony/dependency-injection/TaggedContainerInterface.php  me  ǝ      1   vendor/symfony/dependency-injection/Parameter.php|  me|  nJ      E   vendor/symfony/dependency-injection/Compiler/DecoratorServicePass.php  me   '      M   vendor/symfony/dependency-injection/Compiler/ResolveInvalidReferencesPass.phpK  meK  A      L   vendor/symfony/dependency-injection/Compiler/ValidateEnvPlaceholdersPass.php  me  Af      M   vendor/symfony/dependency-injection/Compiler/RegisterEnvVarProcessorsPass.php  me  S/      T   vendor/symfony/dependency-injection/Compiler/RegisterAutoconfigureAttributesPass.php  me         L   vendor/symfony/dependency-injection/Compiler/CheckDefinitionValidityPass.php  me  _9      ;   vendor/symfony/dependency-injection/Compiler/PassConfig.php  me  `Z      F   vendor/symfony/dependency-injection/Compiler/ServiceReferenceGraph.php~
  me~
  FAaä      E   vendor/symfony/dependency-injection/Compiler/ResolveNoPreloadPass.phpX
  meX
  L_;      J   vendor/symfony/dependency-injection/Compiler/ServiceReferenceGraphNode.php	  me	  H      J   vendor/symfony/dependency-injection/Compiler/CheckTypeDeclarationsPass.php1  me1  1Fʤ      M   vendor/symfony/dependency-injection/Compiler/InlineServiceDefinitionsPass.php)  me)  <`      H   vendor/symfony/dependency-injection/Compiler/ResolveFactoryClassPass.php  me  /O      D   vendor/symfony/dependency-injection/Compiler/ResolveBindingsPass.php&  me&   e      K   vendor/symfony/dependency-injection/Compiler/PriorityTaggedServiceTrait.php  me  f*      M   vendor/symfony/dependency-injection/Compiler/RegisterReverseContainerPass.php	  me	        F   vendor/symfony/dependency-injection/Compiler/AbstractRecursivePass.php3%  me3%  xI      R   vendor/symfony/dependency-injection/Compiler/AliasDeprecatedPublicServicesPass.php	
  me	
  Ls]      R   vendor/symfony/dependency-injection/Compiler/ResolveInstanceofConditionalsPass.phpv  mev  vW      O   vendor/symfony/dependency-injection/Compiler/ResolveReferencesToAliasesPass.php  me  p      K   vendor/symfony/dependency-injection/Compiler/CheckArgumentsValidityPass.phpT  meT  L      O   vendor/symfony/dependency-injection/Compiler/AttributeAutoconfigurationPass.php  me  Bu      D   vendor/symfony/dependency-injection/Compiler/ResolvePrivatesPass.php  me  פ      O   vendor/symfony/dependency-injection/Compiler/AutowireRequiredPropertiesPass.php&	  me&	  K.      J   vendor/symfony/dependency-injection/Compiler/ResolveNamedArgumentsPass.php,  me,  t}Ȥ      I   vendor/symfony/dependency-injection/Compiler/RemovePrivateAliasesPass.phpv  mev  x#      P   vendor/symfony/dependency-injection/Compiler/MergeExtensionConfigurationPass.phpR!  meR!  L6k      J   vendor/symfony/dependency-injection/Compiler/ServiceReferenceGraphEdge.php  me  \      M   vendor/symfony/dependency-injection/Compiler/DefinitionErrorExceptionPass.php7
  me7
        L   vendor/symfony/dependency-injection/Compiler/RemoveUnusedDefinitionsPass.phpT  meT        =   vendor/symfony/dependency-injection/Compiler/AutowirePass.phpkb  mekb  LR      F   vendor/symfony/dependency-injection/Compiler/ServiceLocatorTagPass.phpM  meM  \hT      R   vendor/symfony/dependency-injection/Compiler/ResolveTaggedIteratorArgumentPass.php  me  D>Ϥ      K   vendor/symfony/dependency-injection/Compiler/ResolveEnvPlaceholdersPass.phpm  mem  I2a      L   vendor/symfony/dependency-injection/Compiler/CheckCircularReferencesPass.php	  me	  b4      ]   vendor/symfony/dependency-injection/Compiler/CheckExceptionOnInvalidReferenceBehaviorPass.php  me  7      E   vendor/symfony/dependency-injection/Compiler/AutoAliasServicePass.php  me  	#      Q   vendor/symfony/dependency-injection/Compiler/ResolveParameterPlaceHoldersPass.php  me        A   vendor/symfony/dependency-injection/Compiler/ResolveClassPass.php^  me^  j'      N   vendor/symfony/dependency-injection/Compiler/RemoveAbstractDefinitionsPass.php  me  V𿐤      K   vendor/symfony/dependency-injection/Compiler/CheckReferenceValidityPass.php  me  Ⅴ      O   vendor/symfony/dependency-injection/Compiler/RegisterServiceSubscribersPass.php  me  1[      C   vendor/symfony/dependency-injection/Compiler/ResolveHotPathPass.php9
  me9
  1f\      J   vendor/symfony/dependency-injection/Compiler/ResolveDecoratorStackPass.php  me  cǤ      N   vendor/symfony/dependency-injection/Compiler/ResolveServiceSubscribersPass.php  me  [{      F   vendor/symfony/dependency-injection/Compiler/CompilerPassInterface.php  me  @      S   vendor/symfony/dependency-injection/Compiler/ReplaceAliasByActualDefinitionPass.php  me  ,<o      L   vendor/symfony/dependency-injection/Compiler/ResolveChildDefinitionsPass.phpw  mew  W      9   vendor/symfony/dependency-injection/Compiler/Compiler.php
  me
  e7      F   vendor/symfony/dependency-injection/Compiler/ExtensionCompilerPass.php  me  @	Ť      M   vendor/symfony/dependency-injection/Compiler/AnalyzeServiceReferencesPass.php  me  F      L   vendor/symfony/dependency-injection/Compiler/AutowireRequiredMethodsPass.php  me  .ݤ      =   vendor/symfony/dependency-injection/Dumper/GraphvizDumper.php$  me$  G`      9   vendor/symfony/dependency-injection/Dumper/YamlDumper.phpx5  mex5  	f
      8   vendor/symfony/dependency-injection/Dumper/Preloader.php-  me-  "!      8   vendor/symfony/dependency-injection/Dumper/XmlDumper.php@  me@  ǿ      >   vendor/symfony/dependency-injection/Dumper/DumperInterface.phpj  mej  m      5   vendor/symfony/dependency-injection/Dumper/Dumper.php  me  U;a      8   vendor/symfony/dependency-injection/Dumper/PhpDumper.phpdg medg :ä      1   vendor/symfony/dependency-injection/composer.jsonx  mex  Ed      =   vendor/symfony/dependency-injection/EnvVarLoaderInterface.php  me  Aar      ?   vendor/symfony/dependency-injection/ContainerAwareInterface.php]  me]  雤      :   vendor/symfony/password-hasher/PasswordHasherInterface.php  me  k>      >   vendor/symfony/password-hasher/Hasher/SodiumPasswordHasher.php  me  U      B   vendor/symfony/password-hasher/Hasher/CheckPasswordLengthTrait.phpw  mew  #1      <   vendor/symfony/password-hasher/Hasher/UserPasswordHasher.php  me  rπ      >   vendor/symfony/password-hasher/Hasher/Pbkdf2PasswordHasher.php  me  (SA      F   vendor/symfony/password-hasher/Hasher/PasswordHasherAwareInterface.php  me  ϡ*      >   vendor/symfony/password-hasher/Hasher/NativePasswordHasher.php  me        E   vendor/symfony/password-hasher/Hasher/MessageDigestPasswordHasher.php  me  x      E   vendor/symfony/password-hasher/Hasher/UserPasswordHasherInterface.php   me   VkT      A   vendor/symfony/password-hasher/Hasher/PlaintextPasswordHasher.php6	  me6	  juq      H   vendor/symfony/password-hasher/Hasher/PasswordHasherFactoryInterface.php1  me1  |<      A   vendor/symfony/password-hasher/Hasher/MigratingPasswordHasher.phpL  meL  SG      ?   vendor/symfony/password-hasher/Hasher/PasswordHasherFactory.php#  me#  vӫ      &   vendor/symfony/password-hasher/LICENSE,  me,  U      +   vendor/symfony/password-hasher/CHANGELOG.md]   me]   {>I      @   vendor/symfony/password-hasher/LegacyPasswordHasherInterface.phpv  mev  V      (   vendor/symfony/password-hasher/README.md  me  !      B   vendor/symfony/password-hasher/Command/UserPasswordHashCommand.php)  me)  Ud      ;   vendor/symfony/password-hasher/Exception/LogicException.php  me  A      ?   vendor/symfony/password-hasher/Exception/ExceptionInterface.php  me  EWL      E   vendor/symfony/password-hasher/Exception/InvalidPasswordException.php  me  L      ,   vendor/symfony/password-hasher/composer.json  me  uB$6         vendor/symfony/process/LICENSE,  me,  U      +   vendor/symfony/process/ExecutableFinder.php	  me	        #   vendor/symfony/process/CHANGELOG.md  me  (C          vendor/symfony/process/README.md  me  H!X      *   vendor/symfony/process/Pipes/UnixPipes.php  me  bU      -   vendor/symfony/process/Pipes/WindowsPipes.phpc  mec  $ޙ      .   vendor/symfony/process/Pipes/AbstractPipes.php  me  #      /   vendor/symfony/process/Pipes/PipesInterface.php  me        &   vendor/symfony/process/InputStream.php	  me	  D_      %   vendor/symfony/process/PhpProcess.php	  me	  nq      .   vendor/symfony/process/PhpExecutableFinder.php]
  me]
  "!Τ      =   vendor/symfony/process/Exception/ProcessSignaledException.php  me  V      3   vendor/symfony/process/Exception/LogicException.php  me  iUQ      7   vendor/symfony/process/Exception/ExceptionInterface.php  me  
j%W      ;   vendor/symfony/process/Exception/ProcessFailedException.phpA  meA  lk      5   vendor/symfony/process/Exception/RuntimeException.php  me  P      =   vendor/symfony/process/Exception/ProcessTimedOutException.phpt  met  /      =   vendor/symfony/process/Exception/InvalidArgumentException.php  me  ڴ      $   vendor/symfony/process/composer.json  me  Sg      '   vendor/symfony/process/ProcessUtils.phpT  meT        "   vendor/symfony/process/Process.php  me  }B=      (   vendor/symfony/console/ConsoleEvents.php  me  .
      !   vendor/symfony/console/Cursor.php7  me7  E      &   vendor/symfony/console/Application.phpp  mep  (;      /   vendor/symfony/console/Logger/ConsoleLogger.php  me  2      .   vendor/symfony/console/Attribute/AsCommand.phpJ  meJ  c         vendor/symfony/console/LICENSE,  me,  U      #   vendor/symfony/console/CHANGELOG.md   me   P      9   vendor/symfony/console/Input/StreamableInputInterface.phpv  mev  @      +   vendor/symfony/console/Input/ArrayInput.php  me  $      *   vendor/symfony/console/Input/ArgvInput.php0  me0         .   vendor/symfony/console/Input/InputArgument.php
  me
  2      4   vendor/symfony/console/Input/InputAwareInterface.phpH  meH  Ea      ,   vendor/symfony/console/Input/InputOption.php<  me<  '      0   vendor/symfony/console/Input/InputDefinition.phpH.  meH.  ʄ=s      ,   vendor/symfony/console/Input/StringInput.php
  me
  JYc      &   vendor/symfony/console/Input/Input.php1  me1  m      /   vendor/symfony/console/Input/InputInterface.php  me  
+      #   vendor/symfony/console/Terminal.phpi  mei  5wt8      2   vendor/symfony/console/CI/GithubActionReporter.php  me  s      0   vendor/symfony/console/Resources/completion.bash
  me
  z(      4   vendor/symfony/console/Resources/bin/hiddeninput.exe $  me $  v      5   vendor/symfony/console/Output/TrimmedBufferOutput.phpc  mec        8   vendor/symfony/console/Output/ConsoleOutputInterface.php-  me-  U      0   vendor/symfony/console/Output/BufferedOutput.php_  me_  PR1      1   vendor/symfony/console/Output/OutputInterface.phpl  mel   -I      (   vendor/symfony/console/Output/Output.php[  me[  46      6   vendor/symfony/console/Output/ConsoleSectionOutput.php  me  ɤ      /   vendor/symfony/console/Output/ConsoleOutput.php!  me!  -i¤      ,   vendor/symfony/console/Output/NullOutput.php,	  me,	  GPJ      .   vendor/symfony/console/Output/StreamOutput.php  me  c(      A   vendor/symfony/console/Completion/Output/BashCompletionOutput.php	  me	  Q2      F   vendor/symfony/console/Completion/Output/CompletionOutputInterface.php  me  :]      0   vendor/symfony/console/Completion/Suggestion.php  me   s      ;   vendor/symfony/console/Completion/CompletionSuggestions.phpf  mef  \      5   vendor/symfony/console/Completion/CompletionInput.phpG   meG   Fx      ,   vendor/symfony/console/Style/OutputStyle.php8  me8  '      -   vendor/symfony/console/Style/SymfonyStyle.php9  me9  y      /   vendor/symfony/console/Style/StyleInterface.phpN
  meN
  ͎)      2   vendor/symfony/console/Question/ChoiceQuestion.php  me  .!ܤ      ,   vendor/symfony/console/Question/Question.phpr  mer  l      8   vendor/symfony/console/Question/ConfirmationQuestion.php%  me%  䦤          vendor/symfony/console/README.md  me  =NP      9   vendor/symfony/console/Formatter/OutputFormatterStyle.php  me  .}2      B   vendor/symfony/console/Formatter/OutputFormatterStyleInterface.phpe  mee  5ޤ      =   vendor/symfony/console/Formatter/NullOutputFormatterStyle.php  me  ]*      =   vendor/symfony/console/Formatter/OutputFormatterInterface.php@  me@  ?&      4   vendor/symfony/console/Formatter/OutputFormatter.php   me   d      8   vendor/symfony/console/Formatter/NullOutputFormatter.phpk  mek  Nl      F   vendor/symfony/console/Formatter/WrappableOutputFormatterInterface.php  me  pޤ      >   vendor/symfony/console/Formatter/OutputFormatterStyleStack.php
  me
  0          vendor/symfony/console/Color.phpR  meR  P      8   vendor/symfony/console/SignalRegistry/SignalRegistry.php@  me@         3   vendor/symfony/console/SingleCommandApplication.php)  me)  6^      ?   vendor/symfony/console/CommandLoader/CommandLoaderInterface.phpv  mev  h      ?   vendor/symfony/console/CommandLoader/ContainerCommandLoader.php
  me
  7!      =   vendor/symfony/console/CommandLoader/FactoryCommandLoader.php]  me]  j7      4   vendor/symfony/console/Descriptor/TextDescriptor.php1  me1  X      <   vendor/symfony/console/Descriptor/ApplicationDescription.php  me  5x      3   vendor/symfony/console/Descriptor/XmlDescriptor.php'  me'  fʕ'      9   vendor/symfony/console/Descriptor/DescriptorInterface.phpI  meI  N)      0   vendor/symfony/console/Descriptor/Descriptor.php  me  =      4   vendor/symfony/console/Descriptor/JsonDescriptor.php  me  k/6       8   vendor/symfony/console/Descriptor/MarkdownDescriptor.phpK  meK   Ѥ      /   vendor/symfony/console/Tester/CommandTester.php>	  me>	  ڑc      -   vendor/symfony/console/Tester/TesterTrait.php  me  ́      3   vendor/symfony/console/Tester/ApplicationTester.php
  me
  $Z      9   vendor/symfony/console/Tester/CommandCompletionTester.php<  me<  y      @   vendor/symfony/console/Tester/Constraint/CommandIsSuccessful.php  me  Ld      .   vendor/symfony/console/Command/LazyCommand.php&  me&  i      0   vendor/symfony/console/Command/LockableTrait.php  me  ̤      .   vendor/symfony/console/Command/HelpCommand.php  me        2   vendor/symfony/console/Command/CompleteCommand.php   me   gQ@      .   vendor/symfony/console/Command/ListCommand.php  me  8MZ      8   vendor/symfony/console/Command/DumpCompletionCommand.php  me  Dә      =   vendor/symfony/console/Command/SignalableCommandInterface.php  me  ,      *   vendor/symfony/console/Command/Command.phpP  meP  vK      ,   vendor/symfony/console/Helper/TableStyle.php0  me0  ?V      +   vendor/symfony/console/Helper/TableRows.phpR  meR  HD      7   vendor/symfony/console/Helper/SymfonyQuestionHelper.php+
  me+
  ݙ      1   vendor/symfony/console/Helper/HelperInterface.phpZ  meZ  6      +   vendor/symfony/console/Helper/TableCell.php
  me
  ~3      /   vendor/symfony/console/Helper/ProcessHelper.php  me  Iʤ      0   vendor/symfony/console/Helper/TableSeparator.php!  me!  n2      1   vendor/symfony/console/Helper/FormatterHelper.phpx	  mex	  @d
Ϥ      0   vendor/symfony/console/Helper/TableCellStyle.php\  me\  9|S      -   vendor/symfony/console/Helper/ProgressBar.php H  me H  EX      6   vendor/symfony/console/Helper/DebugFormatterHelper.phpX
  meX
  젤      +   vendor/symfony/console/Helper/HelperSet.php;
  me;
  J>~      (   vendor/symfony/console/Helper/Dumper.phpD  meD  z      2   vendor/symfony/console/Helper/InputAwareHelper.php  me  E      0   vendor/symfony/console/Helper/QuestionHelper.php}N  me}N        (   vendor/symfony/console/Helper/Helper.php  me  I 0      '   vendor/symfony/console/Helper/Table.phpPr  mePr  m6      3   vendor/symfony/console/Helper/ProgressIndicator.php  me  :      2   vendor/symfony/console/Helper/DescriptorHelper.php	  me	  Nq      D   vendor/symfony/console/DependencyInjection/AddConsoleCommandPass.php  me  S      3   vendor/symfony/console/Exception/LogicException.php  me  5      ;   vendor/symfony/console/Exception/InvalidOptionException.php  me  %:      7   vendor/symfony/console/Exception/ExceptionInterface.php  me  oOȤ      5   vendor/symfony/console/Exception/RuntimeException.php  me        ?   vendor/symfony/console/Exception/NamespaceNotFoundException.php  me  xD      =   vendor/symfony/console/Exception/InvalidArgumentException.php  me  x
Τ      :   vendor/symfony/console/Exception/MissingInputException.php  me  L      =   vendor/symfony/console/Exception/CommandNotFoundException.php  me  
kg      6   vendor/symfony/console/Event/ConsoleTerminateEvent.phpZ  meZ  TJ      2   vendor/symfony/console/Event/ConsoleErrorEvent.php  me  o}4Ϥ      4   vendor/symfony/console/Event/ConsoleCommandEvent.php9  me9  tp      -   vendor/symfony/console/Event/ConsoleEvent.php  me  .bF      3   vendor/symfony/console/Event/ConsoleSignalEvent.php  me  #4pԤ      $   vendor/symfony/console/composer.json  me  S(      6   vendor/symfony/console/EventListener/ErrorListener.phpB  meB  a      0   vendor/symfony/polyfill-mbstring/bootstrap80.phpa#  mea#  ,      (   vendor/symfony/polyfill-mbstring/LICENSE,  me,  H      B   vendor/symfony/polyfill-mbstring/Resources/unidata/caseFolding.php  me  ]SC      @   vendor/symfony/polyfill-mbstring/Resources/unidata/lowerCase.phpU  meU  D׎      F   vendor/symfony/polyfill-mbstring/Resources/unidata/titleCaseRegexp.php  me  oቤ      @   vendor/symfony/polyfill-mbstring/Resources/unidata/upperCase.phpO[  meO[  (      -   vendor/symfony/polyfill-mbstring/Mbstring.phpi|  mei|  fe%      .   vendor/symfony/polyfill-mbstring/bootstrap.phpV  meV  m<      *   vendor/symfony/polyfill-mbstring/README.mdr  mer  A`      .   vendor/symfony/polyfill-mbstring/composer.json8  me8  .      5   vendor/symfony/polyfill-intl-grapheme/bootstrap80.phpg
  meg
  E{      -   vendor/symfony/polyfill-intl-grapheme/LICENSE,  me,  H      2   vendor/symfony/polyfill-intl-grapheme/Grapheme.php&  me&  8      3   vendor/symfony/polyfill-intl-grapheme/bootstrap.php  me        /   vendor/symfony/polyfill-intl-grapheme/README.mdK  meK  C>      3   vendor/symfony/polyfill-intl-grapheme/composer.json   me            vendor/ramsey/uuid/LICENSED  meD  D¤         vendor/ramsey/uuid/README.mdh  meh  g          vendor/ramsey/uuid/composer.json7  me7  J      $   vendor/ramsey/uuid/src/functions.phpj	  mej	  "      :   vendor/ramsey/uuid/src/Converter/Time/PhpTimeConverter.php  me  濤      ?   vendor/ramsey/uuid/src/Converter/Time/DegradedTimeConverter.php  me  :      @   vendor/ramsey/uuid/src/Converter/Time/BigNumberTimeConverter.php
  me
  l      C   vendor/ramsey/uuid/src/Converter/Number/DegradedNumberConverter.php  me        >   vendor/ramsey/uuid/src/Converter/Number/BigNumberConverter.php  me        ;   vendor/ramsey/uuid/src/Converter/TimeConverterInterface.phpD  meD  x      =   vendor/ramsey/uuid/src/Converter/NumberConverterInterface.php  me  uѢ      8   vendor/ramsey/uuid/src/Codec/TimestampFirstCombCodec.php  me  o^      1   vendor/ramsey/uuid/src/Codec/OrderedTimeCodec.php"  me"  а      /   vendor/ramsey/uuid/src/Codec/CodecInterface.php  me  EΤ      0   vendor/ramsey/uuid/src/Codec/GuidStringCodec.php  me  U`      ,   vendor/ramsey/uuid/src/Codec/StringCodec.phpR  meR  
      7   vendor/ramsey/uuid/src/Codec/TimestampLastCombCodec.php  me  0         vendor/ramsey/uuid/src/Uuid.php0Z  me0Z  x      9   vendor/ramsey/uuid/src/Provider/NodeProviderInterface.php  me  ڤ      ;   vendor/ramsey/uuid/src/Provider/Time/SystemTimeProvider.php  me        :   vendor/ramsey/uuid/src/Provider/Time/FixedTimeProvider.php  me  UtC      9   vendor/ramsey/uuid/src/Provider/TimeProviderInterface.php^  me^  ۤ      ;   vendor/ramsey/uuid/src/Provider/Node/RandomNodeProvider.php]  me]  An      =   vendor/ramsey/uuid/src/Provider/Node/FallbackNodeProvider.php  me  [I      ;   vendor/ramsey/uuid/src/Provider/Node/SystemNodeProvider.php
  me
  CKd      %   vendor/ramsey/uuid/src/FeatureSet.php$  me$  3/t      (   vendor/ramsey/uuid/src/UuidInterface.php%  me%  He"L      /   vendor/ramsey/uuid/src/UuidFactoryInterface.phpr  mer  V+X      9   vendor/ramsey/uuid/src/Generator/RandomBytesGenerator.php  me  cߤ      5   vendor/ramsey/uuid/src/Generator/OpenSslGenerator.php  me  4$      ;   vendor/ramsey/uuid/src/Generator/RandomGeneratorFactory.phpq  meq  )Q!      9   vendor/ramsey/uuid/src/Generator/TimeGeneratorFactory.php  me  ZFzN      9   vendor/ramsey/uuid/src/Generator/DefaultTimeGenerator.php*  me*  p      5   vendor/ramsey/uuid/src/Generator/RandomLibAdapter.php(  me(  <      ;   vendor/ramsey/uuid/src/Generator/TimeGeneratorInterface.php  me  ^ܟ"      2   vendor/ramsey/uuid/src/Generator/CombGenerator.php  me  y?$      =   vendor/ramsey/uuid/src/Generator/RandomGeneratorInterface.php  me  Ȕ      <   vendor/ramsey/uuid/src/Generator/PeclUuidRandomGenerator.phpo  meo  (      4   vendor/ramsey/uuid/src/Generator/MtRandGenerator.php  me  g      :   vendor/ramsey/uuid/src/Generator/SodiumRandomGenerator.php  me  :L      :   vendor/ramsey/uuid/src/Generator/PeclUuidTimeGenerator.php  me  A      &   vendor/ramsey/uuid/src/BinaryUtils.php4  me4  F@ۤ      &   vendor/ramsey/uuid/src/UuidFactory.phpE!  meE!  Jji      '   vendor/ramsey/uuid/src/DegradedUuid.php
  me
  @{      6   vendor/ramsey/uuid/src/Builder/DegradedUuidBuilder.php  me  L      7   vendor/ramsey/uuid/src/Builder/UuidBuilderInterface.php  me        5   vendor/ramsey/uuid/src/Builder/DefaultUuidBuilder.php  me        B   vendor/ramsey/uuid/src/Exception/UnsupportedOperationException.php  me  z{      C   vendor/ramsey/uuid/src/Exception/UnsatisfiedDependencyException.php  me  佢      ?   vendor/ramsey/uuid/src/Exception/InvalidUuidStringException.php  me  Ep8         vendor/react/promise/LICENSEg  meg  F      !   vendor/react/promise/CHANGELOG.md  me  B<Τ         vendor/react/promise/README.mdQY  meQY  @wn      "   vendor/react/promise/composer.json  me  NjB      -   vendor/react/promise/src/PromiseInterface.php  me  MFx8      &   vendor/react/promise/src/functions.php1-  me1-  t      .   vendor/react/promise/src/functions_include.php   me   dx\      $   vendor/react/promise/src/Promise.php(  me(  A      %   vendor/react/promise/src/Deferred.php/  me/  -ߤ      5   vendor/react/promise/src/Internal/RejectedPromise.php  me        6   vendor/react/promise/src/Internal/FulfilledPromise.php1	  me1	  RKbФ      7   vendor/react/promise/src/Internal/CancellationQueue.php  me  r2      6   vendor/react/promise/src/Exception/LengthException.php^   me^   ?q      9   vendor/react/promise/src/Exception/CompositeException.phpa  mea  '      3   vendor/terminal42/service-annotation-bundle/LICENSE#  me#  ~ke0      3   vendor/terminal42/service-annotation-bundle/ecs.phpr   mer   =05      5   vendor/terminal42/service-annotation-bundle/README.md  me  #      9   vendor/terminal42/service-annotation-bundle/composer.json  me  幉      U   vendor/terminal42/service-annotation-bundle/src/Terminal42ServiceAnnotationBundle.phpn  men  E      N   vendor/terminal42/service-annotation-bundle/src/ServiceAnnotationInterface.php  me  oj      I   vendor/terminal42/service-annotation-bundle/src/Annotation/ServiceTag.php  me  HƧ      R   vendor/terminal42/service-annotation-bundle/src/Annotation/ServiceTagInterface.php  me  FJ"      f   vendor/terminal42/service-annotation-bundle/src/DependencyInjection/Compiler/ServiceAnnotationPass.php
  me
  =!      <?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

require __DIR__ . '/../vendor/autoload.php';
if (\false === \in_array(\PHP_SAPI, array('cli', 'phpdbg', 'embed'), \true)) {
    echo \PHP_EOL . 'The application may only be invoked from a command line, got "' . \PHP_SAPI . '"' . \PHP_EOL;
    exit(1);
}
if ((\false === isset($_SERVER['BOX_REQUIREMENT_CHECKER']) || \true === (bool) $_SERVER['BOX_REQUIREMENT_CHECKER']) && \false === Checker::checkRequirements()) {
    exit(1);
}
<?php

return array (
  0 => 
  array (
    'type' => 'php',
    'condition' => '^7.2.5 || ^8.0',
    'message' => 'The application requires the version "^7.2.5 || ^8.0" or greater.',
    'helpMessage' => 'The application requires the version "^7.2.5 || ^8.0" or greater.',
  ),
  1 => 
  array (
    'type' => 'extension',
    'condition' => 'json',
    'message' => 'The application requires the extension "json". Enable it or install a polyfill.',
    'helpMessage' => 'The application requires the extension "json".',
  ),
  2 => 
  array (
    'type' => 'extension',
    'condition' => 'json',
    'message' => 'The package "ramsey/uuid" requires the extension "json". Enable it or install a polyfill.',
    'helpMessage' => 'The package "ramsey/uuid" requires the extension "json".',
  ),
  3 => 
  array (
    'type' => 'extension',
    'condition' => 'zip',
    'message' => 'The application requires the extension "zip". Enable it or install a polyfill.',
    'helpMessage' => 'The application requires the extension "zip".',
  ),
  4 => 
  array (
    'type' => 'extension',
    'condition' => 'openssl',
    'message' => 'The package "composer/ca-bundle" requires the extension "openssl". Enable it or install a polyfill.',
    'helpMessage' => 'The package "composer/ca-bundle" requires the extension "openssl".',
  ),
  5 => 
  array (
    'type' => 'extension',
    'condition' => 'pcre',
    'message' => 'The package "composer/ca-bundle" requires the extension "pcre". Enable it or install a polyfill.',
    'helpMessage' => 'The package "composer/ca-bundle" requires the extension "pcre".',
  ),
  6 => 
  array (
    'type' => 'extension',
    'condition' => 'tokenizer',
    'message' => 'The package "doctrine/annotations" requires the extension "tokenizer". Enable it or install a polyfill.',
    'helpMessage' => 'The package "doctrine/annotations" requires the extension "tokenizer".',
  ),
  7 => 
  array (
    'type' => 'extension',
    'condition' => 'xml',
    'message' => 'The package "symfony/framework-bundle" requires the extension "xml". Enable it or install a polyfill.',
    'helpMessage' => 'The package "symfony/framework-bundle" requires the extension "xml".',
  ),
  8 => 
  array (
    'type' => 'extension',
    'condition' => 'xml',
    'message' => 'The package "symfony/security-bundle" requires the extension "xml". Enable it or install a polyfill.',
    'helpMessage' => 'The package "symfony/security-bundle" requires the extension "xml".',
  ),
);<?php

// autoload.php @generated by Composer

require_once __DIR__ . '/composer/autoload_real.php';

return ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893::getLoader();
<?php

// autoload_namespaces.php @generated by Composer

$vendorDir = dirname(dirname(__FILE__));
$baseDir = dirname($vendorDir);

return array(
);

Copyright (c) Nils Adermann, Jordi Boggiano

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is furnished
to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

<?php

/*
 * This file is part of Composer.
 *
 * (c) Nils Adermann <naderman@naderman.de>
 *     Jordi Boggiano <j.boggiano@seld.be>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Composer\Autoload;

/**
 * ClassLoader implements a PSR-0, PSR-4 and classmap class loader.
 *
 *     $loader = new \Composer\Autoload\ClassLoader();
 *
 *     // register classes with namespaces
 *     $loader->add('Symfony\Component', __DIR__.'/component');
 *     $loader->add('Symfony',           __DIR__.'/framework');
 *
 *     // activate the autoloader
 *     $loader->register();
 *
 *     // to enable searching the include path (eg. for PEAR packages)
 *     $loader->setUseIncludePath(true);
 *
 * In this example, if you try to use a class in the Symfony\Component
 * namespace or one of its children (Symfony\Component\Console for instance),
 * the autoloader will first look for the class under the component/
 * directory, and it will then fallback to the framework/ directory if not
 * found before giving up.
 *
 * This class is loosely based on the Symfony UniversalClassLoader.
 *
 * @author Fabien Potencier <fabien@symfony.com>
 * @author Jordi Boggiano <j.boggiano@seld.be>
 * @see    https://www.php-fig.org/psr/psr-0/
 * @see    https://www.php-fig.org/psr/psr-4/
 */
class ClassLoader
{
    /** @var ?string */
    private $vendorDir;

    // PSR-4
    /**
     * @var array[]
     * @psalm-var array<string, array<string, int>>
     */
    private $prefixLengthsPsr4 = array();
    /**
     * @var array[]
     * @psalm-var array<string, array<int, string>>
     */
    private $prefixDirsPsr4 = array();
    /**
     * @var array[]
     * @psalm-var array<string, string>
     */
    private $fallbackDirsPsr4 = array();

    // PSR-0
    /**
     * @var array[]
     * @psalm-var array<string, array<string, string[]>>
     */
    private $prefixesPsr0 = array();
    /**
     * @var array[]
     * @psalm-var array<string, string>
     */
    private $fallbackDirsPsr0 = array();

    /** @var bool */
    private $useIncludePath = false;

    /**
     * @var string[]
     * @psalm-var array<string, string>
     */
    private $classMap = array();

    /** @var bool */
    private $classMapAuthoritative = false;

    /**
     * @var bool[]
     * @psalm-var array<string, bool>
     */
    private $missingClasses = array();

    /** @var ?string */
    private $apcuPrefix;

    /**
     * @var self[]
     */
    private static $registeredLoaders = array();

    /**
     * @param ?string $vendorDir
     */
    public function __construct($vendorDir = null)
    {
        $this->vendorDir = $vendorDir;
    }

    /**
     * @return string[]
     */
    public function getPrefixes()
    {
        if (!empty($this->prefixesPsr0)) {
            return call_user_func_array('array_merge', array_values($this->prefixesPsr0));
        }

        return array();
    }

    /**
     * @return array[]
     * @psalm-return array<string, array<int, string>>
     */
    public function getPrefixesPsr4()
    {
        return $this->prefixDirsPsr4;
    }

    /**
     * @return array[]
     * @psalm-return array<string, string>
     */
    public function getFallbackDirs()
    {
        return $this->fallbackDirsPsr0;
    }

    /**
     * @return array[]
     * @psalm-return array<string, string>
     */
    public function getFallbackDirsPsr4()
    {
        return $this->fallbackDirsPsr4;
    }

    /**
     * @return string[] Array of classname => path
     * @psalm-return array<string, string>
     */
    public function getClassMap()
    {
        return $this->classMap;
    }

    /**
     * @param string[] $classMap Class to filename map
     * @psalm-param array<string, string> $classMap
     *
     * @return void
     */
    public function addClassMap(array $classMap)
    {
        if ($this->classMap) {
            $this->classMap = array_merge($this->classMap, $classMap);
        } else {
            $this->classMap = $classMap;
        }
    }

    /**
     * Registers a set of PSR-0 directories for a given prefix, either
     * appending or prepending to the ones previously set for this prefix.
     *
     * @param string          $prefix  The prefix
     * @param string[]|string $paths   The PSR-0 root directories
     * @param bool            $prepend Whether to prepend the directories
     *
     * @return void
     */
    public function add($prefix, $paths, $prepend = false)
    {
        if (!$prefix) {
            if ($prepend) {
                $this->fallbackDirsPsr0 = array_merge(
                    (array) $paths,
                    $this->fallbackDirsPsr0
                );
            } else {
                $this->fallbackDirsPsr0 = array_merge(
                    $this->fallbackDirsPsr0,
                    (array) $paths
                );
            }

            return;
        }

        $first = $prefix[0];
        if (!isset($this->prefixesPsr0[$first][$prefix])) {
            $this->prefixesPsr0[$first][$prefix] = (array) $paths;

            return;
        }
        if ($prepend) {
            $this->prefixesPsr0[$first][$prefix] = array_merge(
                (array) $paths,
                $this->prefixesPsr0[$first][$prefix]
            );
        } else {
            $this->prefixesPsr0[$first][$prefix] = array_merge(
                $this->prefixesPsr0[$first][$prefix],
                (array) $paths
            );
        }
    }

    /**
     * Registers a set of PSR-4 directories for a given namespace, either
     * appending or prepending to the ones previously set for this namespace.
     *
     * @param string          $prefix  The prefix/namespace, with trailing '\\'
     * @param string[]|string $paths   The PSR-4 base directories
     * @param bool            $prepend Whether to prepend the directories
     *
     * @throws \InvalidArgumentException
     *
     * @return void
     */
    public function addPsr4($prefix, $paths, $prepend = false)
    {
        if (!$prefix) {
            // Register directories for the root namespace.
            if ($prepend) {
                $this->fallbackDirsPsr4 = array_merge(
                    (array) $paths,
                    $this->fallbackDirsPsr4
                );
            } else {
                $this->fallbackDirsPsr4 = array_merge(
                    $this->fallbackDirsPsr4,
                    (array) $paths
                );
            }
        } elseif (!isset($this->prefixDirsPsr4[$prefix])) {
            // Register directories for a new namespace.
            $length = strlen($prefix);
            if ('\\' !== $prefix[$length - 1]) {
                throw new \InvalidArgumentException("A non-empty PSR-4 prefix must end with a namespace separator.");
            }
            $this->prefixLengthsPsr4[$prefix[0]][$prefix] = $length;
            $this->prefixDirsPsr4[$prefix] = (array) $paths;
        } elseif ($prepend) {
            // Prepend directories for an already registered namespace.
            $this->prefixDirsPsr4[$prefix] = array_merge(
                (array) $paths,
                $this->prefixDirsPsr4[$prefix]
            );
        } else {
            // Append directories for an already registered namespace.
            $this->prefixDirsPsr4[$prefix] = array_merge(
                $this->prefixDirsPsr4[$prefix],
                (array) $paths
            );
        }
    }

    /**
     * Registers a set of PSR-0 directories for a given prefix,
     * replacing any others previously set for this prefix.
     *
     * @param string          $prefix The prefix
     * @param string[]|string $paths  The PSR-0 base directories
     *
     * @return void
     */
    public function set($prefix, $paths)
    {
        if (!$prefix) {
            $this->fallbackDirsPsr0 = (array) $paths;
        } else {
            $this->prefixesPsr0[$prefix[0]][$prefix] = (array) $paths;
        }
    }

    /**
     * Registers a set of PSR-4 directories for a given namespace,
     * replacing any others previously set for this namespace.
     *
     * @param string          $prefix The prefix/namespace, with trailing '\\'
     * @param string[]|string $paths  The PSR-4 base directories
     *
     * @throws \InvalidArgumentException
     *
     * @return void
     */
    public function setPsr4($prefix, $paths)
    {
        if (!$prefix) {
            $this->fallbackDirsPsr4 = (array) $paths;
        } else {
            $length = strlen($prefix);
            if ('\\' !== $prefix[$length - 1]) {
                throw new \InvalidArgumentException("A non-empty PSR-4 prefix must end with a namespace separator.");
            }
            $this->prefixLengthsPsr4[$prefix[0]][$prefix] = $length;
            $this->prefixDirsPsr4[$prefix] = (array) $paths;
        }
    }

    /**
     * Turns on searching the include path for class files.
     *
     * @param bool $useIncludePath
     *
     * @return void
     */
    public function setUseIncludePath($useIncludePath)
    {
        $this->useIncludePath = $useIncludePath;
    }

    /**
     * Can be used to check if the autoloader uses the include path to check
     * for classes.
     *
     * @return bool
     */
    public function getUseIncludePath()
    {
        return $this->useIncludePath;
    }

    /**
     * Turns off searching the prefix and fallback directories for classes
     * that have not been registered with the class map.
     *
     * @param bool $classMapAuthoritative
     *
     * @return void
     */
    public function setClassMapAuthoritative($classMapAuthoritative)
    {
        $this->classMapAuthoritative = $classMapAuthoritative;
    }

    /**
     * Should class lookup fail if not found in the current class map?
     *
     * @return bool
     */
    public function isClassMapAuthoritative()
    {
        return $this->classMapAuthoritative;
    }

    /**
     * APCu prefix to use to cache found/not-found classes, if the extension is enabled.
     *
     * @param string|null $apcuPrefix
     *
     * @return void
     */
    public function setApcuPrefix($apcuPrefix)
    {
        $this->apcuPrefix = function_exists('apcu_fetch') && filter_var(ini_get('apc.enabled'), FILTER_VALIDATE_BOOLEAN) ? $apcuPrefix : null;
    }

    /**
     * The APCu prefix in use, or null if APCu caching is not enabled.
     *
     * @return string|null
     */
    public function getApcuPrefix()
    {
        return $this->apcuPrefix;
    }

    /**
     * Registers this instance as an autoloader.
     *
     * @param bool $prepend Whether to prepend the autoloader or not
     *
     * @return void
     */
    public function register($prepend = false)
    {
        spl_autoload_register(array($this, 'loadClass'), true, $prepend);

        if (null === $this->vendorDir) {
            return;
        }

        if ($prepend) {
            self::$registeredLoaders = array($this->vendorDir => $this) + self::$registeredLoaders;
        } else {
            unset(self::$registeredLoaders[$this->vendorDir]);
            self::$registeredLoaders[$this->vendorDir] = $this;
        }
    }

    /**
     * Unregisters this instance as an autoloader.
     *
     * @return void
     */
    public function unregister()
    {
        spl_autoload_unregister(array($this, 'loadClass'));

        if (null !== $this->vendorDir) {
            unset(self::$registeredLoaders[$this->vendorDir]);
        }
    }

    /**
     * Loads the given class or interface.
     *
     * @param  string    $class The name of the class
     * @return true|null True if loaded, null otherwise
     */
    public function loadClass($class)
    {
        if ($file = $this->findFile($class)) {
            includeFile($file);

            return true;
        }

        return null;
    }

    /**
     * Finds the path to the file where the class is defined.
     *
     * @param string $class The name of the class
     *
     * @return string|false The path if found, false otherwise
     */
    public function findFile($class)
    {
        // class map lookup
        if (isset($this->classMap[$class])) {
            return $this->classMap[$class];
        }
        if ($this->classMapAuthoritative || isset($this->missingClasses[$class])) {
            return false;
        }
        if (null !== $this->apcuPrefix) {
            $file = apcu_fetch($this->apcuPrefix.$class, $hit);
            if ($hit) {
                return $file;
            }
        }

        $file = $this->findFileWithExtension($class, '.php');

        // Search for Hack files if we are running on HHVM
        if (false === $file && defined('HHVM_VERSION')) {
            $file = $this->findFileWithExtension($class, '.hh');
        }

        if (null !== $this->apcuPrefix) {
            apcu_add($this->apcuPrefix.$class, $file);
        }

        if (false === $file) {
            // Remember that this class does not exist.
            $this->missingClasses[$class] = true;
        }

        return $file;
    }

    /**
     * Returns the currently registered loaders indexed by their corresponding vendor directories.
     *
     * @return self[]
     */
    public static function getRegisteredLoaders()
    {
        return self::$registeredLoaders;
    }

    /**
     * @param  string       $class
     * @param  string       $ext
     * @return string|false
     */
    private function findFileWithExtension($class, $ext)
    {
        // PSR-4 lookup
        $logicalPathPsr4 = strtr($class, '\\', DIRECTORY_SEPARATOR) . $ext;

        $first = $class[0];
        if (isset($this->prefixLengthsPsr4[$first])) {
            $subPath = $class;
            while (false !== $lastPos = strrpos($subPath, '\\')) {
                $subPath = substr($subPath, 0, $lastPos);
                $search = $subPath . '\\';
                if (isset($this->prefixDirsPsr4[$search])) {
                    $pathEnd = DIRECTORY_SEPARATOR . substr($logicalPathPsr4, $lastPos + 1);
                    foreach ($this->prefixDirsPsr4[$search] as $dir) {
                        if (file_exists($file = $dir . $pathEnd)) {
                            return $file;
                        }
                    }
                }
            }
        }

        // PSR-4 fallback dirs
        foreach ($this->fallbackDirsPsr4 as $dir) {
            if (file_exists($file = $dir . DIRECTORY_SEPARATOR . $logicalPathPsr4)) {
                return $file;
            }
        }

        // PSR-0 lookup
        if (false !== $pos = strrpos($class, '\\')) {
            // namespaced class name
            $logicalPathPsr0 = substr($logicalPathPsr4, 0, $pos + 1)
                . strtr(substr($logicalPathPsr4, $pos + 1), '_', DIRECTORY_SEPARATOR);
        } else {
            // PEAR-like class name
            $logicalPathPsr0 = strtr($class, '_', DIRECTORY_SEPARATOR) . $ext;
        }

        if (isset($this->prefixesPsr0[$first])) {
            foreach ($this->prefixesPsr0[$first] as $prefix => $dirs) {
                if (0 === strpos($class, $prefix)) {
                    foreach ($dirs as $dir) {
                        if (file_exists($file = $dir . DIRECTORY_SEPARATOR . $logicalPathPsr0)) {
                            return $file;
                        }
                    }
                }
            }
        }

        // PSR-0 fallback dirs
        foreach ($this->fallbackDirsPsr0 as $dir) {
            if (file_exists($file = $dir . DIRECTORY_SEPARATOR . $logicalPathPsr0)) {
                return $file;
            }
        }

        // PSR-0 include paths.
        if ($this->useIncludePath && $file = stream_resolve_include_path($logicalPathPsr0)) {
            return $file;
        }

        return false;
    }
}

/**
 * Scope isolated include.
 *
 * Prevents access to $this/self from included files.
 *
 * @param  string $file
 * @return void
 * @private
 */
function includeFile($file)
{
    include $file;
}
<?php

// autoload_psr4.php @generated by Composer

$vendorDir = dirname(dirname(__FILE__));
$baseDir = dirname($vendorDir);

return array(
    'HumbugBox3150\\KevinGH\\RequirementChecker\\' => array($baseDir . '/src'),
    'HumbugBox3150\\Composer\\Semver\\' => array($vendorDir . '/composer/semver/src'),
);
<?php

// autoload_classmap.php @generated by Composer

$vendorDir = dirname(dirname(__FILE__));
$baseDir = dirname($vendorDir);

return array(
    'Composer\\InstalledVersions' => $vendorDir . '/composer/InstalledVersions.php',
    'HumbugBox3150\\Composer\\Semver\\Comparator' => $vendorDir . '/composer/semver/src/Comparator.php',
    'HumbugBox3150\\Composer\\Semver\\CompilingMatcher' => $vendorDir . '/composer/semver/src/CompilingMatcher.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\Bound' => $vendorDir . '/composer/semver/src/Constraint/Bound.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\Constraint' => $vendorDir . '/composer/semver/src/Constraint/Constraint.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\ConstraintInterface' => $vendorDir . '/composer/semver/src/Constraint/ConstraintInterface.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchAllConstraint' => $vendorDir . '/composer/semver/src/Constraint/MatchAllConstraint.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchNoneConstraint' => $vendorDir . '/composer/semver/src/Constraint/MatchNoneConstraint.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\MultiConstraint' => $vendorDir . '/composer/semver/src/Constraint/MultiConstraint.php',
    'HumbugBox3150\\Composer\\Semver\\Interval' => $vendorDir . '/composer/semver/src/Interval.php',
    'HumbugBox3150\\Composer\\Semver\\Intervals' => $vendorDir . '/composer/semver/src/Intervals.php',
    'HumbugBox3150\\Composer\\Semver\\Semver' => $vendorDir . '/composer/semver/src/Semver.php',
    'HumbugBox3150\\Composer\\Semver\\VersionParser' => $vendorDir . '/composer/semver/src/VersionParser.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Checker' => $baseDir . '/src/Checker.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IO' => $baseDir . '/src/IO.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IsExtensionFulfilled' => $baseDir . '/src/IsExtensionFulfilled.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IsFulfilled' => $baseDir . '/src/IsFulfilled.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IsPhpVersionFulfilled' => $baseDir . '/src/IsPhpVersionFulfilled.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Printer' => $baseDir . '/src/Printer.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Requirement' => $baseDir . '/src/Requirement.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\RequirementCollection' => $baseDir . '/src/RequirementCollection.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Terminal' => $baseDir . '/src/Terminal.php',
);
<?php

// autoload_static.php @generated by Composer

namespace Composer\Autoload;

class ComposerStaticInit7b1918d23e69dc64db20ca1f98396893
{
    public static $prefixLengthsPsr4 = array (
        'H' => 
        array (
            'HumbugBox3150\\KevinGH\\RequirementChecker\\' => 41,
            'HumbugBox3150\\Composer\\Semver\\' => 30,
        ),
    );

    public static $prefixDirsPsr4 = array (
        'HumbugBox3150\\KevinGH\\RequirementChecker\\' => 
        array (
            0 => __DIR__ . '/../..' . '/src',
        ),
        'HumbugBox3150\\Composer\\Semver\\' => 
        array (
            0 => __DIR__ . '/..' . '/composer/semver/src',
        ),
    );

    public static $classMap = array (
        'Composer\\InstalledVersions' => __DIR__ . '/..' . '/composer/InstalledVersions.php',
        'HumbugBox3150\\Composer\\Semver\\Comparator' => __DIR__ . '/..' . '/composer/semver/src/Comparator.php',
        'HumbugBox3150\\Composer\\Semver\\CompilingMatcher' => __DIR__ . '/..' . '/composer/semver/src/CompilingMatcher.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\Bound' => __DIR__ . '/..' . '/composer/semver/src/Constraint/Bound.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\Constraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/Constraint.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\ConstraintInterface' => __DIR__ . '/..' . '/composer/semver/src/Constraint/ConstraintInterface.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchAllConstraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/MatchAllConstraint.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchNoneConstraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/MatchNoneConstraint.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\MultiConstraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/MultiConstraint.php',
        'HumbugBox3150\\Composer\\Semver\\Interval' => __DIR__ . '/..' . '/composer/semver/src/Interval.php',
        'HumbugBox3150\\Composer\\Semver\\Intervals' => __DIR__ . '/..' . '/composer/semver/src/Intervals.php',
        'HumbugBox3150\\Composer\\Semver\\Semver' => __DIR__ . '/..' . '/composer/semver/src/Semver.php',
        'HumbugBox3150\\Composer\\Semver\\VersionParser' => __DIR__ . '/..' . '/composer/semver/src/VersionParser.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Checker' => __DIR__ . '/../..' . '/src/Checker.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IO' => __DIR__ . '/../..' . '/src/IO.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IsExtensionFulfilled' => __DIR__ . '/../..' . '/src/IsExtensionFulfilled.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IsFulfilled' => __DIR__ . '/../..' . '/src/IsFulfilled.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IsPhpVersionFulfilled' => __DIR__ . '/../..' . '/src/IsPhpVersionFulfilled.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Printer' => __DIR__ . '/../..' . '/src/Printer.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Requirement' => __DIR__ . '/../..' . '/src/Requirement.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\RequirementCollection' => __DIR__ . '/../..' . '/src/RequirementCollection.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Terminal' => __DIR__ . '/../..' . '/src/Terminal.php',
    );

    public static function getInitializer(ClassLoader $loader)
    {
        return \Closure::bind(function () use ($loader) {
            $loader->prefixLengthsPsr4 = ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::$prefixLengthsPsr4;
            $loader->prefixDirsPsr4 = ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::$prefixDirsPsr4;
            $loader->classMap = ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::$classMap;

        }, null, ClassLoader::class);
    }
}
<?php

// autoload_real.php @generated by Composer

class ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893
{
    private static $loader;

    public static function loadClassLoader($class)
    {
        if ('Composer\Autoload\ClassLoader' === $class) {
            require __DIR__ . '/ClassLoader.php';
        }
    }

    /**
     * @return \Composer\Autoload\ClassLoader
     */
    public static function getLoader()
    {
        if (null !== self::$loader) {
            return self::$loader;
        }

        spl_autoload_register(array('ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893', 'loadClassLoader'), true, true);
        self::$loader = $loader = new \Composer\Autoload\ClassLoader(\dirname(\dirname(__FILE__)));
        spl_autoload_unregister(array('ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893', 'loadClassLoader'));

        $useStaticLoader = PHP_VERSION_ID >= 50600 && !defined('HHVM_VERSION') && (!function_exists('zend_loader_file_encoded') || !zend_loader_file_encoded());
        if ($useStaticLoader) {
            require __DIR__ . '/autoload_static.php';

            call_user_func(\Composer\Autoload\ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::getInitializer($loader));
        } else {
            $classMap = require __DIR__ . '/autoload_classmap.php';
            if ($classMap) {
                $loader->addClassMap($classMap);
            }
        }

        $loader->setClassMapAuthoritative(true);
        $loader->register(true);

        return $loader;
    }
}
<?php

namespace HumbugBox3150\Composer\Semver;

use HumbugBox3150\Composer\Semver\Constraint\Constraint;
class Comparator
{
    public static function greaterThan($version1, $version2)
    {
        return self::compare($version1, '>', $version2);
    }
    public static function greaterThanOrEqualTo($version1, $version2)
    {
        return self::compare($version1, '>=', $version2);
    }
    public static function lessThan($version1, $version2)
    {
        return self::compare($version1, '<', $version2);
    }
    public static function lessThanOrEqualTo($version1, $version2)
    {
        return self::compare($version1, '<=', $version2);
    }
    public static function equalTo($version1, $version2)
    {
        return self::compare($version1, '==', $version2);
    }
    public static function notEqualTo($version1, $version2)
    {
        return self::compare($version1, '!=', $version2);
    }
    public static function compare($version1, $operator, $version2)
    {
        $constraint = new Constraint($operator, $version2);
        return $constraint->matchSpecific(new Constraint('==', $version1), \true);
    }
}
<?php

namespace HumbugBox3150\Composer\Semver;

use HumbugBox3150\Composer\Semver\Constraint\Constraint;
class Semver
{
    const SORT_ASC = 1;
    const SORT_DESC = -1;
    private static $versionParser;
    public static function satisfies($version, $constraints)
    {
        if (null === self::$versionParser) {
            self::$versionParser = new VersionParser();
        }
        $versionParser = self::$versionParser;
        $provider = new Constraint('==', $versionParser->normalize($version));
        $parsedConstraints = $versionParser->parseConstraints($constraints);
        return $parsedConstraints->matches($provider);
    }
    public static function satisfiedBy(array $versions, $constraints)
    {
        $versions = \array_filter($versions, function ($version) use($constraints) {
            return Semver::satisfies($version, $constraints);
        });
        return \array_values($versions);
    }
    public static function sort(array $versions)
    {
        return self::usort($versions, self::SORT_ASC);
    }
    public static function rsort(array $versions)
    {
        return self::usort($versions, self::SORT_DESC);
    }
    private static function usort(array $versions, $direction)
    {
        if (null === self::$versionParser) {
            self::$versionParser = new VersionParser();
        }
        $versionParser = self::$versionParser;
        $normalized = array();
        foreach ($versions as $key => $version) {
            $normalizedVersion = $versionParser->normalize($version);
            $normalizedVersion = $versionParser->normalizeDefaultBranch($normalizedVersion);
            $normalized[] = array($normalizedVersion, $key);
        }
        \usort($normalized, function (array $left, array $right) use($direction) {
            if ($left[0] === $right[0]) {
                return 0;
            }
            if (Comparator::lessThan($left[0], $right[0])) {
                return -$direction;
            }
            return $direction;
        });
        $sorted = array();
        foreach ($normalized as $item) {
            $sorted[] = $versions[$item[1]];
        }
        return $sorted;
    }
}
<?php

namespace HumbugBox3150\Composer\Semver;

use HumbugBox3150\Composer\Semver\Constraint\ConstraintInterface;
use HumbugBox3150\Composer\Semver\Constraint\MatchAllConstraint;
use HumbugBox3150\Composer\Semver\Constraint\MultiConstraint;
use HumbugBox3150\Composer\Semver\Constraint\Constraint;
class VersionParser
{
    private static $modifierRegex = '[._-]?(?:(stable|beta|b|RC|alpha|a|patch|pl|p)((?:[.-]?\\d+)*+)?)?([.-]?dev)?';
    private static $stabilitiesRegex = 'stable|RC|beta|alpha|dev';
    public static function parseStability($version)
    {
        $version = \preg_replace('{#.+$}i', '', $version);
        if (\strpos($version, 'dev-') === 0 || '-dev' === \substr($version, -4)) {
            return 'dev';
        }
        \preg_match('{' . self::$modifierRegex . '(?:\\+.*)?$}i', \strtolower($version), $match);
        if (!empty($match[3])) {
            return 'dev';
        }
        if (!empty($match[1])) {
            if ('beta' === $match[1] || 'b' === $match[1]) {
                return 'beta';
            }
            if ('alpha' === $match[1] || 'a' === $match[1]) {
                return 'alpha';
            }
            if ('rc' === $match[1]) {
                return 'RC';
            }
        }
        return 'stable';
    }
    public static function normalizeStability($stability)
    {
        $stability = \strtolower($stability);
        return $stability === 'rc' ? 'RC' : $stability;
    }
    public function normalize($version, $fullVersion = null)
    {
        $version = \trim($version);
        $origVersion = $version;
        if (null === $fullVersion) {
            $fullVersion = $version;
        }
        if (\preg_match('{^([^,\\s]++) ++as ++([^,\\s]++)$}', $version, $match)) {
            $version = $match[1];
        }
        if (\preg_match('{@(?:' . self::$stabilitiesRegex . ')$}i', $version, $match)) {
            $version = \substr($version, 0, \strlen($version) - \strlen($match[0]));
        }
        if (\in_array($version, array('master', 'trunk', 'default'), \true)) {
            $version = 'dev-' . $version;
        }
        if (\stripos($version, 'dev-') === 0) {
            return 'dev-' . \substr($version, 4);
        }
        if (\preg_match('{^([^,\\s+]++)\\+[^\\s]++$}', $version, $match)) {
            $version = $match[1];
        }
        if (\preg_match('{^v?(\\d{1,5})(\\.\\d++)?(\\.\\d++)?(\\.\\d++)?' . self::$modifierRegex . '$}i', $version, $matches)) {
            $version = $matches[1] . (!empty($matches[2]) ? $matches[2] : '.0') . (!empty($matches[3]) ? $matches[3] : '.0') . (!empty($matches[4]) ? $matches[4] : '.0');
            $index = 5;
        } elseif (\preg_match('{^v?(\\d{4}(?:[.:-]?\\d{2}){1,6}(?:[.:-]?\\d{1,3})?)' . self::$modifierRegex . '$}i', $version, $matches)) {
            $version = \preg_replace('{\\D}', '.', $matches[1]);
            $index = 2;
        }
        if (isset($index)) {
            if (!empty($matches[$index])) {
                if ('stable' === $matches[$index]) {
                    return $version;
                }
                $version .= '-' . $this->expandStability($matches[$index]) . (!empty($matches[$index + 1]) ? \ltrim($matches[$index + 1], '.-') : '');
            }
            if (!empty($matches[$index + 2])) {
                $version .= '-dev';
            }
            return $version;
        }
        if (\preg_match('{(.*?)[.-]?dev$}i', $version, $match)) {
            try {
                $normalized = $this->normalizeBranch($match[1]);
                if (\strpos($normalized, 'dev-') === \false) {
                    return $normalized;
                }
            } catch (\Exception $e) {
            }
        }
        $extraMessage = '';
        if (\preg_match('{ +as +' . \preg_quote($version) . '(?:@(?:' . self::$stabilitiesRegex . '))?$}', $fullVersion)) {
            $extraMessage = ' in "' . $fullVersion . '", the alias must be an exact version';
        } elseif (\preg_match('{^' . \preg_quote($version) . '(?:@(?:' . self::$stabilitiesRegex . '))? +as +}', $fullVersion)) {
            $extraMessage = ' in "' . $fullVersion . '", the alias source must be an exact version, if it is a branch name you should prefix it with dev-';
        }
        throw new \UnexpectedValueException('Invalid version string "' . $origVersion . '"' . $extraMessage);
    }
    public function parseNumericAliasPrefix($branch)
    {
        if (\preg_match('{^(?P<version>(\\d++\\.)*\\d++)(?:\\.x)?-dev$}i', $branch, $matches)) {
            return $matches['version'] . '.';
        }
        return \false;
    }
    public function normalizeBranch($name)
    {
        $name = \trim($name);
        if (\preg_match('{^v?(\\d++)(\\.(?:\\d++|[xX*]))?(\\.(?:\\d++|[xX*]))?(\\.(?:\\d++|[xX*]))?$}i', $name, $matches)) {
            $version = '';
            for ($i = 1; $i < 5; ++$i) {
                $version .= isset($matches[$i]) ? \str_replace(array('*', 'X'), 'x', $matches[$i]) : '.x';
            }
            return \str_replace('x', '9999999', $version) . '-dev';
        }
        return 'dev-' . $name;
    }
    public function normalizeDefaultBranch($name)
    {
        if ($name === 'dev-master' || $name === 'dev-default' || $name === 'dev-trunk') {
            return '9999999-dev';
        }
        return $name;
    }
    public function parseConstraints($constraints)
    {
        $prettyConstraint = $constraints;
        $orConstraints = \preg_split('{\\s*\\|\\|?\\s*}', \trim($constraints));
        $orGroups = array();
        foreach ($orConstraints as $constraints) {
            $andConstraints = \preg_split('{(?<!^|as|[=>< ,]) *(?<!-)[, ](?!-) *(?!,|as|$)}', $constraints);
            if (\count($andConstraints) > 1) {
                $constraintObjects = array();
                foreach ($andConstraints as $constraint) {
                    foreach ($this->parseConstraint($constraint) as $parsedConstraint) {
                        $constraintObjects[] = $parsedConstraint;
                    }
                }
            } else {
                $constraintObjects = $this->parseConstraint($andConstraints[0]);
            }
            if (1 === \count($constraintObjects)) {
                $constraint = $constraintObjects[0];
            } else {
                $constraint = new MultiConstraint($constraintObjects);
            }
            $orGroups[] = $constraint;
        }
        $constraint = MultiConstraint::create($orGroups, \false);
        $constraint->setPrettyString($prettyConstraint);
        return $constraint;
    }
    private function parseConstraint($constraint)
    {
        if (\preg_match('{^([^,\\s]++) ++as ++([^,\\s]++)$}', $constraint, $match)) {
            $constraint = $match[1];
        }
        if (\preg_match('{^([^,\\s]*?)@(' . self::$stabilitiesRegex . ')$}i', $constraint, $match)) {
            $constraint = '' !== $match[1] ? $match[1] : '*';
            if ($match[2] !== 'stable') {
                $stabilityModifier = $match[2];
            }
        }
        if (\preg_match('{^(dev-[^,\\s@]+?|[^,\\s@]+?\\.x-dev)#.+$}i', $constraint, $match)) {
            $constraint = $match[1];
        }
        if (\preg_match('{^(v)?[xX*](\\.[xX*])*$}i', $constraint, $match)) {
            if (!empty($match[1]) || !empty($match[2])) {
                return array(new Constraint('>=', '0.0.0.0-dev'));
            }
            return array(new MatchAllConstraint());
        }
        $versionRegex = 'v?(\\d++)(?:\\.(\\d++|[xX*]))?(?:\\.(\\d++|[xX*]))?(?:\\.(\\d++|[xX*]))?' . self::$modifierRegex . '(?:\\+[^\\s]+)?';
        if (\preg_match('{^~>?' . $versionRegex . '$}i', $constraint, $matches)) {
            if (\strpos($constraint, '~>') === 0) {
                throw new \UnexpectedValueException('Could not parse version constraint ' . $constraint . ': ' . 'Invalid operator "~>", you probably meant to use the "~" operator');
            }
            if (isset($matches[4]) && '' !== $matches[4] && null !== $matches[4]) {
                $position = 4;
            } elseif (isset($matches[3]) && '' !== $matches[3] && null !== $matches[3]) {
                $position = 3;
            } elseif (isset($matches[2]) && '' !== $matches[2] && null !== $matches[2]) {
                $position = 2;
            } else {
                $position = 1;
            }
            for ($i = $position; $i >= 0; $i--) {
                if ($matches[$i] === 'x' || $matches[$i] === 'X' || $matches[$i] === '*') {
                    $matches[$i] = '9999999';
                }
            }
            $stabilitySuffix = '';
            if (empty($matches[5]) && empty($matches[7])) {
                $stabilitySuffix .= '-dev';
            }
            $lowVersion = $this->normalize(\substr($constraint . $stabilitySuffix, 1));
            $lowerBound = new Constraint('>=', $lowVersion);
            $highPosition = \max(1, $position - 1);
            $highVersion = $this->manipulateVersionString($matches, $highPosition, 1) . '-dev';
            $upperBound = new Constraint('<', $highVersion);
            return array($lowerBound, $upperBound);
        }
        if (\preg_match('{^\\^' . $versionRegex . '($)}i', $constraint, $matches)) {
            if ('0' !== $matches[1] || '' === $matches[2] || null === $matches[2]) {
                $position = 1;
            } elseif ('0' !== $matches[2] || '' === $matches[3] || null === $matches[3]) {
                $position = 2;
            } else {
                $position = 3;
            }
            if ($position === 2 && ($matches[2] === 'x' || $matches[2] === 'X' || $matches[2] === '*')) {
                $position = 1;
            }
            $stabilitySuffix = '';
            if (empty($matches[5]) && empty($matches[7])) {
                $stabilitySuffix .= '-dev';
            }
            $lowVersion = $this->normalize(\substr($constraint . $stabilitySuffix, 1));
            $lowerBound = new Constraint('>=', $lowVersion);
            $highVersion = $this->manipulateVersionString($matches, $position, 1) . '-dev';
            $upperBound = new Constraint('<', $highVersion);
            return array($lowerBound, $upperBound);
        }
        if (\preg_match('{^v?(\\d++)(?:\\.(\\d++))?(?:\\.(\\d++))?(?:\\.[xX*])++$}', $constraint, $matches)) {
            if (isset($matches[3]) && '' !== $matches[3] && null !== $matches[3]) {
                $position = 3;
            } elseif (isset($matches[2]) && '' !== $matches[2] && null !== $matches[2]) {
                $position = 2;
            } else {
                $position = 1;
            }
            $lowVersion = $this->manipulateVersionString($matches, $position) . '-dev';
            $highVersion = $this->manipulateVersionString($matches, $position, 1) . '-dev';
            if ($lowVersion === '0.0.0.0-dev') {
                return array(new Constraint('<', $highVersion));
            }
            return array(new Constraint('>=', $lowVersion), new Constraint('<', $highVersion));
        }
        if (\preg_match('{^(?P<from>' . $versionRegex . ') +- +(?P<to>' . $versionRegex . ')($)}i', $constraint, $matches)) {
            $lowStabilitySuffix = '';
            if (empty($matches[6]) && empty($matches[8])) {
                $lowStabilitySuffix = '-dev';
            }
            $lowVersion = $this->normalize($matches['from']);
            $lowerBound = new Constraint('>=', $lowVersion . $lowStabilitySuffix);
            $empty = function ($x) {
                return $x === 0 || $x === '0' ? \false : empty($x);
            };
            if (!$empty($matches[11]) && !$empty($matches[12]) || !empty($matches[14]) || !empty($matches[16])) {
                $highVersion = $this->normalize($matches['to']);
                $upperBound = new Constraint('<=', $highVersion);
            } else {
                $highMatch = array('', $matches[10], $matches[11], $matches[12], $matches[13]);
                $this->normalize($matches['to']);
                $highVersion = $this->manipulateVersionString($highMatch, $empty($matches[11]) ? 1 : 2, 1) . '-dev';
                $upperBound = new Constraint('<', $highVersion);
            }
            return array($lowerBound, $upperBound);
        }
        if (\preg_match('{^(<>|!=|>=?|<=?|==?)?\\s*(.*)}', $constraint, $matches)) {
            try {
                try {
                    $version = $this->normalize($matches[2]);
                } catch (\UnexpectedValueException $e) {
                    if (\substr($matches[2], -4) === '-dev') {
                        $version = $this->normalize('dev-' . \substr($matches[2], 0, -4));
                    } else {
                        throw $e;
                    }
                }
                $op = $matches[1] ?: '=';
                if ($op !== '==' && $op !== '=' && !empty($stabilityModifier) && self::parseStability($version) === 'stable') {
                    $version .= '-' . $stabilityModifier;
                } elseif ('<' === $op || '>=' === $op) {
                    if (!\preg_match('/-' . self::$modifierRegex . '$/', \strtolower($matches[2]))) {
                        if (\strpos($matches[2], 'dev-') !== 0) {
                            $version .= '-dev';
                        }
                    }
                }
                return array(new Constraint($matches[1] ?: '=', $version));
            } catch (\Exception $e) {
            }
        }
        $message = 'Could not parse version constraint ' . $constraint;
        if (isset($e)) {
            $message .= ': ' . $e->getMessage();
        }
        throw new \UnexpectedValueException($message);
    }
    private function manipulateVersionString($matches, $position, $increment = 0, $pad = '0')
    {
        for ($i = 4; $i > 0; --$i) {
            if ($i > $position) {
                $matches[$i] = $pad;
            } elseif ($i === $position && $increment) {
                $matches[$i] += $increment;
                if ($matches[$i] < 0) {
                    $matches[$i] = $pad;
                    --$position;
                    if ($i === 1) {
                        return null;
                    }
                }
            }
        }
        return $matches[1] . '.' . $matches[2] . '.' . $matches[3] . '.' . $matches[4];
    }
    private function expandStability($stability)
    {
        $stability = \strtolower($stability);
        switch ($stability) {
            case 'a':
                return 'alpha';
            case 'b':
                return 'beta';
            case 'p':
            case 'pl':
                return 'patch';
            case 'rc':
                return 'RC';
            default:
                return $stability;
        }
    }
}
<?php

namespace HumbugBox3150\Composer\Semver\Constraint;

interface ConstraintInterface
{
    public function matches(ConstraintInterface $provider);
    public function compile($operator);
    public function getUpperBound();
    public function getLowerBound();
    public function getPrettyString();
    public function setPrettyString($prettyString);
    public function __toString();
}
<?php

namespace HumbugBox3150\Composer\Semver\Constraint;

class MultiConstraint implements ConstraintInterface
{
    protected $constraints;
    protected $prettyString;
    protected $string;
    protected $conjunctive;
    protected $lowerBound;
    protected $upperBound;
    public function __construct(array $constraints, $conjunctive = \true)
    {
        if (\count($constraints) < 2) {
            throw new \InvalidArgumentException('Must provide at least two constraints for a MultiConstraint. Use ' . 'the regular Constraint class for one constraint only or MatchAllConstraint for none. You may use ' . 'MultiConstraint::create() which optimizes and handles those cases automatically.');
        }
        $this->constraints = $constraints;
        $this->conjunctive = $conjunctive;
    }
    public function getConstraints()
    {
        return $this->constraints;
    }
    public function isConjunctive()
    {
        return $this->conjunctive;
    }
    public function isDisjunctive()
    {
        return !$this->conjunctive;
    }
    public function compile($otherOperator)
    {
        $parts = array();
        foreach ($this->constraints as $constraint) {
            $code = $constraint->compile($otherOperator);
            if ($code === 'true') {
                if (!$this->conjunctive) {
                    return 'true';
                }
            } elseif ($code === 'false') {
                if ($this->conjunctive) {
                    return 'false';
                }
            } else {
                $parts[] = '(' . $code . ')';
            }
        }
        if (!$parts) {
            return $this->conjunctive ? 'true' : 'false';
        }
        return $this->conjunctive ? \implode('&&', $parts) : \implode('||', $parts);
    }
    public function matches(ConstraintInterface $provider)
    {
        if (\false === $this->conjunctive) {
            foreach ($this->constraints as $constraint) {
                if ($provider->matches($constraint)) {
                    return \true;
                }
            }
            return \false;
        }
        foreach ($this->constraints as $constraint) {
            if (!$provider->matches($constraint)) {
                return \false;
            }
        }
        return \true;
    }
    public function setPrettyString($prettyString)
    {
        $this->prettyString = $prettyString;
    }
    public function getPrettyString()
    {
        if ($this->prettyString) {
            return $this->prettyString;
        }
        return (string) $this;
    }
    public function __toString()
    {
        if ($this->string !== null) {
            return $this->string;
        }
        $constraints = array();
        foreach ($this->constraints as $constraint) {
            $constraints[] = (string) $constraint;
        }
        return $this->string = '[' . \implode($this->conjunctive ? ' ' : ' || ', $constraints) . ']';
    }
    public function getLowerBound()
    {
        $this->extractBounds();
        return $this->lowerBound;
    }
    public function getUpperBound()
    {
        $this->extractBounds();
        return $this->upperBound;
    }
    public static function create(array $constraints, $conjunctive = \true)
    {
        if (0 === \count($constraints)) {
            return new MatchAllConstraint();
        }
        if (1 === \count($constraints)) {
            return $constraints[0];
        }
        $optimized = self::optimizeConstraints($constraints, $conjunctive);
        if ($optimized !== null) {
            list($constraints, $conjunctive) = $optimized;
            if (\count($constraints) === 1) {
                return $constraints[0];
            }
        }
        return new self($constraints, $conjunctive);
    }
    private static function optimizeConstraints(array $constraints, $conjunctive)
    {
        if (!$conjunctive) {
            $left = $constraints[0];
            $mergedConstraints = array();
            $optimized = \false;
            for ($i = 1, $l = \count($constraints); $i < $l; $i++) {
                $right = $constraints[$i];
                if ($left instanceof MultiConstraint && $left->conjunctive && $right instanceof MultiConstraint && $right->conjunctive && ($left0 = (string) $left->constraints[0]) && $left0[0] === '>' && $left0[1] === '=' && ($left1 = (string) $left->constraints[1]) && $left1[0] === '<' && ($right0 = (string) $right->constraints[0]) && $right0[0] === '>' && $right0[1] === '=' && ($right1 = (string) $right->constraints[1]) && $right1[0] === '<' && \substr($left1, 2) === \substr($right0, 3)) {
                    $optimized = \true;
                    $left = new MultiConstraint(\array_merge(array($left->constraints[0], $right->constraints[1]), \array_slice($left->constraints, 2), \array_slice($right->constraints, 2)), \true);
                } else {
                    $mergedConstraints[] = $left;
                    $left = $right;
                }
            }
            if ($optimized) {
                $mergedConstraints[] = $left;
                return array($mergedConstraints, \false);
            }
        }
        return null;
    }
    private function extractBounds()
    {
        if (null !== $this->lowerBound) {
            return;
        }
        foreach ($this->constraints as $constraint) {
            if (null === $this->lowerBound && null === $this->upperBound) {
                $this->lowerBound = $constraint->getLowerBound();
                $this->upperBound = $constraint->getUpperBound();
                continue;
            }
            if ($constraint->getLowerBound()->compareTo($this->lowerBound, $this->isConjunctive() ? '>' : '<')) {
                $this->lowerBound = $constraint->getLowerBound();
            }
            if ($constraint->getUpperBound()->compareTo($this->upperBound, $this->isConjunctive() ? '<' : '>')) {
                $this->upperBound = $constraint->getUpperBound();
            }
        }
    }
}
<?php

namespace HumbugBox3150\Composer\Semver\Constraint;

class Constraint implements ConstraintInterface
{
    const OP_EQ = 0;
    const OP_LT = 1;
    const OP_LE = 2;
    const OP_GT = 3;
    const OP_GE = 4;
    const OP_NE = 5;
    /**
    @phpstan-var
    */
    private static $transOpStr = array('=' => self::OP_EQ, '==' => self::OP_EQ, '<' => self::OP_LT, '<=' => self::OP_LE, '>' => self::OP_GT, '>=' => self::OP_GE, '<>' => self::OP_NE, '!=' => self::OP_NE);
    /**
    @phpstan-var
    */
    private static $transOpInt = array(self::OP_EQ => '==', self::OP_LT => '<', self::OP_LE => '<=', self::OP_GT => '>', self::OP_GE => '>=', self::OP_NE => '!=');
    /**
    @phpstan-var
    */
    protected $operator;
    protected $version;
    protected $prettyString;
    protected $lowerBound;
    protected $upperBound;
    public function __construct($operator, $version)
    {
        if (!isset(self::$transOpStr[$operator])) {
            throw new \InvalidArgumentException(\sprintf('Invalid operator "%s" given, expected one of: %s', $operator, \implode(', ', self::getSupportedOperators())));
        }
        $this->operator = self::$transOpStr[$operator];
        $this->version = $version;
    }
    public function getVersion()
    {
        return $this->version;
    }
    public function getOperator()
    {
        return self::$transOpInt[$this->operator];
    }
    public function matches(ConstraintInterface $provider)
    {
        if ($provider instanceof self) {
            return $this->matchSpecific($provider);
        }
        return $provider->matches($this);
    }
    public function setPrettyString($prettyString)
    {
        $this->prettyString = $prettyString;
    }
    public function getPrettyString()
    {
        if ($this->prettyString) {
            return $this->prettyString;
        }
        return $this->__toString();
    }
    public static function getSupportedOperators()
    {
        return \array_keys(self::$transOpStr);
    }
    /**
    @phpstan-return
    */
    public static function getOperatorConstant($operator)
    {
        return self::$transOpStr[$operator];
    }
    public function versionCompare($a, $b, $operator, $compareBranches = \false)
    {
        if (!isset(self::$transOpStr[$operator])) {
            throw new \InvalidArgumentException(\sprintf('Invalid operator "%s" given, expected one of: %s', $operator, \implode(', ', self::getSupportedOperators())));
        }
        $aIsBranch = 'dev-' === \substr($a, 0, 4);
        $bIsBranch = 'dev-' === \substr($b, 0, 4);
        if ($operator === '!=' && ($aIsBranch || $bIsBranch)) {
            return $a !== $b;
        }
        if ($aIsBranch && $bIsBranch) {
            return $operator === '==' && $a === $b;
        }
        if (!$compareBranches && ($aIsBranch || $bIsBranch)) {
            return \false;
        }
        return \version_compare($a, $b, $operator);
    }
    public function compile($otherOperator)
    {
        if ($this->version[0] === 'd' && 'dev-' === \substr($this->version, 0, 4)) {
            if (self::OP_EQ === $this->operator) {
                if (self::OP_EQ === $otherOperator) {
                    return \sprintf('$b && $v === %s', \var_export($this->version, \true));
                }
                if (self::OP_NE === $otherOperator) {
                    return \sprintf('!$b || $v !== %s', \var_export($this->version, \true));
                }
                return 'false';
            }
            if (self::OP_NE === $this->operator) {
                if (self::OP_EQ === $otherOperator) {
                    return \sprintf('!$b || $v !== %s', \var_export($this->version, \true));
                }
                if (self::OP_NE === $otherOperator) {
                    return 'true';
                }
                return '!$b';
            }
            return 'false';
        }
        if (self::OP_EQ === $this->operator) {
            if (self::OP_EQ === $otherOperator) {
                return \sprintf('\\version_compare($v, %s, \'==\')', \var_export($this->version, \true));
            }
            if (self::OP_NE === $otherOperator) {
                return \sprintf('$b || \\version_compare($v, %s, \'!=\')', \var_export($this->version, \true));
            }
            return \sprintf('!$b && \\version_compare(%s, $v, \'%s\')', \var_export($this->version, \true), self::$transOpInt[$otherOperator]);
        }
        if (self::OP_NE === $this->operator) {
            if (self::OP_EQ === $otherOperator) {
                return \sprintf('$b || (!$b && \\version_compare($v, %s, \'!=\'))', \var_export($this->version, \true));
            }
            if (self::OP_NE === $otherOperator) {
                return 'true';
            }
            return '!$b';
        }
        if (self::OP_LT === $this->operator || self::OP_LE === $this->operator) {
            if (self::OP_LT === $otherOperator || self::OP_LE === $otherOperator) {
                return '!$b';
            }
        } elseif (self::OP_GT === $this->operator || self::OP_GE === $this->operator) {
            if (self::OP_GT === $otherOperator || self::OP_GE === $otherOperator) {
                return '!$b';
            }
        }
        if (self::OP_NE === $otherOperator) {
            return 'true';
        }
        $codeComparison = \sprintf('\\version_compare($v, %s, \'%s\')', \var_export($this->version, \true), self::$transOpInt[$this->operator]);
        if ($this->operator === self::OP_LE) {
            if ($otherOperator === self::OP_GT) {
                return \sprintf('!$b && \\version_compare($v, %s, \'!=\') && ', \var_export($this->version, \true)) . $codeComparison;
            }
        } elseif ($this->operator === self::OP_GE) {
            if ($otherOperator === self::OP_LT) {
                return \sprintf('!$b && \\version_compare($v, %s, \'!=\') && ', \var_export($this->version, \true)) . $codeComparison;
            }
        }
        return \sprintf('!$b && %s', $codeComparison);
    }
    public function matchSpecific(Constraint $provider, $compareBranches = \false)
    {
        $noEqualOp = \str_replace('=', '', self::$transOpInt[$this->operator]);
        $providerNoEqualOp = \str_replace('=', '', self::$transOpInt[$provider->operator]);
        $isEqualOp = self::OP_EQ === $this->operator;
        $isNonEqualOp = self::OP_NE === $this->operator;
        $isProviderEqualOp = self::OP_EQ === $provider->operator;
        $isProviderNonEqualOp = self::OP_NE === $provider->operator;
        if ($isNonEqualOp || $isProviderNonEqualOp) {
            if ($isNonEqualOp && !$isProviderNonEqualOp && !$isProviderEqualOp && 'dev-' === \substr($provider->version, 0, 4)) {
                return \false;
            }
            if ($isProviderNonEqualOp && !$isNonEqualOp && !$isEqualOp && 'dev-' === \substr($this->version, 0, 4)) {
                return \false;
            }
            if (!$isEqualOp && !$isProviderEqualOp) {
                return \true;
            }
            return $this->versionCompare($provider->version, $this->version, '!=', $compareBranches);
        }
        if ($this->operator !== self::OP_EQ && $noEqualOp === $providerNoEqualOp) {
            if ('dev-' === \substr($this->version, 0, 4) || 'dev-' === \substr($provider->version, 0, 4)) {
                return \false;
            }
            return \true;
        }
        $version1 = $isEqualOp ? $this->version : $provider->version;
        $version2 = $isEqualOp ? $provider->version : $this->version;
        $operator = $isEqualOp ? $provider->operator : $this->operator;
        if ($this->versionCompare($version1, $version2, self::$transOpInt[$operator], $compareBranches)) {
            return !(self::$transOpInt[$provider->operator] === $providerNoEqualOp && self::$transOpInt[$this->operator] !== $noEqualOp && \version_compare($provider->version, $this->version, '=='));
        }
        return \false;
    }
    public function __toString()
    {
        return self::$transOpInt[$this->operator] . ' ' . $this->version;
    }
    public function getLowerBound()
    {
        $this->extractBounds();
        return $this->lowerBound;
    }
    public function getUpperBound()
    {
        $this->extractBounds();
        return $this->upperBound;
    }
    private function extractBounds()
    {
        if (null !== $this->lowerBound) {
            return;
        }
        if (\strpos($this->version, 'dev-') === 0) {
            $this->lowerBound = Bound::zero();
            $this->upperBound = Bound::positiveInfinity();
            return;
        }
        switch ($this->operator) {
            case self::OP_EQ:
                $this->lowerBound = new Bound($this->version, \true);
                $this->upperBound = new Bound($this->version, \true);
                break;
            case self::OP_LT:
                $this->lowerBound = Bound::zero();
                $this->upperBound = new Bound($this->version, \false);
                break;
            case self::OP_LE:
                $this->lowerBound = Bound::zero();
                $this->upperBound = new Bound($this->version, \true);
                break;
            case self::OP_GT:
                $this->lowerBound = new Bound($this->version, \false);
                $this->upperBound = Bound::positiveInfinity();
                break;
            case self::OP_GE:
                $this->lowerBound = new Bound($this->version, \true);
                $this->upperBound = Bound::positiveInfinity();
                break;
            case self::OP_NE:
                $this->lowerBound = Bound::zero();
                $this->upperBound = Bound::positiveInfinity();
                break;
        }
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

class Terminal
{
    private static $width;
    private static $height;
    private static $stty;
    public function getWidth()
    {
        $width = \getenv('COLUMNS');
        if (\false !== $width) {
            return (int) \trim($width);
        }
        if (null === self::$width) {
            self::initDimensions();
        }
        return self::$width ?: 80;
    }
    public function getHeight()
    {
        $height = \getenv('LINES');
        if (\false !== $height) {
            return (int) \trim($height);
        }
        if (null === self::$height) {
            self::initDimensions();
        }
        return self::$height ?: 50;
    }
    public static function hasSttyAvailable()
    {
        if (null !== self::$stty) {
            return self::$stty;
        }
        if (!\function_exists('exec')) {
            return \false;
        }
        \exec('stty 2>&1', $output, $exitcode);
        return self::$stty = 0 === $exitcode;
    }
    private static function initDimensions()
    {
        if ('\\' === \DIRECTORY_SEPARATOR) {
            if (\preg_match('/^(\\d+)x(\\d+)(?: \\((\\d+)x(\\d+)\\))?$/', \trim(\getenv('ANSICON')), $matches)) {
                self::$width = (int) $matches[1];
                self::$height = isset($matches[4]) ? (int) $matches[4] : (int) $matches[2];
            } elseif (!self::hasVt100Support() && self::hasSttyAvailable()) {
                self::initDimensionsUsingStty();
            } elseif (null !== ($dimensions = self::getConsoleMode())) {
                self::$width = (int) $dimensions[0];
                self::$height = (int) $dimensions[1];
            }
        } else {
            self::initDimensionsUsingStty();
        }
    }
    private static function hasVt100Support()
    {
        return \function_exists('sapi_windows_vt100_support') && \sapi_windows_vt100_support(\fopen('php://stdout', 'wb'));
    }
    private static function initDimensionsUsingStty()
    {
        if ($sttyString = self::getSttyColumns()) {
            if (\preg_match('/rows.(\\d+);.columns.(\\d+);/i', $sttyString, $matches)) {
                self::$width = (int) $matches[2];
                self::$height = (int) $matches[1];
            } elseif (\preg_match('/;.(\\d+).rows;.(\\d+).columns/i', $sttyString, $matches)) {
                self::$width = (int) $matches[2];
                self::$height = (int) $matches[1];
            }
        }
    }
    private static function getConsoleMode()
    {
        $info = self::readFromProcess('mode CON');
        if (null === $info || !\preg_match('/--------+\\r?\\n.+?(\\d+)\\r?\\n.+?(\\d+)\\r?\\n/', $info, $matches)) {
            return null;
        }
        return array((int) $matches[2], (int) $matches[1]);
    }
    private static function getSttyColumns()
    {
        return self::readFromProcess('stty -a | grep columns');
    }
    private static function readFromProcess($command)
    {
        if (!\function_exists('proc_open')) {
            return null;
        }
        $descriptorspec = array(1 => array('pipe', 'w'), 2 => array('pipe', 'w'));
        $process = \proc_open($command, $descriptorspec, $pipes, null, null, array('suppress_errors' => \true));
        if (!\is_resource($process)) {
            return null;
        }
        $info = \stream_get_contents($pipes[1]);
        \fclose($pipes[1]);
        \fclose($pipes[2]);
        \proc_close($process);
        return $info;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class IO
{
    const VERBOSITY_QUIET = 16;
    const VERBOSITY_NORMAL = 32;
    const VERBOSITY_VERBOSE = 64;
    const VERBOSITY_VERY_VERBOSE = 128;
    const VERBOSITY_DEBUG = 256;
    private $interactive;
    private $verbosity = self::VERBOSITY_NORMAL;
    private $colorSupport;
    private $options;
    public function __construct()
    {
        $this->options = \implode(' ', $_SERVER['argv']);
        $shellVerbosity = $this->configureVerbosity();
        $this->interactive = $this->checkInteractivity($shellVerbosity);
        $this->colorSupport = $this->checkColorSupport();
    }
    public function isInteractive()
    {
        return $this->interactive;
    }
    public function getVerbosity()
    {
        return $this->verbosity;
    }
    public function hasColorSupport()
    {
        return $this->colorSupport;
    }
    public function hasParameter($values)
    {
        $values = (array) $values;
        foreach ($values as $value) {
            $regexp = \sprintf('/\\s%s\\b/', \str_replace(' ', '\\s+', \preg_quote($value, '/')));
            if (1 === \preg_match($regexp, $this->options)) {
                return \true;
            }
        }
        return \false;
    }
    private function checkInteractivity($shellVerbosity)
    {
        if (-1 === $shellVerbosity) {
            return \false;
        }
        if (\true === $this->hasParameter(array('--no-interaction', '-n'))) {
            return \false;
        }
        if (\function_exists('posix_isatty') && !@\posix_isatty(\STDOUT) && \false === \getenv('SHELL_INTERACTIVE')) {
            return \false;
        }
        return \true;
    }
    private function configureVerbosity()
    {
        switch ($shellVerbosity = (int) \getenv('SHELL_VERBOSITY')) {
            case -1:
                $this->verbosity = self::VERBOSITY_QUIET;
                break;
            case 1:
                $this->verbosity = self::VERBOSITY_VERBOSE;
                break;
            case 2:
                $this->verbosity = self::VERBOSITY_VERY_VERBOSE;
                break;
            case 3:
                $this->verbosity = self::VERBOSITY_DEBUG;
                break;
            default:
                $shellVerbosity = 0;
                break;
        }
        if ($this->hasParameter(array('--quiet', '-q'))) {
            $this->verbosity = self::VERBOSITY_QUIET;
            $shellVerbosity = -1;
        } elseif ($this->hasParameter(array('-vvv', '--verbose=3', '--verbose 3'))) {
            $this->verbosity = self::VERBOSITY_DEBUG;
            $shellVerbosity = 3;
        } elseif ($this->hasParameter(array('-vv', '--verbose=2', '--verbose 2'))) {
            $this->verbosity = self::VERBOSITY_VERY_VERBOSE;
            $shellVerbosity = 2;
        } elseif ($this->hasParameter(array('-v', '--verbose=1', '--verbose 1', '--verbose'))) {
            $this->verbosity = self::VERBOSITY_VERBOSE;
            $shellVerbosity = 1;
        }
        return $shellVerbosity;
    }
    private function checkColorSupport()
    {
        if ($this->hasParameter(array('--ansi'))) {
            return \true;
        }
        if ($this->hasParameter(array('--no-ansi'))) {
            return \false;
        }
        if (\DIRECTORY_SEPARATOR === '\\') {
            return \function_exists('sapi_windows_vt100_support') && \sapi_windows_vt100_support(\STDOUT) || \false !== \getenv('ANSICON') || 'ON' === \getenv('ConEmuANSI') || 'xterm' === \getenv('TERM');
        }
        if (\function_exists('stream_isatty')) {
            return \stream_isatty(\STDOUT);
        }
        if (\function_exists('posix_isatty')) {
            return \posix_isatty(\STDOUT);
        }
        $stat = \fstat(\STDOUT);
        return $stat ? 020000 === ($stat['mode'] & 0170000) : \false;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class IsExtensionFulfilled implements IsFulfilled
{
    private $requiredExtension;
    public function __construct($requiredExtension)
    {
        $this->requiredExtension = $requiredExtension;
    }
    public function __invoke()
    {
        return \extension_loaded($this->requiredExtension);
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class Checker
{
    private static $requirementsConfig;
    public static function checkRequirements()
    {
        $requirements = self::retrieveRequirements();
        $checkPassed = $requirements->evaluateRequirements();
        $io = new IO();
        self::printCheck($checkPassed, new Printer($io->getVerbosity(), $io->hasColorSupport()), $requirements);
        return $checkPassed;
    }
    public static function printCheck($checkPassed, Printer $printer, RequirementCollection $requirements)
    {
        if (\false === $checkPassed && IO::VERBOSITY_VERY_VERBOSE > $printer->getVerbosity()) {
            $printer->setVerbosity(IO::VERBOSITY_VERY_VERBOSE);
        }
        $verbosity = IO::VERBOSITY_VERY_VERBOSE;
        $iniPath = $requirements->getPhpIniPath();
        $printer->title('Box Requirements Checker', $verbosity);
        $printer->printv('> Using PHP ', $verbosity);
        $printer->printvln(\PHP_VERSION, $verbosity, 'green');
        $printer->printvln('> PHP is using the following php.ini file:', $verbosity);
        if ($iniPath) {
            $printer->printvln('  ' . $iniPath, $verbosity, 'green');
        } else {
            $printer->printvln('  WARNING: No configuration file (php.ini) used by PHP!', $verbosity, 'yellow');
        }
        $printer->printvln('', $verbosity);
        if (\count($requirements) > 0) {
            $printer->printvln('> Checking Box requirements:', $verbosity);
            $printer->printv('  ', $verbosity);
        } else {
            $printer->printvln('> No requirements found.', $verbosity);
        }
        $errorMessages = array();
        foreach ($requirements->getRequirements() as $requirement) {
            if ($errorMessage = $printer->getRequirementErrorMessage($requirement)) {
                if (IO::VERBOSITY_DEBUG === $printer->getVerbosity()) {
                    $printer->printvln('✘ ' . $requirement->getTestMessage(), IO::VERBOSITY_DEBUG, 'red');
                    $printer->printv('  ', IO::VERBOSITY_DEBUG);
                    $errorMessages[] = $errorMessage;
                } else {
                    $printer->printv('E', $verbosity, 'red');
                    $errorMessages[] = $errorMessage;
                }
                continue;
            }
            if (IO::VERBOSITY_DEBUG === $printer->getVerbosity()) {
                $printer->printvln('✔ ' . $requirement->getHelpText(), IO::VERBOSITY_DEBUG, 'green');
                $printer->printv('  ', IO::VERBOSITY_DEBUG);
            } else {
                $printer->printv('.', $verbosity, 'green');
            }
        }
        if (IO::VERBOSITY_DEBUG !== $printer->getVerbosity() && \count($requirements) > 0) {
            $printer->printvln('', $verbosity);
        }
        if ($requirements->evaluateRequirements()) {
            $printer->block('OK', 'Your system is ready to run the application.', $verbosity, 'success');
        } else {
            $printer->block('ERROR', 'Your system is not ready to run the application.', $verbosity, 'error');
            $printer->title('Fix the following mandatory requirements:', $verbosity, 'red');
            foreach ($errorMessages as $errorMessage) {
                $printer->printv(' * ' . $errorMessage, $verbosity);
            }
        }
        $printer->printvln('', $verbosity);
    }
    private static function retrieveRequirements()
    {
        if (null === self::$requirementsConfig) {
            self::$requirementsConfig = __DIR__ . '/../.requirements.php';
        }
        $config = (require self::$requirementsConfig);
        $requirements = new RequirementCollection();
        foreach ($config as $constraint) {
            $requirements->addRequirement('php' === $constraint['type'] ? new IsPhpVersionFulfilled($constraint['condition']) : new IsExtensionFulfilled($constraint['condition']), $constraint['message'], $constraint['helpMessage']);
        }
        return $requirements;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

use HumbugBox3150\Composer\Semver\Semver;
final class IsPhpVersionFulfilled implements IsFulfilled
{
    private $requiredPhpVersion;
    public function __construct($requiredPhpVersion)
    {
        $this->requiredPhpVersion = $requiredPhpVersion;
    }
    public function __invoke()
    {
        return Semver::satisfies(\sprintf('%d.%d.%d', \PHP_MAJOR_VERSION, \PHP_MINOR_VERSION, \PHP_RELEASE_VERSION), $this->requiredPhpVersion);
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

use ArrayIterator;
use Countable;
use IteratorAggregate;
use ReturnTypeWillChange;
use Traversable;
final class RequirementCollection implements IteratorAggregate, Countable
{
    private $requirements = array();
    #[\ReturnTypeWillChange]
    public function getIterator()
    {
        return new ArrayIterator($this->requirements);
    }
    #[\ReturnTypeWillChange]
    public function count()
    {
        return \count($this->requirements);
    }
    public function add(Requirement $requirement)
    {
        $this->requirements[] = $requirement;
    }
    public function addRequirement($checkIsFulfilled, $testMessage, $helpText)
    {
        $this->add(new Requirement($checkIsFulfilled, $testMessage, $helpText));
    }
    public function getRequirements()
    {
        return $this->requirements;
    }
    public function getPhpIniPath()
    {
        return \get_cfg_var('cfg_file_path');
    }
    public function evaluateRequirements()
    {
        return \array_reduce($this->requirements, function ($checkPassed, Requirement $requirement) {
            return $checkPassed && $requirement->isFulfilled();
        }, \true);
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class Printer
{
    private $styles = array('reset' => "\x1b[0m", 'red' => "\x1b[31m", 'green' => "\x1b[32m", 'yellow' => "\x1b[33m", 'title' => "\x1b[33m", 'error' => "\x1b[37;41m", 'success' => "\x1b[30;42m");
    private $verbosity;
    private $supportColors;
    private $width;
    public function __construct($verbosity, $supportColors, $width = null)
    {
        if (null === $width) {
            $terminal = new Terminal();
            $width = $terminal->getWidth();
        }
        $this->verbosity = $verbosity;
        $this->supportColors = $supportColors;
        $this->width = $width ?: 80;
    }
    public function getVerbosity()
    {
        return $this->verbosity;
    }
    public function setVerbosity($verbosity)
    {
        $this->verbosity = $verbosity;
    }
    public function title($title, $verbosity, $style = null)
    {
        if (null === $style) {
            $style = 'title';
        }
        $this->printvln('', $verbosity, $style);
        $this->printvln($title, $verbosity, $style);
        $this->printvln(\str_repeat('=', \min(\strlen($title), $this->width)), $verbosity, $style);
        $this->printvln('', $verbosity, $style);
    }
    public function getRequirementErrorMessage(Requirement $requirement)
    {
        if ($requirement->isFulfilled()) {
            return null;
        }
        $errorMessage = \wordwrap($requirement->getTestMessage(), $this->width - 3, \PHP_EOL . '   ') . \PHP_EOL;
        return $errorMessage;
    }
    public function block($title, $message, $verbosity, $style = null)
    {
        $prefix = ' [' . $title . '] ';
        $lineLength = $this->width - \strlen($prefix) - 1;
        if ($lineLength < 0) {
            $lineLength = 0;
        }
        $message = $prefix . \trim($message);
        $lines = array();
        $remainingMessage = $message;
        $wrapped = \wordwrap($remainingMessage, $lineLength, '¬');
        $wrapped = \explode('¬', $wrapped);
        do {
            $line = \array_shift($wrapped);
            if ($lines && $lineLength > 0) {
                $line = \str_repeat(' ', \strlen($prefix)) . \ltrim($line);
            }
            $lines[] = \str_pad($line, $this->width, ' ', \STR_PAD_RIGHT);
        } while (\count($wrapped));
        $this->printvln('', $verbosity);
        $this->printvln(\str_repeat(' ', $this->width), $verbosity, $style);
        foreach ($lines as $line) {
            $this->printvln($line, $verbosity, $style);
        }
        $this->printv(\str_repeat(' ', $this->width), $verbosity, $style);
        $this->printvln('', $verbosity);
    }
    public function printvln($message, $verbosity, $style = null)
    {
        $this->printv($message, $verbosity, $style);
        $this->printv(\PHP_EOL, $verbosity, null);
    }
    public function printv($message, $verbosity, $style = null)
    {
        if ($verbosity > $this->verbosity) {
            return;
        }
        $message = \wordwrap($message, $this->width);
        $message = \sprintf('%s%s%s', $this->supportColors && isset($this->styles[$style]) ? $this->styles[$style] : '', $message, $this->supportColors ? $this->styles['reset'] : '');
        echo $message;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

interface IsFulfilled
{
    public function __invoke();
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class Requirement
{
    private $checkIsFulfilled;
    private $fulfilled;
    private $testMessage;
    private $helpText;
    public function __construct($checkIsFulfilled, $testMessage, $helpText)
    {
        $this->checkIsFulfilled = $checkIsFulfilled;
        $this->testMessage = $testMessage;
        $this->helpText = $helpText;
    }
    public function isFulfilled()
    {
        if (null === $this->fulfilled) {
            $this->fulfilled = $this->checkIsFulfilled->__invoke();
        }
        return (bool) $this->fulfilled;
    }
    public function getIsFullfilledChecker()
    {
        return $this->checkIsFulfilled;
    }
    public function getTestMessage()
    {
        return $this->testMessage;
    }
    public function getHelpText()
    {
        return $this->helpText;
    }
}
                   GNU LESSER GENERAL PUBLIC LICENSE
                       Version 3, 29 June 2007

 Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.


  This version of the GNU Lesser General Public License incorporates
the terms and conditions of version 3 of the GNU General Public
License, supplemented by the additional permissions listed below.

  0. Additional Definitions.

  As used herein, "this License" refers to version 3 of the GNU Lesser
General Public License, and the "GNU GPL" refers to version 3 of the GNU
General Public License.

  "The Library" refers to a covered work governed by this License,
other than an Application or a Combined Work as defined below.

  An "Application" is any work that makes use of an interface provided
by the Library, but which is not otherwise based on the Library.
Defining a subclass of a class defined by the Library is deemed a mode
of using an interface provided by the Library.

  A "Combined Work" is a work produced by combining or linking an
Application with the Library.  The particular version of the Library
with which the Combined Work was made is also called the "Linked
Version".

  The "Minimal Corresponding Source" for a Combined Work means the
Corresponding Source for the Combined Work, excluding any source code
for portions of the Combined Work that, considered in isolation, are
based on the Application, and not on the Linked Version.

  The "Corresponding Application Code" for a Combined Work means the
object code and/or source code for the Application, including any data
and utility programs needed for reproducing the Combined Work from the
Application, but excluding the System Libraries of the Combined Work.

  1. Exception to Section 3 of the GNU GPL.

  You may convey a covered work under sections 3 and 4 of this License
without being bound by section 3 of the GNU GPL.

  2. Conveying Modified Versions.

  If you modify a copy of the Library, and, in your modifications, a
facility refers to a function or data to be supplied by an Application
that uses the facility (other than as an argument passed when the
facility is invoked), then you may convey a copy of the modified
version:

   a) under this License, provided that you make a good faith effort to
   ensure that, in the event an Application does not supply the
   function or data, the facility still operates, and performs
   whatever part of its purpose remains meaningful, or

   b) under the GNU GPL, with none of the additional permissions of
   this License applicable to that copy.

  3. Object Code Incorporating Material from Library Header Files.

  The object code form of an Application may incorporate material from
a header file that is part of the Library.  You may convey such object
code under terms of your choice, provided that, if the incorporated
material is not limited to numerical parameters, data structure
layouts and accessors, or small macros, inline functions and templates
(ten or fewer lines in length), you do both of the following:

   a) Give prominent notice with each copy of the object code that the
   Library is used in it and that the Library and its use are
   covered by this License.

   b) Accompany the object code with a copy of the GNU GPL and this license
   document.

  4. Combined Works.

  You may convey a Combined Work under terms of your choice that,
taken together, effectively do not restrict modification of the
portions of the Library contained in the Combined Work and reverse
engineering for debugging such modifications, if you also do each of
the following:

   a) Give prominent notice with each copy of the Combined Work that
   the Library is used in it and that the Library and its use are
   covered by this License.

   b) Accompany the Combined Work with a copy of the GNU GPL and this license
   document.

   c) For a Combined Work that displays copyright notices during
   execution, include the copyright notice for the Library among
   these notices, as well as a reference directing the user to the
   copies of the GNU GPL and this license document.

   d) Do one of the following:

       0) Convey the Minimal Corresponding Source under the terms of this
       License, and the Corresponding Application Code in a form
       suitable for, and under terms that permit, the user to
       recombine or relink the Application with a modified version of
       the Linked Version to produce a modified Combined Work, in the
       manner specified by section 6 of the GNU GPL for conveying
       Corresponding Source.

       1) Use a suitable shared library mechanism for linking with the
       Library.  A suitable mechanism is one that (a) uses at run time
       a copy of the Library already present on the user's computer
       system, and (b) will operate properly with a modified version
       of the Library that is interface-compatible with the Linked
       Version.

   e) Provide Installation Information, but only if you would otherwise
   be required to provide such information under section 6 of the
   GNU GPL, and only to the extent that such information is
   necessary to install and execute a modified version of the
   Combined Work produced by recombining or relinking the
   Application with a modified version of the Linked Version. (If
   you use option 4d0, the Installation Information must accompany
   the Minimal Corresponding Source and Corresponding Application
   Code. If you use option 4d1, you must provide the Installation
   Information in the manner specified by section 6 of the GNU GPL
   for conveying Corresponding Source.)

  5. Combined Libraries.

  You may place library facilities that are a work based on the
Library side by side in a single library together with other library
facilities that are not Applications and are not covered by this
License, and convey such a combined library under terms of your
choice, if you do both of the following:

   a) Accompany the combined library with a copy of the same work based
   on the Library, uncombined with any other library facilities,
   conveyed under the terms of this License.

   b) Give prominent notice with the combined library that part of it
   is a work based on the Library, and explaining where to find the
   accompanying uncombined form of the same work.

  6. Revised Versions of the GNU Lesser General Public License.

  The Free Software Foundation may publish revised and/or new versions
of the GNU Lesser General Public License from time to time. Such new
versions will be similar in spirit to the present version, but may
differ in detail to address new problems or concerns.

  Each version is given a distinguishing version number. If the
Library as you received it specifies that a certain numbered version
of the GNU Lesser General Public License "or any later version"
applies to it, you have the option of following the terms and
conditions either of that published version or of any later version
published by the Free Software Foundation. If the Library as you
received it does not specify a version number of the GNU Lesser
General Public License, you may choose any version of the GNU Lesser
General Public License ever published by the Free Software Foundation.

  If the Library as you received it specifies that a proxy can decide
whether future versions of the GNU Lesser General Public License shall
apply, that proxy's public statement of acceptance of any version is
permanent authorization for you to choose that version for the
Library.
<!doctype html><html lang="en"><head><meta charset="utf-8"><title>Contao Manager</title><meta http-equiv="X-UA-Compatible" content="IE=edge"><meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1"/><meta name="description" content=""><meta name="robots" content="noindex,follow"><meta http-equiv="Content-Security-Policy" content="img-src 'self' data: blob: contao.github.io extensions.contao.org; object-src 'none'"/><link rel="icon" type="image/x-icon" href="assets/favicon.ico"><link rel="icon" type="image/png" sizes="16x16" href="assets/favicon-16x16.png"><link rel="icon" type="image/png" sizes="32x32" href="assets/favicon-32x32.png"><link rel="icon" type="image/png" sizes="48x48" href="assets/favicon-48x48.png"><link rel="manifest" href="assets/manifest.webmanifest"><meta name="mobile-web-app-capable" content="yes"><meta name="theme-color" content="#ffffff"><meta name="application-name" content="Contao Manager"><link rel="apple-touch-icon" sizes="57x57" href="assets/apple-touch-icon-57x57.png"><link rel="apple-touch-icon" sizes="60x60" href="assets/apple-touch-icon-60x60.png"><link rel="apple-touch-icon" sizes="72x72" href="assets/apple-touch-icon-72x72.png"><link rel="apple-touch-icon" sizes="76x76" href="assets/apple-touch-icon-76x76.png"><link rel="apple-touch-icon" sizes="114x114" href="assets/apple-touch-icon-114x114.png"><link rel="apple-touch-icon" sizes="120x120" href="assets/apple-touch-icon-120x120.png"><link rel="apple-touch-icon" sizes="144x144" href="assets/apple-touch-icon-144x144.png"><link rel="apple-touch-icon" sizes="152x152" href="assets/apple-touch-icon-152x152.png"><link rel="apple-touch-icon" sizes="167x167" href="assets/apple-touch-icon-167x167.png"><link rel="apple-touch-icon" sizes="180x180" href="assets/apple-touch-icon-180x180.png"><link rel="apple-touch-icon" sizes="1024x1024" href="assets/apple-touch-icon-1024x1024.png"><meta name="apple-mobile-web-app-capable" content="yes"><meta name="apple-mobile-web-app-status-bar-style" content="black-translucent"><meta name="apple-mobile-web-app-title" content="Contao Manager"><link rel="apple-touch-startup-image" media="(device-width: 320px) and (device-height: 568px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-640x1136.png"><link rel="apple-touch-startup-image" media="(device-width: 320px) and (device-height: 568px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-1136x640.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 667px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-750x1334.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 667px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-1334x750.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 812px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1125x2436.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 812px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2436x1125.png"><link rel="apple-touch-startup-image" media="(device-width: 390px) and (device-height: 844px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1170x2532.png"><link rel="apple-touch-startup-image" media="(device-width: 390px) and (device-height: 844px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2532x1170.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-828x1792.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-1792x828.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1242x2688.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2688x1242.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 736px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1242x2208.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 736px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2208x1242.png"><link rel="apple-touch-startup-image" media="(device-width: 428px) and (device-height: 926px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1284x2778.png"><link rel="apple-touch-startup-image" media="(device-width: 428px) and (device-height: 926px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2778x1284.png"><link rel="apple-touch-startup-image" media="(device-width: 768px) and (device-height: 1024px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1536x2048.png"><link rel="apple-touch-startup-image" media="(device-width: 768px) and (device-height: 1024px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2048x1536.png"><link rel="apple-touch-startup-image" media="(device-width: 810px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1620x2160.png"><link rel="apple-touch-startup-image" media="(device-width: 810px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2160x1620.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1194px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1668x2388.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1194px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2388x1668.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1112px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1668x2224.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1112px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2224x1668.png"><link rel="apple-touch-startup-image" media="(device-width: 1024px) and (device-height: 1366px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-2048x2732.png"><link rel="apple-touch-startup-image" media="(device-width: 1024px) and (device-height: 1366px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2732x2048.png"><meta name="msapplication-TileColor" content="#ffffff"><meta name="msapplication-TileImage" content="assets/mstile-144x144.png"><meta name="msapplication-config" content="assets/browserconfig.xml"><link rel="yandex-tableau-widget" href="assets/yandex-browser-manifest.json"><script defer="defer" src="js/chunk-vendors.41a4e2b1.js" type="module"></script><script defer="defer" src="js/app.1ba94aee.js" type="module"></script><link href="css/chunk-vendors.e94d59f6.css" rel="stylesheet"><link href="css/app.a9bbe961.css" rel="stylesheet"><script defer="defer" src="js/chunk-vendors-legacy.8131a05f.js" nomodule></script><script defer="defer" src="js/app-legacy.4548ebe5.js" nomodule></script></head><body><noscript><strong>We're sorry but the Contao Manager does not work without JavaScript enabled. Please enable it to continue.</strong></noscript><div id="app"></div></body></html><?php

declare(strict_types=1);

/*
 * This file is part of Contao Manager.
 *
 * (c) Contao Association
 *
 * @license LGPL-3.0-or-later
 */

use Contao\ManagerApi\ApiKernel;
use Contao\ManagerApi\HttpKernel\ApiProblemResponse;
use Symfony\Component\HttpFoundation\Request;

require __DIR__.'/../vendor/autoload.php';

try {
    $kernel = new ApiKernel('@symfony_env@' === 'prod' ? 'prod' : 'dev');

    $request = Request::createFromGlobals();
    $response = $kernel->handle($request);
    $response->send();
    $kernel->terminate($request, $response);
} catch (Throwable $e) {
    ApiProblemResponse::createFromException($e, '@symfony_env@' !== 'prod')->send();
}
body.nav-active{overflow:hidden!important}#app{-webkit-transition:-webkit-transform .4s cubic-bezier(.55,0,.1,1);transition:-webkit-transform .4s cubic-bezier(.55,0,.1,1);transition:transform .4s cubic-bezier(.55,0,.1,1);transition:transform .4s cubic-bezier(.55,0,.1,1),-webkit-transform .4s cubic-bezier(.55,0,.1,1)}.nav-active #app{overflow-y:visible;-webkit-transform:translateX(-250px);transform:translateX(-250px)}@media(min-width:1024px){.nav-active #app{-webkit-transform:none;transform:none}}.navigation{float:right}.navigation__toggle{display:block;float:right;position:relative;-webkit-transition:-webkit-transform .4s cubic-bezier(.55,0,.1,1);transition:-webkit-transform .4s cubic-bezier(.55,0,.1,1);transition:transform .4s cubic-bezier(.55,0,.1,1);transition:transform .4s cubic-bezier(.55,0,.1,1),-webkit-transform .4s cubic-bezier(.55,0,.1,1);margin:5px 15px;padding:0;width:30px;height:30px;cursor:pointer;z-index:20}@media(min-width:1024px){.navigation__toggle{display:none}}.nav-active .navigation__toggle{-webkit-transform:rotate(90deg);transform:rotate(90deg)}.navigation__toggle span{display:block;height:3px;width:25px;margin:5px auto;background:#535353;pointer-events:none}.navigation__group,.navigation__item{list-style-type:none;margin:0;padding:0}.navigation__group--main{position:fixed;top:0;bottom:0;right:-250px;width:250px;padding:20px;overflow-y:auto;overflow-scrolling:touch;background:#fff;-webkit-box-shadow:-1px 0 #ccbfa2;box-shadow:-1px 0 #ccbfa2;z-index:10}.navigation__item a{display:block;padding:12px 10px;font-size:16px;color:#535353;white-space:pre}.navigation__item a:hover{text-decoration:none}.navigation__item a[href]:hover{color:#f47c00}.navigation__item--main>a{text-transform:uppercase}.navigation__item--sub>a{margin-left:15px}.navigation__item--icon svg{display:none}.navigation__item-badge{position:relative;top:-2px;margin-left:8px;padding:2px 5px;font-size:10px;color:#fff;font-weight:600;background:#f47c00;border-radius:5px}@media(min-width:1024px){.navigation__group--main{position:inherit;top:auto;bottom:auto;right:auto;width:auto;padding:0;overflow:visible;background:none;-webkit-box-shadow:none;box-shadow:none;-webkit-transform:none;transform:none;-webkit-transition:none;transition:none}.navigation__group--sub{display:none;position:absolute;left:50%;min-width:180px;margin-top:-3px;text-align:center;background:#fff;border-top:3px solid #f47c00;-webkit-transform:translateX(-50%);transform:translateX(-50%);z-index:100;-webkit-box-shadow:0 1px 2px #ccbfa2;box-shadow:0 1px 2px #ccbfa2}.navigation__group--sub:before{position:absolute;left:50%;top:-7px;width:0;height:0;margin-left:-4px;border-style:solid;border-width:0 3.5px 4px 3.5px;border-color:transparent transparent #f47c00 transparent;content:""}.navigation__group--right{left:auto;right:7px;-webkit-transform:translateX(0);transform:translateX(0)}.navigation__group--right:before{left:auto;right:18px}.navigation__item{position:relative;display:inline-block;padding:0 8px}.navigation__item.router-link-active>a,.navigation__item:hover>a{color:#f47c00!important;border-bottom:3px solid #f47c00}.navigation__item:hover>.navigation__group--sub{display:block}.navigation__item--sub{display:block;border-top:1px solid #e5dfd0}.navigation__item--sub a{margin:0;border:none!important}.navigation__item--sub a:hover{color:#000!important}.navigation__item--sub:first-child{border-top:none}.navigation__item--icon>a{padding-top:7px}.navigation__item--icon>a svg{display:inline;position:relative;top:4px;width:22px;height:22px;fill:#535353}.navigation__item--icon>a:hover svg{fill:#f47c00}.navigation__item--icon>a span{display:none}.navigation:hover li>a{border:none}.navigation:hover li:hover>a{border-bottom:3px solid #f47c00}.navigation:hover li:hover>a svg{fill:#f47c00}}.logout-warning{position:fixed;display:block;top:20%;left:50%;width:500px;max-width:90%;text-align:center;background:#fff;z-index:10;opacity:1;-webkit-transform:translateX(-50%);transform:translateX(-50%);border-bottom:2px solid #ddd3bc;border-radius:2px}.logout-warning__headline{position:relative;background:#f47c00;color:#fff;font-weight:300;line-height:40px;border-radius:2px 2px 0 0}.logout-warning__headline--complete{background-color:#31a64b}.logout-warning__headline--error{background-color:#db5041}.logout-warning__text{margin:2em 40px}.logout-warning__countdown{margin:-20px 0 20px;font:600 4em/1.6 SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;color:#db8c41}.logout-warning .widget-button{width:auto;height:35px;margin:0 5px 2em 5px;padding:0 30px;line-height:35px}.fragment-footer{clear:both;width:250px;margin:10px auto 0;padding:15px 0;font-size:12px;text-align:center;border-top:1px solid #eee}.fragment-footer--main{width:auto;margin-top:52px!important;padding:20px 0;border-top:1px solid #bbb}.fragment-footer:before{content:"";display:table;clear:both}.fragment-footer__product{font-weight:300}.fragment-footer__links{margin:5px 0 0;padding:0;list-style-type:none}.fragment-footer__links li{display:inline-block}.fragment-footer__links li:not(:first-child):before{content:"|";padding:0 10px 0 8px}.fragment-footer__links a{display:inline!important;color:#2a7887}.fragment-footer__language{position:relative;display:inline-block;margin-left:5px}.fragment-footer__language button{width:auto;height:auto;padding:0 0 0 25px;margin-top:10px!important;background:transparent;color:#535353;font-size:12px;font-weight:300;line-height:20px;background:url(../img/language.95d0a00b.svg) 0 no-repeat;background-size:20px 20px;border:none}.fragment-footer__language button:hover{color:#000}.fragment-footer__language ul{position:absolute;display:block;width:350px;left:50%;bottom:30px;margin:0;padding:0;text-align:left;list-style-type:none;white-space:nowrap;background:#fff;border-bottom:3px solid #f47c00;-webkit-transform:translateX(-50%);transform:translateX(-50%);z-index:100;-webkit-box-shadow:0 -1px 2px #ccbfa2;box-shadow:0 -1px 2px #ccbfa2}.fragment-footer__language ul:after{position:absolute;left:50%;bottom:-7px;width:0;height:0;margin-left:-4px;border-style:solid;border-width:4px 3.5px 0 3.5px;border-color:#f47c00 transparent transparent transparent;content:""}.fragment-footer__language li{float:left;width:50%;margin:0;padding:0;border-top:1px solid #e5dfd0}.fragment-footer__language li a{display:block;margin:0;padding:5px 10px;color:#535353;cursor:pointer}.fragment-footer__language li a.active{font-weight:600}.fragment-footer__language li a:hover{color:#000;text-decoration:none}.fragment-footer__language li:first-child,.fragment-footer__language li:nth-child(2){border-top:none}@media(min-width:960px){.fragment-footer--boxed .fragment-footer__product,.fragment-footer--main .fragment-footer__product{float:left}.fragment-footer--boxed .fragment-footer__links,.fragment-footer--main .fragment-footer__links{float:right;margin:0}.fragment-footer--boxed .fragment-footer__language button,.fragment-footer--main .fragment-footer__language button{margin-top:0!important}.fragment-footer--boxed{width:840px}}.layout-main{overflow:hidden;min-height:100vh}.layout-main__header{height:56px;padding:8px;background:#fff;-webkit-box-shadow:0 1px #ccbfa2;box-shadow:0 1px #ccbfa2}.layout-main__header--margin{margin-bottom:30px}.layout-main__subheader{margin:30px 0 45px;padding:20px 0;background:#e5dfcf;border-bottom:1px solid #dcd8cc}.layout-main__subheader-inside{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column}.layout-main__news{width:320px;height:50px;margin-bottom:20px}.layout-main .search-bar{width:100%;margin:0}.layout-main__logo{display:inline;color:#535353;text-decoration:none;font-weight:100;font-size:27px;line-height:40px}.layout-main__logo img{float:left;margin:0 10px 0 12px}@media(min-width:1024px){.layout-main__logo img{margin-left:0}}.layout-main footer,.layout-main__content,.layout-main__subheader-inside{position:relative;margin:0 20px}@media(min-width:700px){.layout-main__subheader-inside{-webkit-box-orient:horizontal;-webkit-box-direction:normal;-ms-flex-direction:row;flex-direction:row}.layout-main__news{margin:0 20px 0 0}}@media(min-width:1024px){.layout-main footer,.layout-main__content,.layout-main__subheader-inside{max-width:960px;margin:0 auto}}@media(min-width:1200px){.layout-main footer,.layout-main__content,.layout-main__subheader-inside{max-width:1180px}}.confirm-button{position:relative}.confirm-button__icon{display:none;position:absolute;opacity:0;z-index:100}.confirm-button__icon--confirm{display:block;-webkit-animation:confirm_button .5s ease-out 0s;animation:confirm_button .5s ease-out 0s}.confirm-button__icon svg{fill:#31a64b;width:100%;height:100%}@-webkit-keyframes confirm_button{0%{opacity:1;height:10px;width:10px;left:calc(50% - 5px);top:calc(50% - 5px)}to{opacity:0;height:150px;width:150px;left:calc(50% - 75px);top:calc(50% - 75px)}}@keyframes confirm_button{0%{opacity:1;height:10px;width:10px;left:calc(50% - 5px);top:calc(50% - 5px)}to{opacity:0;height:150px;width:150px;left:calc(50% - 75px);top:calc(50% - 75px)}}.package-tools{position:relative;clear:both;text-align:center}@media(min-width:800px){.package-tools{margin-bottom:40px}}.package-tools__button.widget-button{margin-bottom:10px}@media(min-width:800px){.package-tools{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center}.package-tools__button.widget-button{width:auto;margin:0 15px;padding:0 15px}}.package-actions{position:fixed;left:0;right:0;bottom:0;max-height:0;background:#000;background:rgba(0,0,0,.8);color:#fff;-webkit-transition:max-height .4s ease;transition:max-height .4s ease;z-index:100}.package-actions--active{max-height:200px}.package-actions__inner{display:-webkit-box;display:-ms-flexbox;display:flex;-ms-flex-wrap:wrap;flex-wrap:wrap;-webkit-box-pack:end;-ms-flex-pack:end;justify-content:flex-end;-webkit-box-align:center;-ms-flex-align:center;align-items:center;margin:0;padding:12px;text-align:right}@media(min-width:1024px){.package-actions__inner{max-width:976px;margin:0 auto;padding-left:0;padding-right:0}}@media(min-width:1200px){.package-actions__inner{max-width:1196px}}.package-actions__text{-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1;display:initial;margin:0 8px;font-weight:600}.package-actions__button{display:block;padding:0 15px!important;margin:8px}.package-actions__button--dryRun{width:auto!important;-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1}@media(min-width:600px){.package-actions__button{width:auto!important}.package-actions__button--dryRun{-webkit-box-flex:0;-ms-flex-positive:0;flex-grow:0}}.package-actions__button-group{display:block;width:100%;margin:8px}.package-actions__button-group>.button-group__primary{padding:0 15px!important}@media(min-width:600px){.package-actions__button-group{width:auto!important}}.package{margin-bottom:14px;background:#fff;border-bottom:3px solid #ddd3bc;border-radius:2px}.package--contao{border-bottom-color:#f47c00}.package__hint{position:relative;padding:8px 20px 8px 20px;background:#e8c8bc;font-weight:400;font-size:12px;line-height:1.8;border-radius:2px 2px 0 0}@media(min-width:800px){.package__hint{padding-left:56px;background:#e8c8bc url(../img/hint.ba2ac97e.svg) 20px 5px no-repeat;background-size:28px 28px}}.package__hint p a{display:inline-block;padding-right:10px}.package__hint p a:first-child{margin-left:10px}.package__hint p a:not(:first-child):before{padding-right:10px;content:"|"}.package__hint-close{float:right;padding-left:18px;color:#bd2e20;background:url(../img/close.88e95867.svg) 0 no-repeat;background-size:14px 14px}.package__inside{padding:10px 20px 25px}.package__inside:after{display:table;clear:both;content:""}@media(min-width:1024px){.package__inside{padding:25px 20px}}.package__icon{display:none}.package__icon img{width:100%;height:100%}@media(min-width:1024px){.package__icon{display:block;float:left;width:90px;height:90px;margin-right:20px}}.package__about{margin-bottom:20px}@media(min-width:1024px){.package__about{float:left;width:370px;margin-bottom:0}}@media(min-width:1200px){.package__about{width:590px}}.package__headline{position:relative;margin-bottom:5px}.package__headline em{background-color:#ff0;font-style:normal}.package__headline--badge{padding-right:100px}@media(min-width:1024px){.package__headline--badge{padding-right:0}}.package__title{margin-right:10px}.package__badge{position:absolute;top:6px;right:0;padding:0 8px;background:#db5041;border-radius:2px;font-size:12px;line-height:19px;color:#fff;cursor:help}@media(min-width:800px){.package__badge{position:relative;display:inline-block;top:-3px;right:auto}}.package__description{display:-webkit-box;overflow:hidden;-webkit-line-clamp:2;-webkit-box-orient:vertical;margin-bottom:1em}.package__description em{background-color:#ff0;font-style:normal}.package__additional{margin-top:-5px}.package .package__release{display:none;text-align:right;margin-bottom:10px}@media(min-width:600px){.package .package__release{display:block;float:left;width:50%}}@media(min-width:1024px){.package .package__release{width:180px;margin-left:40px;margin-bottom:0}}.package__version--additional strong{margin-right:10px}@media(min-width:1024px){.package__version--additional{display:none}}.package__version--release{display:none}@media(min-width:1024px){.package__version--release{display:block;margin-top:20px;text-align:center}}.package__version--release time{display:block}.package__version--missing{padding:4px 8px;background:#db5041;border-radius:2px;color:#fff;font-weight:700}.package__version-update{display:inline-block;margin:0 0 2px;padding:1px 8px;color:#fff}.package__version-update--available{background:#31a64b}.package__version-update--error{background:#db5041}.package__version-update--none{background:#ccc}@media(min-width:1024px){.package__version-update{display:block;margin:2px 0 0}}.package__version-latest{float:right;position:relative;right:-7px;width:24px;height:20px;background:#31a64b url(../img/button-update.c63bd5a5.svg) 50%/20px 20px no-repeat}@media(min-width:600px){.package__actions{float:right;width:50%;max-width:500px;margin-top:-5px;padding-left:40px;text-align:right}}@media(min-width:1024px){.package__actions{width:180px;margin-left:40px;padding-left:0}}.package__actions .button-group:not(:last-child),.package__actions .widget-button:not(:last-child){margin-bottom:5px}.package__actions .button-group button{margin-bottom:0!important}.package__features{padding:0 0 10px 0;margin:-20px 0 0}@media(min-width:1024px){.package__features{margin-top:-10px}}@media(min-width:960px){.package__hint{overflow:hidden;height:37px;-webkit-transition:height .4s ease;transition:height .4s ease}.package__hint-enter,.package__hint-leave-to{height:0}}.progress-bar{position:relative;width:100%;height:30px;background:#fff;border:2px solid #db8c41;color:#000;font-weight:600;text-align:center;line-height:26px}.progress-bar__bar{position:absolute;overflow:hidden;left:0;right:0;top:0;bottom:0;background:#db8c41}.progress-bar__bar span{display:block;color:#fff;text-align:center}.feature-package{display:-webkit-box;display:-ms-flexbox;display:flex;-ms-flex-wrap:wrap;flex-wrap:wrap;padding-top:4px;margin:4px 20px 4px;border-top:1px solid #e9eef1}.feature-package:last-child{padding-bottom:0;margin-bottom:-4px}.feature-package__name{font-weight:600;white-space:nowrap}.feature-package__name:after{content:": "}.feature-package__text{-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1;display:-webkit-box;overflow:hidden;-webkit-line-clamp:1;-webkit-box-orient:vertical;margin-right:.5em;padding:4px 0;line-height:20px}.feature-package__text--hint{display:inline;-webkit-line-clamp:none}.feature-package__badge{margin-left:5px;padding:2px 8px;background:#db5041;border-radius:2px;font-size:12px;font-weight:600;line-height:19px;color:#fff;cursor:help}.feature-package__hint{line-height:1.2;padding:2px 5px;background:#e8c8bc;font-size:12px}.feature-package__actions{-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1;display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:end;-ms-flex-pack:end;justify-content:flex-end;margin:0 -4px 0 0}.feature-package__actions>*{margin:0 4px}.feature-package__restore{padding-left:18px;font-size:12px;color:#bd2e20;background:url(../img/close.88e95867.svg) 0 no-repeat;background-size:14px 14px;border:none;outline:none;cursor:pointer}.feature-package__restore:hover{text-decoration:underline}@media(min-width:800px){.feature-package{-ms-flex-wrap:nowrap;flex-wrap:nowrap}}@media(min-width:1024px){.feature-package__hint{padding:8px 10px 8px 36px;background:#e8c8bc url(../img/hint.ba2ac97e.svg) 10px 5px no-repeat;background-size:20px 20px}.feature-package__actions{margin:0 -4px 0 0}}.package-constraint input[type=text][data-v-5cd7bdbd]{height:30px;margin-right:2px;background:#fff;border:2px solid #db8c41;color:#000;font-weight:600;text-align:center;line-height:30px}.package-constraint input[type=text][data-v-5cd7bdbd]::-webkit-input-placeholder{color:#fff;opacity:1}.package-constraint input[type=text][data-v-5cd7bdbd]::-moz-placeholder{color:#fff;opacity:1}.package-constraint input[type=text][data-v-5cd7bdbd]:-ms-input-placeholder{color:#fff;opacity:1}.package-constraint input[type=text][data-v-5cd7bdbd]::-ms-input-placeholder{color:#fff;opacity:1}.package-constraint input[type=text][data-v-5cd7bdbd]::placeholder{color:#fff;opacity:1}.package-constraint input[type=text][data-v-5cd7bdbd]:disabled{color:#fff;opacity:1;background:#db8c41;-webkit-text-fill-color:#fff}.package-constraint input[type=text].disabled[data-v-5cd7bdbd]{background:#ccc;border-color:#ccc}.package-constraint input[type=text].error[data-v-5cd7bdbd]{-webkit-animation:input-error .15s linear 3;animation:input-error .15s linear 3}.package-constraint>input[type=text][data-v-5cd7bdbd],.package-constraint>input[type=text][data-v-5cd7bdbd]:disabled{float:left;width:calc(100% - 32px)}.package-constraint button[data-v-5cd7bdbd]{position:relative;width:30px;height:30px;background:#db8c41;line-height:20px;text-indent:-999em}.package-constraint button[data-v-5cd7bdbd]:hover{background:#d77f2c;border-color:#c47225}.package-constraint button[data-v-5cd7bdbd]:before{position:absolute;left:50%;top:50%;margin:-10px 0 0 -10px}.package-constraint button.rotate[data-v-5cd7bdbd]:before{-webkit-animation:release-validating-5cd7bdbd 2s linear infinite;animation:release-validating-5cd7bdbd 2s linear infinite}@-webkit-keyframes release-validating-5cd7bdbd{to{-webkit-transform:rotate(1turn);transform:rotate(1turn)}}@keyframes release-validating-5cd7bdbd{to{-webkit-transform:rotate(1turn);transform:rotate(1turn)}}.button-group{position:relative}.button-group__primary.widget-button{float:left;width:calc(100% - 39px);border-top-right-radius:0;border-bottom-right-radius:0}.button-group__more.widget-button{float:right;width:38px;padding:7px;border-top-left-radius:0;border-bottom-left-radius:0}.button-group__more.widget-button svg{width:24px;height:24px}.button-group__group{position:absolute;top:39px;width:100%;z-index:100}.button-group__group:focus{outline:none}.button-group__group .widget-button{margin-top:1px}.button-group__group .link-menu{margin-top:3px}.button-group__group--top{top:auto;bottom:39px}.button-group__group--top .link-menu{margin-top:0;margin-bottom:3px}.composer-package__stats{display:inline-block;margin-right:15px;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.composer-package__stats--license{padding-left:0}.composer-package__stats--downloads{background-image:url(../img/downloads.aa84cdf1.svg)}.composer-package__stats--favers{background-image:url(../img/favers.31587387.svg)}.composer-package__stats--funding{width:16px;background-image:url(../img/funding.8a3c0e0e.svg);background-size:16px 16px;background-repeat:no-repeat;text-decoration:none!important}.package-uploads__overlay{top:0;bottom:0;right:0;left:0;position:fixed;z-index:9999;opacity:.6;text-align:center;background:#000}.package-uploads__overlay div{margin:-.5em 0 0;position:absolute;top:50%;left:0;right:0;-webkit-transform:translateY(-50%);transform:translateY(-50%);font-size:40px;color:#fff;padding:0}.cloud-status{margin-left:8px;position:relative}.cloud-status__button{margin-left:0;margin-right:0;padding-left:8px;cursor:help!important}.cloud-status__popup{position:absolute;text-align:left;left:0;bottom:55px;margin:0;padding:0 0 15px;outline:none;background:#fff;color:#535353;border-bottom:3px solid #f47c00;-webkit-box-shadow:0 -1px 2px #ccbfa2;box-shadow:0 -1px 2px #ccbfa2;z-index:100}.cloud-status__popup:after{position:absolute;left:38px;bottom:-7px;width:0;height:0;margin-left:-4px;border-style:solid;border-width:4px 3.5px 0 3.5px;border-color:#f47c00 transparent transparent transparent;content:""}.cloud-status__popup--error{color:#fff;text-align:center;background-color:#db5041;border-color:#db5041}.cloud-status__popup--error:after{left:27px;border-color:#db5041 transparent transparent transparent}.cloud-status__headline{padding:15px 20px 0;font-size:16px;white-space:pre}.cloud-status__version{text-align:center;margin:0 0 8px;font-size:12px}.cloud-status__link{display:block;margin:15px 10px 0;text-align:center}.cloud-status__error{padding:8px 20px 8px;-webkit-hyphens:auto;-ms-hyphens:auto;hyphens:auto}.cloud-status table{width:100%;margin-top:12px;border-spacing:0;border-collapse:collapse}.cloud-status th{padding:3px 5px 3px 20px}.cloud-status td{padding:3px 20px 3px 0}.cloud-status tr:nth-child(odd){background:#f0f0f0}.package-list{position:relative}.package-list__status{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.package-list__status .sk-circle{width:100px;height:100px;margin:0 auto 40px}.package-list__headline{font-size:18px;font-weight:300;margin:30px 0 10px}.layout-boxed{display:table;width:100%;height:100%}.layout-boxed__cell{display:table-cell;overflow:hidden;vertical-align:middle;padding:10px 0}.layout-boxed__container{position:relative;max-width:380px;margin:0 auto;background:#fff}.layout-boxed__container:after{display:table;clear:both}.layout-boxed__container:before{left:-100px;-webkit-box-shadow:inset 15px 0 60px 25px #ebe6db,inset -8px 0 8px -8px rgba(0,0,0,.8);box-shadow:inset 15px 0 60px 25px #ebe6db,inset -8px 0 8px -8px rgba(0,0,0,.8)}.layout-boxed__container:after,.layout-boxed__container:before{position:absolute;display:block;width:100px;top:0;bottom:0;content:""}.layout-boxed__container:after{right:-100px;-webkit-box-shadow:inset -15px 0 60px 25px #ebe6db,inset 8px 0 8px -8px rgba(0,0,0,.8);box-shadow:inset -15px 0 60px 25px #ebe6db,inset 8px 0 8px -8px rgba(0,0,0,.8)}@media(min-width:960px){.layout-boxed__container{margin-top:20px;margin-bottom:20px}.layout-boxed__container--wide{max-width:940px}}.view-oauth__header{max-width:280px;margin:0 auto 60px;padding-top:40px;text-align:center}.view-oauth__product{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-oauth__form{position:relative;max-width:250px;margin:0 auto 80px;text-align:center}.view-oauth__form input,.view-oauth__form select{margin:5px 0 10px}.view-oauth__headline{margin-bottom:0}.view-oauth__description{margin-top:.5em;margin-bottom:.5em}.view-oauth__client{margin:1em 0;font-size:32px}.view-oauth__warning{color:#db5041;margin-top:.5em;margin-bottom:2em}.view-oauth__button{margin-top:20px}.view-oauth__button .sk-circle{color:#fff;text-align:center}.message-overlay{position:relative}.message-overlay__blur{opacity:.75;-webkit-filter:blur(2px);filter:blur(2px);-webkit-transition:opacity .5s,-webkit-filter .5s;transition:opacity .5s,-webkit-filter .5s;transition:opacity .5s,filter .5s;transition:opacity .5s,filter .5s,-webkit-filter .5s}.message-overlay__overlay{position:absolute;display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;left:0;right:0;top:0;bottom:0}.message-overlay__message{padding:10px;font-size:2em;font-weight:400;text-align:center}.maintenance{margin-bottom:14px;background:#fff;border-bottom:3px solid #ddd3bc;border-radius:2px}.maintenance__inside{padding:10px 20px 20px}.maintenance__inside:after{display:table;clear:both;content:""}@media(min-width:1024px){.maintenance__inside{padding:25px 20px}}.maintenance__image{display:none}.maintenance__image img{width:100%;height:100%}@media(min-width:1024px){.maintenance__image{display:block;float:left;width:90px;height:90px;margin-right:20px}}.maintenance__about{margin-bottom:20px}@media(min-width:1024px){.maintenance__about{float:left;width:510px;margin-bottom:0}}.maintenance__about h1{position:relative;margin-bottom:5px}.maintenance__about p{margin:0 0 1em;display:inline}.maintenance__error,.maintenance__warning{position:relative;top:-2px;margin-left:.5em;padding:2px 8px;font-size:14px;line-height:1em;font-weight:300;background:#db8c41;color:#fff}.maintenance__error{background:#db5041}@media(min-width:600px){.maintenance__actions{margin:0 -10px}}@media(min-width:1024px){.maintenance__actions{float:right;width:250px;margin:0 0 0 40px}}.maintenance__actions>.button-group,.maintenance__actions>button{width:100%;margin-bottom:10px}@media(min-width:600px){.maintenance__actions>.button-group,.maintenance__actions>button{float:right;width:calc(50% - 20px);margin:0 10px}}@media(min-width:1024px){.maintenance__actions>.button-group,.maintenance__actions>button{width:100%;margin:0 0 10px}}.maintenance__loader{width:50px;margin:0 auto}.maintenance__loader .sk-circle{width:50px;height:50px}.log-viewer__status{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.log-viewer__status--empty{padding-top:140px;background:url(../img/warning.a0297242.svg) top no-repeat;background-size:100px 100px}.log-viewer__status--loader .sk-circle{width:100px;height:100px;margin:0 auto 40px}.log-viewer__status button{margin-top:2em}.log-viewer__loading{width:30px;margin:40px auto}.log-viewer__loading .sk-circle{width:30px;height:30px}.log-viewer__filters{-webkit-box-pack:justify;-ms-flex-pack:justify;justify-content:space-between;-ms-flex-wrap:wrap;flex-wrap:wrap}.log-viewer__filters,.log-viewer__filters>div{display:-webkit-box;display:-ms-flexbox;display:flex;gap:20px}.log-viewer__filters>div{-webkit-box-align:end;-ms-flex-align:end;align-items:flex-end}.log-viewer__list{margin-top:2em;padding-bottom:1px;background:#fff;border-radius:2px}@media(min-width:600px){.log-viewer__list{overflow-y:scroll;max-height:calc(100vh - 300px)}}.log-viewer__line{position:relative;padding:10px 0;border-bottom:1px solid #e9eef1}@media(min-width:600px){.log-viewer__line{display:-webkit-box;display:-ms-flexbox;display:flex}}.log-viewer__line:hover{background:#f9f9f9}.log-viewer__line:last-child{border-bottom:none}.log-viewer__line--header{display:none}@media(min-width:600px){.log-viewer__line--header{display:-webkit-box;display:-ms-flexbox;display:flex;position:sticky;top:0;z-index:1;font-weight:600;background:#ccbfa2;color:#fff;border-top-left-radius:2px;border-top-right-radius:2px;border-bottom-color:#fff}.log-viewer__line--header:hover{background:#ccbfa2}}.log-viewer__line--alert:before,.log-viewer__line--critical:before,.log-viewer__line--emergency:before,.log-viewer__line--error:before,.log-viewer__line--warning:before{content:"";position:absolute;left:0;top:-1px;bottom:-1px;width:4px;background:#db5041}.log-viewer__line--warning:before{background:#db8c41}.log-viewer__line--raw{padding:5px 10px;background:#24292e;border-bottom:none;font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;color:#f6f8fa;font-size:.8em;line-height:1.5}.log-viewer__line--raw:hover{background:#2f363d}.log-viewer__more{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;padding:20px}.log-viewer__content,.log-viewer__meta{padding:10px 20px}.log-viewer__content--header,.log-viewer__meta--header{padding:0 20px!important}.log-viewer__meta{padding-bottom:0;-ms-flex-negative:0;flex-shrink:0;font-style:italic}.log-viewer__meta--header{font-style:normal}@media(min-width:600px){.log-viewer__meta{width:220px;padding-bottom:10px}}.log-viewer__content{-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1}.log-viewer__datetime{display:block}@media(min-width:600px){.log-viewer__datetime{margin-bottom:1em}}.log-viewer__badge{display:inline-block;margin-right:10px;padding:1px 4px;background:#ccc;border-radius:2px;font-size:.9em;font-weight:400;text-transform:lowercase}.log-viewer__badge--desktop{display:none}@media(min-width:600px){.log-viewer__badge--desktop{display:inline-block}.log-viewer__badge--mobile{display:none}}.log-viewer__badge--channel{padding-top:0;padding-bottom:0;border:1px solid #ccc;background:#fff}.log-viewer__badge--level-warning{background:#db8c41;color:#fff}.log-viewer__badge--level-alert,.log-viewer__badge--level-critical,.log-viewer__badge--level-emergency,.log-viewer__badge--level-error{background:#db5041;color:#fff}.log-viewer__message span:nth-child(2n){font-weight:600;color:#000}.log-viewer__details{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-align:center;-ms-flex-align:center;align-items:center;margin-top:1em}.log-viewer__toggle{margin-right:10px;padding:0;border:none;background:none;color:#f47c00;text-decoration:none;cursor:pointer}.log-viewer__toggle:hover{text-decoration:underline}.log-viewer__json{margin:10px 0 0}.package-popup__installed strong{margin-right:5px}@media(min-width:600px){.package-popup__installed{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;-webkit-box-pack:end;-ms-flex-pack:end;justify-content:flex-end;text-align:center}.package-popup__installed strong{display:block;margin:0}}.package-popup__update{margin:0 0 20px;padding:10px 20px 10px 50px;color:#fff;background:#31a64b url(../img/button-update.c63bd5a5.svg) 15px 50% no-repeat;background-size:23px 23px}.view-error{position:fixed;left:0;right:0;top:0;bottom:0;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;padding:10px;color:#e8e8e8;font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;font-size:13px;line-height:1.2;background-color:rgba(0,0,0,.851);background-position:0 0;background-repeat:repeat;z-index:9998}.view-error,.view-error__content{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-align:center;-ms-flex-align:center;align-items:center}.view-error__content{-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;max-width:800px;max-height:100vh;line-height:1.5;text-align:center}.view-error__icon{display:block;height:100px;margin:2em 0;fill:#fff}.view-error__status{margin-bottom:1em;padding:2px 4px;background-color:#e36049;border-radius:2px}.view-error__headline{margin:0;font-size:1em;line-height:1.5}.view-error__status a{color:#e8e8e8;text-decoration:underline}.view-error__details{display:block;margin-top:2em;white-space:pre-line}.view-error__debug{-ms-flex-item-align:start;align-self:flex-start;max-height:60vh;overflow-y:auto;margin-top:2em;text-align:left;white-space:pre-line}.view-error__actions{margin:4em 0;text-align:center}.view-error__link{margin:10px;padding:10px 20px;border:1px solid #fff;border-radius:4px;color:#fff}.widget-text--password input{padding-right:40px!important}.widget__password-toggle{position:absolute;right:8px;bottom:2px;padding:0;margin:0;background:none;border:none;cursor:pointer}.widget__password-toggle--hidden svg{fill:#31a64b}.widget__password-toggle--visible svg{fill:#737373}.view-account__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.view-account__product{margin-top:15px;margin-bottom:40px;font-weight:600}.view-account__product strong{display:block;margin-bottom:10px;font-size:54px;font-weight:100;line-height:1}.view-account__headline{margin-bottom:.5em;font-size:18px;font-weight:600;line-height:30px}.view-account__description{margin-bottom:1em;text-align:justify}.view-account__form{position:relative;max-width:280px;margin:0 auto}.view-account__form .widget-text{margin-top:10px}.view-account__form .widget-text label{display:block;padding-bottom:5px}.view-account__form .widget-button{margin-top:1.5em}.view-account__contribute{max-width:250px;margin:80px auto 0;font-size:12px;text-align:center}.view-account__contribute br{display:none}@media(min-width:960px){.view-account{padding-top:100px}.view-account__header{float:left;width:470px;max-width:none;padding:0 60px}.view-account__form{float:left;width:370px;max-width:none;margin:20px 50px 0}.view-account__form .widget-text label{float:left;width:120px;padding-top:10px;font-weight:400}.view-account__form input[type=password],.view-account__form input[type=text],.view-account__form select{width:250px!important}.view-account__form .widget-button{width:250px;margin-left:120px}.view-account__contribute{max-width:840px}.view-account__contribute br{display:block}}.view-login__header{max-width:280px;margin:0 auto 60px;padding-top:40px;text-align:center}.view-login__product{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-login__form{position:relative;max-width:250px;margin:0 auto 80px}.view-login__form input{padding-right:30px;margin:5px 0 10px}.view-login__locked{max-width:290px;margin:-20px auto 60px;padding:20px;background:#db5041;color:#fff;text-align:center}.view-login__locked strong{white-space:pre}.view-login__headline{margin-bottom:0}.view-login__description{margin-top:.5em;margin-bottom:30px}.view-login label{position:absolute;text-indent:-999em}.view-login label[for=ctrl_username]{top:17px;right:13px;width:16px;height:16px;background:url(../img/person.00d78897.svg) 0 0 no-repeat;background-size:16px 16px;z-index:10}.view-login label[for=ctrl_password]{top:17px;right:12px;width:16px;height:16px;background:url(../img/lock.3c42a55f.svg) 0 0 no-repeat;background-size:14px 14px;z-index:10}.view-login .widget-text--password button{display:none}.view-login__link{display:block;font-size:12px}.view-login__button{margin-top:20px}.view-login__button .sk-circle{color:#fff;text-align:center}.button-menu{position:relative}.button-menu__primary.widget-button{float:left;width:calc(100% - 39px);border-top-right-radius:0;border-bottom-right-radius:0}.button-menu__more.widget-button{float:right;width:38px;padding:7px;border-top-left-radius:0;border-bottom-left-radius:0}.button-menu__more.widget-button svg{width:24px;height:24px}.button-menu__menu{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;position:absolute;top:38px;right:0;width:auto;z-index:100;background:#fff;border-radius:2px}.button-menu__menu:before{content:"";position:absolute;top:-5px;right:15px;width:0;height:0;border-right:none;border-bottom:none;border-left:5px solid transparent;border-right:5px solid transparent;border-bottom:5px solid #fff}.button-menu__menu:focus{outline:none}.button-menu__menu button{padding:8px 16px;background:none;border:none;text-align:left;white-space:nowrap;border-bottom:1px solid #ccc;cursor:pointer}.button-menu__menu button:hover{background:#f0f0f0}.button-menu__menu button:first-child{border-top-left-radius:2px;border-top-right-radius:2px}.button-menu__menu button:last-child{border-bottom:none;border-bottom-left-radius:2px;border-bottom-right-radius:2px}.button-menu__menu .link-menu{margin-top:3px}.console-operation{position:relative;padding:0 16px;text-align:left;font-size:12px;color:#959da5}.console-operation__summary{margin-left:13px;padding:8px;-webkit-box-sizing:border-box;box-sizing:border-box;outline:none}.console-operation__summary--console{margin-left:0}.console-operation summary{cursor:pointer}.console-operation__status{display:inline-block;position:relative;-webkit-box-sizing:border-box;box-sizing:border-box;padding-right:8px;width:24px;height:18px;text-align:center;vertical-align:middle}.console-operation__icon{position:absolute;left:0;top:0}.console-operation__icon--skipped{fill:#666b71}.console-operation__icon--pending{fill:#dbab0a}.console-operation__icon--active{fill:#dbab0a;-webkit-animation:console-active 1s linear infinite;animation:console-active 1s linear infinite}@-webkit-keyframes console-active{0%{-webkit-transform:rotate(0deg);transform:rotate(0deg)}50%{-webkit-transform:rotate(180deg);transform:rotate(180deg)}to{-webkit-transform:rotate(359deg);transform:rotate(359deg)}}@keyframes console-active{0%{-webkit-transform:rotate(0deg);transform:rotate(0deg)}50%{-webkit-transform:rotate(180deg);transform:rotate(180deg)}to{-webkit-transform:rotate(359deg);transform:rotate(359deg)}}.console-operation__icon--success{fill:#31a64b}.console-operation__icon--error{fill:#db5041}.console-operation__label{display:inline-block;overflow:hidden;max-width:750px;vertical-align:top}.console-operation__title{display:inline;margin:0;color:#fff}.console-operation__title--disabled{text-decoration:line-through}.console-operation__description{display:inline;margin:0 0 0 10px}.console-operation__console{position:relative}.console-operation__lines{overflow-y:auto;max-height:250px;padding:8px 0 16px;font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;color:#f6f8fa;line-height:1.5;white-space:pre-wrap;word-break:break-word;overflow-wrap:break-word}.console-operation__line{display:-webkit-box;display:-ms-flexbox;display:flex}.console-operation__line:hover{background-color:#2f363d}.console-operation__line-number{display:inline-block;overflow:hidden;width:48px;min-width:48px;color:#959da5;text-align:right;text-overflow:ellipsis;white-space:nowrap;vertical-align:middle;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.console-operation__line-content{display:inline-block;margin-left:16px;vertical-align:middle}.console-operation__scroll{position:absolute;left:0;right:0;display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:end;-ms-flex-align:end;align-items:flex-end;width:100%;height:30px;padding:0;border:none;cursor:pointer}.console-operation__scroll svg{fill:#fff;width:16px;height:16px}.console-operation__scroll--top{top:0;background:-webkit-gradient(linear,left top,left bottom,from(#24292e),color-stop(50%,rgba(36,41,46,.502)));background:linear-gradient(#24292e,rgba(36,41,46,.502) 50%)}.console-operation__scroll--top svg{-webkit-transform:rotate(180deg);transform:rotate(180deg)}.console-operation__scroll--bottom{bottom:0;background:-webkit-gradient(linear,left top,left bottom,from(rgba(36,41,46,.502)),color-stop(50%,#24292e));background:linear-gradient(rgba(36,41,46,.502),#24292e 50%)}.console-operation__scroll--bottom svg{-webkit-transform:rotate(0deg);transform:rotate(0deg)}.console{background:#24292e}.console__header{display:-webkit-box;display:-ms-flexbox;display:flex;-ms-flex-wrap:nowrap;flex-wrap:nowrap;-webkit-box-pack:justify;-ms-flex-pack:justify;justify-content:space-between;-webkit-box-align:center;-ms-flex-align:center;align-items:center;padding:12px 12px 12px 24px;border-bottom:1px solid #444d56}.console__headline{margin:0;font-size:inherit;line-height:1.5;color:#fff}.console__description{color:#959da5;font-size:12px}.console__actions{display:-webkit-box;display:-ms-flexbox;display:flex;-ms-flex-wrap:nowrap;flex-wrap:nowrap;-webkit-box-align:center;-ms-flex-align:center;align-items:center}.console__action,.console__action>button{height:30px!important;line-height:30px!important;width:auto!important;min-width:0;margin:0 2px;padding:0 5px!important;border:none!important}.console__action:hover,.console__action>button:hover{background-color:#2f363d!important}.console__action--active,.console__action>button--active{background-color:#586069!important}.console__operations{padding:20px 0}.widget-checkbox input{position:absolute;visibility:hidden}.widget-checkbox label{display:block;padding-left:25px;background:url(../img/widget-checkbox--off.73856538.svg) 0 0 no-repeat;background-size:20px 20px;text-align:left}.widget-checkbox input:checked+label{background-image:url(../img/widget-checkbox--on.c05d996c.svg)}.widget-checkbox input:disabled+label{opacity:.5}.widget-checkbox__description{padding-left:25px}.widget-checkbox__description--disabled{opacity:.5}.view-task__header{margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.view-task__icon{background:#f47c00;border-radius:10px;padding:10px}.view-task__headline{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-task__description{margin:0;font-weight:600}.view-task__actions{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;margin-top:2em}@media(min-width:960px){.view-task__actions{-webkit-box-orient:horizontal;-webkit-box-direction:normal;-ms-flex-direction:row;flex-direction:row}}.view-task .widget-button{width:250px;height:35px;margin:5px;padding:0 30px;line-height:35px}@media(min-width:960px){.view-task .widget-button{width:auto}}.view-task__main{margin:0 50px 50px;background:#24292e}.view-task__loading{width:30px;margin:40px auto}.view-task__loading .sk-circle{width:30px;height:30px}.view-task__sponsor{margin:-30px 50px 50px;text-align:center}@media(min-width:960px){.view-task__sponsor br{display:none}}.view-task__donate{position:relative;top:5px;margin-left:.5em;line-height:0}.boot-check{padding:10px}.boot-check:after{display:table;clear:both;content:""}.boot-check__icon{float:left}.boot-check__icon .sk-circle{width:34px;height:34px;margin:3px}.boot-check__icon svg{display:block;width:40px;height:40px}.boot-check__icon--success svg{fill:#31a64b}.boot-check__icon--info svg,.boot-check__icon--warning svg{fill:#db8c41}.boot-check__icon--error svg{fill:#db5041}.boot-check__label{margin-left:50px}.boot-check__description,.boot-check__detail,.boot-check__title{margin:0;line-height:inherit;overflow:hidden;text-overflow:ellipsis}.boot-check__detail{margin-top:5px;font-size:12px}.boot-check__action{margin-left:50px}.boot-check__action button{margin:15px 0 10px;height:33px;line-height:33px}@media(min-width:960px){.boot-check__label{float:left;width:540px;margin-left:10px}.boot-check__action{float:right;margin:0 10px;width:140px;text-align:center}.boot-check__action button{margin:3px 0}.boot-check__action a[target=_blank]{display:inline-block;margin:10px 0;padding-left:20px;background:url(../img/link-blank.c018a22c.svg) 0 no-repeat;background-size:16px 16px}}.config-check__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.config-check__icon{background:#f47c00;border-radius:10px;padding:10px}.config-check__headline{margin-top:20px;margin-bottom:25px;font-size:36px;font-weight:100;line-height:1}.config-check__description{text-align:justify}.config-check__form{position:relative;max-width:280px;margin:0 auto 50px}.config-check__form .widget-select,.config-check__form .widget-text{margin-top:20px}.config-check__form .widget-select label,.config-check__form .widget-text label{display:block;margin-bottom:5px;font-weight:400}.config-check__fields{margin-bottom:2em}.config-check__fieldtitle{margin-bottom:.5em;font-size:18px;font-weight:600;line-height:30px}.config-check__fielddesc{margin-bottom:1em}.config-check__issues{margin-bottom:1em;color:#db5041}.config-check__issues p{font-weight:600}.config-check__issues ul{margin:0;padding:0}.config-check__issues li{margin:.5em 0 0 25px;padding:0}.config-check .widget-button{margin-bottom:.5em}@media(min-width:960px){.config-check{padding-top:100px}.config-check__header{float:left;width:470px;max-width:none;padding:0 60px 100px}.config-check__form{float:left;width:370px;max-width:none;margin:20px 50px 0;padding-bottom:100px}.config-check__form .widget-select label,.config-check__form .widget-text label{display:block;float:left;width:120px;padding-top:10px;font-weight:400}.config-check__form .widget-select input[type=text],.config-check__form .widget-select select,.config-check__form .widget-text input[type=text],.config-check__form .widget-text select{width:250px}.config-check__form .widget-button{width:250px;margin-left:120px}}.view-boot__header{margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.view-boot__icon{background:#f47c00;border-radius:10px;padding:10px}.view-boot__headline{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-boot__description{margin:0;font-weight:600}.view-boot__loading{width:30px;margin:0 auto 40px}.view-boot__loading .sk-circle{width:30px;height:30px}.view-boot__checks{margin:0 20px 50px}.view-boot__checks .boot-check:nth-child(odd){background:#f5f9fa}.view-boot__summary{margin:50px 0 0}.view-boot__summary--error svg{width:100%;height:40px;fill:#db5041}.view-boot__issue{max-width:60%;margin:10px auto;text-align:center;color:#db5041;line-height:1.2em}.view-boot__safeMode{margin:2em auto 0}.view-boot__continue,.view-boot__safeMode{clear:both;display:block!important;width:220px!important}.view-boot__continue{margin:0 auto}@media(min-width:960px){.view-boot__checks{margin:0 80px 50px}}.widget-radio-button legend{margin-bottom:2px}.widget-radio-button>div{position:relative;margin:.25em 0}.widget-radio-button input{position:absolute;visibility:hidden}.widget-radio-button label{display:block;padding-left:25px;background:url(../img/widget-radio--off.4e93f443.svg) 0 -1px no-repeat;background-size:20px 20px}.widget-radio-button input:checked+label{background-image:url(../img/widget-radio--on.181461b6.svg)}.widget-radio-button input:disabled+label{opacity:.5}.setup__directories{margin-top:2em}.setup__directories>dt{margin-top:1em;font-weight:600}.setup__directories>dd{margin:0;word-break:break-all}.setup__directories>dd span{background-color:#ff0;font-weight:400}.theme-details__constraint{-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1}.file-tree{margin:0;padding:0;list-style:none}.file-tree__folder{position:relative;padding-left:20px}.file-tree__folder:before{content:"";position:absolute;left:10px;top:6px;width:0;height:0;border-top:5px solid transparent;border-bottom:5px solid transparent;border-left:5px solid #535353;-webkit-transition:-webkit-transform .1s ease-in-out;transition:-webkit-transform .1s ease-in-out;transition:transform .1s ease-in-out;transition:transform .1s ease-in-out,-webkit-transform .1s ease-in-out}.file-tree__folder--open:before{-webkit-transform:rotate(90deg);transform:rotate(90deg)}.file-tree__file{padding-left:20px}.file-tree button{background:none;border:none;font-weight:400;cursor:pointer}.setup__versions{margin:0;padding:0 0 0 15px}.setup__version{margin:.5em 0;text-align:left}.setup__version--warning{color:#db5041}.setup__releaseplan{margin-top:1.5em}.setup__fielddesc--version{margin-bottom:-1em!important}.setup__core-features{margin:5px 0 0 5px;font-size:12px}.setup__theme-image{max-width:100%;height:auto;border:1px solid #ccc}.setup__theme p{margin:1em 0}.setup__theme-upload{position:absolute!important;visibility:hidden}.setup__themes{padding:0 14px}.setup__themes-item{border:1px solid #ddd3bc}.setup__themes-more{margin-top:20px;text-align:center}@media(min-width:960px){.setup__themes{padding:20px 12px 0}.setup__themes-results{display:-webkit-box;display:-ms-flexbox;display:flex;-ms-flex-wrap:wrap;flex-wrap:wrap}.setup__themes-item{-ms-flex-preferred-size:calc(50% - 16px);flex-basis:calc(50% - 16px);margin-left:8px;margin-right:8px}}.setup__theme-search{margin:20px 0 0;text-align:center}.setup__theme-search--empty{padding-top:60px;background:url(../img/sad.c9a06488.svg) top no-repeat;background-size:50px 50px}.setup__theme-search--offline{padding-top:60px;background:url(../img/offline.1f95ae24.svg) top no-repeat;background-size:50px 50px}.setup__theme-search--loader .sk-circle{width:50px;height:50px;margin:0 auto 20px}.setup__theme-search button{margin-top:2em}.setup__fielddesc--warning{padding:10px 10px 10px 40px;background:#e8c8bc url(../img/hint.ba2ac97e.svg) 10px 10px no-repeat}.setup__tabs{margin:1em 0}.setup__tab-controls{display:-webkit-box;display:-ms-flexbox;display:flex}.setup__tab-control{-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1;padding:4px 10px;border:none;border-top:1px solid #ccc;border-left:1px solid #ccc;background:none;cursor:pointer}.setup__tab-control:last-child{border-right:1px solid #ccc}.setup__tab-control--active{border-color:#737373;background:#737373;color:#fff}.setup__tab{border:1px solid #ccc}.setup__tab--files{white-space:pre;overflow:scroll;height:200px}.setup__requires{width:100%;border-collapse:collapse}.setup__requires td,.setup__requires th{margin:0;padding:3px 10px;text-align:start;vertical-align:top}.setup__requires th{background:#737373;color:#fff}.setup__requires td{border-bottom:1px solid #ccc}.setup__requires tr:last-child td{border-bottom:none}.setup__requires tr:nth-child(odd) td{background:#f5f5f5}.setup__or{position:relative;overflow:hidden;margin:1em 0;text-align:center}.setup__or:before{content:"";position:absolute;top:.8em;left:0;right:0;display:block;height:1px;background:#ccc;z-index:1}.setup__or span{position:relative;padding:0 10px;background:#fff;z-index:2}.view-setup{padding-top:40px}.view-setup footer{margin-top:40px}.view-setup__steps{padding:0 0 50px 0}.view-setup__steps ul{list-style-type:none}.view-setup__steps li,.view-setup__steps ul{display:-webkit-box;display:-ms-flexbox;display:flex;margin:0;padding:0}.view-setup__steps li{-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1;position:relative;height:6px}.view-setup__steps li:before{content:"";position:absolute;left:-50%;right:50%;background:#ccc;height:5px}.view-setup__steps li:after{content:"";position:absolute;top:-18px;left:50%;margin-left:-21px;width:42px;height:42px;color:#fff;text-indent:0;text-align:center;line-height:35px;background:#ccc;border-radius:50%;z-index:1}.view-setup__steps li:first-child:before{content:none}.view-setup__steps li.active:after,.view-setup__steps li.active:before{background:#f47c00}.view-setup__steps button{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;background:transparent;border:none;z-index:10;cursor:pointer}.view-setup__steps button:disabled{cursor:default}.view-setup__steps svg{fill:#fff}.view-setup__main{text-align:center}.view-setup__party{font-size:64px}.view-setup__headline{margin:10px 0 20px;padding:15px 0;font-size:42px;font-weight:100}.view-setup__description{max-width:500px;margin:1em 25px}.view-setup__start.widget-button{height:50px;margin:30px 10px 0;padding:0 50px;font-size:1.2em;line-height:50px}.view-setup__continue.widget-button{width:80%!important;margin:10px 0 0}.view-setup__funding{width:80%;margin:50px auto 0;padding:20px 25px;border:2px solid #ea4aaa}.view-setup__funding figure{margin-bottom:1em}.view-setup__funding p{margin:0 0 .5em 0}.view-setup__funding-link{margin:1em 0 0!important}@media(min-width:960px){.view-setup{padding-top:80px}.view-setup footer{margin-top:80px}.view-setup__steps{padding-bottom:80px}.view-setup__headline{margin:20px 0 40px;font-size:64px}.view-setup__continue.widget-button{width:auto!important;margin:25px 10px 0;padding:0 20px}.view-setup__description{max-width:550px;margin:1em auto;font-size:1.2em}.view-setup__funding{display:-webkit-box;display:-ms-flexbox;display:flex;margin:60px auto -20px;text-align:left}.view-setup__funding figure{margin-right:25px}}.setup__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.setup__header .widget-button{margin-top:1em}.setup__icon{background:#f47c00;border-radius:10px;padding:10px}.setup__headline{margin-top:20px;margin-bottom:25px;font-size:36px;font-weight:100;line-height:1}.setup__description,.setup__warning{margin:1em 0;text-align:justify}.setup__warning{color:#db5041;font-weight:600}.setup__form{position:relative;max-width:280px;margin:0 auto 50px;opacity:1}.setup__form svg.setup__check{display:block;width:80px;height:80px;margin:0 auto 2em;fill:#31a64b}.setup__form .widget-select,.setup__form .widget-text{margin-top:10px}.setup__form .widget-select label,.setup__form .widget-text label{display:block;margin-bottom:5px;font-weight:400}.setup__form .widget-checkbox{margin-top:20px;font-weight:400}.setup__form .widget-radio-button{margin-top:20px}.setup__fields{margin-bottom:2em}.setup__fields--center{text-align:center}.setup__fields .button-group .widget-button{margin-bottom:1px}.setup__fieldtitle{margin-bottom:.5em;font-size:18px;font-weight:600;line-height:30px}.setup__fielddesc{margin-bottom:1em;text-align:left}.setup__fielddesc code{word-break:break-word}.setup__actions{display:-webkit-box;display:-ms-flexbox;display:flex;-ms-flex-wrap:wrap;flex-wrap:wrap;gap:10px}.setup__actions--center{-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center}.setup__actions .button-group,.setup__actions .widget-button{-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1}.setup__actions .button-group--inline,.setup__actions .widget-button--inline{-webkit-box-flex:0;-ms-flex-positive:0;flex-grow:0}@media(min-width:960px){.setup{padding-top:100px}.setup__header{float:left;width:470px;max-width:none;padding:0 60px}.setup__form{float:left;width:370px;max-width:none;margin:0 50px}.setup__form .widget-select label,.setup__form .widget-text label{display:block;float:left;width:120px;padding-top:10px;font-weight:400}.setup__form .widget-select input,.setup__form .widget-select select,.setup__form .widget-text input,.setup__form .widget-text select{width:250px!important}}.view-recovery__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0 10px;text-align:center}.view-recovery__icon{background:#f47c00;border-radius:10px;padding:10px}.view-recovery__headline{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-recovery__content{margin:0 30px 50px}@media(min-width:960px){.view-recovery__content{margin-left:50px;margin-right:50px}}.view-recovery__description{font-weight:600;max-width:600px;margin:0 auto;text-align:center}.view-recovery__console{margin:30px 0 60px}.view-recovery__option{margin:50px 0 0;padding:20px 20px 30px;background:#f5f9fa;text-align:center}.view-recovery__option h3{position:relative;top:-40px;margin-bottom:-25px;font-size:2em;font-weight:300}.view-recovery__option button{margin-top:1.5em}.view-recovery__failed{margin:10px 0;color:#db5041;font-weight:600}.database-migration__header{margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.database-migration__icon{background:#f47c00;border-radius:10px;padding:10px}.database-migration__headline{margin-top:.5em;margin-bottom:.5em;font-size:36px;font-weight:100;line-height:1}.database-migration__description{margin:0 50px;font-weight:600}.database-migration__actions{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;margin-top:2em;padding:0 50px}@media(min-width:960px){.database-migration__actions{-webkit-box-orient:horizontal;-webkit-box-direction:normal;-ms-flex-direction:row;flex-direction:row}}.database-migration .widget-button{width:250px;height:35px;margin:5px;padding:0 30px;line-height:35px}@media(min-width:960px){.database-migration .widget-button{width:auto}}.database-migration__main{margin:0 50px 50px;background:#24292e}.database-migration__loading{width:30px;margin:40px auto}.database-migration__loading .sk-circle{width:30px;height:30px}html{-webkit-box-sizing:border-box;box-sizing:border-box}*,:after,:before{-webkit-box-sizing:inherit;box-sizing:inherit}#app,body,html{height:100%}blockquote,body,figure,form,p{margin:0;padding:0}article,aside,figcaption,figure,footer,header,main,nav,section{display:block}body,div,fieldset,form,h1,h2,h3,h4,h5,h6,html,p{-webkit-text-size-adjust:none;-moz-text-size-adjust:none;-ms-text-size-adjust:none;text-size-adjust:none}body{background:#ebe6db;overflow-y:hidden}#app{overflow-y:scroll}fieldset{border:none;margin:0;padding:0}legend{-webkit-padding-start:0;-webkit-padding-end:0}body,button,input,textarea{font:300 14px/1.4 -apple-system,system-ui,Segoe UI,Roboto,Oxygen-Sans,Ubuntu,Cantarell,Helvetica Neue,sans-serif;color:#535353}strong{font-weight:600}code{font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace}input,select,textarea{font-size:99%}input:disabled,select:disabled,textarea:disabled{color:#535353;-webkit-text-fill-color:#535353;cursor:text}input::-ms-clear,input::-ms-reveal,select::-ms-clear,select::-ms-reveal,textarea::-ms-clear,textarea::-ms-reveal{display:none}.invisible{border:0;clip:rect(0 0 0 0);height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;width:1px}.clearfix{*zoom:1}.clearfix:after,.clearfix:before{display:table;content:"";line-height:0}.clearfix:after{clear:both}h1,h2,h3,h4,h5,h6{font-size:inherit;line-height:inherit;font-weight:600;margin:0}a{color:#f47c00;text-decoration:none}a:hover{text-decoration:underline}h1{font-size:18px;line-height:30px;margin-bottom:10px}@-webkit-keyframes input-error{0%{left:0}25%{left:-5px}75%{left:5px}to{left:0}}@keyframes input-error{0%{left:0}25%{left:-5px}75%{left:5px}to{left:0}}.widget{position:relative}.widget__error{display:none;position:absolute;bottom:-6px;left:0;right:0;margin:0;padding:4px 10px;color:#fff;background:#db5041;border-radius:2px;-webkit-transform:translateY(100%);transform:translateY(100%);z-index:10;white-space:pre-line}.widget__error:after,.widget__error:before{bottom:100%;left:50%;border:solid transparent;content:" ";height:0;width:0;position:absolute;pointer-events:none}.widget__error:after{border-bottom-color:#db5041;border-width:3px;margin-left:-3px}.widget__error:before{border-bottom-color:#db5041;border-width:5px;margin-left:-5px}input:focus+.widget__error,input:hover+.widget__error,select:hover+.widget__error{display:block}input:not([type=checkbox]):not([type=radio]),select{position:relative;width:100%;height:38px;padding:0 10px 0 10px;background:#fff;border:1px solid #ccc;border-radius:2px;color:#535353;-webkit-appearance:none;-moz-appearance:none;appearance:none}input:not([type=checkbox]):not([type=radio]):focus,select:focus{outline:none;background-color:#f9f9f9}.widget--validate input:not([type=checkbox]):not([type=radio]):not(:-moz-placeholder-shown):valid,.widget--validate select:not(:-moz-placeholder-shown):valid{border-color:#31a64b}.widget--validate input:not([type=checkbox]):not([type=radio]):not(:-ms-input-placeholder):valid,.widget--validate select:not(:-ms-input-placeholder):valid{border-color:#31a64b}.widget--validate input:not([type=checkbox]):not([type=radio]):not(:placeholder-shown):valid,.widget--validate select:not(:placeholder-shown):valid{border-color:#31a64b}.widget--validate input:not([type=checkbox]):not([type=radio]):not(:-moz-placeholder-shown):invalid,.widget--validate select:not(:-moz-placeholder-shown):invalid{border-color:#db5041}.widget--validate input:not([type=checkbox]):not([type=radio]):not(:-ms-input-placeholder):invalid,.widget--validate select:not(:-ms-input-placeholder):invalid{border-color:#db5041}.widget--validate input:not([type=checkbox]):not([type=radio]):not(:placeholder-shown):invalid,.widget--validate select:not(:placeholder-shown):invalid{border-color:#db5041}.widget--error input:not([type=checkbox]):not([type=radio]),.widget--error select{border-color:#db5041;-webkit-animation:input-error .15s linear 3;animation:input-error .15s linear 3}select{padding-right:30px}.widget-select:after{position:absolute;right:12px;bottom:16px;width:0;height:0;border-left:6px solid transparent;border-right:6px solid transparent;border-top:6px solid #ccc;content:"";pointer-events:none}.widget-button{display:inline-block;width:100%;height:38px;padding:0;border:none;background-color:#737373;color:#fff;font-weight:600;line-height:38px;text-decoration:none;text-align:center;white-space:nowrap;cursor:pointer;border-bottom:1px solid inherit;border-radius:2px}.widget-button:active,.widget-button:hover{background-color:#666;border-bottom:1px solid #5a5a5a}.widget-button--inline{width:auto!important;min-width:100px;padding:0 20px}.widget-button--transparent{background:transparent}.widget-button--small{height:28px;width:auto!important;min-width:0;padding:0 15px;font-size:13px;line-height:28px;font-weight:300;border-radius:1px}.widget-button--small:before,.widget-button--small>:before{top:3px!important;width:15px!important;height:15px!important;margin-right:4px!important;background-size:15px 15px!important}.widget-button--primary{background-color:#31a64b}.widget-button--primary:active,.widget-button--primary:hover{background-color:#2b9242;border-bottom:1px solid #257f39}.widget-button--warning{background-color:#db8c41}.widget-button--warning:active,.widget-button--warning:hover{background-color:#d77f2c;border-bottom:1px solid #c47225}.widget-button--alert{background-color:#db5041}.widget-button--alert:active,.widget-button--alert:hover{background-color:#d73c2c;border-bottom:1px solid #c43525}.widget-button--info{background-color:#6a8ca6}.widget-button--info:active,.widget-button--info:hover{background-color:#5c7f9a;border-bottom:1px solid #53728a}.widget-button--funding{background-color:#ea4aaa}.widget-button--funding:active,.widget-button--funding:hover{background-color:#e7339f;border-bottom:1px solid #e51c95}.widget-button--add:before{background-image:url(../img/button-add.759df12e.svg)}.widget-button--check:before{background-image:url(../img/button-check.8170bc92.svg)}.widget-button--cloud:before{background-image:url(../img/button-cloud.5015c41d.svg)}.widget-button--cloud-off:before{background-image:url(../img/button-cloud-off.37842942.svg)}.widget-button--console:before{background-image:url(../img/button-console.93e68609.svg)}.widget-button--database:before{background-image:url(../img/button-database.1f267fe1.svg)}.widget-button--download:before{background-image:url(../img/button-download.ce5cd0d3.svg)}.widget-button--edit:before{background-image:url(../img/button-edit.d4a8737e.svg)}.widget-button--gear:before{background-image:url(../img/button-gear.75fa79f0.svg)}.widget-button--hide:before{background-image:url(../img/button-hide.6a3eaaf7.svg)}.widget-button--details:before{background-image:url(../img/button-details.78532630.svg)}.widget-button--link:before{background-image:url(../img/button-link.e4488c1f.svg)}.widget-button--lock:before{background-image:url(../img/button-lock.98988f08.svg)}.widget-button--maintenance:before{background-image:url(../img/button-maintenance.18fa2ce6.svg)}.widget-button--more:before{background-image:url(../img/button-more.e3eb2622.svg)}.widget-button--power:before{background-image:url(../img/button-power.6b957f3a.svg)}.widget-button--run:before{background-image:url(../img/button-run.5c7703ae.svg)}.widget-button--save:before{background-image:url(../img/button-save.7704614c.svg)}.widget-button--search:before{background-image:url(../img/button-search.6f2edfbf.svg)}.widget-button--show:before{background-image:url(../img/button-show.2336e1d9.svg)}.widget-button--trash:before{background-image:url(../img/button-trash.a2f11028.svg)}.widget-button--unlock:before{background-image:url(../img/button-unlock.51b76e07.svg)}.widget-button--update:before{background-image:url(../img/button-update.c63bd5a5.svg)}.widget-button--upload:before{background-image:url(../img/button-upload.b489ceec.svg)}.widget-button .icon-selector:before,.widget-button--add:before,.widget-button--check:before,.widget-button--cloud-off:before,.widget-button--cloud:before,.widget-button--console:before,.widget-button--database:before,.widget-button--details:before,.widget-button--download:before,.widget-button--edit:before,.widget-button--gear:before,.widget-button--hide:before,.widget-button--link:before,.widget-button--lock:before,.widget-button--maintenance:before,.widget-button--more:before,.widget-button--power:before,.widget-button--run:before,.widget-button--save:before,.widget-button--search:before,.widget-button--show:before,.widget-button--trash:before,.widget-button--unlock:before,.widget-button--update:before,.widget-button--upload:before{position:relative;display:inline-block;top:5px;width:20px;height:20px;margin-right:8px;background-position:50%;background-repeat:no-repeat;background-size:20px 20px;content:""}.widget-button .icon-selector:empty:before,.widget-button--add:empty:before,.widget-button--check:empty:before,.widget-button--cloud-off:empty:before,.widget-button--cloud:empty:before,.widget-button--console:empty:before,.widget-button--database:empty:before,.widget-button--details:empty:before,.widget-button--download:empty:before,.widget-button--edit:empty:before,.widget-button--gear:empty:before,.widget-button--hide:empty:before,.widget-button--link:empty:before,.widget-button--lock:empty:before,.widget-button--maintenance:empty:before,.widget-button--more:empty:before,.widget-button--power:empty:before,.widget-button--run:empty:before,.widget-button--save:empty:before,.widget-button--search:empty:before,.widget-button--show:empty:before,.widget-button--trash:empty:before,.widget-button--unlock:empty:before,.widget-button--update:empty:before,.widget-button--upload:empty:before{margin-right:0!important}.widget-button:empty{min-width:auto;padding:0 10px}.widget-button:empty:before{margin-right:0!important}.widget-button:hover{text-decoration:none}.widget-button.disabled,.widget-button:disabled{background-color:#ccc!important;border-color:#ccc!important;cursor:not-allowed}.widget-button.disabled{pointer-events:none}label{padding:0}.widget--required label:after{margin-left:2px;content:"*";color:#db5041}.animate-initializing{-webkit-animation:initializing 1s linear infinite;animation:initializing 1s linear infinite}@-webkit-keyframes initializing{0%{opacity:.5}50%{opacity:1}to{opacity:.5}}@keyframes initializing{0%{opacity:.5}50%{opacity:1}to{opacity:.5}}.animate-blur-in{z-index:-1;opacity:.5;-webkit-filter:blur(4px);filter:blur(4px);-webkit-transition:opacity .5s,-webkit-filter .5s;transition:opacity .5s,-webkit-filter .5s;transition:opacity .5s,filter .5s;transition:opacity .5s,filter .5s,-webkit-filter .5s}.animate-blur-out{opacity:1;-webkit-transition:opacity .5s;transition:opacity .5s}.animate-fade-enter-active,.animate-fade-leave-active{-webkit-transition-duration:.2s;transition-duration:.2s;-webkit-transition-property:opacity;transition-property:opacity;-webkit-transition-timing-function:ease;transition-timing-function:ease}.animate-fade-enter,.animate-fade-leave-active{opacity:0}.animate-flip-enter-active,.animate-flip-leave-active{-webkit-transform-style:preserve-3d;transform-style:preserve-3d;-webkit-backface-visibility:hidden;backface-visibility:hidden;-webkit-transition-duration:.5s;transition-duration:.5s;-webkit-transition-property:opacity,-webkit-transform;transition-property:opacity,-webkit-transform;transition-property:transform,opacity;transition-property:transform,opacity,-webkit-transform}.animate-flip-leave-active{-webkit-transform:perspective(600px) rotateY(0deg);transform:perspective(600px) rotateY(0deg);opacity:1}.animate-flip-leave-to{-webkit-transform:perspective(600px) rotateY(90deg);transform:perspective(600px) rotateY(90deg);-webkit-transition-timing-function:ease-in;transition-timing-function:ease-in;opacity:0}.animate-flip-enter-active{-webkit-transform:perspective(400px) rotateY(270deg);transform:perspective(400px) rotateY(270deg);opacity:0}.animate-flip-enter-to{-webkit-transform:perspective(400px) rotateY(1turn);transform:perspective(400px) rotateY(1turn);-webkit-transition-timing-function:ease-out;transition-timing-function:ease-out;opacity:1}.https-warning{position:absolute;top:0;left:0;right:0;height:27px;padding:4px 8px;background:#db8c41;color:#fff;text-align:center;z-index:100}.https-warning__description{display:none}@media(min-width:600px){.https-warning__description{display:inline}}.https-warning__link{color:#fff;text-decoration:underline}.https-warning+div{padding-top:25px}.safe-mode{position:absolute;top:0;left:0;right:0;height:27px;padding:4px 8px;background:#db5041;color:#fff;text-align:center;z-index:100}.safe-mode__description{display:none}@media(min-width:600px){.safe-mode__description{display:inline}}.safe-mode__link{color:#fff;text-decoration:underline}.safe-mode+div{padding-top:25px}.view-init{display:table;width:100%;height:100%}.view-init__cell{display:table-cell;font-size:1.5em;text-align:center;vertical-align:middle}.popup-overlay{position:fixed;top:0;right:0;bottom:0;left:0;z-index:1000}@media(min-width:960px){.popup-overlay{padding:20px 0;overflow-y:auto}}.loader__item{float:left;width:16px;height:16px;margin-right:1px;background-color:#f47c00;-webkit-animation:loading 1.4s ease-in-out infinite both;animation:loading 1.4s ease-in-out infinite both}.loader__item--20{-webkit-animation-delay:-.64s;animation-delay:-.64s}.loader__item--40{-webkit-animation-delay:-.48s;animation-delay:-.48s}.loader__item--60{-webkit-animation-delay:-.32s;animation-delay:-.32s}.loader__item--80{-webkit-animation-delay:-.16s;animation-delay:-.16s}@-webkit-keyframes loading{0%,90%,to{opacity:0}20%{opacity:1}}@keyframes loading{0%,90%,to{opacity:0}20%{opacity:1}}.loader__text{float:left;width:40px}.sk-circle{width:25px;height:25px;position:relative}.sk-circle .sk-child{width:100%;height:100%;position:absolute;left:0;top:0}.sk-circle .sk-child:before{content:"";display:block;margin:0 auto;width:15%;height:15%;background-color:#535353;border-radius:100%;-webkit-animation:sk-circleBounceDelay 1.2s ease-in-out infinite both;animation:sk-circleBounceDelay 1.2s ease-in-out infinite both}.sk-circle .sk-circle2{-webkit-transform:rotate(30deg);transform:rotate(30deg)}.sk-circle .sk-circle3{-webkit-transform:rotate(60deg);transform:rotate(60deg)}.sk-circle .sk-circle4{-webkit-transform:rotate(90deg);transform:rotate(90deg)}.sk-circle .sk-circle5{-webkit-transform:rotate(120deg);transform:rotate(120deg)}.sk-circle .sk-circle6{-webkit-transform:rotate(150deg);transform:rotate(150deg)}.sk-circle .sk-circle7{-webkit-transform:rotate(180deg);transform:rotate(180deg)}.sk-circle .sk-circle8{-webkit-transform:rotate(210deg);transform:rotate(210deg)}.sk-circle .sk-circle9{-webkit-transform:rotate(240deg);transform:rotate(240deg)}.sk-circle .sk-circle10{-webkit-transform:rotate(270deg);transform:rotate(270deg)}.sk-circle .sk-circle11{-webkit-transform:rotate(300deg);transform:rotate(300deg)}.sk-circle .sk-circle12{-webkit-transform:rotate(330deg);transform:rotate(330deg)}.sk-circle .sk-circle2:before{-webkit-animation-delay:-1.1s;animation-delay:-1.1s}.sk-circle .sk-circle3:before{-webkit-animation-delay:-1s;animation-delay:-1s}.sk-circle .sk-circle4:before{-webkit-animation-delay:-.9s;animation-delay:-.9s}.sk-circle .sk-circle5:before{-webkit-animation-delay:-.8s;animation-delay:-.8s}.sk-circle .sk-circle6:before{-webkit-animation-delay:-.7s;animation-delay:-.7s}.sk-circle .sk-circle7:before{-webkit-animation-delay:-.6s;animation-delay:-.6s}.sk-circle .sk-circle8:before{-webkit-animation-delay:-.5s;animation-delay:-.5s}.sk-circle .sk-circle9:before{-webkit-animation-delay:-.4s;animation-delay:-.4s}.sk-circle .sk-circle10:before{-webkit-animation-delay:-.3s;animation-delay:-.3s}.sk-circle .sk-circle11:before{-webkit-animation-delay:-.2s;animation-delay:-.2s}.sk-circle .sk-circle12:before{-webkit-animation-delay:-.1s;animation-delay:-.1s}@-webkit-keyframes sk-circleBounceDelay{0%,80%,to{-webkit-transform:scale(0);transform:scale(0)}40%{-webkit-transform:scale(1);transform:scale(1)}}@keyframes sk-circleBounceDelay{0%,80%,to{-webkit-transform:scale(0);transform:scale(0)}40%{-webkit-transform:scale(1);transform:scale(1)}}.widget-button .loader{width:25px;margin:0 auto}.widget-button .sk-circle .sk-child:before{background-color:#fff}.loading-button{position:relative}.loading-button>.loader{position:absolute;left:calc(50% - 12.5px);top:calc(50% - 12.5px)}.loading-button>.loading{visibility:hidden}.package-logo--fallback[data-v-622648b4]{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;background:#e9eef1}svg[data-v-622648b4]{width:80%;height:80%;fill:#babec1}.discover-package{position:relative;overflow:hidden;margin-bottom:14px;padding:20px;background:#fff;border-bottom:3px solid #ddd3bc;border-radius:2px}.discover-package__abandoned{display:inline-block;margin-bottom:1em;padding:2px 5px;color:#fff;font-size:12px;font-weight:600;background:#db5041;cursor:help;z-index:10}@media(min-width:600px){.discover-package__abandoned{position:absolute;top:20px;left:-25px;padding:2px 30px;border-top:1px solid #c43525;border-bottom:1px solid #99291d;-webkit-transform:rotate(-45deg);transform:rotate(-45deg)}}.discover-package__icon{position:absolute;right:20px;height:42px;width:42px;margin-left:1em}.discover-package__icon--fallback{display:none}.discover-package__icon img{position:absolute;width:100%;height:auto;max-height:100%}@media(min-width:600px){.discover-package__icon{position:relative;right:auto;display:block;float:left;width:90px;height:90px;margin-left:0;margin-right:20px}}@media(min-width:1024px){.discover-package__icon{position:absolute;right:20px;height:50px;width:50px;margin-left:1em;margin-right:0}.discover-package__icon--fallback{display:none}}@media(min-width:1200px){.discover-package__icon{position:relative;right:auto;display:block;float:left;width:90px;height:90px;margin-left:0;margin-right:20px}}.discover-package__details{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;-webkit-box-pack:justify;-ms-flex-pack:justify;justify-content:space-between}@media(min-width:600px){.discover-package__details{height:100%;min-height:90px}}.discover-package__headline{margin-bottom:.2em;line-height:1;margin-right:50px;overflow-wrap:break-word}.discover-package__headline--fallback{margin-right:0}@media(min-width:600px){.discover-package__headline{margin-right:0}}@media(min-width:1024px){.discover-package__headline{margin-right:60px}.discover-package__headline--fallback{margin-right:0}}@media(min-width:1200px){.discover-package__headline{margin-right:0}}.discover-package__headline em{background-color:#ff0;font-style:normal}.discover-package__description{display:-webkit-box;overflow:hidden;-webkit-line-clamp:2;-webkit-box-orient:vertical;margin-bottom:.5em;margin-right:50px}.discover-package__description--fallback{margin-right:0}@media(min-width:600px){.discover-package__description{margin-right:0}}@media(min-width:1024px){.discover-package__description{margin-right:60px}.discover-package__description--fallback{margin-right:0}}@media(min-width:1200px){.discover-package__description{margin-right:0}}.discover-package__description em{background-color:#ff0;font-style:normal}.discover-package__more{display:-webkit-box;display:-ms-flexbox;display:flex;-ms-flex-wrap:wrap;flex-wrap:wrap;-webkit-box-pack:justify;-ms-flex-pack:justify;justify-content:space-between;-webkit-box-align:end;-ms-flex-align:end;align-items:flex-end;margin-bottom:-.5em;line-height:28px}.discover-package__counts,.discover-package__more{-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1}.discover-package__counts{margin-bottom:.5em}@media(min-width:600px){.discover-package__counts{margin-bottom:0}}.discover-package__count{display:inline-block;margin-right:15px;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.discover-package__count--private{background-image:url(../img/private.c66d3582.svg)}.discover-package__count--updated{background-image:url(../img/updated.455f42dc.svg)}.discover-package__count--downloads{background-image:url(../img/downloads.aa84cdf1.svg)}.discover-package__count--favers{background-image:url(../img/favers.31587387.svg)}.discover-package__actions{-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1;display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:end;-ms-flex-pack:end;justify-content:flex-end;margin:0 -4px .5em}.discover-package__actions>*{margin:0 4px}@media(min-width:600px){.discover-package__actions{margin-bottom:0}}.vueperslide{white-space:normal;background-size:cover;-ms-flex-negative:0;flex-shrink:0;display:block;width:100%;position:relative}.vueperslide--clone-1{position:absolute;top:0;bottom:0;right:100%}.vueperslides--rtl .vueperslide--clone-1{right:auto;left:100%}.vueperslide[href]{-webkit-user-drag:none}.vueperslide__image{background-size:cover}.vueperslide__image,.vueperslide__loader{position:absolute;top:0;left:0;right:0;bottom:0}.vueperslide__loader{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;-webkit-box-align:center;-ms-flex-align:center;align-items:center;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center}.vueperslide__content-wrapper:not(.vueperslide__content-wrapper--outside-top):not(.vueperslide__content-wrapper--outside-bottom){height:100%;margin:auto}.vueperslides--fade .vueperslide{position:absolute;top:0;left:0;right:0;bottom:0;opacity:0;-webkit-transition:opacity ease-in-out;transition:opacity ease-in-out;-webkit-transition-duration:inherit;transition-duration:inherit}.vueperslides--fade .vueperslide--active,.vueperslides--fade .vueperslide--visible{z-index:1;opacity:1}.vueperslides--slide-image-inside .vueperslide{overflow:hidden}.vueperslides--3d .vueperslide{position:absolute;z-index:-1;height:100%}.vueperslides--3d .vueperslide--active,.vueperslides--3d .vueperslide--next-slide,.vueperslides--3d .vueperslide--previous-slide{z-index:0}.vueperslides--3d .vueperslide--active{z-index:1}.vueperslides--3d .vueperslide[face=front]{-webkit-transform:rotateY(90deg) translateX(-50%) rotateY(-90deg);transform:rotateY(90deg) translateX(-50%) rotateY(-90deg)}.vueperslides--3d .vueperslide[face=right]{-webkit-transform:rotateY(90deg) translateX(50%);transform:rotateY(90deg) translateX(50%);-webkit-transform-origin:100% 0;transform-origin:100% 0}.vueperslides--3d .vueperslide[face=back]{-webkit-transform:rotateY(270deg) translateX(-50%) rotateY(-90deg);transform:rotateY(270deg) translateX(-50%) rotateY(-90deg)}.vueperslides--3d .vueperslide[face=left]{-webkit-transform:rotateY(270deg) translateX(-50%);transform:rotateY(270deg) translateX(-50%);-webkit-transform-origin:0 0;transform-origin:0 0}.vueperslides:not(.no-shadow):not(.vueperslides--3d) .vueperslides__parallax-wrapper:after,.vueperslides:not(.no-shadow):not(.vueperslides--3d) .vueperslides__parallax-wrapper:before{content:"";position:absolute;bottom:100%;left:-1em;right:-1em;height:2em;-webkit-box-shadow:0 0 20px rgba(0,0,0,.25);box-shadow:0 0 20px rgba(0,0,0,.25);z-index:2}.vueperslides:not(.no-shadow):not(.vueperslides--3d) .vueperslides__parallax-wrapper:after{top:100%;bottom:auto}.vueperslides__arrows{color:#fff}.vueperslides__arrows--outside{color:currentColor}.vueperslides__arrow{top:50%;background-color:transparent;border:none;opacity:.7}.vueperslides--rtl .vueperslides__arrow--next,.vueperslides__arrow--prev{right:auto;left:.5em}.vueperslides--rtl .vueperslides__arrow--prev,.vueperslides__arrow--next{left:auto;right:.5em}.vueperslides__arrow:hover{opacity:1}.vueperslides--rtl .vueperslides__arrows--outside .vueperslides__arrow--next,.vueperslides__arrows--outside .vueperslides__arrow--prev{right:auto;left:-3.5em}.vueperslides--rtl .vueperslides__arrows--outside .vueperslides__arrow--prev,.vueperslides__arrows--outside .vueperslides__arrow--next{left:auto;right:-3.5em}.vueperslides__paused{top:.7em;right:.7em;opacity:0;text-shadow:0 0 3px rgba(0,0,0,.4);z-index:1}.vueperslides:hover .vueperslides__paused{opacity:1}.vueperslides__bullets:not(.vueperslides__bullets--outside){color:#fff}.vueperslides__bullet{margin:1.5em .6em;padding:0;border:none;background:none}.vueperslides__bullet .default{width:12px;height:12px;border-radius:12px;border:1px solid currentColor;background-color:transparent;-webkit-box-shadow:0 0 1px rgba(0,0,0,.5),0 0 3px rgba(0,0,0,.3);box-shadow:0 0 1px rgba(0,0,0,.5),0 0 3px rgba(0,0,0,.3);-webkit-transition:.4s ease-in-out;transition:.4s ease-in-out;-webkit-box-sizing:border-box;box-sizing:border-box}.vueperslides__bullet .default span{display:none}.vueperslides__bullet--active .default{border-width:6px}.vueperslide,.vueperslide__image{background-position:50%}.vueperslide__video{outline:none}.vueperslide--no-pointer-events:before{content:"";position:absolute;top:0;bottom:0;left:0;right:0}.vueperslide__content-wrapper:not(.vueperslide__content-wrapper--outside-top):not(.vueperslide__content-wrapper--outside-bottom){display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-flex:1;-ms-flex:1 1 auto;flex:1 1 auto;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;-webkit-box-align:center;-ms-flex-align:center;align-items:center;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;text-align:center}.vueperslide--has-image-inside .vueperslide__content-wrapper,.vueperslide--has-video .vueperslide__content-wrapper,.vueperslide__content-wrapper.parallax-fixed-content{position:absolute;z-index:2;top:0;bottom:0;left:0;right:0;display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;pointer-events:none}.vueperslides{position:relative}.vueperslides--fixed-height .vueperslide,.vueperslides--fixed-height .vueperslides__inner,.vueperslides--fixed-height .vueperslides__parallax-wrapper{height:inherit}.vueperslides--fixed-height .vueperslides__parallax-wrapper{padding-bottom:0!important}.vueperslides--fixed-height.vueperslides--bullets-outside{margin-bottom:4em}.vueperslides__inner{position:relative;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.vueperslides__parallax-wrapper{position:relative;overflow:hidden}.vueperslides--3d .vueperslides__parallax-wrapper{overflow:visible}.vueperslides__track{position:absolute;top:0;height:100%;left:0;right:0;overflow:hidden;z-index:1}.vueperslides--parallax .vueperslides__track{height:200%;-webkit-transform:translateY(0);transform:translateY(0)}.vueperslides--touchable .vueperslides__track{cursor:ew-resize;cursor:-webkit-grab;cursor:grab}.vueperslides--touchable .vueperslides__track--dragging,.vueperslides--touchable .vueperslides__track--mousedown{cursor:-webkit-grabbing;cursor:grabbing}.vueperslides--3d .vueperslides__track{overflow:visible;-webkit-perspective:100em;perspective:100em}.vueperslides__track-inner{white-space:nowrap;-webkit-transition:transform .5s ease-in-out;-webkit-transition:-webkit-transform .5s ease-in-out;transition:-webkit-transform .5s ease-in-out;transition:transform .5s ease-in-out;transition:transform .5s ease-in-out,-webkit-transform .5s ease-in-out;height:100%;display:-webkit-box;display:-ms-flexbox;display:flex}.vueperslides--no-animation .vueperslides__track-inner{-webkit-transition-duration:0s!important;transition-duration:0s!important}.vueperslides--fade .vueperslides__track-inner{white-space:normal;-webkit-transition:none;transition:none}.vueperslides--3d .vueperslides__track-inner{-webkit-transform-style:preserve-3d;transform-style:preserve-3d}.vueperslides__track--mousedown .vueperslides__track-inner{-webkit-transition:transform .25s ease-in-out!important;-webkit-transition:-webkit-transform .25s ease-in-out!important;transition:-webkit-transform .25s ease-in-out!important;transition:transform .25s ease-in-out!important;transition:transform .25s ease-in-out,-webkit-transform .25s ease-in-out!important}.vueperslides__track--dragging .vueperslides__track-inner{-webkit-transition:none;transition:none}.vueperslides__arrow{position:absolute;font-size:inherit;color:inherit;text-align:center;-webkit-transform:translateY(-50%);transform:translateY(-50%);cursor:pointer;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;outline:none;z-index:2;line-height:1}.vueperslides__arrow,.vueperslides__arrow svg{-webkit-transition:.3s ease-in-out;transition:.3s ease-in-out}.vueperslides__arrow svg{vertical-align:middle;stroke:currentColor;fill:none;width:3.5em;padding:1em;stroke-width:1;-webkit-box-sizing:border-box;box-sizing:border-box}.vueperslides__arrow svg:hover{stroke-width:1.3}.vueperslides__paused{position:absolute;-webkit-transition:.3s ease-in-out;transition:.3s ease-in-out}.vueperslides__bullets{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;position:absolute;bottom:0;left:0;right:0}.vueperslides__bullets--outside{position:relative}.vueperslides__bullet,.vueperslides__bullets button{cursor:pointer;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;outline:none;z-index:2;display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;color:inherit}.vueperslides__bullet::-moz-focus-inner,.vueperslides__bullets button::-moz-focus-inner{border:0}.vueperslides__fractions{position:absolute;top:.8em;left:.5em;z-index:2;padding:.2em 1em;border:1px solid hsla(0,0%,100%,.5);border-radius:2em;background:hsla(0,0%,100%,.2);color:#fff}.vueperslides__progress{position:absolute;top:0;left:0;right:0;z-index:2;height:6px;color:rgba(0,0,0,.7)}.vueperslides__progress>*{position:absolute;top:0;bottom:0;left:0;background:currentColor;-webkit-transition:.3s ease-in-out;transition:.3s ease-in-out}img[data-v-5f0fe3e2]{width:100%}.ads[data-v-5f0fe3e2]{margin:59px 0 69px}.link[data-v-5f0fe3e2]{padding-top:5px;text-align:right}.link a[data-v-5f0fe3e2]{padding-left:16px;font-size:.8em;color:inherit;background:url(../img/link-blank.d5149b7c.svg) 0 no-repeat;background-size:13px 13px}.container[data-v-5f0fe3e2]{position:relative;background:#fff;-webkit-box-shadow:0 1px 5px 1px rgba(0,0,0,.2);box-shadow:0 1px 5px 1px rgba(0,0,0,.2)}.package-sorting{margin:20px 0 15px;text-align:right}.package-sorting__label{display:inline-block;text-transform:uppercase}.package-sorting__label:after{content:":"}.package-sorting__group{position:relative;display:-webkit-inline-box;display:-ms-inline-flexbox;display:inline-flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;margin:0;padding:0 15px 0 0;list-style-type:none;text-align:left}.package-sorting__group:after{content:"";position:absolute;top:.8em;right:0;width:0;height:0;border-left:5px solid transparent;border-right:5px solid transparent;border-top:5px solid #535353}.package-sorting__item{display:none;margin:0 0 0 10px;padding:3px 0;text-transform:uppercase;cursor:pointer;border-bottom:2px solid transparent}.package-sorting__item:hover{color:#f47c00}.package-sorting__item--open{display:inline}.package-sorting__item--active{display:inline;color:#f47c00;border-bottom:2px solid #f47c00}@media(min-width:600px){.package-sorting__group{-webkit-box-orient:horizontal;-webkit-box-direction:normal;-ms-flex-direction:row;flex-direction:row;-webkit-box-pack:end;-ms-flex-pack:end;justify-content:flex-end;padding:0}.package-sorting__group:after{content:none}.package-sorting__item{display:inline}}.search-bar{position:relative}.search-bar__input{height:50px!important;padding-right:40px!important}.search-bar__button{position:absolute;top:0;right:0;display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-align:center;-ms-flex-align:center;align-items:center;width:38px;height:50px;margin:0;padding:7px;line-height:36px;border:none;background:none;outline:none}.package-search{position:relative}.package-search__input{max-width:400px;margin:0 20px}.package-search__headline{font-size:18px;font-weight:300;margin:30px 0 10px}@media(min-width:1024px){.package-search__results{display:-webkit-box;display:-ms-flexbox;display:flex;-ms-flex-wrap:wrap;flex-wrap:wrap;margin:0 -8px}.package-search__item{-ms-flex-preferred-size:calc(50% - 16px);flex-basis:calc(50% - 16px);margin-left:8px;margin-right:8px}}.package-search__status{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.package-search__status--empty{padding-top:140px;background:url(../img/sad.c9a06488.svg) top no-repeat;background-size:100px 100px}.package-search__status--offline{padding-top:140px;background:url(../img/offline.1f95ae24.svg) top no-repeat;background-size:100px 100px}.package-search__status--loader .sk-circle{width:100px;height:100px;margin:0 auto 40px}.package-search__status button{margin-top:2em}.package-search__explain{font-size:16px}.package-search__more{margin:10px 0 30px;text-align:center}.package-search__more-button{display:inline-block;margin:0 auto;padding:0;text-transform:uppercase;background:none;border:none;cursor:pointer}.package-search__more-button:hover{text-decoration:underline}.package-search__algolia{display:block;width:200px;margin:50px auto 0}.link-menu{position:absolute;display:block;left:50%;margin:0;padding:0;text-align:center;list-style-type:none;white-space:nowrap;background:#fff;border-top:3px solid #535353;z-index:100;-webkit-box-shadow:0 1px 2px #ccbfa2;box-shadow:0 1px 2px #ccbfa2}.link-menu:before{position:absolute;left:50%;top:-7px;width:0;height:0;margin-left:-4px;border-style:solid;border-width:0 3.5px 4px 3.5px;border-color:transparent transparent #535353 transparent;content:""}.link-menu--align-left{left:0;right:auto}.link-menu--align-left:before{left:17px;right:auto}.link-menu--align-right{left:auto;right:0}.link-menu--align-right:before{left:auto;right:17px}.link-menu--valign-top{bottom:0;border-top:none;border-bottom:3px solid #535353;-webkit-box-shadow:0 0 2px #ccbfa2;box-shadow:0 0 2px #ccbfa2}.link-menu--valign-top:before{top:auto;bottom:-7px;border-width:4px 3.5px 0 3.5px;border-color:#535353 transparent transparent transparent}.link-menu--contao{border-color:#f47c00}.link-menu--contao:before{border-bottom-color:#f47c00}.link-menu--contao.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:#f47c00}.link-menu--primary{border-color:#31a64b}.link-menu--primary:before{border-bottom-color:#31a64b}.link-menu--primary.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:#31a64b}.link-menu--warning{border-color:#db8c41}.link-menu--warning:before{border-bottom-color:#db8c41}.link-menu--warning.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:#db8c41}.link-menu--alert{border-color:#db5041}.link-menu--alert:before{border-bottom-color:#db5041}.link-menu--alert.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:#db5041}.link-menu__item{margin:0;padding:0;display:block;border-top:1px solid #e5dfd0}.link-menu__item:first-child{border-top:none}.link-menu__action{display:block;margin:0;padding:10px 20px;color:#535353;cursor:pointer}.link-menu__action:hover{color:#000;text-decoration:none}.vjs-tree-brackets{cursor:pointer}.vjs-tree-brackets:hover{color:#1890ff}.vjs-check-controller{position:absolute;left:0}.vjs-check-controller.is-checked .vjs-check-controller-inner{background-color:#1890ff;border-color:#0076e4}.vjs-check-controller.is-checked .vjs-check-controller-inner.is-checkbox:after{-webkit-transform:rotate(45deg) scaleY(1);transform:rotate(45deg) scaleY(1)}.vjs-check-controller.is-checked .vjs-check-controller-inner.is-radio:after{-webkit-transform:translate(-50%,-50%) scale(1);transform:translate(-50%,-50%) scale(1)}.vjs-check-controller .vjs-check-controller-inner{display:inline-block;position:relative;border:1px solid #bfcbd9;border-radius:2px;vertical-align:middle;-webkit-box-sizing:border-box;box-sizing:border-box;width:16px;height:16px;background-color:#fff;z-index:1;cursor:pointer;-webkit-transition:border-color .25s cubic-bezier(.71,-.46,.29,1.46),background-color .25s cubic-bezier(.71,-.46,.29,1.46);transition:border-color .25s cubic-bezier(.71,-.46,.29,1.46),background-color .25s cubic-bezier(.71,-.46,.29,1.46)}.vjs-check-controller .vjs-check-controller-inner:after{-webkit-box-sizing:content-box;box-sizing:content-box;content:"";border:2px solid #fff;border-left:0;border-top:0;height:8px;left:4px;position:absolute;top:1px;-webkit-transform:rotate(45deg) scaleY(0);transform:rotate(45deg) scaleY(0);width:4px;-webkit-transition:-webkit-transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;transition:-webkit-transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;transition:transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;transition:transform .15s cubic-bezier(.71,-.46,.88,.6) .05s,-webkit-transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;-webkit-transform-origin:center;transform-origin:center}.vjs-check-controller .vjs-check-controller-inner.is-radio{border-radius:100%}.vjs-check-controller .vjs-check-controller-inner.is-radio:after{border-radius:100%;height:4px;background-color:#fff;left:50%;top:50%}.vjs-check-controller .vjs-check-controller-original{opacity:0;outline:none;position:absolute;z-index:-1;top:0;left:0;right:0;bottom:0;margin:0}.vjs-carets{position:absolute;right:0;cursor:pointer}.vjs-carets svg{-webkit-transition:-webkit-transform .3s;transition:-webkit-transform .3s;transition:transform .3s;transition:transform .3s,-webkit-transform .3s}.vjs-carets:hover{color:#1890ff}.vjs-carets-close{-webkit-transform:rotate(-90deg);transform:rotate(-90deg)}.vjs-tree-node{display:-webkit-box;display:-ms-flexbox;display:flex;position:relative;line-height:20px}.vjs-tree-node.has-carets{padding-left:15px}.vjs-tree-node.has-carets.has-selector,.vjs-tree-node.has-selector{padding-left:30px}.vjs-tree-node.is-highlight,.vjs-tree-node:hover{background-color:#e6f7ff}.vjs-tree-node .vjs-indent{display:-webkit-box;display:-ms-flexbox;display:flex;position:relative}.vjs-tree-node .vjs-indent-unit{width:1em}.vjs-tree-node .vjs-indent-unit.has-line{border-left:1px dashed #bfcbd9}.vjs-node-index{position:absolute;right:100%;margin-right:4px;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.vjs-colon{white-space:pre}.vjs-comment{color:#bfcbd9}.vjs-value{word-break:break-word}.vjs-value-null,.vjs-value-undefined{color:#d55fde}.vjs-value-boolean,.vjs-value-number{color:#1d8ce0}.vjs-value-string{color:#13ce66}.vjs-tree{font-family:Monaco,Menlo,Consolas,Bitstream Vera Sans Mono,monospace;font-size:14px;text-align:left}.vjs-tree.is-virtual{overflow:auto}.vjs-tree.is-virtual .vjs-tree-node{white-space:nowrap}.link-more{position:relative;display:inline-block}p:empty+.link-more{margin-left:0}.link-more button{width:auto;height:auto;padding:0 0 5px;background:transparent;color:#f47c00;font-size:13px;font-weight:300;line-height:inherit;border:none;cursor:pointer}.link-more button:hover{text-decoration:underline}.link-more__menu{outline:none}.link-more ul{-webkit-transform:translateX(-50%);transform:translateX(-50%)}.package-link{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-pack:justify;-ms-flex-pack:justify;justify-content:space-between;width:100%;padding-bottom:4px;margin-bottom:4px;border-bottom:1px solid #e9eef1}.package-link:last-child{padding-bottom:0;margin-bottom:0;border-bottom:none}.package-link__details{padding:5px 0;line-height:18px}.package-link__name{display:inline;font-weight:600}.package-link__name:after{content:": "}.package-link__text{display:inline}.package-link__actions{display:-webkit-box;display:-ms-flexbox;display:flex;margin-left:20px;margin:0 -4px}.package-link__actions>*{margin:0 4px}.package-link--limit .package-link__details{display:-webkit-box;display:-ms-flexbox;display:flex}.package-link--limit .package-link__name{white-space:nowrap}.package-link--limit .package-link__text{display:-webkit-box;overflow:hidden;-webkit-line-clamp:1;-webkit-box-orient:vertical;padding:0 10px 0 5px}div[data-v-7ac04620]{padding:10px 20px 10px 50px;font-weight:400;font-size:12px;line-height:1.8;background:rgba(234,74,170,.025) url(../img/funding.8a3c0e0e.svg) 15px 50% no-repeat;background-size:23px 23px;border:1px solid rgba(234,74,170,.5)}span[data-v-7ac04620]{margin-right:15px}a[data-v-7ac04620]{display:inline-block;padding-left:16px;color:#ea4aaa;background:url(../img/link-funding.c73bb011.svg) 0 50% no-repeat;background-size:13px 13px}a[data-v-7ac04620]:after{content:"|";margin:0 10px}a[data-v-7ac04620]:last-child:after{content:none}.package-popup{position:fixed;display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;-webkit-box-pack:start;-ms-flex-pack:start;justify-content:flex-start;width:100%;height:100%;background:#fff;z-index:10;opacity:1}.package-popup>*{-ms-flex-preferred-size:auto;flex-basis:auto;-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1}.package-popup__loader{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;-webkit-box-align:center;-ms-flex-align:center;align-items:center;-webkit-box-pack:center;-ms-flex-pack:center;justify-content:center;padding:50px 0}.package-popup__loader p{margin:1em}.package-popup__headline{position:relative;-webkit-box-flex:0;-ms-flex-positive:0;flex-grow:0;-ms-flex-negative:1;flex-shrink:1;padding:7px 30px 6px;background:#f47c00;color:#fff;font-size:18px;font-weight:300;line-height:1.5;text-align:center;border-radius:2px 2px 0 0}.package-popup__headline--complete{background-color:#31a64b}.package-popup__headline--error{background-color:#db5041}.package-popup__button{display:block;float:right;position:absolute;top:0;margin:4px 0;padding:4px;background:none;border:1px solid transparent;border-radius:1px;cursor:pointer}.package-popup__button--previous{left:4px}.package-popup__button--close{right:4px}.package-popup__button svg{display:block;width:22px;height:22px}.package-popup__button:hover{background-color:#db6f00;border-color:#c16200}.package-popup__headline--complete .package-popup__button:hover{background-color:#2b9242;border-color:#257f39}.package-popup__headline--error .package-popup__button:hover{background-color:#db5041;border-color:#c43525}.package-popup__summary{-webkit-box-flex:0;-ms-flex-positive:0;flex-grow:0;padding:25px 35px}@media(min-width:600px){.package-popup__summary{display:-webkit-box;display:-ms-flexbox;display:flex}}.package-popup__icon{float:right;height:42px;width:42px;margin-left:1em}.package-popup__icon--fallback{display:none}.package-popup__icon img{width:100%;height:auto;max-height:100%}@media(min-width:600px){.package-popup__icon{display:block;float:left;width:90px;height:90px;margin-left:0;margin-right:20px;margin-bottom:-4px}}.package-popup__text{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1}@media(min-width:600px){.package-popup__text{width:200px}}.package-popup__title{margin:0;line-height:1.4;overflow-wrap:break-word}.package-popup__authors{-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1;font-size:13px;margin-bottom:.5em}.package-popup__author{display:inline-block;margin-right:2px}.package-popup__author:after{color:#535353;content:", "}.package-popup__author:last-child:after{content:none}.package-popup__stats{display:inline-block;margin-right:15px;margin-top:.5em;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.package-popup__stats--private{padding-left:20px;background-image:url(../img/private.c66d3582.svg);background-size:15px 15px}.package-popup__stats--updated{background-image:url(../img/updated.455f42dc.svg)}.package-popup__stats--downloads{background-image:url(../img/downloads.aa84cdf1.svg)}.package-popup__stats--favers{background-image:url(../img/favers.31587387.svg)}.package-popup__actions{display:-webkit-box;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-ms-flex-direction:column;flex-direction:column;gap:10px;margin-top:1em}@media(min-width:600px){.package-popup__actions{-webkit-box-pack:justify;-ms-flex-pack:justify;justify-content:space-between;margin:0 0 0 25px;min-width:200px}}.package-popup__installed{margin-top:1em}.package-popup__abandoned{margin:0 0 20px;padding:10px 20px 10px 50px;font-weight:400;font-size:12px;line-height:1.8;background:hsla(16,49%,82%,.3) url(../img/hint.ba2ac97e.svg) 15px no-repeat;background-size:23px 23px;border:1px solid #bd2e20}.package-popup__funding{margin:0 0 20px}.package-popup__tabs{-webkit-box-flex:0;-ms-flex-positive:0;flex-grow:0;clear:both;display:-webkit-box;display:-ms-flexbox;display:flex;-ms-flex-wrap:wrap;flex-wrap:wrap;width:100%;margin:0;padding:0;list-style-type:none}.package-popup__tab{-webkit-box-flex:1;-ms-flex-positive:1;flex-grow:1;margin:0;padding:0;height:39px;line-height:39px;text-align:center;border-top:1px solid #e9eef1;border-right:1px solid #e9eef1;border-bottom:1px solid #e9eef1}.package-popup__tab:last-child{border-right:none}.package-popup__tab--active{font-weight:600;background:#f8f9fb;border-bottom:1px solid #f8f9fb}.package-popup__tab button{width:100%;height:100%;margin:0;padding:0 10px;border:none;background:transparent;cursor:pointer;outline:none}.package-popup__tab button:disabled{color:#ccc!important;cursor:not-allowed}.package-popup__pill{position:relative;top:-2px;display:inline-block;margin-left:5px;padding:2px 5px;font-size:10px;font-weight:400;background:#e9eef1;border-radius:40%}.package-popup__pill--highlight{color:#fff;background:#31a64b}.package-popup__tabcontent{position:relative;padding:25px 35px;overflow-y:auto;background:#f8f9fb}@media(min-width:960px)and (min-height:700px){.package-popup__tabcontent{height:450px}}.package-popup__description{margin:1em 0;white-space:pre-wrap}@media(min-width:960px){.package-popup{position:relative;display:block;top:0;left:50%;width:750px;margin-left:-375px;height:auto;border-bottom:2px solid #ddd3bc;border-radius:2px}}@media(min-width:960px)and (min-height:700px){.package-popup{position:absolute;top:50%;-webkit-transform:translateY(-50%);transform:translateY(-50%)}}"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[716],{3716:function(e){e.exports=JSON.parse('{"ui.app.title":"Rozszerzenia Contao","ui.app.loading":"Ładowanie listy rozszerzeń …","ui.discover.advertisement":"Reklama w liście rozszerzeń","ui.discover.loading":"Ładowanie …","ui.discover.offline":"Nie znaleziono żadnych wyników.","ui.discover.offlineExplain":"Sprawdź swoje połączenie internetowe i wyłącz narzędzia blokujące JavaScript w przeglądarce.","ui.discover.offlineButton":"Spróbuj ponownie","ui.discover.searchPlaceholder":"Szukaj w {count} rozszerzeniach ...","ui.discover.empty":"Brak wyników dla {query}","ui.discover.more":"Więcej Wyników","ui.discover.sortBy":"Sortuj według","ui.discover.sortReleased":"Released","ui.discover.sortReleasedTitle":"Sort results by release date","ui.discover.sortLatest":"Data aktualizacji","ui.discover.sortLatestTitle":"Sort results by last updated","ui.discover.sortDownloads":"Pobrania","ui.discover.sortDownloadsTitle":"Sort results by number of downloads","ui.discover.sortFavers":"Ocena","ui.discover.sortFaversTitle":"Sort results by rating","ui.discover.detailsButton":"Szczegóły","ui.discover.latestPackages":"Najnowsze i zaktualizowane rozszerzenia","ui.discover.faversPackages":"Najwyżej oceniane rozszerzenia","ui.discover.downloadsPackages":"Najczęściej pobierane rozszerzenia","ui.package.homepage":"Strona Projektu","ui.package.private":"Prywatny Pakiet","ui.package.privateTitle":"Prywatne pakiety są dostępne tylko bezpośrednio od dostawcy (np. jako plik ZIP). Odwiedź stronę po więcej informacji.","ui.package.abandoned":"porzucony","ui.package.abandonedText":"Ten pakiet jest porzucony i nie jest już wspierany.","ui.package.abandonedReplace":"Ten pakiet jest porzucony i nie jest już wspierany. Autor sugeruje użycie pakietu {replacement} zamiast niego.","ui.package-details.previous":"Szczegóły poprzedniego rozszerzenia","ui.package-details.close":"Zamknij szczegóły rozszerzenia","ui.package-details.loading":"Ładowanie …","ui.package-details.tabDescription":"Opis","ui.package-details.tabRequire":"Wymagania","ui.package-details.tabFeatures":"Funkcjonalności","ui.package-details.tabSuggest":"Sugestie","ui.package-details.tabConflict":"Konflikty","ui.package-details.tabDependents":"Zależności","ui.package-details.linkRequires":"wymaga","ui.package-details.linkReplaces":"zastępuje","ui.package-details.linkProvides":"dostarcza","ui.package-details.linkConflicts":"koliduje","ui.package-details.funding":"Finansuj rozwój pakietu!","ui.package-details.latest":"Ostatnia wersja","ui.package-details.released":"data wydania","ui.package-details.license":"Licencje","ui.package-details.authors":"od","ui.package-details.more":"Więcej","ui.package-details.packagist":"Szczegóły Pakietu","ui.package-details.metadata":"Edytuj metadane","ui.package-details.support_docs":"Dokumentacja","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Forum","ui.package-details.support_issues":"Issues / Bug Report","ui.package-details.support_source":"Kod źródłowy","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Wsparcie E-mail","ui.package-details.support_rss":"Kanał RSS"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[486],{8486:function(e){e.exports=JSON.parse('{"ui.app.title":"Contao eklentileri","ui.app.loading":"Eklenti listesi yükleniyor…","ui.discover.advertisement":"Eklenti listesinde duyuru","ui.discover.loading":"Yükleniyor…","ui.discover.offline":"Herhangi bir sonuç alınamadı.","ui.discover.offlineExplain":"İnternet bağlantınızı denetleyin ve tarayıcınızdaki JavaScript engelleyicileri etkisizleştirin.","ui.discover.offlineButton":"Yeniden dene","ui.discover.searchPlaceholder":"{count} eklentide ara…","ui.discover.empty":"{query} ile eşleşen bir sonuç bulunamadı","ui.discover.more":"Diğer sonuçlar","ui.discover.sortBy":"Sıralama","ui.discover.sortReleased":"Yayınlandı","ui.discover.sortReleasedTitle":"Sonuçlar yayınlanma tarihine göre sıralansın","ui.discover.sortLatest":"Güncellendi","ui.discover.sortLatestTitle":"Sonuçlar güncellenme tarihine göre sıralansın","ui.discover.sortDownloads":"İndirmeler","ui.discover.sortDownloadsTitle":"Sonuçlar indirme sayılarına göre sıralansın","ui.discover.sortFavers":"Değerlendirme","ui.discover.sortFaversTitle":"Sonuçlar değerlendirmeye göre sıralansın","ui.discover.detailsButton":"Ayrıntılar","ui.discover.latestPackages":"Yeni ve güncellenmiş eklentiler","ui.discover.faversPackages":"İyi değerlendirilmiş eklentiler","ui.discover.downloadsPackages":"En çok indirilen eklentiler","ui.package.homepage":"Proje sitesi","ui.package.private":"Özel paket","ui.package.privateTitle":"Özel paketler yalnızca üretici tarafından sağlanabilir (ZIP indirmesi gibi). Ayrıntılı bilgi almak için siteye bakabilirsiniz.","ui.package.abandoned":"kullanımdan kaldırıldı","ui.package.abandonedText":"Bu paket kullanımdan kaldırıldı ve artık geliştirilmiyor.","ui.package.abandonedReplace":"Bu paket kullanımdan kaldırıldı ve artık geliştirilmiyor. Geliştirici bunun yerine  {replacement} paketinin kullanılmasını öneriyor.","ui.package-details.previous":"Önceki eklenti bilgileri","ui.package-details.close":"Eklenti bilgilerini kapat","ui.package-details.loading":"Yükleniyor…","ui.package-details.tabDescription":"Açıklama","ui.package-details.tabRequire":"Gereksinimler","ui.package-details.tabFeatures":"Özellikler","ui.package-details.tabSuggest":"Öneriler","ui.package-details.tabConflict":"Çakışmalar","ui.package-details.tabDependents":"Bağımlılar","ui.package-details.linkRequires":"gereksinimi","ui.package-details.linkReplaces":"değişikliği","ui.package-details.linkProvides":"sundukları","ui.package-details.linkConflicts":"çakışması","ui.package-details.funding":"Paketin geliştirilmesine destek olun!","ui.package-details.latest":"Son sürüm","ui.package-details.released":"yayınlanma tarihi","ui.package-details.license":"Lisanslar","ui.package-details.authors":"geliştiren","ui.package-details.more":"Ayrıntılar","ui.package-details.packagist":"Paket bilgileri","ui.package-details.metadata":"Üst verileri düzenle","ui.package-details.support_docs":"Belgeler","ui.package-details.support_wiki":"Viki","ui.package-details.support_forum":"Destek forumu","ui.package-details.support_issues":"Sorunlar / Hata bildirimi","ui.package-details.support_source":"Kaynak kodu","ui.package-details.support_irc":"IRC / Sohbet","ui.package-details.support_email":"Destek e-postası","ui.package-details.support_rss":"RSS akışı"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[606],{2225:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Ligação Insegura !!","ui.app.httpsDescription":"Sem recurso a HTTPS os seus dados confidenciais serão transferidos sem encriptação.","ui.app.httpsLink":"Mais info","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Modo Guardar activado !!","ui.app.safeModeDescription":"Algumas características do Gestor de Contacto não estão disponíveis.","ui.app.safeModeExit":"Sair do modo seguro","ui.app.loading":"A iniciar o Contao Manager ...","ui.app.apiError":"API status não esperado -erro","ui.app.configSecurity1":"ALERTA DE SEGURANÇA!!! Directório de configuração sem protecção detectado","ui.app.configSecurity2":"O Contao Manager detetou que os seus ficheiros de configuração estão acessíveis publicamente. Todas as operações estão desativadas até que o directório esteja seguro, caso contrário um atacante poderá aceder a informações sensíveis sobre a sua instalação.\\n\\nPara corrigir esta situação, certifique-se que previne o acesso ao directório \\"contao-manager\\" no seu servidor. Para saber como o fazer, consulte o manual do seu webserver ou contacte o fornecedor de alojamento web.","ui.account.welcome":"Bem Vindo","ui.account.intro1":"Bem-vindo ao Contao Manager, uma ferramenta universal para instalar e gerir o Contao Open Source CMS. Se é novo nele, por favor {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} para começar","ui.account.introManual":"ler o manual","ui.account.intro2":"Se encontrar algum problema, verifique {ourGithubIssues} e sinta-se à vontade para criar um novo para qualquer coisa que ainda não tenha sido relatada.","ui.account.introIssues":"as nossas edições GitHub","ui.account.headline":"Utilizador","ui.account.description":"Para gerir a sua instalação, por favor crie uma conta para utilizar no Contao Manager. Certifique-se que é distinta da conta utilizada no Contao back e front end.","ui.account.username":"Utilizador","ui.account.password":"Senha","ui.account.passwordPlaceholder":"min. 8 caracteres","ui.account.passwordLength":"Por favor utilize o minimo de 8 caracteres.","ui.account.submit":"Criar Conta","ui.account.contribute1":"O Contao e o Contao Manager são patrocinados pela Associação Contao sem fins lucrativos.","ui.account.contribute2":"Por favor, considere contribuir para o código aberto por {donate}.","ui.account.contributeDonate":"fazer um donativo","ui.login.headline":"Iniciar sessão","ui.login.description":"Iniciar sessão para gerir a sua instalação.","ui.login.username":"Utilizador","ui.login.password":"Senha","ui.login.forgotPassword":"Esqueceu a sua senha?","ui.login.button":"Iniciar sessão","ui.login.locked":"O acesso foi negado porque o Gestor de Contacto está bloqueado. Para desbloquear, apagar o ficheiro {lockFile} no directório raiz do seu Contao.","ui.logout.headline":"Tempo de Sessão expirado.","ui.logout.warning":"Esteve inactivo por mais de 25 minutos. Por razões de segurança a sua sessão será terminada em breve.","ui.logout.expired":"A sua sessão foi terminada automaticamente porque esteve inactivo por mais de 30 minutos.","ui.logout.renew":"Manter sessão ativa","ui.logout.logout":"Terminar Sessão","ui.logout.login":"Voltar para inicio de sessão","ui.oauth.error":"Tentativa OAuth inválida. Verifique os parâmetros pedidos.","ui.oauth.https":"O redireccionamento do URI DEVE utilizar um protocolo seguro (https:) para evitar que o símbolo de autenticação seja transmitido em texto claro.","ui.oauth.headline":"Autenticação remota","ui.oauth.description":"A seguinte aplicação ou serviço está a solicitar acesso remoto ao Contao Manager.","ui.oauth.domain":"Antes de permitir o acesso, certifique-se de que conhece este URL e confie no seu proprietário!","ui.oauth.allow":"Permitir Acesso","ui.oauth.deny":"Negar Acesso","ui.boot.headline":"Verificar Sistema","ui.boot.description":"Por favor espere, estamos a analisar o seu servidor...","ui.boot.issue1":"Problemas com a instalação detectados","ui.boot.issue2":"A sua instalação tem problemas que têm de ser resolvidos antes que o Gestor de Contacto possa ser utilizado.","ui.boot.run":"Iniciar o Contao Manager","ui.boot.safeMode":"Executar em Modo de Segurança","ui.recovery.headline":"Recuperação de Sistema","ui.recovery.description":"O Contao Manager detectou ficheiros que podem pertencer ao Contao, mas a linha de comandos não funciona como previsto.","ui.recovery.console":"Saída da Consola","ui.recovery.repairOptions":"Por favor escolha uma opção para reparar a sua instalação.","ui.recovery.repairHeadline":"Reparação Automática","ui.recovery.repairDescription":"Efectua uma tentativa de reparar automaticamente a instalação ao reconstruir a cache da aplicação e reinstalando os pacotes Composer.","ui.recovery.repairWarning":"Quaisquer modificações aos ficheiros vendor poderão ser apagadas durante o processo!","ui.recovery.repairFailed":"A reparação automática não teve sucesso. Usar o modo de segurança para reparar manualmente a instalação poderá resolver o problema.","ui.recovery.repairButton":"Executar Reparação de Sistema","ui.recovery.safeModeHeadline":"Modo de Segurança ","ui.recovery.safeModeDescription":"Executar o Contao Manager em Modo de Segurança permite gerir pacotes e correr tarefas de manutenção específicas, mas implementações que dependam de uma instalação Contao funcional não estarão disponíveis.","ui.recovery.safeModeButton":"Executar em Modo de Segurança","ui.server.pending":"Aguarde ...","ui.server.running":"A analisar ...","ui.server.error":"A verificação falhou devido a uma resposta inesperada do servidor.","ui.server.details":"Detalhes","ui.server.prerequisite":"A verificação falhou devido a um pré-requisito em falta.","ui.server.selfUpdate.title":"Actualizações Contao Manager","ui.server.selfUpdate.update":"Uma nova versão do Contao Manager {latest} está disponivel.","ui.server.selfUpdate.manualUpdate":"Está disponível uma nova versão do Contao Manager {latest}. O seu servidor não suporta actualizações automáticas, por favor descarregue a nova versão a partir de {download}.","ui.server.selfUpdate.latest":"Está a usar a versão mais recente {current}.","ui.server.selfUpdate.dev":"Versões de testes não suportam actualizações automáticas.","ui.server.selfUpdate.unsupported":"Uma nova versão está disponível mas não é  compatível com a sua versão de PHP.","ui.server.selfUpdate.button":"Executar Auto-Update","ui.server.selfUpdate.continue":"Continuar","ui.server.config.title":"Configuração do Servidor","ui.server.config.setup":"Configurar","ui.server.config.change":"Alterar","ui.server.config.save":"Guardar","ui.server.config.cancel":"Cancelar","ui.server.config.customOption":"Outros ...","ui.server.config.description":"Para executar correctamente as tarefas de fundo, o Gestor de Contacto precisa de saber onde encontrar o binário de linha de comando PHP e como executar comandos separados do processo web.","ui.server.config.formTitle":"Configuração do Servidor","ui.server.config.formText":"Por favor introduza o caminho para o seu binário PHP. Certifique-se que o seu binário usa a mesma versao PHP que o seu processo web.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"A Composer Resolver Cloud permite instalar dependências Composer mesmo se o seu servidor não possuir memória local suficiente. Tenha em consideração que a sua informação de pacotes será transmitida para um servidor em nuvem mantido pela Contao Association.","ui.server.config.cloud":"Usar a Composer Resolver Cloud","ui.server.config.cli":"Binário PHP","ui.server.config.stateErrorCli":"Nenhum binário PHP válido foi encontrado no servidor. ","ui.server.config.stateErrorCloud":"A Composer Resolver Cloud não é suportada.","ui.server.config.stateSuccess":"Binário PHP em {php_cli}.","ui.server.php_web.title":"Processo Web PHP","ui.server.php_web.below7":"Encontrada a versão {version} PHP. Actualize para a versão PHP 7 assim que possivel!","ui.server.php_web.success":"Encontrada a versão PHP {version}, nenhum problema a reportar.","ui.server.php_cli.title":"Interface PHP Linha de Comandos","ui.server.php_cli.success":"Encontrada a versão PHP {version}, nenhum problema a reportar.","ui.server.composer.title":"Ambiente Composer","ui.server.composer.success":"Nenhum problema encontrado.","ui.server.composer.install":"Dependências Composer não instaladas.","ui.server.composer.button":"Instalar","ui.server.contao.title":"Instalação Contao","ui.server.contao.setup":"Configuração","ui.server.contao.check":"Check database","ui.server.contao.empty":"Nenhuma instalação Contao foi encontrada.","ui.server.contao.old":"A versão {version} do Contao não é compatível com o Contao Manager,  actualize a sua instalação manualmente.","ui.server.contao.found":"Encontrado Contao com versão {version} (Versão API {api}).","ui.server.contao.connectionError":"Incapaz de se ligar ao servidor da base de dados.","ui.server.contao.connectionProblem":"Database problem found.","ui.server.contao.missingUser":"Conta administrativa não encontrada.","ui.setup.continue":"Continuar","ui.setup.manager":"Iniciar o Contao Manager","ui.setup.cancel":"Cancelar","ui.setup.welcome":"Bem Vindo","ui.setup.welcome1":"Este assistente irá levá-lo através dos passos necessários para configurar a sua instalação do CMS Contao Open Source.","ui.setup.welcome2":"If you have any questions, please find documentation, forums, a Slack channel and more on the {support} page.","ui.setup.support":"Apoio à Comunidade","ui.setup.start":"ComeceComece","ui.setup.complete":"Parabéns!","ui.setup.complete1":"Contao {version} has been installed successfully.","ui.setup.complete2":"To finish the setup process, please open the install tool to configure the database connection and create a back end user.","ui.setup.complete3":"You can now start to create your website in the Contao back end. If you need additional extensions, continue to the Contao Manager.","ui.setup.installTool":"Open the Install Tool","ui.setup.login":"Login to Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". An Open Source project like Contao requires amounts of money that can\'t be raised by a single person or company.\\nIf you have a website or sell websites built with Contao, we would love to see you contribute back financially to the product your business relies upon.","ui.setup.fundingLink":"Learn more","ui.setup.document-root.headline":"Configuração do Webserver","ui.setup.document-root.warning":"Para instalar o Contao através do Contao Manager, é necessário fixar a raiz do documento no servidor web.","ui.setup.document-root.description1":"Contao uses a separate folder for public files, application files are installed in its parent folder. Contao cannot be installed if the folder structure is not correct or the folders are not empty.","ui.setup.document-root.description2":"Se não souber como configurar a raiz do seu documento, leia a documentação do Contacto ou contacte o seu fornecedor de alojamento.","ui.setup.document-root.documentation":"Ler a Documentação","ui.setup.document-root.conflictsTitle":"Directório de instalação não vazio","ui.setup.document-root.conflictsDirectory":"The root directory of your future Contao installation is not empty, we have found {count} file(s) that might be overwritten by the installation process. It is recommended to create an empty directory structure for Contao, but you can also remove the following files and check again if you are sure they are unused.","ui.setup.document-root.ignoreConflicts":"Quero instalar o Contao no directório dos não vazios. Compreendo que isto pode substituir quaisquer ficheiros existentes no meu espaço web.","ui.setup.document-root.check":"Check again","ui.setup.document-root.create":"Criar directórios","ui.setup.document-root.change":"Change directories","ui.setup.document-root.formTitle":"Configuração de directório","ui.setup.document-root.formText1":"O Contao Manager pode criar automaticamente uma nova estrutura de directório no servidor.","ui.setup.document-root.formText2":"Será necessário configurar manualmente a raiz do novo documento (por exemplo, através de um painel de administração de alojamento).","ui.setup.document-root.autoconfig":"Compreendo que tenho de alterar a configuração do meu servidor. Não configurar a raiz do documento irá quebrar o Contao Manager e expor os ficheiros de configuração (incluindo detalhes de conta e palavras-passe)!","ui.setup.document-root.directory":"Novo Directório","ui.setup.document-root.currentRoot":"Raiz do documento actual","ui.setup.document-root.newRoot":"Novo Documento Raiz","ui.setup.document-root.finish":"Directórios de configuração","ui.setup.document-root.publicDir":"Utilizar {dir} para ficheiros públicos (para Contao {version})","ui.setup.document-root.directoryInvalid":"Por favor, introduza um nome de directório válido.","ui.setup.document-root.directoryExists":"O directório alvo já existe. Por favor, introduza um nome diferente.","ui.setup.document-root.confirmation":"O Contao Manager criou com sucesso o directório necessário para a sua instalação de Contao. Tem agora de configurar a raiz do documento no seu servidor web. Não volte a carregar esta página até lá.","ui.setup.document-root.reload":"Recarregar Página","ui.setup.document-root.success":"The directory structure on your web server is set up correctly!","ui.setup.document-root.installingProjectDir":"Application files will be installed to {dir}.","ui.setup.document-root.installingPublicDir":"Public files will be installed to {dir}.","ui.setup.document-root.installedProjectDir":"Application files are installed in {dir}.","ui.setup.document-root.installedPublicDir":"Public files are installed in {dir}.","ui.setup.create-project.headline":"Instalação Contao","ui.setup.create-project.description":"Contao development follows the principle of {semver}, a new minor version is released every six months. The currently supported releases are:","ui.setup.create-project.semver":"Semantic Versioning","ui.setup.create-project.latestTitle":"Mais Recente","ui.setup.create-project.ltsTitle":"Suporte a Longo Prazo (LTS)","ui.setup.create-project.latestQ1":"Our latest version, offers the most features with support until February {year}.","ui.setup.create-project.latestQ3":"Our latest version, offers the most features with support until August {year}.","ui.setup.create-project.ltsText":"Our current LTS version, if you focus on stability. Offers long term support until February {year}.","ui.setup.create-project.pltsText":"The previous LTS version, still has long term support until February {year}.","ui.setup.create-project.requiresPHP":"Requires at least PHP {version}, you have PHP {current}.","ui.setup.create-project.requiresDocroot":"The document root must be \\"{folder}\\".","ui.setup.create-project.releaseplan":"Ver o {contaoReleasePlan} para informações detalhadas.","ui.setup.create-project.releaseplanLink":"Plano de lançamento do Contao","ui.setup.create-project.installed":"Contao {version} is successfully installed on the server. Continue to set up your database or launch the Contao Manager to install a different version.","ui.setup.create-project.formTitle":"Select a distribution","ui.setup.create-project.formText":"Please choose which version should be installed.","ui.setup.create-project.version":"Versão","ui.setup.create-project.demo":"Install the Contao demo website","ui.setup.create-project.demoDescription":"The demo website helps you to get familiar with Contao and all of its core features. More themes can be found in the {store}.","ui.setup.create-project.coreOnly":"Instalação Mínima ( Apenas o \\"core\\")","ui.setup.create-project.noUpdate":"Ignorar Instalação (Utilizador avançado!)","ui.setup.create-project.theme":"Contao Theme","ui.setup.create-project.themeInstall":"To install a Contao theme, use the search input or upload a theme file (.cto/.zip) that supports installation through the Contao Manager.","ui.setup.create-project.themeBuy":"Make sure to visit the official {store}.","ui.setup.create-project.themeStore":"Contao Themes Store","ui.setup.create-project.themeUpload":"Upload theme file (.cto/.zip)","ui.setup.create-project.themeInvalid":"The uploaded file is not a Contao theme or does not support the Contao Manager.","ui.setup.create-project.themeWarning":"The Contao Manager cannot tell whether this theme is compatible with your server. Please check with the theme vendor if you have any questions.","ui.setup.create-project.themeTitle":"Review theme details","ui.setup.create-project.themeDetails":"The following dependencies and files will be installed with this theme.","ui.setup.create-project.themeRequire":"{count} Dependencies | {count} Dependencies","ui.setup.create-project.themeFiles":"{count} File | {count} Files","ui.setup.create-project.theme.or":"or search public themes","ui.setup.create-project.theme.search":"Search themes","ui.setup.create-project.theme.more":"More themes","ui.setup.create-project.theme.empty":"No themes matching {query}","ui.setup.create-project.theme.uploaded":"The theme file was uploaded successfully.","ui.setup.create-project.theme.packageName":"Package name","ui.setup.create-project.theme.version":"Versão","ui.setup.create-project.theme.authors":"Author(s)","ui.setup.create-project.install":"Instalar","ui.setup.create-project.cancel":"Cancelar","ui.setup.database-connection.headline":"Database Connection","ui.setup.database-connection.description":"Contao requires a MySQL database (or a compatible fork like MariaDB) to store pages, content, users and other relational data. Connection parameters are stored in the {env} file in the project root of your Contao installation.","ui.setup.database-connection.formTitle":"Connection Parameters","ui.setup.database-connection.formText":"Enter a database URL or fill in the username, password, server and database fields separately.","ui.setup.database-connection.url":"Database URL","ui.setup.database-connection.validUrl":"Database URL is invalid or connection to server failed.","ui.setup.database-connection.or":"or","ui.setup.database-connection.user":"Utilizador","ui.setup.database-connection.password":"Senha","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Database Name","ui.setup.database-connection.connected":"Successfully connected to database {database} on {server}.","ui.setup.database-connection.error":"Error connecting to the database.","ui.setup.database-connection.problem":"Contao has detected a problem with your database server.","ui.setup.database-connection.schemaTitle":"Database Schema","ui.setup.database-connection.migration":"There is one pending migration. | There are {count} pending migrations.","ui.setup.database-connection.schema":"There is one pending schema update. | There are {count} pending schema updates.","ui.setup.database-connection.noChanges":"Your database schema is up to date.","ui.setup.database-connection.check":"Check database","ui.setup.database-connection.skip":"Skip","ui.setup.database-connection.save":"Guardar","ui.setup.database-connection.change":"Change credentials","ui.setup.database-connection.restoreTitle":"Database Import","ui.setup.database-connection.restoreText":"The theme you just installed contains a database backup. Restore the database to import theme data or skip this step to start with a blank Contao installation. | The theme you just installed contains multiple database backups. Select a backup file to import theme data or skip this step to start with a blank Contao installation.","ui.setup.database-connection.backup":"Backup current database before import","ui.setup.database-connection.backupWarning":"All data in database will be overwritten on import! Create a backup first if the database is not empty.","ui.setup.database-connection.restore":"Import theme database","ui.setup.database-connection.restoreOption":"Backup from {date} ({size})","ui.setup.database-connection.restored":"Your theme database was successfully imported. Continue to validate your database schema.","ui.setup.backend-user.success":"An admin account for the Contao back end was found in your database. Use the Contao back end to add more users.","ui.setup.backend-user.error":"Unable to retrieve user list. Check the console output for details.","ui.setup.backend-user.headline":"Backend Account","ui.setup.backend-user.description":"To manage your website, you need to have at least one admin account for the Contao back end. Be aware that this account is not related to the Contao Manager.","ui.setup.backend-user.formTitle":"Criar Conta","ui.setup.backend-user.formText":"Please enter the details for the new back end account.","ui.setup.backend-user.username":"Utilizador","ui.setup.backend-user.name":"Name","ui.setup.backend-user.email":"E-mail address","ui.setup.backend-user.emailInvalid":"Please enter a valid e-mail address","ui.setup.backend-user.password":"Senha","ui.setup.backend-user.passwordPlaceholder":"min. 8 caracteres","ui.setup.backend-user.passwordLength":"Por favor utilize o minimo de 8 caracteres.","ui.setup.backend-user.create":"Add account","ui.task.headline":"Tarefa de fundo","ui.task.loading":"Carregamento de detalhes ...","ui.task.created":"Carregamento de detalhes ...","ui.task.active":"Por favor aguarde enquanto o Gestor de Contacto está a executar operações de tarefas em segundo plano.","ui.task.complete":"Todas as operações são concluídas com sucesso. Verifique a saída da consola para mais detalhes.","ui.task.aborting":"Por favor aguarde enquanto as operações de fundo estão a ser canceladas.","ui.task.stopped":"Algumas operações de fundo foram canceladas. Por favor, verifique a saída da consola.","ui.task.error":"Uma operação de fundo parou inesperadamente. Por favor, verifique a saída da consola.","ui.task.failed":"O Gestor de Contao não conseguiu iniciar uma tarefa de fundo!","ui.task.failedDescription1":"Alguma coisa correu mal ao tentar executar operações em segundo plano.","ui.task.failedDescription2":"Se isto acontecer novamente, o seu servidor poderá não ser suportado.","ui.task.reportProblem":"Reportar um Problema","ui.task.sponsor":"Composer Cloud sponsored by {sponsor}","ui.task.buttonAudit":"Actualizar base de dados ","ui.task.buttonClose":"Fechar","ui.task.buttonConfirm":"Confirmar e Fechar","ui.task.buttonCancel":"Cancelar","ui.task.confirmCancel":"Tem a certeza que pretende interromper esta tarefa? Poderá afectar a instalação do Contao negativamente!","ui.task.autoclose":"Detalhes sobre o sucesso da tarefa","ui.console.toggle":"Mostrar/Esconder saída de Consola","ui.console.showLog":"Mostrar registo completo da consola","ui.console.copyLog":"Copiar log para prancheta","ui.migrate.headline":"Database Updates","ui.migrate.migrationsOnly":"(migrations only)","ui.migrate.schemaOnly":"(schema only)","ui.migrate.loading":"Please wait, we are checking your database …","ui.migrate.empty":"No pending migrations or schema updates found. Your database is up to date.","ui.migrate.emptyMigrations":"No pending migrations found. Make sure to also check for schema updates.","ui.migrate.emptySchema":"No pending schema updates found. Make sure to also check for migrations.","ui.migrate.pending":"Your database is not up to date. Please review the console output below and execute the changes.","ui.migrate.previousChanges":"A previous database migration was not confirmed.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.previousComplete":"A previous database migration was not confirmed, please review the console output below.\\nThere are no more pending changes.","ui.migrate.appliedChanges":"Database updates have been applied.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.appliedComplete":"Database updates have been applied.\\nThere are no more pending migrations or schema updates. Your database is up to date.","ui.migrate.problem":"Contao has detected a problem with your database server.\\nPlease review the console output below to find out what needs to be fixed. | Contao has detected problems with your database server.\\nPlease review the console output below to find out what needs to be fixed.","ui.migrate.warning":"Contao has detected a misconfiguration of your database server.\\nWarnings can be skipped temporarily, but should be fixed for optimal performance and data integrity.","ui.migrate.error":"The changes could not be applied. Your database might have been changed, please check again to retry.","ui.migrate.execute":"Execute","ui.migrate.close":"Fechar","ui.migrate.confirm":"Confirmar e Fechar","ui.migrate.cancel":"Cancelar","ui.migrate.continue":"Continuar","ui.migrate.setup":"Configuração","ui.migrate.skip":"Skip","ui.migrate.retry":"Check again","ui.migrate.retryAll":"Check all","ui.migrate.withDeletes":"Execute all database changes including DROP queries.","ui.migrate.migrationTitle":"Database Migrations","ui.migrate.schemaTitle":"Schema Updates","ui.migrate.problemTitle":"Database Problems","ui.migrate.warningTitle":"Database Warnings","ui.migrate.addTable":"Add table {table}","ui.migrate.dropTable":"Drop table {table}","ui.migrate.addField":"Add field {table}.{field}","ui.migrate.changeField":"Change field {table}.{field}","ui.migrate.dropField":"Drop field {table}.{field}","ui.migrate.createIndex":"Create index \\"{name}\\" on {table}","ui.migrate.dropIndex":"Drop index \\"{name}\\" on {table}","ui.widget.mandatory":"Este campo não pode estar vazio.","ui.widget.blankOption":"Por favor seleccione ...","ui.widget.showPassword":"Show password","ui.widget.hidePassword":"Hide password","ui.error.title":"O pedido HTTP de \\"{method} {url}\\" falhou.","ui.error.server500":"Parece que ocorreu um erro inesperado no seu servidor. Por favor verifique os ficheiros de registo do seu servidor web (Apache/Nginx) e os registos do Contao Manager em \\"Contao-manager/logs\\".","ui.error.response":"O servidor devolveu uma resposta com o código de estado {status}.","ui.error.moreLink":"Mais informação ","ui.error.support":"Contao Support","ui.footer.help":"Ajuda","ui.footer.reportProblem":"Reportar um Problema","ui.navigation.discover":"Descubra","ui.navigation.packages":"Pacotes","ui.navigation.tools":"Ferramentas","ui.navigation.installTool":"Ferramenta de Instalação","ui.navigation.backend":"Backend Contao","ui.navigation.debug":"Depuração Contao","ui.navigation.logViewer":"Log Viewer","ui.navigation.phpinfo":"Informação PHP","ui.navigation.phpinfoLoading":"Carregamento de informação PHP","ui.navigation.maintenance":"Manutenção","ui.navigation.rebuildCache":"Reconstruir Cache","ui.navigation.systemCheck":"Verificar Sistema","ui.navigation.advanced":"Avançado","ui.navigation.logout":"Terminar Sessão","ui.maintenance.database.title":"Database Migrations and Backups","ui.maintenance.database.description":"Database migrations ensure consistent data and table schemas.","ui.maintenance.database.migrations":"One pending database migration | {count} pending database migrations","ui.maintenance.database.schemaUpdates":"One pending schema update | {count} pending schema updates","ui.maintenance.database.error":"Database problem found.","ui.maintenance.database.warning":"Database warnings found.","ui.maintenance.database.button":"Check database","ui.maintenance.database.migrationOnly":"Check migrations only","ui.maintenance.database.schemaOnly":"Check schema only","ui.maintenance.database.installTool":"Open Install Tool","ui.maintenance.database.createBackup":"Create Backup","ui.maintenance.database.backupUnsupported":"Database backups are not supported by your Contao version.","ui.maintenance.database.backupList":"You have one database backup, created on {date}. | You have {count} database backups, the latest one was created on {date}.","ui.maintenance.database.backupEmpty":"You currently have no database backups.","ui.maintenance.rebuildCache.title":"Cache de Aplicação","ui.maintenance.rebuildCache.description":"Reconstruir a cache da aplicação é necessário após modificar quaisquer dos ficheiros de configuração.","ui.maintenance.rebuildCache.rebuildProd":"Reconstruir Cache de Produção","ui.maintenance.rebuildCache.rebuildDev":"Reconstruir Cache Desenvolvimento","ui.maintenance.rebuildCache.clearProd":"Limpar Cache Produção","ui.maintenance.rebuildCache.clearDev":"Limpar Cache Desenvolvimento","ui.maintenance.installTool.title":"Ferramenta de Instalação do Contao","ui.maintenance.installTool.description":"A Ferramenta de Instalação do Contao bloqueia automaticamente caso a senha seja introduzida erradamente três vezes.","ui.maintenance.installTool.unlock":"Desbloquear ferramenta de instalação","ui.maintenance.installTool.lock":"Bloquear ferramenta de instalação","ui.maintenance.dumpAutoload.title":"Carregador de Classes Composer","ui.maintenance.dumpAutoload.description":"O Composer autoloader é responsável por carregar classes PHP. O autoloader tem que ser \\"dumped\\" após adicionar namespaces personalizados ao root compser.json .","ui.maintenance.dumpAutoload.button":"Dump Autoloader","ui.maintenance.composerInstall.title":"Dependências Composer ","ui.maintenance.composerInstall.description":"As dependências dos Composer estão localizadas na pasta {vendor} na raiz da sua aplicação. A reinstalação das dependências pode ser necessária após manipulação ou carregamento manual do ficheiro {composerLock}.","ui.maintenance.composerInstall.button":"Executar Instalador","ui.maintenance.composerInstall.update":"Executar Actualizador Composer","ui.maintenance.composerCache.title":"Cache Composer","ui.maintenance.composerCache.description":"O Composer guarda cache de pacotes provenientes de download para melhor performance. Caso tenha problemas com ficheiros não funcionais, apagar a Composer cache para forçar um novo download poderá resolver o problema.","ui.maintenance.composerCache.button":"Apagar Cache","ui.maintenance.maintenanceMode.title":"Modo Manutenção","ui.maintenance.maintenanceMode.description":"Colocar o Contao em modo de manutenção exibirá um modelo \\"503 Serviço Indisponível\\" para o website.","ui.maintenance.maintenanceMode.enable":"Activar","ui.maintenance.maintenanceMode.disable":"Desactivar","ui.maintenance.debugMode.title":"Modo Depuração","ui.maintenance.debugMode.description":"Activar o modo de depuração definindo um utilizador e uma palavra-passe para o ponto de entrada {appDevPhp}.","ui.maintenance.debugMode.descriptionJwt":"Active o modo de depuração ao definir o cookie de depuração para o domínio corrente.","ui.maintenance.debugMode.activate":"Activar","ui.maintenance.debugMode.deactivate":"Desactivar","ui.maintenance.debugMode.credentials":"Credenciais","ui.maintenance.debugMode.user":"Por favor introduza um nome de utilizador para o modo de depuração.","ui.maintenance.debugMode.password":"Por favor introduza uma senha para o modo de depuração.","ui.maintenance.opcodeCache.title":"Cache Opcode","ui.maintenance.opcodeCache.description":"O Opcode efectua cache de ficheiros PHP no processo web para mais rápida execução. Deverá ser apagado dentro de certas  circunstâncias caso ficheiros não sejam reconhecidos após edição.","ui.maintenance.opcodeCache.button":"Truncar Cache","ui.maintenance.safeMode":"Nao disponível em Modo Segurança","ui.maintenance.unsupported":"Não suportado pela sua versão Contao","ui.packages.updateButton":"Actualizar Pacotes","ui.packages.searchButton":"Procurar Pacotes","ui.packages.searchPlaceholder":"Procurar Pacotes ...","ui.packages.uploadOverlay":"Arrastar e largar ficheiros para upload","ui.packages.uploadButton":"Carregar Packages","ui.packages.uploadMessage":"Tem um carregamento não confirmado. | Tem {count} uploads não confirmados.","ui.packages.uploadApply":"Confirmar Uploads","ui.packages.uploadReset":"Apagar Uploads","ui.packages.uploadIncomplete":"Este ficheiro não foi uploaded completamente. Por favor remova-o e tente novamente.","ui.packages.uploadDuplicate":"Este ficheiro aparenta ter sido uploaded  várias vezes. Por favor remova os duplicados.","ui.packages.uploadInstalled":"Este ficheiro já se encontra instalado. Por favor remova os duplicados.","ui.packages.uploadUnsupported":"Uploads are not supported in your installation. Please make sure that the PHP ZIP extension is installed and update your dependencies.","ui.packages.changesMessage":"Tem uma alteração não confirmada. | Tem {count} alterações não confirmadas.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"Aplicar Alterações","ui.packages.changesApplyAll":"Actualizar todos os pacotes","ui.packages.changesDryrunAll":"Funcionamento a seco todos os pacotes","ui.packages.changesReset":"Reverter Alterações","ui.packages.changesReview":"Rever Alterações","ui.packagelist.loading":"A Carregar ...","ui.packagelist.uploads":"Uploads","ui.packagelist.added":"Novos pacotes","ui.packagelist.installed":"Pacotes instalados","ui.package.hintRevert":"Reverter Alterações","ui.package.hintNoupdate":"Não actualizar","ui.package.hintConstraint":" Este pacote será instalado com limitações de entrada {constraint} quando aplicar alterações.","ui.package.hintConstraintBest":"Este pacote será instalado com a melhor versão disponível quando aplicar alterações.","ui.package.hintConstraintChange":"As limitações de entrada para este pacote serão alteradas de \\"{from}\\" para \\"{to}\\" quando  aplicar alterações.","ui.package.hintConstraintUpdate":"Este pacote será actualizado quando aplicar alterações. ","ui.package.hintAdded":"Este pacote vai ser instalado quando aplicar as alterações.","ui.package.hintRemoved":"Este pacote será removido quando aplicar alterações.","ui.package.requiredTitle":"manualmente adicionado","ui.package.requiredText":"Este pacote é requerido pelo seu composer.json mas não está instalado.","ui.package.removedTitle":"manualmente removido","ui.package.removedText":"Este pacote vai ser removido do seu composer.json.","ui.package.installed":"Actualmente instalado:","ui.package.version":"Versão {version}","ui.package.additionalDownloads":"{count} Descarregar | {count} Descarregar","ui.package.additionalStars":"{count} Estrela | {count} Estrelas","ui.package.editConstraint":"Editar","ui.package.uploadConstraint":"Esta restrição está definida pelo pacote que foi uploaded.","ui.package.updateButton":"Actualizar","ui.package.removeButton":"Remover","ui.package.installButton":"Adicionar Pacote","ui.package.installButtonShort":"Adicionar","ui.package.detailsButton":"Detalhes","ui.package.latestConstraint":"versão mais recente","ui.package.update":"Actualização disponível","ui.package.updateLatest":"versão mais recente","ui.package.updateAvailable":"{version} disponível","ui.package.updateUnknown":"versão desconhecida","ui.package.updateConstraint":"A newer version outside your version constraint is available.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Versão {version}","ui.cloudStatus.waitingTime":"Tempo de Espera","ui.cloudStatus.jobs":"Tarefas Actuais","ui.cloudStatus.workers":"Trabalhadores","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"nenhum","ui.cloudStatus.short":"ca. {minutes} min","ui.cloudStatus.long":"ca. {minutes} min {seconds} seg","ui.cloudStatus.error":"Incapaz de obter o estatuto de Composer Resolver Cloud. Pode ser para questões de manutenção ou de experiência.","ui.cloudStatus.button":"Estado das nuvens","ui.cloudStatus.refresh":"Actualizar o estado das nuvens","ui.log-viewer.loading":"A Carregar ...","ui.log-viewer.empty":"There are no log files on your server.","ui.log-viewer.reload":"Reload","ui.log-viewer.file":"Log file","ui.log-viewer.channel":"Channel","ui.log-viewer.channelTitle":"The channel this message was logged to.","ui.log-viewer.level":"Level","ui.log-viewer.levelTitle":"Severity of the log message.","ui.log-viewer.timeHeader":"Time","ui.log-viewer.messageHeader":"Message","ui.log-viewer.showContext":"Show Context","ui.log-viewer.hideContext":"Hide Context","ui.log-viewer.showExtra":"Show Extra","ui.log-viewer.hideExtra":"Hide Extra","ui.log-viewer.more":"Load more …","ui.log-viewer.download":"Download","ui.log-viewer.downloadTitle":"Download file \\"{file}\\"","ui.log-viewer.prodEnvironment":"Production Environment","ui.log-viewer.devEnvironment":"Development Environment (Debug Mode)"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[477],{6477:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Unsichere Verbindung !!","ui.app.httpsDescription":"Ohne HTTPS werden deine vertraulichen Daten unverschlüsselt übertragen.","ui.app.httpsLink":"Weitere Informationen","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Abgesicherter Modus !!","ui.app.safeModeDescription":"Einige Funktionen des Contao Managers sind nicht verfügbar.","ui.app.safeModeExit":"Beenden","ui.app.loading":"Contao Manager wird geladen …","ui.app.apiError":"Unerwarteter API-Status","ui.app.configSecurity1":"SICHERHEITSWARNUNG !!! Das Konfigurationsverzeichnis ist ungeschützt","ui.app.configSecurity2":"Der Contao Manager hat erkannt, dass seine Konfigurationsdateien öffentlich erreichbar sind. Du musst diese Dateien schützen, bevor der Manager verwendet werden kann, da ein Angreifer sonst auf sensible Daten zugreifen könnte.\\n\\nUm dieses Problem zu beheben, schütze das Verzeichnis \\"contao-manager\\" auf deinem Server. Bei Fragen lies das Handbuch deines Webservers oder wende dich an deinen Hosting-Anbieter.","ui.account.welcome":"Willkommen","ui.account.intro1":"Willkommen zum Contao Manager, einem universellen Werkzeug, um das Contao Open Source CMS zu installieren, zu konfigurieren und zu warten. Wenn du den Manager zum ersten Mal einsetzen, {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} bevor du beginnst","ui.account.introManual":"lies die Dokumentation","ui.account.intro2":"Sollten Probleme auftreten, dann prüfe {ourGithubIssues}. Falls für dein Anliegen noch kein Ticket existiert, kannst du gern ein Neues erstellen.","ui.account.introIssues":"die Tickets auf GitHub","ui.account.headline":"Benutzerkonto","ui.account.description":"Erstelle ein Benutzerkonto, um deine Installation zu verwalten. Beachte dass dieses Konto in keinem Zusammenhang mit dem Contao Backend oder Frontend steht.","ui.account.username":"Benutzername","ui.account.password":"Passwort","ui.account.passwordPlaceholder":"min. 8 Zeichen","ui.account.passwordLength":"Bitte gib mindestens 8 Zeichen ein.","ui.account.submit":"Benutzerkonto erstellen","ui.account.contribute1":"Contao und der Contao Manager werden durch die Contao Association gefördert.","ui.account.contribute2":"{donate} und leiste deinen Beitrag zu Open Source!","ui.account.contributeDonate":"Mach eine Spende","ui.login.headline":"Anmelden","ui.login.description":"Melde dich an, um deine Installation zu verwalten.","ui.login.username":"Benutzername","ui.login.password":"Passwort","ui.login.forgotPassword":"Passwort vergessen?","ui.login.button":"Anmelden","ui.login.locked":"Der Zugriff wurde verweigert, da der Contao Manager gesperrt ist. Zum entsperren lösche die Datei {lockFile} in deinem Contao Hauptverzeichnis.","ui.logout.headline":"Session-Timeout","ui.logout.warning":"Du warst mehr als 25 Minuten inaktiv. Aus Sicherheitsgründen wird deine Sitzung in Kürze beendet.","ui.logout.expired":"Deine Sitzung wurde automatisch beendet, da du mehr als 30 Minuten inaktiv warst.","ui.logout.renew":"Angemeldet bleiben","ui.logout.logout":"Abmelden","ui.logout.login":"Zurück zum Login","ui.oauth.error":"Ungültiger OAuth-Versuch. Bitte überprüfe die Request-Parameter.","ui.oauth.https":"Die Rückleitungs-URL MUSS eine sichere Verbindung (https:) nutzen, um die Übertragung der Anmeldedaten im Klartext zu verhindern.","ui.oauth.headline":"Remote-Anmeldung","ui.oauth.description":"Die folgende Anwendung oder der folgende Dienst fordert den Fernzugriff auf deine Contao Manager-Instanz an.","ui.oauth.domain":"Bevor du diesen Zugriff erlaubst, stelle sicher dass du die URL kennst und ihr vertraust!","ui.oauth.allow":"Zugriff erlauben","ui.oauth.deny":"Zugriff verweigern","ui.boot.headline":"Systemprüfung","ui.boot.description":"Bitte warten, dein Server wird überprüft …","ui.boot.issue1":"Installationsprobleme erkannt","ui.boot.issue2":"Du musst die Installationsprobleme beheben, bevor der Contao Manager verwendet werden kann.","ui.boot.run":"Contao Manager starten","ui.boot.safeMode":"Abgesicherten Modus starten","ui.recovery.headline":"Systemwiederherstellung","ui.recovery.description":"Es wurden Dateien erkannt, die nach einer Contao-Installation aussehen, aber die Kommandozeile scheint nicht korrekt zu funktionieren.","ui.recovery.console":"Konsolenausgabe","ui.recovery.repairOptions":"Wähle eine Option, um das System zu reparieren.","ui.recovery.repairHeadline":"Automatische Reparatur","ui.recovery.repairDescription":"Versucht eine automatische Systemreparatur, indem der Cache neu aufgebaut und die Composer-Pakete neu installiert werden.","ui.recovery.repairWarning":"Manuelle Änderungen an den vendor-Dateien können dabei verloren gehen!","ui.recovery.repairFailed":"Die automatische Reparatur ist fehlgeschlagen. Versuche den abgesicherten Modus, um die Installation von Hand zu reparieren.","ui.recovery.repairButton":"Reparatur ausführen","ui.recovery.safeModeHeadline":"Abgesicherter Modus","ui.recovery.safeModeDescription":"Der abgesicherte Modus erlaubt die Paketverwaltung und gewisse Wartungsaufgaben, aber Funktionen, welche ein funktionierendes Contao benötigen, sind nicht verfügbar.","ui.recovery.safeModeButton":"Abgesicherten Modus starten","ui.server.pending":"Warten …","ui.server.running":"Analysiere …","ui.server.error":"Die Prüfung ist aufgrund einer unerwarteten Server-Antwort fehlgeschlagen.","ui.server.details":"Details","ui.server.prerequisite":"Prüfung aufgrund fehlender Abhängigkeiten abgebrochen.","ui.server.selfUpdate.title":"Updates für den Contao Manager","ui.server.selfUpdate.update":"Die neue Version {latest} des Contao Managers ist verfügbar.","ui.server.selfUpdate.manualUpdate":"Eine neue Version {latest} des Contao Manager ist verfügbar. Dein Server unterstützt keine automatischen Updates, bitte lade die neue Version von {download} herunter.","ui.server.selfUpdate.latest":"Du verwendest die aktuelle Version {current}.","ui.server.selfUpdate.dev":"Entwicklungs-Versionen können nicht automatisch aktualisiert werden.","ui.server.selfUpdate.unsupported":"Eine neue Version ist verfügbar, aber diese funktioniert nicht mit deiner PHP-Version.","ui.server.selfUpdate.button":"Aktualisieren","ui.server.selfUpdate.continue":"Weiter","ui.server.config.title":"Serverkonfiguration","ui.server.config.setup":"Konfigurieren","ui.server.config.change":"Ändern","ui.server.config.save":"Speichern","ui.server.config.cancel":"Abbrechen","ui.server.config.customOption":"Andere …","ui.server.config.description":"Der Contao Manager benötigt den Pfad zum PHP-Binary und weitere Server-Informationen, um Hintergrund-Prozesse korrekt auszuführen.","ui.server.config.formTitle":"Serverkonfiguration","ui.server.config.formText":"Bitte gib den Pfad zu deinem PHP-Binary ein. Das Binary muss dieselbe PHP-Version sein wie der Webprozess.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Die Composer Resolver Cloud erlaubt die Installation von Composer-Abhängigkeiten, selbst wenn der lokale Server nicht über genug Arbeitsspeicher verfügt. Beachte dass deine Paketinformationen an einen Cloud-Dienst der Contao Association übermittelt werden.","ui.server.config.cloud":"Die Composer Resolver Cloud verwenden","ui.server.config.cli":"PHP-Binary","ui.server.config.stateErrorCli":"Es wurde kein valides PHP-Programm auf dem Server gefunden.","ui.server.config.stateErrorCloud":"Die Composer Resolver Cloud wird nicht unterstützt.","ui.server.config.stateSuccess":"PHP-Binary in {php_cli}.","ui.server.php_web.title":"PHP-Webprozess","ui.server.php_web.below7":"PHP Version {version} gefunden. Bitte wechsle baldmöglichst auf PHP 7!","ui.server.php_web.success":"PHP Version {version}, keine bekannten Probleme gefunden.","ui.server.php_cli.title":"PHP Kommandozeilen-Programm","ui.server.php_cli.success":"PHP Version {version}, keine bekannten Probleme gefunden.","ui.server.composer.title":"Composer-Umgebung","ui.server.composer.success":"Keine bekannten Probleme gefunden.","ui.server.composer.install":"Composer-Abhängigkeiten sind nicht installiert.","ui.server.composer.button":"Installieren","ui.server.contao.title":"Contao-Installation","ui.server.contao.setup":"Einrichtung","ui.server.contao.check":"Datenbank überprüfen","ui.server.contao.empty":"Es wurde keine Contao-Installation gefunden.","ui.server.contao.old":"Contao {version} ist nicht kompatibel mit dem Contao Manager; bitte aktualisiere deine Installation manuell.","ui.server.contao.found":"Contao {version} (API-Version {api}) gefunden.","ui.server.contao.connectionError":"Verbindung zum Datenbank-Server fehlgeschlagen.","ui.server.contao.connectionProblem":"Datenbank-Problem gefunden.","ui.server.contao.missingUser":"Administratorkonto nicht gefunden.","ui.setup.continue":"Weiter","ui.setup.manager":"Contao Manager starten","ui.setup.cancel":"Abbrechen","ui.setup.welcome":"Willkommen","ui.setup.welcome1":"Dieser Assistent führt dich durch die Installation und Einrichtung deines Contao Open Source CMS.","ui.setup.welcome2":"Solltest du Fragen haben, findest du die Dokumentation, das Forum, den Slack Kanal und weiteres auf der {support}-Seite.","ui.setup.support":"Contao-Support","ui.setup.start":"Los geht\'s","ui.setup.complete":"Geschafft!","ui.setup.complete1":"Contao {version} wurde erfolgreich installiert.","ui.setup.complete2":"Um die Installation fertig zu stellen, öffne bitte das Install-Tool um die Datenbank zu verbinden und ein Backend-Konto hinzuzufügen.","ui.setup.complete3":"Du kannst nun deine Webseite im Contao Backend einrichten. Willst du Erweiterungen installieren fahre mit dem Contao Manager fort.","ui.setup.installTool":"Install-Tool öffnen","ui.setup.login":"Contao Login","ui.setup.funding":"Ohne seine Community wäre Contao nicht das, was es heute ist. Wenn du professionell Webseiten mit Contao erstellst, sind wir auf deine Unterstützung angewiesen. Mit einer Investition in das Projekt sicherst du die Entwicklung für die Zukunft, damit dein Unternehmen weiterhin von Contao profitieren kann.","ui.setup.fundingLink":"Weitere Informationen","ui.setup.document-root.headline":"Webserver-Einrichtung","ui.setup.document-root.warning":"Um Contao über den Contao Manager zu installieren, muss das Wurzelverzeichnis des Webservers angepasst werden.","ui.setup.document-root.description1":"Contao verwendet einen Unterordner für öffentliche Dateien, die Systemdaten werden im übergeordneten Ordner installiert. Contao kann nicht installiert werden, wenn die Struktur nicht stimmt oder die Ordner nicht leer sind.","ui.setup.document-root.description2":"Falls du nicht weisst, wie dein Wurzelverzeichnis konfiguriert werden kann, lies die Contao Dokumentation oder kontaktiere deinen Hosting-Anbieter.","ui.setup.document-root.documentation":"Dokumentation lesen","ui.setup.document-root.conflictsTitle":"Installationsverzeichnis nicht leer","ui.setup.document-root.conflictsDirectory":"Das Wurzelverzeichnis deiner zukünftigen Contao-Installation ist nicht leer, es wurden {count} Datei(en) gefunden, die bei der Installation überschrieben werden könnten. Es wird empfohlen Contao in ein leeres Verzeichnis zu installieren, aber du kannst auch die Dateien löschen und erneut prüfen lassen wenn du sicher bist dass diese nicht benötigt werden.","ui.setup.document-root.ignoreConflicts":"Ich will Contao in ein nicht-leeres Verzeichnis installieren. Ich verstehe dass dadurch bestehende Dateien auf meinem Server möglicherweise überschrieben werden.","ui.setup.document-root.check":"Erneut prüfen","ui.setup.document-root.create":"Verzeichnisse erstellen","ui.setup.document-root.change":"Verzeichnisse ändern","ui.setup.document-root.formTitle":"Verzeichnisstruktur einrichten","ui.setup.document-root.formText1":"Der Contao Manager kann automatisch eine neue Verzeichnisstruktur auf dem Server einrichten.","ui.setup.document-root.formText2":"Du musst das Wurzelverzeichnis danach manuell umkonfigurieren (z. B. über die Hosting-Administration).","ui.setup.document-root.autoconfig":"Ich habe verstanden dass meine Server-Konfiguration geändert werden muss. Wenn ich dies nicht tue, funktioniert der Contao Manager nicht mehr und meine Konfigurationsdateien (inklusive Benutzer & Passwörter) werden öffentlich erreichbar!","ui.setup.document-root.directory":"Neuer Ordner","ui.setup.document-root.currentRoot":"Aktuelles Wurzelverzeichnis","ui.setup.document-root.newRoot":"Neues Wurzelverzeichnis","ui.setup.document-root.finish":"Ordner erstellen","ui.setup.document-root.publicDir":"{dir} für öffentliche Dateien nutzen (Contao {version})","ui.setup.document-root.directoryInvalid":"Bitte gib einen gültigen Ordnernamen ein.","ui.setup.document-root.directoryExists":"Das Zielverzeichnis ist bereits vorhanden. Bitte gibt einen anderen Namen ein.","ui.setup.document-root.confirmation":"Der Contao Manager hat die benötigten Verzeichnisse erfolgreich angelegt. Nun musst du dein Wurzelverzeichnis anpassen. Lade die Seite nicht neu bis dies erledigt ist.","ui.setup.document-root.reload":"Neu laden","ui.setup.document-root.success":"Die Verzeichnisstruktur auf deinem Server ist korrekt eingerichtet!","ui.setup.document-root.installingProjectDir":"Systemdateien werden nach {dir} installiert.","ui.setup.document-root.installingPublicDir":"Öffentliche Dateien werden nach {dir} installiert.","ui.setup.document-root.installedProjectDir":"Systemdateien sind in {dir} installiert.","ui.setup.document-root.installedPublicDir":"Öffentliche Dateien sind in {dir} installiert.","ui.setup.create-project.headline":"Contao-Installation","ui.setup.create-project.description":"Die Contao-Entwicklung folgt dem Prinzip von {semver}, eine neue Minor-Version wird alles sechs Monate veröffentlicht. Die aktuell unterstützten Versionen sind:","ui.setup.create-project.semver":"Semantic Versioning","ui.setup.create-project.latestTitle":"Neuste","ui.setup.create-project.ltsTitle":"Langzeit-Support","ui.setup.create-project.latestQ1":"Unsere neuste Version mit den meisten Funktionen, wird bis Februar {year} unterstützt.","ui.setup.create-project.latestQ3":"Unsere neuste Version mit den meisten Funktionen, wird bis August {year} unterstützt.","ui.setup.create-project.ltsText":"Unsere aktuelle LTS-Version mit Fokus auf Stabilität. Bietet einen verlängerten Supportzeitraum bis Februar {year}.","ui.setup.create-project.pltsText":"Die vorherige LTS-Version, hat einen verlängerten Supportzeitraum bis Februar {year}","ui.setup.create-project.requiresPHP":"Benötigt mindestens PHP {version}, du hast PHP {current}.","ui.setup.create-project.requiresDocroot":"Das Wurzelverzeichnis muss \\"{folder}\\" sein.","ui.setup.create-project.releaseplan":"Weitere Details findest du im {contaoReleasePlan}.","ui.setup.create-project.releaseplanLink":"Contao Release-Plan","ui.setup.create-project.installed":"Contao {version} wurde erfolgreich auf dem Server installiert. Fahre weiter um die Datenbank einzurichten, oder gehe zum Contao Manager um eine andere Version zu installieren.","ui.setup.create-project.formTitle":"Wähle eine Distribution","ui.setup.create-project.formText":"Bitte wähle die zu installierende Version.","ui.setup.create-project.version":"Version","ui.setup.create-project.demo":"Beispiel-Webseite installieren","ui.setup.create-project.demoDescription":"Die Beispiel-Webseite von Contao hilft dir dabei, dich mit dem System und seinen Hauptfunktionen vertraut zu machen. Weitere Themes findest du im {store}.","ui.setup.create-project.coreOnly":"Minimale Installation (nur Core)","ui.setup.create-project.noUpdate":"Installation überspringen (Expertenmodus!)","ui.setup.create-project.theme":"Theme für Contao","ui.setup.create-project.themeInstall":"Um ein Theme für Contao zu installieren, benutze die Sucheingabe oder lade eine Theme-Datei (.cto/.zip) hoch, die den Contao Manager unterstützt.","ui.setup.create-project.themeBuy":"Besuche auch den {store}.","ui.setup.create-project.themeStore":"Contao Themes-Store","ui.setup.create-project.themeUpload":"Theme-Datei (.cto/.zip) hochladen","ui.setup.create-project.themeInvalid":"Die hochgeladene Datei ist kein Theme für Contao oder unterstützt die Installation im Contao Manager nicht.","ui.setup.create-project.themeWarning":"Der Contao Manager kann nicht beurteilen ob dieses Theme mit deinem Server kompatibel ist. Wende dich bei Fragen bitte direkt an den Theme-Hersteller.","ui.setup.create-project.themeTitle":"Theme-Details überprüfen","ui.setup.create-project.themeDetails":"Die nachfolgenden Abhängigkeiten und Dateien werden mit diesem Theme installiert.","ui.setup.create-project.themeRequire":"{count} Abhängigkeit | {count} Abhängigkeiten","ui.setup.create-project.themeFiles":"{count} Datei | {count} Dateien","ui.setup.create-project.theme.or":"oder suche öffentliche Themes","ui.setup.create-project.theme.search":"Themes durchsuchen","ui.setup.create-project.theme.more":"Weitere Themes","ui.setup.create-project.theme.empty":"Keine Theme für {query} gefunden","ui.setup.create-project.theme.uploaded":"Die Theme-Datei wurde erfolgreich hochgeladen.","ui.setup.create-project.theme.packageName":"Paketname","ui.setup.create-project.theme.version":"Version","ui.setup.create-project.theme.authors":"Autor(en)","ui.setup.create-project.install":"Installieren","ui.setup.create-project.cancel":"Abbrechen","ui.setup.database-connection.headline":"Datenbank-Verbindung","ui.setup.database-connection.description":"Contao benötigt eine MySQL Datenbank (oder ein kompatibler Fork wie MariaDB) um Seiten, Inhalte und andere Daten zu speichern. Die Verbindungsdaten werden in der Datei {env} im Systemverzeichnis von Contao gespeichert werden.","ui.setup.database-connection.formTitle":"Verbindungs-Parameter","ui.setup.database-connection.formText":"Gib eine Datenbank-URL ein, oder fülle die Felder für Benutzername, Passwort, Server und Datenbank separat aus.","ui.setup.database-connection.url":"Datenbank-URL","ui.setup.database-connection.validUrl":"Datenbank-URL ungültig oder Verbindung zum Server fehlgeschlagen.","ui.setup.database-connection.or":"oder","ui.setup.database-connection.user":"Benutzername","ui.setup.database-connection.password":"Passwort","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Datenbankname","ui.setup.database-connection.connected":"Erfolgreich verbunden mit Datenbank {database} auf {server}.","ui.setup.database-connection.error":"Fehler beim verbinden mit der Datenbank.","ui.setup.database-connection.problem":"Contao hat ein Problem mit dem Datenbank-Server gefunden.","ui.setup.database-connection.schemaTitle":"Datenbank-Schema","ui.setup.database-connection.migration":"Es gibt eine ausstehende Migration. | Es gibt {count} ausstehende Migrationen.","ui.setup.database-connection.schema":"Es gibt eine ausstehende Schema-Änderung. | Es gibt {count} ausstehende Schema-Änderungen.","ui.setup.database-connection.noChanges":"Dein Datenbank-Schema ist aktuell.","ui.setup.database-connection.check":"Datenbank überprüfen","ui.setup.database-connection.skip":"Überspringen","ui.setup.database-connection.save":"Speichern","ui.setup.database-connection.change":"Zugangsdaten ändern","ui.setup.database-connection.restoreTitle":"Datenbank-Import","ui.setup.database-connection.restoreText":"Das soeben installierte Theme enthält ein Datenbank-Backup. Du kannst diese Theme-Daten in die Datenbank importieren oder diesen Schritt überspringen und mit einem leeren Contao beginnen. | Das soeben installierte Theme enthält mehrere Datenbank-Backups. Wähle eine Backup-Datei für den Import oder überspringe diesen Schritt, um mit einem leeren Contao zu beginnen.","ui.setup.database-connection.backup":"Datenbank vor dem Import sichern","ui.setup.database-connection.backupWarning":"Alle Daten in der Datenbank werden beim Import überschrieben! Erstelle zuerst ein Backup, falls die Datenbank nicht leer ist.","ui.setup.database-connection.restore":"Theme importieren","ui.setup.database-connection.restoreOption":"Backup vom {date} ({size})","ui.setup.database-connection.restored":"Die Theme-Datenbank wurde erfolgreich importiert. Fahre fort um das Datenbank-Schema zu überprüfen.","ui.setup.backend-user.success":"Es ist bereits ein Benutzerkonto in der Datenbank vorhanden. Weitere Konten können über das Backend hinzugefügt werden.","ui.setup.backend-user.error":"Die Benutzerliste konnte nicht gelesen werden. Weitere Details findest du in der Konsolen-Ausgabe.","ui.setup.backend-user.headline":"Backend-Konto","ui.setup.backend-user.description":"Um deine Webseite zu verwalten benötigst du mindestens ein Administratorkonto für das Contao Backend. Beachte dass dieses Konto nicht mit dem Contao Manager zusammenhängt.","ui.setup.backend-user.formTitle":"Benutzerkonto erstellen","ui.setup.backend-user.formText":"Bitte gib die Details für das neue Backend-Konto ein.","ui.setup.backend-user.username":"Benutzername","ui.setup.backend-user.name":"Name","ui.setup.backend-user.email":"E-Mail Adresse","ui.setup.backend-user.emailInvalid":"Bitte gib eine gültige E-Mail Adresse ein","ui.setup.backend-user.password":"Passwort","ui.setup.backend-user.passwordPlaceholder":"min. 8 Zeichen","ui.setup.backend-user.passwordLength":"Bitte gib mindestens 8 Zeichen ein.","ui.setup.backend-user.create":"Konto hinzufügen","ui.task.headline":"Hintergrund-Prozess","ui.task.loading":"Lade Details …","ui.task.created":"Lade Details …","ui.task.active":"Bitte warte, während der Contao Manager die nötigen Operationen im Hintergrund ausführt.","ui.task.complete":"Alle Operationen erfolgreich abgeschlossen. Weitere Details findest du in der Konsolen-Ausgabe.","ui.task.aborting":"Bitte warte während der Hintergrund-Prozess abgebrochen wird.","ui.task.stopped":"Einige Operationen wurden abgebrochen. Bitte prüfe die Konsolen-Ausgabe.","ui.task.error":"Ein Hintergrund-Prozess wurde unerwartet beendet. Bitte prüfe die Konsolen-Ausgabe.","ui.task.failed":"Der Contao Manager konnte den Hintergrund-Prozess nicht starten.","ui.task.failedDescription1":"Die Ausführung der Aufgabe ist fehlgeschlagen.","ui.task.failedDescription2":"Sollte dies wiederholt geschehen, wird dein Server möglicherweise nicht unterstützt.","ui.task.reportProblem":"Probleme melden","ui.task.sponsor":"Composer Cloud gesponsert von {sponsor}","ui.task.buttonAudit":"Datenbank aktualisieren","ui.task.buttonClose":"Schließen","ui.task.buttonConfirm":"Bestätigen & Schließen","ui.task.buttonCancel":"Abbrechen","ui.task.confirmCancel":"Möchtest du diesen Prozess wirklich abbrechen? Deine Contao-Installation könnte in einem defekten Zustand zurückbleiben!","ui.task.autoclose":"Fenster bei Erfolg schließen","ui.console.toggle":"Konsolenausgabe anzeigen/verstecken","ui.console.showLog":"Vollständige Konsole anzeigen","ui.console.copyLog":"Konsole in Zwischenablage kopieren","ui.migrate.headline":"Datenbank-Änderungen","ui.migrate.migrationsOnly":"(nur Migrationen)","ui.migrate.schemaOnly":"(nur Schema)","ui.migrate.loading":"Bitte warten, die Datenbank wird überprüft …","ui.migrate.empty":"Keine ausstehenden Migrationen oder Schema-Änderungen gefunden. Deine Datenbank ist auf dem aktuellsten Stand.","ui.migrate.emptyMigrations":"Keine ausstehenden Migrationen gefunden. Bitte prüfe auch die Schema-Änderungen.","ui.migrate.emptySchema":"Keine ausstehenden Schema-Änderungen gefunden. Bitte prüfe auch die Migrationen.","ui.migrate.pending":"Die Datenbank ist nicht aktuell. Bitte prüfe die untenstehende Konsolenausgabe und führe die Änderungen aus.","ui.migrate.previousChanges":"Eine vorherige Datenbankmigration wurde nicht bestätigt.\\nBitte prüfen die untenstehende Konsolenausgabe und klicke weiter, um die nächsten Änderungen zu sehen.","ui.migrate.previousComplete":"Eine vorherige Datenbankmigration wurde nicht bestätigt, bitte prüfe die untenstehende Konsolenausgabe.\\nEs gibt keine weiteren ausstehenden Änderungen.","ui.migrate.appliedChanges":"Die Datenbankänderungen wurden übernommen.\\nBitte prüfe die untenstehende Konsolenausgabe, dann klicke weiter, um die nächsten Änderungen zu sehen.","ui.migrate.appliedComplete":"Die Datenbankänderungen wurden übernommen.\\nEs gibt keine weiteren Migrationen oder Schema-Änderungen. Deine Datenbank ist auf dem aktuellen Stand.","ui.migrate.problem":"Contao hat ein Problem mit dem Datenbank-Server gefunden.\\nBitte prüfe die Konsolen-Ausgabe unten um zu sehen was angepasst werden muss. | Contao hat Probleme mit dem Datenbank-Server gefunden.\\nBitte prüfe die Konsolen-Ausgabe unten um zu sehen was angepasst werden muss.","ui.migrate.warning":"Contao hat eine Fehlkonfiguration des Datenbank-Servers gefunden.\\nDie unten stehenden Warnungen sollten für optimalen Betrieb und Datensicherheit behoben werden.","ui.migrate.error":"Die Änderungen konnten nicht angewendet werden. Möglicherweise wurde die Datenbank geändert, bitte prüfe nochmals und versuche es erneut.","ui.migrate.execute":"Ausführen","ui.migrate.close":"Schließen","ui.migrate.confirm":"Bestätigen & Schließen","ui.migrate.cancel":"Abbrechen","ui.migrate.continue":"Weiter","ui.migrate.setup":"Einrichtung","ui.migrate.skip":"Überspringen","ui.migrate.retry":"Erneut prüfen","ui.migrate.retryAll":"Alles überprüfen","ui.migrate.withDeletes":"Alle Änderungen inklusive Löschungen anwenden.","ui.migrate.migrationTitle":"Datenbank-Migrationen","ui.migrate.schemaTitle":"Schema-Änderungen","ui.migrate.problemTitle":"Datenbank-Probleme","ui.migrate.warningTitle":"Datenbank-Warnungen","ui.migrate.addTable":"Tabelle {table} hinzufügen","ui.migrate.dropTable":"Tabelle {table} löschen","ui.migrate.addField":"Feld {table}.{field} hinzufügen","ui.migrate.changeField":"Feld {table}.{field} ändern","ui.migrate.dropField":"Feld {table}.{field} löschen","ui.migrate.createIndex":"Index \\"{name}\\" zu {table} hinzufügen","ui.migrate.dropIndex":"Index \\"{name}\\" aus {table} löschen","ui.widget.mandatory":"Dieses Feld darf nicht leer sein.","ui.widget.blankOption":"Bitte wählen …","ui.widget.showPassword":"Passwort anzeigen","ui.widget.hidePassword":"Passwort ausblenden","ui.error.title":"HTTP-Anfrage für \\"{method} {url}\\" fehlgeschlagen.","ui.error.server500":"Es scheint ein unbekannter Fehler aufgetreten zu sein. Prüfe die Log-Dateien deines Webservers (Apache/Nginx) und des Contao Managers im Ordner \\"contao-manager/logs\\".","ui.error.response":"Der Server hat eine Antwort mit Status-Code {status} gesendet.","ui.error.moreLink":"Weitere Informationen","ui.error.support":"Contao Support","ui.footer.help":"Hilfe","ui.footer.reportProblem":"Probleme melden","ui.navigation.discover":"Entdecken","ui.navigation.packages":"Pakete","ui.navigation.tools":"Tools","ui.navigation.installTool":"Installtool","ui.navigation.backend":"Contao-Backend","ui.navigation.debug":"Contao-Debug-Modus","ui.navigation.logViewer":"System-Log","ui.navigation.phpinfo":"PHP-Informationen","ui.navigation.phpinfoLoading":"Lade PHP-Informationen…","ui.navigation.maintenance":"Systemwartung","ui.navigation.rebuildCache":"Cache erneuern","ui.navigation.systemCheck":"Systemprüfung","ui.navigation.advanced":"Fortgeschritten","ui.navigation.logout":"Abmelden","ui.maintenance.database.title":"Datenbank-Migrationen und -Backups","ui.maintenance.database.description":"Datenbankmigrationen stellen konsistente Daten und Tabellenschemas sicher.","ui.maintenance.database.migrations":"Eine ausstehende Datenbank-Migration | {count} ausstehende Datenbank-Migrationen","ui.maintenance.database.schemaUpdates":"Eine ausstehende Schema-Änderung | {count} ausstehende Schema-Änderungen","ui.maintenance.database.error":"Datenbank-Problem gefunden.","ui.maintenance.database.warning":"Datenbank-Warnung gefunden.","ui.maintenance.database.button":"Datenbank überprüfen","ui.maintenance.database.migrationOnly":"Nur Migrationen prüfen","ui.maintenance.database.schemaOnly":"Nur Schema prüfen","ui.maintenance.database.installTool":"Install-Tool öffnen","ui.maintenance.database.createBackup":"Backup erstellen","ui.maintenance.database.backupUnsupported":"Datenbank-Backups werden von deiner Contao-Version nicht unterstützt.","ui.maintenance.database.backupList":"Du hast ein Datenbank-Backup, erstellt am {date}. | Du hast {count} Datenbank-Backups, das neuste wurde am {date} erstellt.","ui.maintenance.database.backupEmpty":"Du hast noch keine Datenbank-Backups.","ui.maintenance.rebuildCache.title":"Anwendungs-Cache","ui.maintenance.rebuildCache.description":"Nach dem Ändern einer der Konfigurationsdateien muss der Anwendungs-Cache neu aufgebaut werden.","ui.maintenance.rebuildCache.rebuildProd":"Prod.-Cache erneuern","ui.maintenance.rebuildCache.rebuildDev":"Dev.-Cache erneuern","ui.maintenance.rebuildCache.clearProd":"Prod.-Cache leeren","ui.maintenance.rebuildCache.clearDev":"Dev.-Cache leeren","ui.maintenance.installTool.title":"Contao-Installtool","ui.maintenance.installTool.description":"Das Contao-Installtool wird automatisch gesperrt, wenn das Passwort drei Mal falsch eingegeben wird.","ui.maintenance.installTool.unlock":"Installtool entsperren","ui.maintenance.installTool.lock":"Installtool sperren","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"Der Composer-Autoloader ist für das Laden der PHP-Klassen verantwortlich. Der Autoloader muss nach dem Hinzufügen von eigenen Namespaces in die composer.json neu geschrieben werden.","ui.maintenance.dumpAutoload.button":"Datei aktualisieren","ui.maintenance.composerInstall.title":"Composer-Abhängigkeiten","ui.maintenance.composerInstall.description":"Composer-Abhängigkeiten befinden sich im Ordner {vendor} im Hauptverzeichnis deiner Anwendung. Eine Neuinstallation der Abhängigkeiten kann nach der Bearbeitung oder dem manuellen Hochladen der Datei {composerLock} notwendig sein.","ui.maintenance.composerInstall.button":"Installer ausführen","ui.maintenance.composerInstall.update":"Composer Update ausführen","ui.maintenance.composerCache.title":"Composer-Cache","ui.maintenance.composerCache.description":"Composer speichert heruntergeladene Pakete im Cache, um die Performance zu verbessern. Wenn Du z. B. Probleme mit korrupten Dateien hast, kannst du den Composer-Cache leeren, um einen neuen Download zu erzwingen.","ui.maintenance.composerCache.button":"Cache leeren","ui.maintenance.maintenanceMode.title":"Wartungsmodus","ui.maintenance.maintenanceMode.description":"Im Wartungsmodus zeigt Contao das \\"503 Dienst nicht verfügbar\\"-Template anstelle der Webseite an.","ui.maintenance.maintenanceMode.enable":"Aktivieren","ui.maintenance.maintenanceMode.disable":"Deaktivieren","ui.maintenance.debugMode.title":"Debug-Modus","ui.maintenance.debugMode.description":"Aktiviere den Debug-Modus, indem du einen Benutzer und ein Passwort für den Einstiegspunkt {appDevPhp} festlegen.","ui.maintenance.debugMode.descriptionJwt":"Aktiviert den Debug-Modus, indem für die aktuelle Domain ein entsprechendes Cookie gesetzt wird.","ui.maintenance.debugMode.activate":"Aktivieren","ui.maintenance.debugMode.deactivate":"Deaktivieren","ui.maintenance.debugMode.credentials":"Anmeldedaten","ui.maintenance.debugMode.user":"Bitte gib einen Benutzernamen für den Debug-Modus ein.","ui.maintenance.debugMode.password":"Bitte gib ein Passwort für den Debug-Modus ein.","ui.maintenance.opcodeCache.title":"Opcode-Cache","ui.maintenance.opcodeCache.description":"Der Opcode-Cache speichert PHP-Dateien im Webprozess für eine schnellere Ausführung. Er muss unter Umständen gelöscht werden, wenn Dateien nach dem Ändern nicht erkannt werden.","ui.maintenance.opcodeCache.button":"Cache leeren","ui.maintenance.safeMode":"Deaktiviert im abgesicherten Modus","ui.maintenance.unsupported":"Von deiner Contao-Version nicht unterstützt","ui.packages.updateButton":"Pakete aktualisieren","ui.packages.searchButton":"Pakete suchen","ui.packages.searchPlaceholder":"Pakete suchen …","ui.packages.uploadOverlay":"Lege Dateien hier ab, um sie hochzuladen","ui.packages.uploadButton":"Pakete hochladen","ui.packages.uploadMessage":"Du hast einen unbestätigten Upload. | Du hast {count} unbestätigte Uploads.","ui.packages.uploadApply":"Uploads bestätigen","ui.packages.uploadReset":"Uploads löschen","ui.packages.uploadIncomplete":"Diese Datei wurde nicht vollständig hochgeladen. Bitte entferne sie und versuchen es noch einmal.","ui.packages.uploadDuplicate":"Diese Datei scheint mehrfach hochgeladen worden zu sein. Bitte entferne die Duplikate.","ui.packages.uploadInstalled":"Diese Datei ist bereits installiert. Bitte entferne die Duplikate.","ui.packages.uploadUnsupported":"Uploads werden in deiner Installation nicht unterstützt. Stelle sicher dass die PHP ZIP-Erweiterung installiert ist und aktualisiere die Abhängigkeiten.","ui.packages.changesMessage":"Du hast eine unbestätigte Änderung. | Du hast {count} unbestätigte Änderungen.","ui.packages.changesDryrun":"Testlauf","ui.packages.changesApply":"Änderungen anwenden","ui.packages.changesApplyAll":"Alle Pakete aktualisieren","ui.packages.changesDryrunAll":"Testlauf mit allen Paketen","ui.packages.changesReset":"Änderungen verwerfen","ui.packages.changesReview":"Änderungen prüfen","ui.packagelist.loading":"Laden …","ui.packagelist.uploads":"Uploads","ui.packagelist.added":"Neue Pakete","ui.packagelist.installed":"Installierte Pakete","ui.package.hintRevert":"Änderung verwerfen","ui.package.hintNoupdate":"Nicht aktualisieren","ui.package.hintConstraint":"Dieses Paket wird mit der Versionsbedingung {constraint} installiert, wenn du die Änderungen anwendest.","ui.package.hintConstraintBest":"Dieses Paket wird in der besten verfügbaren Version installiert, wenn du die Änderungen anwendest.","ui.package.hintConstraintChange":"Die Versionsbedingung dieses Pakets wird von \\"{from}\\" in \\"{to}\\" geändert, wenn du die Änderungen anwendest.","ui.package.hintConstraintUpdate":"Dieses Paket wird aktualisiert, wenn du die Änderungen anwendest.","ui.package.hintAdded":"Dieses Paket wird installiert, wenn du die Änderungen anwendest.","ui.package.hintRemoved":"Dieses Paket wird entfernt, wenn du die Änderungen anwendest.","ui.package.requiredTitle":"manuell hinzugefügt","ui.package.requiredText":"Dieses Paket wurde in der composer.json hinzugefügt, ist aber nicht installiert.","ui.package.removedTitle":"manuell entfernt","ui.package.removedText":"Dieses Paket wurde aus der composer.json entfernt.","ui.package.installed":"Aktuell installiert:","ui.package.version":"Version {version}","ui.package.additionalDownloads":"{count} Download | {count} Downloads","ui.package.additionalStars":"{count} Stern | {count} Sterne","ui.package.editConstraint":"Bearbeiten","ui.package.uploadConstraint":"Diese Versionsbedingung wird von dem hochgeladenen Paket definiert.","ui.package.updateButton":"Aktualisieren","ui.package.removeButton":"Entfernen","ui.package.installButton":"Paket hinzufügen","ui.package.installButtonShort":"Hinzufügen","ui.package.detailsButton":"Details","ui.package.latestConstraint":"neuste Version","ui.package.update":"Update verfügbar","ui.package.updateLatest":"neuste Version","ui.package.updateAvailable":"{version} verfügbar","ui.package.updateUnknown":"unbekannte Version","ui.package.updateConstraint":"Es ist eine neuere Version ausserhalb der Versionsbedingung verfügbar.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Version {version}","ui.cloudStatus.waitingTime":"Wartezeit","ui.cloudStatus.jobs":"Aktive Aufgaben","ui.cloudStatus.workers":"Server","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"keine","ui.cloudStatus.short":"ca. {minutes} min","ui.cloudStatus.long":"ca. {minutes} min {seconds} sek","ui.cloudStatus.error":"Status der Composer Resolver Cloud konnte nicht abgerufen werden. Möglicherweise gibt es ein Wartungsfenster oder Systemprobleme.","ui.cloudStatus.button":"Cloud-Status","ui.cloudStatus.refresh":"Cloud-Status aktualisieren","ui.log-viewer.loading":"Laden …","ui.log-viewer.empty":"Auf dem Server sind keine Logdateien vorhanden.","ui.log-viewer.reload":"Neu laden","ui.log-viewer.file":"Logdatei","ui.log-viewer.channel":"Kanal","ui.log-viewer.channelTitle":"Kanal in welcher die Nachricht geschrieben wurde.","ui.log-viewer.level":"Stufe","ui.log-viewer.levelTitle":"Wichtigkeit der Log-Nachricht.","ui.log-viewer.timeHeader":"Uhrzeit","ui.log-viewer.messageHeader":"Nachricht","ui.log-viewer.showContext":"Kontext anzeigen","ui.log-viewer.hideContext":"Kontext ausblenden","ui.log-viewer.showExtra":"Extras anzeigen","ui.log-viewer.hideExtra":"Extras ausblenden","ui.log-viewer.more":"Mehr laden …","ui.log-viewer.download":"Herunterladen","ui.log-viewer.downloadTitle":"Datei \\"{file}\\" herunterladen","ui.log-viewer.prodEnvironment":"Produktivumgebung","ui.log-viewer.devEnvironment":"Entwicklungsumgebung (Debug Modus)"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[606],{4606:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Ligação Insegura !!","ui.app.httpsDescription":"Sem recurso a HTTPS os seus dados confidenciais serão transferidos sem encriptação.","ui.app.httpsLink":"Mais info","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Modo Guardar activado !!","ui.app.safeModeDescription":"Algumas características do Gestor de Contacto não estão disponíveis.","ui.app.safeModeExit":"Sair do modo seguro","ui.app.loading":"A iniciar o Contao Manager ...","ui.app.apiError":"API status não esperado -erro","ui.app.configSecurity1":"ALERTA DE SEGURANÇA!!! Directório de configuração sem protecção detectado","ui.app.configSecurity2":"O Contao Manager detetou que os seus ficheiros de configuração estão acessíveis publicamente. Todas as operações estão desativadas até que o directório esteja seguro, caso contrário um atacante poderá aceder a informações sensíveis sobre a sua instalação.\\n\\nPara corrigir esta situação, certifique-se que previne o acesso ao directório \\"contao-manager\\" no seu servidor. Para saber como o fazer, consulte o manual do seu webserver ou contacte o fornecedor de alojamento web.","ui.account.welcome":"Bem Vindo","ui.account.intro1":"Bem-vindo ao Contao Manager, uma ferramenta universal para instalar e gerir o Contao Open Source CMS. Se é novo nele, por favor {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} para começar","ui.account.introManual":"ler o manual","ui.account.intro2":"Se encontrar algum problema, verifique {ourGithubIssues} e sinta-se à vontade para criar um novo para qualquer coisa que ainda não tenha sido relatada.","ui.account.introIssues":"as nossas edições GitHub","ui.account.headline":"Utilizador","ui.account.description":"Para gerir a sua instalação, por favor crie uma conta para utilizar no Contao Manager. Certifique-se que é distinta da conta utilizada no Contao back e front end.","ui.account.username":"Utilizador","ui.account.password":"Senha","ui.account.passwordPlaceholder":"min. 8 caracteres","ui.account.passwordLength":"Por favor utilize o minimo de 8 caracteres.","ui.account.submit":"Criar Conta","ui.account.contribute1":"O Contao e o Contao Manager são patrocinados pela Associação Contao sem fins lucrativos.","ui.account.contribute2":"Por favor, considere contribuir para o código aberto por {donate}.","ui.account.contributeDonate":"fazer um donativo","ui.login.headline":"Iniciar sessão","ui.login.description":"Iniciar sessão para gerir a sua instalação.","ui.login.username":"Utilizador","ui.login.password":"Senha","ui.login.forgotPassword":"Esqueceu a sua senha?","ui.login.button":"Iniciar sessão","ui.login.locked":"O acesso foi negado porque o Gestor de Contacto está bloqueado. Para desbloquear, apagar o ficheiro {lockFile} no directório raiz do seu Contao.","ui.logout.headline":"Tempo de Sessão expirado.","ui.logout.warning":"Esteve inactivo por mais de 25 minutos. Por razões de segurança a sua sessão será terminada em breve.","ui.logout.expired":"A sua sessão foi terminada automaticamente porque esteve inactivo por mais de 30 minutos.","ui.logout.renew":"Manter sessão ativa","ui.logout.logout":"Terminar Sessão","ui.logout.login":"Voltar para inicio de sessão","ui.oauth.error":"Tentativa OAuth inválida. Verifique os parâmetros pedidos.","ui.oauth.https":"O redireccionamento do URI DEVE utilizar um protocolo seguro (https:) para evitar que o símbolo de autenticação seja transmitido em texto claro.","ui.oauth.headline":"Autenticação remota","ui.oauth.description":"A seguinte aplicação ou serviço está a solicitar acesso remoto ao Contao Manager.","ui.oauth.domain":"Antes de permitir o acesso, certifique-se de que conhece este URL e confie no seu proprietário!","ui.oauth.allow":"Permitir Acesso","ui.oauth.deny":"Negar Acesso","ui.boot.headline":"Verificar Sistema","ui.boot.description":"Por favor espere, estamos a analisar o seu servidor...","ui.boot.issue1":"Problemas com a instalação detectados","ui.boot.issue2":"A sua instalação tem problemas que têm de ser resolvidos antes que o Gestor de Contacto possa ser utilizado.","ui.boot.run":"Iniciar o Contao Manager","ui.boot.safeMode":"Executar em Modo de Segurança","ui.recovery.headline":"Recuperação de Sistema","ui.recovery.description":"O Contao Manager detectou ficheiros que podem pertencer ao Contao, mas a linha de comandos não funciona como previsto.","ui.recovery.console":"Saída da Consola","ui.recovery.repairOptions":"Por favor escolha uma opção para reparar a sua instalação.","ui.recovery.repairHeadline":"Reparação Automática","ui.recovery.repairDescription":"Efectua uma tentativa de reparar automaticamente a instalação ao reconstruir a cache da aplicação e reinstalando os pacotes Composer.","ui.recovery.repairWarning":"Quaisquer modificações aos ficheiros vendor poderão ser apagadas durante o processo!","ui.recovery.repairFailed":"A reparação automática não teve sucesso. Usar o modo de segurança para reparar manualmente a instalação poderá resolver o problema.","ui.recovery.repairButton":"Executar Reparação de Sistema","ui.recovery.safeModeHeadline":"Modo de Segurança ","ui.recovery.safeModeDescription":"Executar o Contao Manager em Modo de Segurança permite gerir pacotes e correr tarefas de manutenção específicas, mas implementações que dependam de uma instalação Contao funcional não estarão disponíveis.","ui.recovery.safeModeButton":"Executar em Modo de Segurança","ui.server.pending":"Aguarde ...","ui.server.running":"A analisar ...","ui.server.error":"A verificação falhou devido a uma resposta inesperada do servidor.","ui.server.details":"Detalhes","ui.server.prerequisite":"A verificação falhou devido a um pré-requisito em falta.","ui.server.selfUpdate.title":"Actualizações Contao Manager","ui.server.selfUpdate.update":"Uma nova versão do Contao Manager {latest} está disponivel.","ui.server.selfUpdate.manualUpdate":"Está disponível uma nova versão do Contao Manager {latest}. O seu servidor não suporta actualizações automáticas, por favor descarregue a nova versão a partir de {download}.","ui.server.selfUpdate.latest":"Está a usar a versão mais recente {current}.","ui.server.selfUpdate.dev":"Versões de testes não suportam actualizações automáticas.","ui.server.selfUpdate.unsupported":"Uma nova versão está disponível mas não é  compatível com a sua versão de PHP.","ui.server.selfUpdate.button":"Executar Auto-Update","ui.server.selfUpdate.continue":"Continuar","ui.server.config.title":"Configuração do Servidor","ui.server.config.setup":"Configurar","ui.server.config.change":"Alterar","ui.server.config.save":"Guardar","ui.server.config.cancel":"Cancelar","ui.server.config.customOption":"Outros ...","ui.server.config.description":"Para executar correctamente as tarefas de fundo, o Gestor de Contacto precisa de saber onde encontrar o binário de linha de comando PHP e como executar comandos separados do processo web.","ui.server.config.formTitle":"Configuração do Servidor","ui.server.config.formText":"Por favor introduza o caminho para o seu binário PHP. Certifique-se que o seu binário usa a mesma versao PHP que o seu processo web.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"A Composer Resolver Cloud permite instalar dependências Composer mesmo se o seu servidor não possuir memória local suficiente. Tenha em consideração que a sua informação de pacotes será transmitida para um servidor em nuvem mantido pela Contao Association.","ui.server.config.cloud":"Usar a Composer Resolver Cloud","ui.server.config.cli":"Binário PHP","ui.server.config.stateErrorCli":"Nenhum binário PHP válido foi encontrado no servidor. ","ui.server.config.stateErrorCloud":"A Composer Resolver Cloud não é suportada.","ui.server.config.stateSuccess":"Binário PHP em {php_cli}.","ui.server.php_web.title":"Processo Web PHP","ui.server.php_web.below7":"Encontrada a versão {version} PHP. Actualize para a versão PHP 7 assim que possivel!","ui.server.php_web.success":"Encontrada a versão PHP {version}, nenhum problema a reportar.","ui.server.php_cli.title":"Interface PHP Linha de Comandos","ui.server.php_cli.success":"Encontrada a versão PHP {version}, nenhum problema a reportar.","ui.server.composer.title":"Ambiente Composer","ui.server.composer.success":"Nenhum problema encontrado.","ui.server.composer.install":"Dependências Composer não instaladas.","ui.server.composer.button":"Instalar","ui.server.contao.title":"Instalação Contao","ui.server.contao.setup":"Configuração","ui.server.contao.check":"Check database","ui.server.contao.empty":"Nenhuma instalação Contao foi encontrada.","ui.server.contao.old":"A versão {version} do Contao não é compatível com o Contao Manager,  actualize a sua instalação manualmente.","ui.server.contao.found":"Encontrado Contao com versão {version} (Versão API {api}).","ui.server.contao.connectionError":"Incapaz de se ligar ao servidor da base de dados.","ui.server.contao.connectionProblem":"Database problem found.","ui.server.contao.missingUser":"Conta administrativa não encontrada.","ui.setup.continue":"Continuar","ui.setup.manager":"Iniciar o Contao Manager","ui.setup.cancel":"Cancelar","ui.setup.welcome":"Bem Vindo","ui.setup.welcome1":"Este assistente irá levá-lo através dos passos necessários para configurar a sua instalação do CMS Contao Open Source.","ui.setup.welcome2":"If you have any questions, please find documentation, forums, a Slack channel and more on the {support} page.","ui.setup.support":"Apoio à Comunidade","ui.setup.start":"ComeceComece","ui.setup.complete":"Parabéns!","ui.setup.complete1":"Contao {version} has been installed successfully.","ui.setup.complete2":"To finish the setup process, please open the install tool to configure the database connection and create a back end user.","ui.setup.complete3":"You can now start to create your website in the Contao back end. If you need additional extensions, continue to the Contao Manager.","ui.setup.installTool":"Open the Install Tool","ui.setup.login":"Login to Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". An Open Source project like Contao requires amounts of money that can\'t be raised by a single person or company.\\nIf you have a website or sell websites built with Contao, we would love to see you contribute back financially to the product your business relies upon.","ui.setup.fundingLink":"Learn more","ui.setup.document-root.headline":"Configuração do Webserver","ui.setup.document-root.warning":"Para instalar o Contao através do Contao Manager, é necessário fixar a raiz do documento no servidor web.","ui.setup.document-root.description1":"Contao uses a separate folder for public files, application files are installed in its parent folder. Contao cannot be installed if the folder structure is not correct or the folders are not empty.","ui.setup.document-root.description2":"Se não souber como configurar a raiz do seu documento, leia a documentação do Contacto ou contacte o seu fornecedor de alojamento.","ui.setup.document-root.documentation":"Ler a Documentação","ui.setup.document-root.conflictsTitle":"Directório de instalação não vazio","ui.setup.document-root.conflictsDirectory":"The root directory of your future Contao installation is not empty, we have found {count} file(s) that might be overwritten by the installation process. It is recommended to create an empty directory structure for Contao, but you can also remove the following files and check again if you are sure they are unused.","ui.setup.document-root.ignoreConflicts":"Quero instalar o Contao no directório dos não vazios. Compreendo que isto pode substituir quaisquer ficheiros existentes no meu espaço web.","ui.setup.document-root.check":"Check again","ui.setup.document-root.create":"Criar directórios","ui.setup.document-root.change":"Change directories","ui.setup.document-root.formTitle":"Configuração de directório","ui.setup.document-root.formText1":"O Contao Manager pode criar automaticamente uma nova estrutura de directório no servidor.","ui.setup.document-root.formText2":"Será necessário configurar manualmente a raiz do novo documento (por exemplo, através de um painel de administração de alojamento).","ui.setup.document-root.autoconfig":"Compreendo que tenho de alterar a configuração do meu servidor. Não configurar a raiz do documento irá quebrar o Contao Manager e expor os ficheiros de configuração (incluindo detalhes de conta e palavras-passe)!","ui.setup.document-root.directory":"Novo Directório","ui.setup.document-root.currentRoot":"Raiz do documento actual","ui.setup.document-root.newRoot":"Novo Documento Raiz","ui.setup.document-root.finish":"Directórios de configuração","ui.setup.document-root.publicDir":"Utilizar {dir} para ficheiros públicos (para Contao {version})","ui.setup.document-root.directoryInvalid":"Por favor, introduza um nome de directório válido.","ui.setup.document-root.directoryExists":"O directório alvo já existe. Por favor, introduza um nome diferente.","ui.setup.document-root.confirmation":"O Contao Manager criou com sucesso o directório necessário para a sua instalação de Contao. Tem agora de configurar a raiz do documento no seu servidor web. Não volte a carregar esta página até lá.","ui.setup.document-root.reload":"Recarregar Página","ui.setup.document-root.success":"The directory structure on your web server is set up correctly!","ui.setup.document-root.installingProjectDir":"Application files will be installed to {dir}.","ui.setup.document-root.installingPublicDir":"Public files will be installed to {dir}.","ui.setup.document-root.installedProjectDir":"Application files are installed in {dir}.","ui.setup.document-root.installedPublicDir":"Public files are installed in {dir}.","ui.setup.create-project.headline":"Instalação Contao","ui.setup.create-project.description":"Contao development follows the principle of {semver}, a new minor version is released every six months. The currently supported releases are:","ui.setup.create-project.semver":"Semantic Versioning","ui.setup.create-project.latestTitle":"Mais Recente","ui.setup.create-project.ltsTitle":"Suporte a Longo Prazo (LTS)","ui.setup.create-project.latestQ1":"Our latest version, offers the most features with support until February {year}.","ui.setup.create-project.latestQ3":"Our latest version, offers the most features with support until August {year}.","ui.setup.create-project.ltsText":"Our current LTS version, if you focus on stability. Offers long term support until February {year}.","ui.setup.create-project.pltsText":"The previous LTS version, still has long term support until February {year}.","ui.setup.create-project.requiresPHP":"Requires at least PHP {version}, you have PHP {current}.","ui.setup.create-project.requiresDocroot":"The document root must be \\"{folder}\\".","ui.setup.create-project.releaseplan":"Ver o {contaoReleasePlan} para informações detalhadas.","ui.setup.create-project.releaseplanLink":"Plano de lançamento do Contao","ui.setup.create-project.installed":"Contao {version} is successfully installed on the server. Continue to set up your database or launch the Contao Manager to install a different version.","ui.setup.create-project.formTitle":"Select a distribution","ui.setup.create-project.formText":"Please choose which version should be installed.","ui.setup.create-project.version":"Versão","ui.setup.create-project.demo":"Install the Contao demo website","ui.setup.create-project.demoDescription":"The demo website helps you to get familiar with Contao and all of its core features. More themes can be found in the {store}.","ui.setup.create-project.coreOnly":"Instalação Mínima ( Apenas o \\"core\\")","ui.setup.create-project.noUpdate":"Ignorar Instalação (Utilizador avançado!)","ui.setup.create-project.theme":"Contao Theme","ui.setup.create-project.themeInstall":"To install a Contao theme, use the search input or upload a theme file (.cto/.zip) that supports installation through the Contao Manager.","ui.setup.create-project.themeBuy":"Make sure to visit the official {store}.","ui.setup.create-project.themeStore":"Contao Themes Store","ui.setup.create-project.themeUpload":"Upload theme file (.cto/.zip)","ui.setup.create-project.themeInvalid":"The uploaded file is not a Contao theme or does not support the Contao Manager.","ui.setup.create-project.themeWarning":"The Contao Manager cannot tell whether this theme is compatible with your server. Please check with the theme vendor if you have any questions.","ui.setup.create-project.themeTitle":"Review theme details","ui.setup.create-project.themeDetails":"The following dependencies and files will be installed with this theme.","ui.setup.create-project.themeRequire":"{count} Dependencies | {count} Dependencies","ui.setup.create-project.themeFiles":"{count} File | {count} Files","ui.setup.create-project.theme.or":"or search public themes","ui.setup.create-project.theme.search":"Search themes","ui.setup.create-project.theme.more":"More themes","ui.setup.create-project.theme.empty":"No themes matching {query}","ui.setup.create-project.theme.uploaded":"The theme file was uploaded successfully.","ui.setup.create-project.theme.packageName":"Package name","ui.setup.create-project.theme.version":"Versão","ui.setup.create-project.theme.authors":"Author(s)","ui.setup.create-project.install":"Instalar","ui.setup.create-project.cancel":"Cancelar","ui.setup.database-connection.headline":"Database Connection","ui.setup.database-connection.description":"Contao requires a MySQL database (or a compatible fork like MariaDB) to store pages, content, users and other relational data. Connection parameters are stored in the {env} file in the project root of your Contao installation.","ui.setup.database-connection.formTitle":"Connection Parameters","ui.setup.database-connection.formText":"Enter a database URL or fill in the username, password, server and database fields separately.","ui.setup.database-connection.url":"Database URL","ui.setup.database-connection.validUrl":"Database URL is invalid or connection to server failed.","ui.setup.database-connection.or":"or","ui.setup.database-connection.user":"Utilizador","ui.setup.database-connection.password":"Senha","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Database Name","ui.setup.database-connection.connected":"Successfully connected to database {database} on {server}.","ui.setup.database-connection.error":"Error connecting to the database.","ui.setup.database-connection.problem":"Contao has detected a problem with your database server.","ui.setup.database-connection.schemaTitle":"Database Schema","ui.setup.database-connection.migration":"There is one pending migration. | There are {count} pending migrations.","ui.setup.database-connection.schema":"There is one pending schema update. | There are {count} pending schema updates.","ui.setup.database-connection.noChanges":"Your database schema is up to date.","ui.setup.database-connection.check":"Check database","ui.setup.database-connection.skip":"Skip","ui.setup.database-connection.save":"Guardar","ui.setup.database-connection.change":"Change credentials","ui.setup.database-connection.restoreTitle":"Database Import","ui.setup.database-connection.restoreText":"The theme you just installed contains a database backup. Restore the database to import theme data or skip this step to start with a blank Contao installation. | The theme you just installed contains multiple database backups. Select a backup file to import theme data or skip this step to start with a blank Contao installation.","ui.setup.database-connection.backup":"Backup current database before import","ui.setup.database-connection.backupWarning":"All data in database will be overwritten on import! Create a backup first if the database is not empty.","ui.setup.database-connection.restore":"Import theme database","ui.setup.database-connection.restoreOption":"Backup from {date} ({size})","ui.setup.database-connection.restored":"Your theme database was successfully imported. Continue to validate your database schema.","ui.setup.backend-user.success":"An admin account for the Contao back end was found in your database. Use the Contao back end to add more users.","ui.setup.backend-user.error":"Unable to retrieve user list. Check the console output for details.","ui.setup.backend-user.headline":"Backend Account","ui.setup.backend-user.description":"To manage your website, you need to have at least one admin account for the Contao back end. Be aware that this account is not related to the Contao Manager.","ui.setup.backend-user.formTitle":"Criar Conta","ui.setup.backend-user.formText":"Please enter the details for the new back end account.","ui.setup.backend-user.username":"Utilizador","ui.setup.backend-user.name":"Name","ui.setup.backend-user.email":"E-mail address","ui.setup.backend-user.emailInvalid":"Please enter a valid e-mail address","ui.setup.backend-user.password":"Senha","ui.setup.backend-user.passwordPlaceholder":"min. 8 caracteres","ui.setup.backend-user.passwordLength":"Por favor utilize o minimo de 8 caracteres.","ui.setup.backend-user.create":"Add account","ui.task.headline":"Tarefa de fundo","ui.task.loading":"Carregamento de detalhes ...","ui.task.created":"Carregamento de detalhes ...","ui.task.active":"Por favor aguarde enquanto o Gestor de Contacto está a executar operações de tarefas em segundo plano.","ui.task.complete":"Todas as operações são concluídas com sucesso. Verifique a saída da consola para mais detalhes.","ui.task.aborting":"Por favor aguarde enquanto as operações de fundo estão a ser canceladas.","ui.task.stopped":"Algumas operações de fundo foram canceladas. Por favor, verifique a saída da consola.","ui.task.error":"Uma operação de fundo parou inesperadamente. Por favor, verifique a saída da consola.","ui.task.failed":"O Gestor de Contao não conseguiu iniciar uma tarefa de fundo!","ui.task.failedDescription1":"Alguma coisa correu mal ao tentar executar operações em segundo plano.","ui.task.failedDescription2":"Se isto acontecer novamente, o seu servidor poderá não ser suportado.","ui.task.reportProblem":"Reportar um Problema","ui.task.sponsor":"Composer Cloud sponsored by {sponsor}","ui.task.buttonAudit":"Actualizar base de dados ","ui.task.buttonClose":"Fechar","ui.task.buttonConfirm":"Confirmar e Fechar","ui.task.buttonCancel":"Cancelar","ui.task.confirmCancel":"Tem a certeza que pretende interromper esta tarefa? Poderá afectar a instalação do Contao negativamente!","ui.task.autoclose":"Detalhes sobre o sucesso da tarefa","ui.console.toggle":"Mostrar/Esconder saída de Consola","ui.console.showLog":"Mostrar registo completo da consola","ui.console.copyLog":"Copiar log para prancheta","ui.migrate.headline":"Database Updates","ui.migrate.migrationsOnly":"(migrations only)","ui.migrate.schemaOnly":"(schema only)","ui.migrate.loading":"Please wait, we are checking your database …","ui.migrate.empty":"No pending migrations or schema updates found. Your database is up to date.","ui.migrate.emptyMigrations":"No pending migrations found. Make sure to also check for schema updates.","ui.migrate.emptySchema":"No pending schema updates found. Make sure to also check for migrations.","ui.migrate.pending":"Your database is not up to date. Please review the console output below and execute the changes.","ui.migrate.previousChanges":"A previous database migration was not confirmed.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.previousComplete":"A previous database migration was not confirmed, please review the console output below.\\nThere are no more pending changes.","ui.migrate.appliedChanges":"Database updates have been applied.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.appliedComplete":"Database updates have been applied.\\nThere are no more pending migrations or schema updates. Your database is up to date.","ui.migrate.problem":"Contao has detected a problem with your database server.\\nPlease review the console output below to find out what needs to be fixed. | Contao has detected problems with your database server.\\nPlease review the console output below to find out what needs to be fixed.","ui.migrate.warning":"Contao has detected a misconfiguration of your database server.\\nWarnings can be skipped temporarily, but should be fixed for optimal performance and data integrity.","ui.migrate.error":"The changes could not be applied. Your database might have been changed, please check again to retry.","ui.migrate.execute":"Execute","ui.migrate.close":"Fechar","ui.migrate.confirm":"Confirmar e Fechar","ui.migrate.cancel":"Cancelar","ui.migrate.continue":"Continuar","ui.migrate.setup":"Configuração","ui.migrate.skip":"Skip","ui.migrate.retry":"Check again","ui.migrate.retryAll":"Check all","ui.migrate.withDeletes":"Execute all database changes including DROP queries.","ui.migrate.migrationTitle":"Database Migrations","ui.migrate.schemaTitle":"Schema Updates","ui.migrate.problemTitle":"Database Problems","ui.migrate.warningTitle":"Database Warnings","ui.migrate.addTable":"Add table {table}","ui.migrate.dropTable":"Drop table {table}","ui.migrate.addField":"Add field {table}.{field}","ui.migrate.changeField":"Change field {table}.{field}","ui.migrate.dropField":"Drop field {table}.{field}","ui.migrate.createIndex":"Create index \\"{name}\\" on {table}","ui.migrate.dropIndex":"Drop index \\"{name}\\" on {table}","ui.widget.mandatory":"Este campo não pode estar vazio.","ui.widget.blankOption":"Por favor seleccione ...","ui.widget.showPassword":"Show password","ui.widget.hidePassword":"Hide password","ui.error.title":"O pedido HTTP de \\"{method} {url}\\" falhou.","ui.error.server500":"Parece que ocorreu um erro inesperado no seu servidor. Por favor verifique os ficheiros de registo do seu servidor web (Apache/Nginx) e os registos do Contao Manager em \\"Contao-manager/logs\\".","ui.error.response":"O servidor devolveu uma resposta com o código de estado {status}.","ui.error.moreLink":"Mais informação ","ui.error.support":"Contao Support","ui.footer.help":"Ajuda","ui.footer.reportProblem":"Reportar um Problema","ui.navigation.discover":"Descubra","ui.navigation.packages":"Pacotes","ui.navigation.tools":"Ferramentas","ui.navigation.installTool":"Ferramenta de Instalação","ui.navigation.backend":"Backend Contao","ui.navigation.debug":"Depuração Contao","ui.navigation.logViewer":"Log Viewer","ui.navigation.phpinfo":"Informação PHP","ui.navigation.phpinfoLoading":"Carregamento de informação PHP","ui.navigation.maintenance":"Manutenção","ui.navigation.rebuildCache":"Reconstruir Cache","ui.navigation.systemCheck":"Verificar Sistema","ui.navigation.advanced":"Avançado","ui.navigation.logout":"Terminar Sessão","ui.maintenance.database.title":"Database Migrations and Backups","ui.maintenance.database.description":"Database migrations ensure consistent data and table schemas.","ui.maintenance.database.migrations":"One pending database migration | {count} pending database migrations","ui.maintenance.database.schemaUpdates":"One pending schema update | {count} pending schema updates","ui.maintenance.database.error":"Database problem found.","ui.maintenance.database.warning":"Database warnings found.","ui.maintenance.database.button":"Check database","ui.maintenance.database.migrationOnly":"Check migrations only","ui.maintenance.database.schemaOnly":"Check schema only","ui.maintenance.database.installTool":"Open Install Tool","ui.maintenance.database.createBackup":"Create Backup","ui.maintenance.database.backupUnsupported":"Database backups are not supported by your Contao version.","ui.maintenance.database.backupList":"You have one database backup, created on {date}. | You have {count} database backups, the latest one was created on {date}.","ui.maintenance.database.backupEmpty":"You currently have no database backups.","ui.maintenance.rebuildCache.title":"Cache de Aplicação","ui.maintenance.rebuildCache.description":"Reconstruir a cache da aplicação é necessário após modificar quaisquer dos ficheiros de configuração.","ui.maintenance.rebuildCache.rebuildProd":"Reconstruir Cache de Produção","ui.maintenance.rebuildCache.rebuildDev":"Reconstruir Cache Desenvolvimento","ui.maintenance.rebuildCache.clearProd":"Limpar Cache Produção","ui.maintenance.rebuildCache.clearDev":"Limpar Cache Desenvolvimento","ui.maintenance.installTool.title":"Ferramenta de Instalação do Contao","ui.maintenance.installTool.description":"A Ferramenta de Instalação do Contao bloqueia automaticamente caso a senha seja introduzida erradamente três vezes.","ui.maintenance.installTool.unlock":"Desbloquear ferramenta de instalação","ui.maintenance.installTool.lock":"Bloquear ferramenta de instalação","ui.maintenance.dumpAutoload.title":"Carregador de Classes Composer","ui.maintenance.dumpAutoload.description":"O Composer autoloader é responsável por carregar classes PHP. O autoloader tem que ser \\"dumped\\" após adicionar namespaces personalizados ao root compser.json .","ui.maintenance.dumpAutoload.button":"Dump Autoloader","ui.maintenance.composerInstall.title":"Dependências Composer ","ui.maintenance.composerInstall.description":"As dependências dos Composer estão localizadas na pasta {vendor} na raiz da sua aplicação. A reinstalação das dependências pode ser necessária após manipulação ou carregamento manual do ficheiro {composerLock}.","ui.maintenance.composerInstall.button":"Executar Instalador","ui.maintenance.composerInstall.update":"Executar Actualizador Composer","ui.maintenance.composerCache.title":"Cache Composer","ui.maintenance.composerCache.description":"O Composer guarda cache de pacotes provenientes de download para melhor performance. Caso tenha problemas com ficheiros não funcionais, apagar a Composer cache para forçar um novo download poderá resolver o problema.","ui.maintenance.composerCache.button":"Apagar Cache","ui.maintenance.maintenanceMode.title":"Modo Manutenção","ui.maintenance.maintenanceMode.description":"Colocar o Contao em modo de manutenção exibirá um modelo \\"503 Serviço Indisponível\\" para o website.","ui.maintenance.maintenanceMode.enable":"Activar","ui.maintenance.maintenanceMode.disable":"Desactivar","ui.maintenance.debugMode.title":"Modo Depuração","ui.maintenance.debugMode.description":"Activar o modo de depuração definindo um utilizador e uma palavra-passe para o ponto de entrada {appDevPhp}.","ui.maintenance.debugMode.descriptionJwt":"Active o modo de depuração ao definir o cookie de depuração para o domínio corrente.","ui.maintenance.debugMode.activate":"Activar","ui.maintenance.debugMode.deactivate":"Desactivar","ui.maintenance.debugMode.credentials":"Credenciais","ui.maintenance.debugMode.user":"Por favor introduza um nome de utilizador para o modo de depuração.","ui.maintenance.debugMode.password":"Por favor introduza uma senha para o modo de depuração.","ui.maintenance.opcodeCache.title":"Cache Opcode","ui.maintenance.opcodeCache.description":"O Opcode efectua cache de ficheiros PHP no processo web para mais rápida execução. Deverá ser apagado dentro de certas  circunstâncias caso ficheiros não sejam reconhecidos após edição.","ui.maintenance.opcodeCache.button":"Truncar Cache","ui.maintenance.safeMode":"Nao disponível em Modo Segurança","ui.maintenance.unsupported":"Não suportado pela sua versão Contao","ui.packages.updateButton":"Actualizar Pacotes","ui.packages.searchButton":"Procurar Pacotes","ui.packages.searchPlaceholder":"Procurar Pacotes ...","ui.packages.uploadOverlay":"Arrastar e largar ficheiros para upload","ui.packages.uploadButton":"Carregar Packages","ui.packages.uploadMessage":"Tem um carregamento não confirmado. | Tem {count} uploads não confirmados.","ui.packages.uploadApply":"Confirmar Uploads","ui.packages.uploadReset":"Apagar Uploads","ui.packages.uploadIncomplete":"Este ficheiro não foi uploaded completamente. Por favor remova-o e tente novamente.","ui.packages.uploadDuplicate":"Este ficheiro aparenta ter sido uploaded  várias vezes. Por favor remova os duplicados.","ui.packages.uploadInstalled":"Este ficheiro já se encontra instalado. Por favor remova os duplicados.","ui.packages.uploadUnsupported":"Uploads are not supported in your installation. Please make sure that the PHP ZIP extension is installed and update your dependencies.","ui.packages.changesMessage":"Tem uma alteração não confirmada. | Tem {count} alterações não confirmadas.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"Aplicar Alterações","ui.packages.changesApplyAll":"Actualizar todos os pacotes","ui.packages.changesDryrunAll":"Funcionamento a seco todos os pacotes","ui.packages.changesReset":"Reverter Alterações","ui.packages.changesReview":"Rever Alterações","ui.packagelist.loading":"A Carregar ...","ui.packagelist.uploads":"Uploads","ui.packagelist.added":"Novos pacotes","ui.packagelist.installed":"Pacotes instalados","ui.package.hintRevert":"Reverter Alterações","ui.package.hintNoupdate":"Não actualizar","ui.package.hintConstraint":" Este pacote será instalado com limitações de entrada {constraint} quando aplicar alterações.","ui.package.hintConstraintBest":"Este pacote será instalado com a melhor versão disponível quando aplicar alterações.","ui.package.hintConstraintChange":"As limitações de entrada para este pacote serão alteradas de \\"{from}\\" para \\"{to}\\" quando  aplicar alterações.","ui.package.hintConstraintUpdate":"Este pacote será actualizado quando aplicar alterações. ","ui.package.hintAdded":"Este pacote vai ser instalado quando aplicar as alterações.","ui.package.hintRemoved":"Este pacote será removido quando aplicar alterações.","ui.package.requiredTitle":"manualmente adicionado","ui.package.requiredText":"Este pacote é requerido pelo seu composer.json mas não está instalado.","ui.package.removedTitle":"manualmente removido","ui.package.removedText":"Este pacote vai ser removido do seu composer.json.","ui.package.installed":"Actualmente instalado:","ui.package.version":"Versão {version}","ui.package.additionalDownloads":"{count} Descarregar | {count} Descarregar","ui.package.additionalStars":"{count} Estrela | {count} Estrelas","ui.package.editConstraint":"Editar","ui.package.uploadConstraint":"Esta restrição está definida pelo pacote que foi uploaded.","ui.package.updateButton":"Actualizar","ui.package.removeButton":"Remover","ui.package.installButton":"Adicionar Pacote","ui.package.installButtonShort":"Adicionar","ui.package.detailsButton":"Detalhes","ui.package.latestConstraint":"versão mais recente","ui.package.update":"Actualização disponível","ui.package.updateLatest":"versão mais recente","ui.package.updateAvailable":"{version} disponível","ui.package.updateUnknown":"versão desconhecida","ui.package.updateConstraint":"A newer version outside your version constraint is available.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Versão {version}","ui.cloudStatus.waitingTime":"Tempo de Espera","ui.cloudStatus.jobs":"Tarefas Actuais","ui.cloudStatus.workers":"Trabalhadores","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"nenhum","ui.cloudStatus.short":"ca. {minutes} min","ui.cloudStatus.long":"ca. {minutes} min {seconds} seg","ui.cloudStatus.error":"Incapaz de obter o estatuto de Composer Resolver Cloud. Pode ser para questões de manutenção ou de experiência.","ui.cloudStatus.button":"Estado das nuvens","ui.cloudStatus.refresh":"Actualizar o estado das nuvens","ui.log-viewer.loading":"A Carregar ...","ui.log-viewer.empty":"There are no log files on your server.","ui.log-viewer.reload":"Reload","ui.log-viewer.file":"Log file","ui.log-viewer.channel":"Channel","ui.log-viewer.channelTitle":"The channel this message was logged to.","ui.log-viewer.level":"Level","ui.log-viewer.levelTitle":"Severity of the log message.","ui.log-viewer.timeHeader":"Time","ui.log-viewer.messageHeader":"Message","ui.log-viewer.showContext":"Show Context","ui.log-viewer.hideContext":"Hide Context","ui.log-viewer.showExtra":"Show Extra","ui.log-viewer.hideExtra":"Hide Extra","ui.log-viewer.more":"Load more …","ui.log-viewer.download":"Download","ui.log-viewer.downloadTitle":"Download file \\"{file}\\"","ui.log-viewer.prodEnvironment":"Production Environment","ui.log-viewer.devEnvironment":"Development Environment (Debug Mode)"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[540],{4540:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!!  Nezabezpečené připojení !!","ui.app.httpsDescription":"Bez HTTPS budou citlivá data přenášena nezabezpečeně.","ui.app.httpsLink":"Více informací","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Je zapnutý bezpečnostní režim !!","ui.app.safeModeDescription":"Některé funkce nejsou k dispozici ve Správci Contaa.","ui.app.safeModeExit":"Ukončit bezpečnostní režim","ui.app.loading":"Nahrávání Správce Contaa","ui.app.apiError":"Nečekaný status API","ui.app.configSecurity1":"BEZPEČNOSTNÍ UPOZORNĚNÍ!!! Byla objevená nechráněná konfigurační složka ","ui.app.configSecurity2":"Správce Contaa zjistil, že jsou veřejně dostupné jeho konfigurační soubory. Všechny operace byly pozastavené, dokud nebude daná složka chráněná, jinak může dojít k útoku na choulostivá data Vaší instalace.\\n\\nPro opravení této potíže zajistěte omezený přístup ke složce \\"contao-manager\\" na Vašem serveru. Jak to lze provést, se dozvíte od Vašeho hostingového poskytovatele nebo v příručce ke správě serveru.","ui.account.welcome":"Vítejte","ui.account.intro1":"Vítejte ve Správci Contaa, univerzálním nástroji k instalaci a správě Contaa Open Source CMS. Pokud jste tu poprvé, přečtěte si prosím návod {readTheManualToGetStarted}.","ui.account.introGetStarted":"Začínáme {readTheManual}.","ui.account.introManual":"přečíst návod","ui.account.intro2":"Pokud si všimnete jakýchkoli nesrovnalostí, podívejte se na seznam nahlášených chyb  {ourGithubIssues}  a případně nahlaste novou, kterou ještě nikdo nenahlásil. ","ui.account.introIssues":"Chyby na GitHubu","ui.account.headline":"Uživatelský účet","ui.account.description":"Abyste mohli spravovat instalaci, vytvořte prosím uživatelský účet. Uvědomte si prosím, že tento účet není stejný pro přihlášení do Contaa. ","ui.account.username":"Uživatelské jméno","ui.account.password":"Heslo","ui.account.passwordPlaceholder":"min. 8 znaků","ui.account.passwordLength":"Zadejte prosím nejméně 8 znaků.","ui.account.submit":"Vytvořit účet","ui.account.contribute1":"Contao a Správce Contaa je podporovaný neziskovou Contao Association.","ui.account.contribute2":"Prosím zvažte, zda se chcete stát členem a spolupracovníkem tohoto open source projektu {becomingAMember}.","ui.account.contributeDonate":"Staňte se dárcem","ui.login.headline":"Přihlásit se","ui.login.description":"Přihlaste se, abyste mohli spravovat Vaši instalaci.","ui.login.username":"Uživatelské jméno","ui.login.password":"Heslo","ui.login.forgotPassword":"Zapomněli jste heslo?","ui.login.button":"Přihlásit se","ui.login.locked":"Přístup byl zamítnut, protože je Správce Contaa uzamčen. Pro odemknutí smažte soubor {lockFile} na Vašem serveru v kořenové složce Contaa.","ui.logout.headline":"Vypršení sezení","ui.logout.warning":"Byli jste neaktivní po dobu 25 minut. Z bezpečnostních důvodů bude Vaše sezení zakrátko ukončené. ","ui.logout.expired":"Vaše sezení bylo automaticky ukončeno, protože jste byli neaktivní více než 30 minut.","ui.logout.renew":"Zůstat přihlášený/á","ui.logout.logout":"Odhlásit","ui.logout.login":"Zpátky k přihlášení","ui.oauth.error":"Neplatný pokus o ověření totožnosti. Zkontrolujte požadované parametry.","ui.oauth.https":"Přeposílací URL musí používat zabezpečený protokol (https), aby nedošlo k přenosu autorizačního kódu v čirém textu.","ui.oauth.headline":"Smazat autorizaci","ui.oauth.description":"Následující aplikace nebo servis požadují vzdálený přístup k Vašemu Správci Contaa. ","ui.oauth.domain":"Ještě než povolíte přístup, ujistěte se, že znáte tuto URL a důvěřujete jejímu majiteli!","ui.oauth.allow":"Povolit přístup","ui.oauth.deny":"Odmítnout přístup","ui.boot.headline":"Kontrola systému","ui.boot.description":"Prosím počkejte, analyzujeme Váš server...","ui.boot.issue1":"Byly zjištěny chyby","ui.boot.issue2":"Vaše instalace obsahuje několik chyb a je ji třeba opravit, než se bude moct použít Správce Contaa.","ui.boot.run":"Spustit Správce Contaa","ui.boot.safeMode":"Spustit v Bezpečnostním módu","ui.recovery.headline":"Záchrana systému","ui.recovery.description":"Správce Contaa našel soubory, které vypadají jako soubory Contaa, ale Příkazový řádek nepracuje tak, jak by měl.","ui.recovery.console":"Výstup konzoly","ui.recovery.repairOptions":"Vyberte prosím jednu z možností pro zotavení Vaší instalace.","ui.recovery.repairHeadline":"Automatická oprava","ui.recovery.repairDescription":"Bude provedené automatické opravení instalace tím, že se přestaví meziúložiště a přeinstalují se balíčky závislé na Composeru.","ui.recovery.repairWarning":"Veškeré úpravy provedené na souborech ve složce vendor budou ztraceny!","ui.recovery.repairFailed":"Automatická oprava neproběhla úspěšně. Pro opravení instalace se pokuste se použít Bezpečnostní mód.","ui.recovery.repairButton":"Spustit opravu systému","ui.recovery.safeModeHeadline":"Bezpečnostní mód","ui.recovery.safeModeDescription":"Spuštěním Správce Contaa v Bezpečném módu lze spravovat balíčky a spouštět základní příkazy/úlohy, nejsou ovšem dostupné funkce závislé na instalaci Contaa.","ui.recovery.safeModeButton":"Spustit v Bezpečnostním módu","ui.server.pending":"Čekám…","ui.server.running":"Analyzování…","ui.server.error":"Kontrola selhala kvůli neočekávané odezvě ze strany serveru.","ui.server.details":"Podrobnosti","ui.server.prerequisite":"Kontrola zrušena kvůli chybějící podmínce.","ui.server.selfUpdate.title":"Aktualizace Správce Contaa","ui.server.selfUpdate.update":"Je k dispozici nová verze Správce Contaa {latest}.","ui.server.selfUpdate.manualUpdate":"Je dostupná nová verze Správce Contaa {latest}. Váš server nepodporuje automatické instalace. Stáhněte si proto prosím novou verzi {download}.","ui.server.selfUpdate.latest":"Používáte poslední verzi {current}.","ui.server.selfUpdate.dev":"Vývojové verze nepodporují automatické aktualizace.","ui.server.selfUpdate.unsupported":"Je dostupná novější verze, ale ta nepodporuje Vaši verzi PHP.","ui.server.selfUpdate.button":"Spustit automatické aktualizace","ui.server.selfUpdate.continue":"Pokračovat","ui.server.config.title":"Nastavení serveru","ui.server.config.setup":"Nastavit","ui.server.config.change":"Změnit","ui.server.config.save":"Uložit","ui.server.config.cancel":"Zrušit","ui.server.config.customOption":"Jíné…","ui.server.config.description":"Pro správný běh úloh na pozadí potřebuje Správce Contaa vědět, kde může najít binární příkazový řádek PHP a jak spouštět příkazy odděleně od webové stránky. ","ui.server.config.formTitle":"Nastavení serveru","ui.server.config.formText":"Zadejte prosím cestu k binární PHP. Ujistěte se, že je binární soubor stejný jako Vámi používaná verze PHP. ","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud umožňuje nainstalovat na Composeru závislých rozšířeních, i když Váš server nemá dostatek paměti. Mějte na paměti, že informaci o Vaši balíčcích budou odeslané na cloudový server vlastněný Asociací Contaa.","ui.server.config.cloud":"Použít Composer Resolver Cloud","ui.server.config.cli":"Binární PHP","ui.server.config.stateErrorCli":"Na Vašem serveru nebyla nalezena žádná platná binární PHP.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud není podporován.","ui.server.config.stateSuccess":"Binární PHP na {php_cli}.","ui.server.php_web.title":"Webový proces PHP","ui.server.php_web.below7":"Byla nalezena následující verze PHP {version}. Prosím přejděte co nejdříve na PHP 7. ","ui.server.php_web.success":"Byla nalezena následující verze PHP {version}, nejsou známé žádné chyby.","ui.server.php_cli.title":"Rozhraní příkazového řádku PHP","ui.server.php_cli.success":"Byla nalezena následující verze PHP {version}, nejsou známé žádné chyby.","ui.server.composer.title":"Prostředí Composeru","ui.server.composer.success":"Nebyly nalezeny žádné chyby.","ui.server.composer.install":"Věci závislé na Composorovi nejsou nainstalované.","ui.server.composer.button":"Nainstalovat","ui.server.contao.title":"Instalace Contaa","ui.server.contao.setup":"Nastavení","ui.server.contao.check":"Zkontrolovat databázi","ui.server.contao.empty":"Nebyla nalezena žádná instalace Contaa.","ui.server.contao.old":"Verze Contaa {version} není kompatabilní se Správcem Contaa. Zaktualizujte prosím Vaši instalaci manuálně.","ui.server.contao.found":"Nalezeno Contao {version} (verze API {api})","ui.server.contao.connectionError":"Nepodařilo se připojit k serveru databáze.","ui.server.contao.connectionProblem":"Nalezen problém s databází.","ui.server.contao.missingUser":"Nebyl nalezen žádný administrační účet.","ui.setup.continue":"Pokračovat","ui.setup.manager":"Spustit Správce Contaa","ui.setup.cancel":"Zrušit","ui.setup.welcome":"Vítejte","ui.setup.welcome1":"Tento průvodce Vás provede důležitými kroky pro nastavení instalace CMS Contao.","ui.setup.welcome2":"Pokud máte jakýkoli dotaz, prohlédněte si prosím dokumentaci, fóra, kanál Slacku nebo se obraťte na stránku {podpory}.  ","ui.setup.support":"podpora komunity","ui.setup.start":"Začít","ui.setup.complete":"Blahopřejeme!","ui.setup.complete1":"Úspěšně byla nainstalována {version} Contaa.","ui.setup.complete2":"Pro ukončení tohoto procesu otevřete prosím instalační nástroj, abyste nastavili připojení k databázi a vytvořili účet administrátora.","ui.setup.complete3":"Nyní můžete začít vytvářet Vaši webovou stránku v backendu Contaa. Potřebujete-li dodatečná rozšíření, vraťte se do Správce Contaa.","ui.setup.installTool":"Otevřít instalační nástroj","ui.setup.login":"Přihlásit se do Contaa","ui.setup.funding":"Volný software je \\"volný\\" jako \\"volný projev\\", ale ne jako \\"pivo zdarma\\". Open source projekt jako Contaa vyžaduje řadu peněz a nedá se ho uskutečnit bez jediné osoby nebo firmy. \\nPokud máte vytvořenou webovou stránku pomocí Contaa nebo je prodáváte, potěšilo by nás, kdybyste nás finančně podpořili poměrně k Vašemu obchodu.","ui.setup.fundingLink":"Dozvědět se víc","ui.setup.document-root.headline":"Nastavení webového serveru","ui.setup.document-root.warning":"Abyste mohli nainstalovat Contao prostřednictvím Správce Contaa, musíte opravit kořenový dokument na webovém serveru.","ui.setup.document-root.description1":"Contao používá zvláštní složku pro veřejné soubory. Aplikační soubory jsou nainstalované v rodičovské složce. Contao právě nelze nainstalovat, protože Vaše složková struktura není správná nebo složky nejsou prázdné.","ui.setup.document-root.description2":"Pokud nevíte, jak nastavit kořenový dokument, přečtěte si prosím dokumentaci Contaa nebo se obraťte na svého poskytovatele webových služeb.","ui.setup.document-root.documentation":"Přečíst si dokumentaci","ui.setup.document-root.conflictsTitle":"Instalační složka není prázdná","ui.setup.document-root.conflictsDirectory":"Kořenová složka Vaší budoucí instalace Contaa není prázdná. Našli jsem následující počet souborů {count}, které se musí přepsat během instalace. Doporučujeme vytvořit prázdnou složku pro instalaci Contaa, nebo můžete také smazat veškeré věci, které se právě nachází ve vybrané složce, pokud jste si jistí, že je již nepotřebujete. ","ui.setup.document-root.ignoreConflicts":"Chci nainstalova Contao do nevyprázděné složky. Souhlasím s tím, že budou dané soubory přepsány. ","ui.setup.document-root.check":"Znovu zkontrolovat","ui.setup.document-root.create":"Vytvořit složky","ui.setup.document-root.change":"Změnit složky","ui.setup.document-root.formTitle":"Nastavení adresáře","ui.setup.document-root.formText1":"Správce Contaa může automaticky vytvořit novou adresářovou strukturu na tomto webovém serveru.","ui.setup.document-root.formText2":"Budete muset nastavit nový kořenový dokument (např. pomocí správního panelu ve Vašem účtu webových služeb).","ui.setup.document-root.autoconfig":"Rozumím tomu, že musím změnit nastavení serveru. Pokud se tak nestane, může dojít k poruše Správce Contaa a poničení souborů nastavení (včetně podrobností k účtu a heslu)!","ui.setup.document-root.directory":"Nový adresář","ui.setup.document-root.currentRoot":"Současný kořenový dokument","ui.setup.document-root.newRoot":"Nový kořenový dokument","ui.setup.document-root.finish":"Nastavení adresářů","ui.setup.document-root.publicDir":"Použijte {dir} pro veřejné soubory (pro Contao {version})","ui.setup.document-root.directoryInvalid":"Zadejte prosím platný název adresáře","ui.setup.document-root.directoryExists":"Cílový adresář již existuje. Zadejte prosím jiný název.","ui.setup.document-root.confirmation":"Správce Contaa úspěšně vytvořil potřebný adresář pro instalaci Contaa. Nyní musíte nastavit kořenový dokument na svém webovém serveru. Nenačítejte tuto stránku do té doby.","ui.setup.document-root.reload":"Načíst stránku znovu","ui.setup.document-root.success":"Struktura složek je nastavená na Vašem serveru správně!","ui.setup.document-root.installingProjectDir":"Aplikační soubory se nainstalují do {dir}.","ui.setup.document-root.installingPublicDir":"Veřejné soubory se nainstalují do {dir}.","ui.setup.document-root.installedProjectDir":"Aplikační soubory jsou nainstalované v {dir}.","ui.setup.document-root.installedPublicDir":"Veřejné soubory jsou nainstalované v {dir}.","ui.setup.create-project.headline":"Instalace Contaa","ui.setup.create-project.description":"Vývoj Contaa se drží principů {semver}, nová menší verze vychází každých šest měsíců. Současná verze, která se udržuje, je:","ui.setup.create-project.semver":"Sémantické číslování verzí","ui.setup.create-project.latestTitle":"Poslední","ui.setup.create-project.ltsTitle":"Několikaletá podpora - Long Term Support","ui.setup.create-project.latestQ1":"Naše poslední verze nabízí nejnovější funkce s podporou do února {year}.","ui.setup.create-project.latestQ3":"Naše poslední verze nabízí nejnovější funkce s podporou do srpna {year}.","ui.setup.create-project.ltsText":"Naše současná verze LTS, chcete-li se zaměřit na stabilitu. Nabízí dlouhodobou podporu do února {year}.","ui.setup.create-project.pltsText":"Naše předešlá verze LTS má podporu do února {year}.","ui.setup.create-project.requiresPHP":"Vyžaduje přinejmenším PHP {version}, používáte PHP {current}.","ui.setup.create-project.requiresDocroot":"Kořenový dokument musí být \\"{folder}\\".","ui.setup.create-project.releaseplan":"Více informací: {contaoReleasePlan} ","ui.setup.create-project.releaseplanLink":"Plán vydávání nových verzí Contaa","ui.setup.create-project.installed":"Contao {version} je úspěšně nainstalována na vašem serveru. Pokračujte, abyste nastavili vaši databázi nebo spustili Správce Contaa pro nainstalování jiné verze.","ui.setup.create-project.formTitle":"Vyberte distribuci","ui.setup.create-project.formText":"Vyberte prosím verzi, kterou chcete nainstalovat.","ui.setup.create-project.version":"Verze","ui.setup.create-project.demo":"Nainstalovat demoverzi Contaa","ui.setup.create-project.demoDescription":"Demoverze vám pomůže se seznámit s Contaa a pochopit jeho základní fukce. Více předloh můžete najít v {store}.","ui.setup.create-project.coreOnly":"Minimální instalace (pouze jádro)","ui.setup.create-project.noUpdate":"Přeskočit instalaci (pouze pro pokročilé!)","ui.setup.create-project.theme":"Předloha Contaa","ui.setup.create-project.themeInstall":"Abyste nainstalovali předlohu Contaa, použijte vyhledávací políčko nebo načtete soubor (.cto/.zip), který podporuje instalace pomocí Správce Contaa.","ui.setup.create-project.themeBuy":"Podívejte se na další předlohy v obchodě {store}.","ui.setup.create-project.themeStore":"Obchod předloh Contaa","ui.setup.create-project.themeUpload":"Načíst soubor předlohy (.cto/.zip)","ui.setup.create-project.themeInvalid":"Načtený soubor není předloha Contaa nebo ho Správce Contaa nepodporuje.","ui.setup.create-project.themeWarning":"Správce Contaa nemůže říct, jestli je tato předloha kompatibilní s vaším serverem. Podívejte se prosím na informace předlohy pro získání dalších informací.","ui.setup.create-project.themeTitle":"Podívat se na hodnocení předlohy","ui.setup.create-project.themeDetails":"Následující závislosti a soubory se nainstalují spolu s vybranou předlohou.","ui.setup.create-project.themeRequire":"{count} závilostí | {count} závislostí","ui.setup.create-project.themeFiles":"{count} soubor | {count} souborů","ui.setup.create-project.theme.or":"nebo prohledejte veřejně dostupné předlohy","ui.setup.create-project.theme.search":"Prohledat předlohy","ui.setup.create-project.theme.more":"Více předloh","ui.setup.create-project.theme.empty":"Nenalezeny žádné předlohy pro {query}","ui.setup.create-project.theme.uploaded":"Soubory předlohy byly úspěšně nahrány.","ui.setup.create-project.theme.packageName":"Název balíčku","ui.setup.create-project.theme.version":"Verze","ui.setup.create-project.theme.authors":"Autor/Autoři","ui.setup.create-project.install":"Instalace","ui.setup.create-project.cancel":"Zrušit","ui.setup.database-connection.headline":"Připojení k databázi","ui.setup.database-connection.description":"Contao vyžaduje přinejmenším jednu databázi MySQL (nebo kompatibilní druh jako MariaDB) pro ukládání stránek, obsahu, uživatelů a příslušných dat. Přihlašovací údaje jsou uložené v souboru {env} v kořenové složce instalace Contaa.","ui.setup.database-connection.formTitle":"Připojovací údaje","ui.setup.database-connection.formText":"Zadejte prosím cestu k databázi nebo vyplňte zvlášť uživatelské jméno, heslo, server a pole databáze.","ui.setup.database-connection.url":"Cesta k databázi","ui.setup.database-connection.validUrl":"Cesta k databázi je neplatná nebo selhalo spojit se se serverem.","ui.setup.database-connection.or":"nebo","ui.setup.database-connection.user":"Uživatelské jméno","ui.setup.database-connection.password":"Heslo","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Jméno databáze","ui.setup.database-connection.connected":"Došlo k úspěšnému připojení k {database} na {server}.","ui.setup.database-connection.error":"Při připojení k databázi došlo k chybě.","ui.setup.database-connection.problem":"Contao zjistil problém s Vaší serverovou databází.","ui.setup.database-connection.schemaTitle":"Databázové schéma","ui.setup.database-connection.migration":"Existuje jedna nedokončená migrace. | Existují následující nedokončené migrace: {count}.","ui.setup.database-connection.schema":"Existuje jedna nedokončená schematická aktualizace. | Existují následující nedokončené schematické aktualizace: {count}.","ui.setup.database-connection.noChanges":"Vaše databáze je aktuální. ","ui.setup.database-connection.check":"Zkontrolovat databázi","ui.setup.database-connection.skip":"Přeskočit","ui.setup.database-connection.save":"Uložit","ui.setup.database-connection.change":"Změnit pověření","ui.setup.database-connection.restoreTitle":"Import databáze","ui.setup.database-connection.restoreText":"Předlohu, kterou jste právě nainstalovali, obsahuje již připravenou databázi s definovaným obsahem. Pokud ji chcete nahrát a začít tak používat Contao s již definovaným obsahem, nahrajte danou databázi, nebo přeskočte tento krok. |  Předlohu, kterou jste právě nainstalovali, obsahuje několik připravených databází s již definovaným obsahem. Pokud je chcete nahrát a začít tak používat Contao s již definovaným obsahem, nahrajte dané databázi, nebo přeskočte tento krok","ui.setup.database-connection.backup":"Uložit současnou databázi před importem.","ui.setup.database-connection.backupWarning":"Veškerá data budou v databázi přepsána! Ponejprv si uložte současnou databázi, pokud již není prázdná.","ui.setup.database-connection.restore":"Importovat předlohu databáze","ui.setup.database-connection.restoreOption":"Uložená databáze {date} ({size})","ui.setup.database-connection.restored":"Vaše databáze byla úspěšně importovaná. Pokračujte prosím, abyste provedli aktualizaci schématu databáze.","ui.setup.backend-user.success":"Ve vaší databázi byl nalezen jeden administrátorský účet pro backend Contaa. Pokud si přejete přidat další účty, přihlašte se do backendu Contaa a vytvořte je v sekci Uživatelé.","ui.setup.backend-user.error":"Nebylo možné najít jakýkoli seznam uživatelů. Zkontrolujete prosím výstup příkazového řádku.","ui.setup.backend-user.headline":"Účet backendu","ui.setup.backend-user.description":"Abyste mohli spravovat Vaši webovou stránku, musíte vytvořit alespoň jeden administrativní účet. Uvědomte si prosím, že tento účet není stejný pro přihlášení do Správce Contaa. ","ui.setup.backend-user.formTitle":"Vytvořit účet","ui.setup.backend-user.formText":"Zadejte prosím údaje pro nový účet backendu.","ui.setup.backend-user.username":"Uživatelské jméno","ui.setup.backend-user.name":"Jméno","ui.setup.backend-user.email":"Mailová adresa","ui.setup.backend-user.emailInvalid":"Zadejte prosím platnou mailovou adresu","ui.setup.backend-user.password":"Heslo","ui.setup.backend-user.passwordPlaceholder":"min. 8 znaků","ui.setup.backend-user.passwordLength":"Zadejte prosím nejméně 8 znaků.","ui.setup.backend-user.create":"Přidat účet","ui.task.headline":"Úloha na pozadí","ui.task.loading":"Načítání podrobností...","ui.task.created":"Načítání podrobností...","ui.task.active":"Počkejte prosím, zatímco Spráce Contaa na pozadí vyřizuje operační úlohy.","ui.task.complete":"Všechny operace byly úspěšně provedené. Další podrobnosti získáte v protokolu konzoly.","ui.task.aborting":"Počkejte prosím, zatímco se na pozadí zastavují operace.","ui.task.stopped":"Některé z operačních úloh byly zrušené. Zkontrolujte prosím protokol konzoly.","ui.task.error":"Příkaz na pozadí byl znenadání zastaven. Zkontrolujte prosím protokol konzoly.","ui.task.failed":"Správci Contaa se nepodařilo spustit úlohu!","ui.task.failedDescription1":"Něco se pokazilo, zatímco probíhaly úlohy na pozadí.","ui.task.failedDescription2":"Pokud se to bude opakovat, nejspíš není Váš server podporovaný.","ui.task.reportProblem":"Oznámit problém","ui.task.sponsor":"Cloud Composeru spozorován: {sponsor}","ui.task.buttonAudit":"Zaktualizovat dabázi","ui.task.buttonClose":"Zavřít","ui.task.buttonConfirm":"Potvrdit a zavřít","ui.task.buttonCancel":"Zrušit","ui.task.confirmCancel":"Jste si jistí, že chcete zrušit tuto úlohu? To může zanechat instalaci Contaa v špatném stavu!","ui.task.autoclose":"Zavřít podrobnosti o úloze po úspěšném dokončení","ui.console.toggle":"Zobrazit/skrýt výstup příkazového řádku","ui.console.showLog":"Zobrazit celý protokol konzoly","ui.console.copyLog":"Zkopírovat protokol do schránky.","ui.migrate.headline":"Aktualizace databáze","ui.migrate.migrationsOnly":"(pouze migrace)","ui.migrate.schemaOnly":"(pouze schémata)","ui.migrate.loading":"Prosím počkejte, analyzujeme Vaši databázi...","ui.migrate.empty":"Nebyl nalezené žádné aktualizace pro migraci nebo schémata. Vaši databáze je aktuální.","ui.migrate.emptyMigrations":"Nebyla nalezené žádné nedokončené migrace. Ujistěte se prosím, zda není potřeba také zaktualizovat schémata.","ui.migrate.emptySchema":"Nebyla nalezené žádné nedokončené schémata. Ujistěte se prosím, zda není potřeba také zaktualizovat migrace.","ui.migrate.pending":"Vaše databáze není aktuální. Prohlídněte si prosím níže konzolu a zaktualizujte Vaši databázi.","ui.migrate.previousChanges":"Předešlá migrace nebyla potvrzená.\\nProhlédněte si prosím níže výsledky v konzole a pak proveďte potřebné změny.","ui.migrate.previousComplete":"Předešlá migrace nebyla potvrzená. Prohlédněte si prosím níže výsledky v konzole.\\nExistuje několik nedokončených změn.","ui.migrate.appliedChanges":"Databáze byla zaktualizovaná. \\nProhlédněte si prosím níže výsledky v konzole, pak pokračujte dalšími kroky, abyste provedli další změny. ","ui.migrate.appliedComplete":"Databáze byla zaktualizovaná. \\nNeexistují žádné další nedokončené migrace nebo schémata. Vaše databáze je aktuální. ","ui.migrate.problem":"Contao zjistil problém s Vaším databázovým serverem. \\nProhlédněte si prosím níže výsledky v konzole, abyste se dozvěděli více o tom, co je potřeba opravit.  | Contao zjistil problém s Vaším databázovým serverem. \\nProhlédněte si prosím níže výsledky v konzole, abyste se dozvěděli více o tom, co je potřeba opravit. ","ui.migrate.warning":"Contao zjistil nesprávné nastavení Vašeho databázového serveru. \\nVarování lze dočasně přeskočit, měly by se ale opravit, aby docházelo k dobrému výkonu a zacházení s daty. ","ui.migrate.error":"Změny nelze provést. Vaše databáze se možná změnila. Zkontrolujte to prosím ještě jednou a proveďte daný krok ještě jednou.","ui.migrate.execute":"Provést","ui.migrate.close":"Zavřít","ui.migrate.confirm":"Potvrdit a zavřít","ui.migrate.cancel":"Zrušit","ui.migrate.continue":"Pokračovat","ui.migrate.setup":"Nastavení","ui.migrate.skip":"Přeskočit","ui.migrate.retry":"Znovu zkontrolovat","ui.migrate.retryAll":"Vybrat vše","ui.migrate.withDeletes":"Provést všechny změny databáze včetně příkazu ke smazání. ","ui.migrate.migrationTitle":"Migrace databáze","ui.migrate.schemaTitle":"Schématická aktualizace","ui.migrate.problemTitle":"Problémy databáze","ui.migrate.warningTitle":"Varování databáze","ui.migrate.addTable":"Přidat tabulku {table}","ui.migrate.dropTable":"Odstranit tabulku {table}","ui.migrate.addField":"Přidat pole {table}. {field}","ui.migrate.changeField":"Změnit pole {table}.{field}","ui.migrate.dropField":"Odstranit pole {table}.{field}","ui.migrate.createIndex":"Vytvořit index \\"{name}\\" v {table}","ui.migrate.dropIndex":"Odstranit index \\"{name}\\" v {table}","ui.widget.mandatory":"Toto pole nesmí být prázdné.","ui.widget.blankOption":"Vyberte prosím…","ui.widget.showPassword":"Zobrazit heslo","ui.widget.hidePassword":"Skrýt heslo","ui.error.title":"Požadavek HTTP pro \\"{method} {url}\\" selhal.","ui.error.server500":"Vypadá to, že došlo k nečekané chybě na Vašem webovém serveru. Zkontrolujte prosím protokolové soubory na serveru (Apache/Nginx) a protokol Správce Contaa v \\"contao-manager/logs\\".","ui.error.response":"Server odpověděl statusovým kódem {status}.","ui.error.moreLink":"Více informací","ui.error.support":"Podpora Contaa","ui.footer.help":"Nápověda","ui.footer.reportProblem":"Oznámit problém","ui.navigation.discover":"Prohlédnout","ui.navigation.packages":"Balíčky","ui.navigation.tools":"Nástroje","ui.navigation.installTool":"Instalační nástroj","ui.navigation.backend":"Backend Contaa","ui.navigation.debug":"Debugový mód Contaa","ui.navigation.logViewer":"Prohlížeč protokolu","ui.navigation.phpinfo":"Informace o PHP","ui.navigation.phpinfoLoading":"Načítání informací o PHP…","ui.navigation.maintenance":"Údržba","ui.navigation.rebuildCache":"Přetvoření meziúložiště","ui.navigation.systemCheck":"Kontrola systému","ui.navigation.advanced":"Rozšířené","ui.navigation.logout":"Odhlásit","ui.maintenance.database.title":"Migrace databáze","ui.maintenance.database.description":"Migrace databáze zajišťuje konzistentní data a tabulková schémata.","ui.maintenance.database.migrations":"Jedna nedokončená migrace databáze | Počet nedokončených migrací databáze {count} ","ui.maintenance.database.schemaUpdates":"Jedna nedokončená schématická aktualizace | Počet nedokončených schematických aktualizací {count} ","ui.maintenance.database.error":"Nalezen problém s databází.","ui.maintenance.database.warning":"Byly nalezená varování databáze.","ui.maintenance.database.button":"Zkontrolovat databázi","ui.maintenance.database.migrationOnly":"Vybrat pouze migrace","ui.maintenance.database.schemaOnly":"Vybrat pouze schémata","ui.maintenance.database.installTool":"Otevřít instalační nástroj","ui.maintenance.database.createBackup":"Vytvořit uložení databáze","ui.maintenance.database.backupUnsupported":"Ukládání databází není vaší verzí Contaa podporováno.","ui.maintenance.database.backupList":"Máte pouze jednou uloženou vaší databázi, a sice {date}. | Počet uložených databází {count}. Naposledy byla uložená {date}.","ui.maintenance.database.backupEmpty":"Momentálně nemáte žádné uložené databáze.","ui.maintenance.rebuildCache.title":"Meziúložiště aplikace","ui.maintenance.rebuildCache.description":"Přetvoření meziúložiště aplikace je nutné provést po každé změně konfiguračních souborů. ","ui.maintenance.rebuildCache.rebuildProd":"Přetvořit produktivní meziúložiště ","ui.maintenance.rebuildCache.rebuildDev":"Přetvořit vývojářské meziúložiště ","ui.maintenance.rebuildCache.clearProd":"Vyprázdnit produktivní meziúložiště ","ui.maintenance.rebuildCache.clearDev":"Vyprázdnit vývojářské meziúložiště ","ui.maintenance.installTool.title":"Instalační nástroj Contaa","ui.maintenance.installTool.description":"Instalační nástroj Contaa se automaticky uzamkne, pokud nesprávně zadáte heslo třikrát po sobě. ","ui.maintenance.installTool.unlock":"Odemknout Instalační nástroj","ui.maintenance.installTool.lock":"Uzamknout Instalační nástroj","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"Composer autoloader je zodpovědný za načítání tříd PHP. Autoloader musí být spuštěný po přidání vlastních namespace do kořenové composer.json.","ui.maintenance.dumpAutoload.button":"Spustit Autoloadera","ui.maintenance.composerInstall.title":"Na Compseru závislá rozšíření","ui.maintenance.composerInstall.description":"Na Composeru závislá rozšíření se nachází ve složce {vendor} Vaší instalace. Přeinstalování těchto závislostí může být důležité po manipulaci nebo manuálnímu přenosu souboru {composerLock}.","ui.maintenance.composerInstall.button":"Spustit instalátor","ui.maintenance.composerInstall.update":"Spustit aktualizaci Composeru","ui.maintenance.composerCache.title":"Meziúložiště Composeru","ui.maintenance.composerCache.description":"Meziúložiště Composeru stáhla balíčky, aby zlepšily výkonost. Pokud máte potíže jako poničené soubory, pokuste se smazat meziúložiště Composeru, abyste vyvolali nové stáhnutí. ","ui.maintenance.composerCache.button":"Smazat meziúložiště","ui.maintenance.maintenanceMode.title":"Mód údržby","ui.maintenance.maintenanceMode.description":"Když se spustí mód údržby, zobrazí se předloha pro \\"503 service Unavailable\\".","ui.maintenance.maintenanceMode.enable":"Aktivovat","ui.maintenance.maintenanceMode.disable":"Deaktivovat","ui.maintenance.debugMode.title":"Vývojářský mód","ui.maintenance.debugMode.description":"Aktivujte vývojářský mód zadáním uživatele a hesla pro {appDevPhp}.","ui.maintenance.debugMode.descriptionJwt":"Aktivujte vývojářský mód nastavením vývojářské cookie pro danou doménu.","ui.maintenance.debugMode.activate":"Aktivovat","ui.maintenance.debugMode.deactivate":"Deaktivovat","ui.maintenance.debugMode.credentials":"Uživatelské informace","ui.maintenance.debugMode.user":"Zadejte prosím uživatelské jméno pro vývojářský mód.","ui.maintenance.debugMode.password":"Zadejte prosím heslo pro uživatele vývojářského módu.","ui.maintenance.opcodeCache.title":"Operační kód mezinúložiště","ui.maintenance.opcodeCache.description":"Operační kód meziúložiště souborů PHP dokáže rychleji zpracovat data. Musí být smazán za určitých podmínek, pokud se nepodařilo rozpoznat soubory po jejich změně.","ui.maintenance.opcodeCache.button":"Zkrátit meziúložiště","ui.maintenance.safeMode":"Není to dostupné v Bezpečnostním módu","ui.maintenance.unsupported":"Nepodporované Vaší verzí Contaa. ","ui.packages.updateButton":"Zaktualizovat balíčky","ui.packages.searchButton":"Vyhledat balíčky","ui.packages.searchPlaceholder":"Hledají se balíčky…","ui.packages.uploadOverlay":"Přetáhněte a pusťte soubory, které chcete nahrát","ui.packages.uploadButton":"Nahrát balíčky","ui.packages.uploadMessage":"Máte jeden nepotvrzený přenos. | Máte celkem {count} nepotvrzených přenosů.","ui.packages.uploadApply":"Potvrdit nahrání","ui.packages.uploadReset":"Smazat nahráné soubory","ui.packages.uploadIncomplete":"Tyto soubory nebyly zcela nahrány. Smažte je prosím a zkuste to znovu.","ui.packages.uploadDuplicate":"Zdá se, že byly tyto soubory nahrány několikrát. Smažte prosím dané duplikáty.","ui.packages.uploadInstalled":"Tento soubor je již nainstalovaný. Smažte prosím daný duplikát.","ui.packages.uploadUnsupported":"Nahrávání souborů není ve Vaší instalaci podporováno. Ujistěte se prosím, zda je funkce PHP ZIP nainstalovaná a zaktualizujte veškeré závislosti.","ui.packages.changesMessage":"Máte jednu nepotvrzenou změnu. | Máte celkem {count} nepotvrzených změn.","ui.packages.changesDryrun":"Zkouška nanečisto","ui.packages.changesApply":"Provést změny","ui.packages.changesApplyAll":"Zaktualizovat všechny balíčky","ui.packages.changesDryrunAll":"Vyzkoušet všechny balíčky nanečisto","ui.packages.changesReset":"Vrátit změny","ui.packages.changesReview":"Ukázat změny","ui.packagelist.loading":"Spouštění…","ui.packagelist.uploads":"Nahrání/přenos souborů","ui.packagelist.added":"Nové balíčky","ui.packagelist.installed":"Nainstalované balíčky","ui.package.hintRevert":"Vrátit změny","ui.package.hintNoupdate":"Neaktualizovat","ui.package.hintConstraint":"Tento balíček bude nainstalovaný s omezením {constraint}, pokud provedete změny.","ui.package.hintConstraintBest":"Tento balíček bude nainstalovaný v nejnověji dostupné verzi, pokud provedete změny.","ui.package.hintConstraintChange":"Toto omezení pro tento balíček bude změněno z \\"{from}\\" na \\"{to}\\", pokud provedete změny.","ui.package.hintConstraintUpdate":"Tento balíček bude zaktualizovaný, pokud aplikujete tyto změny.","ui.package.hintAdded":"Tento balíček bude nainstalovaný, když aplikujete tyto změny.","ui.package.hintRemoved":"Tento balíček bude smazaný, pokud provedete změny.","ui.package.requiredTitle":"přidáno manuálně","ui.package.requiredText":"Tento balíček je už sice uvedený ve Vašem souboru composer.json, ale ještě není nainstalovaný.","ui.package.removedTitle":"odstaněno manuálně","ui.package.removedText":"Tento balíček byl odstraněn z Vašeho souboru composer.json.","ui.package.installed":"Momentálně nainstalováno:","ui.package.version":"Verze {version}","ui.package.additionalDownloads":"{count} Stažení | {count} Stažení","ui.package.additionalStars":"{count} Hvězda | {count} hvězd","ui.package.editConstraint":"Upravit","ui.package.uploadConstraint":"Toto omezení je nadefinováno nahraným balíčkem.","ui.package.updateButton":"Zaktualizovat","ui.package.removeButton":"Smazat","ui.package.installButton":"Přidat balíček","ui.package.installButtonShort":"Přidat","ui.package.detailsButton":"Podrobnosti","ui.package.latestConstraint":"poslední verze","ui.package.update":"Existuje nová aktualizace","ui.package.updateLatest":"poslední verze","ui.package.updateAvailable":"{version}","ui.package.updateUnknown":"neznámá verze","ui.package.updateConstraint":"Je k dispozici nová verze než ta, kterou právě používáte.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Verze {version}","ui.cloudStatus.waitingTime":"Doba čekání","ui.cloudStatus.jobs":"Současné úlohy","ui.cloudStatus.workers":"Účastníků","ui.cloudStatus.approx":"{minutes} min.","ui.cloudStatus.none":"ne","ui.cloudStatus.short":"ca. {minutes} min.","ui.cloudStatus.long":"ca. {minutes} min. {seconds} sek.","ui.cloudStatus.error":"Nebylo možné získat status Composer Resolver Cloud. Může být zrovna neaktivní nebo má nějaké problémy.","ui.cloudStatus.button":"Status Cloudu","ui.cloudStatus.refresh":"Znovu načíst status Cloudu","ui.log-viewer.loading":"Spouštění…","ui.log-viewer.empty":"Na Vašem serveru se nenacházejí žádné protokolové soubory.","ui.log-viewer.reload":"Načíst znovu","ui.log-viewer.file":"Protokolový soubor","ui.log-viewer.channel":"Kanál","ui.log-viewer.channelTitle":"Kanál zpráv byl přihlášen.","ui.log-viewer.level":"Úroveň","ui.log-viewer.levelTitle":"Vážnost protokolované zprávy.","ui.log-viewer.timeHeader":"Čas","ui.log-viewer.messageHeader":"Zpráva","ui.log-viewer.showContext":"Zobrazit kontext","ui.log-viewer.hideContext":"Skrýt kontext","ui.log-viewer.showExtra":"Zobrazit extra","ui.log-viewer.hideExtra":"Smazat extra","ui.log-viewer.more":"Dozvědět se víc...","ui.log-viewer.download":"Stáhnout","ui.log-viewer.downloadTitle":"Stáhnout soubor \\"{file}\\"","ui.log-viewer.prodEnvironment":"Produktivní prostředí","ui.log-viewer.devEnvironment":"Vývojářské prostředí (vychytávací mód)"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[557],{1557:function(e){e.exports=JSON.parse('{"ui.app.title":"Расширения Contao","ui.app.loading":"Загрузка списка расширений...","ui.discover.advertisement":"Реклама в списке расширений","ui.discover.loading":"Загрузка...","ui.discover.offline":"Не удалось получить результаты.","ui.discover.offlineExplain":"Проверьте подключение к сети Интернет и отключите блокировку JavaScript в своем браузере.","ui.discover.offlineButton":"Попробовать еще раз","ui.discover.searchPlaceholder":"Поиск в {count} расширениях...","ui.discover.empty":"Нет результатов для {query}","ui.discover.more":"Другие результаты","ui.discover.sortBy":"Сортировать по","ui.discover.sortReleased":"Выпуск","ui.discover.sortReleasedTitle":"Сортировать результаты по дате выпуска","ui.discover.sortLatest":"Обновлено","ui.discover.sortLatestTitle":"Сортировать результаты по последнему обновлению","ui.discover.sortDownloads":"Загрузки","ui.discover.sortDownloadsTitle":"Сортировать результаты по количеству загрузок","ui.discover.sortFavers":"Рейтинг","ui.discover.sortFaversTitle":"Сортировать результаты по рейтингу","ui.discover.detailsButton":"Сведения","ui.discover.latestPackages":"Последние и обновленные расширения","ui.discover.faversPackages":"Расширения с высоким рейтингом","ui.discover.downloadsPackages":"Самые загружаемые расширения","ui.package.homepage":"Веб-сайт проекта","ui.package.private":"Частный пакет","ui.package.privateTitle":"Частные пакеты доступны только у поставщика (наприм., в виде загрузки ZIP-файла). Посетите веб-сайт для получения дополнительной информации.","ui.package.abandoned":"Заброшенный","ui.package.abandonedText":"Этот пакет отмечен как заброшенный и больше не поддерживается.","ui.package.abandonedReplace":"Этот пакет имеет статус заброшенного и больше не поддерживается. Автор предлагает вместо него использовать пакет {replacement}.","ui.package-details.previous":"Детали предыдущего расширения","ui.package-details.close":"Закрыть детали расширения","ui.package-details.loading":"Загрузка...","ui.package-details.tabDescription":"Описание","ui.package-details.tabRequire":"Требования","ui.package-details.tabFeatures":"Особенности","ui.package-details.tabSuggest":"Предложения","ui.package-details.tabConflict":"Конфликты","ui.package-details.tabDependents":"Зависимые","ui.package-details.linkRequires":"требует","ui.package-details.linkReplaces":"заменяет","ui.package-details.linkProvides":"обеспечивает","ui.package-details.linkConflicts":"конфликты","ui.package-details.funding":"Финансировать дальнейшее развитие!","ui.package-details.latest":"Последняя версия","ui.package-details.released":"выпуск от","ui.package-details.license":"Лицензия(и)","ui.package-details.authors":"из","ui.package-details.more":"Еще","ui.package-details.packagist":"Сведения о пакете","ui.package-details.metadata":"Редактировать метаданные","ui.package-details.support_docs":"Документация","ui.package-details.support_wiki":"Вики","ui.package-details.support_forum":"Форум поддержки","ui.package-details.support_issues":"Проблемы / Отчет об ошибках","ui.package-details.support_source":"Исходный код","ui.package-details.support_irc":"IRC / Чат","ui.package-details.support_email":"E-Mail поддержки","ui.package-details.support_rss":"RSS-канал"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[523],{523:function(e){e.exports=JSON.parse('{"ui.app.title":"Contao Erweiterungen","ui.app.loading":"Lade Erweiterungsliste …","ui.discover.advertisement":"Anzeigen in der Erweiterungsliste","ui.discover.loading":"Laden …","ui.discover.offline":"Konnte keine Ergebnisse laden.","ui.discover.offlineExplain":"Prüfe deine Internet-Verbindung und deaktiviere alle JavaScript-Blocker.","ui.discover.offlineButton":"Erneut versuchen","ui.discover.searchPlaceholder":"{count} Erweiterungen durchsuchen …","ui.discover.empty":"Keine Ergebnisse für {query}","ui.discover.more":"Mehr Resultate","ui.discover.sortBy":"Sortieren nach","ui.discover.sortReleased":"Veröffentlicht","ui.discover.sortReleasedTitle":"Ergebnisse nach der Veröffentlichung sortieren","ui.discover.sortLatest":"Aktualisiert","ui.discover.sortLatestTitle":"Ergebnisse nach der letzten Aktualisierung sortieren","ui.discover.sortDownloads":"Downloads","ui.discover.sortDownloadsTitle":"Ergebnisse nach Anzahl Downloads sortieren","ui.discover.sortFavers":"Bewertung","ui.discover.sortFaversTitle":"Ergebnisse nach Bewertung sortieren","ui.discover.detailsButton":"Details","ui.discover.latestPackages":"Neuste und aktualisierte Erweiterungen","ui.discover.faversPackages":"Bestbewertete Erweiterungen","ui.discover.downloadsPackages":"Meistgeladene Erweiterungen","ui.package.homepage":"Projektwebseite","ui.package.private":"Privates Paket","ui.package.privateTitle":"Private Pakete sind nur vom jeweiligen Hersteller verfügbar (z.B. als ZIP-Download). Besuche die Webseite für weitere Informationen.","ui.package.abandoned":"verwaist","ui.package.abandonedText":"Diese Erweiterung ist verwaist und wird nicht mehr gepflegt.","ui.package.abandonedReplace":"Diese Erweiterung ist verwaist und wird nicht mehr gepflegt. Der Autor empfiehlt stattdessen das Paket {replacement} zu verwenden.","ui.package-details.previous":"Details der vorherigen Erweiterung","ui.package-details.close":"Details der Erweiterung schließen","ui.package-details.loading":"Laden …","ui.package-details.tabDescription":"Beschreibung","ui.package-details.tabRequire":"Abhängigkeiten","ui.package-details.tabFeatures":"Funktionen","ui.package-details.tabSuggest":"Empfehlungen","ui.package-details.tabConflict":"Konflikte","ui.package-details.tabDependents":"Abhängige","ui.package-details.linkRequires":"benötigt","ui.package-details.linkReplaces":"ersetzt","ui.package-details.linkProvides":"liefert","ui.package-details.linkConflicts":"inkompatibel mit","ui.package-details.funding":"Weiterentwicklung finanzieren!","ui.package-details.latest":"Neuste Version","ui.package-details.released":"veröffentlicht am","ui.package-details.license":"Lizenz(en)","ui.package-details.authors":"von","ui.package-details.more":"Mehr","ui.package-details.packagist":"Paketdetails","ui.package-details.metadata":"Metadaten bearbeiten","ui.package-details.support_docs":"Dokumentation","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Support-Forum","ui.package-details.support_issues":"Fehler melden","ui.package-details.support_source":"Quellcode","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Support E-Mail","ui.package-details.support_rss":"RSS-Feed"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[953],{3953:function(e){e.exports=JSON.parse('{"ui.app.title":"Contao Extensions","ui.app.loading":"Laddar tilläggslista …","ui.discover.advertisement":"Annons i tilläggslistan","ui.discover.loading":"Laddning ...","ui.discover.offline":"Det gick inte att hämta några resultat.","ui.discover.offlineExplain":"Kontrollera din internetanslutning och inaktivera JavaScript-blockerare i din webbläsare.","ui.discover.offlineButton":"Försök igen","ui.discover.searchPlaceholder":"Sök i {count} tillägg …","ui.discover.empty":"Inga resultat för {query}","ui.discover.more":"Fler resultat","ui.discover.sortBy":"Sortera efter","ui.discover.sortReleased":"Släppte","ui.discover.sortReleasedTitle":"Sortera resultat efter releasedatum","ui.discover.sortLatest":"Uppdaterad","ui.discover.sortLatestTitle":"Sortera resultat efter senast uppdaterade","ui.discover.sortDownloads":"Nedladdningar","ui.discover.sortDownloadsTitle":"Sortera resultat efter antal nedladdningar","ui.discover.sortFavers":"Betyg","ui.discover.sortFaversTitle":"Sortera resultat efter betyg","ui.discover.detailsButton":"Detaljer","ui.discover.latestPackages":"Senaste och uppdaterade tillägg","ui.discover.faversPackages":"Högst rankade tillägg","ui.discover.downloadsPackages":"Mest nedladdade tillägg","ui.package.homepage":"Projektets hemsida","ui.package.private":"Privat paket","ui.package.privateTitle":"Privata paket är endast tillgängliga från leverantören (t.ex. som en ZIP-nedladdning). Besök gärna webbplatsen för mer information.","ui.package.abandoned":"övergiven","ui.package.abandonedText":"Detta paket är övergivet och underhålls inte längre.","ui.package.abandonedReplace":"Detta paket är övergivet och underhålls inte längre. Författaren föreslår att du istället använder paketet {replacement}.","ui.package-details.previous":"Tidigare tilläggsinformation","ui.package-details.close":"Stäng tilläggsinformation","ui.package-details.loading":"Laddning ...","ui.package-details.tabDescription":"Beskrivning","ui.package-details.tabRequire":"Krav","ui.package-details.tabFeatures":"Funktioner","ui.package-details.tabSuggest":"Förslag","ui.package-details.tabConflict":"Konflikter","ui.package-details.tabDependents":"Anhöriga","ui.package-details.linkRequires":"kräver","ui.package-details.linkReplaces":"ersätter","ui.package-details.linkProvides":"tillhandahåller","ui.package-details.linkConflicts":"konflikter","ui.package-details.funding":"Underhåll av fondpaket!","ui.package-details.latest":"Senaste versionen","ui.package-details.released":"släppt på","ui.package-details.license":"Licens(er)","ui.package-details.authors":"från","ui.package-details.more":"Mer","ui.package-details.packagist":"Paketdetaljer","ui.package-details.metadata":"Redigera metadata","ui.package-details.support_docs":"Dokumentation","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Supportforum","ui.package-details.support_issues":"Problem/felrapport","ui.package-details.support_source":"Källkod","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Support E-post","ui.package-details.support_rss":"RSS Feed"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[721],{9721:function(e){e.exports=JSON.parse('{"ui.app.title":"Contao機能拡張","ui.app.loading":"機能拡張の一覧を読み込み中...","ui.discover.advertisement":"機能拡張のリストに広告","ui.discover.loading":"読み込み中...","ui.discover.offline":"何も結果を取得できませんでした。","ui.discover.offlineExplain":"Internet接続を確認し、ブラウザーのJavaScriptのブロッカーを無効にしてください。","ui.discover.offlineButton":"再実行","ui.discover.searchPlaceholder":"{count}の機能拡張から検索中...","ui.discover.empty":"{query}の結果はありません。","ui.discover.more":"さらに結果を表示","ui.discover.sortBy":"並べ替え","ui.discover.sortReleased":"リリース","ui.discover.sortReleasedTitle":"リリース日で並べ替え","ui.discover.sortLatest":"更新日時","ui.discover.sortLatestTitle":"更新日時で並べ替え","ui.discover.sortDownloads":"ダウンロード","ui.discover.sortDownloadsTitle":"ダウンロード数で並べ替え","ui.discover.sortFavers":"評価","ui.discover.sortFaversTitle":"評価の結果で並べ替え","ui.discover.detailsButton":"詳細","ui.discover.latestPackages":"最新と更新された機能拡張","ui.discover.faversPackages":"最上位のレートの機能拡張","ui.discover.downloadsPackages":"もっともダウンロードされた機能拡張","ui.package.homepage":"プロジェクトのウェブサイト","ui.package.private":"私的なパッケージ","ui.package.privateTitle":"私的なパッケージはベンダーからだけ(例えば、ZIPのダウンロードで)入手できます。詳細はウェブサイトを参照してください。","ui.package.abandoned":"放棄","ui.package.abandonedText":"このパッケージは放棄され、もう保守されていません。","ui.package.abandonedReplace":"このパッケージは放棄され、もう保守されていません。代わりに{replacement}パッケージの使用を作者は推奨しています。","ui.package-details.previous":"以前の機能拡張の詳細","ui.package-details.close":"機能拡張の詳細を閉じる","ui.package-details.loading":"読み込み中...","ui.package-details.tabDescription":"説明","ui.package-details.tabRequire":"必須要件","ui.package-details.tabFeatures":"機能","ui.package-details.tabSuggest":"提案","ui.package-details.tabConflict":"競合","ui.package-details.tabDependents":"依存関係","ui.package-details.linkRequires":"必要","ui.package-details.linkReplaces":"置き換え","ui.package-details.linkProvides":"提供","ui.package-details.linkConflicts":"競合","ui.package-details.funding":"パッケージの保守に資金を提供!","ui.package-details.latest":"最新版","ui.package-details.released":"リリース日","ui.package-details.license":"ライセンス","ui.package-details.authors":"次から","ui.package-details.more":"詳細","ui.package-details.packagist":"パッケージの詳細","ui.package-details.metadata":"メタデータを編集","ui.package-details.support_docs":"ドキュメント","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"サポートフォーラム","ui.package-details.support_issues":"問題 / バグ報告","ui.package-details.support_source":"ソースコード","ui.package-details.support_irc":"IRC / チャット","ui.package-details.support_email":"サポートの電子メール","ui.package-details.support_rss":"RSSフィード"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[367],{8367:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Веза није безбедна !!","ui.app.httpsDescription":"Ако не користите HTTPS ваши поверљиви подаци ће се преносити без енкрипције.","ui.app.httpsLink":"Детаљније","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Safe Mode enabled !!","ui.app.safeModeDescription":"Some features of the Contao Manager are not available.","ui.app.safeModeExit":"Exit Safe Mode","ui.app.loading":"Contao Manager се учитава...","ui.app.apiError":"Неочекиван статус API","ui.app.configSecurity1":"УПОЗОРЕЊЕ !!! Пронађен је незаштићен config фолдер","ui.app.configSecurity2":"Contao Manager је открио да су конфигурациони фајлови јавно доступни. Све операције су обустављене док се config фолдер не заштити. У супротном би потенцијални нападач могао да приступи осетљивим подацима о Вашој инсталацији.\\n\\nДа поправите ово, осигурајте да приступ фолдеру \\"contao-manager\\" на Вашем серверу буде спречен. Ако је потребно да прво научите како то да урадите, прочитајте упутство за ваш сервер или контактирајте корисничку подршку Вашег хостинг провајдера.","ui.account.welcome":"Добро дошли","ui.account.intro1":"Добродошли у Contao Manager, универзални алат за инсталацију и управљање са Вашом инсталацијом Contao Open Source CMS. Ако се први пут срећете са њим, погледајте {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} да почнете","ui.account.introManual":"прочитајте приручник","ui.account.intro2":"Ако наиђете на неки проблем, проверите {ourGithubIssues}  и слободно креирајте нову тему за било шта што до сада није пријављено.","ui.account.introIssues":"наши GitHub проблеми","ui.account.headline":"Кориснички налог","ui.account.description":"Да управљате Вашом инсталацијом, потребно је да креирате налог за Contao Manager. Имајте на уму да овај налог није исто што и налог за Contao Фронт- и БекЕнд.","ui.account.username":"Корисничко име","ui.account.password":"Лозинка","ui.account.passwordPlaceholder":"мин. 8 знакова","ui.account.passwordLength":"Унесите барем 8 знакова.","ui.account.submit":"Креирај налог","ui.account.contribute1":"Contao и Contao Manager су под покровитељством непрофитне организације Contao Association.","ui.account.contribute2":"Молимо Вас да размислите о томе да помогнете отвореном пројекту својом {donate}.","ui.account.contributeDonate":"донирање","ui.login.headline":"Пријава","ui.login.description":"Пријави се ради управљања инсталацијом.","ui.login.username":"Корисничко име","ui.login.password":"Лозинка","ui.login.forgotPassword":"Заборавили сте лозинку?","ui.login.button":"Пријава","ui.login.locked":"Приступ је одбијен јер је Contao Manager закључан. Да бисте га откључали, обришите {lockFile} у почетном директоријуму ваше Contao инсталације.","ui.logout.headline":"Сесија је истекла","ui.logout.warning":"Нисте били активни дуже од 25 минута. Из безбедносних разлога ваша сесија ће бити ускоро прекинута.","ui.logout.expired":"Ваша сесија је аутоматски прекинута јер сте били неактивни дуже од 30 минута.","ui.logout.renew":"Остани пријављен","ui.logout.logout":"Одјава","ui.logout.login":"Назад на пријаву","ui.oauth.error":"Неисправан OAuth покушај. Проверите параметре.","ui.oauth.https":"URI за редирекцију МОРА да користи сигурни протокол (https:) чиме се спречава да се аутентификациони токен преноси као обични текст.","ui.oauth.headline":"Даљинска аутентификација","ui.oauth.description":"Следеће апликације или сервиси захтевају удаљени приступ Вашој инстанци Contao Manager-а.","ui.oauth.domain":"Пре него што дозволите приступ, будите сигурни да познајете овај URL и имате поверење у власника!","ui.oauth.allow":"Дозволи приступ","ui.oauth.deny":"Одбиј приступ","ui.boot.headline":"Провера система","ui.boot.description":"Молимо сачекајте, анализирам ваш сервер ...","ui.boot.issue1":"Пронађен је проблем приликом инсталације","ui.boot.issue2":"Ваша инсталација има проблеме који морају бити решени како бисте могли да користите Contao Manager.","ui.boot.run":"Покрени Contao Manager","ui.boot.safeMode":"Покрени у Safe Mode","ui.recovery.headline":"Опоравак система","ui.recovery.description":"Contao Manager је открио фајлове који наликују на Contaо, али интерфејс командне линије - Command Line Interface - не ради како би требао.","ui.recovery.console":"Испис конзоле","ui.recovery.repairOptions":"Одаберите опцију за опоравак инсталације.","ui.recovery.repairHeadline":"Аутоматска поправка","ui.recovery.repairDescription":"Аутоматска поправка инсталације поновним креирањем апликативног cache-а и реинсталацијом пакета Композера.","ui.recovery.repairWarning":"Било која модификација vendor фајлова можда ће бити обрисана приликом процедуре!","ui.recovery.repairFailed":"Аутоматска поправка није успела. Пробајте ручно да поправите инсталацију у Safe Mode-у.","ui.recovery.repairButton":"Покрени системску поправку","ui.recovery.safeModeHeadline":"Safe Mode","ui.recovery.safeModeDescription":"Покретањем Contao Manager-а у Safe Mode-у омогућиће управљање пакетима и одређеним задацима одржавања, али могућности које се ослањају на постојећу инсталацију Contao неће бити доступне.","ui.recovery.safeModeButton":"Покрени у Safe Mode","ui.server.pending":"Причекајте...","ui.server.running":"Анализа је у току...","ui.server.error":"Провера није успела због неочекиваног одговора са сервера.","ui.server.details":"Детаљи","ui.server.prerequisite":"Провера је заустављена због тога што потребни предуслови нису задовољени.","ui.server.selfUpdate.title":"Ажурирања Contao Manager-а","ui.server.selfUpdate.update":"Нова верзија Contao Manager {latest} је доступна.","ui.server.selfUpdate.manualUpdate":"Нова верзија Contao Manager {latest} је доступна. Ваш сервер не подржава аутоматско ажурирање, панову верзију преузмите са {download}.","ui.server.selfUpdate.latest":"Користите последњу верзију {current}.","ui.server.selfUpdate.dev":"Развојне верзије не подржавају аутоматско ажурирање.","ui.server.selfUpdate.unsupported":"Нова верзија је доступна али не подржава вашу верзију PHP-а.","ui.server.selfUpdate.button":"Покрени Само-ажурирање","ui.server.selfUpdate.continue":"Настави","ui.server.config.title":"Конфигурација сервера","ui.server.config.setup":"Конфигуриши","ui.server.config.change":"Промени","ui.server.config.save":"Сачувај","ui.server.config.cancel":"Откажи","ui.server.config.customOption":"Остало...","ui.server.config.description":"Да би исправно извршавао позадинске задатке, Contao Manager треба да зна где се налази PHP command line binary и како да извршава команде одвојено од мрежних процеса.","ui.server.config.formTitle":"Конфигурација сервера","ui.server.config.formText":"Унесите путању до вашег PHP binary. Проверите да ли је binary у истој верзији PHP као ваш веб процес.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud омогућава инсталацију Composer зависности и у случају када ваш локални сервер не поседује довољно радне меморије. Имајте на уму да ће информације о вашим пакетима бити пренете на сервер којим управља Contao Association.","ui.server.config.cloud":"Користи Composer Resolver Cloud","ui.server.config.cli":"PHP binary","ui.server.config.stateErrorCli":"На серверу није пронађен валидан PHP binary.","ui.server.config.stateErrorCloud":"Употреба Composer Resolver Cloud није подржана.","ui.server.config.stateSuccess":"PHP binary на {php_cli}.","ui.server.php_web.title":"PHP Web Process","ui.server.php_web.below7":"Пронађена је верзија PHP {version}. Молимо Вас да што пре пређете на PHP 7!","ui.server.php_web.success":"Пронађена верзија PHP {version}, нема познатих проблема.","ui.server.php_cli.title":"PHP Command Line Interface","ui.server.php_cli.success":"Пронађена верзија PHP {version}, нема познатих проблема.","ui.server.composer.title":"Composer Environment","ui.server.composer.success":"Нема познатих проблема.","ui.server.composer.install":"Зависности Композера нису инсталиране.","ui.server.composer.button":"Install","ui.server.contao.title":"Инсталација Contao","ui.server.contao.setup":"Покретање инсталације","ui.server.contao.check":"Check database","ui.server.contao.empty":"Није пронађена инсталација Contao.","ui.server.contao.old":"Верзија Contao {version} није усклађена са Contao Менаџером, па ћете морати ручно да ажурирате вашу инсталацију.","ui.server.contao.found":"Пронађен Contao {version} (API version {api}).","ui.server.contao.connectionError":"Unable to connect to the database server.","ui.server.contao.connectionProblem":"Database problem found.","ui.server.contao.missingUser":"Admin account not found.","ui.setup.continue":"Настави","ui.setup.manager":"Покрени Contao Manager","ui.setup.cancel":"Откажи","ui.setup.welcome":"Добро дошли","ui.setup.welcome1":"This wizard will take you through the necessary steps to set up your Contao Open Source CMS installation.","ui.setup.welcome2":"If you have any questions, please find documentation, forums, a Slack channel and more on the {support} page.","ui.setup.support":"community support","ui.setup.start":"Get started","ui.setup.complete":"Congratulations!","ui.setup.complete1":"Contao {version} has been installed successfully.","ui.setup.complete2":"To finish the setup process, please open the install tool to configure the database connection and create a back end user.","ui.setup.complete3":"You can now start to create your website in the Contao back end. If you need additional extensions, continue to the Contao Manager.","ui.setup.installTool":"Open the Install Tool","ui.setup.login":"Login to Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". An Open Source project like Contao requires amounts of money that can\'t be raised by a single person or company.\\nIf you have a website or sell websites built with Contao, we would love to see you contribute back financially to the product your business relies upon.","ui.setup.fundingLink":"Learn more","ui.setup.document-root.headline":"Подешавања мрежног сервера","ui.setup.document-root.warning":"Да бисте инсталирали Contao уз помоћ Contao Manager-а, морате да исправно подесите локацију  root-а на Вашем мрежном серверу.","ui.setup.document-root.description1":"Contao uses a separate folder for public files, application files are installed in its parent folder. Contao cannot be installed if the folder structure is not correct or the folders are not empty.","ui.setup.document-root.description2":"Ако нисте сигурни како да подесите root, прочитајте документацију или контактирајте администратора Вашег хостинг провајдера.","ui.setup.document-root.documentation":"Прочитајте документацију","ui.setup.document-root.conflictsTitle":"Installation directory not empty","ui.setup.document-root.conflictsDirectory":"The root directory of your future Contao installation is not empty, we have found {count} file(s) that might be overwritten by the installation process. It is recommended to create an empty directory structure for Contao, but you can also remove the following files and check again if you are sure they are unused.","ui.setup.document-root.ignoreConflicts":"I want to install Contao into the non-empty directory. I understand that this might overwrite any existing files on my webspace.","ui.setup.document-root.check":"Check again","ui.setup.document-root.create":"Create directories","ui.setup.document-root.change":"Change directories","ui.setup.document-root.formTitle":"Подешавање директоријума","ui.setup.document-root.formText1":"Contao Manager може аутоматски да креира нову структуру директоријума на серверу.","ui.setup.document-root.formText2":"Мораћете рућно да подесите нови root за документе (нпр. преко администраторског контрол панела на хостингу).","ui.setup.document-root.autoconfig":"Разумем да морам да променим моју конфигурацију сервера. Ако то не урадим, конфигурациони фајлови ће бити изложени (укључујући детаље налога и лозинке)!","ui.setup.document-root.directory":"Нови директоријум","ui.setup.document-root.currentRoot":"Тренутни Document Root","ui.setup.document-root.newRoot":"Нови Document Root","ui.setup.document-root.finish":"Постављање директоријума","ui.setup.document-root.publicDir":"Use {dir} for public files (for Contao {version})","ui.setup.document-root.directoryInvalid":"Унесите исправан назив за директоријум.","ui.setup.document-root.directoryExists":"Одредишни директоријум већ постоји. Унесите други назив.","ui.setup.document-root.confirmation":"Contao Manager је успешно завршио креирање потребног директоријума за Вашу Contao инсталацију. Сада треба да подесите document root на Вашем мрежном серверу. Немојте да поново учитавате ову страницу пре тога.","ui.setup.document-root.reload":"Поново учитај страницу","ui.setup.document-root.success":"The directory structure on your web server is set up correctly!","ui.setup.document-root.installingProjectDir":"Application files will be installed to {dir}.","ui.setup.document-root.installingPublicDir":"Public files will be installed to {dir}.","ui.setup.document-root.installedProjectDir":"Application files are installed in {dir}.","ui.setup.document-root.installedPublicDir":"Public files are installed in {dir}.","ui.setup.create-project.headline":"Инсталација Contao","ui.setup.create-project.description":"Contao development follows the principle of {semver}, a new minor version is released every six months. The currently supported releases are:","ui.setup.create-project.semver":"Semantic Versioning","ui.setup.create-project.latestTitle":"Последња верзија","ui.setup.create-project.ltsTitle":"Long Term Support","ui.setup.create-project.latestQ1":"Our latest version, offers the most features with support until February {year}.","ui.setup.create-project.latestQ3":"Our latest version, offers the most features with support until August {year}.","ui.setup.create-project.ltsText":"Our current LTS version, if you focus on stability. Offers long term support until February {year}.","ui.setup.create-project.pltsText":"The previous LTS version, still has long term support until February {year}.","ui.setup.create-project.requiresPHP":"Requires at least PHP {version}, you have PHP {current}.","ui.setup.create-project.requiresDocroot":"The document root must be \\"{folder}\\".","ui.setup.create-project.releaseplan":"За више информација, проверите {contaoReleasePlan}.","ui.setup.create-project.releaseplanLink":"План издања за Contao","ui.setup.create-project.installed":"Contao {version} is successfully installed on the server. Continue to set up your database or launch the Contao Manager to install a different version.","ui.setup.create-project.formTitle":"Select a distribution","ui.setup.create-project.formText":"Please choose which version should be installed.","ui.setup.create-project.version":"Верзија","ui.setup.create-project.demo":"Install the Contao demo website","ui.setup.create-project.demoDescription":"The demo website helps you to get familiar with Contao and all of its core features. More themes can be found in the {store}.","ui.setup.create-project.coreOnly":"Минимална инсталација (само основни модули)","ui.setup.create-project.noUpdate":"Прескочи инсталацију (само за експерте!)","ui.setup.create-project.theme":"Contao Theme","ui.setup.create-project.themeInstall":"To install a Contao theme, use the search input or upload a theme file (.cto/.zip) that supports installation through the Contao Manager.","ui.setup.create-project.themeBuy":"Make sure to visit the official {store}.","ui.setup.create-project.themeStore":"Contao Themes Store","ui.setup.create-project.themeUpload":"Upload theme file (.cto/.zip)","ui.setup.create-project.themeInvalid":"The uploaded file is not a Contao theme or does not support the Contao Manager.","ui.setup.create-project.themeWarning":"The Contao Manager cannot tell whether this theme is compatible with your server. Please check with the theme vendor if you have any questions.","ui.setup.create-project.themeTitle":"Review theme details","ui.setup.create-project.themeDetails":"The following dependencies and files will be installed with this theme.","ui.setup.create-project.themeRequire":"{count} Dependencies | {count} Dependencies","ui.setup.create-project.themeFiles":"{count} File | {count} Files","ui.setup.create-project.theme.or":"or search public themes","ui.setup.create-project.theme.search":"Search themes","ui.setup.create-project.theme.more":"More themes","ui.setup.create-project.theme.empty":"No themes matching {query}","ui.setup.create-project.theme.uploaded":"The theme file was uploaded successfully.","ui.setup.create-project.theme.packageName":"Package name","ui.setup.create-project.theme.version":"Верзија","ui.setup.create-project.theme.authors":"Author(s)","ui.setup.create-project.install":"Install","ui.setup.create-project.cancel":"Откажи","ui.setup.database-connection.headline":"Database Connection","ui.setup.database-connection.description":"Contao requires a MySQL database (or a compatible fork like MariaDB) to store pages, content, users and other relational data. Connection parameters are stored in the {env} file in the project root of your Contao installation.","ui.setup.database-connection.formTitle":"Connection Parameters","ui.setup.database-connection.formText":"Enter a database URL or fill in the username, password, server and database fields separately.","ui.setup.database-connection.url":"Database URL","ui.setup.database-connection.validUrl":"Database URL is invalid or connection to server failed.","ui.setup.database-connection.or":"or","ui.setup.database-connection.user":"Корисничко име","ui.setup.database-connection.password":"Лозинка","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Database Name","ui.setup.database-connection.connected":"Successfully connected to database {database} on {server}.","ui.setup.database-connection.error":"Error connecting to the database.","ui.setup.database-connection.problem":"Contao has detected a problem with your database server.","ui.setup.database-connection.schemaTitle":"Database Schema","ui.setup.database-connection.migration":"There is one pending migration. | There are {count} pending migrations.","ui.setup.database-connection.schema":"There is one pending schema update. | There are {count} pending schema updates.","ui.setup.database-connection.noChanges":"Your database schema is up to date.","ui.setup.database-connection.check":"Check database","ui.setup.database-connection.skip":"Skip","ui.setup.database-connection.save":"Сачувај","ui.setup.database-connection.change":"Change credentials","ui.setup.database-connection.restoreTitle":"Database Import","ui.setup.database-connection.restoreText":"The theme you just installed contains a database backup. Restore the database to import theme data or skip this step to start with a blank Contao installation. | The theme you just installed contains multiple database backups. Select a backup file to import theme data or skip this step to start with a blank Contao installation.","ui.setup.database-connection.backup":"Backup current database before import","ui.setup.database-connection.backupWarning":"All data in database will be overwritten on import! Create a backup first if the database is not empty.","ui.setup.database-connection.restore":"Import theme database","ui.setup.database-connection.restoreOption":"Backup from {date} ({size})","ui.setup.database-connection.restored":"Your theme database was successfully imported. Continue to validate your database schema.","ui.setup.backend-user.success":"An admin account for the Contao back end was found in your database. Use the Contao back end to add more users.","ui.setup.backend-user.error":"Unable to retrieve user list. Check the console output for details.","ui.setup.backend-user.headline":"Backend Account","ui.setup.backend-user.description":"To manage your website, you need to have at least one admin account for the Contao back end. Be aware that this account is not related to the Contao Manager.","ui.setup.backend-user.formTitle":"Креирај налог","ui.setup.backend-user.formText":"Please enter the details for the new back end account.","ui.setup.backend-user.username":"Корисничко име","ui.setup.backend-user.name":"Name","ui.setup.backend-user.email":"E-mail address","ui.setup.backend-user.emailInvalid":"Please enter a valid e-mail address","ui.setup.backend-user.password":"Лозинка","ui.setup.backend-user.passwordPlaceholder":"мин. 8 знакова","ui.setup.backend-user.passwordLength":"Унесите барем 8 знакова.","ui.setup.backend-user.create":"Add account","ui.task.headline":"Позадински задаци","ui.task.loading":"Учитавам детаље...","ui.task.created":"Учитавам детаље...","ui.task.active":"Сачекајте док Contao Manager заврши са позадинским задацима и операцијама.","ui.task.complete":"Сви задаци су успешно завршени. За више детаља, проверите излаз конзоле.","ui.task.aborting":"Сачекајте док се позадински задаци не откажу.","ui.task.stopped":"Неки позадински задаци су отказани. Проверите излаз конзоле.","ui.task.error":"Позадински задатак је неочекивано заустављен. Проверите излаз конзоле.","ui.task.failed":"Contao Manager није успео да покрене позадински задатак!","ui.task.failedDescription1":"Нешто је кренуло погрешно приликом извршавања операција у позадини.","ui.task.failedDescription2":"Ако се ово деси поново, Ваш сервер можда не подржава инсталацију.","ui.task.reportProblem":"Пријави проблем","ui.task.sponsor":"Composer Cloud sponsored by {sponsor}","ui.task.buttonAudit":"Ажурирај базу података","ui.task.buttonClose":"Затвори","ui.task.buttonConfirm":"Потврди и затвори","ui.task.buttonCancel":"Откажи","ui.task.confirmCancel":"Да ли сте сигурни да желите да откажете задатак? Ово ће можда довести до тога да Contao инсталација не буде комплетна.","ui.task.autoclose":"Затвори детаље задатка након успешног завршетка.","ui.console.toggle":"Прикажи/Сакриј конзолу","ui.console.showLog":"Прикажи сав лог конзоле","ui.console.copyLog":"Копирај лог у привремену меморију.","ui.migrate.headline":"Database Updates","ui.migrate.migrationsOnly":"(migrations only)","ui.migrate.schemaOnly":"(schema only)","ui.migrate.loading":"Please wait, we are checking your database …","ui.migrate.empty":"No pending migrations or schema updates found. Your database is up to date.","ui.migrate.emptyMigrations":"No pending migrations found. Make sure to also check for schema updates.","ui.migrate.emptySchema":"No pending schema updates found. Make sure to also check for migrations.","ui.migrate.pending":"Your database is not up to date. Please review the console output below and execute the changes.","ui.migrate.previousChanges":"A previous database migration was not confirmed.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.previousComplete":"A previous database migration was not confirmed, please review the console output below.\\nThere are no more pending changes.","ui.migrate.appliedChanges":"Database updates have been applied.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.appliedComplete":"Database updates have been applied.\\nThere are no more pending migrations or schema updates. Your database is up to date.","ui.migrate.problem":"Contao has detected a problem with your database server.\\nPlease review the console output below to find out what needs to be fixed. | Contao has detected problems with your database server.\\nPlease review the console output below to find out what needs to be fixed.","ui.migrate.warning":"Contao has detected a misconfiguration of your database server.\\nWarnings can be skipped temporarily, but should be fixed for optimal performance and data integrity.","ui.migrate.error":"The changes could not be applied. Your database might have been changed, please check again to retry.","ui.migrate.execute":"Execute","ui.migrate.close":"Затвори","ui.migrate.confirm":"Потврди и затвори","ui.migrate.cancel":"Откажи","ui.migrate.continue":"Настави","ui.migrate.setup":"Покретање инсталације","ui.migrate.skip":"Skip","ui.migrate.retry":"Check again","ui.migrate.retryAll":"Check all","ui.migrate.withDeletes":"Execute all database changes including DROP queries.","ui.migrate.migrationTitle":"Database Migrations","ui.migrate.schemaTitle":"Schema Updates","ui.migrate.problemTitle":"Database Problems","ui.migrate.warningTitle":"Database Warnings","ui.migrate.addTable":"Add table {table}","ui.migrate.dropTable":"Drop table {table}","ui.migrate.addField":"Add field {table}.{field}","ui.migrate.changeField":"Change field {table}.{field}","ui.migrate.dropField":"Drop field {table}.{field}","ui.migrate.createIndex":"Create index \\"{name}\\" on {table}","ui.migrate.dropIndex":"Drop index \\"{name}\\" on {table}","ui.widget.mandatory":"Ово поље не сме бити празно.","ui.widget.blankOption":"Одаберите...","ui.widget.showPassword":"Show password","ui.widget.hidePassword":"Hide password","ui.error.title":"HTTP захтев за \\"{method} {url}\\" није успео.","ui.error.server500":" Изгледа да се десила нека неочекивана грешка на серверу. Проверите логове на Вашем серверу  (Apache/Nginx) и логове Contao Manager на локацији \\"contao-manager/logs\\".","ui.error.response":"Сервер је договорио са кодом  {status}.","ui.error.moreLink":"Више информација","ui.error.support":"Подршка за  Contao","ui.footer.help":"Помоћ","ui.footer.reportProblem":"Пријави проблем","ui.navigation.discover":"Истражи","ui.navigation.packages":"Пакети","ui.navigation.tools":"Алати","ui.navigation.installTool":"Алат за инсталацију","ui.navigation.backend":"Contao БекЕнд","ui.navigation.debug":"Contao мод за дебаговање","ui.navigation.logViewer":"Log Viewer","ui.navigation.phpinfo":"Информације о PHP","ui.navigation.phpinfoLoading":"Loading PHP Information…","ui.navigation.maintenance":"Одржавање","ui.navigation.rebuildCache":"Поновно креирај кеш","ui.navigation.systemCheck":"Провера система","ui.navigation.advanced":"Напредно","ui.navigation.logout":"Одјава","ui.maintenance.database.title":"Database Migrations and Backups","ui.maintenance.database.description":"Database migrations ensure consistent data and table schemas.","ui.maintenance.database.migrations":"One pending database migration | {count} pending database migrations","ui.maintenance.database.schemaUpdates":"One pending schema update | {count} pending schema updates","ui.maintenance.database.error":"Database problem found.","ui.maintenance.database.warning":"Database warnings found.","ui.maintenance.database.button":"Check database","ui.maintenance.database.migrationOnly":"Check migrations only","ui.maintenance.database.schemaOnly":"Check schema only","ui.maintenance.database.installTool":"Open Install Tool","ui.maintenance.database.createBackup":"Create Backup","ui.maintenance.database.backupUnsupported":"Database backups are not supported by your Contao version.","ui.maintenance.database.backupList":"You have one database backup, created on {date}. | You have {count} database backups, the latest one was created on {date}.","ui.maintenance.database.backupEmpty":"You currently have no database backups.","ui.maintenance.rebuildCache.title":"Апликативни cache","ui.maintenance.rebuildCache.description":"Поновно креирање апликативног cache-a је потребно сваки пут када мењате било који конфигурациони фајл.","ui.maintenance.rebuildCache.rebuildProd":"Обнови продукциони Cache","ui.maintenance.rebuildCache.rebuildDev":"Обнови развојни Cache","ui.maintenance.rebuildCache.clearProd":"Обриши продукциони Cache","ui.maintenance.rebuildCache.clearDev":"Обриши развојни Cache","ui.maintenance.installTool.title":"Инсталациони алат за Contao","ui.maintenance.installTool.description":"Инсталациони алат за Contao је аутоматски закључан ако три пута заредом погрешите лозинку.","ui.maintenance.installTool.unlock":"Откључај Инсталациони алат","ui.maintenance.installTool.lock":"Закључај Инсталациони алат","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"The Composer autoloader је одговоран за учитавање PHP класа.  Аutoloader мора бити испражњен након додавања властитих namespaces у root composer.json.","ui.maintenance.dumpAutoload.button":"Испразни Autoloader","ui.maintenance.composerInstall.title":"Композер зависности - dependencies","ui.maintenance.composerInstall.description":"Композер зависности су смештене у фолдер {vendor} у root фолдеру ваше апликације. Реинсталирање зависности ће можда бити неопходно након измене или ручног копирања на сервер фајла {composerLock}.","ui.maintenance.composerInstall.button":"Покрени Инсталер","ui.maintenance.composerInstall.update":"Покрени ажурирање Композера","ui.maintenance.composerCache.title":"Композер Cache","ui.maintenance.composerCache.description":"Композер кешира преузете пакете како би побољшао перформансе. Ако имате проблеме са непотпуним фајловима, покушајте да обришете cache Композера како бисте га присилили на поновно преузимање читавог пакета.","ui.maintenance.composerCache.button":"Обриши Cache","ui.maintenance.maintenanceMode.title":"Maintenance Mode","ui.maintenance.maintenanceMode.description":"Putting Contao in maintenance mode will display a \\"503 Service Unavailable\\" template for the website.","ui.maintenance.maintenanceMode.enable":"Enable","ui.maintenance.maintenanceMode.disable":"Disable","ui.maintenance.debugMode.title":"Мод за дебаговање","ui.maintenance.debugMode.description":"Активирајте мод за дебаговање тако што ћете поставити корисничко име и лозинку за улазну тачку {appDevPhp}.","ui.maintenance.debugMode.descriptionJwt":"Активирајте debug мод тако што ћете поставити debug колачић за тренутни домен.","ui.maintenance.debugMode.activate":"Активирај","ui.maintenance.debugMode.deactivate":"Деактивирај","ui.maintenance.debugMode.credentials":"Креденцијали","ui.maintenance.debugMode.user":"Унесите корисничко име за Мод за дебаговање.","ui.maintenance.debugMode.password":"Унесите лозинку за Мод за дебаговање.","ui.maintenance.opcodeCache.title":"Opcode Cache","ui.maintenance.opcodeCache.description":"Opcode кешира PHP фајлове ради бржег извршавања. У неким околностима мора бити обрисан ако фајлови нису препознати након измене.","ui.maintenance.opcodeCache.button":"Испразни Cache","ui.maintenance.safeMode":"Није доступно у Safe Mode","ui.maintenance.unsupported":"Није подржан у вашој верзији Contao","ui.packages.updateButton":"Ажурирај Пакете","ui.packages.searchButton":"Претрага пакета","ui.packages.searchPlaceholder":"Претрага Пакета...","ui.packages.uploadOverlay":"Превуците & пустите фајлове да бисте их пренели на сервер","ui.packages.uploadButton":"Постави пакете","ui.packages.uploadMessage":"Имате непотврђено пребацивање на сервер. | Имате {count} непотврђених пребацивања на сервер.","ui.packages.uploadApply":"Потврди преносе","ui.packages.uploadReset":"Обриши преносе","ui.packages.uploadIncomplete":"Фајл није пренесен у потпуности. Уклоните га и пробајте поново.","ui.packages.uploadDuplicate":"Изгледа да је овај фајл пренесен неколико пута. Уклоните дупликате.","ui.packages.uploadInstalled":"Овај фајл је већ инсталиран. Уклоните дупликате.","ui.packages.uploadUnsupported":"Uploads are not supported in your installation. Please make sure that the PHP ZIP extension is installed and update your dependencies.","ui.packages.changesMessage":"Имате једну непотврђену промену. | Имате {count} непотврђених промена.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"Примени промене","ui.packages.changesApplyAll":"Ажурирај све пакете","ui.packages.changesDryrunAll":"Обави \\"dry-run\\" симулацију свих пакета.","ui.packages.changesReset":"Врати на почетно стање","ui.packages.changesReview":"Прегледај промене","ui.packagelist.loading":"Учитавам ...","ui.packagelist.uploads":"Преноси","ui.packagelist.added":"Нови пакети","ui.packagelist.installed":"Инсталирани пакети","ui.package.hintRevert":"Опозови измене","ui.package.hintNoupdate":"Не ажурирај","ui.package.hintConstraint":"Када сачувате измене, овај пакет ће бити инсталиран са ограничењима {constraint}.","ui.package.hintConstraintBest":"Када сачувате измене, овај пакет ће бити инсталиран са најбољом доступном верзијом.","ui.package.hintConstraintChange":"Када сачувате измене, ограничење овог пакета биће промењено из \\"{from}\\" у \\"{to}\\" .","ui.package.hintConstraintUpdate":"Ови пакети ће бити ажурирани када потврдите измене.","ui.package.hintAdded":"Ови пакети ће бити инсталирани када потврдите измене.","ui.package.hintRemoved":"Када сачувате измене, овај пакет ће бити уклоњен.","ui.package.requiredTitle":"ручно додати","ui.package.requiredText":"Овај пакет је захтеван у Вашем composer.json али није инсталиран.","ui.package.removedTitle":"ручно уклоњено","ui.package.removedText":"Овај пакет је уклоњен из вашег composer.json.","ui.package.installed":"Тренутно инсталирано:","ui.package.version":"Верзија {version}","ui.package.additionalDownloads":"{count} Преузимање | {count} Преузимања","ui.package.additionalStars":"{count} Звезда | {count} Звезде","ui.package.editConstraint":"Уреди","ui.package.uploadConstraint":"Ова зависности је дефинисана од пренесеног пакета.","ui.package.updateButton":"Ажурирај","ui.package.removeButton":"Уклони","ui.package.installButton":"Додај пакет","ui.package.installButtonShort":"Додавање","ui.package.detailsButton":"Детаљи","ui.package.latestConstraint":"последња верзија","ui.package.update":"Доступно је ажурирање","ui.package.updateLatest":"последња верзија","ui.package.updateAvailable":"{version} доступна","ui.package.updateUnknown":"непозната верзија","ui.package.updateConstraint":"A newer version outside your version constraint is available.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Верзија {version}","ui.cloudStatus.waitingTime":"Време чекања","ui.cloudStatus.jobs":"Тренутни задаци","ui.cloudStatus.workers":"Радници","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"нема","ui.cloudStatus.short":"ca. {minutes} min","ui.cloudStatus.long":"ca. {minutes} min {seconds} sec","ui.cloudStatus.error":"Није могуће проверити стање сервиса Composer Resolver Cloud. Можда је у току одржавање или постоје проблеми.","ui.cloudStatus.button":"Статус Cloud-а","ui.cloudStatus.refresh":"Освежи статус Cloud-а","ui.log-viewer.loading":"Учитавам ...","ui.log-viewer.empty":"There are no log files on your server.","ui.log-viewer.reload":"Reload","ui.log-viewer.file":"Log file","ui.log-viewer.channel":"Channel","ui.log-viewer.channelTitle":"The channel this message was logged to.","ui.log-viewer.level":"Level","ui.log-viewer.levelTitle":"Severity of the log message.","ui.log-viewer.timeHeader":"Time","ui.log-viewer.messageHeader":"Message","ui.log-viewer.showContext":"Show Context","ui.log-viewer.hideContext":"Hide Context","ui.log-viewer.showExtra":"Show Extra","ui.log-viewer.hideExtra":"Hide Extra","ui.log-viewer.more":"Load more …","ui.log-viewer.download":"Download","ui.log-viewer.downloadTitle":"Download file \\"{file}\\"","ui.log-viewer.prodEnvironment":"Production Environment","ui.log-viewer.devEnvironment":"Development Environment (Debug Mode)"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[560],{1560:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Nedrošs savienojums !!","ui.app.httpsDescription":"Bez HTTPS jūsu konfidenciālie dati tiks pārsūtīti nešifrēti.","ui.app.httpsLink":"Vairāk informācijas","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Ieslēgts drošais režīms !!","ui.app.safeModeDescription":"Dažas Contao Manager funkcijas nav pieejamas.","ui.app.safeModeExit":"Iziet no drošā režīma","ui.app.loading":"Ielādē Contao pārvaldnieku ...","ui.app.apiError":"Negaidīts API statuss","ui.app.configSecurity1":"DROŠĪBAS BRĪDINĀJUMS !!! Konstatēts neaizsargāts konfigurācijas direktorijs","ui.app.configSecurity2":"The Contao Manager has detected that its config files are publicly accessible. All operations are disabled until the directory is secured, otherwise an attacker could access sensitive data of your installation.\\n\\nTo fix this issue, make sure to prevent access to the \\"contao-manager\\" directory on your server. To learn how to do this, please refer to the manual of your webserver or contact your hosting provider.","ui.account.welcome":"Laipni lūdzam","ui.account.intro1":"Laipni lūgti Contao pārvaldniekā, kas ir universāls rīks Contao atvērtā koda CMS instalēšanai un pārvaldībai. Ja esat jauns lietotājs, lūdzu, {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual}, lai sāktu","ui.account.introManual":"izlasiet rokasgrāmatu","ui.account.intro2":"Ja jums rodas kādas problēmas, pārbaudiet {ourGithubIssues} un nekautrējieties izveidot jaunu problēmu, ja par to vēl nav ziņots.","ui.account.introIssues":"mūsu GitHub problēmas","ui.account.headline":"Lietotāja konts","ui.account.description":"Lai pārvaldītu savu instalāciju, lūdzu, izveidojiet Contao pārvaldnieka kontu. Ņemiet vērā, ka šis konts nav saistīts ar Contao aizmuguri vai priekšu.","ui.account.username":"Lietotājvārds","ui.account.password":"Parole","ui.account.passwordPlaceholder":"min. 8 rakstzīmes","ui.account.passwordLength":"Lūdzu, ievadiet vismaz 8 rakstzīmes.","ui.account.submit":"Izveidot kontu","ui.account.contribute1":"Contao un Contao Manager sponsorē bezpeļņas organizācija Contao Association.","ui.account.contribute2":"Lūdzu, apsveriet iespēju sniegt ieguldījumu atvērtajā pirmkodā {donate}.","ui.account.contributeDonate":"ziedojuma veikšana","ui.login.headline":"Pierakstīties","ui.login.description":"Pierakstīties, lai pārvaldītu savu instalāciju.","ui.login.username":"Lietotājvārds","ui.login.password":"Parole","ui.login.forgotPassword":"Aizmirsāt paroli?","ui.login.button":"Pierakstīties","ui.login.locked":"Piekļuve ir liegta, jo Contao Manager ir bloķēts. Lai atbloķētu, izdzēsiet {lockFile} datni Contao galvenajā direktorijā.","ui.logout.headline":"Sesijas laika limits","ui.logout.warning":"Jūs esat bijis neaktīvs ilgāk par 25 minūtēm. Drošības apsvērumu dēļ jūsu sesija drīz tiks pārtraukta.","ui.logout.expired":"Jūsu sesija tika automātiski pārtraukta, jo esat bijis neaktīvs ilgāk par 30 minūtēm.","ui.logout.renew":"Palikt pieteikušamies","ui.logout.logout":"Izrakstīties","ui.logout.login":"Atpakaļ uz pieteikšanos","ui.oauth.error":"Nederīgs OAuth mēģinājums. Pārbaudiet pieprasījuma parametrus.","ui.oauth.https":"The redirect URI MUST use a secure protocol (https:) to prevent the authentication token from being transmitted in clear-text.","ui.oauth.headline":"Attālā autentifikācija","ui.oauth.description":"Šāda lietojumprogramma vai pakalpojums pieprasa attālo piekļuvi jūsu Contao Manager instancei.","ui.oauth.domain":"Pirms atļaujat piekļuvi, pārliecinieties, ka zināt šo URL un uzticaties tā īpašniekam!","ui.oauth.allow":"Atļaut piekļuvi","ui.oauth.deny":"Liegt piekļuvi","ui.boot.headline":"Sistēmas pārbaude","ui.boot.description":"Lūdzu, uzgaidiet, mēs analizējam jūsu serveri ...","ui.boot.issue1":"Konstatētās  instalēšanas problēmas","ui.boot.issue2":"Jūsu instalācijā ir problēmas, kas jānovērš, pirms var izmantot Contao Manager.","ui.boot.run":"Palaist Contao pārvaldnieku","ui.boot.safeMode":"Palaist drošajā režīmā","ui.recovery.headline":"Sistēmas atkopšana","ui.recovery.description":"Contao Manager atklāja datnes, kas izskatās kā Contao, bet komandrindas saskarne nedarbojas, kā paredzēts.","ui.recovery.console":"Konsoles izvade","ui.recovery.repairOptions":"Lūdzu, izvēlieties iespēju, lai salabotu instalāciju.","ui.recovery.repairHeadline":"Automātiskā izlabošana","ui.recovery.repairDescription":"Mēģina automātiski labot instalāciju, atjaunojot lietojumprogrammu kešatmiņu un atkārtoti instalējot Composer paketes.","ui.recovery.repairWarning":"Procesa laikā var tikt dzēstas visas piegādātāja datņu izmaiņas!","ui.recovery.repairFailed":"Automātiskā labošana nebija veiksmīga. Izmēģiniet instalāciju labot manuāli drošajā režīmā.","ui.recovery.repairButton":"Palaist sistēmas izlabošanu","ui.recovery.safeModeHeadline":"Drošais režīms","ui.recovery.safeModeDescription":"Programmas Contao Manager palaišana drošajā režīmā ļauj pārvaldīt paketes un veikt dažus uzturēšanas uzdevumus, taču funkcijas, kas ir atkarīgas no darbojošās Contao instalācijas, nebūs pieejamas.","ui.recovery.safeModeButton":"Palaist drošajā režīmā","ui.server.pending":"Gaida ...","ui.server.running":"Analizē ...","ui.server.error":"Pārbaude neizdevās, jo no servera saņemta neparedzēta atbilde.","ui.server.details":"Sīkāka informācija","ui.server.prerequisite":"Pārbaude atcelta trūkstošā priekšnosacījuma dēļ.","ui.server.selfUpdate.title":"Contao pārvaldnieka atjauninājumi","ui.server.selfUpdate.update":"Ir pieejama jauna Contao pārvaldnieka versija {latest}.","ui.server.selfUpdate.manualUpdate":"Ir pieejama jauna Contao Manager versija {latest}. Jūsu serveris neatbalsta automātiskus atjauninājumus, lūdzu, lejupielādējiet jauno versiju no {download}.","ui.server.selfUpdate.latest":"Jūs izmantojat jaunāko versiju {current}.","ui.server.selfUpdate.dev":"Izstrādes būves neatbalsta automātiskus atjauninājumus.","ui.server.selfUpdate.unsupported":"Ir pieejama jauna versija, taču tā neatbalsta jūsu PHP versiju.","ui.server.selfUpdate.button":"Palaist pašatjauninājumu","ui.server.selfUpdate.continue":"Turpināt","ui.server.config.title":"Servera konfigurācija","ui.server.config.setup":"Konfigurēt","ui.server.config.change":"Mainīt","ui.server.config.save":"Saglabāt","ui.server.config.cancel":"Atcelt","ui.server.config.customOption":"Cits ...","ui.server.config.description":"To correctly run background tasks, the Contao Manager needs to know where to find the PHP command line binary and how to run commands separated from the web process.","ui.server.config.formTitle":"Servera konfigurācija","ui.server.config.formText":"Please enter the path to your PHP binary. Make sure the binary is the same PHP version as your web process.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"The Composer Resolver Cloud allows to install Composer dependencies even if your server does not provide enough local memory. Please be aware that your package information will be transmitted to a cloud server operated by the Contao Association.","ui.server.config.cloud":"Izmantot Composer Resolver Cloud","ui.server.config.cli":"PHP binārs","ui.server.config.stateErrorCli":"Serverī netika atrasts derīgs PHP binārs.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud netiek atbalstīts.","ui.server.config.stateSuccess":"PHP binārais kodols {php_cli}.","ui.server.php_web.title":"PHP Web process","ui.server.php_web.below7":"Atrasta PHP versija {versija}. Lūdzu, pēc iespējas ātrāk pārejiet uz PHP 7!","ui.server.php_web.success":"Atrasta PHP versija {versija}, neviena zināma problēma nav atrasta.","ui.server.php_cli.title":"PHP komandrindas saskarne","ui.server.php_cli.success":"Atrasta PHP versija {versija}, neviena zināma problēma nav atrasta.","ui.server.composer.title":"Composer vide","ui.server.composer.success":"Netika atrastas zināmas problēmas.","ui.server.composer.install":"Composer dependencies are not installed.","ui.server.composer.button":"Uzstādīt","ui.server.contao.title":"Contao instalācija","ui.server.contao.setup":"Uzstādīt","ui.server.contao.check":"Pārbaudīt datubāzi","ui.server.contao.empty":"Neviena Contao instalācija nav atrasta.","ui.server.contao.old":"Contao versija {versija} nav savietojama ar Contao pārvaldnieku, lūdzu, manuāli atjauniniet instalāciju.","ui.server.contao.found":"Atrasts Contao {versija} (API versija {api}).","ui.server.contao.connectionError":"Nevar izveidot savienojumu ar datubāzes serveri.","ui.server.contao.connectionProblem":"Atrasta datubāzes problēma.","ui.server.contao.missingUser":"Administratora konts nav atrasts.","ui.setup.continue":"Turpināt","ui.setup.manager":"Palaist Contao pārvaldnieku","ui.setup.cancel":"Atcelt","ui.setup.welcome":"Laipni lūdzam","ui.setup.welcome1":"This wizard will take you through the necessary steps to set up your Contao Open Source CMS installation.","ui.setup.welcome2":"If you have any questions, please find documentation, forums, a Slack channel and more on the {support} page.","ui.setup.support":"kopienas atbalsts","ui.setup.start":"Sākt","ui.setup.complete":"Apsveicam!","ui.setup.complete1":"Contao {versija} ir veiksmīgi instalēta.","ui.setup.complete2":"To finish the setup process, please open the install tool to configure the database connection and create a back end user.","ui.setup.complete3":"You can now start to create your website in the Contao back end. If you need additional extensions, continue to the Contao Manager.","ui.setup.installTool":"Atveriet instalēšanas rīku","ui.setup.login":"Pieslēgties Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". An Open Source project like Contao requires amounts of money that can\'t be raised by a single person or company.\\nIf you have a website or sell websites built with Contao, we would love to see you contribute back financially to the product your business relies upon.","ui.setup.fundingLink":"Uzzināt vairāk","ui.setup.document-root.headline":"Tīmekļa servera iestatīšana","ui.setup.document-root.warning":"Lai instalētu Contao, izmantojot Contao Manager, tīmekļa serverī ir jānosaka dokumenta sakne.","ui.setup.document-root.description1":"Contao uses a separate folder for public files, application files are installed in its parent folder. Contao cannot be installed if the folder structure is not correct or the folders are not empty.","ui.setup.document-root.description2":"Ja nezināt, kā konfigurēt dokumentu sakni, izlasiet Contao dokumentāciju vai sazinieties ar savu hostinga pakalpojumu sniedzēju.","ui.setup.document-root.documentation":"Izlasiet dokumentāciju","ui.setup.document-root.conflictsTitle":"Instalācijas direktorijs nav tukšs","ui.setup.document-root.conflictsDirectory":"The root directory of your future Contao installation is not empty, we have found {count} file(s) that might be overwritten by the installation process. It is recommended to create an empty directory structure for Contao, but you can also remove the following files and check again if you are sure they are unused.","ui.setup.document-root.ignoreConflicts":"I want to install Contao into the non-empty directory. I understand that this might overwrite any existing files on my webspace.","ui.setup.document-root.check":"Pārbaudiet vēlreiz","ui.setup.document-root.create":"Izveidot direktorijus","ui.setup.document-root.change":"Change directories","ui.setup.document-root.formTitle":"Direktoriju iestatīšana","ui.setup.document-root.formText1":"Contao Manager var automātiski izveidot jaunu direktoriju struktūru serverī.","ui.setup.document-root.formText2":"Jums būs manuāli jākonfigurē jaunā dokumenta sakne (piemēram, izmantojot hostinga administratora paneli).","ui.setup.document-root.autoconfig":"Es saprotu, ka man ir jāmaina servera konfigurācija. Dokumenta saknes nekonfigurēšana sabojās Contao Manager un atklās konfigurācijas failus (tostarp konta informāciju un paroles)!","ui.setup.document-root.directory":"Jauns direktorijs","ui.setup.document-root.currentRoot":"Pašreizējā dokumenta sakne","ui.setup.document-root.newRoot":"Jauna dokumenta sakne","ui.setup.document-root.finish":"Direktoriju iestatīšana","ui.setup.document-root.publicDir":"Izmantojiet {dir} publiskajām datnēm (Contao {version})","ui.setup.document-root.directoryInvalid":"Lūdzu, ievadiet derīgu direktorija nosaukumu.","ui.setup.document-root.directoryExists":"Mērķa direktorijs jau pastāv. Lūdzu, ievadiet citu nosaukumu.","ui.setup.document-root.confirmation":"Contao pārvaldnieks ir veiksmīgi izveidojis nepieciešamo direktoriju jūsu Contao instalācijai. Tagad jums ir jākonfigurē dokumenta sakne tīmekļa serverī. Līdz tam nepārlādējiet šo lapu no jauna.","ui.setup.document-root.reload":"Pārlādēt lapu","ui.setup.document-root.success":"The directory structure on your web server is set up correctly!","ui.setup.document-root.installingProjectDir":"Lietojumprogrammas datnes tiks instalētas {dir}.","ui.setup.document-root.installingPublicDir":"Publiskās datnes tiks instalētas {dir}.","ui.setup.document-root.installedProjectDir":"Lietojumprogrammas datnes ir instalētas {dir}.","ui.setup.document-root.installedPublicDir":"Publiskās datnes ir instalētas {dir}.","ui.setup.create-project.headline":"Contao instalācija","ui.setup.create-project.description":"Contao development follows the principle of {semver}, a new minor version is released every six months. The currently supported releases are:","ui.setup.create-project.semver":"Semantic Versioning","ui.setup.create-project.latestTitle":"Jaunākais","ui.setup.create-project.ltsTitle":"Ilgtermiņa atbalsts","ui.setup.create-project.latestQ1":"Our latest version, offers the most features with support until February {year}.","ui.setup.create-project.latestQ3":"Our latest version, offers the most features with support until August {year}.","ui.setup.create-project.ltsText":"Our current LTS version, if you focus on stability. Offers long term support until February {year}.","ui.setup.create-project.pltsText":"The previous LTS version, still has long term support until February {year}.","ui.setup.create-project.requiresPHP":"Requires at least PHP {version}, you have PHP {current}.","ui.setup.create-project.requiresDocroot":"Dokumenta saknei jābūt \\"{folder}\\".","ui.setup.create-project.releaseplan":"Sīkāku informāciju skatiet {contaoReleasePlan}.","ui.setup.create-project.releaseplanLink":"Contao izlaišanas plāns","ui.setup.create-project.installed":"Contao {version} is successfully installed on the server. Continue to set up your database or launch the Contao Manager to install a different version.","ui.setup.create-project.formTitle":"Izvēlēties distribūciju","ui.setup.create-project.formText":"Lūdzu, izvēlieties, kura versija jāuzstāda.","ui.setup.create-project.version":"Versija","ui.setup.create-project.demo":"Install the Contao demo website","ui.setup.create-project.demoDescription":"The demo website helps you to get familiar with Contao and all of its core features. More themes can be found in the {store}.","ui.setup.create-project.coreOnly":"Minimāla instalācija (tikai Core)","ui.setup.create-project.noUpdate":"Izlaist instalāciju (tikai eksperts!)","ui.setup.create-project.theme":"Contao Theme","ui.setup.create-project.themeInstall":"To install a Contao theme, use the search input or upload a theme file (.cto/.zip) that supports installation through the Contao Manager.","ui.setup.create-project.themeBuy":"Make sure to visit the official {store}.","ui.setup.create-project.themeStore":"Contao Themes Store","ui.setup.create-project.themeUpload":"Upload theme file (.cto/.zip)","ui.setup.create-project.themeInvalid":"The uploaded file is not a Contao theme or does not support the Contao Manager.","ui.setup.create-project.themeWarning":"The Contao Manager cannot tell whether this theme is compatible with your server. Please check with the theme vendor if you have any questions.","ui.setup.create-project.themeTitle":"Review theme details","ui.setup.create-project.themeDetails":"The following dependencies and files will be installed with this theme.","ui.setup.create-project.themeRequire":"{count} Dependencies | {count} Dependencies","ui.setup.create-project.themeFiles":"{count} File | {count} Files","ui.setup.create-project.theme.or":"or search public themes","ui.setup.create-project.theme.search":"Search themes","ui.setup.create-project.theme.more":"More themes","ui.setup.create-project.theme.empty":"No themes matching {query}","ui.setup.create-project.theme.uploaded":"The theme file was uploaded successfully.","ui.setup.create-project.theme.packageName":"Package name","ui.setup.create-project.theme.version":"Versija","ui.setup.create-project.theme.authors":"Author(s)","ui.setup.create-project.install":"Uzstādīt","ui.setup.create-project.cancel":"Atcelt","ui.setup.database-connection.headline":"Datubāzes savienojums","ui.setup.database-connection.description":"Contao requires a MySQL database (or a compatible fork like MariaDB) to store pages, content, users and other relational data. Connection parameters are stored in the {env} file in the project root of your Contao installation.","ui.setup.database-connection.formTitle":"Savienojuma parametri","ui.setup.database-connection.formText":"Ievadiet datubāzes URL vai atsevišķi aizpildiet lietotājvārdu, paroli, serveri un datubāzes laukus.","ui.setup.database-connection.url":"Datubāzes URL","ui.setup.database-connection.validUrl":"Datubāzes URL ir nederīgs vai neizdevās izveidot savienojumu ar serveri.","ui.setup.database-connection.or":"vai","ui.setup.database-connection.user":"Lietotājvārds","ui.setup.database-connection.password":"Parole","ui.setup.database-connection.server":"Serveris (:ports)","ui.setup.database-connection.database":"Datubāzes nosaukums","ui.setup.database-connection.connected":"Successfully connected to database {database} on {server}.","ui.setup.database-connection.error":"Kļūda, savienojoties ar datubāzi.","ui.setup.database-connection.problem":"Contao ir atklājis problēmu ar jūsu datubāzes serveri.","ui.setup.database-connection.schemaTitle":"Database Schema","ui.setup.database-connection.migration":"There is one pending migration. | There are {count} pending migrations.","ui.setup.database-connection.schema":"There is one pending schema update. | There are {count} pending schema updates.","ui.setup.database-connection.noChanges":"Jūsu datubāzes shēma ir aktuāla.","ui.setup.database-connection.check":"Pārbaudīt datubāzi","ui.setup.database-connection.skip":"Izlaist","ui.setup.database-connection.save":"Saglabāt","ui.setup.database-connection.change":"Mainīt akreditācijas datus","ui.setup.database-connection.restoreTitle":"Database Import","ui.setup.database-connection.restoreText":"The theme you just installed contains a database backup. Restore the database to import theme data or skip this step to start with a blank Contao installation. | The theme you just installed contains multiple database backups. Select a backup file to import theme data or skip this step to start with a blank Contao installation.","ui.setup.database-connection.backup":"Backup current database before import","ui.setup.database-connection.backupWarning":"All data in database will be overwritten on import! Create a backup first if the database is not empty.","ui.setup.database-connection.restore":"Import theme database","ui.setup.database-connection.restoreOption":"Backup from {date} ({size})","ui.setup.database-connection.restored":"Your theme database was successfully imported. Continue to validate your database schema.","ui.setup.backend-user.success":"An admin account for the Contao back end was found in your database. Use the Contao back end to add more users.","ui.setup.backend-user.error":"Unable to retrieve user list. Check the console output for details.","ui.setup.backend-user.headline":"Aizmugures konts","ui.setup.backend-user.description":"To manage your website, you need to have at least one admin account for the Contao back end. Be aware that this account is not related to the Contao Manager.","ui.setup.backend-user.formTitle":"Izveidot kontu","ui.setup.backend-user.formText":"Please enter the details for the new back end account.","ui.setup.backend-user.username":"Lietotājvārds","ui.setup.backend-user.name":"Vārds","ui.setup.backend-user.email":"E-pasta adrese","ui.setup.backend-user.emailInvalid":"Lūdzu, ievadiet derīgu e-pasta adresi","ui.setup.backend-user.password":"Parole","ui.setup.backend-user.passwordPlaceholder":"min. 8 rakstzīmes","ui.setup.backend-user.passwordLength":"Lūdzu, ievadiet vismaz 8 rakstzīmes.","ui.setup.backend-user.create":"Pievienot kontu","ui.task.headline":"Fona uzdevums","ui.task.loading":"Ielādē informāciju ...","ui.task.created":"Ielādē informāciju ...","ui.task.active":"Lūdzu, pagaidiet, kamēr Contao Manager fona režīmā tiek veiktas uzdevumu operācijas.","ui.task.complete":"Visas operācijas ir veiksmīgi pabeigtas. Sīkāku informāciju skatiet konsoles izvades failā.","ui.task.aborting":"Lūdzu, uzgaidiet, kamēr tiek atceltas fona operācijas.","ui.task.stopped":"Dažas fona darbības tika atceltas. Lūdzu, pārbaudiet konsoles izvadi.","ui.task.error":"Fona operācija negaidīti apstājās. Lūdzu, pārbaudiet konsoles izvadi.","ui.task.failed":"Contao pārvaldniekam neizdevās palaist fona uzdevumu!","ui.task.failedDescription1":"Mēģinot izpildīt operācijas fonā, kaut kas notika nepareizi.","ui.task.failedDescription2":"Ja tas atkārtojas, iespējams, ka jūsu serveris netiek atbalstīts.","ui.task.reportProblem":"Ziņot par problēmu","ui.task.sponsor":"Composer Cloud sponsored by {sponsor}","ui.task.buttonAudit":"Atjaunināt datubāzi","ui.task.buttonClose":"Aizvērt","ui.task.buttonConfirm":"Apstiprināt & aizvērt","ui.task.buttonCancel":"Atcelt","ui.task.confirmCancel":"Vai noteikti vēlaties atcelt šo uzdevumu? Tas var atstāt jūsu Contao instalāciju bojātā stāvoklī!","ui.task.autoclose":"Aizvērt uzdevuma informāciju pēc izdošanās","ui.console.toggle":"Rādīt/slēpt konsoles izvadi","ui.console.showLog":"Rādīt pilnu konsoles žurnālu","ui.console.copyLog":"Kopēt žurnālu uz starpliktuvi","ui.migrate.headline":"Datubāzes atjauninājumi","ui.migrate.migrationsOnly":"(migrations only)","ui.migrate.schemaOnly":"(schema only)","ui.migrate.loading":"Lūdzu, uzgaidiet, mēs pārbaudām jūsu datubāzi...","ui.migrate.empty":"No pending migrations or schema updates found. Your database is up to date.","ui.migrate.emptyMigrations":"No pending migrations found. Make sure to also check for schema updates.","ui.migrate.emptySchema":"No pending schema updates found. Make sure to also check for migrations.","ui.migrate.pending":"Your database is not up to date. Please review the console output below and execute the changes.","ui.migrate.previousChanges":"A previous database migration was not confirmed.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.previousComplete":"A previous database migration was not confirmed, please review the console output below.\\nThere are no more pending changes.","ui.migrate.appliedChanges":"Database updates have been applied.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.appliedComplete":"Database updates have been applied.\\nThere are no more pending migrations or schema updates. Your database is up to date.","ui.migrate.problem":"Contao has detected a problem with your database server.\\nPlease review the console output below to find out what needs to be fixed. | Contao has detected problems with your database server.\\nPlease review the console output below to find out what needs to be fixed.","ui.migrate.warning":"Contao has detected a misconfiguration of your database server.\\nWarnings can be skipped temporarily, but should be fixed for optimal performance and data integrity.","ui.migrate.error":"The changes could not be applied. Your database might have been changed, please check again to retry.","ui.migrate.execute":"Izpildīt","ui.migrate.close":"Aizvērt","ui.migrate.confirm":"Apstiprināt & aizvērt","ui.migrate.cancel":"Atcelt","ui.migrate.continue":"Turpināt","ui.migrate.setup":"Uzstādīt","ui.migrate.skip":"Izlaist","ui.migrate.retry":"Pārbaudiet vēlreiz","ui.migrate.retryAll":"Atzīmēt visus","ui.migrate.withDeletes":"Izpildīt visas datubāzes izmaiņas, tostarp DROP vaicājumus.","ui.migrate.migrationTitle":"Datubāzu migrācija","ui.migrate.schemaTitle":"Shēmas atjauninājumi","ui.migrate.problemTitle":"Datubāzes problēmas","ui.migrate.warningTitle":"Datubāzes brīdinājumi","ui.migrate.addTable":"Pievienot tabulu {table}","ui.migrate.dropTable":"Nomest tabulu {table}","ui.migrate.addField":"Pievienot lauku {table}.{field}","ui.migrate.changeField":"Mainīt lauku {table}.{field}","ui.migrate.dropField":"Nomest lauku {table}.{field}","ui.migrate.createIndex":"Izveidot indeksu \\"{name}\\" uz {table}","ui.migrate.dropIndex":"Nomest indeksu \\"{name}\\" uz {table}","ui.widget.mandatory":"Šis lauks nedrīkst būt tukšs.","ui.widget.blankOption":"Lūdzu, izvēlieties ...","ui.widget.showPassword":"Rādīt paroli","ui.widget.hidePassword":"Slēpt paroli","ui.error.title":"HTTP pieprasījums \\"{metod} {url}\\" neizdevās.","ui.error.server500":"Looks like an unexpected error happened on your server. Please check the log files of your web server (Apache/Nginx) and the Contao Manager logs at \\"contao-manager/logs\\".","ui.error.response":"Serveris atbildēja ar statusa kodu {status}.","ui.error.moreLink":"Vairāk informācijas","ui.error.support":"Contao atbalsts","ui.footer.help":"Palīdzība","ui.footer.reportProblem":"Ziņot par problēmu","ui.navigation.discover":"Atklāt","ui.navigation.packages":"Pakotnes","ui.navigation.tools":"Rīki","ui.navigation.installTool":"Instalēšanas rīks","ui.navigation.backend":"Contao aizmugure","ui.navigation.debug":"Contao atkļūdošanas režīms","ui.navigation.logViewer":"Log Viewer","ui.navigation.phpinfo":"PHP informācija","ui.navigation.phpinfoLoading":"PHP informācijas ielāde...","ui.navigation.maintenance":"Uzturēšana","ui.navigation.rebuildCache":"Pārbūvēt kešatmiņu","ui.navigation.systemCheck":"Sistēmas pārbaude","ui.navigation.advanced":"Papildu","ui.navigation.logout":"Izrakstīties","ui.maintenance.database.title":"Database Migrations and Backups","ui.maintenance.database.description":"Database migrations ensure consistent data and table schemas.","ui.maintenance.database.migrations":"One pending database migration | {count} pending database migrations","ui.maintenance.database.schemaUpdates":"One pending schema update | {count} pending schema updates","ui.maintenance.database.error":"Atrasta datubāzes problēma.","ui.maintenance.database.warning":"Atrasti datubāzes brīdinājumi.","ui.maintenance.database.button":"Pārbaudīt datubāzi","ui.maintenance.database.migrationOnly":"Pārbaudīt tikai migrācijas","ui.maintenance.database.schemaOnly":"Pārbaudīt tikai shēmu","ui.maintenance.database.installTool":"Atvērt instalēšanas rīku","ui.maintenance.database.createBackup":"Create Backup","ui.maintenance.database.backupUnsupported":"Database backups are not supported by your Contao version.","ui.maintenance.database.backupList":"You have one database backup, created on {date}. | You have {count} database backups, the latest one was created on {date}.","ui.maintenance.database.backupEmpty":"You currently have no database backups.","ui.maintenance.rebuildCache.title":"Lietojumprogrammas kešatmiņa","ui.maintenance.rebuildCache.description":"Rebuilding the application cache is required after modifying any of the configuration files.","ui.maintenance.rebuildCache.rebuildProd":"Ražošanas kešatmiņas pārbūve","ui.maintenance.rebuildCache.rebuildDev":"Izstrādes kešatmiņas pārbūve","ui.maintenance.rebuildCache.clearProd":"Notīrīt ražošanas kešatmiņu","ui.maintenance.rebuildCache.clearDev":"Notīrīt izstrādes kešatmiņu","ui.maintenance.installTool.title":"Contao instalēšanas rīks","ui.maintenance.installTool.description":"Contao instalēšanas rīks tiek automātiski bloķēts, ja trīs reizes pēc kārtas ievadāt nepareizu paroli.","ui.maintenance.installTool.unlock":"Atbloķēt instalēšanas rīku","ui.maintenance.installTool.lock":"Bloķēt instalēšanas rīku","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"The Composer autoloader is responsible for PHP class loading. The autoloader must be dumped after adding custom namespaces to the root composer.json.","ui.maintenance.dumpAutoload.button":"Dump Autoloader","ui.maintenance.composerInstall.title":"Composer Dependencies","ui.maintenance.composerInstall.description":"Composer dependencies are located in the {vendor} folder in your application root. Reinstalling the dependencies can be necessary after manipulation or manually uploading the {composerLock} file.","ui.maintenance.composerInstall.button":"Palaist instalētāju","ui.maintenance.composerInstall.update":"Palaist Composer jauninājumu","ui.maintenance.composerCache.title":"Composer kešatmiņa","ui.maintenance.composerCache.description":"Composer caches downloaded packages for improved performance. If you have issues like broken files, try to delete the Composer cache to force a new download.","ui.maintenance.composerCache.button":"Iztīrīt kešatmiņu","ui.maintenance.maintenanceMode.title":"Uzturēšanas režīms","ui.maintenance.maintenanceMode.description":"Putting Contao in maintenance mode will display a \\"503 Service Unavailable\\" template for the website.","ui.maintenance.maintenanceMode.enable":"Iespējot","ui.maintenance.maintenanceMode.disable":"Atspējot","ui.maintenance.debugMode.title":"Atkļūdošanas režīms","ui.maintenance.debugMode.description":"Activate the debug mode by setting a user and password for the {appDevPhp} entry point.","ui.maintenance.debugMode.descriptionJwt":"Activate the debug mode by setting the debug cookie for the current domain.","ui.maintenance.debugMode.activate":"Aktivizēt","ui.maintenance.debugMode.deactivate":"Deaktivizēt","ui.maintenance.debugMode.credentials":"Akreditācijas dati","ui.maintenance.debugMode.user":"Lūdzu, ievadiet atkļūdošanas režīma lietotājvārdu.","ui.maintenance.debugMode.password":"Lūdzu, ievadiet paroli atkļūdošanas režīmam.","ui.maintenance.opcodeCache.title":"Opcode Cache","ui.maintenance.opcodeCache.description":"Opcode caches PHP files on the web process for faster execution. It must be deleted under certain circumstances if files are not recognized after changing.","ui.maintenance.opcodeCache.button":"Saīsināt kešatmiņu","ui.maintenance.safeMode":"Nav pieejams drošajā režīmā","ui.maintenance.unsupported":"Neatbalsta jūsu Contao versija","ui.packages.updateButton":"Atjaunināt pakotnes","ui.packages.searchButton":"Meklēt pakotnes","ui.packages.searchPlaceholder":"Meklēt pakotnes ...","ui.packages.uploadOverlay":"Lai augšupielādētu, velciet un nometiet failus","ui.packages.uploadButton":"Augšupielādēt pakotnes","ui.packages.uploadMessage":"Jums ir viena neapstiprināta augšupielāde. | Jums ir {count} neapstiprināta/u augšupielāde/žu.","ui.packages.uploadApply":"Apstiprināt augšupielādi","ui.packages.uploadReset":"Dzēst augšupielādes","ui.packages.uploadIncomplete":"Šis datne netika augšupielādēts pilnībā. Lūdzu, noņemiet to un mēģiniet vēlreiz.","ui.packages.uploadDuplicate":"Šķiet, ka šī datne ir augšupielādēts vairākas reizes. Lūdzu, izdzēsiet dublikātus.","ui.packages.uploadInstalled":"Šis datne jau ir instalēta. Lūdzu, izdzēsiet dublikātus.","ui.packages.uploadUnsupported":"Uploads are not supported in your installation. Please make sure that the PHP ZIP extension is installed and update your dependencies.","ui.packages.changesMessage":"You have one unconfirmed change. | You have {count} unconfirmed changes.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"Pielietot izmaiņas","ui.packages.changesApplyAll":"Atjaunināt visas pakotnes","ui.packages.changesDryrunAll":"Dry run all packages","ui.packages.changesReset":"Atiestatīt izmaiņas","ui.packages.changesReview":"Pārskatīt izmaiņas","ui.packagelist.loading":"Ielādē ...","ui.packagelist.uploads":"Augšupielādes","ui.packagelist.added":"Jaunas pakotnes","ui.packagelist.installed":"Instalētās pakotnes","ui.package.hintRevert":"Atgriezt izmaiņas","ui.package.hintNoupdate":"Neatjaunināt","ui.package.hintConstraint":"This package will be installed with constraint {constraint} when you apply the changes.","ui.package.hintConstraintBest":"This package will be installed in the best available version when you apply the changes.","ui.package.hintConstraintChange":"The constraint for this package will be changed from \\"{from}\\" to \\"{to}\\" when you apply the changes.","ui.package.hintConstraintUpdate":"Šī pakotne tiks atjaunināta, kad piemērosiet izmaiņas.","ui.package.hintAdded":"Šī pakotne tiks instalēta, kad piemērosiet izmaiņas.","ui.package.hintRemoved":"Šī pakotne tiks noņemta, kad piemērosiet izmaiņas.","ui.package.requiredTitle":"manuāli pievienots","ui.package.requiredText":"Šī pakotne ir nepieciešama jūsu composer.json, bet nav instalēta.","ui.package.removedTitle":"manuāli noņemts","ui.package.removedText":"Šī pakotne tika noņemta no jūsu composer.json.","ui.package.installed":"Pašlaik instalēts:","ui.package.version":"Versija {version}","ui.package.additionalDownloads":"{count} Lejupielāde | {count} Lejupielādes","ui.package.additionalStars":"{count} Star | {count} Stars","ui.package.editConstraint":"Rediģēt","ui.package.uploadConstraint":"This constraint is defined by the uploaded package.","ui.package.updateButton":"Jaunināt","ui.package.removeButton":"Noņemt","ui.package.installButton":"Pievienot pakotni","ui.package.installButtonShort":"Pievienot","ui.package.detailsButton":"Sīkāka informācija","ui.package.latestConstraint":"jaunākā versija","ui.package.update":"Pieejams atjauninājums","ui.package.updateLatest":"jaunākā versija","ui.package.updateAvailable":"Pieejama {versija}","ui.package.updateUnknown":"nezināma versija","ui.package.updateConstraint":"A newer version outside your version constraint is available.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Versija {version}","ui.cloudStatus.waitingTime":"Gaidīšanas laiks","ui.cloudStatus.jobs":"Pašreizējie darbi","ui.cloudStatus.workers":"Strādnieki","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"nav","ui.cloudStatus.short":"apt. {minutes} min","ui.cloudStatus.long":"apt. {minutes} min {seconds} sek","ui.cloudStatus.error":"Unable to fetch the status of the Composer Resolver Cloud. It might be down for maintenance or experience issues.","ui.cloudStatus.button":"Mākoņa statuss","ui.cloudStatus.refresh":"Atjaunināt mākoņa statusu","ui.log-viewer.loading":"Ielādē ...","ui.log-viewer.empty":"There are no log files on your server.","ui.log-viewer.reload":"Reload","ui.log-viewer.file":"Log file","ui.log-viewer.channel":"Channel","ui.log-viewer.channelTitle":"The channel this message was logged to.","ui.log-viewer.level":"Level","ui.log-viewer.levelTitle":"Severity of the log message.","ui.log-viewer.timeHeader":"Time","ui.log-viewer.messageHeader":"Message","ui.log-viewer.showContext":"Show Context","ui.log-viewer.hideContext":"Hide Context","ui.log-viewer.showExtra":"Show Extra","ui.log-viewer.hideExtra":"Hide Extra","ui.log-viewer.more":"Load more …","ui.log-viewer.download":"Download","ui.log-viewer.downloadTitle":"Download file \\"{file}\\"","ui.log-viewer.prodEnvironment":"Production Environment","ui.log-viewer.devEnvironment":"Development Environment (Debug Mode)"}')}}]);(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[710],{1710:function(e,t,r){
/*!

JSZip v3.10.1 - A JavaScript class for generating and reading zip files
<http://stuartk.com/jszip>

(c) 2009-2016 Stuart Knightley <stuart [at] stuartk.com>
Dual licenced under the MIT license or GPLv3. See https://raw.github.com/Stuk/jszip/main/LICENSE.markdown.

JSZip uses the library pako released under the MIT license :
https://github.com/nodeca/pako/blob/main/LICENSE
*/
!function(t){e.exports=t()}((function(){return function e(t,r,n){function i(a,o){if(!r[a]){if(!t[a]){var h=void 0;if(!o&&h)return require(a,!0);if(s)return s(a,!0);var u=new Error("Cannot find module '"+a+"'");throw u.code="MODULE_NOT_FOUND",u}var l=r[a]={exports:{}};t[a][0].call(l.exports,(function(e){var r=t[a][1][e];return i(r||e)}),l,l.exports,e,t,r,n)}return r[a].exports}for(var s=void 0,a=0;a<n.length;a++)i(n[a]);return i}({1:[function(e,t,r){"use strict";var n=e("./utils"),i=e("./support"),s="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";r.encode=function(e){for(var t,r,i,a,o,h,u,l=[],f=0,c=e.length,d=c,p="string"!==n.getTypeOf(e);f<e.length;)d=c-f,i=p?(t=e[f++],r=f<c?e[f++]:0,f<c?e[f++]:0):(t=e.charCodeAt(f++),r=f<c?e.charCodeAt(f++):0,f<c?e.charCodeAt(f++):0),a=t>>2,o=(3&t)<<4|r>>4,h=1<d?(15&r)<<2|i>>6:64,u=2<d?63&i:64,l.push(s.charAt(a)+s.charAt(o)+s.charAt(h)+s.charAt(u));return l.join("")},r.decode=function(e){var t,r,n,a,o,h,u=0,l=0,f="data:";if(e.substr(0,f.length)===f)throw new Error("Invalid base64 input, it looks like a data url.");var c,d=3*(e=e.replace(/[^A-Za-z0-9+/=]/g,"")).length/4;if(e.charAt(e.length-1)===s.charAt(64)&&d--,e.charAt(e.length-2)===s.charAt(64)&&d--,d%1!=0)throw new Error("Invalid base64 input, bad content length.");for(c=i.uint8array?new Uint8Array(0|d):new Array(0|d);u<e.length;)t=s.indexOf(e.charAt(u++))<<2|(a=s.indexOf(e.charAt(u++)))>>4,r=(15&a)<<4|(o=s.indexOf(e.charAt(u++)))>>2,n=(3&o)<<6|(h=s.indexOf(e.charAt(u++))),c[l++]=t,64!==o&&(c[l++]=r),64!==h&&(c[l++]=n);return c}},{"./support":30,"./utils":32}],2:[function(e,t,r){"use strict";var n=e("./external"),i=e("./stream/DataWorker"),s=e("./stream/Crc32Probe"),a=e("./stream/DataLengthProbe");function o(e,t,r,n,i){this.compressedSize=e,this.uncompressedSize=t,this.crc32=r,this.compression=n,this.compressedContent=i}o.prototype={getContentWorker:function(){var e=new i(n.Promise.resolve(this.compressedContent)).pipe(this.compression.uncompressWorker()).pipe(new a("data_length")),t=this;return e.on("end",(function(){if(this.streamInfo.data_length!==t.uncompressedSize)throw new Error("Bug : uncompressed data size mismatch")})),e},getCompressedWorker:function(){return new i(n.Promise.resolve(this.compressedContent)).withStreamInfo("compressedSize",this.compressedSize).withStreamInfo("uncompressedSize",this.uncompressedSize).withStreamInfo("crc32",this.crc32).withStreamInfo("compression",this.compression)}},o.createWorkerFrom=function(e,t,r){return e.pipe(new s).pipe(new a("uncompressedSize")).pipe(t.compressWorker(r)).pipe(new a("compressedSize")).withStreamInfo("compression",t)},t.exports=o},{"./external":6,"./stream/Crc32Probe":25,"./stream/DataLengthProbe":26,"./stream/DataWorker":27}],3:[function(e,t,r){"use strict";var n=e("./stream/GenericWorker");r.STORE={magic:"\0\0",compressWorker:function(){return new n("STORE compression")},uncompressWorker:function(){return new n("STORE decompression")}},r.DEFLATE=e("./flate")},{"./flate":7,"./stream/GenericWorker":28}],4:[function(e,t,r){"use strict";var n=e("./utils"),i=function(){for(var e,t=[],r=0;r<256;r++){e=r;for(var n=0;n<8;n++)e=1&e?3988292384^e>>>1:e>>>1;t[r]=e}return t}();t.exports=function(e,t){return void 0!==e&&e.length?"string"!==n.getTypeOf(e)?function(e,t,r,n){var s=i,a=n+r;e^=-1;for(var o=n;o<a;o++)e=e>>>8^s[255&(e^t[o])];return-1^e}(0|t,e,e.length,0):function(e,t,r,n){var s=i,a=n+r;e^=-1;for(var o=n;o<a;o++)e=e>>>8^s[255&(e^t.charCodeAt(o))];return-1^e}(0|t,e,e.length,0):0}},{"./utils":32}],5:[function(e,t,r){"use strict";r.base64=!1,r.binary=!1,r.dir=!1,r.createFolders=!0,r.date=null,r.compression=null,r.compressionOptions=null,r.comment=null,r.unixPermissions=null,r.dosPermissions=null},{}],6:[function(e,t,r){"use strict";var n=null;n="undefined"!=typeof Promise?Promise:e("lie"),t.exports={Promise:n}},{lie:37}],7:[function(e,t,r){"use strict";var n="undefined"!=typeof Uint8Array&&"undefined"!=typeof Uint16Array&&"undefined"!=typeof Uint32Array,i=e("pako"),s=e("./utils"),a=e("./stream/GenericWorker"),o=n?"uint8array":"array";function h(e,t){a.call(this,"FlateWorker/"+e),this._pako=null,this._pakoAction=e,this._pakoOptions=t,this.meta={}}r.magic="\b\0",s.inherits(h,a),h.prototype.processChunk=function(e){this.meta=e.meta,null===this._pako&&this._createPako(),this._pako.push(s.transformTo(o,e.data),!1)},h.prototype.flush=function(){a.prototype.flush.call(this),null===this._pako&&this._createPako(),this._pako.push([],!0)},h.prototype.cleanUp=function(){a.prototype.cleanUp.call(this),this._pako=null},h.prototype._createPako=function(){this._pako=new i[this._pakoAction]({raw:!0,level:this._pakoOptions.level||-1});var e=this;this._pako.onData=function(t){e.push({data:t,meta:e.meta})}},r.compressWorker=function(e){return new h("Deflate",e)},r.uncompressWorker=function(){return new h("Inflate",{})}},{"./stream/GenericWorker":28,"./utils":32,pako:38}],8:[function(e,t,r){"use strict";function n(e,t){var r,n="";for(r=0;r<t;r++)n+=String.fromCharCode(255&e),e>>>=8;return n}function i(e,t,r,i,a,l){var f,c,d=e.file,p=e.compression,m=l!==o.utf8encode,_=s.transformTo("string",l(d.name)),g=s.transformTo("string",o.utf8encode(d.name)),b=d.comment,v=s.transformTo("string",l(b)),y=s.transformTo("string",o.utf8encode(b)),w=g.length!==d.name.length,k=y.length!==b.length,x="",S="",z="",C=d.dir,E=d.date,A={crc32:0,compressedSize:0,uncompressedSize:0};t&&!r||(A.crc32=e.crc32,A.compressedSize=e.compressedSize,A.uncompressedSize=e.uncompressedSize);var I=0;t&&(I|=8),m||!w&&!k||(I|=2048);var O=0,B=0;C&&(O|=16),"UNIX"===a?(B=798,O|=function(e,t){var r=e;return e||(r=t?16893:33204),(65535&r)<<16}(d.unixPermissions,C)):(B=20,O|=function(e){return 63&(e||0)}(d.dosPermissions)),f=E.getUTCHours(),f<<=6,f|=E.getUTCMinutes(),f<<=5,f|=E.getUTCSeconds()/2,c=E.getUTCFullYear()-1980,c<<=4,c|=E.getUTCMonth()+1,c<<=5,c|=E.getUTCDate(),w&&(S=n(1,1)+n(h(_),4)+g,x+="up"+n(S.length,2)+S),k&&(z=n(1,1)+n(h(v),4)+y,x+="uc"+n(z.length,2)+z);var R="";return R+="\n\0",R+=n(I,2),R+=p.magic,R+=n(f,2),R+=n(c,2),R+=n(A.crc32,4),R+=n(A.compressedSize,4),R+=n(A.uncompressedSize,4),R+=n(_.length,2),R+=n(x.length,2),{fileRecord:u.LOCAL_FILE_HEADER+R+_+x,dirRecord:u.CENTRAL_FILE_HEADER+n(B,2)+R+n(v.length,2)+"\0\0\0\0"+n(O,4)+n(i,4)+_+x+v}}var s=e("../utils"),a=e("../stream/GenericWorker"),o=e("../utf8"),h=e("../crc32"),u=e("../signature");function l(e,t,r,n){a.call(this,"ZipFileWorker"),this.bytesWritten=0,this.zipComment=t,this.zipPlatform=r,this.encodeFileName=n,this.streamFiles=e,this.accumulate=!1,this.contentBuffer=[],this.dirRecords=[],this.currentSourceOffset=0,this.entriesCount=0,this.currentFile=null,this._sources=[]}s.inherits(l,a),l.prototype.push=function(e){var t=e.meta.percent||0,r=this.entriesCount,n=this._sources.length;this.accumulate?this.contentBuffer.push(e):(this.bytesWritten+=e.data.length,a.prototype.push.call(this,{data:e.data,meta:{currentFile:this.currentFile,percent:r?(t+100*(r-n-1))/r:100}}))},l.prototype.openedSource=function(e){this.currentSourceOffset=this.bytesWritten,this.currentFile=e.file.name;var t=this.streamFiles&&!e.file.dir;if(t){var r=i(e,t,!1,this.currentSourceOffset,this.zipPlatform,this.encodeFileName);this.push({data:r.fileRecord,meta:{percent:0}})}else this.accumulate=!0},l.prototype.closedSource=function(e){this.accumulate=!1;var t=this.streamFiles&&!e.file.dir,r=i(e,t,!0,this.currentSourceOffset,this.zipPlatform,this.encodeFileName);if(this.dirRecords.push(r.dirRecord),t)this.push({data:function(e){return u.DATA_DESCRIPTOR+n(e.crc32,4)+n(e.compressedSize,4)+n(e.uncompressedSize,4)}(e),meta:{percent:100}});else for(this.push({data:r.fileRecord,meta:{percent:0}});this.contentBuffer.length;)this.push(this.contentBuffer.shift());this.currentFile=null},l.prototype.flush=function(){for(var e=this.bytesWritten,t=0;t<this.dirRecords.length;t++)this.push({data:this.dirRecords[t],meta:{percent:100}});var r=this.bytesWritten-e,i=function(e,t,r,i,a){var o=s.transformTo("string",a(i));return u.CENTRAL_DIRECTORY_END+"\0\0\0\0"+n(e,2)+n(e,2)+n(t,4)+n(r,4)+n(o.length,2)+o}(this.dirRecords.length,r,e,this.zipComment,this.encodeFileName);this.push({data:i,meta:{percent:100}})},l.prototype.prepareNextSource=function(){this.previous=this._sources.shift(),this.openedSource(this.previous.streamInfo),this.isPaused?this.previous.pause():this.previous.resume()},l.prototype.registerPrevious=function(e){this._sources.push(e);var t=this;return e.on("data",(function(e){t.processChunk(e)})),e.on("end",(function(){t.closedSource(t.previous.streamInfo),t._sources.length?t.prepareNextSource():t.end()})),e.on("error",(function(e){t.error(e)})),this},l.prototype.resume=function(){return!!a.prototype.resume.call(this)&&(!this.previous&&this._sources.length?(this.prepareNextSource(),!0):this.previous||this._sources.length||this.generatedError?void 0:(this.end(),!0))},l.prototype.error=function(e){var t=this._sources;if(!a.prototype.error.call(this,e))return!1;for(var r=0;r<t.length;r++)try{t[r].error(e)}catch(e){}return!0},l.prototype.lock=function(){a.prototype.lock.call(this);for(var e=this._sources,t=0;t<e.length;t++)e[t].lock()},t.exports=l},{"../crc32":4,"../signature":23,"../stream/GenericWorker":28,"../utf8":31,"../utils":32}],9:[function(e,t,r){"use strict";var n=e("../compressions"),i=e("./ZipFileWorker");r.generateWorker=function(e,t,r){var s=new i(t.streamFiles,r,t.platform,t.encodeFileName),a=0;try{e.forEach((function(e,r){a++;var i=function(e,t){var r=e||t,i=n[r];if(!i)throw new Error(r+" is not a valid compression method !");return i}(r.options.compression,t.compression),o=r.options.compressionOptions||t.compressionOptions||{},h=r.dir,u=r.date;r._compressWorker(i,o).withStreamInfo("file",{name:e,dir:h,date:u,comment:r.comment||"",unixPermissions:r.unixPermissions,dosPermissions:r.dosPermissions}).pipe(s)})),s.entriesCount=a}catch(e){s.error(e)}return s}},{"../compressions":3,"./ZipFileWorker":8}],10:[function(e,t,r){"use strict";function n(){if(!(this instanceof n))return new n;if(arguments.length)throw new Error("The constructor with parameters has been removed in JSZip 3.0, please check the upgrade guide.");this.files=Object.create(null),this.comment=null,this.root="",this.clone=function(){var e=new n;for(var t in this)"function"!=typeof this[t]&&(e[t]=this[t]);return e}}(n.prototype=e("./object")).loadAsync=e("./load"),n.support=e("./support"),n.defaults=e("./defaults"),n.version="3.10.1",n.loadAsync=function(e,t){return(new n).loadAsync(e,t)},n.external=e("./external"),t.exports=n},{"./defaults":5,"./external":6,"./load":11,"./object":15,"./support":30}],11:[function(e,t,r){"use strict";var n=e("./utils"),i=e("./external"),s=e("./utf8"),a=e("./zipEntries"),o=e("./stream/Crc32Probe"),h=e("./nodejsUtils");function u(e){return new i.Promise((function(t,r){var n=e.decompressed.getContentWorker().pipe(new o);n.on("error",(function(e){r(e)})).on("end",(function(){n.streamInfo.crc32!==e.decompressed.crc32?r(new Error("Corrupted zip : CRC32 mismatch")):t()})).resume()}))}t.exports=function(e,t){var r=this;return t=n.extend(t||{},{base64:!1,checkCRC32:!1,optimizedBinaryString:!1,createFolders:!1,decodeFileName:s.utf8decode}),h.isNode&&h.isStream(e)?i.Promise.reject(new Error("JSZip can't accept a stream when loading a zip file.")):n.prepareContent("the loaded zip file",e,!0,t.optimizedBinaryString,t.base64).then((function(e){var r=new a(t);return r.load(e),r})).then((function(e){var r=[i.Promise.resolve(e)],n=e.files;if(t.checkCRC32)for(var s=0;s<n.length;s++)r.push(u(n[s]));return i.Promise.all(r)})).then((function(e){for(var i=e.shift(),s=i.files,a=0;a<s.length;a++){var o=s[a],h=o.fileNameStr,u=n.resolve(o.fileNameStr);r.file(u,o.decompressed,{binary:!0,optimizedBinaryString:!0,date:o.date,dir:o.dir,comment:o.fileCommentStr.length?o.fileCommentStr:null,unixPermissions:o.unixPermissions,dosPermissions:o.dosPermissions,createFolders:t.createFolders}),o.dir||(r.file(u).unsafeOriginalName=h)}return i.zipComment.length&&(r.comment=i.zipComment),r}))}},{"./external":6,"./nodejsUtils":14,"./stream/Crc32Probe":25,"./utf8":31,"./utils":32,"./zipEntries":33}],12:[function(e,t,r){"use strict";var n=e("../utils"),i=e("../stream/GenericWorker");function s(e,t){i.call(this,"Nodejs stream input adapter for "+e),this._upstreamEnded=!1,this._bindStream(t)}n.inherits(s,i),s.prototype._bindStream=function(e){var t=this;(this._stream=e).pause(),e.on("data",(function(e){t.push({data:e,meta:{percent:0}})})).on("error",(function(e){t.isPaused?this.generatedError=e:t.error(e)})).on("end",(function(){t.isPaused?t._upstreamEnded=!0:t.end()}))},s.prototype.pause=function(){return!!i.prototype.pause.call(this)&&(this._stream.pause(),!0)},s.prototype.resume=function(){return!!i.prototype.resume.call(this)&&(this._upstreamEnded?this.end():this._stream.resume(),!0)},t.exports=s},{"../stream/GenericWorker":28,"../utils":32}],13:[function(e,t,r){"use strict";var n=e("readable-stream").Readable;function i(e,t,r){n.call(this,t),this._helper=e;var i=this;e.on("data",(function(e,t){i.push(e)||i._helper.pause(),r&&r(t)})).on("error",(function(e){i.emit("error",e)})).on("end",(function(){i.push(null)}))}e("../utils").inherits(i,n),i.prototype._read=function(){this._helper.resume()},t.exports=i},{"../utils":32,"readable-stream":16}],14:[function(e,t,r){"use strict";t.exports={isNode:"undefined"!=typeof Buffer,newBufferFrom:function(e,t){if(Buffer.from&&Buffer.from!==Uint8Array.from)return Buffer.from(e,t);if("number"==typeof e)throw new Error('The "data" argument must not be a number');return new Buffer(e,t)},allocBuffer:function(e){if(Buffer.alloc)return Buffer.alloc(e);var t=new Buffer(e);return t.fill(0),t},isBuffer:function(e){return Buffer.isBuffer(e)},isStream:function(e){return e&&"function"==typeof e.on&&"function"==typeof e.pause&&"function"==typeof e.resume}}},{}],15:[function(e,t,r){"use strict";function n(e,t,r){var n,i=s.getTypeOf(t),o=s.extend(r||{},h);o.date=o.date||new Date,null!==o.compression&&(o.compression=o.compression.toUpperCase()),"string"==typeof o.unixPermissions&&(o.unixPermissions=parseInt(o.unixPermissions,8)),o.unixPermissions&&16384&o.unixPermissions&&(o.dir=!0),o.dosPermissions&&16&o.dosPermissions&&(o.dir=!0),o.dir&&(e=m(e)),o.createFolders&&(n=p(e))&&_.call(this,n,!0);var f="string"===i&&!1===o.binary&&!1===o.base64;r&&void 0!==r.binary||(o.binary=!f),(t instanceof u&&0===t.uncompressedSize||o.dir||!t||0===t.length)&&(o.base64=!1,o.binary=!0,t="",o.compression="STORE",i="string");var g=null;g=t instanceof u||t instanceof a?t:c.isNode&&c.isStream(t)?new d(e,t):s.prepareContent(e,t,o.binary,o.optimizedBinaryString,o.base64);var b=new l(e,g,o);this.files[e]=b}var i=e("./utf8"),s=e("./utils"),a=e("./stream/GenericWorker"),o=e("./stream/StreamHelper"),h=e("./defaults"),u=e("./compressedObject"),l=e("./zipObject"),f=e("./generate"),c=e("./nodejsUtils"),d=e("./nodejs/NodejsStreamInputAdapter"),p=function(e){"/"===e.slice(-1)&&(e=e.substring(0,e.length-1));var t=e.lastIndexOf("/");return 0<t?e.substring(0,t):""},m=function(e){return"/"!==e.slice(-1)&&(e+="/"),e},_=function(e,t){return t=void 0!==t?t:h.createFolders,e=m(e),this.files[e]||n.call(this,e,null,{dir:!0,createFolders:t}),this.files[e]};function g(e){return"[object RegExp]"===Object.prototype.toString.call(e)}var b={load:function(){throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.")},forEach:function(e){var t,r,n;for(t in this.files)n=this.files[t],(r=t.slice(this.root.length,t.length))&&t.slice(0,this.root.length)===this.root&&e(r,n)},filter:function(e){var t=[];return this.forEach((function(r,n){e(r,n)&&t.push(n)})),t},file:function(e,t,r){if(1!==arguments.length)return e=this.root+e,n.call(this,e,t,r),this;if(g(e)){var i=e;return this.filter((function(e,t){return!t.dir&&i.test(e)}))}var s=this.files[this.root+e];return s&&!s.dir?s:null},folder:function(e){if(!e)return this;if(g(e))return this.filter((function(t,r){return r.dir&&e.test(t)}));var t=this.root+e,r=_.call(this,t),n=this.clone();return n.root=r.name,n},remove:function(e){e=this.root+e;var t=this.files[e];if(t||("/"!==e.slice(-1)&&(e+="/"),t=this.files[e]),t&&!t.dir)delete this.files[e];else for(var r=this.filter((function(t,r){return r.name.slice(0,e.length)===e})),n=0;n<r.length;n++)delete this.files[r[n].name];return this},generate:function(){throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.")},generateInternalStream:function(e){var t,r={};try{if((r=s.extend(e||{},{streamFiles:!1,compression:"STORE",compressionOptions:null,type:"",platform:"DOS",comment:null,mimeType:"application/zip",encodeFileName:i.utf8encode})).type=r.type.toLowerCase(),r.compression=r.compression.toUpperCase(),"binarystring"===r.type&&(r.type="string"),!r.type)throw new Error("No output type specified.");s.checkSupport(r.type),"darwin"!==r.platform&&"freebsd"!==r.platform&&"linux"!==r.platform&&"sunos"!==r.platform||(r.platform="UNIX"),"win32"===r.platform&&(r.platform="DOS");var n=r.comment||this.comment||"";t=f.generateWorker(this,r,n)}catch(e){(t=new a("error")).error(e)}return new o(t,r.type||"string",r.mimeType)},generateAsync:function(e,t){return this.generateInternalStream(e).accumulate(t)},generateNodeStream:function(e,t){return(e=e||{}).type||(e.type="nodebuffer"),this.generateInternalStream(e).toNodejsStream(t)}};t.exports=b},{"./compressedObject":2,"./defaults":5,"./generate":9,"./nodejs/NodejsStreamInputAdapter":12,"./nodejsUtils":14,"./stream/GenericWorker":28,"./stream/StreamHelper":29,"./utf8":31,"./utils":32,"./zipObject":35}],16:[function(e,t,r){"use strict";t.exports=e("stream")},{stream:void 0}],17:[function(e,t,r){"use strict";var n=e("./DataReader");function i(e){n.call(this,e);for(var t=0;t<this.data.length;t++)e[t]=255&e[t]}e("../utils").inherits(i,n),i.prototype.byteAt=function(e){return this.data[this.zero+e]},i.prototype.lastIndexOfSignature=function(e){for(var t=e.charCodeAt(0),r=e.charCodeAt(1),n=e.charCodeAt(2),i=e.charCodeAt(3),s=this.length-4;0<=s;--s)if(this.data[s]===t&&this.data[s+1]===r&&this.data[s+2]===n&&this.data[s+3]===i)return s-this.zero;return-1},i.prototype.readAndCheckSignature=function(e){var t=e.charCodeAt(0),r=e.charCodeAt(1),n=e.charCodeAt(2),i=e.charCodeAt(3),s=this.readData(4);return t===s[0]&&r===s[1]&&n===s[2]&&i===s[3]},i.prototype.readData=function(e){if(this.checkOffset(e),0===e)return[];var t=this.data.slice(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t},t.exports=i},{"../utils":32,"./DataReader":18}],18:[function(e,t,r){"use strict";var n=e("../utils");function i(e){this.data=e,this.length=e.length,this.index=0,this.zero=0}i.prototype={checkOffset:function(e){this.checkIndex(this.index+e)},checkIndex:function(e){if(this.length<this.zero+e||e<0)throw new Error("End of data reached (data length = "+this.length+", asked index = "+e+"). Corrupted zip ?")},setIndex:function(e){this.checkIndex(e),this.index=e},skip:function(e){this.setIndex(this.index+e)},byteAt:function(){},readInt:function(e){var t,r=0;for(this.checkOffset(e),t=this.index+e-1;t>=this.index;t--)r=(r<<8)+this.byteAt(t);return this.index+=e,r},readString:function(e){return n.transformTo("string",this.readData(e))},readData:function(){},lastIndexOfSignature:function(){},readAndCheckSignature:function(){},readDate:function(){var e=this.readInt(4);return new Date(Date.UTC(1980+(e>>25&127),(e>>21&15)-1,e>>16&31,e>>11&31,e>>5&63,(31&e)<<1))}},t.exports=i},{"../utils":32}],19:[function(e,t,r){"use strict";var n=e("./Uint8ArrayReader");function i(e){n.call(this,e)}e("../utils").inherits(i,n),i.prototype.readData=function(e){this.checkOffset(e);var t=this.data.slice(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t},t.exports=i},{"../utils":32,"./Uint8ArrayReader":21}],20:[function(e,t,r){"use strict";var n=e("./DataReader");function i(e){n.call(this,e)}e("../utils").inherits(i,n),i.prototype.byteAt=function(e){return this.data.charCodeAt(this.zero+e)},i.prototype.lastIndexOfSignature=function(e){return this.data.lastIndexOf(e)-this.zero},i.prototype.readAndCheckSignature=function(e){return e===this.readData(4)},i.prototype.readData=function(e){this.checkOffset(e);var t=this.data.slice(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t},t.exports=i},{"../utils":32,"./DataReader":18}],21:[function(e,t,r){"use strict";var n=e("./ArrayReader");function i(e){n.call(this,e)}e("../utils").inherits(i,n),i.prototype.readData=function(e){if(this.checkOffset(e),0===e)return new Uint8Array(0);var t=this.data.subarray(this.zero+this.index,this.zero+this.index+e);return this.index+=e,t},t.exports=i},{"../utils":32,"./ArrayReader":17}],22:[function(e,t,r){"use strict";var n=e("../utils"),i=e("../support"),s=e("./ArrayReader"),a=e("./StringReader"),o=e("./NodeBufferReader"),h=e("./Uint8ArrayReader");t.exports=function(e){var t=n.getTypeOf(e);return n.checkSupport(t),"string"!==t||i.uint8array?"nodebuffer"===t?new o(e):i.uint8array?new h(n.transformTo("uint8array",e)):new s(n.transformTo("array",e)):new a(e)}},{"../support":30,"../utils":32,"./ArrayReader":17,"./NodeBufferReader":19,"./StringReader":20,"./Uint8ArrayReader":21}],23:[function(e,t,r){"use strict";r.LOCAL_FILE_HEADER="PK",r.CENTRAL_FILE_HEADER="PK",r.CENTRAL_DIRECTORY_END="PK",r.ZIP64_CENTRAL_DIRECTORY_LOCATOR="PK",r.ZIP64_CENTRAL_DIRECTORY_END="PK",r.DATA_DESCRIPTOR="PK\b"},{}],24:[function(e,t,r){"use strict";var n=e("./GenericWorker"),i=e("../utils");function s(e){n.call(this,"ConvertWorker to "+e),this.destType=e}i.inherits(s,n),s.prototype.processChunk=function(e){this.push({data:i.transformTo(this.destType,e.data),meta:e.meta})},t.exports=s},{"../utils":32,"./GenericWorker":28}],25:[function(e,t,r){"use strict";var n=e("./GenericWorker"),i=e("../crc32");function s(){n.call(this,"Crc32Probe"),this.withStreamInfo("crc32",0)}e("../utils").inherits(s,n),s.prototype.processChunk=function(e){this.streamInfo.crc32=i(e.data,this.streamInfo.crc32||0),this.push(e)},t.exports=s},{"../crc32":4,"../utils":32,"./GenericWorker":28}],26:[function(e,t,r){"use strict";var n=e("../utils"),i=e("./GenericWorker");function s(e){i.call(this,"DataLengthProbe for "+e),this.propName=e,this.withStreamInfo(e,0)}n.inherits(s,i),s.prototype.processChunk=function(e){if(e){var t=this.streamInfo[this.propName]||0;this.streamInfo[this.propName]=t+e.data.length}i.prototype.processChunk.call(this,e)},t.exports=s},{"../utils":32,"./GenericWorker":28}],27:[function(e,t,r){"use strict";var n=e("../utils"),i=e("./GenericWorker");function s(e){i.call(this,"DataWorker");var t=this;this.dataIsReady=!1,this.index=0,this.max=0,this.data=null,this.type="",this._tickScheduled=!1,e.then((function(e){t.dataIsReady=!0,t.data=e,t.max=e&&e.length||0,t.type=n.getTypeOf(e),t.isPaused||t._tickAndRepeat()}),(function(e){t.error(e)}))}n.inherits(s,i),s.prototype.cleanUp=function(){i.prototype.cleanUp.call(this),this.data=null},s.prototype.resume=function(){return!!i.prototype.resume.call(this)&&(!this._tickScheduled&&this.dataIsReady&&(this._tickScheduled=!0,n.delay(this._tickAndRepeat,[],this)),!0)},s.prototype._tickAndRepeat=function(){this._tickScheduled=!1,this.isPaused||this.isFinished||(this._tick(),this.isFinished||(n.delay(this._tickAndRepeat,[],this),this._tickScheduled=!0))},s.prototype._tick=function(){if(this.isPaused||this.isFinished)return!1;var e=null,t=Math.min(this.max,this.index+16384);if(this.index>=this.max)return this.end();switch(this.type){case"string":e=this.data.substring(this.index,t);break;case"uint8array":e=this.data.subarray(this.index,t);break;case"array":case"nodebuffer":e=this.data.slice(this.index,t)}return this.index=t,this.push({data:e,meta:{percent:this.max?this.index/this.max*100:0}})},t.exports=s},{"../utils":32,"./GenericWorker":28}],28:[function(e,t,r){"use strict";function n(e){this.name=e||"default",this.streamInfo={},this.generatedError=null,this.extraStreamInfo={},this.isPaused=!0,this.isFinished=!1,this.isLocked=!1,this._listeners={data:[],end:[],error:[]},this.previous=null}n.prototype={push:function(e){this.emit("data",e)},end:function(){if(this.isFinished)return!1;this.flush();try{this.emit("end"),this.cleanUp(),this.isFinished=!0}catch(e){this.emit("error",e)}return!0},error:function(e){return!this.isFinished&&(this.isPaused?this.generatedError=e:(this.isFinished=!0,this.emit("error",e),this.previous&&this.previous.error(e),this.cleanUp()),!0)},on:function(e,t){return this._listeners[e].push(t),this},cleanUp:function(){this.streamInfo=this.generatedError=this.extraStreamInfo=null,this._listeners=[]},emit:function(e,t){if(this._listeners[e])for(var r=0;r<this._listeners[e].length;r++)this._listeners[e][r].call(this,t)},pipe:function(e){return e.registerPrevious(this)},registerPrevious:function(e){if(this.isLocked)throw new Error("The stream '"+this+"' has already been used.");this.streamInfo=e.streamInfo,this.mergeStreamInfo(),this.previous=e;var t=this;return e.on("data",(function(e){t.processChunk(e)})),e.on("end",(function(){t.end()})),e.on("error",(function(e){t.error(e)})),this},pause:function(){return!this.isPaused&&!this.isFinished&&(this.isPaused=!0,this.previous&&this.previous.pause(),!0)},resume:function(){if(!this.isPaused||this.isFinished)return!1;var e=this.isPaused=!1;return this.generatedError&&(this.error(this.generatedError),e=!0),this.previous&&this.previous.resume(),!e},flush:function(){},processChunk:function(e){this.push(e)},withStreamInfo:function(e,t){return this.extraStreamInfo[e]=t,this.mergeStreamInfo(),this},mergeStreamInfo:function(){for(var e in this.extraStreamInfo)Object.prototype.hasOwnProperty.call(this.extraStreamInfo,e)&&(this.streamInfo[e]=this.extraStreamInfo[e])},lock:function(){if(this.isLocked)throw new Error("The stream '"+this+"' has already been used.");this.isLocked=!0,this.previous&&this.previous.lock()},toString:function(){var e="Worker "+this.name;return this.previous?this.previous+" -> "+e:e}},t.exports=n},{}],29:[function(e,t,r){"use strict";var n=e("../utils"),i=e("./ConvertWorker"),s=e("./GenericWorker"),a=e("../base64"),o=e("../support"),h=e("../external"),u=null;if(o.nodestream)try{u=e("../nodejs/NodejsStreamOutputAdapter")}catch(e){}function l(e,t){return new h.Promise((function(r,i){var s=[],o=e._internalType,h=e._outputType,u=e._mimeType;e.on("data",(function(e,r){s.push(e),t&&t(r)})).on("error",(function(e){s=[],i(e)})).on("end",(function(){try{var e=function(e,t,r){switch(e){case"blob":return n.newBlob(n.transformTo("arraybuffer",t),r);case"base64":return a.encode(t);default:return n.transformTo(e,t)}}(h,function(e,t){var r,n=0,i=null,s=0;for(r=0;r<t.length;r++)s+=t[r].length;switch(e){case"string":return t.join("");case"array":return Array.prototype.concat.apply([],t);case"uint8array":for(i=new Uint8Array(s),r=0;r<t.length;r++)i.set(t[r],n),n+=t[r].length;return i;case"nodebuffer":return Buffer.concat(t);default:throw new Error("concat : unsupported type '"+e+"'")}}(o,s),u);r(e)}catch(e){i(e)}s=[]})).resume()}))}function f(e,t,r){var a=t;switch(t){case"blob":case"arraybuffer":a="uint8array";break;case"base64":a="string"}try{this._internalType=a,this._outputType=t,this._mimeType=r,n.checkSupport(a),this._worker=e.pipe(new i(a)),e.lock()}catch(e){this._worker=new s("error"),this._worker.error(e)}}f.prototype={accumulate:function(e){return l(this,e)},on:function(e,t){var r=this;return"data"===e?this._worker.on(e,(function(e){t.call(r,e.data,e.meta)})):this._worker.on(e,(function(){n.delay(t,arguments,r)})),this},resume:function(){return n.delay(this._worker.resume,[],this._worker),this},pause:function(){return this._worker.pause(),this},toNodejsStream:function(e){if(n.checkSupport("nodestream"),"nodebuffer"!==this._outputType)throw new Error(this._outputType+" is not supported by this method");return new u(this,{objectMode:"nodebuffer"!==this._outputType},e)}},t.exports=f},{"../base64":1,"../external":6,"../nodejs/NodejsStreamOutputAdapter":13,"../support":30,"../utils":32,"./ConvertWorker":24,"./GenericWorker":28}],30:[function(e,t,r){"use strict";if(r.base64=!0,r.array=!0,r.string=!0,r.arraybuffer="undefined"!=typeof ArrayBuffer&&"undefined"!=typeof Uint8Array,r.nodebuffer="undefined"!=typeof Buffer,r.uint8array="undefined"!=typeof Uint8Array,"undefined"==typeof ArrayBuffer)r.blob=!1;else{var n=new ArrayBuffer(0);try{r.blob=0===new Blob([n],{type:"application/zip"}).size}catch(e){try{var i=new(self.BlobBuilder||self.WebKitBlobBuilder||self.MozBlobBuilder||self.MSBlobBuilder);i.append(n),r.blob=0===i.getBlob("application/zip").size}catch(e){r.blob=!1}}}try{r.nodestream=!!e("readable-stream").Readable}catch(e){r.nodestream=!1}},{"readable-stream":16}],31:[function(e,t,r){"use strict";for(var n=e("./utils"),i=e("./support"),s=e("./nodejsUtils"),a=e("./stream/GenericWorker"),o=new Array(256),h=0;h<256;h++)o[h]=252<=h?6:248<=h?5:240<=h?4:224<=h?3:192<=h?2:1;function u(){a.call(this,"utf-8 decode"),this.leftOver=null}function l(){a.call(this,"utf-8 encode")}o[254]=o[254]=1,r.utf8encode=function(e){return i.nodebuffer?s.newBufferFrom(e,"utf-8"):function(e){var t,r,n,s,a,o=e.length,h=0;for(s=0;s<o;s++)55296==(64512&(r=e.charCodeAt(s)))&&s+1<o&&56320==(64512&(n=e.charCodeAt(s+1)))&&(r=65536+(r-55296<<10)+(n-56320),s++),h+=r<128?1:r<2048?2:r<65536?3:4;for(t=i.uint8array?new Uint8Array(h):new Array(h),s=a=0;a<h;s++)55296==(64512&(r=e.charCodeAt(s)))&&s+1<o&&56320==(64512&(n=e.charCodeAt(s+1)))&&(r=65536+(r-55296<<10)+(n-56320),s++),r<128?t[a++]=r:(r<2048?t[a++]=192|r>>>6:(r<65536?t[a++]=224|r>>>12:(t[a++]=240|r>>>18,t[a++]=128|r>>>12&63),t[a++]=128|r>>>6&63),t[a++]=128|63&r);return t}(e)},r.utf8decode=function(e){return i.nodebuffer?n.transformTo("nodebuffer",e).toString("utf-8"):function(e){var t,r,i,s,a=e.length,h=new Array(2*a);for(t=r=0;t<a;)if((i=e[t++])<128)h[r++]=i;else if(4<(s=o[i]))h[r++]=65533,t+=s-1;else{for(i&=2===s?31:3===s?15:7;1<s&&t<a;)i=i<<6|63&e[t++],s--;1<s?h[r++]=65533:i<65536?h[r++]=i:(i-=65536,h[r++]=55296|i>>10&1023,h[r++]=56320|1023&i)}return h.length!==r&&(h.subarray?h=h.subarray(0,r):h.length=r),n.applyFromCharCode(h)}(e=n.transformTo(i.uint8array?"uint8array":"array",e))},n.inherits(u,a),u.prototype.processChunk=function(e){var t=n.transformTo(i.uint8array?"uint8array":"array",e.data);if(this.leftOver&&this.leftOver.length){if(i.uint8array){var s=t;(t=new Uint8Array(s.length+this.leftOver.length)).set(this.leftOver,0),t.set(s,this.leftOver.length)}else t=this.leftOver.concat(t);this.leftOver=null}var a=function(e,t){var r;for((t=t||e.length)>e.length&&(t=e.length),r=t-1;0<=r&&128==(192&e[r]);)r--;return r<0||0===r?t:r+o[e[r]]>t?r:t}(t),h=t;a!==t.length&&(i.uint8array?(h=t.subarray(0,a),this.leftOver=t.subarray(a,t.length)):(h=t.slice(0,a),this.leftOver=t.slice(a,t.length))),this.push({data:r.utf8decode(h),meta:e.meta})},u.prototype.flush=function(){this.leftOver&&this.leftOver.length&&(this.push({data:r.utf8decode(this.leftOver),meta:{}}),this.leftOver=null)},r.Utf8DecodeWorker=u,n.inherits(l,a),l.prototype.processChunk=function(e){this.push({data:r.utf8encode(e.data),meta:e.meta})},r.Utf8EncodeWorker=l},{"./nodejsUtils":14,"./stream/GenericWorker":28,"./support":30,"./utils":32}],32:[function(e,t,r){"use strict";var n=e("./support"),i=e("./base64"),s=e("./nodejsUtils"),a=e("./external");function o(e){return e}function h(e,t){for(var r=0;r<e.length;++r)t[r]=255&e.charCodeAt(r);return t}e("setimmediate"),r.newBlob=function(t,n){r.checkSupport("blob");try{return new Blob([t],{type:n})}catch(e){try{var i=new(self.BlobBuilder||self.WebKitBlobBuilder||self.MozBlobBuilder||self.MSBlobBuilder);return i.append(t),i.getBlob(n)}catch(e){throw new Error("Bug : can't construct the Blob.")}}};var u={stringifyByChunk:function(e,t,r){var n=[],i=0,s=e.length;if(s<=r)return String.fromCharCode.apply(null,e);for(;i<s;)"array"===t||"nodebuffer"===t?n.push(String.fromCharCode.apply(null,e.slice(i,Math.min(i+r,s)))):n.push(String.fromCharCode.apply(null,e.subarray(i,Math.min(i+r,s)))),i+=r;return n.join("")},stringifyByChar:function(e){for(var t="",r=0;r<e.length;r++)t+=String.fromCharCode(e[r]);return t},applyCanBeUsed:{uint8array:function(){try{return n.uint8array&&1===String.fromCharCode.apply(null,new Uint8Array(1)).length}catch(e){return!1}}(),nodebuffer:function(){try{return n.nodebuffer&&1===String.fromCharCode.apply(null,s.allocBuffer(1)).length}catch(e){return!1}}()}};function l(e){var t=65536,n=r.getTypeOf(e),i=!0;if("uint8array"===n?i=u.applyCanBeUsed.uint8array:"nodebuffer"===n&&(i=u.applyCanBeUsed.nodebuffer),i)for(;1<t;)try{return u.stringifyByChunk(e,n,t)}catch(e){t=Math.floor(t/2)}return u.stringifyByChar(e)}function f(e,t){for(var r=0;r<e.length;r++)t[r]=e[r];return t}r.applyFromCharCode=l;var c={};c.string={string:o,array:function(e){return h(e,new Array(e.length))},arraybuffer:function(e){return c.string.uint8array(e).buffer},uint8array:function(e){return h(e,new Uint8Array(e.length))},nodebuffer:function(e){return h(e,s.allocBuffer(e.length))}},c.array={string:l,array:o,arraybuffer:function(e){return new Uint8Array(e).buffer},uint8array:function(e){return new Uint8Array(e)},nodebuffer:function(e){return s.newBufferFrom(e)}},c.arraybuffer={string:function(e){return l(new Uint8Array(e))},array:function(e){return f(new Uint8Array(e),new Array(e.byteLength))},arraybuffer:o,uint8array:function(e){return new Uint8Array(e)},nodebuffer:function(e){return s.newBufferFrom(new Uint8Array(e))}},c.uint8array={string:l,array:function(e){return f(e,new Array(e.length))},arraybuffer:function(e){return e.buffer},uint8array:o,nodebuffer:function(e){return s.newBufferFrom(e)}},c.nodebuffer={string:l,array:function(e){return f(e,new Array(e.length))},arraybuffer:function(e){return c.nodebuffer.uint8array(e).buffer},uint8array:function(e){return f(e,new Uint8Array(e.length))},nodebuffer:o},r.transformTo=function(e,t){if(t=t||"",!e)return t;r.checkSupport(e);var n=r.getTypeOf(t);return c[n][e](t)},r.resolve=function(e){for(var t=e.split("/"),r=[],n=0;n<t.length;n++){var i=t[n];"."===i||""===i&&0!==n&&n!==t.length-1||(".."===i?r.pop():r.push(i))}return r.join("/")},r.getTypeOf=function(e){return"string"==typeof e?"string":"[object Array]"===Object.prototype.toString.call(e)?"array":n.nodebuffer&&s.isBuffer(e)?"nodebuffer":n.uint8array&&e instanceof Uint8Array?"uint8array":n.arraybuffer&&e instanceof ArrayBuffer?"arraybuffer":void 0},r.checkSupport=function(e){if(!n[e.toLowerCase()])throw new Error(e+" is not supported by this platform")},r.MAX_VALUE_16BITS=65535,r.MAX_VALUE_32BITS=-1,r.pretty=function(e){var t,r,n="";for(r=0;r<(e||"").length;r++)n+="\\x"+((t=e.charCodeAt(r))<16?"0":"")+t.toString(16).toUpperCase();return n},r.delay=function(e,t,r){setImmediate((function(){e.apply(r||null,t||[])}))},r.inherits=function(e,t){function r(){}r.prototype=t.prototype,e.prototype=new r},r.extend=function(){var e,t,r={};for(e=0;e<arguments.length;e++)for(t in arguments[e])Object.prototype.hasOwnProperty.call(arguments[e],t)&&void 0===r[t]&&(r[t]=arguments[e][t]);return r},r.prepareContent=function(e,t,s,o,u){return a.Promise.resolve(t).then((function(e){return n.blob&&(e instanceof Blob||-1!==["[object File]","[object Blob]"].indexOf(Object.prototype.toString.call(e)))&&"undefined"!=typeof FileReader?new a.Promise((function(t,r){var n=new FileReader;n.onload=function(e){t(e.target.result)},n.onerror=function(e){r(e.target.error)},n.readAsArrayBuffer(e)})):e})).then((function(t){var l=r.getTypeOf(t);return l?("arraybuffer"===l?t=r.transformTo("uint8array",t):"string"===l&&(u?t=i.decode(t):s&&!0!==o&&(t=function(e){return h(e,n.uint8array?new Uint8Array(e.length):new Array(e.length))}(t))),t):a.Promise.reject(new Error("Can't read the data of '"+e+"'. Is it in a supported JavaScript type (String, Blob, ArrayBuffer, etc) ?"))}))}},{"./base64":1,"./external":6,"./nodejsUtils":14,"./support":30,setimmediate:54}],33:[function(e,t,r){"use strict";var n=e("./reader/readerFor"),i=e("./utils"),s=e("./signature"),a=e("./zipEntry"),o=e("./support");function h(e){this.files=[],this.loadOptions=e}h.prototype={checkSignature:function(e){if(!this.reader.readAndCheckSignature(e)){this.reader.index-=4;var t=this.reader.readString(4);throw new Error("Corrupted zip or bug: unexpected signature ("+i.pretty(t)+", expected "+i.pretty(e)+")")}},isSignature:function(e,t){var r=this.reader.index;this.reader.setIndex(e);var n=this.reader.readString(4)===t;return this.reader.setIndex(r),n},readBlockEndOfCentral:function(){this.diskNumber=this.reader.readInt(2),this.diskWithCentralDirStart=this.reader.readInt(2),this.centralDirRecordsOnThisDisk=this.reader.readInt(2),this.centralDirRecords=this.reader.readInt(2),this.centralDirSize=this.reader.readInt(4),this.centralDirOffset=this.reader.readInt(4),this.zipCommentLength=this.reader.readInt(2);var e=this.reader.readData(this.zipCommentLength),t=o.uint8array?"uint8array":"array",r=i.transformTo(t,e);this.zipComment=this.loadOptions.decodeFileName(r)},readBlockZip64EndOfCentral:function(){this.zip64EndOfCentralSize=this.reader.readInt(8),this.reader.skip(4),this.diskNumber=this.reader.readInt(4),this.diskWithCentralDirStart=this.reader.readInt(4),this.centralDirRecordsOnThisDisk=this.reader.readInt(8),this.centralDirRecords=this.reader.readInt(8),this.centralDirSize=this.reader.readInt(8),this.centralDirOffset=this.reader.readInt(8),this.zip64ExtensibleData={};for(var e,t,r,n=this.zip64EndOfCentralSize-44;0<n;)e=this.reader.readInt(2),t=this.reader.readInt(4),r=this.reader.readData(t),this.zip64ExtensibleData[e]={id:e,length:t,value:r}},readBlockZip64EndOfCentralLocator:function(){if(this.diskWithZip64CentralDirStart=this.reader.readInt(4),this.relativeOffsetEndOfZip64CentralDir=this.reader.readInt(8),this.disksCount=this.reader.readInt(4),1<this.disksCount)throw new Error("Multi-volumes zip are not supported")},readLocalFiles:function(){var e,t;for(e=0;e<this.files.length;e++)t=this.files[e],this.reader.setIndex(t.localHeaderOffset),this.checkSignature(s.LOCAL_FILE_HEADER),t.readLocalPart(this.reader),t.handleUTF8(),t.processAttributes()},readCentralDir:function(){var e;for(this.reader.setIndex(this.centralDirOffset);this.reader.readAndCheckSignature(s.CENTRAL_FILE_HEADER);)(e=new a({zip64:this.zip64},this.loadOptions)).readCentralPart(this.reader),this.files.push(e);if(this.centralDirRecords!==this.files.length&&0!==this.centralDirRecords&&0===this.files.length)throw new Error("Corrupted zip or bug: expected "+this.centralDirRecords+" records in central dir, got "+this.files.length)},readEndOfCentral:function(){var e=this.reader.lastIndexOfSignature(s.CENTRAL_DIRECTORY_END);if(e<0)throw this.isSignature(0,s.LOCAL_FILE_HEADER)?new Error("Corrupted zip: can't find end of central directory"):new Error("Can't find end of central directory : is this a zip file ? If it is, see https://stuk.github.io/jszip/documentation/howto/read_zip.html");this.reader.setIndex(e);var t=e;if(this.checkSignature(s.CENTRAL_DIRECTORY_END),this.readBlockEndOfCentral(),this.diskNumber===i.MAX_VALUE_16BITS||this.diskWithCentralDirStart===i.MAX_VALUE_16BITS||this.centralDirRecordsOnThisDisk===i.MAX_VALUE_16BITS||this.centralDirRecords===i.MAX_VALUE_16BITS||this.centralDirSize===i.MAX_VALUE_32BITS||this.centralDirOffset===i.MAX_VALUE_32BITS){if(this.zip64=!0,(e=this.reader.lastIndexOfSignature(s.ZIP64_CENTRAL_DIRECTORY_LOCATOR))<0)throw new Error("Corrupted zip: can't find the ZIP64 end of central directory locator");if(this.reader.setIndex(e),this.checkSignature(s.ZIP64_CENTRAL_DIRECTORY_LOCATOR),this.readBlockZip64EndOfCentralLocator(),!this.isSignature(this.relativeOffsetEndOfZip64CentralDir,s.ZIP64_CENTRAL_DIRECTORY_END)&&(this.relativeOffsetEndOfZip64CentralDir=this.reader.lastIndexOfSignature(s.ZIP64_CENTRAL_DIRECTORY_END),this.relativeOffsetEndOfZip64CentralDir<0))throw new Error("Corrupted zip: can't find the ZIP64 end of central directory");this.reader.setIndex(this.relativeOffsetEndOfZip64CentralDir),this.checkSignature(s.ZIP64_CENTRAL_DIRECTORY_END),this.readBlockZip64EndOfCentral()}var r=this.centralDirOffset+this.centralDirSize;this.zip64&&(r+=20,r+=12+this.zip64EndOfCentralSize);var n=t-r;if(0<n)this.isSignature(t,s.CENTRAL_FILE_HEADER)||(this.reader.zero=n);else if(n<0)throw new Error("Corrupted zip: missing "+Math.abs(n)+" bytes.")},prepareReader:function(e){this.reader=n(e)},load:function(e){this.prepareReader(e),this.readEndOfCentral(),this.readCentralDir(),this.readLocalFiles()}},t.exports=h},{"./reader/readerFor":22,"./signature":23,"./support":30,"./utils":32,"./zipEntry":34}],34:[function(e,t,r){"use strict";var n=e("./reader/readerFor"),i=e("./utils"),s=e("./compressedObject"),a=e("./crc32"),o=e("./utf8"),h=e("./compressions"),u=e("./support");function l(e,t){this.options=e,this.loadOptions=t}l.prototype={isEncrypted:function(){return 1==(1&this.bitFlag)},useUTF8:function(){return 2048==(2048&this.bitFlag)},readLocalPart:function(e){var t,r;if(e.skip(22),this.fileNameLength=e.readInt(2),r=e.readInt(2),this.fileName=e.readData(this.fileNameLength),e.skip(r),-1===this.compressedSize||-1===this.uncompressedSize)throw new Error("Bug or corrupted zip : didn't get enough information from the central directory (compressedSize === -1 || uncompressedSize === -1)");if(null===(t=function(e){for(var t in h)if(Object.prototype.hasOwnProperty.call(h,t)&&h[t].magic===e)return h[t];return null}(this.compressionMethod)))throw new Error("Corrupted zip : compression "+i.pretty(this.compressionMethod)+" unknown (inner file : "+i.transformTo("string",this.fileName)+")");this.decompressed=new s(this.compressedSize,this.uncompressedSize,this.crc32,t,e.readData(this.compressedSize))},readCentralPart:function(e){this.versionMadeBy=e.readInt(2),e.skip(2),this.bitFlag=e.readInt(2),this.compressionMethod=e.readString(2),this.date=e.readDate(),this.crc32=e.readInt(4),this.compressedSize=e.readInt(4),this.uncompressedSize=e.readInt(4);var t=e.readInt(2);if(this.extraFieldsLength=e.readInt(2),this.fileCommentLength=e.readInt(2),this.diskNumberStart=e.readInt(2),this.internalFileAttributes=e.readInt(2),this.externalFileAttributes=e.readInt(4),this.localHeaderOffset=e.readInt(4),this.isEncrypted())throw new Error("Encrypted zip are not supported");e.skip(t),this.readExtraFields(e),this.parseZIP64ExtraField(e),this.fileComment=e.readData(this.fileCommentLength)},processAttributes:function(){this.unixPermissions=null,this.dosPermissions=null;var e=this.versionMadeBy>>8;this.dir=!!(16&this.externalFileAttributes),0==e&&(this.dosPermissions=63&this.externalFileAttributes),3==e&&(this.unixPermissions=this.externalFileAttributes>>16&65535),this.dir||"/"!==this.fileNameStr.slice(-1)||(this.dir=!0)},parseZIP64ExtraField:function(){if(this.extraFields[1]){var e=n(this.extraFields[1].value);this.uncompressedSize===i.MAX_VALUE_32BITS&&(this.uncompressedSize=e.readInt(8)),this.compressedSize===i.MAX_VALUE_32BITS&&(this.compressedSize=e.readInt(8)),this.localHeaderOffset===i.MAX_VALUE_32BITS&&(this.localHeaderOffset=e.readInt(8)),this.diskNumberStart===i.MAX_VALUE_32BITS&&(this.diskNumberStart=e.readInt(4))}},readExtraFields:function(e){var t,r,n,i=e.index+this.extraFieldsLength;for(this.extraFields||(this.extraFields={});e.index+4<i;)t=e.readInt(2),r=e.readInt(2),n=e.readData(r),this.extraFields[t]={id:t,length:r,value:n};e.setIndex(i)},handleUTF8:function(){var e=u.uint8array?"uint8array":"array";if(this.useUTF8())this.fileNameStr=o.utf8decode(this.fileName),this.fileCommentStr=o.utf8decode(this.fileComment);else{var t=this.findExtraFieldUnicodePath();if(null!==t)this.fileNameStr=t;else{var r=i.transformTo(e,this.fileName);this.fileNameStr=this.loadOptions.decodeFileName(r)}var n=this.findExtraFieldUnicodeComment();if(null!==n)this.fileCommentStr=n;else{var s=i.transformTo(e,this.fileComment);this.fileCommentStr=this.loadOptions.decodeFileName(s)}}},findExtraFieldUnicodePath:function(){var e=this.extraFields[28789];if(e){var t=n(e.value);return 1!==t.readInt(1)||a(this.fileName)!==t.readInt(4)?null:o.utf8decode(t.readData(e.length-5))}return null},findExtraFieldUnicodeComment:function(){var e=this.extraFields[25461];if(e){var t=n(e.value);return 1!==t.readInt(1)||a(this.fileComment)!==t.readInt(4)?null:o.utf8decode(t.readData(e.length-5))}return null}},t.exports=l},{"./compressedObject":2,"./compressions":3,"./crc32":4,"./reader/readerFor":22,"./support":30,"./utf8":31,"./utils":32}],35:[function(e,t,r){"use strict";function n(e,t,r){this.name=e,this.dir=r.dir,this.date=r.date,this.comment=r.comment,this.unixPermissions=r.unixPermissions,this.dosPermissions=r.dosPermissions,this._data=t,this._dataBinary=r.binary,this.options={compression:r.compression,compressionOptions:r.compressionOptions}}var i=e("./stream/StreamHelper"),s=e("./stream/DataWorker"),a=e("./utf8"),o=e("./compressedObject"),h=e("./stream/GenericWorker");n.prototype={internalStream:function(e){var t=null,r="string";try{if(!e)throw new Error("No output type specified.");var n="string"===(r=e.toLowerCase())||"text"===r;"binarystring"!==r&&"text"!==r||(r="string"),t=this._decompressWorker();var s=!this._dataBinary;s&&!n&&(t=t.pipe(new a.Utf8EncodeWorker)),!s&&n&&(t=t.pipe(new a.Utf8DecodeWorker))}catch(e){(t=new h("error")).error(e)}return new i(t,r,"")},async:function(e,t){return this.internalStream(e).accumulate(t)},nodeStream:function(e,t){return this.internalStream(e||"nodebuffer").toNodejsStream(t)},_compressWorker:function(e,t){if(this._data instanceof o&&this._data.compression.magic===e.magic)return this._data.getCompressedWorker();var r=this._decompressWorker();return this._dataBinary||(r=r.pipe(new a.Utf8EncodeWorker)),o.createWorkerFrom(r,e,t)},_decompressWorker:function(){return this._data instanceof o?this._data.getContentWorker():this._data instanceof h?this._data:new s(this._data)}};for(var u=["asText","asBinary","asNodeBuffer","asUint8Array","asArrayBuffer"],l=function(){throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.")},f=0;f<u.length;f++)n.prototype[u[f]]=l;t.exports=n},{"./compressedObject":2,"./stream/DataWorker":27,"./stream/GenericWorker":28,"./stream/StreamHelper":29,"./utf8":31}],36:[function(e,t,n){(function(e){"use strict";var r,n,i=e.MutationObserver||e.WebKitMutationObserver;if(i){var s=0,a=new i(l),o=e.document.createTextNode("");a.observe(o,{characterData:!0}),r=function(){o.data=s=++s%2}}else if(e.setImmediate||void 0===e.MessageChannel)r="document"in e&&"onreadystatechange"in e.document.createElement("script")?function(){var t=e.document.createElement("script");t.onreadystatechange=function(){l(),t.onreadystatechange=null,t.parentNode.removeChild(t),t=null},e.document.documentElement.appendChild(t)}:function(){setTimeout(l,0)};else{var h=new e.MessageChannel;h.port1.onmessage=l,r=function(){h.port2.postMessage(0)}}var u=[];function l(){var e,t;n=!0;for(var r=u.length;r;){for(t=u,u=[],e=-1;++e<r;)t[e]();r=u.length}n=!1}t.exports=function(e){1!==u.push(e)||n||r()}}).call(this,"undefined"!=typeof r.g?r.g:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{}],37:[function(e,t,r){"use strict";var n=e("immediate");function i(){}var s={},a=["REJECTED"],o=["FULFILLED"],h=["PENDING"];function u(e){if("function"!=typeof e)throw new TypeError("resolver must be a function");this.state=h,this.queue=[],this.outcome=void 0,e!==i&&d(this,e)}function l(e,t,r){this.promise=e,"function"==typeof t&&(this.onFulfilled=t,this.callFulfilled=this.otherCallFulfilled),"function"==typeof r&&(this.onRejected=r,this.callRejected=this.otherCallRejected)}function f(e,t,r){n((function(){var n;try{n=t(r)}catch(n){return s.reject(e,n)}n===e?s.reject(e,new TypeError("Cannot resolve promise with itself")):s.resolve(e,n)}))}function c(e){var t=e&&e.then;if(e&&("object"==typeof e||"function"==typeof e)&&"function"==typeof t)return function(){t.apply(e,arguments)}}function d(e,t){var r=!1;function n(t){r||(r=!0,s.reject(e,t))}function i(t){r||(r=!0,s.resolve(e,t))}var a=p((function(){t(i,n)}));"error"===a.status&&n(a.value)}function p(e,t){var r={};try{r.value=e(t),r.status="success"}catch(e){r.status="error",r.value=e}return r}(t.exports=u).prototype.finally=function(e){if("function"!=typeof e)return this;var t=this.constructor;return this.then((function(r){return t.resolve(e()).then((function(){return r}))}),(function(r){return t.resolve(e()).then((function(){throw r}))}))},u.prototype.catch=function(e){return this.then(null,e)},u.prototype.then=function(e,t){if("function"!=typeof e&&this.state===o||"function"!=typeof t&&this.state===a)return this;var r=new this.constructor(i);return this.state!==h?f(r,this.state===o?e:t,this.outcome):this.queue.push(new l(r,e,t)),r},l.prototype.callFulfilled=function(e){s.resolve(this.promise,e)},l.prototype.otherCallFulfilled=function(e){f(this.promise,this.onFulfilled,e)},l.prototype.callRejected=function(e){s.reject(this.promise,e)},l.prototype.otherCallRejected=function(e){f(this.promise,this.onRejected,e)},s.resolve=function(e,t){var r=p(c,t);if("error"===r.status)return s.reject(e,r.value);var n=r.value;if(n)d(e,n);else{e.state=o,e.outcome=t;for(var i=-1,a=e.queue.length;++i<a;)e.queue[i].callFulfilled(t)}return e},s.reject=function(e,t){e.state=a,e.outcome=t;for(var r=-1,n=e.queue.length;++r<n;)e.queue[r].callRejected(t);return e},u.resolve=function(e){return e instanceof this?e:s.resolve(new this(i),e)},u.reject=function(e){var t=new this(i);return s.reject(t,e)},u.all=function(e){var t=this;if("[object Array]"!==Object.prototype.toString.call(e))return this.reject(new TypeError("must be an array"));var r=e.length,n=!1;if(!r)return this.resolve([]);for(var a=new Array(r),o=0,h=-1,u=new this(i);++h<r;)l(e[h],h);return u;function l(e,i){t.resolve(e).then((function(e){a[i]=e,++o!==r||n||(n=!0,s.resolve(u,a))}),(function(e){n||(n=!0,s.reject(u,e))}))}},u.race=function(e){var t=this;if("[object Array]"!==Object.prototype.toString.call(e))return this.reject(new TypeError("must be an array"));var r=e.length,n=!1;if(!r)return this.resolve([]);for(var a,o=-1,h=new this(i);++o<r;)a=e[o],t.resolve(a).then((function(e){n||(n=!0,s.resolve(h,e))}),(function(e){n||(n=!0,s.reject(h,e))}));return h}},{immediate:36}],38:[function(e,t,r){"use strict";var n={};(0,e("./lib/utils/common").assign)(n,e("./lib/deflate"),e("./lib/inflate"),e("./lib/zlib/constants")),t.exports=n},{"./lib/deflate":39,"./lib/inflate":40,"./lib/utils/common":41,"./lib/zlib/constants":44}],39:[function(e,t,r){"use strict";var n=e("./zlib/deflate"),i=e("./utils/common"),s=e("./utils/strings"),a=e("./zlib/messages"),o=e("./zlib/zstream"),h=Object.prototype.toString,u=0,l=-1,f=0,c=8;function d(e){if(!(this instanceof d))return new d(e);this.options=i.assign({level:l,method:c,chunkSize:16384,windowBits:15,memLevel:8,strategy:f,to:""},e||{});var t=this.options;t.raw&&0<t.windowBits?t.windowBits=-t.windowBits:t.gzip&&0<t.windowBits&&t.windowBits<16&&(t.windowBits+=16),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new o,this.strm.avail_out=0;var r=n.deflateInit2(this.strm,t.level,t.method,t.windowBits,t.memLevel,t.strategy);if(r!==u)throw new Error(a[r]);if(t.header&&n.deflateSetHeader(this.strm,t.header),t.dictionary){var p;if(p="string"==typeof t.dictionary?s.string2buf(t.dictionary):"[object ArrayBuffer]"===h.call(t.dictionary)?new Uint8Array(t.dictionary):t.dictionary,(r=n.deflateSetDictionary(this.strm,p))!==u)throw new Error(a[r]);this._dict_set=!0}}function p(e,t){var r=new d(t);if(r.push(e,!0),r.err)throw r.msg||a[r.err];return r.result}d.prototype.push=function(e,t){var r,a,o=this.strm,l=this.options.chunkSize;if(this.ended)return!1;a=t===~~t?t:!0===t?4:0,"string"==typeof e?o.input=s.string2buf(e):"[object ArrayBuffer]"===h.call(e)?o.input=new Uint8Array(e):o.input=e,o.next_in=0,o.avail_in=o.input.length;do{if(0===o.avail_out&&(o.output=new i.Buf8(l),o.next_out=0,o.avail_out=l),1!==(r=n.deflate(o,a))&&r!==u)return this.onEnd(r),!(this.ended=!0);0!==o.avail_out&&(0!==o.avail_in||4!==a&&2!==a)||("string"===this.options.to?this.onData(s.buf2binstring(i.shrinkBuf(o.output,o.next_out))):this.onData(i.shrinkBuf(o.output,o.next_out)))}while((0<o.avail_in||0===o.avail_out)&&1!==r);return 4===a?(r=n.deflateEnd(this.strm),this.onEnd(r),this.ended=!0,r===u):2!==a||(this.onEnd(u),!(o.avail_out=0))},d.prototype.onData=function(e){this.chunks.push(e)},d.prototype.onEnd=function(e){e===u&&("string"===this.options.to?this.result=this.chunks.join(""):this.result=i.flattenChunks(this.chunks)),this.chunks=[],this.err=e,this.msg=this.strm.msg},r.Deflate=d,r.deflate=p,r.deflateRaw=function(e,t){return(t=t||{}).raw=!0,p(e,t)},r.gzip=function(e,t){return(t=t||{}).gzip=!0,p(e,t)}},{"./utils/common":41,"./utils/strings":42,"./zlib/deflate":46,"./zlib/messages":51,"./zlib/zstream":53}],40:[function(e,t,r){"use strict";var n=e("./zlib/inflate"),i=e("./utils/common"),s=e("./utils/strings"),a=e("./zlib/constants"),o=e("./zlib/messages"),h=e("./zlib/zstream"),u=e("./zlib/gzheader"),l=Object.prototype.toString;function f(e){if(!(this instanceof f))return new f(e);this.options=i.assign({chunkSize:16384,windowBits:0,to:""},e||{});var t=this.options;t.raw&&0<=t.windowBits&&t.windowBits<16&&(t.windowBits=-t.windowBits,0===t.windowBits&&(t.windowBits=-15)),!(0<=t.windowBits&&t.windowBits<16)||e&&e.windowBits||(t.windowBits+=32),15<t.windowBits&&t.windowBits<48&&0==(15&t.windowBits)&&(t.windowBits|=15),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new h,this.strm.avail_out=0;var r=n.inflateInit2(this.strm,t.windowBits);if(r!==a.Z_OK)throw new Error(o[r]);this.header=new u,n.inflateGetHeader(this.strm,this.header)}function c(e,t){var r=new f(t);if(r.push(e,!0),r.err)throw r.msg||o[r.err];return r.result}f.prototype.push=function(e,t){var r,o,h,u,f,c,d=this.strm,p=this.options.chunkSize,m=this.options.dictionary,_=!1;if(this.ended)return!1;o=t===~~t?t:!0===t?a.Z_FINISH:a.Z_NO_FLUSH,"string"==typeof e?d.input=s.binstring2buf(e):"[object ArrayBuffer]"===l.call(e)?d.input=new Uint8Array(e):d.input=e,d.next_in=0,d.avail_in=d.input.length;do{if(0===d.avail_out&&(d.output=new i.Buf8(p),d.next_out=0,d.avail_out=p),(r=n.inflate(d,a.Z_NO_FLUSH))===a.Z_NEED_DICT&&m&&(c="string"==typeof m?s.string2buf(m):"[object ArrayBuffer]"===l.call(m)?new Uint8Array(m):m,r=n.inflateSetDictionary(this.strm,c)),r===a.Z_BUF_ERROR&&!0===_&&(r=a.Z_OK,_=!1),r!==a.Z_STREAM_END&&r!==a.Z_OK)return this.onEnd(r),!(this.ended=!0);d.next_out&&(0!==d.avail_out&&r!==a.Z_STREAM_END&&(0!==d.avail_in||o!==a.Z_FINISH&&o!==a.Z_SYNC_FLUSH)||("string"===this.options.to?(h=s.utf8border(d.output,d.next_out),u=d.next_out-h,f=s.buf2string(d.output,h),d.next_out=u,d.avail_out=p-u,u&&i.arraySet(d.output,d.output,h,u,0),this.onData(f)):this.onData(i.shrinkBuf(d.output,d.next_out)))),0===d.avail_in&&0===d.avail_out&&(_=!0)}while((0<d.avail_in||0===d.avail_out)&&r!==a.Z_STREAM_END);return r===a.Z_STREAM_END&&(o=a.Z_FINISH),o===a.Z_FINISH?(r=n.inflateEnd(this.strm),this.onEnd(r),this.ended=!0,r===a.Z_OK):o!==a.Z_SYNC_FLUSH||(this.onEnd(a.Z_OK),!(d.avail_out=0))},f.prototype.onData=function(e){this.chunks.push(e)},f.prototype.onEnd=function(e){e===a.Z_OK&&("string"===this.options.to?this.result=this.chunks.join(""):this.result=i.flattenChunks(this.chunks)),this.chunks=[],this.err=e,this.msg=this.strm.msg},r.Inflate=f,r.inflate=c,r.inflateRaw=function(e,t){return(t=t||{}).raw=!0,c(e,t)},r.ungzip=c},{"./utils/common":41,"./utils/strings":42,"./zlib/constants":44,"./zlib/gzheader":47,"./zlib/inflate":49,"./zlib/messages":51,"./zlib/zstream":53}],41:[function(e,t,r){"use strict";var n="undefined"!=typeof Uint8Array&&"undefined"!=typeof Uint16Array&&"undefined"!=typeof Int32Array;r.assign=function(e){for(var t=Array.prototype.slice.call(arguments,1);t.length;){var r=t.shift();if(r){if("object"!=typeof r)throw new TypeError(r+"must be non-object");for(var n in r)r.hasOwnProperty(n)&&(e[n]=r[n])}}return e},r.shrinkBuf=function(e,t){return e.length===t?e:e.subarray?e.subarray(0,t):(e.length=t,e)};var i={arraySet:function(e,t,r,n,i){if(t.subarray&&e.subarray)e.set(t.subarray(r,r+n),i);else for(var s=0;s<n;s++)e[i+s]=t[r+s]},flattenChunks:function(e){var t,r,n,i,s,a;for(t=n=0,r=e.length;t<r;t++)n+=e[t].length;for(a=new Uint8Array(n),t=i=0,r=e.length;t<r;t++)s=e[t],a.set(s,i),i+=s.length;return a}},s={arraySet:function(e,t,r,n,i){for(var s=0;s<n;s++)e[i+s]=t[r+s]},flattenChunks:function(e){return[].concat.apply([],e)}};r.setTyped=function(e){e?(r.Buf8=Uint8Array,r.Buf16=Uint16Array,r.Buf32=Int32Array,r.assign(r,i)):(r.Buf8=Array,r.Buf16=Array,r.Buf32=Array,r.assign(r,s))},r.setTyped(n)},{}],42:[function(e,t,r){"use strict";var n=e("./common"),i=!0,s=!0;try{String.fromCharCode.apply(null,[0])}catch(e){i=!1}try{String.fromCharCode.apply(null,new Uint8Array(1))}catch(e){s=!1}for(var a=new n.Buf8(256),o=0;o<256;o++)a[o]=252<=o?6:248<=o?5:240<=o?4:224<=o?3:192<=o?2:1;function h(e,t){if(t<65537&&(e.subarray&&s||!e.subarray&&i))return String.fromCharCode.apply(null,n.shrinkBuf(e,t));for(var r="",a=0;a<t;a++)r+=String.fromCharCode(e[a]);return r}a[254]=a[254]=1,r.string2buf=function(e){var t,r,i,s,a,o=e.length,h=0;for(s=0;s<o;s++)55296==(64512&(r=e.charCodeAt(s)))&&s+1<o&&56320==(64512&(i=e.charCodeAt(s+1)))&&(r=65536+(r-55296<<10)+(i-56320),s++),h+=r<128?1:r<2048?2:r<65536?3:4;for(t=new n.Buf8(h),s=a=0;a<h;s++)55296==(64512&(r=e.charCodeAt(s)))&&s+1<o&&56320==(64512&(i=e.charCodeAt(s+1)))&&(r=65536+(r-55296<<10)+(i-56320),s++),r<128?t[a++]=r:(r<2048?t[a++]=192|r>>>6:(r<65536?t[a++]=224|r>>>12:(t[a++]=240|r>>>18,t[a++]=128|r>>>12&63),t[a++]=128|r>>>6&63),t[a++]=128|63&r);return t},r.buf2binstring=function(e){return h(e,e.length)},r.binstring2buf=function(e){for(var t=new n.Buf8(e.length),r=0,i=t.length;r<i;r++)t[r]=e.charCodeAt(r);return t},r.buf2string=function(e,t){var r,n,i,s,o=t||e.length,u=new Array(2*o);for(r=n=0;r<o;)if((i=e[r++])<128)u[n++]=i;else if(4<(s=a[i]))u[n++]=65533,r+=s-1;else{for(i&=2===s?31:3===s?15:7;1<s&&r<o;)i=i<<6|63&e[r++],s--;1<s?u[n++]=65533:i<65536?u[n++]=i:(i-=65536,u[n++]=55296|i>>10&1023,u[n++]=56320|1023&i)}return h(u,n)},r.utf8border=function(e,t){var r;for((t=t||e.length)>e.length&&(t=e.length),r=t-1;0<=r&&128==(192&e[r]);)r--;return r<0||0===r?t:r+a[e[r]]>t?r:t}},{"./common":41}],43:[function(e,t,r){"use strict";t.exports=function(e,t,r,n){for(var i=65535&e|0,s=e>>>16&65535|0,a=0;0!==r;){for(r-=a=2e3<r?2e3:r;s=s+(i=i+t[n++]|0)|0,--a;);i%=65521,s%=65521}return i|s<<16|0}},{}],44:[function(e,t,r){"use strict";t.exports={Z_NO_FLUSH:0,Z_PARTIAL_FLUSH:1,Z_SYNC_FLUSH:2,Z_FULL_FLUSH:3,Z_FINISH:4,Z_BLOCK:5,Z_TREES:6,Z_OK:0,Z_STREAM_END:1,Z_NEED_DICT:2,Z_ERRNO:-1,Z_STREAM_ERROR:-2,Z_DATA_ERROR:-3,Z_BUF_ERROR:-5,Z_NO_COMPRESSION:0,Z_BEST_SPEED:1,Z_BEST_COMPRESSION:9,Z_DEFAULT_COMPRESSION:-1,Z_FILTERED:1,Z_HUFFMAN_ONLY:2,Z_RLE:3,Z_FIXED:4,Z_DEFAULT_STRATEGY:0,Z_BINARY:0,Z_TEXT:1,Z_UNKNOWN:2,Z_DEFLATED:8}},{}],45:[function(e,t,r){"use strict";var n=function(){for(var e,t=[],r=0;r<256;r++){e=r;for(var n=0;n<8;n++)e=1&e?3988292384^e>>>1:e>>>1;t[r]=e}return t}();t.exports=function(e,t,r,i){var s=n,a=i+r;e^=-1;for(var o=i;o<a;o++)e=e>>>8^s[255&(e^t[o])];return-1^e}},{}],46:[function(e,t,r){"use strict";var n,i=e("../utils/common"),s=e("./trees"),a=e("./adler32"),o=e("./crc32"),h=e("./messages"),u=0,l=4,f=0,c=-2,d=-1,p=4,m=2,_=8,g=9,b=286,v=30,y=19,w=2*b+1,k=15,x=3,S=258,z=S+x+1,C=42,E=113,A=1,I=2,O=3,B=4;function R(e,t){return e.msg=h[t],t}function T(e){return(e<<1)-(4<e?9:0)}function D(e){for(var t=e.length;0<=--t;)e[t]=0}function F(e){var t=e.state,r=t.pending;r>e.avail_out&&(r=e.avail_out),0!==r&&(i.arraySet(e.output,t.pending_buf,t.pending_out,r,e.next_out),e.next_out+=r,t.pending_out+=r,e.total_out+=r,e.avail_out-=r,t.pending-=r,0===t.pending&&(t.pending_out=0))}function N(e,t){s._tr_flush_block(e,0<=e.block_start?e.block_start:-1,e.strstart-e.block_start,t),e.block_start=e.strstart,F(e.strm)}function U(e,t){e.pending_buf[e.pending++]=t}function P(e,t){e.pending_buf[e.pending++]=t>>>8&255,e.pending_buf[e.pending++]=255&t}function L(e,t){var r,n,i=e.max_chain_length,s=e.strstart,a=e.prev_length,o=e.nice_match,h=e.strstart>e.w_size-z?e.strstart-(e.w_size-z):0,u=e.window,l=e.w_mask,f=e.prev,c=e.strstart+S,d=u[s+a-1],p=u[s+a];e.prev_length>=e.good_match&&(i>>=2),o>e.lookahead&&(o=e.lookahead);do{if(u[(r=t)+a]===p&&u[r+a-1]===d&&u[r]===u[s]&&u[++r]===u[s+1]){s+=2,r++;do{}while(u[++s]===u[++r]&&u[++s]===u[++r]&&u[++s]===u[++r]&&u[++s]===u[++r]&&u[++s]===u[++r]&&u[++s]===u[++r]&&u[++s]===u[++r]&&u[++s]===u[++r]&&s<c);if(n=S-(c-s),s=c-S,a<n){if(e.match_start=t,o<=(a=n))break;d=u[s+a-1],p=u[s+a]}}}while((t=f[t&l])>h&&0!=--i);return a<=e.lookahead?a:e.lookahead}function j(e){var t,r,n,s,h,u,l,f,c,d,p=e.w_size;do{if(s=e.window_size-e.lookahead-e.strstart,e.strstart>=p+(p-z)){for(i.arraySet(e.window,e.window,p,p,0),e.match_start-=p,e.strstart-=p,e.block_start-=p,t=r=e.hash_size;n=e.head[--t],e.head[t]=p<=n?n-p:0,--r;);for(t=r=p;n=e.prev[--t],e.prev[t]=p<=n?n-p:0,--r;);s+=p}if(0===e.strm.avail_in)break;if(u=e.strm,l=e.window,f=e.strstart+e.lookahead,c=s,d=void 0,d=u.avail_in,c<d&&(d=c),r=0===d?0:(u.avail_in-=d,i.arraySet(l,u.input,u.next_in,d,f),1===u.state.wrap?u.adler=a(u.adler,l,d,f):2===u.state.wrap&&(u.adler=o(u.adler,l,d,f)),u.next_in+=d,u.total_in+=d,d),e.lookahead+=r,e.lookahead+e.insert>=x)for(h=e.strstart-e.insert,e.ins_h=e.window[h],e.ins_h=(e.ins_h<<e.hash_shift^e.window[h+1])&e.hash_mask;e.insert&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[h+x-1])&e.hash_mask,e.prev[h&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=h,h++,e.insert--,!(e.lookahead+e.insert<x)););}while(e.lookahead<z&&0!==e.strm.avail_in)}function Z(e,t){for(var r,n;;){if(e.lookahead<z){if(j(e),e.lookahead<z&&t===u)return A;if(0===e.lookahead)break}if(r=0,e.lookahead>=x&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+x-1])&e.hash_mask,r=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),0!==r&&e.strstart-r<=e.w_size-z&&(e.match_length=L(e,r)),e.match_length>=x)if(n=s._tr_tally(e,e.strstart-e.match_start,e.match_length-x),e.lookahead-=e.match_length,e.match_length<=e.max_lazy_match&&e.lookahead>=x){for(e.match_length--;e.strstart++,e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+x-1])&e.hash_mask,r=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart,0!=--e.match_length;);e.strstart++}else e.strstart+=e.match_length,e.match_length=0,e.ins_h=e.window[e.strstart],e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+1])&e.hash_mask;else n=s._tr_tally(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++;if(n&&(N(e,!1),0===e.strm.avail_out))return A}return e.insert=e.strstart<x-1?e.strstart:x-1,t===l?(N(e,!0),0===e.strm.avail_out?O:B):e.last_lit&&(N(e,!1),0===e.strm.avail_out)?A:I}function W(e,t){for(var r,n,i;;){if(e.lookahead<z){if(j(e),e.lookahead<z&&t===u)return A;if(0===e.lookahead)break}if(r=0,e.lookahead>=x&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+x-1])&e.hash_mask,r=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),e.prev_length=e.match_length,e.prev_match=e.match_start,e.match_length=x-1,0!==r&&e.prev_length<e.max_lazy_match&&e.strstart-r<=e.w_size-z&&(e.match_length=L(e,r),e.match_length<=5&&(1===e.strategy||e.match_length===x&&4096<e.strstart-e.match_start)&&(e.match_length=x-1)),e.prev_length>=x&&e.match_length<=e.prev_length){for(i=e.strstart+e.lookahead-x,n=s._tr_tally(e,e.strstart-1-e.prev_match,e.prev_length-x),e.lookahead-=e.prev_length-1,e.prev_length-=2;++e.strstart<=i&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+x-1])&e.hash_mask,r=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),0!=--e.prev_length;);if(e.match_available=0,e.match_length=x-1,e.strstart++,n&&(N(e,!1),0===e.strm.avail_out))return A}else if(e.match_available){if((n=s._tr_tally(e,0,e.window[e.strstart-1]))&&N(e,!1),e.strstart++,e.lookahead--,0===e.strm.avail_out)return A}else e.match_available=1,e.strstart++,e.lookahead--}return e.match_available&&(n=s._tr_tally(e,0,e.window[e.strstart-1]),e.match_available=0),e.insert=e.strstart<x-1?e.strstart:x-1,t===l?(N(e,!0),0===e.strm.avail_out?O:B):e.last_lit&&(N(e,!1),0===e.strm.avail_out)?A:I}function M(e,t,r,n,i){this.good_length=e,this.max_lazy=t,this.nice_length=r,this.max_chain=n,this.func=i}function H(){this.strm=null,this.status=0,this.pending_buf=null,this.pending_buf_size=0,this.pending_out=0,this.pending=0,this.wrap=0,this.gzhead=null,this.gzindex=0,this.method=_,this.last_flush=-1,this.w_size=0,this.w_bits=0,this.w_mask=0,this.window=null,this.window_size=0,this.prev=null,this.head=null,this.ins_h=0,this.hash_size=0,this.hash_bits=0,this.hash_mask=0,this.hash_shift=0,this.block_start=0,this.match_length=0,this.prev_match=0,this.match_available=0,this.strstart=0,this.match_start=0,this.lookahead=0,this.prev_length=0,this.max_chain_length=0,this.max_lazy_match=0,this.level=0,this.strategy=0,this.good_match=0,this.nice_match=0,this.dyn_ltree=new i.Buf16(2*w),this.dyn_dtree=new i.Buf16(2*(2*v+1)),this.bl_tree=new i.Buf16(2*(2*y+1)),D(this.dyn_ltree),D(this.dyn_dtree),D(this.bl_tree),this.l_desc=null,this.d_desc=null,this.bl_desc=null,this.bl_count=new i.Buf16(k+1),this.heap=new i.Buf16(2*b+1),D(this.heap),this.heap_len=0,this.heap_max=0,this.depth=new i.Buf16(2*b+1),D(this.depth),this.l_buf=0,this.lit_bufsize=0,this.last_lit=0,this.d_buf=0,this.opt_len=0,this.static_len=0,this.matches=0,this.insert=0,this.bi_buf=0,this.bi_valid=0}function G(e){var t;return e&&e.state?(e.total_in=e.total_out=0,e.data_type=m,(t=e.state).pending=0,t.pending_out=0,t.wrap<0&&(t.wrap=-t.wrap),t.status=t.wrap?C:E,e.adler=2===t.wrap?0:1,t.last_flush=u,s._tr_init(t),f):R(e,c)}function K(e){var t=G(e);return t===f&&function(e){e.window_size=2*e.w_size,D(e.head),e.max_lazy_match=n[e.level].max_lazy,e.good_match=n[e.level].good_length,e.nice_match=n[e.level].nice_length,e.max_chain_length=n[e.level].max_chain,e.strstart=0,e.block_start=0,e.lookahead=0,e.insert=0,e.match_length=e.prev_length=x-1,e.match_available=0,e.ins_h=0}(e.state),t}function Y(e,t,r,n,s,a){if(!e)return c;var o=1;if(t===d&&(t=6),n<0?(o=0,n=-n):15<n&&(o=2,n-=16),s<1||g<s||r!==_||n<8||15<n||t<0||9<t||a<0||p<a)return R(e,c);8===n&&(n=9);var h=new H;return(e.state=h).strm=e,h.wrap=o,h.gzhead=null,h.w_bits=n,h.w_size=1<<h.w_bits,h.w_mask=h.w_size-1,h.hash_bits=s+7,h.hash_size=1<<h.hash_bits,h.hash_mask=h.hash_size-1,h.hash_shift=~~((h.hash_bits+x-1)/x),h.window=new i.Buf8(2*h.w_size),h.head=new i.Buf16(h.hash_size),h.prev=new i.Buf16(h.w_size),h.lit_bufsize=1<<s+6,h.pending_buf_size=4*h.lit_bufsize,h.pending_buf=new i.Buf8(h.pending_buf_size),h.d_buf=1*h.lit_bufsize,h.l_buf=3*h.lit_bufsize,h.level=t,h.strategy=a,h.method=r,K(e)}n=[new M(0,0,0,0,(function(e,t){var r=65535;for(r>e.pending_buf_size-5&&(r=e.pending_buf_size-5);;){if(e.lookahead<=1){if(j(e),0===e.lookahead&&t===u)return A;if(0===e.lookahead)break}e.strstart+=e.lookahead,e.lookahead=0;var n=e.block_start+r;if((0===e.strstart||e.strstart>=n)&&(e.lookahead=e.strstart-n,e.strstart=n,N(e,!1),0===e.strm.avail_out))return A;if(e.strstart-e.block_start>=e.w_size-z&&(N(e,!1),0===e.strm.avail_out))return A}return e.insert=0,t===l?(N(e,!0),0===e.strm.avail_out?O:B):(e.strstart>e.block_start&&(N(e,!1),e.strm.avail_out),A)})),new M(4,4,8,4,Z),new M(4,5,16,8,Z),new M(4,6,32,32,Z),new M(4,4,16,16,W),new M(8,16,32,32,W),new M(8,16,128,128,W),new M(8,32,128,256,W),new M(32,128,258,1024,W),new M(32,258,258,4096,W)],r.deflateInit=function(e,t){return Y(e,t,_,15,8,0)},r.deflateInit2=Y,r.deflateReset=K,r.deflateResetKeep=G,r.deflateSetHeader=function(e,t){return e&&e.state?2!==e.state.wrap?c:(e.state.gzhead=t,f):c},r.deflate=function(e,t){var r,i,a,h;if(!e||!e.state||5<t||t<0)return e?R(e,c):c;if(i=e.state,!e.output||!e.input&&0!==e.avail_in||666===i.status&&t!==l)return R(e,0===e.avail_out?-5:c);if(i.strm=e,r=i.last_flush,i.last_flush=t,i.status===C)if(2===i.wrap)e.adler=0,U(i,31),U(i,139),U(i,8),i.gzhead?(U(i,(i.gzhead.text?1:0)+(i.gzhead.hcrc?2:0)+(i.gzhead.extra?4:0)+(i.gzhead.name?8:0)+(i.gzhead.comment?16:0)),U(i,255&i.gzhead.time),U(i,i.gzhead.time>>8&255),U(i,i.gzhead.time>>16&255),U(i,i.gzhead.time>>24&255),U(i,9===i.level?2:2<=i.strategy||i.level<2?4:0),U(i,255&i.gzhead.os),i.gzhead.extra&&i.gzhead.extra.length&&(U(i,255&i.gzhead.extra.length),U(i,i.gzhead.extra.length>>8&255)),i.gzhead.hcrc&&(e.adler=o(e.adler,i.pending_buf,i.pending,0)),i.gzindex=0,i.status=69):(U(i,0),U(i,0),U(i,0),U(i,0),U(i,0),U(i,9===i.level?2:2<=i.strategy||i.level<2?4:0),U(i,3),i.status=E);else{var d=_+(i.w_bits-8<<4)<<8;d|=(2<=i.strategy||i.level<2?0:i.level<6?1:6===i.level?2:3)<<6,0!==i.strstart&&(d|=32),d+=31-d%31,i.status=E,P(i,d),0!==i.strstart&&(P(i,e.adler>>>16),P(i,65535&e.adler)),e.adler=1}if(69===i.status)if(i.gzhead.extra){for(a=i.pending;i.gzindex<(65535&i.gzhead.extra.length)&&(i.pending!==i.pending_buf_size||(i.gzhead.hcrc&&i.pending>a&&(e.adler=o(e.adler,i.pending_buf,i.pending-a,a)),F(e),a=i.pending,i.pending!==i.pending_buf_size));)U(i,255&i.gzhead.extra[i.gzindex]),i.gzindex++;i.gzhead.hcrc&&i.pending>a&&(e.adler=o(e.adler,i.pending_buf,i.pending-a,a)),i.gzindex===i.gzhead.extra.length&&(i.gzindex=0,i.status=73)}else i.status=73;if(73===i.status)if(i.gzhead.name){a=i.pending;do{if(i.pending===i.pending_buf_size&&(i.gzhead.hcrc&&i.pending>a&&(e.adler=o(e.adler,i.pending_buf,i.pending-a,a)),F(e),a=i.pending,i.pending===i.pending_buf_size)){h=1;break}h=i.gzindex<i.gzhead.name.length?255&i.gzhead.name.charCodeAt(i.gzindex++):0,U(i,h)}while(0!==h);i.gzhead.hcrc&&i.pending>a&&(e.adler=o(e.adler,i.pending_buf,i.pending-a,a)),0===h&&(i.gzindex=0,i.status=91)}else i.status=91;if(91===i.status)if(i.gzhead.comment){a=i.pending;do{if(i.pending===i.pending_buf_size&&(i.gzhead.hcrc&&i.pending>a&&(e.adler=o(e.adler,i.pending_buf,i.pending-a,a)),F(e),a=i.pending,i.pending===i.pending_buf_size)){h=1;break}h=i.gzindex<i.gzhead.comment.length?255&i.gzhead.comment.charCodeAt(i.gzindex++):0,U(i,h)}while(0!==h);i.gzhead.hcrc&&i.pending>a&&(e.adler=o(e.adler,i.pending_buf,i.pending-a,a)),0===h&&(i.status=103)}else i.status=103;if(103===i.status&&(i.gzhead.hcrc?(i.pending+2>i.pending_buf_size&&F(e),i.pending+2<=i.pending_buf_size&&(U(i,255&e.adler),U(i,e.adler>>8&255),e.adler=0,i.status=E)):i.status=E),0!==i.pending){if(F(e),0===e.avail_out)return i.last_flush=-1,f}else if(0===e.avail_in&&T(t)<=T(r)&&t!==l)return R(e,-5);if(666===i.status&&0!==e.avail_in)return R(e,-5);if(0!==e.avail_in||0!==i.lookahead||t!==u&&666!==i.status){var p=2===i.strategy?function(e,t){for(var r;;){if(0===e.lookahead&&(j(e),0===e.lookahead)){if(t===u)return A;break}if(e.match_length=0,r=s._tr_tally(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++,r&&(N(e,!1),0===e.strm.avail_out))return A}return e.insert=0,t===l?(N(e,!0),0===e.strm.avail_out?O:B):e.last_lit&&(N(e,!1),0===e.strm.avail_out)?A:I}(i,t):3===i.strategy?function(e,t){for(var r,n,i,a,o=e.window;;){if(e.lookahead<=S){if(j(e),e.lookahead<=S&&t===u)return A;if(0===e.lookahead)break}if(e.match_length=0,e.lookahead>=x&&0<e.strstart&&(n=o[i=e.strstart-1])===o[++i]&&n===o[++i]&&n===o[++i]){a=e.strstart+S;do{}while(n===o[++i]&&n===o[++i]&&n===o[++i]&&n===o[++i]&&n===o[++i]&&n===o[++i]&&n===o[++i]&&n===o[++i]&&i<a);e.match_length=S-(a-i),e.match_length>e.lookahead&&(e.match_length=e.lookahead)}if(e.match_length>=x?(r=s._tr_tally(e,1,e.match_length-x),e.lookahead-=e.match_length,e.strstart+=e.match_length,e.match_length=0):(r=s._tr_tally(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++),r&&(N(e,!1),0===e.strm.avail_out))return A}return e.insert=0,t===l?(N(e,!0),0===e.strm.avail_out?O:B):e.last_lit&&(N(e,!1),0===e.strm.avail_out)?A:I}(i,t):n[i.level].func(i,t);if(p!==O&&p!==B||(i.status=666),p===A||p===O)return 0===e.avail_out&&(i.last_flush=-1),f;if(p===I&&(1===t?s._tr_align(i):5!==t&&(s._tr_stored_block(i,0,0,!1),3===t&&(D(i.head),0===i.lookahead&&(i.strstart=0,i.block_start=0,i.insert=0))),F(e),0===e.avail_out))return i.last_flush=-1,f}return t!==l?f:i.wrap<=0?1:(2===i.wrap?(U(i,255&e.adler),U(i,e.adler>>8&255),U(i,e.adler>>16&255),U(i,e.adler>>24&255),U(i,255&e.total_in),U(i,e.total_in>>8&255),U(i,e.total_in>>16&255),U(i,e.total_in>>24&255)):(P(i,e.adler>>>16),P(i,65535&e.adler)),F(e),0<i.wrap&&(i.wrap=-i.wrap),0!==i.pending?f:1)},r.deflateEnd=function(e){var t;return e&&e.state?(t=e.state.status)!==C&&69!==t&&73!==t&&91!==t&&103!==t&&t!==E&&666!==t?R(e,c):(e.state=null,t===E?R(e,-3):f):c},r.deflateSetDictionary=function(e,t){var r,n,s,o,h,u,l,d,p=t.length;if(!e||!e.state)return c;if(2===(o=(r=e.state).wrap)||1===o&&r.status!==C||r.lookahead)return c;for(1===o&&(e.adler=a(e.adler,t,p,0)),r.wrap=0,p>=r.w_size&&(0===o&&(D(r.head),r.strstart=0,r.block_start=0,r.insert=0),d=new i.Buf8(r.w_size),i.arraySet(d,t,p-r.w_size,r.w_size,0),t=d,p=r.w_size),h=e.avail_in,u=e.next_in,l=e.input,e.avail_in=p,e.next_in=0,e.input=t,j(r);r.lookahead>=x;){for(n=r.strstart,s=r.lookahead-(x-1);r.ins_h=(r.ins_h<<r.hash_shift^r.window[n+x-1])&r.hash_mask,r.prev[n&r.w_mask]=r.head[r.ins_h],r.head[r.ins_h]=n,n++,--s;);r.strstart=n,r.lookahead=x-1,j(r)}return r.strstart+=r.lookahead,r.block_start=r.strstart,r.insert=r.lookahead,r.lookahead=0,r.match_length=r.prev_length=x-1,r.match_available=0,e.next_in=u,e.input=l,e.avail_in=h,r.wrap=o,f},r.deflateInfo="pako deflate (from Nodeca project)"},{"../utils/common":41,"./adler32":43,"./crc32":45,"./messages":51,"./trees":52}],47:[function(e,t,r){"use strict";t.exports=function(){this.text=0,this.time=0,this.xflags=0,this.os=0,this.extra=null,this.extra_len=0,this.name="",this.comment="",this.hcrc=0,this.done=!1}},{}],48:[function(e,t,r){"use strict";t.exports=function(e,t){var r,n,i,s,a,o,h,u,l,f,c,d,p,m,_,g,b,v,y,w,k,x,S,z,C;r=e.state,n=e.next_in,z=e.input,i=n+(e.avail_in-5),s=e.next_out,C=e.output,a=s-(t-e.avail_out),o=s+(e.avail_out-257),h=r.dmax,u=r.wsize,l=r.whave,f=r.wnext,c=r.window,d=r.hold,p=r.bits,m=r.lencode,_=r.distcode,g=(1<<r.lenbits)-1,b=(1<<r.distbits)-1;e:do{p<15&&(d+=z[n++]<<p,p+=8,d+=z[n++]<<p,p+=8),v=m[d&g];t:for(;;){if(d>>>=y=v>>>24,p-=y,0===(y=v>>>16&255))C[s++]=65535&v;else{if(!(16&y)){if(0==(64&y)){v=m[(65535&v)+(d&(1<<y)-1)];continue t}if(32&y){r.mode=12;break e}e.msg="invalid literal/length code",r.mode=30;break e}w=65535&v,(y&=15)&&(p<y&&(d+=z[n++]<<p,p+=8),w+=d&(1<<y)-1,d>>>=y,p-=y),p<15&&(d+=z[n++]<<p,p+=8,d+=z[n++]<<p,p+=8),v=_[d&b];r:for(;;){if(d>>>=y=v>>>24,p-=y,!(16&(y=v>>>16&255))){if(0==(64&y)){v=_[(65535&v)+(d&(1<<y)-1)];continue r}e.msg="invalid distance code",r.mode=30;break e}if(k=65535&v,p<(y&=15)&&(d+=z[n++]<<p,(p+=8)<y&&(d+=z[n++]<<p,p+=8)),h<(k+=d&(1<<y)-1)){e.msg="invalid distance too far back",r.mode=30;break e}if(d>>>=y,p-=y,(y=s-a)<k){if(l<(y=k-y)&&r.sane){e.msg="invalid distance too far back",r.mode=30;break e}if(S=c,(x=0)===f){if(x+=u-y,y<w){for(w-=y;C[s++]=c[x++],--y;);x=s-k,S=C}}else if(f<y){if(x+=u+f-y,(y-=f)<w){for(w-=y;C[s++]=c[x++],--y;);if(x=0,f<w){for(w-=y=f;C[s++]=c[x++],--y;);x=s-k,S=C}}}else if(x+=f-y,y<w){for(w-=y;C[s++]=c[x++],--y;);x=s-k,S=C}for(;2<w;)C[s++]=S[x++],C[s++]=S[x++],C[s++]=S[x++],w-=3;w&&(C[s++]=S[x++],1<w&&(C[s++]=S[x++]))}else{for(x=s-k;C[s++]=C[x++],C[s++]=C[x++],C[s++]=C[x++],2<(w-=3););w&&(C[s++]=C[x++],1<w&&(C[s++]=C[x++]))}break}}break}}while(n<i&&s<o);n-=w=p>>3,d&=(1<<(p-=w<<3))-1,e.next_in=n,e.next_out=s,e.avail_in=n<i?i-n+5:5-(n-i),e.avail_out=s<o?o-s+257:257-(s-o),r.hold=d,r.bits=p}},{}],49:[function(e,t,r){"use strict";var n=e("../utils/common"),i=e("./adler32"),s=e("./crc32"),a=e("./inffast"),o=e("./inftrees"),h=1,u=2,l=0,f=-2,c=1,d=852,p=592;function m(e){return(e>>>24&255)+(e>>>8&65280)+((65280&e)<<8)+((255&e)<<24)}function _(){this.mode=0,this.last=!1,this.wrap=0,this.havedict=!1,this.flags=0,this.dmax=0,this.check=0,this.total=0,this.head=null,this.wbits=0,this.wsize=0,this.whave=0,this.wnext=0,this.window=null,this.hold=0,this.bits=0,this.length=0,this.offset=0,this.extra=0,this.lencode=null,this.distcode=null,this.lenbits=0,this.distbits=0,this.ncode=0,this.nlen=0,this.ndist=0,this.have=0,this.next=null,this.lens=new n.Buf16(320),this.work=new n.Buf16(288),this.lendyn=null,this.distdyn=null,this.sane=0,this.back=0,this.was=0}function g(e){var t;return e&&e.state?(t=e.state,e.total_in=e.total_out=t.total=0,e.msg="",t.wrap&&(e.adler=1&t.wrap),t.mode=c,t.last=0,t.havedict=0,t.dmax=32768,t.head=null,t.hold=0,t.bits=0,t.lencode=t.lendyn=new n.Buf32(d),t.distcode=t.distdyn=new n.Buf32(p),t.sane=1,t.back=-1,l):f}function b(e){var t;return e&&e.state?((t=e.state).wsize=0,t.whave=0,t.wnext=0,g(e)):f}function v(e,t){var r,n;return e&&e.state?(n=e.state,t<0?(r=0,t=-t):(r=1+(t>>4),t<48&&(t&=15)),t&&(t<8||15<t)?f:(null!==n.window&&n.wbits!==t&&(n.window=null),n.wrap=r,n.wbits=t,b(e))):f}function y(e,t){var r,n;return e?(n=new _,(e.state=n).window=null,(r=v(e,t))!==l&&(e.state=null),r):f}var w,k,x=!0;function S(e){if(x){var t;for(w=new n.Buf32(512),k=new n.Buf32(32),t=0;t<144;)e.lens[t++]=8;for(;t<256;)e.lens[t++]=9;for(;t<280;)e.lens[t++]=7;for(;t<288;)e.lens[t++]=8;for(o(h,e.lens,0,288,w,0,e.work,{bits:9}),t=0;t<32;)e.lens[t++]=5;o(u,e.lens,0,32,k,0,e.work,{bits:5}),x=!1}e.lencode=w,e.lenbits=9,e.distcode=k,e.distbits=5}function z(e,t,r,i){var s,a=e.state;return null===a.window&&(a.wsize=1<<a.wbits,a.wnext=0,a.whave=0,a.window=new n.Buf8(a.wsize)),i>=a.wsize?(n.arraySet(a.window,t,r-a.wsize,a.wsize,0),a.wnext=0,a.whave=a.wsize):(i<(s=a.wsize-a.wnext)&&(s=i),n.arraySet(a.window,t,r-i,s,a.wnext),(i-=s)?(n.arraySet(a.window,t,r-i,i,0),a.wnext=i,a.whave=a.wsize):(a.wnext+=s,a.wnext===a.wsize&&(a.wnext=0),a.whave<a.wsize&&(a.whave+=s))),0}r.inflateReset=b,r.inflateReset2=v,r.inflateResetKeep=g,r.inflateInit=function(e){return y(e,15)},r.inflateInit2=y,r.inflate=function(e,t){var r,d,p,_,g,b,v,y,w,k,x,C,E,A,I,O,B,R,T,D,F,N,U,P,L=0,j=new n.Buf8(4),Z=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];if(!e||!e.state||!e.output||!e.input&&0!==e.avail_in)return f;12===(r=e.state).mode&&(r.mode=13),g=e.next_out,p=e.output,v=e.avail_out,_=e.next_in,d=e.input,b=e.avail_in,y=r.hold,w=r.bits,k=b,x=v,N=l;e:for(;;)switch(r.mode){case c:if(0===r.wrap){r.mode=13;break}for(;w<16;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(2&r.wrap&&35615===y){j[r.check=0]=255&y,j[1]=y>>>8&255,r.check=s(r.check,j,2,0),w=y=0,r.mode=2;break}if(r.flags=0,r.head&&(r.head.done=!1),!(1&r.wrap)||(((255&y)<<8)+(y>>8))%31){e.msg="incorrect header check",r.mode=30;break}if(8!=(15&y)){e.msg="unknown compression method",r.mode=30;break}if(w-=4,F=8+(15&(y>>>=4)),0===r.wbits)r.wbits=F;else if(F>r.wbits){e.msg="invalid window size",r.mode=30;break}r.dmax=1<<F,e.adler=r.check=1,r.mode=512&y?10:12,w=y=0;break;case 2:for(;w<16;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(r.flags=y,8!=(255&r.flags)){e.msg="unknown compression method",r.mode=30;break}if(57344&r.flags){e.msg="unknown header flags set",r.mode=30;break}r.head&&(r.head.text=y>>8&1),512&r.flags&&(j[0]=255&y,j[1]=y>>>8&255,r.check=s(r.check,j,2,0)),w=y=0,r.mode=3;case 3:for(;w<32;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}r.head&&(r.head.time=y),512&r.flags&&(j[0]=255&y,j[1]=y>>>8&255,j[2]=y>>>16&255,j[3]=y>>>24&255,r.check=s(r.check,j,4,0)),w=y=0,r.mode=4;case 4:for(;w<16;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}r.head&&(r.head.xflags=255&y,r.head.os=y>>8),512&r.flags&&(j[0]=255&y,j[1]=y>>>8&255,r.check=s(r.check,j,2,0)),w=y=0,r.mode=5;case 5:if(1024&r.flags){for(;w<16;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}r.length=y,r.head&&(r.head.extra_len=y),512&r.flags&&(j[0]=255&y,j[1]=y>>>8&255,r.check=s(r.check,j,2,0)),w=y=0}else r.head&&(r.head.extra=null);r.mode=6;case 6:if(1024&r.flags&&(b<(C=r.length)&&(C=b),C&&(r.head&&(F=r.head.extra_len-r.length,r.head.extra||(r.head.extra=new Array(r.head.extra_len)),n.arraySet(r.head.extra,d,_,C,F)),512&r.flags&&(r.check=s(r.check,d,C,_)),b-=C,_+=C,r.length-=C),r.length))break e;r.length=0,r.mode=7;case 7:if(2048&r.flags){if(0===b)break e;for(C=0;F=d[_+C++],r.head&&F&&r.length<65536&&(r.head.name+=String.fromCharCode(F)),F&&C<b;);if(512&r.flags&&(r.check=s(r.check,d,C,_)),b-=C,_+=C,F)break e}else r.head&&(r.head.name=null);r.length=0,r.mode=8;case 8:if(4096&r.flags){if(0===b)break e;for(C=0;F=d[_+C++],r.head&&F&&r.length<65536&&(r.head.comment+=String.fromCharCode(F)),F&&C<b;);if(512&r.flags&&(r.check=s(r.check,d,C,_)),b-=C,_+=C,F)break e}else r.head&&(r.head.comment=null);r.mode=9;case 9:if(512&r.flags){for(;w<16;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(y!==(65535&r.check)){e.msg="header crc mismatch",r.mode=30;break}w=y=0}r.head&&(r.head.hcrc=r.flags>>9&1,r.head.done=!0),e.adler=r.check=0,r.mode=12;break;case 10:for(;w<32;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}e.adler=r.check=m(y),w=y=0,r.mode=11;case 11:if(0===r.havedict)return e.next_out=g,e.avail_out=v,e.next_in=_,e.avail_in=b,r.hold=y,r.bits=w,2;e.adler=r.check=1,r.mode=12;case 12:if(5===t||6===t)break e;case 13:if(r.last){y>>>=7&w,w-=7&w,r.mode=27;break}for(;w<3;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}switch(r.last=1&y,w-=1,3&(y>>>=1)){case 0:r.mode=14;break;case 1:if(S(r),r.mode=20,6!==t)break;y>>>=2,w-=2;break e;case 2:r.mode=17;break;case 3:e.msg="invalid block type",r.mode=30}y>>>=2,w-=2;break;case 14:for(y>>>=7&w,w-=7&w;w<32;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if((65535&y)!=(y>>>16^65535)){e.msg="invalid stored block lengths",r.mode=30;break}if(r.length=65535&y,w=y=0,r.mode=15,6===t)break e;case 15:r.mode=16;case 16:if(C=r.length){if(b<C&&(C=b),v<C&&(C=v),0===C)break e;n.arraySet(p,d,_,C,g),b-=C,_+=C,v-=C,g+=C,r.length-=C;break}r.mode=12;break;case 17:for(;w<14;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(r.nlen=257+(31&y),y>>>=5,w-=5,r.ndist=1+(31&y),y>>>=5,w-=5,r.ncode=4+(15&y),y>>>=4,w-=4,286<r.nlen||30<r.ndist){e.msg="too many length or distance symbols",r.mode=30;break}r.have=0,r.mode=18;case 18:for(;r.have<r.ncode;){for(;w<3;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}r.lens[Z[r.have++]]=7&y,y>>>=3,w-=3}for(;r.have<19;)r.lens[Z[r.have++]]=0;if(r.lencode=r.lendyn,r.lenbits=7,U={bits:r.lenbits},N=o(0,r.lens,0,19,r.lencode,0,r.work,U),r.lenbits=U.bits,N){e.msg="invalid code lengths set",r.mode=30;break}r.have=0,r.mode=19;case 19:for(;r.have<r.nlen+r.ndist;){for(;O=(L=r.lencode[y&(1<<r.lenbits)-1])>>>16&255,B=65535&L,!((I=L>>>24)<=w);){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(B<16)y>>>=I,w-=I,r.lens[r.have++]=B;else{if(16===B){for(P=I+2;w<P;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(y>>>=I,w-=I,0===r.have){e.msg="invalid bit length repeat",r.mode=30;break}F=r.lens[r.have-1],C=3+(3&y),y>>>=2,w-=2}else if(17===B){for(P=I+3;w<P;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}w-=I,F=0,C=3+(7&(y>>>=I)),y>>>=3,w-=3}else{for(P=I+7;w<P;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}w-=I,F=0,C=11+(127&(y>>>=I)),y>>>=7,w-=7}if(r.have+C>r.nlen+r.ndist){e.msg="invalid bit length repeat",r.mode=30;break}for(;C--;)r.lens[r.have++]=F}}if(30===r.mode)break;if(0===r.lens[256]){e.msg="invalid code -- missing end-of-block",r.mode=30;break}if(r.lenbits=9,U={bits:r.lenbits},N=o(h,r.lens,0,r.nlen,r.lencode,0,r.work,U),r.lenbits=U.bits,N){e.msg="invalid literal/lengths set",r.mode=30;break}if(r.distbits=6,r.distcode=r.distdyn,U={bits:r.distbits},N=o(u,r.lens,r.nlen,r.ndist,r.distcode,0,r.work,U),r.distbits=U.bits,N){e.msg="invalid distances set",r.mode=30;break}if(r.mode=20,6===t)break e;case 20:r.mode=21;case 21:if(6<=b&&258<=v){e.next_out=g,e.avail_out=v,e.next_in=_,e.avail_in=b,r.hold=y,r.bits=w,a(e,x),g=e.next_out,p=e.output,v=e.avail_out,_=e.next_in,d=e.input,b=e.avail_in,y=r.hold,w=r.bits,12===r.mode&&(r.back=-1);break}for(r.back=0;O=(L=r.lencode[y&(1<<r.lenbits)-1])>>>16&255,B=65535&L,!((I=L>>>24)<=w);){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(O&&0==(240&O)){for(R=I,T=O,D=B;O=(L=r.lencode[D+((y&(1<<R+T)-1)>>R)])>>>16&255,B=65535&L,!(R+(I=L>>>24)<=w);){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}y>>>=R,w-=R,r.back+=R}if(y>>>=I,w-=I,r.back+=I,r.length=B,0===O){r.mode=26;break}if(32&O){r.back=-1,r.mode=12;break}if(64&O){e.msg="invalid literal/length code",r.mode=30;break}r.extra=15&O,r.mode=22;case 22:if(r.extra){for(P=r.extra;w<P;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}r.length+=y&(1<<r.extra)-1,y>>>=r.extra,w-=r.extra,r.back+=r.extra}r.was=r.length,r.mode=23;case 23:for(;O=(L=r.distcode[y&(1<<r.distbits)-1])>>>16&255,B=65535&L,!((I=L>>>24)<=w);){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(0==(240&O)){for(R=I,T=O,D=B;O=(L=r.distcode[D+((y&(1<<R+T)-1)>>R)])>>>16&255,B=65535&L,!(R+(I=L>>>24)<=w);){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}y>>>=R,w-=R,r.back+=R}if(y>>>=I,w-=I,r.back+=I,64&O){e.msg="invalid distance code",r.mode=30;break}r.offset=B,r.extra=15&O,r.mode=24;case 24:if(r.extra){for(P=r.extra;w<P;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}r.offset+=y&(1<<r.extra)-1,y>>>=r.extra,w-=r.extra,r.back+=r.extra}if(r.offset>r.dmax){e.msg="invalid distance too far back",r.mode=30;break}r.mode=25;case 25:if(0===v)break e;if(C=x-v,r.offset>C){if((C=r.offset-C)>r.whave&&r.sane){e.msg="invalid distance too far back",r.mode=30;break}E=C>r.wnext?(C-=r.wnext,r.wsize-C):r.wnext-C,C>r.length&&(C=r.length),A=r.window}else A=p,E=g-r.offset,C=r.length;for(v<C&&(C=v),v-=C,r.length-=C;p[g++]=A[E++],--C;);0===r.length&&(r.mode=21);break;case 26:if(0===v)break e;p[g++]=r.length,v--,r.mode=21;break;case 27:if(r.wrap){for(;w<32;){if(0===b)break e;b--,y|=d[_++]<<w,w+=8}if(x-=v,e.total_out+=x,r.total+=x,x&&(e.adler=r.check=r.flags?s(r.check,p,x,g-x):i(r.check,p,x,g-x)),x=v,(r.flags?y:m(y))!==r.check){e.msg="incorrect data check",r.mode=30;break}w=y=0}r.mode=28;case 28:if(r.wrap&&r.flags){for(;w<32;){if(0===b)break e;b--,y+=d[_++]<<w,w+=8}if(y!==(4294967295&r.total)){e.msg="incorrect length check",r.mode=30;break}w=y=0}r.mode=29;case 29:N=1;break e;case 30:N=-3;break e;case 31:return-4;case 32:default:return f}return e.next_out=g,e.avail_out=v,e.next_in=_,e.avail_in=b,r.hold=y,r.bits=w,(r.wsize||x!==e.avail_out&&r.mode<30&&(r.mode<27||4!==t))&&z(e,e.output,e.next_out,x-e.avail_out)?(r.mode=31,-4):(k-=e.avail_in,x-=e.avail_out,e.total_in+=k,e.total_out+=x,r.total+=x,r.wrap&&x&&(e.adler=r.check=r.flags?s(r.check,p,x,e.next_out-x):i(r.check,p,x,e.next_out-x)),e.data_type=r.bits+(r.last?64:0)+(12===r.mode?128:0)+(20===r.mode||15===r.mode?256:0),(0==k&&0===x||4===t)&&N===l&&(N=-5),N)},r.inflateEnd=function(e){if(!e||!e.state)return f;var t=e.state;return t.window&&(t.window=null),e.state=null,l},r.inflateGetHeader=function(e,t){var r;return e&&e.state?0==(2&(r=e.state).wrap)?f:((r.head=t).done=!1,l):f},r.inflateSetDictionary=function(e,t){var r,n=t.length;return e&&e.state?0!==(r=e.state).wrap&&11!==r.mode?f:11===r.mode&&i(1,t,n,0)!==r.check?-3:z(e,t,n,n)?(r.mode=31,-4):(r.havedict=1,l):f},r.inflateInfo="pako inflate (from Nodeca project)"},{"../utils/common":41,"./adler32":43,"./crc32":45,"./inffast":48,"./inftrees":50}],50:[function(e,t,r){"use strict";var n=e("../utils/common"),i=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0],s=[16,16,16,16,16,16,16,16,17,17,17,17,18,18,18,18,19,19,19,19,20,20,20,20,21,21,21,21,16,72,78],a=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577,0,0],o=[16,16,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,27,27,28,28,29,29,64,64];t.exports=function(e,t,r,h,u,l,f,c){var d,p,m,_,g,b,v,y,w,k=c.bits,x=0,S=0,z=0,C=0,E=0,A=0,I=0,O=0,B=0,R=0,T=null,D=0,F=new n.Buf16(16),N=new n.Buf16(16),U=null,P=0;for(x=0;x<=15;x++)F[x]=0;for(S=0;S<h;S++)F[t[r+S]]++;for(E=k,C=15;1<=C&&0===F[C];C--);if(C<E&&(E=C),0===C)return u[l++]=20971520,u[l++]=20971520,c.bits=1,0;for(z=1;z<C&&0===F[z];z++);for(E<z&&(E=z),x=O=1;x<=15;x++)if(O<<=1,(O-=F[x])<0)return-1;if(0<O&&(0===e||1!==C))return-1;for(N[1]=0,x=1;x<15;x++)N[x+1]=N[x]+F[x];for(S=0;S<h;S++)0!==t[r+S]&&(f[N[t[r+S]]++]=S);if(b=0===e?(T=U=f,19):1===e?(T=i,D-=257,U=s,P-=257,256):(T=a,U=o,-1),x=z,g=l,I=S=R=0,m=-1,_=(B=1<<(A=E))-1,1===e&&852<B||2===e&&592<B)return 1;for(;;){for(v=x-I,w=f[S]<b?(y=0,f[S]):f[S]>b?(y=U[P+f[S]],T[D+f[S]]):(y=96,0),d=1<<x-I,z=p=1<<A;u[g+(R>>I)+(p-=d)]=v<<24|y<<16|w|0,0!==p;);for(d=1<<x-1;R&d;)d>>=1;if(0!==d?(R&=d-1,R+=d):R=0,S++,0==--F[x]){if(x===C)break;x=t[r+f[S]]}if(E<x&&(R&_)!==m){for(0===I&&(I=E),g+=z,O=1<<(A=x-I);A+I<C&&!((O-=F[A+I])<=0);)A++,O<<=1;if(B+=1<<A,1===e&&852<B||2===e&&592<B)return 1;u[m=R&_]=E<<24|A<<16|g-l|0}}return 0!==R&&(u[g+R]=x-I<<24|64<<16|0),c.bits=E,0}},{"../utils/common":41}],51:[function(e,t,r){"use strict";t.exports={2:"need dictionary",1:"stream end",0:"","-1":"file error","-2":"stream error","-3":"data error","-4":"insufficient memory","-5":"buffer error","-6":"incompatible version"}},{}],52:[function(e,t,r){"use strict";var n=e("../utils/common"),i=0,s=1;function a(e){for(var t=e.length;0<=--t;)e[t]=0}var o=0,h=29,u=256,l=u+1+h,f=30,c=19,d=2*l+1,p=15,m=16,_=7,g=256,b=16,v=17,y=18,w=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0],k=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],x=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7],S=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],z=new Array(2*(l+2));a(z);var C=new Array(2*f);a(C);var E=new Array(512);a(E);var A=new Array(256);a(A);var I=new Array(h);a(I);var O,B,R,T=new Array(f);function D(e,t,r,n,i){this.static_tree=e,this.extra_bits=t,this.extra_base=r,this.elems=n,this.max_length=i,this.has_stree=e&&e.length}function F(e,t){this.dyn_tree=e,this.max_code=0,this.stat_desc=t}function N(e){return e<256?E[e]:E[256+(e>>>7)]}function U(e,t){e.pending_buf[e.pending++]=255&t,e.pending_buf[e.pending++]=t>>>8&255}function P(e,t,r){e.bi_valid>m-r?(e.bi_buf|=t<<e.bi_valid&65535,U(e,e.bi_buf),e.bi_buf=t>>m-e.bi_valid,e.bi_valid+=r-m):(e.bi_buf|=t<<e.bi_valid&65535,e.bi_valid+=r)}function L(e,t,r){P(e,r[2*t],r[2*t+1])}function j(e,t){for(var r=0;r|=1&e,e>>>=1,r<<=1,0<--t;);return r>>>1}function Z(e,t,r){var n,i,s=new Array(p+1),a=0;for(n=1;n<=p;n++)s[n]=a=a+r[n-1]<<1;for(i=0;i<=t;i++){var o=e[2*i+1];0!==o&&(e[2*i]=j(s[o]++,o))}}function W(e){var t;for(t=0;t<l;t++)e.dyn_ltree[2*t]=0;for(t=0;t<f;t++)e.dyn_dtree[2*t]=0;for(t=0;t<c;t++)e.bl_tree[2*t]=0;e.dyn_ltree[2*g]=1,e.opt_len=e.static_len=0,e.last_lit=e.matches=0}function M(e){8<e.bi_valid?U(e,e.bi_buf):0<e.bi_valid&&(e.pending_buf[e.pending++]=e.bi_buf),e.bi_buf=0,e.bi_valid=0}function H(e,t,r,n){var i=2*t,s=2*r;return e[i]<e[s]||e[i]===e[s]&&n[t]<=n[r]}function G(e,t,r){for(var n=e.heap[r],i=r<<1;i<=e.heap_len&&(i<e.heap_len&&H(t,e.heap[i+1],e.heap[i],e.depth)&&i++,!H(t,n,e.heap[i],e.depth));)e.heap[r]=e.heap[i],r=i,i<<=1;e.heap[r]=n}function K(e,t,r){var n,i,s,a,o=0;if(0!==e.last_lit)for(;n=e.pending_buf[e.d_buf+2*o]<<8|e.pending_buf[e.d_buf+2*o+1],i=e.pending_buf[e.l_buf+o],o++,0===n?L(e,i,t):(L(e,(s=A[i])+u+1,t),0!==(a=w[s])&&P(e,i-=I[s],a),L(e,s=N(--n),r),0!==(a=k[s])&&P(e,n-=T[s],a)),o<e.last_lit;);L(e,g,t)}function Y(e,t){var r,n,i,s=t.dyn_tree,a=t.stat_desc.static_tree,o=t.stat_desc.has_stree,h=t.stat_desc.elems,u=-1;for(e.heap_len=0,e.heap_max=d,r=0;r<h;r++)0!==s[2*r]?(e.heap[++e.heap_len]=u=r,e.depth[r]=0):s[2*r+1]=0;for(;e.heap_len<2;)s[2*(i=e.heap[++e.heap_len]=u<2?++u:0)]=1,e.depth[i]=0,e.opt_len--,o&&(e.static_len-=a[2*i+1]);for(t.max_code=u,r=e.heap_len>>1;1<=r;r--)G(e,s,r);for(i=h;r=e.heap[1],e.heap[1]=e.heap[e.heap_len--],G(e,s,1),n=e.heap[1],e.heap[--e.heap_max]=r,e.heap[--e.heap_max]=n,s[2*i]=s[2*r]+s[2*n],e.depth[i]=(e.depth[r]>=e.depth[n]?e.depth[r]:e.depth[n])+1,s[2*r+1]=s[2*n+1]=i,e.heap[1]=i++,G(e,s,1),2<=e.heap_len;);e.heap[--e.heap_max]=e.heap[1],function(e,t){var r,n,i,s,a,o,h=t.dyn_tree,u=t.max_code,l=t.stat_desc.static_tree,f=t.stat_desc.has_stree,c=t.stat_desc.extra_bits,m=t.stat_desc.extra_base,_=t.stat_desc.max_length,g=0;for(s=0;s<=p;s++)e.bl_count[s]=0;for(h[2*e.heap[e.heap_max]+1]=0,r=e.heap_max+1;r<d;r++)_<(s=h[2*h[2*(n=e.heap[r])+1]+1]+1)&&(s=_,g++),h[2*n+1]=s,u<n||(e.bl_count[s]++,a=0,m<=n&&(a=c[n-m]),o=h[2*n],e.opt_len+=o*(s+a),f&&(e.static_len+=o*(l[2*n+1]+a)));if(0!==g){do{for(s=_-1;0===e.bl_count[s];)s--;e.bl_count[s]--,e.bl_count[s+1]+=2,e.bl_count[_]--,g-=2}while(0<g);for(s=_;0!==s;s--)for(n=e.bl_count[s];0!==n;)u<(i=e.heap[--r])||(h[2*i+1]!==s&&(e.opt_len+=(s-h[2*i+1])*h[2*i],h[2*i+1]=s),n--)}}(e,t),Z(s,u,e.bl_count)}function X(e,t,r){var n,i,s=-1,a=t[1],o=0,h=7,u=4;for(0===a&&(h=138,u=3),t[2*(r+1)+1]=65535,n=0;n<=r;n++)i=a,a=t[2*(n+1)+1],++o<h&&i===a||(o<u?e.bl_tree[2*i]+=o:0!==i?(i!==s&&e.bl_tree[2*i]++,e.bl_tree[2*b]++):o<=10?e.bl_tree[2*v]++:e.bl_tree[2*y]++,s=i,u=(o=0)===a?(h=138,3):i===a?(h=6,3):(h=7,4))}function V(e,t,r){var n,i,s=-1,a=t[1],o=0,h=7,u=4;for(0===a&&(h=138,u=3),n=0;n<=r;n++)if(i=a,a=t[2*(n+1)+1],!(++o<h&&i===a)){if(o<u)for(;L(e,i,e.bl_tree),0!=--o;);else 0!==i?(i!==s&&(L(e,i,e.bl_tree),o--),L(e,b,e.bl_tree),P(e,o-3,2)):o<=10?(L(e,v,e.bl_tree),P(e,o-3,3)):(L(e,y,e.bl_tree),P(e,o-11,7));s=i,u=(o=0)===a?(h=138,3):i===a?(h=6,3):(h=7,4)}}a(T);var q=!1;function J(e,t,r,i){P(e,(o<<1)+(i?1:0),3),function(e,t,r,i){M(e),i&&(U(e,r),U(e,~r)),n.arraySet(e.pending_buf,e.window,t,r,e.pending),e.pending+=r}(e,t,r,!0)}r._tr_init=function(e){q||(function(){var e,t,r,n,i,s=new Array(p+1);for(n=r=0;n<h-1;n++)for(I[n]=r,e=0;e<1<<w[n];e++)A[r++]=n;for(A[r-1]=n,n=i=0;n<16;n++)for(T[n]=i,e=0;e<1<<k[n];e++)E[i++]=n;for(i>>=7;n<f;n++)for(T[n]=i<<7,e=0;e<1<<k[n]-7;e++)E[256+i++]=n;for(t=0;t<=p;t++)s[t]=0;for(e=0;e<=143;)z[2*e+1]=8,e++,s[8]++;for(;e<=255;)z[2*e+1]=9,e++,s[9]++;for(;e<=279;)z[2*e+1]=7,e++,s[7]++;for(;e<=287;)z[2*e+1]=8,e++,s[8]++;for(Z(z,l+1,s),e=0;e<f;e++)C[2*e+1]=5,C[2*e]=j(e,5);O=new D(z,w,u+1,l,p),B=new D(C,k,0,f,p),R=new D(new Array(0),x,0,c,_)}(),q=!0),e.l_desc=new F(e.dyn_ltree,O),e.d_desc=new F(e.dyn_dtree,B),e.bl_desc=new F(e.bl_tree,R),e.bi_buf=0,e.bi_valid=0,W(e)},r._tr_stored_block=J,r._tr_flush_block=function(e,t,r,n){var a,o,h=0;0<e.level?(2===e.strm.data_type&&(e.strm.data_type=function(e){var t,r=4093624447;for(t=0;t<=31;t++,r>>>=1)if(1&r&&0!==e.dyn_ltree[2*t])return i;if(0!==e.dyn_ltree[18]||0!==e.dyn_ltree[20]||0!==e.dyn_ltree[26])return s;for(t=32;t<u;t++)if(0!==e.dyn_ltree[2*t])return s;return i}(e)),Y(e,e.l_desc),Y(e,e.d_desc),h=function(e){var t;for(X(e,e.dyn_ltree,e.l_desc.max_code),X(e,e.dyn_dtree,e.d_desc.max_code),Y(e,e.bl_desc),t=c-1;3<=t&&0===e.bl_tree[2*S[t]+1];t--);return e.opt_len+=3*(t+1)+5+5+4,t}(e),a=e.opt_len+3+7>>>3,(o=e.static_len+3+7>>>3)<=a&&(a=o)):a=o=r+5,r+4<=a&&-1!==t?J(e,t,r,n):4===e.strategy||o===a?(P(e,2+(n?1:0),3),K(e,z,C)):(P(e,4+(n?1:0),3),function(e,t,r,n){var i;for(P(e,t-257,5),P(e,r-1,5),P(e,n-4,4),i=0;i<n;i++)P(e,e.bl_tree[2*S[i]+1],3);V(e,e.dyn_ltree,t-1),V(e,e.dyn_dtree,r-1)}(e,e.l_desc.max_code+1,e.d_desc.max_code+1,h+1),K(e,e.dyn_ltree,e.dyn_dtree)),W(e),n&&M(e)},r._tr_tally=function(e,t,r){return e.pending_buf[e.d_buf+2*e.last_lit]=t>>>8&255,e.pending_buf[e.d_buf+2*e.last_lit+1]=255&t,e.pending_buf[e.l_buf+e.last_lit]=255&r,e.last_lit++,0===t?e.dyn_ltree[2*r]++:(e.matches++,t--,e.dyn_ltree[2*(A[r]+u+1)]++,e.dyn_dtree[2*N(t)]++),e.last_lit===e.lit_bufsize-1},r._tr_align=function(e){P(e,2,3),L(e,g,z),function(e){16===e.bi_valid?(U(e,e.bi_buf),e.bi_buf=0,e.bi_valid=0):8<=e.bi_valid&&(e.pending_buf[e.pending++]=255&e.bi_buf,e.bi_buf>>=8,e.bi_valid-=8)}(e)}},{"../utils/common":41}],53:[function(e,t,r){"use strict";t.exports=function(){this.input=null,this.next_in=0,this.avail_in=0,this.total_in=0,this.output=null,this.next_out=0,this.avail_out=0,this.total_out=0,this.msg="",this.state=null,this.data_type=2,this.adler=0}},{}],54:[function(e,t,n){(function(e){!function(e,t){"use strict";if(!e.setImmediate){var r,n,i,s,a=1,o={},h=!1,u=e.document,l=Object.getPrototypeOf&&Object.getPrototypeOf(e);l=l&&l.setTimeout?l:e,r="[object process]"==={}.toString.call(e.process)?function(e){process.nextTick((function(){c(e)}))}:function(){if(e.postMessage&&!e.importScripts){var t=!0,r=e.onmessage;return e.onmessage=function(){t=!1},e.postMessage("","*"),e.onmessage=r,t}}()?(s="setImmediate$"+Math.random()+"$",e.addEventListener?e.addEventListener("message",d,!1):e.attachEvent("onmessage",d),function(t){e.postMessage(s+t,"*")}):e.MessageChannel?((i=new MessageChannel).port1.onmessage=function(e){c(e.data)},function(e){i.port2.postMessage(e)}):u&&"onreadystatechange"in u.createElement("script")?(n=u.documentElement,function(e){var t=u.createElement("script");t.onreadystatechange=function(){c(e),t.onreadystatechange=null,n.removeChild(t),t=null},n.appendChild(t)}):function(e){setTimeout(c,0,e)},l.setImmediate=function(e){"function"!=typeof e&&(e=new Function(""+e));for(var t=new Array(arguments.length-1),n=0;n<t.length;n++)t[n]=arguments[n+1];var i={callback:e,args:t};return o[a]=i,r(a),a++},l.clearImmediate=f}function f(e){delete o[e]}function c(e){if(h)setTimeout(c,0,e);else{var r=o[e];if(r){h=!0;try{!function(e){var r=e.callback,n=e.args;switch(n.length){case 0:r();break;case 1:r(n[0]);break;case 2:r(n[0],n[1]);break;case 3:r(n[0],n[1],n[2]);break;default:r.apply(t,n)}}(r)}finally{f(e),h=!1}}}}function d(t){t.source===e&&"string"==typeof t.data&&0===t.data.indexOf(s)&&c(+t.data.slice(s.length))}}("undefined"==typeof self?void 0===e?this:e:self)}).call(this,"undefined"!=typeof r.g?r.g:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{}]},{},[10])(10)}))}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[581],{4581:function(e){e.exports=JSON.parse('{"ui.app.title":"Contao проширења","ui.app.loading":"Учитавам листу проширења...","ui.discover.advertisement":"Оглашавање у листи екстензија","ui.discover.loading":"Учитавам ...","ui.discover.offline":"Нема пронађених резултата.","ui.discover.offlineExplain":"Проверите вашу интернет конекцију и искључите блокаду JavaScript-а у вашем прегледачу.","ui.discover.offlineButton":"Покушајте поново","ui.discover.searchPlaceholder":"Претражи у {count} екстензија ...","ui.discover.empty":"Нема резултата за {query}","ui.discover.more":"Више резултата","ui.discover.sortBy":"Сортирај по","ui.discover.sortReleased":"Released","ui.discover.sortReleasedTitle":"Sort results by release date","ui.discover.sortLatest":"Ажурирано","ui.discover.sortLatestTitle":"Sort results by last updated","ui.discover.sortDownloads":"Преузимања","ui.discover.sortDownloadsTitle":"Sort results by number of downloads","ui.discover.sortFavers":"Оцене","ui.discover.sortFaversTitle":"Sort results by rating","ui.discover.detailsButton":"Детаљи","ui.discover.latestPackages":"Последње и ажуриране екстензије","ui.discover.faversPackages":"Најбоље оцењене екстензије","ui.discover.downloadsPackages":"Екстензије са највише преузимања","ui.package.homepage":"Вебсајт пројекта","ui.package.private":"Приватни пакети","ui.package.privateTitle":"Приватни пакети су доступни само од вендора (нпр. као ZIP преузимање). Посетите сајт ради више информација.","ui.package.abandoned":"напуштено","ui.package.abandonedText":"Овај пакет је напуштен и више се не одржава.","ui.package.abandonedReplace":"Овај пакет је напуштен и више се не одржава. Аутор предлаже да користите {replacement} као замену.","ui.package-details.previous":"Детаљи претходне екстензије","ui.package-details.close":"Затвори детаље екстензије","ui.package-details.loading":"Учитавам ...","ui.package-details.tabDescription":"Опис","ui.package-details.tabRequire":"Захтеви","ui.package-details.tabFeatures":"Могућности","ui.package-details.tabSuggest":"Предлози","ui.package-details.tabConflict":"Конфликти","ui.package-details.tabDependents":"Зависности","ui.package-details.linkRequires":"захтева","ui.package-details.linkReplaces":"мења","ui.package-details.linkProvides":"пружа","ui.package-details.linkConflicts":"сукобљава се са","ui.package-details.funding":"Спонзорирајте одржавање пакета!","ui.package-details.latest":"Последња верзија","ui.package-details.released":"објављено","ui.package-details.license":"Лиценца(е)","ui.package-details.authors":"од","ui.package-details.more":"Детаљније","ui.package-details.packagist":"Детаљи пакета","ui.package-details.metadata":"Уреди мета податке","ui.package-details.support_docs":"Документација","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Форум за подршку","ui.package-details.support_issues":"Пријава проблема/Баг","ui.package-details.support_source":"Изворни код","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Имејл подршке","ui.package-details.support_rss":"RSS сажетак"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[560],{1560:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Nedrošs savienojums !!","ui.app.httpsDescription":"Bez HTTPS jūsu konfidenciālie dati tiks pārsūtīti nešifrēti.","ui.app.httpsLink":"Vairāk informācijas","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Ieslēgts drošais režīms !!","ui.app.safeModeDescription":"Dažas Contao Manager funkcijas nav pieejamas.","ui.app.safeModeExit":"Iziet no drošā režīma","ui.app.loading":"Ielādē Contao pārvaldnieku ...","ui.app.apiError":"Negaidīts API statuss","ui.app.configSecurity1":"DROŠĪBAS BRĪDINĀJUMS !!! Konstatēts neaizsargāts konfigurācijas direktorijs","ui.app.configSecurity2":"The Contao Manager has detected that its config files are publicly accessible. All operations are disabled until the directory is secured, otherwise an attacker could access sensitive data of your installation.\\n\\nTo fix this issue, make sure to prevent access to the \\"contao-manager\\" directory on your server. To learn how to do this, please refer to the manual of your webserver or contact your hosting provider.","ui.account.welcome":"Laipni lūdzam","ui.account.intro1":"Laipni lūgti Contao pārvaldniekā, kas ir universāls rīks Contao atvērtā koda CMS instalēšanai un pārvaldībai. Ja esat jauns lietotājs, lūdzu, {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual}, lai sāktu","ui.account.introManual":"izlasiet rokasgrāmatu","ui.account.intro2":"Ja jums rodas kādas problēmas, pārbaudiet {ourGithubIssues} un nekautrējieties izveidot jaunu problēmu, ja par to vēl nav ziņots.","ui.account.introIssues":"mūsu GitHub problēmas","ui.account.headline":"Lietotāja konts","ui.account.description":"Lai pārvaldītu savu instalāciju, lūdzu, izveidojiet Contao pārvaldnieka kontu. Ņemiet vērā, ka šis konts nav saistīts ar Contao aizmuguri vai priekšu.","ui.account.username":"Lietotājvārds","ui.account.password":"Parole","ui.account.passwordPlaceholder":"min. 8 rakstzīmes","ui.account.passwordLength":"Lūdzu, ievadiet vismaz 8 rakstzīmes.","ui.account.submit":"Izveidot kontu","ui.account.contribute1":"Contao un Contao Manager sponsorē bezpeļņas organizācija Contao Association.","ui.account.contribute2":"Lūdzu, apsveriet iespēju sniegt ieguldījumu atvērtajā pirmkodā {donate}.","ui.account.contributeDonate":"ziedojuma veikšana","ui.login.headline":"Pierakstīties","ui.login.description":"Pierakstīties, lai pārvaldītu savu instalāciju.","ui.login.username":"Lietotājvārds","ui.login.password":"Parole","ui.login.forgotPassword":"Aizmirsāt paroli?","ui.login.button":"Pierakstīties","ui.login.locked":"Piekļuve ir liegta, jo Contao Manager ir bloķēts. Lai atbloķētu, izdzēsiet {lockFile} datni Contao galvenajā direktorijā.","ui.logout.headline":"Sesijas laika limits","ui.logout.warning":"Jūs esat bijis neaktīvs ilgāk par 25 minūtēm. Drošības apsvērumu dēļ jūsu sesija drīz tiks pārtraukta.","ui.logout.expired":"Jūsu sesija tika automātiski pārtraukta, jo esat bijis neaktīvs ilgāk par 30 minūtēm.","ui.logout.renew":"Palikt pieteikušamies","ui.logout.logout":"Izrakstīties","ui.logout.login":"Atpakaļ uz pieteikšanos","ui.oauth.error":"Nederīgs OAuth mēģinājums. Pārbaudiet pieprasījuma parametrus.","ui.oauth.https":"The redirect URI MUST use a secure protocol (https:) to prevent the authentication token from being transmitted in clear-text.","ui.oauth.headline":"Attālā autentifikācija","ui.oauth.description":"Šāda lietojumprogramma vai pakalpojums pieprasa attālo piekļuvi jūsu Contao Manager instancei.","ui.oauth.domain":"Pirms atļaujat piekļuvi, pārliecinieties, ka zināt šo URL un uzticaties tā īpašniekam!","ui.oauth.allow":"Atļaut piekļuvi","ui.oauth.deny":"Liegt piekļuvi","ui.boot.headline":"Sistēmas pārbaude","ui.boot.description":"Lūdzu, uzgaidiet, mēs analizējam jūsu serveri ...","ui.boot.issue1":"Konstatētās  instalēšanas problēmas","ui.boot.issue2":"Jūsu instalācijā ir problēmas, kas jānovērš, pirms var izmantot Contao Manager.","ui.boot.run":"Palaist Contao pārvaldnieku","ui.boot.safeMode":"Palaist drošajā režīmā","ui.recovery.headline":"Sistēmas atkopšana","ui.recovery.description":"Contao Manager atklāja datnes, kas izskatās kā Contao, bet komandrindas saskarne nedarbojas, kā paredzēts.","ui.recovery.console":"Konsoles izvade","ui.recovery.repairOptions":"Lūdzu, izvēlieties iespēju, lai salabotu instalāciju.","ui.recovery.repairHeadline":"Automātiskā izlabošana","ui.recovery.repairDescription":"Mēģina automātiski labot instalāciju, atjaunojot lietojumprogrammu kešatmiņu un atkārtoti instalējot Composer paketes.","ui.recovery.repairWarning":"Procesa laikā var tikt dzēstas visas piegādātāja datņu izmaiņas!","ui.recovery.repairFailed":"Automātiskā labošana nebija veiksmīga. Izmēģiniet instalāciju labot manuāli drošajā režīmā.","ui.recovery.repairButton":"Palaist sistēmas izlabošanu","ui.recovery.safeModeHeadline":"Drošais režīms","ui.recovery.safeModeDescription":"Programmas Contao Manager palaišana drošajā režīmā ļauj pārvaldīt paketes un veikt dažus uzturēšanas uzdevumus, taču funkcijas, kas ir atkarīgas no darbojošās Contao instalācijas, nebūs pieejamas.","ui.recovery.safeModeButton":"Palaist drošajā režīmā","ui.server.pending":"Gaida ...","ui.server.running":"Analizē ...","ui.server.error":"Pārbaude neizdevās, jo no servera saņemta neparedzēta atbilde.","ui.server.details":"Sīkāka informācija","ui.server.prerequisite":"Pārbaude atcelta trūkstošā priekšnosacījuma dēļ.","ui.server.selfUpdate.title":"Contao pārvaldnieka atjauninājumi","ui.server.selfUpdate.update":"Ir pieejama jauna Contao pārvaldnieka versija {latest}.","ui.server.selfUpdate.manualUpdate":"Ir pieejama jauna Contao Manager versija {latest}. Jūsu serveris neatbalsta automātiskus atjauninājumus, lūdzu, lejupielādējiet jauno versiju no {download}.","ui.server.selfUpdate.latest":"Jūs izmantojat jaunāko versiju {current}.","ui.server.selfUpdate.dev":"Izstrādes būves neatbalsta automātiskus atjauninājumus.","ui.server.selfUpdate.unsupported":"Ir pieejama jauna versija, taču tā neatbalsta jūsu PHP versiju.","ui.server.selfUpdate.button":"Palaist pašatjauninājumu","ui.server.selfUpdate.continue":"Turpināt","ui.server.config.title":"Servera konfigurācija","ui.server.config.setup":"Konfigurēt","ui.server.config.change":"Mainīt","ui.server.config.save":"Saglabāt","ui.server.config.cancel":"Atcelt","ui.server.config.customOption":"Cits ...","ui.server.config.description":"To correctly run background tasks, the Contao Manager needs to know where to find the PHP command line binary and how to run commands separated from the web process.","ui.server.config.formTitle":"Servera konfigurācija","ui.server.config.formText":"Please enter the path to your PHP binary. Make sure the binary is the same PHP version as your web process.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"The Composer Resolver Cloud allows to install Composer dependencies even if your server does not provide enough local memory. Please be aware that your package information will be transmitted to a cloud server operated by the Contao Association.","ui.server.config.cloud":"Izmantot Composer Resolver Cloud","ui.server.config.cli":"PHP binārs","ui.server.config.stateErrorCli":"Serverī netika atrasts derīgs PHP binārs.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud netiek atbalstīts.","ui.server.config.stateSuccess":"PHP binārais kodols {php_cli}.","ui.server.php_web.title":"PHP Web process","ui.server.php_web.below7":"Atrasta PHP versija {versija}. Lūdzu, pēc iespējas ātrāk pārejiet uz PHP 7!","ui.server.php_web.success":"Atrasta PHP versija {versija}, neviena zināma problēma nav atrasta.","ui.server.php_cli.title":"PHP komandrindas saskarne","ui.server.php_cli.success":"Atrasta PHP versija {versija}, neviena zināma problēma nav atrasta.","ui.server.composer.title":"Composer vide","ui.server.composer.success":"Netika atrastas zināmas problēmas.","ui.server.composer.install":"Composer dependencies are not installed.","ui.server.composer.button":"Uzstādīt","ui.server.contao.title":"Contao instalācija","ui.server.contao.setup":"Uzstādīt","ui.server.contao.check":"Pārbaudīt datubāzi","ui.server.contao.empty":"Neviena Contao instalācija nav atrasta.","ui.server.contao.old":"Contao versija {versija} nav savietojama ar Contao pārvaldnieku, lūdzu, manuāli atjauniniet instalāciju.","ui.server.contao.found":"Atrasts Contao {versija} (API versija {api}).","ui.server.contao.connectionError":"Nevar izveidot savienojumu ar datubāzes serveri.","ui.server.contao.connectionProblem":"Atrasta datubāzes problēma.","ui.server.contao.missingUser":"Administratora konts nav atrasts.","ui.setup.continue":"Turpināt","ui.setup.manager":"Palaist Contao pārvaldnieku","ui.setup.cancel":"Atcelt","ui.setup.welcome":"Laipni lūdzam","ui.setup.welcome1":"This wizard will take you through the necessary steps to set up your Contao Open Source CMS installation.","ui.setup.welcome2":"If you have any questions, please find documentation, forums, a Slack channel and more on the {support} page.","ui.setup.support":"kopienas atbalsts","ui.setup.start":"Sākt","ui.setup.complete":"Apsveicam!","ui.setup.complete1":"Contao {versija} ir veiksmīgi instalēta.","ui.setup.complete2":"To finish the setup process, please open the install tool to configure the database connection and create a back end user.","ui.setup.complete3":"You can now start to create your website in the Contao back end. If you need additional extensions, continue to the Contao Manager.","ui.setup.installTool":"Atveriet instalēšanas rīku","ui.setup.login":"Pieslēgties Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". An Open Source project like Contao requires amounts of money that can\'t be raised by a single person or company.\\nIf you have a website or sell websites built with Contao, we would love to see you contribute back financially to the product your business relies upon.","ui.setup.fundingLink":"Uzzināt vairāk","ui.setup.document-root.headline":"Tīmekļa servera iestatīšana","ui.setup.document-root.warning":"Lai instalētu Contao, izmantojot Contao Manager, tīmekļa serverī ir jānosaka dokumenta sakne.","ui.setup.document-root.description1":"Contao uses a separate folder for public files, application files are installed in its parent folder. Contao cannot be installed if the folder structure is not correct or the folders are not empty.","ui.setup.document-root.description2":"Ja nezināt, kā konfigurēt dokumentu sakni, izlasiet Contao dokumentāciju vai sazinieties ar savu hostinga pakalpojumu sniedzēju.","ui.setup.document-root.documentation":"Izlasiet dokumentāciju","ui.setup.document-root.conflictsTitle":"Instalācijas direktorijs nav tukšs","ui.setup.document-root.conflictsDirectory":"The root directory of your future Contao installation is not empty, we have found {count} file(s) that might be overwritten by the installation process. It is recommended to create an empty directory structure for Contao, but you can also remove the following files and check again if you are sure they are unused.","ui.setup.document-root.ignoreConflicts":"I want to install Contao into the non-empty directory. I understand that this might overwrite any existing files on my webspace.","ui.setup.document-root.check":"Pārbaudiet vēlreiz","ui.setup.document-root.create":"Izveidot direktorijus","ui.setup.document-root.change":"Change directories","ui.setup.document-root.formTitle":"Direktoriju iestatīšana","ui.setup.document-root.formText1":"Contao Manager var automātiski izveidot jaunu direktoriju struktūru serverī.","ui.setup.document-root.formText2":"Jums būs manuāli jākonfigurē jaunā dokumenta sakne (piemēram, izmantojot hostinga administratora paneli).","ui.setup.document-root.autoconfig":"Es saprotu, ka man ir jāmaina servera konfigurācija. Dokumenta saknes nekonfigurēšana sabojās Contao Manager un atklās konfigurācijas failus (tostarp konta informāciju un paroles)!","ui.setup.document-root.directory":"Jauns direktorijs","ui.setup.document-root.currentRoot":"Pašreizējā dokumenta sakne","ui.setup.document-root.newRoot":"Jauna dokumenta sakne","ui.setup.document-root.finish":"Direktoriju iestatīšana","ui.setup.document-root.publicDir":"Izmantojiet {dir} publiskajām datnēm (Contao {version})","ui.setup.document-root.directoryInvalid":"Lūdzu, ievadiet derīgu direktorija nosaukumu.","ui.setup.document-root.directoryExists":"Mērķa direktorijs jau pastāv. Lūdzu, ievadiet citu nosaukumu.","ui.setup.document-root.confirmation":"Contao pārvaldnieks ir veiksmīgi izveidojis nepieciešamo direktoriju jūsu Contao instalācijai. Tagad jums ir jākonfigurē dokumenta sakne tīmekļa serverī. Līdz tam nepārlādējiet šo lapu no jauna.","ui.setup.document-root.reload":"Pārlādēt lapu","ui.setup.document-root.success":"The directory structure on your web server is set up correctly!","ui.setup.document-root.installingProjectDir":"Lietojumprogrammas datnes tiks instalētas {dir}.","ui.setup.document-root.installingPublicDir":"Publiskās datnes tiks instalētas {dir}.","ui.setup.document-root.installedProjectDir":"Lietojumprogrammas datnes ir instalētas {dir}.","ui.setup.document-root.installedPublicDir":"Publiskās datnes ir instalētas {dir}.","ui.setup.create-project.headline":"Contao instalācija","ui.setup.create-project.description":"Contao development follows the principle of {semver}, a new minor version is released every six months. The currently supported releases are:","ui.setup.create-project.semver":"Semantic Versioning","ui.setup.create-project.latestTitle":"Jaunākais","ui.setup.create-project.ltsTitle":"Ilgtermiņa atbalsts","ui.setup.create-project.latestQ1":"Our latest version, offers the most features with support until February {year}.","ui.setup.create-project.latestQ3":"Our latest version, offers the most features with support until August {year}.","ui.setup.create-project.ltsText":"Our current LTS version, if you focus on stability. Offers long term support until February {year}.","ui.setup.create-project.pltsText":"The previous LTS version, still has long term support until February {year}.","ui.setup.create-project.requiresPHP":"Requires at least PHP {version}, you have PHP {current}.","ui.setup.create-project.requiresDocroot":"Dokumenta saknei jābūt \\"{folder}\\".","ui.setup.create-project.releaseplan":"Sīkāku informāciju skatiet {contaoReleasePlan}.","ui.setup.create-project.releaseplanLink":"Contao izlaišanas plāns","ui.setup.create-project.installed":"Contao {version} is successfully installed on the server. Continue to set up your database or launch the Contao Manager to install a different version.","ui.setup.create-project.formTitle":"Izvēlēties distribūciju","ui.setup.create-project.formText":"Lūdzu, izvēlieties, kura versija jāuzstāda.","ui.setup.create-project.version":"Versija","ui.setup.create-project.demo":"Install the Contao demo website","ui.setup.create-project.demoDescription":"The demo website helps you to get familiar with Contao and all of its core features. More themes can be found in the {store}.","ui.setup.create-project.coreOnly":"Minimāla instalācija (tikai Core)","ui.setup.create-project.noUpdate":"Izlaist instalāciju (tikai eksperts!)","ui.setup.create-project.theme":"Contao Theme","ui.setup.create-project.themeInstall":"To install a Contao theme, use the search input or upload a theme file (.cto/.zip) that supports installation through the Contao Manager.","ui.setup.create-project.themeBuy":"Make sure to visit the official {store}.","ui.setup.create-project.themeStore":"Contao Themes Store","ui.setup.create-project.themeUpload":"Upload theme file (.cto/.zip)","ui.setup.create-project.themeInvalid":"The uploaded file is not a Contao theme or does not support the Contao Manager.","ui.setup.create-project.themeWarning":"The Contao Manager cannot tell whether this theme is compatible with your server. Please check with the theme vendor if you have any questions.","ui.setup.create-project.themeTitle":"Review theme details","ui.setup.create-project.themeDetails":"The following dependencies and files will be installed with this theme.","ui.setup.create-project.themeRequire":"{count} Dependencies | {count} Dependencies","ui.setup.create-project.themeFiles":"{count} File | {count} Files","ui.setup.create-project.theme.or":"or search public themes","ui.setup.create-project.theme.search":"Search themes","ui.setup.create-project.theme.more":"More themes","ui.setup.create-project.theme.empty":"No themes matching {query}","ui.setup.create-project.theme.uploaded":"The theme file was uploaded successfully.","ui.setup.create-project.theme.packageName":"Package name","ui.setup.create-project.theme.version":"Versija","ui.setup.create-project.theme.authors":"Author(s)","ui.setup.create-project.install":"Uzstādīt","ui.setup.create-project.cancel":"Atcelt","ui.setup.database-connection.headline":"Datubāzes savienojums","ui.setup.database-connection.description":"Contao requires a MySQL database (or a compatible fork like MariaDB) to store pages, content, users and other relational data. Connection parameters are stored in the {env} file in the project root of your Contao installation.","ui.setup.database-connection.formTitle":"Savienojuma parametri","ui.setup.database-connection.formText":"Ievadiet datubāzes URL vai atsevišķi aizpildiet lietotājvārdu, paroli, serveri un datubāzes laukus.","ui.setup.database-connection.url":"Datubāzes URL","ui.setup.database-connection.validUrl":"Datubāzes URL ir nederīgs vai neizdevās izveidot savienojumu ar serveri.","ui.setup.database-connection.or":"vai","ui.setup.database-connection.user":"Lietotājvārds","ui.setup.database-connection.password":"Parole","ui.setup.database-connection.server":"Serveris (:ports)","ui.setup.database-connection.database":"Datubāzes nosaukums","ui.setup.database-connection.connected":"Successfully connected to database {database} on {server}.","ui.setup.database-connection.error":"Kļūda, savienojoties ar datubāzi.","ui.setup.database-connection.problem":"Contao ir atklājis problēmu ar jūsu datubāzes serveri.","ui.setup.database-connection.schemaTitle":"Database Schema","ui.setup.database-connection.migration":"There is one pending migration. | There are {count} pending migrations.","ui.setup.database-connection.schema":"There is one pending schema update. | There are {count} pending schema updates.","ui.setup.database-connection.noChanges":"Jūsu datubāzes shēma ir aktuāla.","ui.setup.database-connection.check":"Pārbaudīt datubāzi","ui.setup.database-connection.skip":"Izlaist","ui.setup.database-connection.save":"Saglabāt","ui.setup.database-connection.change":"Mainīt akreditācijas datus","ui.setup.database-connection.restoreTitle":"Database Import","ui.setup.database-connection.restoreText":"The theme you just installed contains a database backup. Restore the database to import theme data or skip this step to start with a blank Contao installation. | The theme you just installed contains multiple database backups. Select a backup file to import theme data or skip this step to start with a blank Contao installation.","ui.setup.database-connection.backup":"Backup current database before import","ui.setup.database-connection.backupWarning":"All data in database will be overwritten on import! Create a backup first if the database is not empty.","ui.setup.database-connection.restore":"Import theme database","ui.setup.database-connection.restoreOption":"Backup from {date} ({size})","ui.setup.database-connection.restored":"Your theme database was successfully imported. Continue to validate your database schema.","ui.setup.backend-user.success":"An admin account for the Contao back end was found in your database. Use the Contao back end to add more users.","ui.setup.backend-user.error":"Unable to retrieve user list. Check the console output for details.","ui.setup.backend-user.headline":"Aizmugures konts","ui.setup.backend-user.description":"To manage your website, you need to have at least one admin account for the Contao back end. Be aware that this account is not related to the Contao Manager.","ui.setup.backend-user.formTitle":"Izveidot kontu","ui.setup.backend-user.formText":"Please enter the details for the new back end account.","ui.setup.backend-user.username":"Lietotājvārds","ui.setup.backend-user.name":"Vārds","ui.setup.backend-user.email":"E-pasta adrese","ui.setup.backend-user.emailInvalid":"Lūdzu, ievadiet derīgu e-pasta adresi","ui.setup.backend-user.password":"Parole","ui.setup.backend-user.passwordPlaceholder":"min. 8 rakstzīmes","ui.setup.backend-user.passwordLength":"Lūdzu, ievadiet vismaz 8 rakstzīmes.","ui.setup.backend-user.create":"Pievienot kontu","ui.task.headline":"Fona uzdevums","ui.task.loading":"Ielādē informāciju ...","ui.task.created":"Ielādē informāciju ...","ui.task.active":"Lūdzu, pagaidiet, kamēr Contao Manager fona režīmā tiek veiktas uzdevumu operācijas.","ui.task.complete":"Visas operācijas ir veiksmīgi pabeigtas. Sīkāku informāciju skatiet konsoles izvades failā.","ui.task.aborting":"Lūdzu, uzgaidiet, kamēr tiek atceltas fona operācijas.","ui.task.stopped":"Dažas fona darbības tika atceltas. Lūdzu, pārbaudiet konsoles izvadi.","ui.task.error":"Fona operācija negaidīti apstājās. Lūdzu, pārbaudiet konsoles izvadi.","ui.task.failed":"Contao pārvaldniekam neizdevās palaist fona uzdevumu!","ui.task.failedDescription1":"Mēģinot izpildīt operācijas fonā, kaut kas notika nepareizi.","ui.task.failedDescription2":"Ja tas atkārtojas, iespējams, ka jūsu serveris netiek atbalstīts.","ui.task.reportProblem":"Ziņot par problēmu","ui.task.sponsor":"Composer Cloud sponsored by {sponsor}","ui.task.buttonAudit":"Atjaunināt datubāzi","ui.task.buttonClose":"Aizvērt","ui.task.buttonConfirm":"Apstiprināt & aizvērt","ui.task.buttonCancel":"Atcelt","ui.task.confirmCancel":"Vai noteikti vēlaties atcelt šo uzdevumu? Tas var atstāt jūsu Contao instalāciju bojātā stāvoklī!","ui.task.autoclose":"Aizvērt uzdevuma informāciju pēc izdošanās","ui.console.toggle":"Rādīt/slēpt konsoles izvadi","ui.console.showLog":"Rādīt pilnu konsoles žurnālu","ui.console.copyLog":"Kopēt žurnālu uz starpliktuvi","ui.migrate.headline":"Datubāzes atjauninājumi","ui.migrate.migrationsOnly":"(migrations only)","ui.migrate.schemaOnly":"(schema only)","ui.migrate.loading":"Lūdzu, uzgaidiet, mēs pārbaudām jūsu datubāzi...","ui.migrate.empty":"No pending migrations or schema updates found. Your database is up to date.","ui.migrate.emptyMigrations":"No pending migrations found. Make sure to also check for schema updates.","ui.migrate.emptySchema":"No pending schema updates found. Make sure to also check for migrations.","ui.migrate.pending":"Your database is not up to date. Please review the console output below and execute the changes.","ui.migrate.previousChanges":"A previous database migration was not confirmed.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.previousComplete":"A previous database migration was not confirmed, please review the console output below.\\nThere are no more pending changes.","ui.migrate.appliedChanges":"Database updates have been applied.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.appliedComplete":"Database updates have been applied.\\nThere are no more pending migrations or schema updates. Your database is up to date.","ui.migrate.problem":"Contao has detected a problem with your database server.\\nPlease review the console output below to find out what needs to be fixed. | Contao has detected problems with your database server.\\nPlease review the console output below to find out what needs to be fixed.","ui.migrate.warning":"Contao has detected a misconfiguration of your database server.\\nWarnings can be skipped temporarily, but should be fixed for optimal performance and data integrity.","ui.migrate.error":"The changes could not be applied. Your database might have been changed, please check again to retry.","ui.migrate.execute":"Izpildīt","ui.migrate.close":"Aizvērt","ui.migrate.confirm":"Apstiprināt & aizvērt","ui.migrate.cancel":"Atcelt","ui.migrate.continue":"Turpināt","ui.migrate.setup":"Uzstādīt","ui.migrate.skip":"Izlaist","ui.migrate.retry":"Pārbaudiet vēlreiz","ui.migrate.retryAll":"Atzīmēt visus","ui.migrate.withDeletes":"Izpildīt visas datubāzes izmaiņas, tostarp DROP vaicājumus.","ui.migrate.migrationTitle":"Datubāzu migrācija","ui.migrate.schemaTitle":"Shēmas atjauninājumi","ui.migrate.problemTitle":"Datubāzes problēmas","ui.migrate.warningTitle":"Datubāzes brīdinājumi","ui.migrate.addTable":"Pievienot tabulu {table}","ui.migrate.dropTable":"Nomest tabulu {table}","ui.migrate.addField":"Pievienot lauku {table}.{field}","ui.migrate.changeField":"Mainīt lauku {table}.{field}","ui.migrate.dropField":"Nomest lauku {table}.{field}","ui.migrate.createIndex":"Izveidot indeksu \\"{name}\\" uz {table}","ui.migrate.dropIndex":"Nomest indeksu \\"{name}\\" uz {table}","ui.widget.mandatory":"Šis lauks nedrīkst būt tukšs.","ui.widget.blankOption":"Lūdzu, izvēlieties ...","ui.widget.showPassword":"Rādīt paroli","ui.widget.hidePassword":"Slēpt paroli","ui.error.title":"HTTP pieprasījums \\"{metod} {url}\\" neizdevās.","ui.error.server500":"Looks like an unexpected error happened on your server. Please check the log files of your web server (Apache/Nginx) and the Contao Manager logs at \\"contao-manager/logs\\".","ui.error.response":"Serveris atbildēja ar statusa kodu {status}.","ui.error.moreLink":"Vairāk informācijas","ui.error.support":"Contao atbalsts","ui.footer.help":"Palīdzība","ui.footer.reportProblem":"Ziņot par problēmu","ui.navigation.discover":"Atklāt","ui.navigation.packages":"Pakotnes","ui.navigation.tools":"Rīki","ui.navigation.installTool":"Instalēšanas rīks","ui.navigation.backend":"Contao aizmugure","ui.navigation.debug":"Contao atkļūdošanas režīms","ui.navigation.logViewer":"Log Viewer","ui.navigation.phpinfo":"PHP informācija","ui.navigation.phpinfoLoading":"PHP informācijas ielāde...","ui.navigation.maintenance":"Uzturēšana","ui.navigation.rebuildCache":"Pārbūvēt kešatmiņu","ui.navigation.systemCheck":"Sistēmas pārbaude","ui.navigation.advanced":"Papildu","ui.navigation.logout":"Izrakstīties","ui.maintenance.database.title":"Database Migrations and Backups","ui.maintenance.database.description":"Database migrations ensure consistent data and table schemas.","ui.maintenance.database.migrations":"One pending database migration | {count} pending database migrations","ui.maintenance.database.schemaUpdates":"One pending schema update | {count} pending schema updates","ui.maintenance.database.error":"Atrasta datubāzes problēma.","ui.maintenance.database.warning":"Atrasti datubāzes brīdinājumi.","ui.maintenance.database.button":"Pārbaudīt datubāzi","ui.maintenance.database.migrationOnly":"Pārbaudīt tikai migrācijas","ui.maintenance.database.schemaOnly":"Pārbaudīt tikai shēmu","ui.maintenance.database.installTool":"Atvērt instalēšanas rīku","ui.maintenance.database.createBackup":"Create Backup","ui.maintenance.database.backupUnsupported":"Database backups are not supported by your Contao version.","ui.maintenance.database.backupList":"You have one database backup, created on {date}. | You have {count} database backups, the latest one was created on {date}.","ui.maintenance.database.backupEmpty":"You currently have no database backups.","ui.maintenance.rebuildCache.title":"Lietojumprogrammas kešatmiņa","ui.maintenance.rebuildCache.description":"Rebuilding the application cache is required after modifying any of the configuration files.","ui.maintenance.rebuildCache.rebuildProd":"Ražošanas kešatmiņas pārbūve","ui.maintenance.rebuildCache.rebuildDev":"Izstrādes kešatmiņas pārbūve","ui.maintenance.rebuildCache.clearProd":"Notīrīt ražošanas kešatmiņu","ui.maintenance.rebuildCache.clearDev":"Notīrīt izstrādes kešatmiņu","ui.maintenance.installTool.title":"Contao instalēšanas rīks","ui.maintenance.installTool.description":"Contao instalēšanas rīks tiek automātiski bloķēts, ja trīs reizes pēc kārtas ievadāt nepareizu paroli.","ui.maintenance.installTool.unlock":"Atbloķēt instalēšanas rīku","ui.maintenance.installTool.lock":"Bloķēt instalēšanas rīku","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"The Composer autoloader is responsible for PHP class loading. The autoloader must be dumped after adding custom namespaces to the root composer.json.","ui.maintenance.dumpAutoload.button":"Dump Autoloader","ui.maintenance.composerInstall.title":"Composer Dependencies","ui.maintenance.composerInstall.description":"Composer dependencies are located in the {vendor} folder in your application root. Reinstalling the dependencies can be necessary after manipulation or manually uploading the {composerLock} file.","ui.maintenance.composerInstall.button":"Palaist instalētāju","ui.maintenance.composerInstall.update":"Palaist Composer jauninājumu","ui.maintenance.composerCache.title":"Composer kešatmiņa","ui.maintenance.composerCache.description":"Composer caches downloaded packages for improved performance. If you have issues like broken files, try to delete the Composer cache to force a new download.","ui.maintenance.composerCache.button":"Iztīrīt kešatmiņu","ui.maintenance.maintenanceMode.title":"Uzturēšanas režīms","ui.maintenance.maintenanceMode.description":"Putting Contao in maintenance mode will display a \\"503 Service Unavailable\\" template for the website.","ui.maintenance.maintenanceMode.enable":"Iespējot","ui.maintenance.maintenanceMode.disable":"Atspējot","ui.maintenance.debugMode.title":"Atkļūdošanas režīms","ui.maintenance.debugMode.description":"Activate the debug mode by setting a user and password for the {appDevPhp} entry point.","ui.maintenance.debugMode.descriptionJwt":"Activate the debug mode by setting the debug cookie for the current domain.","ui.maintenance.debugMode.activate":"Aktivizēt","ui.maintenance.debugMode.deactivate":"Deaktivizēt","ui.maintenance.debugMode.credentials":"Akreditācijas dati","ui.maintenance.debugMode.user":"Lūdzu, ievadiet atkļūdošanas režīma lietotājvārdu.","ui.maintenance.debugMode.password":"Lūdzu, ievadiet paroli atkļūdošanas režīmam.","ui.maintenance.opcodeCache.title":"Opcode Cache","ui.maintenance.opcodeCache.description":"Opcode caches PHP files on the web process for faster execution. It must be deleted under certain circumstances if files are not recognized after changing.","ui.maintenance.opcodeCache.button":"Saīsināt kešatmiņu","ui.maintenance.safeMode":"Nav pieejams drošajā režīmā","ui.maintenance.unsupported":"Neatbalsta jūsu Contao versija","ui.packages.updateButton":"Atjaunināt pakotnes","ui.packages.searchButton":"Meklēt pakotnes","ui.packages.searchPlaceholder":"Meklēt pakotnes ...","ui.packages.uploadOverlay":"Lai augšupielādētu, velciet un nometiet failus","ui.packages.uploadButton":"Augšupielādēt pakotnes","ui.packages.uploadMessage":"Jums ir viena neapstiprināta augšupielāde. | Jums ir {count} neapstiprināta/u augšupielāde/žu.","ui.packages.uploadApply":"Apstiprināt augšupielādi","ui.packages.uploadReset":"Dzēst augšupielādes","ui.packages.uploadIncomplete":"Šis datne netika augšupielādēts pilnībā. Lūdzu, noņemiet to un mēģiniet vēlreiz.","ui.packages.uploadDuplicate":"Šķiet, ka šī datne ir augšupielādēts vairākas reizes. Lūdzu, izdzēsiet dublikātus.","ui.packages.uploadInstalled":"Šis datne jau ir instalēta. Lūdzu, izdzēsiet dublikātus.","ui.packages.uploadUnsupported":"Uploads are not supported in your installation. Please make sure that the PHP ZIP extension is installed and update your dependencies.","ui.packages.changesMessage":"You have one unconfirmed change. | You have {count} unconfirmed changes.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"Pielietot izmaiņas","ui.packages.changesApplyAll":"Atjaunināt visas pakotnes","ui.packages.changesDryrunAll":"Dry run all packages","ui.packages.changesReset":"Atiestatīt izmaiņas","ui.packages.changesReview":"Pārskatīt izmaiņas","ui.packagelist.loading":"Ielādē ...","ui.packagelist.uploads":"Augšupielādes","ui.packagelist.added":"Jaunas pakotnes","ui.packagelist.installed":"Instalētās pakotnes","ui.package.hintRevert":"Atgriezt izmaiņas","ui.package.hintNoupdate":"Neatjaunināt","ui.package.hintConstraint":"This package will be installed with constraint {constraint} when you apply the changes.","ui.package.hintConstraintBest":"This package will be installed in the best available version when you apply the changes.","ui.package.hintConstraintChange":"The constraint for this package will be changed from \\"{from}\\" to \\"{to}\\" when you apply the changes.","ui.package.hintConstraintUpdate":"Šī pakotne tiks atjaunināta, kad piemērosiet izmaiņas.","ui.package.hintAdded":"Šī pakotne tiks instalēta, kad piemērosiet izmaiņas.","ui.package.hintRemoved":"Šī pakotne tiks noņemta, kad piemērosiet izmaiņas.","ui.package.requiredTitle":"manuāli pievienots","ui.package.requiredText":"Šī pakotne ir nepieciešama jūsu composer.json, bet nav instalēta.","ui.package.removedTitle":"manuāli noņemts","ui.package.removedText":"Šī pakotne tika noņemta no jūsu composer.json.","ui.package.installed":"Pašlaik instalēts:","ui.package.version":"Versija {version}","ui.package.additionalDownloads":"{count} Lejupielāde | {count} Lejupielādes","ui.package.additionalStars":"{count} Star | {count} Stars","ui.package.editConstraint":"Rediģēt","ui.package.uploadConstraint":"This constraint is defined by the uploaded package.","ui.package.updateButton":"Jaunināt","ui.package.removeButton":"Noņemt","ui.package.installButton":"Pievienot pakotni","ui.package.installButtonShort":"Pievienot","ui.package.detailsButton":"Sīkāka informācija","ui.package.latestConstraint":"jaunākā versija","ui.package.update":"Pieejams atjauninājums","ui.package.updateLatest":"jaunākā versija","ui.package.updateAvailable":"Pieejama {versija}","ui.package.updateUnknown":"nezināma versija","ui.package.updateConstraint":"A newer version outside your version constraint is available.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Versija {version}","ui.cloudStatus.waitingTime":"Gaidīšanas laiks","ui.cloudStatus.jobs":"Pašreizējie darbi","ui.cloudStatus.workers":"Strādnieki","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"nav","ui.cloudStatus.short":"apt. {minutes} min","ui.cloudStatus.long":"apt. {minutes} min {seconds} sek","ui.cloudStatus.error":"Unable to fetch the status of the Composer Resolver Cloud. It might be down for maintenance or experience issues.","ui.cloudStatus.button":"Mākoņa statuss","ui.cloudStatus.refresh":"Atjaunināt mākoņa statusu","ui.log-viewer.loading":"Ielādē ...","ui.log-viewer.empty":"There are no log files on your server.","ui.log-viewer.reload":"Reload","ui.log-viewer.file":"Log file","ui.log-viewer.channel":"Channel","ui.log-viewer.channelTitle":"The channel this message was logged to.","ui.log-viewer.level":"Level","ui.log-viewer.levelTitle":"Severity of the log message.","ui.log-viewer.timeHeader":"Time","ui.log-viewer.messageHeader":"Message","ui.log-viewer.showContext":"Show Context","ui.log-viewer.hideContext":"Hide Context","ui.log-viewer.showExtra":"Show Extra","ui.log-viewer.hideExtra":"Hide Extra","ui.log-viewer.more":"Load more …","ui.log-viewer.download":"Download","ui.log-viewer.downloadTitle":"Download file \\"{file}\\"","ui.log-viewer.prodEnvironment":"Production Environment","ui.log-viewer.devEnvironment":"Development Environment (Debug Mode)"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[553],{5553:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Insecure Connection !!","ui.app.httpsDescription":"Without HTTPS your confidential data will be transferred unencrypted.","ui.app.httpsLink":"More Info","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Safe Mode enabled !!","ui.app.safeModeDescription":"Some features of the Contao Manager are not available.","ui.app.safeModeExit":"Exit Safe Mode","ui.app.loading":"Loading Contao Manager …","ui.app.apiError":"Unexpected API status","ui.app.configSecurity1":"SECURITY ALERT !!! Unprotected config directory detected","ui.app.configSecurity2":"The Contao Manager has detected that its config files are publicly accessible. All operations are disabled until the directory is secured, otherwise an attacker could access sensitive data of your installation.\\n\\nTo fix this issue, make sure to prevent access to the \\"contao-manager\\" directory on your server. To learn how to do this, please refer to the manual of your webserver or contact your hosting provider.","ui.account.welcome":"Welcome","ui.account.intro1":"Welcome to the Contao Manager, a universal tool to install and manage Contao Open Source CMS. If you are new to it, please {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} to get started","ui.account.introManual":"read the manual","ui.account.intro2":"If you encounter any problems, check {ourGithubIssues} and feel free to create new one for anything that has not been reported yet.","ui.account.introIssues":"our GitHub issues","ui.account.headline":"User Account","ui.account.description":"To manage your installation, please create an account for the Contao Manager. Be aware that this account is not related to the Contao back end or front end.","ui.account.username":"Username","ui.account.password":"Password","ui.account.passwordPlaceholder":"min. 8 characters","ui.account.passwordLength":"Please enter at least 8 characters.","ui.account.submit":"Create Account","ui.account.contribute1":"Contao and the Contao Manager are sponsored by the non-profit Contao Association.","ui.account.contribute2":"Please consider contributing to open source by {donate}.","ui.account.contributeDonate":"making a donation","ui.login.headline":"Sign In","ui.login.description":"Login to manage your installation.","ui.login.username":"Username","ui.login.password":"Password","ui.login.forgotPassword":"Forgot your password?","ui.login.button":"Sign In","ui.login.locked":"Access has been denied because the Contao Manager is locked. To unlock, delete the {lockFile} file in your Contao root directory.","ui.logout.headline":"Session Timeout","ui.logout.warning":"Your have been inactive for more than 25 minutes. For security reasons your session will be terminated shortly.","ui.logout.expired":"Your session was automatically terminated because you have been inactive for more than 30 minutes.","ui.logout.renew":"Keep Logged In","ui.logout.logout":"Logout","ui.logout.login":"Back To Login","ui.oauth.error":"Invalid OAuth attempt. Check the request parameters.","ui.oauth.https":"The redirect URI MUST use a secure protocol (https:) to prevent the authentication token from being transmitted in clear-text.","ui.oauth.headline":"Remote Authentication","ui.oauth.description":"The following application or service is requesting remote access to your Contao Manager instance.","ui.oauth.domain":"Before allowing access, make sure you know this URL and trust its owner!","ui.oauth.allow":"Allow Access","ui.oauth.deny":"Deny Access","ui.boot.headline":"System Check","ui.boot.description":"Please wait, we are analyzing your server …","ui.boot.issue1":"Installation Issues Detected","ui.boot.issue2":"Your installation has issues that have to be fixed before the Contao Manager can be used.","ui.boot.run":"Launch Contao Manager","ui.boot.safeMode":"Launch in Safe Mode","ui.recovery.headline":"System Recovery","ui.recovery.description":"The Contao Manager detected files that look like Contao, but the Command Line Interface does not work as expected.","ui.recovery.console":"Console Output","ui.recovery.repairOptions":"Please choose an option to repair your installation.","ui.recovery.repairHeadline":"Automatic Repair","ui.recovery.repairDescription":"Attempts to automatically repair the installation by rebuilding the application cache and re-installing the Composer packages.","ui.recovery.repairWarning":"Any modifications to the vendor files might be deleted in the process!","ui.recovery.repairFailed":"Automatic repair was not successful. Try the Safe Mode to manually repair the installation.","ui.recovery.repairButton":"Run System Repair","ui.recovery.safeModeHeadline":"Safe Mode","ui.recovery.safeModeDescription":"Launching the Contao Manager in Safe Mode allows to manage packages and run certain maintenance tasks, but features that rely on a working Contao installation will not be available.","ui.recovery.safeModeButton":"Launch in Safe Mode","ui.server.pending":"Waiting …","ui.server.running":"Analyzing …","ui.server.error":"Check failed due to an unexpected response from the server.","ui.server.details":"Details","ui.server.prerequisite":"Check cancelled due to a missing prerequisite.","ui.server.selfUpdate.title":"Updates of Contao Manager","ui.server.selfUpdate.update":"A new Contao Manager version {latest} is available.","ui.server.selfUpdate.manualUpdate":"A new Contao Manager version {latest} is available. Your server does not support automatic updates, please download the new version from {download}.","ui.server.selfUpdate.latest":"You are using the latest version {current}.","ui.server.selfUpdate.dev":"Development builds do not support automatic updates.","ui.server.selfUpdate.unsupported":"A new version is available but it does not support your PHP version.","ui.server.selfUpdate.button":"Run Self-Update","ui.server.selfUpdate.continue":"Continue","ui.server.config.title":"Server Configuration","ui.server.config.setup":"Configure","ui.server.config.change":"Change","ui.server.config.save":"Save","ui.server.config.cancel":"Cancel","ui.server.config.customOption":"Other …","ui.server.config.description":"To correctly run background tasks, the Contao Manager needs to know where to find the PHP command line binary and how to run commands separated from the web process.","ui.server.config.formTitle":"Server Configuration","ui.server.config.formText":"Please enter the path to your PHP binary. Make sure the binary is the same PHP version as your web process.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"The Composer Resolver Cloud allows to install Composer dependencies even if your server does not provide enough local memory. Please be aware that your package information will be transmitted to a cloud server operated by the Contao Association.","ui.server.config.cloud":"Use the Composer Resolver Cloud","ui.server.config.cli":"PHP Binary","ui.server.config.stateErrorCli":"No valid PHP binary was found on the server.","ui.server.config.stateErrorCloud":"The Composer Resolver Cloud is not supported.","ui.server.config.stateSuccess":"PHP binary at {php_cli}.","ui.server.php_web.title":"PHP Web Process","ui.server.php_web.below7":"Found PHP version {version}. Please switch to PHP 7 as soon as possible!","ui.server.php_web.success":"Found PHP version {version}, no known issues found.","ui.server.php_cli.title":"PHP Command Line Interface","ui.server.php_cli.success":"Found PHP version {version}, no known issues found.","ui.server.composer.title":"Composer Environment","ui.server.composer.success":"No known issues found.","ui.server.composer.install":"Composer dependencies are not installed.","ui.server.composer.button":"Install","ui.server.contao.title":"Contao Installation","ui.server.contao.setup":"Setup","ui.server.contao.check":"Check database","ui.server.contao.empty":"No Contao installation has been found.","ui.server.contao.old":"Contao version {version} is not compatible with the Contao Manager, please update your installation manually.","ui.server.contao.found":"Found Contao {version} (API version {api}).","ui.server.contao.connectionError":"Unable to connect to the database server.","ui.server.contao.connectionProblem":"Database problem found.","ui.server.contao.missingUser":"Admin account not found.","ui.setup.continue":"Continue","ui.setup.manager":"Launch Contao Manager","ui.setup.cancel":"Cancel","ui.setup.welcome":"Welcome","ui.setup.welcome1":"This wizard will take you through the necessary steps to set up your Contao Open Source CMS installation.","ui.setup.welcome2":"If you have any questions, please find documentation, forums, a Slack channel and more on the {support} page.","ui.setup.support":"community support","ui.setup.start":"Get started","ui.setup.complete":"Congratulations!","ui.setup.complete1":"Contao {version} has been installed successfully.","ui.setup.complete2":"To finish the setup process, please open the install tool to configure the database connection and create a back end user.","ui.setup.complete3":"You can now start to create your website in the Contao back end. If you need additional extensions, continue to the Contao Manager.","ui.setup.installTool":"Open the Install Tool","ui.setup.login":"Login to Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". An Open Source project like Contao requires amounts of money that can\'t be raised by a single person or company.\\nIf you have a website or sell websites built with Contao, we would love to see you contribute back financially to the product your business relies upon.","ui.setup.fundingLink":"Learn more","ui.setup.document-root.headline":"Webserver Setup","ui.setup.document-root.warning":"To install Contao through the Contao Manager, you have to fix the document root on the web server.","ui.setup.document-root.description1":"Contao uses a separate folder for public files, application files are installed in its parent folder. Contao cannot be installed if the folder structure is not correct or the folders are not empty.","ui.setup.document-root.description2":"If you don\'t know how to configure your document root, please read the Contao documentation or contact your hosting provider.","ui.setup.document-root.documentation":"Read the Documentation","ui.setup.document-root.conflictsTitle":"Installation directory not empty","ui.setup.document-root.conflictsDirectory":"The root directory of your future Contao installation is not empty, we have found {count} file(s) that might be overwritten by the installation process. It is recommended to create an empty directory structure for Contao, but you can also remove the following files and check again if you are sure they are unused.","ui.setup.document-root.ignoreConflicts":"I want to install Contao into the non-empty directory. I understand that this might overwrite any existing files on my webspace.","ui.setup.document-root.check":"Check again","ui.setup.document-root.create":"Create directories","ui.setup.document-root.change":"Change directories","ui.setup.document-root.formTitle":"Directory Setup","ui.setup.document-root.formText1":"The Contao Manager can automatically create a new directory structure on the server.","ui.setup.document-root.formText2":"You will need to manually configure the new document root (e.g. through a hosting admin panel).","ui.setup.document-root.autoconfig":"I understand that I have to change my server configuration. Not configuring the document root will break the Contao Manager and expose configuration files (including account details and passwords)!","ui.setup.document-root.directory":"New Directory","ui.setup.document-root.currentRoot":"Current Document Root","ui.setup.document-root.newRoot":"New Document Root","ui.setup.document-root.finish":"Setup Directories","ui.setup.document-root.publicDir":"Use {dir} for public files (for Contao {version})","ui.setup.document-root.directoryInvalid":"Please enter a valid directory name.","ui.setup.document-root.directoryExists":"The target directory already exists. Please enter a different name.","ui.setup.document-root.confirmation":"The Contao Manager has successfully created the necessary directory for your Contao installation. You now have to configure the document root on your web server. Do not reload this page until then.","ui.setup.document-root.reload":"Reload Page","ui.setup.document-root.success":"The directory structure on your web server is set up correctly!","ui.setup.document-root.installingProjectDir":"Application files will be installed to {dir}.","ui.setup.document-root.installingPublicDir":"Public files will be installed to {dir}.","ui.setup.document-root.installedProjectDir":"Application files are installed in {dir}.","ui.setup.document-root.installedPublicDir":"Public files are installed in {dir}.","ui.setup.create-project.headline":"Contao Installation","ui.setup.create-project.description":"Contao development follows the principle of {semver}, a new minor version is released every six months. The currently supported releases are:","ui.setup.create-project.semver":"Semantic Versioning","ui.setup.create-project.latestTitle":"Latest","ui.setup.create-project.ltsTitle":"Long Term Support","ui.setup.create-project.latestQ1":"Our latest version, offers the most features with support until February {year}.","ui.setup.create-project.latestQ3":"Our latest version, offers the most features with support until August {year}.","ui.setup.create-project.ltsText":"Our current LTS version, if you focus on stability. Offers long term support until February {year}.","ui.setup.create-project.pltsText":"The previous LTS version, still has long term support until February {year}.","ui.setup.create-project.requiresPHP":"Requires at least PHP {version}, you have PHP {current}.","ui.setup.create-project.requiresDocroot":"The document root must be \\"{folder}\\".","ui.setup.create-project.releaseplan":"See the {contaoReleasePlan} for detailed information.","ui.setup.create-project.releaseplanLink":"Contao Release Plan","ui.setup.create-project.installed":"Contao {version} is successfully installed on the server. Continue to set up your database or launch the Contao Manager to install a different version.","ui.setup.create-project.formTitle":"Select a distribution","ui.setup.create-project.formText":"Please choose which version should be installed.","ui.setup.create-project.version":"Version","ui.setup.create-project.demo":"Install the Contao demo website","ui.setup.create-project.demoDescription":"The demo website helps you to get familiar with Contao and all of its core features. More themes can be found in the {store}.","ui.setup.create-project.coreOnly":"Minimal Installation (Core only)","ui.setup.create-project.noUpdate":"Skip Installation (Expert Only!)","ui.setup.create-project.theme":"Contao Theme","ui.setup.create-project.themeInstall":"To install a Contao theme, use the search input or upload a theme file (.cto/.zip) that supports installation through the Contao Manager.","ui.setup.create-project.themeBuy":"Make sure to visit the official {store}.","ui.setup.create-project.themeStore":"Contao Themes Store","ui.setup.create-project.themeUpload":"Upload theme file (.cto/.zip)","ui.setup.create-project.themeInvalid":"The uploaded file is not a Contao theme or does not support the Contao Manager.","ui.setup.create-project.themeWarning":"The Contao Manager cannot tell whether this theme is compatible with your server. Please check with the theme vendor if you have any questions.","ui.setup.create-project.themeTitle":"Review theme details","ui.setup.create-project.themeDetails":"The following dependencies and files will be installed with this theme.","ui.setup.create-project.themeRequire":"{count} Dependencies | {count} Dependencies","ui.setup.create-project.themeFiles":"{count} File | {count} Files","ui.setup.create-project.theme.or":"or search public themes","ui.setup.create-project.theme.search":"Search themes","ui.setup.create-project.theme.more":"More themes","ui.setup.create-project.theme.empty":"No themes matching {query}","ui.setup.create-project.theme.uploaded":"The theme file was uploaded successfully.","ui.setup.create-project.theme.packageName":"Package name","ui.setup.create-project.theme.version":"Version","ui.setup.create-project.theme.authors":"Author(s)","ui.setup.create-project.install":"Install","ui.setup.create-project.cancel":"Cancel","ui.setup.database-connection.headline":"Database Connection","ui.setup.database-connection.description":"Contao requires a MySQL database (or a compatible fork like MariaDB) to store pages, content, users and other relational data. Connection parameters are stored in the {env} file in the project root of your Contao installation.","ui.setup.database-connection.formTitle":"Connection Parameters","ui.setup.database-connection.formText":"Enter a database URL or fill in the username, password, server and database fields separately.","ui.setup.database-connection.url":"Database URL","ui.setup.database-connection.validUrl":"Database URL is invalid or connection to server failed.","ui.setup.database-connection.or":"or","ui.setup.database-connection.user":"Username","ui.setup.database-connection.password":"Password","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Database Name","ui.setup.database-connection.connected":"Successfully connected to database {database} on {server}.","ui.setup.database-connection.error":"Error connecting to the database.","ui.setup.database-connection.problem":"Contao has detected a problem with your database server.","ui.setup.database-connection.schemaTitle":"Database Schema","ui.setup.database-connection.migration":"There is one pending migration. | There are {count} pending migrations.","ui.setup.database-connection.schema":"There is one pending schema update. | There are {count} pending schema updates.","ui.setup.database-connection.noChanges":"Your database schema is up to date.","ui.setup.database-connection.check":"Check database","ui.setup.database-connection.skip":"Skip","ui.setup.database-connection.save":"Save","ui.setup.database-connection.change":"Change credentials","ui.setup.database-connection.restoreTitle":"Database Import","ui.setup.database-connection.restoreText":"The theme you just installed contains a database backup. Restore the database to import theme data or skip this step to start with a blank Contao installation. | The theme you just installed contains multiple database backups. Select a backup file to import theme data or skip this step to start with a blank Contao installation.","ui.setup.database-connection.backup":"Backup current database before import","ui.setup.database-connection.backupWarning":"All data in database will be overwritten on import! Create a backup first if the database is not empty.","ui.setup.database-connection.restore":"Import theme database","ui.setup.database-connection.restoreOption":"Backup from {date} ({size})","ui.setup.database-connection.restored":"Your theme database was successfully imported. Continue to validate your database schema.","ui.setup.backend-user.success":"An admin account for the Contao back end was found in your database. Use the Contao back end to add more users.","ui.setup.backend-user.error":"Unable to retrieve user list. Check the console output for details.","ui.setup.backend-user.headline":"Backend Account","ui.setup.backend-user.description":"To manage your website, you need to have at least one admin account for the Contao back end. Be aware that this account is not related to the Contao Manager.","ui.setup.backend-user.formTitle":"Create Account","ui.setup.backend-user.formText":"Please enter the details for the new back end account.","ui.setup.backend-user.username":"Username","ui.setup.backend-user.name":"Name","ui.setup.backend-user.email":"E-mail address","ui.setup.backend-user.emailInvalid":"Please enter a valid e-mail address","ui.setup.backend-user.password":"Password","ui.setup.backend-user.passwordPlaceholder":"min. 8 characters","ui.setup.backend-user.passwordLength":"Please enter at least 8 characters.","ui.setup.backend-user.create":"Add account","ui.task.headline":"Background Task","ui.task.loading":"Loading details …","ui.task.created":"Loading details …","ui.task.active":"Please wait while the Contao Manager is running task operations in the background.","ui.task.complete":"All operations are completed successfully. Check the console output for details.","ui.task.aborting":"Please wait while the background operations are being cancelled.","ui.task.stopped":"Some background operations were cancelled. Please check the console output.","ui.task.error":"A background operation stopped unexpectedly. Please check the console output.","ui.task.failed":"The Contao Manager failed to start a background task!","ui.task.failedDescription1":"Something went wrong while trying to execute operations in the background.","ui.task.failedDescription2":"If this happens again, your server might not be supported.","ui.task.reportProblem":"Report a Problem","ui.task.sponsor":"Composer Cloud sponsored by {sponsor}","ui.task.buttonAudit":"Update Database","ui.task.buttonClose":"Close","ui.task.buttonConfirm":"Confirm & Close","ui.task.buttonCancel":"Cancel","ui.task.confirmCancel":"Are you sure to cancel this task? This might leave your Contao installation in a broken state!","ui.task.autoclose":"Close task details on success","ui.console.toggle":"Show/Hide Console Output","ui.console.showLog":"Show full console log","ui.console.copyLog":"Copy log to clipboard","ui.migrate.headline":"Database Updates","ui.migrate.migrationsOnly":"(migrations only)","ui.migrate.schemaOnly":"(schema only)","ui.migrate.loading":"Please wait, we are checking your database …","ui.migrate.empty":"No pending migrations or schema updates found. Your database is up to date.","ui.migrate.emptyMigrations":"No pending migrations found. Make sure to also check for schema updates.","ui.migrate.emptySchema":"No pending schema updates found. Make sure to also check for migrations.","ui.migrate.pending":"Your database is not up to date. Please review the console output below and execute the changes.","ui.migrate.previousChanges":"A previous database migration was not confirmed.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.previousComplete":"A previous database migration was not confirmed, please review the console output below.\\nThere are no more pending changes.","ui.migrate.appliedChanges":"Database updates have been applied.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.appliedComplete":"Database updates have been applied.\\nThere are no more pending migrations or schema updates. Your database is up to date.","ui.migrate.problem":"Contao has detected a problem with your database server.\\nPlease review the console output below to find out what needs to be fixed. | Contao has detected problems with your database server.\\nPlease review the console output below to find out what needs to be fixed.","ui.migrate.warning":"Contao has detected a misconfiguration of your database server.\\nWarnings can be skipped temporarily, but should be fixed for optimal performance and data integrity.","ui.migrate.error":"The changes could not be applied. Your database might have been changed, please check again to retry.","ui.migrate.execute":"Execute","ui.migrate.close":"Close","ui.migrate.confirm":"Confirm & Close","ui.migrate.cancel":"Cancel","ui.migrate.continue":"Continue","ui.migrate.setup":"Setup","ui.migrate.skip":"Skip","ui.migrate.retry":"Check again","ui.migrate.retryAll":"Check all","ui.migrate.withDeletes":"Execute all database changes including DROP queries.","ui.migrate.migrationTitle":"Database Migrations","ui.migrate.schemaTitle":"Schema Updates","ui.migrate.problemTitle":"Database Problems","ui.migrate.warningTitle":"Database Warnings","ui.migrate.addTable":"Add table {table}","ui.migrate.dropTable":"Drop table {table}","ui.migrate.addField":"Add field {table}.{field}","ui.migrate.changeField":"Change field {table}.{field}","ui.migrate.dropField":"Drop field {table}.{field}","ui.migrate.createIndex":"Create index \\"{name}\\" on {table}","ui.migrate.dropIndex":"Drop index \\"{name}\\" on {table}","ui.widget.mandatory":"This field must not be empty.","ui.widget.blankOption":"Please select …","ui.widget.showPassword":"Show password","ui.widget.hidePassword":"Hide password","ui.error.title":"HTTP request for \\"{method} {url}\\" failed.","ui.error.server500":"Looks like an unexpected error happened on your server. Please check the log files of your web server (Apache/Nginx) and the Contao Manager logs at \\"contao-manager/logs\\".","ui.error.response":"The server returned a response with status code {status}.","ui.error.moreLink":"More Information","ui.error.support":"Contao Support","ui.footer.help":"Help","ui.footer.reportProblem":"Report a Problem","ui.navigation.discover":"Discover","ui.navigation.packages":"Packages","ui.navigation.tools":"Tools","ui.navigation.installTool":"Install Tool","ui.navigation.backend":"Contao Backend","ui.navigation.debug":"Contao Debug Mode","ui.navigation.logViewer":"Log Viewer","ui.navigation.phpinfo":"PHP Information","ui.navigation.phpinfoLoading":"Loading PHP Information…","ui.navigation.maintenance":"Maintenance","ui.navigation.rebuildCache":"Rebuild Cache","ui.navigation.systemCheck":"System Check","ui.navigation.advanced":"Advanced","ui.navigation.logout":"Logout","ui.maintenance.database.title":"Database Migrations and Backups","ui.maintenance.database.description":"Database migrations ensure consistent data and table schemas.","ui.maintenance.database.migrations":"One pending database migration | {count} pending database migrations","ui.maintenance.database.schemaUpdates":"One pending schema update | {count} pending schema updates","ui.maintenance.database.error":"Database problem found.","ui.maintenance.database.warning":"Database warnings found.","ui.maintenance.database.button":"Check database","ui.maintenance.database.migrationOnly":"Check migrations only","ui.maintenance.database.schemaOnly":"Check schema only","ui.maintenance.database.installTool":"Open Install Tool","ui.maintenance.database.createBackup":"Create Backup","ui.maintenance.database.backupUnsupported":"Database backups are not supported by your Contao version.","ui.maintenance.database.backupList":"You have one database backup, created on {date}. | You have {count} database backups, the latest one was created on {date}.","ui.maintenance.database.backupEmpty":"You currently have no database backups.","ui.maintenance.rebuildCache.title":"Application Cache","ui.maintenance.rebuildCache.description":"Rebuilding the application cache is required after modifying any of the configuration files.","ui.maintenance.rebuildCache.rebuildProd":"Rebuild Production Cache","ui.maintenance.rebuildCache.rebuildDev":"Rebuild Development Cache","ui.maintenance.rebuildCache.clearProd":"Clear Production Cache","ui.maintenance.rebuildCache.clearDev":"Clear Development Cache","ui.maintenance.installTool.title":"Contao Install Tool","ui.maintenance.installTool.description":"The Contao Install Tool is automatically locked if you enter a wrong password three times in a row.","ui.maintenance.installTool.unlock":"Unlock Install Tool","ui.maintenance.installTool.lock":"Lock Install Tool","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"The Composer autoloader is responsible for PHP class loading. The autoloader must be dumped after adding custom namespaces to the root composer.json.","ui.maintenance.dumpAutoload.button":"Dump Autoloader","ui.maintenance.composerInstall.title":"Composer Dependencies","ui.maintenance.composerInstall.description":"Composer dependencies are located in the {vendor} folder in your application root. Reinstalling the dependencies can be necessary after manipulation or manually uploading the {composerLock} file.","ui.maintenance.composerInstall.button":"Run Installer","ui.maintenance.composerInstall.update":"Run Composer Update","ui.maintenance.composerCache.title":"Composer Cache","ui.maintenance.composerCache.description":"Composer caches downloaded packages for improved performance. If you have issues like broken files, try to delete the Composer cache to force a new download.","ui.maintenance.composerCache.button":"Clear Cache","ui.maintenance.maintenanceMode.title":"Maintenance Mode","ui.maintenance.maintenanceMode.description":"Putting Contao in maintenance mode will display a \\"503 Service Unavailable\\" template for the website.","ui.maintenance.maintenanceMode.enable":"Enable","ui.maintenance.maintenanceMode.disable":"Disable","ui.maintenance.debugMode.title":"Debug Mode","ui.maintenance.debugMode.description":"Activate the debug mode by setting a user and password for the {appDevPhp} entry point.","ui.maintenance.debugMode.descriptionJwt":"Activate the debug mode by setting the debug cookie for the current domain.","ui.maintenance.debugMode.activate":"Activate","ui.maintenance.debugMode.deactivate":"Deactivate","ui.maintenance.debugMode.credentials":"Credentials","ui.maintenance.debugMode.user":"Please enter a username for the debug mode.","ui.maintenance.debugMode.password":"Please enter a password for the debug mode.","ui.maintenance.opcodeCache.title":"Opcode Cache","ui.maintenance.opcodeCache.description":"Opcode caches PHP files on the web process for faster execution. It must be deleted under certain circumstances if files are not recognized after changing.","ui.maintenance.opcodeCache.button":"Truncate Cache","ui.maintenance.safeMode":"Not available in Safe Mode","ui.maintenance.unsupported":"Not supported by your Contao version","ui.packages.updateButton":"Update Packages","ui.packages.searchButton":"Search Packages","ui.packages.searchPlaceholder":"Search Packages …","ui.packages.uploadOverlay":"Drag & drop files to upload","ui.packages.uploadButton":"Upload Packages","ui.packages.uploadMessage":"You have one unconfirmed upload. | You have {count} unconfirmed uploads.","ui.packages.uploadApply":"Confirm Uploads","ui.packages.uploadReset":"Delete Uploads","ui.packages.uploadIncomplete":"This file was not uploaded completely. Please remove it and try again.","ui.packages.uploadDuplicate":"This file seems to be uploaded multiple times. Please remove the duplicates.","ui.packages.uploadInstalled":"This file is already installed. Please remove the duplicates.","ui.packages.uploadUnsupported":"Uploads are not supported in your installation. Please make sure that the PHP ZIP extension is installed and update your dependencies.","ui.packages.changesMessage":"You have one unconfirmed change. | You have {count} unconfirmed changes.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"Apply Changes","ui.packages.changesApplyAll":"Update all packages","ui.packages.changesDryrunAll":"Dry run all packages","ui.packages.changesReset":"Reset Changes","ui.packages.changesReview":"Review Changes","ui.packagelist.loading":"Loading …","ui.packagelist.uploads":"Uploads","ui.packagelist.added":"New packages","ui.packagelist.installed":"Installed packages","ui.package.hintRevert":"Revert Changes","ui.package.hintNoupdate":"Do not update","ui.package.hintConstraint":"This package will be installed with constraint {constraint} when you apply the changes.","ui.package.hintConstraintBest":"This package will be installed in the best available version when you apply the changes.","ui.package.hintConstraintChange":"The constraint for this package will be changed from \\"{from}\\" to \\"{to}\\" when you apply the changes.","ui.package.hintConstraintUpdate":"This package will be updated when you apply the changes.","ui.package.hintAdded":"This package will be installed when you apply the changes.","ui.package.hintRemoved":"This package will be removed when you apply the changes.","ui.package.requiredTitle":"manually added","ui.package.requiredText":"This package is required in your composer.json but not installed.","ui.package.removedTitle":"manually removed","ui.package.removedText":"This package was removed from your composer.json.","ui.package.installed":"Currently installed:","ui.package.version":"Version {version}","ui.package.additionalDownloads":"{count} Download | {count} Downloads","ui.package.additionalStars":"{count} Star | {count} Stars","ui.package.editConstraint":"Edit","ui.package.uploadConstraint":"This constraint is defined by the uploaded package.","ui.package.updateButton":"Update","ui.package.removeButton":"Remove","ui.package.installButton":"Add Package","ui.package.installButtonShort":"Add","ui.package.detailsButton":"Details","ui.package.latestConstraint":"latest version","ui.package.update":"Update available","ui.package.updateLatest":"latest version","ui.package.updateAvailable":"{version} available","ui.package.updateUnknown":"unknown version","ui.package.updateConstraint":"A newer version outside your version constraint is available.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Version {version}","ui.cloudStatus.waitingTime":"Waiting Time","ui.cloudStatus.jobs":"Current Jobs","ui.cloudStatus.workers":"Workers","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"none","ui.cloudStatus.short":"ca. {minutes} min","ui.cloudStatus.long":"ca. {minutes} min {seconds} sec","ui.cloudStatus.error":"Unable to fetch the status of the Composer Resolver Cloud. It might be down for maintenance or experience issues.","ui.cloudStatus.button":"Cloud Status","ui.cloudStatus.refresh":"Refresh Cloud Status","ui.log-viewer.loading":"Loading …","ui.log-viewer.empty":"There are no log files on your server.","ui.log-viewer.reload":"Reload","ui.log-viewer.file":"Log file","ui.log-viewer.channel":"Channel","ui.log-viewer.channelTitle":"The channel this message was logged to.","ui.log-viewer.level":"Level","ui.log-viewer.levelTitle":"Severity of the log message.","ui.log-viewer.timeHeader":"Time","ui.log-viewer.messageHeader":"Message","ui.log-viewer.showContext":"Show Context","ui.log-viewer.hideContext":"Hide Context","ui.log-viewer.showExtra":"Show Extra","ui.log-viewer.hideExtra":"Hide Extra","ui.log-viewer.more":"Load more …","ui.log-viewer.download":"Download","ui.log-viewer.downloadTitle":"Download file \\"{file}\\"","ui.log-viewer.prodEnvironment":"Production Environment","ui.log-viewer.devEnvironment":"Development Environment (Debug Mode)"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[551],{2551:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! この接続は安全ではありません !!","ui.app.httpsDescription":"HTTPSでないと秘密のデータも暗号化しないで送信してしまいます。","ui.app.httpsLink":"詳細な情報","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! セーフモードが有効です !!","ui.app.safeModeDescription":"Contao Managerの一部の機能は利用できません。","ui.app.safeModeExit":"セーフモードを終了","ui.app.loading":"Contao Managerを読み込み中…","ui.app.apiError":"予期しないAPIの状態","ui.app.configSecurity1":"セキュリティ警告!!!  保護していない設定ディレクトリを検出","ui.app.configSecurity2":"Contao Managerは設定ファイルが公開してアクセスできる状態を検出しました。ディレクトリを安全な状態にするまで、すべての操作は動作しません、そうしないとインストールに含まれている極秘データを攻撃者がアクセスできる可能性があるためです。\\n\\nこれを修正するには\\"contao-manager\\"のディレクトリへのアクセスを禁止してください。この方法を学ぶには、ウェブサーバーのマニュアルを参照するかホスティング提供者に連絡してください。","ui.account.welcome":"ようこそ","ui.account.intro1":"Contao Managerにようこそ。Contao ManagerはContaoオープンソースCMSのインストールと管理を行う多才なツールです。Contao Managerを初めて利用する場合は{readTheManualToGetStarted}","ui.account.introGetStarted":"最初に{readTheManual} ","ui.account.introManual":"マニュアルを読んでください","ui.account.intro2":"何か問題があった場合は、{ourGithubIssues} を確認して、まだ報告されていない新しいどの様な問題は自由に新しいIssueを作成してください。","ui.account.introIssues":"GitHubのIssue","ui.account.headline":"ユーザーアカウント","ui.account.description":"インストールしたContaoを管理するには新しいアカウントを作成してください。このアカウントはContaoのバックエンドやフロントエンドとはまったく関係ないことに注意してください。","ui.account.username":"ユーザー名","ui.account.password":"パスワード","ui.account.passwordPlaceholder":"最小で8文字","ui.account.passwordLength":"少なくとも8文字を入力してください。","ui.account.submit":"アカウントを作成","ui.account.contribute1":"ContaoとContao Managerは非営利のContao Associationが支援しています。","ui.account.contribute2":"{donate}でオープンソースに貢献することをご検討ください。","ui.account.contributeDonate":"寄付をする","ui.login.headline":"サインイン","ui.login.description":"インストールを管理するにはログインします。","ui.login.username":"ユーザー名","ui.login.password":"パスワード","ui.login.forgotPassword":"パスワードを忘れましたか?","ui.login.button":"サインイン","ui.login.locked":"Contao Managerはロック状態のためアクセスを拒否しました。ロックを解除するには、Contaoのルートディレクトリにあるファイル: {lockFile}を削除してください。","ui.logout.headline":"セッションタイムアウト","ui.logout.warning":"25分以上アクセスがありません。セキュリティ上の理由から、セッションを間もなく終了します。","ui.logout.expired":"30分以上アクセスがなかったため自動的にセッションを終了しました。","ui.logout.renew":"ログインを維持","ui.logout.logout":"ログアウト","ui.logout.login":"ログイン画面に戻る","ui.oauth.error":"不正なOAuthの試みです。リクエストのパラメーターを確認してください。","ui.oauth.https":"平文で認証トークンが転送されることを防ぐため、リダイレクトのURIは安全なプロトコル(https:)を*使用*しなければなりません。","ui.oauth.headline":"リモート認証","ui.oauth.description":"以下のアプリケーションやサービスが、このContao Managerへのリモートアクセスを要求しています。","ui.oauth.domain":"アクセスを許可する前に、このURLのことを知っていて所有者を信頼できることを確認してください!","ui.oauth.allow":"アクセスを許可","ui.oauth.deny":"アクセスを拒否","ui.boot.headline":"システム検査","ui.boot.description":"しばらくお待ちください、サーバーを解析中です...","ui.boot.issue1":"インストール上の問題を検出","ui.boot.issue2":"Contao Managerを使用できるようにする前に修正しなければならない問題があります。","ui.boot.run":"Contao Managerを開始","ui.boot.safeMode":"セーフモードで開始","ui.recovery.headline":"システム回復","ui.recovery.description":"Contao ManagerはContaoと思われるファイルを検出しましたが、コマンド行のインターフェイスは期待した様に動作しませんでした。","ui.recovery.console":"コンソール出力","ui.recovery.repairOptions":"インストールしたContaoを修正する方法を選択してください。","ui.recovery.repairHeadline":"自動修復","ui.recovery.repairDescription":"アプリケーションキャッシュの再構築とComposerパッケージを再インストールすることで、自動的にインストールの修復を試みます。","ui.recovery.repairWarning":"この処理でベンダーのファイルに行った変更は取り消されるかもしれません!","ui.recovery.repairFailed":"自動修復できませんでした。セーフモードで手作業でインストールを修復してみてください。","ui.recovery.repairButton":"システム修復を実行","ui.recovery.safeModeHeadline":"セーフモード","ui.recovery.safeModeDescription":"Contao Managerをセーフモードで開始するとパッケージの管理と特定の保守のタスクを実行できます。しかし、インストールしたContaoの動作に依存した機能は利用できません。","ui.recovery.safeModeButton":"セーフモードで開始","ui.server.pending":"待機中...","ui.server.running":"解析中…","ui.server.error":"サーバーからの予期しない応答のため検査に失敗しました。","ui.server.details":"詳細","ui.server.prerequisite":"前提条件を満たせていないため検査を取り止めました。","ui.server.selfUpdate.title":"Contao Managerを更新","ui.server.selfUpdate.update":"新しいContao Managerのバージョン {latest} を利用できます。","ui.server.selfUpdate.manualUpdate":"新しいContao Managerバージョン{latest}を利用できます。使用しているサーバーは自動的な更新をサポートしていません、新しいバージョンを {download} からダウンロードしてください。","ui.server.selfUpdate.latest":"最新のバージョン: {current}を使用しています。","ui.server.selfUpdate.dev":"開発版は自動的な更新をサポートしていません。","ui.server.selfUpdate.unsupported":"新しいバージョンを利用できますが、使用しているPHPのバージョンをサポートしていません。","ui.server.selfUpdate.button":"自己更新を実行","ui.server.selfUpdate.continue":"続ける","ui.server.config.title":"サーバーの構成","ui.server.config.setup":"構成","ui.server.config.change":"変更","ui.server.config.save":"保存","ui.server.config.cancel":"取り止め","ui.server.config.customOption":"その他…","ui.server.config.description":"バックグラウンドのタスクを正しく実行するため、Contao ManagerはPHPのコマンド行の実行ファイルがある場所と、ウェブのプロセスから切り離してコマンドを実行する方法を知る必要があります。","ui.server.config.formTitle":"サーバーの構成","ui.server.config.formText":"PHPの実行ファイルのパスを入力してください。Webのプロセスと同じバージョンのPHPであることを忘れずに確認してください。","ui.server.config.cloudTitle":"Composerリゾルバークラウド","ui.server.config.cloudText":"Composerリゾルバークラウドによって、サーバーが十分なローカルのメモリを提供しない場合でもComposerの依存関係のインストールが可能になります。パッケージの情報がContao Associationが運用するクラウドに送信されることに注意してください。","ui.server.config.cloud":"Composerリゾルバークラウドを使用","ui.server.config.cli":"PHPの実行ファイル","ui.server.config.stateErrorCli":"有効なPHPの実行ファイルをサーバー上に見つけられませんでした。","ui.server.config.stateErrorCloud":"Composerリゾルバークラウドをサポートしていません。","ui.server.config.stateSuccess":"PHPの実行ファイルは{php_cli}です。","ui.server.php_web.title":"PHPのWebプロセス","ui.server.php_web.below7":"PHPのバージョン {version} を検出しました。可能な限りPHP 7に切り替えてください!","ui.server.php_web.success":"PHPのバージョン {version} を検出しました、既知の問題はありませんでした。","ui.server.php_cli.title":"PHPコマンド行インターフェイス","ui.server.php_cli.success":"PHPのバージョン {version} を検出しました、既知の問題はありませんでした。","ui.server.composer.title":"Composer環境","ui.server.composer.success":"既知の問題はありませんでした。","ui.server.composer.install":"Composerの依存関係はインストールしていません。","ui.server.composer.button":"インストール","ui.server.contao.title":"Contaoのインストール","ui.server.contao.setup":"セットアップ","ui.server.contao.check":"データベースを検査","ui.server.contao.empty":"インストールしているContaoは見つかりませんでした。","ui.server.contao.old":"Contaoのバージョン{version}はContao Managerと互換性がありません。インストールしているContaoを手作業で更新してください。","ui.server.contao.found":"Contao {version} (APIバージョン {api})を検出しました。","ui.server.contao.connectionError":"データベースサーバーに接続できません。","ui.server.contao.connectionProblem":"データベースの問題が見つかりました。","ui.server.contao.missingUser":"管理者のアカウントがありません。","ui.setup.continue":"続ける","ui.setup.manager":"Contao Managerを開始","ui.setup.cancel":"取り止め","ui.setup.welcome":"ようこそ","ui.setup.welcome1":"このウィザードはContaoオープンソースCMSを設定するのに必要な段階を案内します。","ui.setup.welcome2":"もし質問がありましたらドキュメント、フォーラム、Slackのチャンネル、さらに多くの情報を{support}のページから探してください。","ui.setup.support":"コミュニティサポート","ui.setup.start":"始める","ui.setup.complete":"おめでとうございます!","ui.setup.complete1":"Contao {version}をうまくインストールしました。","ui.setup.complete2":"設定の処理を終えるには、インストールツールを開いて、データベース接続を構成し、バックエンドのユーザーを作成してください。","ui.setup.complete3":"Contaoのバックエンドでウェブサイトを作成できるようになりました。追加の機能拡張が必要な場合は、Contao Managerを続けてください。","ui.setup.installTool":"インストールツールを開く","ui.setup.login":"Contaoにログイン","ui.setup.funding":"フリーソフトウェアの「フリー」は「言論の自由」の自由であって、「無料のビール」の「無料」ではありません。Contaoのようなオープンソースのプロジェクトは一人の個人や1つの会社では集められない資金を必要とします。\\nContaoでウェブサイトを構築したり、構築したウェブサイトを販売される場合は、ビジネスが依存する製品に金銭的に貢献されることを期待しています。","ui.setup.fundingLink":"さらに学ぶ","ui.setup.document-root.headline":"Webサーバーの設定","ui.setup.document-root.warning":"Contao ManagerからContaoをインストールするには、Webサーバーのドキュメントルートを修正しなければなりません。","ui.setup.document-root.description1":"Contaoは公開するファイルに別のフォルダーを使用し、その親のフォルダーにアプリケーションのファイルをインストールします。フォルダーの構造が正しくないか、またはフォルダーが空でない場合はContaoをインストールできません。","ui.setup.document-root.description2":"ドキュメントルートを構成する方法を知らない場合は、Contaoのドキュメントを読むかホスティングサービスの提供者に連絡してください。","ui.setup.document-root.documentation":"ドキュメントを読む","ui.setup.document-root.conflictsTitle":"インストール先のディレクトリが空ではありません","ui.setup.document-root.conflictsDirectory":"Contaoをインストールしようとしているルートのディレクトリが空ではありません、インストールの処理で{count}個のファイルを上書きするかもしれません。Contaoのために空のディレクトリ構造の作成を推奨しますが、以下のファイルを使用していないことが確かな場合は、これらを削除して再検査することもできます。","ui.setup.document-root.ignoreConflicts":"空でないディレクトリにContaoをインストールしようとしています。Web領域の既存のファイルを上書きする可能性を理解しています。","ui.setup.document-root.check":"再検査","ui.setup.document-root.create":"ディレクトリを作成","ui.setup.document-root.change":"ディレクトリを変更","ui.setup.document-root.formTitle":"ディレクトリ設定","ui.setup.document-root.formText1":"Contao Managerはサーバー上に新しいディレクトリ構成を自動的に作成できます。","ui.setup.document-root.formText2":"手作業で(例えば、ホスティングの管理パネルから)新しいドキュメントルートを構成する必要があります。","ui.setup.document-root.autoconfig":"サーバーの構成を変更しなければならないことを理解しました。ドキュメントルートを構成しないとContao Managerは壊れ、(アカウントの詳細とパスワードを含んだ)構成ファイルを剥き出しの状態にしてしまいます。","ui.setup.document-root.directory":"新しいディレクトリ","ui.setup.document-root.currentRoot":"現在のドキュメントルート","ui.setup.document-root.newRoot":"新しいドキュメントルート","ui.setup.document-root.finish":"ディレクトリの設定","ui.setup.document-root.publicDir":"{dir}を(Contao {version}の)公開ファイルの場所として使用","ui.setup.document-root.directoryInvalid":"有効なディレクトリの名前を入力してください。","ui.setup.document-root.directoryExists":"目的のディレクトリは既に存在します。異なる名前を入力してください。","ui.setup.document-root.confirmation":"Contao ManagerはContaoのインストールに必要なディレクトリを作成しました。次にウェブサーバーのドキュメントルートを構成しなければなりません。このページをそれまで再読み込みしないでください。","ui.setup.document-root.reload":"ページを再読み込み","ui.setup.document-root.success":"ウェブサーバーにディレクトリ構造を正しく設定できました!","ui.setup.document-root.installingProjectDir":"{dir}にアプリケーションのファイルをインストールします。","ui.setup.document-root.installingPublicDir":"{dir}に公開するファイルをインストールします。","ui.setup.document-root.installedProjectDir":"{dir}にアプリケーションのファイルをインストールしました。","ui.setup.document-root.installedPublicDir":"{dir}に公開するファイルをインストールしました。","ui.setup.create-project.headline":"Contaoのインストール","ui.setup.create-project.description":"Contaoの開発は{semver}の概念にしたがっていて、新しいマイナーバージョンを6か月毎にリリースします。現在サポートしているリリース:","ui.setup.create-project.semver":"セマンティックバージョニング","ui.setup.create-project.latestTitle":"最新","ui.setup.create-project.ltsTitle":"長期サポート版","ui.setup.create-project.latestQ1":"最新のバージョン、もっとも多くの機能を提供して{year}年2月までサポートします。","ui.setup.create-project.latestQ3":"最新のバージョン、もっとも多くの昨日を提供して{year}年8月までサポートします。","ui.setup.create-project.ltsText":"現在のLTSバージョン、安定性を重視する場合に選んでください。さらに{year}年2月までの長期サポートを提供します。","ui.setup.create-project.pltsText":"以前のLTSバージョン、さらに{year}年2月までの長期サポートを提供します。","ui.setup.create-project.requiresPHP":"少なくともPHP {version}が必要です、現在はPHP {current}です。","ui.setup.create-project.requiresDocroot":"ドキュメントルートは\\"{folder}\\"でなければなりません。","ui.setup.create-project.releaseplan":"詳細な情報は{contaoReleasePlan}を参照してください。","ui.setup.create-project.releaseplanLink":"Contaoのリリース計画","ui.setup.create-project.installed":"サーバーにContao {version}のインストールに成功しました。データベースの設定を続けるか、異なるバージョンをインストールするにはContao Managerを起動してください。","ui.setup.create-project.formTitle":"配布の選択","ui.setup.create-project.formText":"インストールするバージョンを選択してください。","ui.setup.create-project.version":"バージョン","ui.setup.create-project.demo":"Contaoのデモ版のWebサイトをインストール","ui.setup.create-project.demoDescription":"デモ版のWebサイトはContaoと、その基本的な特徴を知る助けとなります。テーマはさらに{store}で入手できます。","ui.setup.create-project.coreOnly":"最小のインストール(コアだけ)","ui.setup.create-project.noUpdate":"インストールを省く(専門家だけ!)","ui.setup.create-project.theme":"Contaoのテーマ","ui.setup.create-project.themeInstall":"Contaoのテーマをインストールするには、検索入力を使用するか、Contao Managerからのインストールをサポートしたテーマのファイル(.ctoまたは.zip)をアップロードしてください。","ui.setup.create-project.themeBuy":"必ず公式の{store}にアクセスしてください。","ui.setup.create-project.themeStore":"Contaoのテーマのストア","ui.setup.create-project.themeUpload":"テーマのファイル(.cto/.zip)をアップロード","ui.setup.create-project.themeInvalid":"アップロードしたファイルはContaoのテーマではないか、Contao Managerをサポートしていません。","ui.setup.create-project.themeWarning":"このテーマがサーバーと互換性があるかどうか、COntao Managerは判断できません。何か疑問がある場合はテーマのベンダーに相談してください。","ui.setup.create-project.themeTitle":"テーマの詳細を調査","ui.setup.create-project.themeDetails":"このテーマは以下の依存関係とファイルもインストールします。","ui.setup.create-project.themeRequire":"{count} 依存関係 | {count} 依存関係","ui.setup.create-project.themeFiles":"{count} ファイル | {count} ファイル","ui.setup.create-project.theme.or":"または公開テーマを検索","ui.setup.create-project.theme.search":"テーマを検索","ui.setup.create-project.theme.more":"さらにテーマ","ui.setup.create-project.theme.empty":"{query}に一致するテーマがありません。","ui.setup.create-project.theme.uploaded":"テーマのファイルのアップロードに成功しました。","ui.setup.create-project.theme.packageName":"パッケージ名","ui.setup.create-project.theme.version":"バージョン","ui.setup.create-project.theme.authors":"作成者","ui.setup.create-project.install":"インストール","ui.setup.create-project.cancel":"取り止め","ui.setup.database-connection.headline":"データベース接続","ui.setup.database-connection.description":"Contaoはページ、コンテント、ユーザー、他の関係のあるデータを保管するためにMySQLデータベース(またはMariaDBの様な互換性のある分岐)を必要とします。接続のパラメーターは、Contaoをインストールしたプロジェクトのルートにある{env}ファイルに保存します。","ui.setup.database-connection.formTitle":"接続パラメーター","ui.setup.database-connection.formText":"データベースのURLを入力するか、ユーザー名、パスワード、サーバー、データベースの欄を別々に入力してください。","ui.setup.database-connection.url":"データベースのURL","ui.setup.database-connection.validUrl":"データベースのURLが正しくないか、サーバーへの接続に失敗しました。","ui.setup.database-connection.or":"または","ui.setup.database-connection.user":"ユーザー名","ui.setup.database-connection.password":"パスワード","ui.setup.database-connection.server":"サーバー(:ポート)","ui.setup.database-connection.database":"データベース名","ui.setup.database-connection.connected":"{server}のデータベース{database}に接続しました。","ui.setup.database-connection.error":"データベースの接続のエラーです。","ui.setup.database-connection.problem":"Contaoはデータベースサーバーの問題を検出しました。","ui.setup.database-connection.schemaTitle":"データベーススキーマ","ui.setup.database-connection.migration":"未解決の移行が1件あります。 | 未解決の移行が{count}件あります。","ui.setup.database-connection.schema":"未解決のスキーマの更新が1件あります。 | 未解決のスキーマの更新が{count}件あります。","ui.setup.database-connection.noChanges":"データベースのスキーマは最新です。","ui.setup.database-connection.check":"データベースを検査","ui.setup.database-connection.skip":"飛ばす","ui.setup.database-connection.save":"保存","ui.setup.database-connection.change":"認証情報を変更","ui.setup.database-connection.restoreTitle":"データベースをインポート","ui.setup.database-connection.restoreText":"先ほどインストールしたテーマはデータベースのバックアップを含んでいます。データベースを復元してテーマのデータを取り込むか、空のContaoのインストールから始める場合はこの段階を飛ばしてください。 | 先ほどインストールしたテーマは複数のデータベースのバックアップを含んでいます。バックアップのファイルを選択してテーマのデータをインポートするか、空のContaoのインストールから始める場合はこの段階を飛ばしてください。","ui.setup.database-connection.backup":"インポート前に現在のデータベースをバックアップ","ui.setup.database-connection.backupWarning":"データベースのすべてのデータを上書きします。データベースが空でない場合は最初にバックアップを作成してください。","ui.setup.database-connection.restore":"テーマのデータベースをインポート","ui.setup.database-connection.restoreOption":"{date} ({size})からバックアップ","ui.setup.database-connection.restored":"テーマのデータベースのインポートに成功しました。データベースのスキーマの検証に進んでください。","ui.setup.backend-user.success":"データベースにContaoのバックエンドの管理者のアカウントがあります。さらにユーザーを追加するにはContaoのバックエンドを使用してください。","ui.setup.backend-user.error":"ユーザーのリストを取り出せません。詳細はコンソールの出力を確認してください。","ui.setup.backend-user.headline":"バックエンドのアカウント","ui.setup.backend-user.description":"ウェブサイトを管理するには、少なくともContaoのバックエンドの管理者のアカウントが1つ必要です。このアカウントはContao Managerと無関係なことに注意してください。","ui.setup.backend-user.formTitle":"アカウントを作成","ui.setup.backend-user.formText":"新しいバックエンドのアカウントの詳細を入力してください。","ui.setup.backend-user.username":"ユーザー名","ui.setup.backend-user.name":"名前","ui.setup.backend-user.email":"電子メールアドレス","ui.setup.backend-user.emailInvalid":"有効な電子メールアドレスを入力してください。","ui.setup.backend-user.password":"パスワード","ui.setup.backend-user.passwordPlaceholder":"最小で8文字","ui.setup.backend-user.passwordLength":"少なくとも8文字を入力してください。","ui.setup.backend-user.create":"アカウントを追加","ui.task.headline":"バックグランドのタスク","ui.task.loading":"詳細を読み込み中...","ui.task.created":"詳細を読み込み中...","ui.task.active":"Contao Managerがバックグラウンドでタスクの処理を実行を開始するまで、しばらくお待ちください。","ui.task.complete":"すべての処理を正常に完了しました。詳細はコンソールの出力を確認してください。","ui.task.aborting":"バックグラウンドの処理を取り消すまで、しばらくお待ちください。","ui.task.stopped":"バックグラウンドの処理の一部を取り消しました。コンソールの出力を確認してください。","ui.task.error":"バックグラウンドの処理が予期せず停止しました。コンソールの出力を確認してください。","ui.task.failed":"Contao Managerはバックグラウンドのタスクを開始できませんでした!","ui.task.failedDescription1":"バックグラウンドで処理を実行しようとするときに何か問題がありました。","ui.task.failedDescription2":"これが再度起きる場合は、サーバーはサポートされていないかもしれません。","ui.task.reportProblem":"問題を報告","ui.task.sponsor":"{sponsor}が後援のComposer Cloud","ui.task.buttonAudit":"データベースを更新","ui.task.buttonClose":"閉じる","ui.task.buttonConfirm":"確認して閉じる","ui.task.buttonCancel":"取り止め","ui.task.confirmCancel":"このタスクを本当に取り止めて良いですか?  取り止めるとContaoのインストールを壊れた状態のままにするかもしれません。","ui.task.autoclose":"正常に終了したときにタスクの詳細を閉じる","ui.console.toggle":"コンソールの出力を表示・非表示","ui.console.showLog":"完全なコンソールのログを表示","ui.console.copyLog":"ログをクリップボードにコピー","ui.migrate.headline":"データベースの更新","ui.migrate.migrationsOnly":"(移行だけ)","ui.migrate.schemaOnly":"(スキーマだけ)","ui.migrate.loading":"しばらくお待ちください、データベースを検査中です...","ui.migrate.empty":"未解決な移行やスキーマの更新はありません。データベースは最新です。","ui.migrate.emptyMigrations":"未解決な移行はありません。スキーマの更新も忘れずにしてください。","ui.migrate.emptySchema":"未解決なスキーマの更新はありません。移行の確認も忘れずにしてください。","ui.migrate.pending":"データベースが最新ではありません。以下のコンソール出力を再確認して変更を実行してください。","ui.migrate.previousChanges":"以前のデータベース移行を確認できませんでした。\\n以下のコンソール出力を再確認して、次の変更の確認に進んでください。","ui.migrate.previousComplete":"以前のデータベース移行を確認できませんでしたので、以下のコンソール出力を再確認してください。\\nこれ以上の未解決な変更はありません。","ui.migrate.appliedChanges":"データベースの更新を適用しました。\\n以下のコンソール出力を再確認して、次の変更の確認に進んでください。","ui.migrate.appliedComplete":"データベースの更新を適用しました。\\n未確認の移行やスキーマの更新はありません。データベースは最新の状態です。","ui.migrate.problem":"Contaoはデータベースサーバーの問題を検出しました。\\n下のコンソール出力を再確認して修正しなければならない事項を調査してください!","ui.migrate.warning":"Contaoはデータベースサーバーの誤った設定を検出しました。\\n一時的に警告は無視できますが、最適な性能とデータの一貫性のためには修正しなければなりません。","ui.migrate.error":"変更を適用できませんでした。データベースは変更されているかもしれません、再確認して再実行してください。","ui.migrate.execute":"実行","ui.migrate.close":"閉じる","ui.migrate.confirm":"確認して閉じる","ui.migrate.cancel":"取り止め","ui.migrate.continue":"続ける","ui.migrate.setup":"セットアップ","ui.migrate.skip":"飛ばす","ui.migrate.retry":"再検査","ui.migrate.retryAll":"すべて検査","ui.migrate.withDeletes":"DROPの処理を含む、すべてのデータベースの変更を実行します。","ui.migrate.migrationTitle":"データベースの移行","ui.migrate.schemaTitle":"スキーマの更新","ui.migrate.problemTitle":"データベースの問題","ui.migrate.warningTitle":"データベースの警告","ui.migrate.addTable":"テーブルを追加","ui.migrate.dropTable":"テーブルを削除","ui.migrate.addField":"項目{table}.{field}を追加","ui.migrate.changeField":"項目{table}.{field}を変更","ui.migrate.dropField":"項目{table}.{field}を削除","ui.migrate.createIndex":"{table}にインデックス\\"{name}\\"を作成","ui.migrate.dropIndex":"{table}のインデックス\\"{name}\\"を削除","ui.widget.mandatory":"この欄の入力は必須です。","ui.widget.blankOption":"選択してください…","ui.widget.showPassword":"パスワードを表示","ui.widget.hidePassword":"パスワードを非表示","ui.error.title":"\\"{method} {url}\\"というHTTPの要求に失敗しました。","ui.error.server500":"予期しないエラーがサーバーで発生したようです。Webサーバー(Apache/Nginx)のログファイルと、Contao Managerの\\"contao-manager/logs\\"へのログを確認してください。","ui.error.response":"サーバーは{status}という応答コードを返しました。","ui.error.moreLink":"詳細な情報","ui.error.support":"Contaoサポート","ui.footer.help":"ヘルプ","ui.footer.reportProblem":"問題を報告","ui.navigation.discover":"発見","ui.navigation.packages":"パッケージ","ui.navigation.tools":"ツール","ui.navigation.installTool":"インストールツール","ui.navigation.backend":"Contaoのバックエンド","ui.navigation.debug":"Contaoのデバッグモード","ui.navigation.logViewer":"ログ表示","ui.navigation.phpinfo":"PHPの情報","ui.navigation.phpinfoLoading":"PHPの情報を読み込み中...","ui.navigation.maintenance":"保守","ui.navigation.rebuildCache":"キャッシュを再作成","ui.navigation.systemCheck":"システム検査","ui.navigation.advanced":"詳細","ui.navigation.logout":"ログアウト","ui.maintenance.database.title":"データベースの移行とバックアップ","ui.maintenance.database.description":"データベースの移行はデータとテーブルのスキーマの一貫性を確保します。","ui.maintenance.database.migrations":"未解決のデータベース移行が1件 | 未解決のデータベース移行が{count}件","ui.maintenance.database.schemaUpdates":"未解決のスキーマの更新が1件 | 未解決のスキーマの更新が{count}件","ui.maintenance.database.error":"データベースの問題が見つかりました。","ui.maintenance.database.warning":"データベースの警告が見つかりました。","ui.maintenance.database.button":"データベースを検査","ui.maintenance.database.migrationOnly":"移行だけを検査","ui.maintenance.database.schemaOnly":"スキーマだけを検査","ui.maintenance.database.installTool":"インストールツールを開く","ui.maintenance.database.createBackup":"バックアップを作成","ui.maintenance.database.backupUnsupported":"このContaoのバージョンではデータベースのバックアップをサポートしていません。","ui.maintenance.database.backupList":"データベースのバックアップが1個あって、{date}に作成されています。 | データベースのバックアップが{count}個あって、最新のものは{date}に作成されています。","ui.maintenance.database.backupEmpty":"現在データベースのバックアップはありません。","ui.maintenance.rebuildCache.title":"アプリケーションキャッシュ","ui.maintenance.rebuildCache.description":"構成ファイルのいずれかを修正した後はアプリケーションキャッシュの再構築が必要です。","ui.maintenance.rebuildCache.rebuildProd":"実稼働用のキャッシュを再構築","ui.maintenance.rebuildCache.rebuildDev":"開発用のキャッシュを再構築","ui.maintenance.rebuildCache.clearProd":"実稼働用のキャッシュを消去","ui.maintenance.rebuildCache.clearDev":"開発用のキャッシュを消去","ui.maintenance.installTool.title":"Contaoインストールツール","ui.maintenance.installTool.description":"連続して3回誤ったパスワードを入力すると、Contaoのインストールツールは自動的にロック状態となります。","ui.maintenance.installTool.unlock":"インストールツールのロックを解除","ui.maintenance.installTool.lock":"インストールツールをロック","ui.maintenance.dumpAutoload.title":"Composerクラスローダー","ui.maintenance.dumpAutoload.description":"ComposerのオートローダーがPHPのクラスの読み込み担当します。rootのcomposer.jsonに独自のネームスペースを追加した後は、オートローダーを書き出さなければなりません。","ui.maintenance.dumpAutoload.button":"オートローダーを書き出し","ui.maintenance.composerInstall.title":"Composerの依存関係","ui.maintenance.composerInstall.description":"Composerの依存関係はアプリケーションのルートの{vendor}フォルダーに配置されています。{composerLock}ファイルを操作や手動でアップロードした後は依存関係の再インストールが必要な場合があります。","ui.maintenance.composerInstall.button":"インストーラーを実行","ui.maintenance.composerInstall.update":"Composerで更新を実行","ui.maintenance.composerCache.title":"Composerキャッシュ","ui.maintenance.composerCache.description":"Composerは性能向上のためにダウンロードしたパッケージをキャッシュします。壊れたファイルのような問題がある場合は、Composerキャッシュを削除して強制的に新しいダウンロードを行ってみてください。","ui.maintenance.composerCache.button":"キャッシュを消去","ui.maintenance.maintenanceMode.title":"保守モード","ui.maintenance.maintenanceMode.description":"Contaoを保守モードにするとウェブサイトでは\\"503 Service Unavailable\\"のテンプレートを表示します。","ui.maintenance.maintenanceMode.enable":"有効","ui.maintenance.maintenanceMode.disable":"無効","ui.maintenance.debugMode.title":"デバッグモード","ui.maintenance.debugMode.description":"{appDevPhp}のエントリーポイントにユーザーとパスワードを設定してデバッグモードを有効にします。","ui.maintenance.debugMode.descriptionJwt":"現在のドメインにデバッグ用のクッキーを設定してデバッグモードを有効にします。","ui.maintenance.debugMode.activate":"有効化","ui.maintenance.debugMode.deactivate":"無効化","ui.maintenance.debugMode.credentials":"認証情報","ui.maintenance.debugMode.user":"デバッグモードのユーザー名を入力してください。","ui.maintenance.debugMode.password":"デバッグモードのパスワードを入力してください。","ui.maintenance.opcodeCache.title":"Opcodeキャッシュ","ui.maintenance.opcodeCache.description":"Opcodeは高速な実行のためにPHPのファイルをウェブプロセス常にキャッシュします。変更後にファイルの変化を認識していないといった、特定の状況では削除しなければなりません。","ui.maintenance.opcodeCache.button":"キャッシュを切り詰め","ui.maintenance.safeMode":"セーフモードでは利用不可","ui.maintenance.unsupported":"このContaoのバージョンでは非サポート","ui.packages.updateButton":"パッケージを更新","ui.packages.searchButton":"パッケージを検索","ui.packages.searchPlaceholder":"パッケージを検索中…","ui.packages.uploadOverlay":"アップロードするファイルをドラッグアンドドロップ","ui.packages.uploadButton":"パッケージをアップロード","ui.packages.uploadMessage":"未確認の1個のアップロードがあります。 | 未確認の{count}個のアップロードがあります。","ui.packages.uploadApply":"アップロードを実行","ui.packages.uploadReset":"アップロードを削除","ui.packages.uploadIncomplete":"このファイルは完全にアップロードできていません。一旦削除削除してもう一度アップロードしてください。","ui.packages.uploadDuplicate":"このファイルを複数回アップロードした様です。重複しているファイルを削除してください。","ui.packages.uploadInstalled":"このファイルを既にインストールしています。重複しているファイルを削除してください。","ui.packages.uploadUnsupported":"インストールしたContaoはアップロードをサポートしていません。PHPのzip拡張のインストールと依存関係の更新を確認してください。","ui.packages.changesMessage":"未確認の1個の変更があります。 | 未確認の{count}個の変更があります。","ui.packages.changesDryrun":"変更を試行","ui.packages.changesApply":"変更を適用","ui.packages.changesApplyAll":"すべてのパッケージを更新","ui.packages.changesDryrunAll":"すべてのパッケージの変更を試行","ui.packages.changesReset":"変更をリセット","ui.packages.changesReview":"変更を見直し","ui.packagelist.loading":"読み込み中...","ui.packagelist.uploads":"アップロード","ui.packagelist.added":"新しいパッケージ","ui.packagelist.installed":"インストール済みのパッケージ","ui.package.hintRevert":"変更を取り消す","ui.package.hintNoupdate":"更新しない","ui.package.hintConstraint":"この変更を適用すると、このパッケージを{constraint}の制約によりインストールします。","ui.package.hintConstraintBest":"変更を適用すると、このパッケージの利用できる一番良いバージョンをインストールします。","ui.package.hintConstraintChange":"変更を適用すると、このパッケージへの制約は\\"{from}\\"から\\"{to}\\"に変更します。","ui.package.hintConstraintUpdate":"変更を適用すると、このパッケージを更新します。","ui.package.hintAdded":"変更を適用すると、このパッケージをインストールします。","ui.package.hintRemoved":"変更を適用すると、このパッケージを削除します。","ui.package.requiredTitle":"手作業で追加済み","ui.package.requiredText":"このパッケージはcomposer.jsonで必要としていますが、インストールされていません。","ui.package.removedTitle":"手作業で削除済み","ui.package.removedText":"このパッケージはcomposer.jsonから削除されています。","ui.package.installed":"インストール済み:","ui.package.version":"バージョン{version}","ui.package.additionalDownloads":"{count}個のダウンロード | {count}個のダウンロード","ui.package.additionalStars":"{count}のスター | {count}のスター","ui.package.editConstraint":"編集","ui.package.uploadConstraint":"この定数はアップロードしたパッケージで定義されています。","ui.package.updateButton":"更新","ui.package.removeButton":"削除","ui.package.installButton":"パッケージを追加","ui.package.installButtonShort":"追加","ui.package.detailsButton":"詳細","ui.package.latestConstraint":"最新のバージョン","ui.package.update":"更新を利用可能","ui.package.updateLatest":"最新のバージョン","ui.package.updateAvailable":"バージョン{version}を利用可能","ui.package.updateUnknown":"不明なバージョン","ui.package.updateConstraint":"バージョンの制約外に利用できる新しいバージョンがあります。","ui.cloudStatus.headline":"Composerリゾルバークラウド","ui.cloudStatus.version":"バージョン{version}","ui.cloudStatus.waitingTime":"待ち時間","ui.cloudStatus.jobs":"現在のジョブ","ui.cloudStatus.workers":"ワーカー","ui.cloudStatus.approx":"{minutes}分","ui.cloudStatus.none":"なし","ui.cloudStatus.short":"ca. {minutes}分","ui.cloudStatus.long":"ca. {minutes}分{seconds}秒","ui.cloudStatus.error":"Composerリゾルバークラウドの状態を取得できません。保守または技術的な問題のため停止しているかもしれません。","ui.cloudStatus.button":"クラウドの状態","ui.cloudStatus.refresh":"クラウドの状態を更新","ui.log-viewer.loading":"読み込み中...","ui.log-viewer.empty":"サーバーにログファイルはありません。","ui.log-viewer.reload":"際読み込み","ui.log-viewer.file":"ログファイル","ui.log-viewer.channel":"チャネル","ui.log-viewer.channelTitle":"このメッセージを記録する先のチャネルです。","ui.log-viewer.level":"レベル","ui.log-viewer.levelTitle":"ログメッセージの深刻さです。","ui.log-viewer.timeHeader":"時刻","ui.log-viewer.messageHeader":"メッセージ","ui.log-viewer.showContext":"コンテキストを表示","ui.log-viewer.hideContext":"コンテキストを非表示","ui.log-viewer.showExtra":"追加を表示","ui.log-viewer.hideExtra":"追加を非表示","ui.log-viewer.more":" さらに読み込む...","ui.log-viewer.download":"ダウンロード","ui.log-viewer.downloadTitle":"\\"{file}\\"をダウンロード","ui.log-viewer.prodEnvironment":"実運用環境","ui.log-viewer.devEnvironment":"開発環境(デバッグモード)"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[874],{2874:function(e){e.exports=JSON.parse('{"ui.app.title":"Rozšíření Contaa","ui.app.loading":"Načítání seznamu rozšíření...","ui.discover.advertisement":"Reklama v seznamu rozšíření","ui.discover.loading":"Spouštění…","ui.discover.offline":"Nemůžu načíst žádné výsledky.","ui.discover.offlineExplain":"Zkontrolujte prosím Vaše internetové připojení a deaktivujte blokování JavaScriptu ve Vašem prohlížeči.","ui.discover.offlineButton":"Zkusit znovu","ui.discover.searchPlaceholder":"Prohledat {count} rozšíření...","ui.discover.empty":"Žádné výsledky pro {query}","ui.discover.more":"Více výsledků","ui.discover.sortBy":"Seřadit podle","ui.discover.sortReleased":"Zveřejněno","ui.discover.sortReleasedTitle":"Seřadit výsledky podle zveřejnění","ui.discover.sortLatest":"Zaktualizované","ui.discover.sortLatestTitle":"Seřadit výsledky podle naposledy zaktualizovaných","ui.discover.sortDownloads":"Stažení","ui.discover.sortDownloadsTitle":"Seřadit výsledky podle počtu stažení","ui.discover.sortFavers":"Hodnocení","ui.discover.sortFaversTitle":"Seřadit výsledky podle hodnocení","ui.discover.detailsButton":"Podrobnosti","ui.discover.latestPackages":"Poslední a naposledy zaktualizovaná rozšíření","ui.discover.faversPackages":"Nejlépe hodnocená rozšíření","ui.discover.downloadsPackages":"Nejvíce stahovaná rozšíření","ui.package.homepage":"Stránka projektu","ui.package.private":"Soukromý balíček","ui.package.privateTitle":"Soukromé balíčky jsou dostupné pouze z vendoru (např. jako soubor ZIP). Více informací získáte na následujícím webu. ","ui.package.abandoned":"nepřijatý","ui.package.abandonedText":"Tento balíček je označený jako nepřijatý a již se dál vyvíjí.","ui.package.abandonedReplace":"Tento balíček je označený jako nepřijatý a již se dál vyvíjí. Autor místo něho doporučuje použít {replacement}. ","ui.package-details.previous":"Předešlé podrobné informace k rozšíření","ui.package-details.close":"Zavřít podrobné informace k rozšíření","ui.package-details.loading":"Spouštění…","ui.package-details.tabDescription":"Popis","ui.package-details.tabRequire":"Požadavky","ui.package-details.tabFeatures":"Funkce","ui.package-details.tabSuggest":"Doporučení","ui.package-details.tabConflict":"Konflikty","ui.package-details.tabDependents":"Závislosti","ui.package-details.linkRequires":"vyžaduje","ui.package-details.linkReplaces":"nahrazuje","ui.package-details.linkProvides":"poskytuje","ui.package-details.linkConflicts":"konflikty","ui.package-details.funding":"Nalezen vyvíjený balíček!","ui.package-details.latest":"Poslední verze","ui.package-details.released":"Zveřejněno","ui.package-details.license":"Licence","ui.package-details.authors":"od","ui.package-details.more":"Více","ui.package-details.packagist":"Podrobnosti k balíčku","ui.package-details.metadata":"Upravit meta informace","ui.package-details.support_docs":"Dokumentace","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Podpora ve fóru","ui.package-details.support_issues":"Chyby / nahlášení chyb","ui.package-details.support_source":"Zdrojový kód","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Mail podpory","ui.package-details.support_rss":"Kanál RSS"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[542],{7542:function(e){e.exports=JSON.parse('{"ui.app.title":"Contao 扩展","ui.app.loading":"扩展列表加载中 …","ui.discover.advertisement":"Advertisement in the extension list","ui.discover.loading":"加载 …","ui.discover.offline":"无法获取任何结果","ui.discover.offlineExplain":"检查网络连接并在浏览器中禁用JavaScript拦截器。","ui.discover.offlineButton":"重试","ui.discover.searchPlaceholder":"Search in {count} extensions …","ui.discover.empty":"No results for {query}","ui.discover.more":"更多","ui.discover.sortBy":"排序","ui.discover.sortReleased":"Released","ui.discover.sortReleasedTitle":"Sort results by release date","ui.discover.sortLatest":"已更新","ui.discover.sortLatestTitle":"Sort results by last updated","ui.discover.sortDownloads":"下载","ui.discover.sortDownloadsTitle":"Sort results by number of downloads","ui.discover.sortFavers":"评级","ui.discover.sortFaversTitle":"Sort results by rating","ui.discover.detailsButton":"详情","ui.discover.latestPackages":"最新和已更新扩展","ui.discover.faversPackages":"最高评级扩展","ui.discover.downloadsPackages":"下载最多扩展","ui.package.homepage":"项目网站","ui.package.private":"私有包","ui.package.privateTitle":"私有包仅可从提供商获取 (e.g. ZIP 下载)。请访问网站获取更多信息。","ui.package.abandoned":"放弃","ui.package.abandonedText":"该程序包已放弃不再维护。","ui.package.abandonedReplace":"该程序包已放弃不再维护。作者建议使用 {replacement} 包替代.","ui.package-details.previous":"以前的扩展详细信息","ui.package-details.close":"关闭扩展详情","ui.package-details.loading":"加载 …","ui.package-details.tabDescription":"描述","ui.package-details.tabRequire":"需求","ui.package-details.tabFeatures":"特征","ui.package-details.tabSuggest":"建议","ui.package-details.tabConflict":"冲突","ui.package-details.tabDependents":"依赖","ui.package-details.linkRequires":"需要","ui.package-details.linkReplaces":"替换","ui.package-details.linkProvides":"提供","ui.package-details.linkConflicts":"冲突","ui.package-details.funding":"Fund package maintenance!","ui.package-details.latest":"最新版","ui.package-details.released":"发布于","ui.package-details.license":"许可(s)","ui.package-details.authors":"from","ui.package-details.more":"更多","ui.package-details.packagist":"包详情","ui.package-details.metadata":"编辑元数据","ui.package-details.support_docs":"文档","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"支持论坛","ui.package-details.support_issues":"问题 / 错误 报告","ui.package-details.support_source":"源代码","ui.package-details.support_irc":"IRC / 聊天","ui.package-details.support_email":"支持 E-Mail","ui.package-details.support_rss":"RSS"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[769],{4769:function(i){i.exports=JSON.parse('{"ui.app.title":"Estensioni Contao","ui.app.loading":"Caricamento lista estensioni...","ui.discover.advertisement":"Pubblicità nell\'elenco delle estensioni","ui.discover.loading":"Caricamento in corso ...","ui.discover.offline":"Non è stato possibile ottenere alcun risultato.","ui.discover.offlineExplain":"Controlla la tua connessione internet e disabilita i blocchi JavaScript nel tuo browser.","ui.discover.offlineButton":"Riprova","ui.discover.searchPlaceholder":"Cerca in {conti} estensioni ...","ui.discover.empty":"Nessun risultato per {query}","ui.discover.more":"Ulteriori risultati","ui.discover.sortBy":"Ordina per","ui.discover.sortReleased":"Rilasciato","ui.discover.sortReleasedTitle":"Ordina i risultati per data di rilascio","ui.discover.sortLatest":"Aggiornamento eseguito","ui.discover.sortLatestTitle":"Ordina i risultati per ultimo aggiornamento","ui.discover.sortDownloads":"Downloads","ui.discover.sortDownloadsTitle":"Ordina i risultati per numero di download","ui.discover.sortFavers":"Valutazione","ui.discover.sortFaversTitle":"Ordina i risultati per valutazione","ui.discover.detailsButton":"Dettagli","ui.discover.latestPackages":"Estensioni più recenti e aggiornate","ui.discover.faversPackages":"Estensioni più votate","ui.discover.downloadsPackages":"Estensioni più scaricate","ui.package.homepage":"Sito web del progetto","ui.package.private":"Pacchetto privato","ui.package.privateTitle":"I pacchetti privati sono disponibili solo attraverso il fornitore (ad es. Come download ZIP). Per ulteriori informazioni, visitare il sito Web.","ui.package.abandoned":"dismesso","ui.package.abandonedText":"Questo pacchetto è abbandonato e non è più mantenuto.","ui.package.abandonedReplace":"Questo pacchetto è abbandonato e non è più mantenuto. L\'autore suggerisce di usare il pacchetto {sostituzione}.","ui.package-details.previous":"Dettagli estensione precedente","ui.package-details.close":"Chiudi dettagli estensione","ui.package-details.loading":"Caricamento in corso ...","ui.package-details.tabDescription":"Descrizione","ui.package-details.tabRequire":"Requisiti","ui.package-details.tabFeatures":"Caratteristiche","ui.package-details.tabSuggest":"Suggerimenti","ui.package-details.tabConflict":"Conflitti","ui.package-details.tabDependents":"Dipendenti","ui.package-details.linkRequires":"richiede","ui.package-details.linkReplaces":"sostituisce","ui.package-details.linkProvides":"fornisce","ui.package-details.linkConflicts":"Conflitti","ui.package-details.funding":"Manutenzione del pacchetto!","ui.package-details.latest":"Ultima versione","ui.package-details.released":"rilasciato il","ui.package-details.license":"Licenza","ui.package-details.authors":"da","ui.package-details.more":"Altro","ui.package-details.packagist":"Dettagli del pacchetto","ui.package-details.metadata":"Modifica metadati","ui.package-details.support_docs":"Documentazione","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Forum di supporto","ui.package-details.support_issues":"Problemi / Bug Report","ui.package-details.support_source":"Source Code","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"E-Mail di supporto","ui.package-details.support_rss":"Feed RSS"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[669],{9669:function(e){e.exports=JSON.parse('{"ui.app.title":"افزونه‌های کنتائو","ui.app.loading":"بارگذاری لیست افزونه...","ui.discover.advertisement":"Advertisement in the extension list","ui.discover.loading":"بارگذاری ...","ui.discover.offline":"Could not fetch any results.","ui.discover.offlineExplain":"Check your internet connection and disable JavaScript blockers in your browser.","ui.discover.offlineButton":"دوباره تلاش کنید","ui.discover.searchPlaceholder":"Search in {count} extensions …","ui.discover.empty":"هیچ نتیجه‌ای برای {query}","ui.discover.more":"نتایج بیشتر","ui.discover.sortBy":"مرتب‌سازی براساس","ui.discover.sortReleased":"Released","ui.discover.sortReleasedTitle":"Sort results by release date","ui.discover.sortLatest":"بروزرسانی شده","ui.discover.sortLatestTitle":"Sort results by last updated","ui.discover.sortDownloads":"دانلودها","ui.discover.sortDownloadsTitle":"Sort results by number of downloads","ui.discover.sortFavers":"امتیاز","ui.discover.sortFaversTitle":"Sort results by rating","ui.discover.detailsButton":"جزئیات","ui.discover.latestPackages":"Latest and updated extensions","ui.discover.faversPackages":"افزونه‌های با امتیاز بالا","ui.discover.downloadsPackages":"Most downloaded extensions","ui.package.homepage":"وب‌سایت پروژه","ui.package.private":"بسته اختصاصی","ui.package.privateTitle":"Private packages are only available from the vendor (e.g. as a ZIP download). Please visit the website for more information.","ui.package.abandoned":"منع شده","ui.package.abandonedText":"This package is abandoned and no longer maintained.","ui.package.abandonedReplace":"This package is abandoned and no longer maintained. The author suggests using the {replacement} package instead.","ui.package-details.previous":"جزئیات افزونه قبلی","ui.package-details.close":"بستن جزئیات افزونه","ui.package-details.loading":"بارگذاری ...","ui.package-details.tabDescription":"توضیح","ui.package-details.tabRequire":"نیازمندی‌ها","ui.package-details.tabFeatures":"ویژگی‌ها","ui.package-details.tabSuggest":"پیشنهادها","ui.package-details.tabConflict":"ناسازگاری‌ها","ui.package-details.tabDependents":"وابسته‌ها","ui.package-details.linkRequires":"نیاز دارد","ui.package-details.linkReplaces":"جایگزین می‌کند","ui.package-details.linkProvides":"فراهم می‌کند","ui.package-details.linkConflicts":"ناسازگار است","ui.package-details.funding":"Fund package maintenance!","ui.package-details.latest":"آخرین نسخه","ui.package-details.released":"منتشر شده در","ui.package-details.license":"مجوز(ها)","ui.package-details.authors":"از","ui.package-details.more":"بیشتر","ui.package-details.packagist":"جژئیات بسته","ui.package-details.metadata":"ویرایش فرداده","ui.package-details.support_docs":"مستندات","ui.package-details.support_wiki":"ویکی","ui.package-details.support_forum":"انجمن پشتیبانی","ui.package-details.support_issues":"مشکلات / گزارش باگ","ui.package-details.support_source":"کد منبع","ui.package-details.support_irc":"IRC / چت","ui.package-details.support_email":"ایمیل پشتیبانی","ui.package-details.support_rss":"خوراک RSS"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[194],{194:function(a){a.exports=JSON.parse('{"ui.app.title":"Contao paplašinājumi","ui.app.loading":"Ielādē paplašinājumu sarakstu ...","ui.discover.advertisement":"Reklāma paplašinājumu sarakstā","ui.discover.loading":"Ielādē ...","ui.discover.offline":"Nevarēja iegūt nekādus rezultātus.","ui.discover.offlineExplain":"Pārbaudiet savu interneta savienojumu un atspējojiet JavaScript bloķētājus savā pārlūkprogrammā.","ui.discover.offlineButton":"Mēģini vēlreiz","ui.discover.searchPlaceholder":"Meklēt {count} paplašinājumos ...","ui.discover.empty":"Nav rezultātu {query}","ui.discover.more":"Vairāk rezultātu","ui.discover.sortBy":"Kārtot pēc","ui.discover.sortReleased":"Released","ui.discover.sortReleasedTitle":"Sort results by release date","ui.discover.sortLatest":"Atjaunināts","ui.discover.sortLatestTitle":"Sort results by last updated","ui.discover.sortDownloads":"Lejupielādes","ui.discover.sortDownloadsTitle":"Sort results by number of downloads","ui.discover.sortFavers":"Vērtējums","ui.discover.sortFaversTitle":"Sort results by rating","ui.discover.detailsButton":"Sīkāka informācija","ui.discover.latestPackages":"Jaunākie un atjauninātie paplašinājumi","ui.discover.faversPackages":"Visaugstāk novērtētie paplašinājumi","ui.discover.downloadsPackages":"Visvairāk lejupielādētie paplašinājumi","ui.package.homepage":"Projekta mājaslapa","ui.package.private":"Privāta pakotne","ui.package.privateTitle":"Privātās pakotnes ir pieejamas tikai pie pārdevēja (piem., kā ZIP lejupielādes). Lūdzu, apmeklējiet vietni, lai iegūtu papildinformāciju.","ui.package.abandoned":"pamests","ui.package.abandonedText":"Šī pakotne ir pamesta un vairs netiek uzturēta.","ui.package.abandonedReplace":"Šī pakotne ir pamesta un vairs netiek uzturēta. Autors iesaka tās vietā izmantot pakotni {replacement}.","ui.package-details.previous":"Iepriekšējā paplašinājuma informācija","ui.package-details.close":"Aizvērt paplašinājuma informāciju","ui.package-details.loading":"Ielādē ...","ui.package-details.tabDescription":"Apraksts","ui.package-details.tabRequire":"Prasības","ui.package-details.tabFeatures":"Iespējas","ui.package-details.tabSuggest":"Ieteikumi","ui.package-details.tabConflict":"Konflikti","ui.package-details.tabDependents":"Atkarīgie","ui.package-details.linkRequires":"nepieciešams","ui.package-details.linkReplaces":"aizstāj","ui.package-details.linkProvides":"nodrošina","ui.package-details.linkConflicts":"konflikti","ui.package-details.funding":"Finansējiet paketes uzturēšanu!","ui.package-details.latest":"Jaunākā versija","ui.package-details.released":"izlaists","ui.package-details.license":"Licence(s)","ui.package-details.authors":"no","ui.package-details.more":"Vairāk","ui.package-details.packagist":"Pakotnes informācija","ui.package-details.metadata":"Rediģēt metadatus","ui.package-details.support_docs":"Dokumentācija","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Atbalsta forums","ui.package-details.support_issues":"Problēmas / Kļūdu ziņojums","ui.package-details.support_source":"Avota kods","ui.package-details.support_irc":"IRC / Tērzēšana","ui.package-details.support_email":"Atbalsta e-pasts","ui.package-details.support_rss":"RSS barotne"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[669],{9669:function(e){e.exports=JSON.parse('{"ui.app.title":"افزونه‌های کنتائو","ui.app.loading":"بارگذاری لیست افزونه...","ui.discover.advertisement":"Advertisement in the extension list","ui.discover.loading":"بارگذاری ...","ui.discover.offline":"Could not fetch any results.","ui.discover.offlineExplain":"Check your internet connection and disable JavaScript blockers in your browser.","ui.discover.offlineButton":"دوباره تلاش کنید","ui.discover.searchPlaceholder":"Search in {count} extensions …","ui.discover.empty":"هیچ نتیجه‌ای برای {query}","ui.discover.more":"نتایج بیشتر","ui.discover.sortBy":"مرتب‌سازی براساس","ui.discover.sortReleased":"Released","ui.discover.sortReleasedTitle":"Sort results by release date","ui.discover.sortLatest":"بروزرسانی شده","ui.discover.sortLatestTitle":"Sort results by last updated","ui.discover.sortDownloads":"دانلودها","ui.discover.sortDownloadsTitle":"Sort results by number of downloads","ui.discover.sortFavers":"امتیاز","ui.discover.sortFaversTitle":"Sort results by rating","ui.discover.detailsButton":"جزئیات","ui.discover.latestPackages":"Latest and updated extensions","ui.discover.faversPackages":"افزونه‌های با امتیاز بالا","ui.discover.downloadsPackages":"Most downloaded extensions","ui.package.homepage":"وب‌سایت پروژه","ui.package.private":"بسته اختصاصی","ui.package.privateTitle":"Private packages are only available from the vendor (e.g. as a ZIP download). Please visit the website for more information.","ui.package.abandoned":"منع شده","ui.package.abandonedText":"This package is abandoned and no longer maintained.","ui.package.abandonedReplace":"This package is abandoned and no longer maintained. The author suggests using the {replacement} package instead.","ui.package-details.previous":"جزئیات افزونه قبلی","ui.package-details.close":"بستن جزئیات افزونه","ui.package-details.loading":"بارگذاری ...","ui.package-details.tabDescription":"توضیح","ui.package-details.tabRequire":"نیازمندی‌ها","ui.package-details.tabFeatures":"ویژگی‌ها","ui.package-details.tabSuggest":"پیشنهادها","ui.package-details.tabConflict":"ناسازگاری‌ها","ui.package-details.tabDependents":"وابسته‌ها","ui.package-details.linkRequires":"نیاز دارد","ui.package-details.linkReplaces":"جایگزین می‌کند","ui.package-details.linkProvides":"فراهم می‌کند","ui.package-details.linkConflicts":"ناسازگار است","ui.package-details.funding":"Fund package maintenance!","ui.package-details.latest":"آخرین نسخه","ui.package-details.released":"منتشر شده در","ui.package-details.license":"مجوز(ها)","ui.package-details.authors":"از","ui.package-details.more":"بیشتر","ui.package-details.packagist":"جژئیات بسته","ui.package-details.metadata":"ویرایش فرداده","ui.package-details.support_docs":"مستندات","ui.package-details.support_wiki":"ویکی","ui.package-details.support_forum":"انجمن پشتیبانی","ui.package-details.support_issues":"مشکلات / گزارش باگ","ui.package-details.support_source":"کد منبع","ui.package-details.support_irc":"IRC / چت","ui.package-details.support_email":"ایمیل پشتیبانی","ui.package-details.support_rss":"خوراک RSS"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[28],{4028:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! 不安全连接 !!","ui.app.httpsDescription":"没有HTTPS情况下，机密数据将会未加密传输。","ui.app.httpsLink":"更多信息","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Safe Mode enabled !!","ui.app.safeModeDescription":"Some features of the Contao Manager are not available.","ui.app.safeModeExit":"Exit Safe Mode","ui.app.loading":"加载 Contao 管理器 …","ui.app.apiError":"意外的API状态","ui.app.configSecurity1":"安全警报 !!! 检测到未受保护的配置目录","ui.app.configSecurity2":"Contao管理器检测到其配置文件可以公开访问。目录受到保护之前会禁止所有操作，否则攻击者可以访问安装的敏感数据。\\n\\n为了修复这个问题，请确保阻止访问服务器上的\\"contao-manager\\"目录。要了解如何执行此操作，请参阅您的网络服务器手册或联系您的托管服务提供商。","ui.account.welcome":"欢迎","ui.account.intro1":"Welcome to the Contao Manager, a universal tool to install and manage Contao Open Source CMS. If you are new to it, please {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} to get started","ui.account.introManual":"read the manual","ui.account.intro2":"If you encounter any problems, check {ourGithubIssues} and feel free to create new one for anything that has not been reported yet.","ui.account.introIssues":"our GitHub issues","ui.account.headline":"用户账户","ui.account.description":"为了管理安装，请为Contao管理器创建一个账号。请注意该账号和Contao后台和前端没有关联。","ui.account.username":"用户名","ui.account.password":"密码","ui.account.passwordPlaceholder":"最少8个字符","ui.account.passwordLength":"请输入最少8个字符","ui.account.submit":"创建账号","ui.account.contribute1":"Contao and the Contao Manager are sponsored by the non-profit Contao Association.","ui.account.contribute2":"Please consider contributing to open source by {donate}.","ui.account.contributeDonate":"making a donation","ui.login.headline":"登录","ui.login.description":"登录来管理安装。","ui.login.username":"用户名","ui.login.password":"密码","ui.login.forgotPassword":"忘记密码","ui.login.button":"登录","ui.login.locked":"Access has been denied because the Contao Manager is locked. To unlock, delete the {lockFile} file in your Contao root directory.","ui.logout.headline":"会话超时","ui.logout.warning":"超过25分钟没有活动。安全原因您的会话将很快被终止。","ui.logout.expired":"由于超过30分钟没有活动，您的会话已自动终止。","ui.logout.renew":"保持登入","ui.logout.logout":"注销","ui.logout.login":"返回登录","ui.oauth.error":"无效的OAuth尝试。检查请求参数。","ui.oauth.https":"The redirect URI MUST use a secure protocol (https:) to prevent the authentication token from being transmitted in clear-text.","ui.oauth.headline":"Remote Authentication","ui.oauth.description":"以下应用程序或者服务正在请求对您的Contao Manager实例远程访问。","ui.oauth.domain":"Before allowing access, make sure you know this URL and trust its owner!","ui.oauth.allow":"允许访问","ui.oauth.deny":"拒绝访问","ui.boot.headline":"系统检查","ui.boot.description":"请稍等，正在分析您的服务器 …","ui.boot.issue1":"监测到安装问题","ui.boot.issue2":"Your installation has issues that have to be fixed before the Contao Manager can be used.","ui.boot.run":"运行Contao管理器","ui.boot.safeMode":"安全模式下运行","ui.recovery.headline":"系统恢复","ui.recovery.description":"The Contao Manager detected files that look like Contao, but the Command Line Interface does not work as expected.","ui.recovery.console":"Console Output","ui.recovery.repairOptions":"Please choose an option to repair your installation.","ui.recovery.repairHeadline":"自动修复","ui.recovery.repairDescription":"尝试通过重建应用缓存并重新安装Composer包来自动修复安装。","ui.recovery.repairWarning":"此过程可能会删除vendor中文件的任何修改!","ui.recovery.repairFailed":"自动修复没有成功。请尝试安全模式手动修复安装。","ui.recovery.repairButton":"运行系统修复","ui.recovery.safeModeHeadline":"安全模式","ui.recovery.safeModeDescription":"安全模式下运行Contao管理器允许管理包并运行某些维护任务，但依赖于正在运行的Contao安装的功能将不可用。","ui.recovery.safeModeButton":"安全模式下运行","ui.server.pending":"等待 …","ui.server.running":"分析中 …","ui.server.error":"由于服务器的意外响应，检查失败。","ui.server.details":"详情","ui.server.prerequisite":"由于缺少必要的条件，检查已取消。","ui.server.selfUpdate.title":"Contao管理器更新","ui.server.selfUpdate.update":"新的Contao管理器版本 {latest} .","ui.server.selfUpdate.manualUpdate":"新版本的Contao管理器 {latest} 可用。服务器不支持自动更新，请从{download}下载新版本。","ui.server.selfUpdate.latest":"正在使用最新版本 {current}。","ui.server.selfUpdate.dev":"开发版不支持自动更新。","ui.server.selfUpdate.unsupported":"有新版本，但您的PHP版本不支持。","ui.server.selfUpdate.button":"运行自更新","ui.server.selfUpdate.continue":"继续","ui.server.config.title":"服务器配置","ui.server.config.setup":"配置","ui.server.config.change":"更改","ui.server.config.save":"保存","ui.server.config.cancel":"取消","ui.server.config.customOption":"其他 …","ui.server.config.description":"To correctly run background tasks, the Contao Manager needs to know where to find the PHP command line binary and how to run commands separated from the web process.","ui.server.config.formTitle":"服务器配置","ui.server.config.formText":"请输入PHP二进制文件位置。确认二进制文件和服务器web进程是相同的PHP版本。","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud 允许安装Composer依赖即使服务器无法提供足够的内存。您的包信息将被传输到由Contao Association运营的云服务器。","ui.server.config.cloud":"使用Composer Resolver Cloud","ui.server.config.cli":"PHP二进制","ui.server.config.stateErrorCli":"服务器中没有发现有效的PHP二进制文件。","ui.server.config.stateErrorCloud":"不支持Composer Resolver Cloud。","ui.server.config.stateSuccess":"PHP 二进制文件在 {php_cli}.","ui.server.php_web.title":"PHP Web 进程","ui.server.php_web.below7":"发现 PHP 版本 {version}。请尽快切换到PHP 7!","ui.server.php_web.success":"发现PHP版本 {version}, 没有发现已知问题。","ui.server.php_cli.title":"PHP命令行接口","ui.server.php_cli.success":"发现PHP版本 {version}, 没有发现已知问题。","ui.server.composer.title":"Composer环境","ui.server.composer.success":"没有发现已知问题","ui.server.composer.install":"没有安装Composer依赖。","ui.server.composer.button":"Install","ui.server.contao.title":"Contao 安装","ui.server.contao.setup":"安装","ui.server.contao.check":"Check database","ui.server.contao.empty":"没有发现安装Contao。","ui.server.contao.old":"Contao版本 {version}不兼容Contao Manager，请手动更新当前安装的系统。","ui.server.contao.found":"发现Contao {version} (API 版本 {api}).","ui.server.contao.connectionError":"Unable to connect to the database server.","ui.server.contao.connectionProblem":"Database problem found.","ui.server.contao.missingUser":"Admin account not found.","ui.setup.continue":"继续","ui.setup.manager":"运行Contao管理器","ui.setup.cancel":"取消","ui.setup.welcome":"欢迎","ui.setup.welcome1":"This wizard will take you through the necessary steps to set up your Contao Open Source CMS installation.","ui.setup.welcome2":"If you have any questions, please find documentation, forums, a Slack channel and more on the {support} page.","ui.setup.support":"community support","ui.setup.start":"Get started","ui.setup.complete":"Congratulations!","ui.setup.complete1":"Contao {version} has been installed successfully.","ui.setup.complete2":"To finish the setup process, please open the install tool to configure the database connection and create a back end user.","ui.setup.complete3":"You can now start to create your website in the Contao back end. If you need additional extensions, continue to the Contao Manager.","ui.setup.installTool":"Open the Install Tool","ui.setup.login":"Login to Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". An Open Source project like Contao requires amounts of money that can\'t be raised by a single person or company.\\nIf you have a website or sell websites built with Contao, we would love to see you contribute back financially to the product your business relies upon.","ui.setup.fundingLink":"Learn more","ui.setup.document-root.headline":"Webserver Setup","ui.setup.document-root.warning":"To install Contao through the Contao Manager, you have to fix the document root on the web server.","ui.setup.document-root.description1":"Contao uses a separate folder for public files, application files are installed in its parent folder. Contao cannot be installed if the folder structure is not correct or the folders are not empty.","ui.setup.document-root.description2":"If you don\'t know how to configure your document root, please read the Contao documentation or contact your hosting provider.","ui.setup.document-root.documentation":"Read the Documentation","ui.setup.document-root.conflictsTitle":"Installation directory not empty","ui.setup.document-root.conflictsDirectory":"The root directory of your future Contao installation is not empty, we have found {count} file(s) that might be overwritten by the installation process. It is recommended to create an empty directory structure for Contao, but you can also remove the following files and check again if you are sure they are unused.","ui.setup.document-root.ignoreConflicts":"I want to install Contao into the non-empty directory. I understand that this might overwrite any existing files on my webspace.","ui.setup.document-root.check":"Check again","ui.setup.document-root.create":"Create directories","ui.setup.document-root.change":"Change directories","ui.setup.document-root.formTitle":"Directory Setup","ui.setup.document-root.formText1":"The Contao Manager can automatically create a new directory structure on the server.","ui.setup.document-root.formText2":"You will need to manually configure the new document root (e.g. through a hosting admin panel).","ui.setup.document-root.autoconfig":"I understand that I have to change my server configuration. Not configuring the document root will break the Contao Manager and expose configuration files (including account details and passwords)!","ui.setup.document-root.directory":"New Directory","ui.setup.document-root.currentRoot":"Current Document Root","ui.setup.document-root.newRoot":"New Document Root","ui.setup.document-root.finish":"Setup Directories","ui.setup.document-root.publicDir":"Use {dir} for public files (for Contao {version})","ui.setup.document-root.directoryInvalid":"Please enter a valid directory name.","ui.setup.document-root.directoryExists":"The target directory already exists. Please enter a different name.","ui.setup.document-root.confirmation":"The Contao Manager has successfully created the necessary directory for your Contao installation. You now have to configure the document root on your web server. Do not reload this page until then.","ui.setup.document-root.reload":"Reload Page","ui.setup.document-root.success":"The directory structure on your web server is set up correctly!","ui.setup.document-root.installingProjectDir":"Application files will be installed to {dir}.","ui.setup.document-root.installingPublicDir":"Public files will be installed to {dir}.","ui.setup.document-root.installedProjectDir":"Application files are installed in {dir}.","ui.setup.document-root.installedPublicDir":"Public files are installed in {dir}.","ui.setup.create-project.headline":"Contao 安装","ui.setup.create-project.description":"Contao development follows the principle of {semver}, a new minor version is released every six months. The currently supported releases are:","ui.setup.create-project.semver":"Semantic Versioning","ui.setup.create-project.latestTitle":"最新","ui.setup.create-project.ltsTitle":"长期支持","ui.setup.create-project.latestQ1":"Our latest version, offers the most features with support until February {year}.","ui.setup.create-project.latestQ3":"Our latest version, offers the most features with support until August {year}.","ui.setup.create-project.ltsText":"Our current LTS version, if you focus on stability. Offers long term support until February {year}.","ui.setup.create-project.pltsText":"The previous LTS version, still has long term support until February {year}.","ui.setup.create-project.requiresPHP":"Requires at least PHP {version}, you have PHP {current}.","ui.setup.create-project.requiresDocroot":"The document root must be \\"{folder}\\".","ui.setup.create-project.releaseplan":"See the {contaoReleasePlan} for detailed information.","ui.setup.create-project.releaseplanLink":"Contao Release Plan","ui.setup.create-project.formTitle":"Select a distribution","ui.setup.create-project.formText":"Please choose which version should be installed.","ui.setup.create-project.version":"版本","ui.setup.create-project.coreOnly":"初始化安装","ui.setup.create-project.coreOnlyNo":"全部安装 (新闻, 日历, 等.)","ui.setup.create-project.coreOnlyYes":"最小化安装 (仅核心)","ui.setup.create-project.coreOnlyFeatures":"What\'s the difference?","ui.setup.create-project.noUpdate":"跳过安装 (仅限专家!)","ui.setup.create-project.install":"Install","ui.setup.database-connection.headline":"Database Connection","ui.setup.database-connection.description":"Contao requires a MySQL database (or a compatible fork like MariaDB) to store pages, content, users and other relational data. Connection parameters are stored in the {env} file in the project root of your Contao installation.","ui.setup.database-connection.formTitle":"Connection Parameters","ui.setup.database-connection.formText":"Enter a database URL or fill in the username, password, server and database fields separately.","ui.setup.database-connection.url":"Database URL","ui.setup.database-connection.validUrl":"Database URL is invalid or connection to server failed.","ui.setup.database-connection.or":"or","ui.setup.database-connection.user":"用户名","ui.setup.database-connection.password":"密码","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Database Name","ui.setup.database-connection.serverVersion":"Server Version","ui.setup.database-connection.oldVersion":"Older MySQL or MariaDB","ui.setup.database-connection.connected":"Successfully connected to database {database} on {server} {version}.","ui.setup.database-connection.error":"Error connecting to the database.","ui.setup.database-connection.problem":"Contao has detected a problem with your database server.","ui.setup.database-connection.migration":"There is one pending migration. | There are {count} pending migrations.","ui.setup.database-connection.schema":"There is one pending schema update. | There are {count} pending schema updates.","ui.setup.database-connection.noChanges":"Your database schema is up to date.","ui.setup.database-connection.check":"Check database","ui.setup.database-connection.save":"保存","ui.setup.database-connection.change":"Change credentials","ui.setup.backend-user.success":"An admin account for the Contao back end was found in your database. Use the Contao back end to add more users.","ui.setup.backend-user.error":"Unable to retrieve user list. Check the console output for details.","ui.setup.backend-user.headline":"Backend Account","ui.setup.backend-user.description":"To manage your website, you need to have at least one admin account for the Contao back end. Be aware that this account is not related to the Contao Manager.","ui.setup.backend-user.formTitle":"创建账号","ui.setup.backend-user.formText":"Please enter the details for the new back end account.","ui.setup.backend-user.username":"用户名","ui.setup.backend-user.name":"Name","ui.setup.backend-user.email":"E-mail address","ui.setup.backend-user.emailInvalid":"Please enter a valid e-mail address","ui.setup.backend-user.password":"密码","ui.setup.backend-user.passwordPlaceholder":"最少8个字符","ui.setup.backend-user.passwordLength":"请输入最少8个字符","ui.setup.backend-user.create":"Add account","ui.task.headline":"Background Task","ui.task.loading":"Loading details …","ui.task.created":"Loading details …","ui.task.active":"Please wait while the Contao Manager is running task operations in the background.","ui.task.complete":"All operations are completed successfully. Check the console output for details.","ui.task.aborting":"Please wait while the background operations are being cancelled.","ui.task.stopped":"Some background operations were cancelled. Please check the console output.","ui.task.error":"A background operation stopped unexpectedly. Please check the console output.","ui.task.failed":"The Contao Manager failed to start a background task!","ui.task.failedDescription1":"Something went wrong while trying to execute operations in the background.","ui.task.failedDescription2":"If this happens again, your server might not be supported.","ui.task.reportProblem":"报告问题","ui.task.sponsor":"Composer Cloud sponsored by {sponsor}","ui.task.buttonAudit":"更新数据库","ui.task.buttonClose":"关闭","ui.task.buttonConfirm":"确认 & 关闭","ui.task.buttonCancel":"取消","ui.task.confirmCancel":"确认取消此任务? 将会使Contao安装处于损坏状态!","ui.task.autoclose":"Close task details on success","ui.console.toggle":"显示/隐藏命令行输出","ui.console.showLog":"Show full console log","ui.console.copyLog":"Copy log to clipboard","ui.migrate.headline":"Database Updates","ui.migrate.migrationsOnly":"(migrations only)","ui.migrate.schemaOnly":"(schema only)","ui.migrate.loading":"Please wait, we are checking your database …","ui.migrate.empty":"No pending migrations or schema updates found. Your database is up to date.","ui.migrate.emptyMigrations":"No pending migrations found. Make sure to also check for schema updates.","ui.migrate.emptySchema":"No pending schema updates found. Make sure to also check for migrations.","ui.migrate.pending":"Your database is not up to date. Please review the console output below and execute the changes.","ui.migrate.previousChanges":"A previous database migration was not confirmed.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.previousComplete":"A previous database migration was not confirmed, please review the console output below.\\nThere are no more pending changes.","ui.migrate.appliedChanges":"Database updates have been applied.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.appliedComplete":"Database updates have been applied.\\nThere are no more pending migrations or schema updates. Your database is up to date.","ui.migrate.problem":"Contao has detected a problem with your database server.\\nPlease review the console output below to find out what needs to be fixed. | Contao has detected problems with your database server.\\nPlease review the console output below to find out what needs to be fixed.","ui.migrate.warning":"Contao has detected a misconfiguration of your database server.\\nWarnings can be skipped temporarily, but should be fixed for optimal performance and data integrity.","ui.migrate.error":"The changes could not be applied. Your database might have been changed, please check again to retry.","ui.migrate.execute":"Execute","ui.migrate.close":"关闭","ui.migrate.confirm":"确认 & 关闭","ui.migrate.cancel":"取消","ui.migrate.continue":"继续","ui.migrate.setup":"安装","ui.migrate.skip":"Skip","ui.migrate.retry":"Check again","ui.migrate.retryAll":"Check all","ui.migrate.withDeletes":"Execute all database changes including DROP queries.","ui.migrate.migrationTitle":"Database Migrations","ui.migrate.schemaTitle":"Schema Updates","ui.migrate.problemTitle":"Database Problems","ui.migrate.warningTitle":"Database Warnings","ui.migrate.addTable":"Add table {table}","ui.migrate.dropTable":"Drop table {table}","ui.migrate.addField":"Add field {table}.{field}","ui.migrate.changeField":"Change field {table}.{field}","ui.migrate.dropField":"Drop field {table}.{field}","ui.migrate.createIndex":"Create index \\"{name}\\" on {table}","ui.migrate.dropIndex":"Drop index \\"{name}\\" on {table}","ui.widget.mandatory":"该字段不能为空。","ui.widget.blankOption":"请选择 …","ui.widget.showPassword":"Show password","ui.widget.hidePassword":"Hide password","ui.error.title":"HTTP request for \\"{method} {url}\\" failed.","ui.error.server500":"Looks like an unexpected error happened on your server. Please check the log files of your web server (Apache/Nginx) and the Contao Manager logs at \\"contao-manager/logs\\".","ui.error.response":"The server returned a response with status code {status}.","ui.error.moreLink":"更多信息","ui.error.support":"Contao Support","ui.footer.help":"帮助","ui.footer.reportProblem":"报告问题","ui.navigation.discover":"发现","ui.navigation.packages":"包","ui.navigation.tools":"工具","ui.navigation.installTool":"安装工具","ui.navigation.backend":"Contao 后台","ui.navigation.debug":"Contao调试模式","ui.navigation.logViewer":"Log Viewer","ui.navigation.phpinfo":"PHP信息","ui.navigation.phpinfoLoading":"Loading PHP Information…","ui.navigation.maintenance":"维护","ui.navigation.rebuildCache":"重建缓存","ui.navigation.systemCheck":"系统检查","ui.navigation.advanced":"高级","ui.navigation.logout":"注销","ui.maintenance.databaseMigration.title":"Database Migrations","ui.maintenance.databaseMigration.description":"Database migrations ensure consistent data and table schemas.","ui.maintenance.databaseMigration.migrations":"One pending database migration | {count} pending database migrations","ui.maintenance.databaseMigration.schemaUpdates":"One pending schema update | {count} pending schema updates","ui.maintenance.databaseMigration.error":"Database problem found.","ui.maintenance.databaseMigration.warning":"Database warnings found.","ui.maintenance.databaseMigration.button":"Check database","ui.maintenance.databaseMigration.migrationOnly":"Check migrations only","ui.maintenance.databaseMigration.schemaOnly":"Check schema only","ui.maintenance.databaseMigration.installTool":"Open Install Tool","ui.maintenance.rebuildCache.title":"应用缓存","ui.maintenance.rebuildCache.description":"修改任何配置文件后，必须重建应用程序缓存。","ui.maintenance.rebuildCache.rebuildProd":"重建生产环境缓存","ui.maintenance.rebuildCache.rebuildDev":"重建开发环境缓存","ui.maintenance.rebuildCache.clearProd":"清除生产环境缓存","ui.maintenance.rebuildCache.clearDev":"清除开发环境缓存","ui.maintenance.installTool.title":"Contao安装工具","ui.maintenance.installTool.description":"连续输入3次错误密码会自动锁定Contao安装工具。","ui.maintenance.installTool.unlock":"解锁安装工具","ui.maintenance.installTool.lock":"锁定安装工具","ui.maintenance.dumpAutoload.title":"Composer类加载器","ui.maintenance.dumpAutoload.description":"Composer的自动加载器负责PHP类加载。添加自定义命名空间到根下的composer.json后必须转储自动加载器。","ui.maintenance.dumpAutoload.button":"打印Autoloader","ui.maintenance.composerInstall.title":"Composer依赖","ui.maintenance.composerInstall.description":"Composer dependencies are located in the {vendor} folder in your application root. Reinstalling the dependencies can be necessary after manipulation or manually uploading the {composerLock} file.","ui.maintenance.composerInstall.button":"运行安装器","ui.maintenance.composerInstall.update":"运行Composer更新","ui.maintenance.composerCache.title":"Composer缓存","ui.maintenance.composerCache.description":"Composer缓存下载的软件包以提高性能。 如果您遇到文件损坏等问题，请尝试删除Composer缓存以强制进行新的下载。","ui.maintenance.composerCache.button":"清楚缓存","ui.maintenance.maintenanceMode.title":"Maintenance Mode","ui.maintenance.maintenanceMode.description":"Putting Contao in maintenance mode will display a \\"503 Service Unavailable\\" template for the website.","ui.maintenance.maintenanceMode.enable":"Enable","ui.maintenance.maintenanceMode.disable":"Disable","ui.maintenance.debugMode.title":"调试模式","ui.maintenance.debugMode.description":"Activate the debug mode by setting a user and password for the {appDevPhp} entry point.","ui.maintenance.debugMode.descriptionJwt":"通过对于当前域名设置调试cookie来激活调试模式。","ui.maintenance.debugMode.activate":"激活","ui.maintenance.debugMode.deactivate":"未激活","ui.maintenance.debugMode.credentials":"证书","ui.maintenance.debugMode.user":"请输入用于调试模式的用户名。","ui.maintenance.debugMode.password":"请输入用于调试模式的密码。","ui.maintenance.opcodeCache.title":"Opcode缓存","ui.maintenance.opcodeCache.description":"Opcode在Web进程上缓存PHP文件以加快执行速度。 如果文件在更改后无法识别，则在某些情况下必须将其删除。","ui.maintenance.opcodeCache.button":"清除缓存","ui.maintenance.safeMode":"安装模式下无效","ui.maintenance.unsupported":"您的Contao版本不支持","ui.packages.updateButton":"更新包","ui.packages.searchButton":"搜索包","ui.packages.searchPlaceholder":"搜索包","ui.packages.uploadOverlay":"拖拽文件上传","ui.packages.uploadButton":"上传包","ui.packages.uploadMessage":"You have one unconfirmed upload. | You have {count} unconfirmed uploads.","ui.packages.uploadApply":"确认上传","ui.packages.uploadReset":"删除上传","ui.packages.uploadIncomplete":"此文件未完全上传。 请将其删除，然后重试。","ui.packages.uploadDuplicate":"此文件似乎多次上传。 请删除重复项。","ui.packages.uploadInstalled":"此文件已安装。请移除重复项。","ui.packages.uploadUnsupported":"Uploads are not supported in your installation. Please make sure that the PHP ZIP extension is installed and update your dependencies.","ui.packages.changesMessage":"You have one unconfirmed change. | You have {count} unconfirmed changes.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"应用更改","ui.packages.changesApplyAll":"Update all packages","ui.packages.changesDryrunAll":"Dry run all packages","ui.packages.changesReset":"重置更改","ui.packages.changesReview":"预览更改","ui.packagelist.loading":"加载 …","ui.packagelist.uploads":"上传","ui.packagelist.added":"新包","ui.packagelist.installed":"已安装的包","ui.package.hintRevert":"恢复更改","ui.package.hintNoupdate":"不要更新","ui.package.hintConstraint":"应用更改时，此包将会带约束 {constraint} 安装。","ui.package.hintConstraintBest":"应用更改时，此包将会安装最佳版本。","ui.package.hintConstraintChange":"应用更改时，此包的约束将从\\"{from}\\"更改为\\"{to}\\"。","ui.package.hintConstraintUpdate":"应用更改后此包会被更新","ui.package.hintAdded":"应用更改后此包会被安装","ui.package.hintRemoved":"应用更改时，该程序包将被移除。","ui.package.requiredTitle":"手动添加","ui.package.requiredText":"composer.json中需要此包，但是没有安装","ui.package.removedTitle":"手动移除","ui.package.removedText":"此包已从composer.json移除。","ui.package.installed":"当前已安装:","ui.package.version":"版本 {version}","ui.package.additionalDownloads":"{count} Download | {count} Downloads","ui.package.additionalStars":"{count} Star | {count} Stars","ui.package.editConstraint":"编辑","ui.package.uploadConstraint":"此约束由上传的包定义。","ui.package.updateButton":"更新","ui.package.removeButton":"移除","ui.package.installButton":"添加包","ui.package.installButtonShort":"添加","ui.package.detailsButton":"详情","ui.package.latestConstraint":"最新版","ui.package.update":"Update available","ui.package.updateLatest":"最新版","ui.package.updateAvailable":"{version} available","ui.package.updateUnknown":"unknown version","ui.package.updateConstraint":"A newer version outside your version constraint is available.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"版本 {version}","ui.cloudStatus.waitingTime":"等待时间","ui.cloudStatus.jobs":"当前工作","ui.cloudStatus.workers":"工作者","ui.cloudStatus.approx":"{minutes} 分钟","ui.cloudStatus.none":"无","ui.cloudStatus.short":"ca. {minutes} 分钟","ui.cloudStatus.long":"ca. {minutes} 分钟 {seconds} 秒","ui.cloudStatus.error":"Unable to fetch the status of the Composer Resolver Cloud. It might be down for maintenance or experience issues.","ui.cloudStatus.button":"Cloud Status","ui.cloudStatus.refresh":"Refresh Cloud Status","ui.log-viewer.loading":"加载 …","ui.log-viewer.empty":"There are no log files on your server.","ui.log-viewer.reload":"Reload","ui.log-viewer.file":"Log file","ui.log-viewer.channel":"Channel","ui.log-viewer.channelTitle":"The channel this message was logged to.","ui.log-viewer.level":"Level","ui.log-viewer.levelTitle":"Severity of the log message.","ui.log-viewer.timeHeader":"Time","ui.log-viewer.messageHeader":"Message","ui.log-viewer.showContext":"Show Context","ui.log-viewer.hideContext":"Hide Context","ui.log-viewer.showExtra":"Show Extra","ui.log-viewer.hideExtra":"Hide Extra","ui.log-viewer.more":"Load more …","ui.log-viewer.download":"Download","ui.log-viewer.downloadTitle":"Download file \\"{file}\\"","ui.log-viewer.prodEnvironment":"Production Environment","ui.log-viewer.devEnvironment":"Development Environment (Debug Mode)"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[518],{2518:function(e){e.exports=JSON.parse('{"ui.app.title":"Contao Extensies","ui.app.loading":"Extensie Lijst laden …","ui.discover.advertisement":"Advertentie in de extensielijst","ui.discover.loading":"Bezig met laden ...","ui.discover.offline":"Kon geen resultaten ophalen.","ui.discover.offlineExplain":"Controleer uw internetverbinding en schakel JavaScript blokkers uit in uw browser.","ui.discover.offlineButton":"Probeer opnieuw","ui.discover.searchPlaceholder":"Zoeken in {count} extensies…","ui.discover.empty":"Geen resultaten voor {query}","ui.discover.more":"Meer resultaten","ui.discover.sortBy":"Sorteren op","ui.discover.sortReleased":"Uitgebracht","ui.discover.sortReleasedTitle":"Sorteer de resultaten op releasedatum","ui.discover.sortLatest":"Updated","ui.discover.sortLatestTitle":"Sorteer de resultaten op laatst bijgewerkt","ui.discover.sortDownloads":"Downloads","ui.discover.sortDownloadsTitle":"Sorteer resultaten op aantal downloads","ui.discover.sortFavers":"Beoordeling","ui.discover.sortFaversTitle":"Sorteer de resultaten op beoordeling","ui.discover.detailsButton":"Details","ui.discover.latestPackages":"Nieuwste en bijgewerkte extensies","ui.discover.faversPackages":"Best beoordeelde extensies","ui.discover.downloadsPackages":"Meest gedownloade extensies","ui.package.homepage":"Project Website","ui.package.private":"Privépakket","ui.package.privateTitle":"Privépakketten zijn alleen verkrijgbaar bij de leverancier (bijvoorbeeld als ZIP-download). Bezoek de website voor meer informatie.","ui.package.abandoned":"niet meer ondersteund","ui.package.abandonedText":"Dit pakket wordt niet langer ondersteund en onderhouden.","ui.package.abandonedReplace":"Dit pakket wordt niet langer ondersteund en onderhouden. De auteur stelt voor om in plaats daarvan het {vervangend} pakket te gebruiken.","ui.package-details.previous":"Vorige Extensie Details","ui.package-details.close":"Sluit Extensie Details","ui.package-details.loading":"Bezig met laden ...","ui.package-details.tabDescription":"Beschrijving","ui.package-details.tabRequire":"Vereisten","ui.package-details.tabFeatures":"Kenmerken","ui.package-details.tabSuggest":"Suggesties","ui.package-details.tabConflict":"Conflicten","ui.package-details.tabDependents":"Afhankelijkheden","ui.package-details.linkRequires":"vereist","ui.package-details.linkReplaces":"vervangt","ui.package-details.linkProvides":"biedt","ui.package-details.linkConflicts":"conflicten","ui.package-details.funding":"Fund package maintenance!","ui.package-details.latest":"Laatste versie","ui.package-details.released":"uitgebracht op","ui.package-details.license":"Licentie(s)","ui.package-details.authors":"van","ui.package-details.more":"Meer","ui.package-details.packagist":"Details bundel","ui.package-details.metadata":"Bewerk Metadata","ui.package-details.support_docs":"Documentatie","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Support Forum","ui.package-details.support_issues":"Problemen / Foutrapport","ui.package-details.support_source":"Broncode","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Support E-Mail","ui.package-details.support_rss":"RSS Feed"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[120],{8120:function(e){e.exports=JSON.parse('{"ui.app.title":"Extensions Contao","ui.app.loading":"Chargement de la liste des extensions…","ui.discover.advertisement":"Publicité dans la liste des extensions","ui.discover.loading":"Chargement…","ui.discover.offline":"Impossible de récupérer des résultats.","ui.discover.offlineExplain":"Vérifiez votre connexion Internet et désactivez les bloqueurs JavaScript dans votre navigateur.","ui.discover.offlineButton":"Réessayer","ui.discover.searchPlaceholder":"Search in {count} extensions …","ui.discover.empty":"Pas de résultats pour {query}","ui.discover.more":"Plus de résulats","ui.discover.sortBy":"Trier par","ui.discover.sortReleased":"Released","ui.discover.sortReleasedTitle":"Sort results by release date","ui.discover.sortLatest":"Mis à jour","ui.discover.sortLatestTitle":"Sort results by last updated","ui.discover.sortDownloads":"Téléchargements","ui.discover.sortDownloadsTitle":"Sort results by number of downloads","ui.discover.sortFavers":"Note","ui.discover.sortFaversTitle":"Sort results by rating","ui.discover.detailsButton":"Détails","ui.discover.latestPackages":"Extensions les plus récentes et mises à jour","ui.discover.faversPackages":"Extensions les mieux notées","ui.discover.downloadsPackages":"Extensions les plus téléchargées","ui.package.homepage":"Site web du projet","ui.package.private":"Package privé","ui.package.privateTitle":"Les packages privés ne sont disponibles que chez le fournisseur (par exemple sous forme de téléchargement ZIP). Veuillez visiter le site Web pour plus d\'informations","ui.package.abandoned":"abandonné","ui.package.abandonedText":"Ce package est abandonné et n\'est plus maintenu.","ui.package.abandonedReplace":"Ce package est abandonné et n\'est plus maintenu. L\'auteur suggère d\'utiliser le package {replacement} à la place.","ui.package-details.previous":"Extension précédente","ui.package-details.close":"Fermer les détails","ui.package-details.loading":"Chargement…","ui.package-details.tabDescription":"Description","ui.package-details.tabRequire":"Prérequis","ui.package-details.tabFeatures":"Fonctionnalités","ui.package-details.tabSuggest":"Suggestions","ui.package-details.tabConflict":"Conflits","ui.package-details.tabDependents":"Dépendants","ui.package-details.linkRequires":"nécessite","ui.package-details.linkReplaces":"remplaces","ui.package-details.linkProvides":"fournis","ui.package-details.linkConflicts":"conflits","ui.package-details.funding":"Fund package maintenance!","ui.package-details.latest":"Dernière version","ui.package-details.released":"Publié le","ui.package-details.license":"License(s)","ui.package-details.authors":"de","ui.package-details.more":"Plus","ui.package-details.packagist":"Détails du Package","ui.package-details.metadata":"Editer les Metadata","ui.package-details.support_docs":"Documentation","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Support","ui.package-details.support_issues":"Issues / Bug Report","ui.package-details.support_source":"Code source","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Support E-Mail","ui.package-details.support_rss":"RSS Feed"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[139],{4139:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! اتصال ناامن !!","ui.app.httpsDescription":"Without HTTPS your confidential data will be transferred unencrypted.","ui.app.httpsLink":"اطلاعات بیشتر","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.loading":"Loading Contao Manager …","ui.app.apiError":"وضعیت API غیرمنتظره","ui.app.configSecurity1":"SECURITY ALERT !!! Unprotected config directory detected","ui.app.configSecurity2":"The Contao Manager has detected that its config files are publicly accessible. All operations are disabled until the directory is secured, otherwise an attacker could access sensitive data of your installation.\\n\\nTo fix this issue, make sure to prevent access to the \\"contao-manager\\" directory on your server. To learn how to do this, please refer to the manual of your webserver or contact your hosting provider.","ui.account.welcome":"Welcome","ui.account.intro1":"Welcome to the Contao Manager, a universal tool to install and manage Contao Open Source CMS. If you are new to it, please {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} to get started","ui.account.introManual":"read the manual","ui.account.intro2":"If you encounter any problems, check {ourGithubIssues} and feel free to create new one for anything that has not been reported yet.","ui.account.introIssues":"our GitHub issues","ui.account.headline":"حساب کاربری","ui.account.description":"To manage your installation, please create an account for the Contao Manager. Be aware that this account is not related to the Contao back end or front end.","ui.account.username":"نام کاربری","ui.account.password":"گذرواژه","ui.account.passwordConfirm":"تایپ مجدد گذرواژه","ui.account.passwordPlaceholder":"حداقل ۸ نویسه","ui.account.passwortLength":"لطفا حداقل ۸ نویسه وارد نمایید.","ui.account.passwortDifferent":"The password does not match the confirmation.","ui.account.submit":"ایجاد حساب","ui.account.contribute1":"Contao and the Contao Manager are sponsored by the non-profit Contao Association.","ui.account.contribute2":"Please consider contributing to open source by {donate}.","ui.account.contributeDonate":"making a donation","ui.login.headline":"ورود","ui.login.description":"برای مدیریت نصب‌تان وارد شوید.","ui.login.username":"نام کاربری","ui.login.password":"گذرواژه","ui.login.forgotPassword":"گذرواژه‌ی خود را فراموش کرده‌اید؟","ui.login.button":"ورود","ui.login.locked":"Access has been denied because the Contao Manager is locked. To unlock, delete the {lockFile} file in your Contao root directory.","ui.logout.headline":"Session Timeout","ui.logout.warning":"Your have been inactive for more than 25 minutes. For security reasons your session will be terminated shortly.","ui.logout.expired":"Your session was automatically terminated because you have been inactive for more than 30 minutes.","ui.logout.renew":"Keep Logged In","ui.logout.logout":"خروج","ui.logout.login":"Back To Login","ui.oauth.error":"Invalid OAuth attempt. Check the request parameters.","ui.oauth.https":"The redirect URI MUST use a secure protocol (https:) to prevent the authentication token from being transmitted in clear-text.","ui.oauth.headline":"Remote Authentication","ui.oauth.description":"The following application or service is requesting remote access to your Contao Manager instance.","ui.oauth.domain":"Before allowing access, make sure you know this URL and trust its owner!","ui.oauth.allow":"Allow Access","ui.oauth.deny":"Deny Access","ui.boot.headline":"System Check","ui.boot.description":"Please wait, we are analyzing your server …","ui.boot.issue1":"Installation Issues Detected","ui.boot.issue2":"Your installation has issues that have to be fixed before the Contao Manager can be used.","ui.boot.run":"Launch Contao Manager","ui.recovery.headline":"System Recovery","ui.recovery.description":"The Contao Manager detected files that look like Contao, but the Command Line Interface does not work as expected.","ui.recovery.console":"Console Output","ui.recovery.repairOptions":"Please choose an option to repair your installation.","ui.recovery.repairHeadline":"Automatic Repair","ui.recovery.repairDescription":"Attempts to automatically repair the installation by rebuilding the application cache and re-installing the Composer packages.","ui.recovery.repairWarning":"Any modifications to the vendor files might be deleted in the process!","ui.recovery.repairFailed":"Automatic repair was not successful. Try the Safe Mode to manually repair the installation.","ui.recovery.repairButton":"Run System Repair","ui.recovery.safeModeHeadline":"Safe Mode","ui.recovery.safeModeDescription":"Launching the Contao Manager in Safe Mode allows to manage packages and run certain maintenance tasks, but features that rely on a working Contao installation will not be available.","ui.recovery.safeModeButton":"Launch in Safe Mode","ui.server.pending":"Waiting …","ui.server.running":"Analyzing …","ui.server.error":"Check failed due to an unexpected response from the server.","ui.server.details":"جزئیات","ui.server.prerequisite":"Check cancelled due to a missing prerequisite.","ui.server.selfUpdate.title":"Updates of Contao Manager","ui.server.selfUpdate.update":"A new Contao Manager version {latest} is available.","ui.server.selfUpdate.manualUpdate":"A new Contao Manager version {latest} is available. Your server does not support automatic updates, please download the new version from {download}.","ui.server.selfUpdate.latest":"You are using the latest version {current}.","ui.server.selfUpdate.dev":"Development builds do not support automatic updates.","ui.server.selfUpdate.unsupported":"A new version is available but it does not support your PHP version.","ui.server.selfUpdate.button":"Run Self-Update","ui.server.selfUpdate.continue":"Continue","ui.server.config.title":"Server Configuration","ui.server.config.setup":"Configure","ui.server.config.change":"Change","ui.server.config.save":"Save","ui.server.config.blankOption":"Please select …","ui.server.config.customOption":"Other …","ui.server.config.description":"To correctly run background tasks, the Contao Manager needs to know where to find the PHP command line binary and how to run commands separated from the web process.","ui.server.config.formTitle":"Server Configuration","ui.server.config.formText":"لطفا مسیر باینری PHP‌ تان را وارد نمایید. مطمئن شوید که باینری همان نسخه‌ی PHP روند وب‌تان باشد.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"The Composer Resolver Cloud allows to install Composer dependencies even if your server does not provide enough local memory. Please be aware that your package information will be transmitted to a cloud server operated by the Contao Association.","ui.server.config.cloud":"Use the Composer Resolver Cloud","ui.server.config.cli":"PHP Binary","ui.server.config.stateErrorCli":"No valid PHP binary was found on the server.","ui.server.config.stateErrorCloud":"The Composer Resolver Cloud is not supported.","ui.server.config.stateSuccess":"PHP binary at {php_cli}.","ui.server.php_web.title":"PHP Web Process","ui.server.php_web.below7":"Found PHP version {version}. Please switch to PHP 7 as soon as possible!","ui.server.php_web.success":"Found PHP version {version}, no known issues found.","ui.server.php_cli.title":"PHP Command Line Interface","ui.server.php_cli.success":"Found PHP version {version}, no known issues found.","ui.server.composer.title":"Composer Environment","ui.server.composer.success":"No known issues found.","ui.server.composer.install":"Composer dependencies are not installed.","ui.server.composer.button":"Run Composer","ui.server.composer.safeMode":"Run Safe Mode","ui.server.contao.title":"نصب کانتائو","ui.server.contao.setup":"Setup","ui.server.contao.empty":"No Contao installation has been found.","ui.server.contao.old":"Contao version {version} is not compatible with the Contao Manager, please update your installation manually.","ui.server.contao.found":"Found Contao {version} (API version {api}).","ui.server.contao.headline":"Contao Setup","ui.server.contao.description":"Welcome to the setup process of your Contao Open Source CMS. You can choose between two versions to install.","ui.server.contao.publicDir":"Use {dir} for public files (for Contao {version})","ui.server.contao.ltsTitle":"Long Term Support","ui.server.contao.ltsText":"The LTS version has an extended support period of up to four years.","ui.server.contao.latestTitle":"Latest","ui.server.contao.latestText":"A new latest version is released every six months in February and August.","ui.server.contao.noLatest":"Requires at least PHP {version}.","ui.server.contao.releaseplan":"See the {contaoReleasePlan} for detailed information.","ui.server.contao.releaseplanLink":"Contao Release Plan","ui.server.contao.formTitle":"نصب کانتائو","ui.server.contao.formText":"نسخه‌ی کانتائو برای نصب را انتخاب کنید.","ui.server.contao.version":"نسخه","ui.server.contao.coreOnly":"Initial Setup","ui.server.contao.coreOnlyNo":"Full Installation (News, Calendar, etc.)","ui.server.contao.coreOnlyYes":"Minimal Installation (Core only)","ui.server.contao.coreOnlyFeatures":"What\'s the difference?","ui.server.contao.noUpdate":"Skip Installation (Expert Only!)","ui.server.contao.install":"Finish","ui.server.docroot.headline":"Webserver Setup","ui.server.docroot.warning":"To install Contao through the Contao Manager, you have to fix the document root on the web server.","ui.server.docroot.description1":"Contao uses a separate folder for public files, application files are installed in its parent folder. Contao cannot be installed right now, because your folder structure is not correct or the folders are not empty.","ui.server.docroot.description2":"If you don\'t know how to configure your document root, please read the Contao documentation or contact your hosting provider.","ui.server.docroot.documentation":"Read the Documentation","ui.server.docroot.conflictsTitle":"Installation directory not empty","ui.server.docroot.conflictsDirectory":"The root directory of your future Contao installation is not empty, we have found {count} file(s) that might be overwritten by the installation process. It is recommended to create an empty directory structure for Contao, but you can also remove the following files and reload the page if you are sure they are unused.","ui.server.docroot.ignoreConflicts":"I want to install Contao into the non-empty directory. I understand that this might overwrite any existing files on my webspace.","ui.server.docroot.create":"Create directories","ui.server.docroot.formTitle":"Directory Setup","ui.server.docroot.formText1":"The Contao Manager can automatically create a new directory structure on the server.","ui.server.docroot.formText2":"You will need to manually configure the new document root (e.g. through a hosting admin panel).","ui.server.docroot.autoconfig":"I understand that I have to change my server configuration. Not configuring the document root will break the Contao Manager and expose configuration files (including account details and passwords)!","ui.server.docroot.directory":"New Directory","ui.server.docroot.currentRoot":"Current Document Root","ui.server.docroot.newRoot":"New Document Root","ui.server.docroot.finish":"Setup Directories","ui.server.docroot.directoryInvalid":"Please enter a valid directory name.","ui.server.docroot.directoryExists":"The target directory already exists. Please enter a different name.","ui.server.docroot.confirmation":"The Contao Manager has successfully created the necessary directory for your Contao installation. You now have to configure the document root on your web server. Do not reload this page until then.","ui.server.docroot.reload":"Reload Page","ui.task.headline":"Background Task","ui.task.loading":"Loading details …","ui.task.created":"Loading details …","ui.task.active":"Please wait while the Contao Manager is running task operations in the background.","ui.task.complete":"All operations are completed successfully. Check the console output for details.","ui.task.aborting":"Please wait while the background operations are being cancelled.","ui.task.stopped":"Some background operations were cancelled. Please check the console output.","ui.task.error":"A background operation stopped unexpectedly. Please check the console output.","ui.task.failed":"The Contao Manager failed to start a background task!","ui.task.failedDescription1":"Something went wrong while trying to execute operations in the background.","ui.task.failedDescription2":"If this happens again, your server might not be supported.","ui.task.reportProblem":"گزارش یک مشکل","ui.task.buttonAudit":"Update Database","ui.task.buttonClose":"بستن","ui.task.buttonConfirm":"تایید و بستن","ui.task.buttonCancel":"لغو","ui.task.confirmCancel":"Are you sure to cancel this task? This might leave your Contao installation in a broken state!","ui.task.autoclose":"Close task details on success","ui.console.toggle":"Show/Hide Console Output","ui.console.showLog":"Show full console log","ui.console.copyLog":"Copy log to clipboard","ui.widget.mandatory":"این فیلد نباید خالی باشد.","ui.error.title":"HTTP request for \\"{method} {url}\\" failed.","ui.error.server500":"Looks like an unexpected error happened on your server. Please check the log files of your web server (Apache/Nginx) and the Contao Manager logs at \\"contao-manager/logs\\".","ui.error.response":"The server returned a response with status code {status}.","ui.error.moreLink":"اطلاعات بیشتر","ui.error.support":"Contao Support","ui.footer.help":"کمک","ui.footer.reportProblem":"گزارش یک مشکل","ui.navigation.discover":"Discover","ui.navigation.packages":"بسته‌ها","ui.navigation.tools":"ابزارها","ui.navigation.installTool":"ابزار نصب","ui.navigation.backend":"Contao Backend","ui.navigation.debug":"Contao Debug Mode","ui.navigation.phpinfo":"PHP Information","ui.navigation.maintenance":"نگهداشت","ui.navigation.rebuildCache":"بازسازی نهان‌گاه","ui.navigation.systemCheck":"System Check","ui.navigation.advanced":"پیشرفته","ui.navigation.logout":"خروج","ui.maintenance.rebuildCache.title":"Application Cache","ui.maintenance.rebuildCache.description":"Rebuilding the application cache is required after modifying any of the configuration files.","ui.maintenance.rebuildCache.rebuildProd":"Rebuild Production Cache","ui.maintenance.rebuildCache.rebuildDev":"Rebuild Development Cache","ui.maintenance.rebuildCache.clearProd":"Clear Production Cache","ui.maintenance.rebuildCache.clearDev":"Clear Development Cache","ui.maintenance.installTool.title":"Contao Install Tool","ui.maintenance.installTool.description":"The Contao Install Tool is automatically locked if you enter a wrong password three times in a row.","ui.maintenance.installTool.unlock":"Unlock Install Tool","ui.maintenance.installTool.lock":"Lock Install Tool","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"The Composer autoloader is responsible for PHP class loading. The autoloader must be dumped after adding custom namespaces to the root composer.json.","ui.maintenance.dumpAutoload.button":"Dump Autoloader","ui.maintenance.composerInstall.title":"Composer Dependencies","ui.maintenance.composerInstall.description":"Composer dependencies are located in the {vendor} folder in your application root. Reinstalling the dependencies can be necessary after manipulation or manually uploading the {composerLock} file.","ui.maintenance.composerInstall.button":"Run Installer","ui.maintenance.composerInstall.update":"Run Composer Update","ui.maintenance.composerCache.title":"Composer Cache","ui.maintenance.composerCache.description":"Composer caches downloaded packages for improved performance. If you have issues like broken files, try to delete the Composer cache to force a new download.","ui.maintenance.composerCache.button":"Clear Cache","ui.maintenance.maintenanceMode.title":"Maintenance Mode","ui.maintenance.maintenanceMode.description":"Putting Contao in maintenance mode will display a \\"503 Service Unavailable\\" template for the website.","ui.maintenance.maintenanceMode.enable":"Enable","ui.maintenance.maintenanceMode.disable":"Disable","ui.maintenance.debugMode.title":"Debug Mode","ui.maintenance.debugMode.description":"Activate the debug mode by setting a user and password for the {appDevPhp} entry point.","ui.maintenance.debugMode.descriptionJwt":"Activate the debug mode by setting the debug cookie for the current domain.","ui.maintenance.debugMode.activate":"Activate","ui.maintenance.debugMode.deactivate":"Deactivate","ui.maintenance.debugMode.credentials":"Credentials","ui.maintenance.debugMode.user":"Please enter a username for the debug mode.","ui.maintenance.debugMode.password":"Please enter a password for the debug mode.","ui.maintenance.opcodeCache.title":"Opcode Cache","ui.maintenance.opcodeCache.description":"Opcode caches PHP files on the web process for faster execution. It must be deleted under certain circumstances if files are not recognized after changing.","ui.maintenance.opcodeCache.button":"Truncate Cache","ui.maintenance.safeMode":"Not available in Safe Mode","ui.maintenance.unsupported":"Not supported by your Contao version","ui.packages.updateButton":"بروزرسانی بسته‌ها","ui.packages.searchButton":"Search Packages","ui.packages.searchPlaceholder":"Search Packages …","ui.packages.uploadOverlay":"Drag & drop files to upload","ui.packages.uploadButton":"Upload Packages","ui.packages.uploadMessage":"You have one unconfirmed upload. | You have {count} unconfirmed uploads.","ui.packages.uploadApply":"Confirm Uploads","ui.packages.uploadReset":"Delete Uploads","ui.packages.uploadIncomplete":"This file was not uploaded completely. Please remove it and try again.","ui.packages.uploadDuplicate":"This file seems to be uploaded multiple times. Please remove the duplicates.","ui.packages.uploadInstalled":"This file is already installed. Please remove the duplicates.","ui.packages.uploadUnsupported":"Uploads are not supported in your installation. Please make sure to update your dependencies.","ui.packages.changesMessage":"You have one unconfirmed change. | You have {count} unconfirmed changes.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"Apply Changes","ui.packages.changesApplyAll":"Update all packages","ui.packages.changesDryrunAll":"Dry run all packages","ui.packages.changesReset":"Reset Changes","ui.packages.changesReview":"Review Changes","ui.packagelist.loading":"بارگذاری ...","ui.packagelist.uploads":"Uploads","ui.packagelist.added":"New packages","ui.packagelist.installed":"Installed packages","ui.package.hintRevert":"بازگرداندن تغییرات","ui.package.hintNoupdate":"Do not update","ui.package.hintConstraint":"این بسته با محدودیت بهترین {constraint} نصب خواهد شد وقتی شما تغییرات را اعمال کنید.","ui.package.hintConstraintBest":"این بسته در بهترین نسخه‌ی موجود نصب خواهد شد وقتی شما تغییرات را اعمال کنید.","ui.package.hintConstraintChange":"محدودیت برای این بسته از «{from}» به «{to}» وقتی شما تغییرات را اعمال کنید تغییر داده خواهد شد.","ui.package.hintConstraintUpdate":"This package will be updated when you apply the changes.","ui.package.hintAdded":"This package will be installed when you apply the changes.","ui.package.hintRemoved":"این بسته حذف خواهد وقتی شما تغییرات را اعمال کنید.","ui.package.requiredTitle":"manually added","ui.package.requiredText":"This package is required in your composer.json but not installed.","ui.package.removedTitle":"manually removed","ui.package.removedText":"This package was removed from your composer.json.","ui.package.installed":"Currently installed:","ui.package.version":"نسخه {version}","ui.package.additionalDownloads":"{count} Download | {count} Downloads","ui.package.additionalStars":"{count} Star | {count} Stars","ui.package.editConstraint":"ویرایش","ui.package.uploadConstraint":"This constraint is defined by the uploaded package.","ui.package.updateButton":"Update","ui.package.removeButton":"حذف","ui.package.installButton":"Add Package","ui.package.installButtonShort":"Add","ui.package.detailsButton":"جزئیات","ui.package.latestConstraint":"آخرین نسخه","ui.package.update":"Update available","ui.package.updateLatest":"آخرین نسخه","ui.package.updateAvailable":"{version} available","ui.package.updateUnknown":"unknown version","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"نسخه {version}","ui.cloudStatus.waitingTime":"Waiting Time","ui.cloudStatus.jobs":"Current Jobs","ui.cloudStatus.workers":"Workers","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"none","ui.cloudStatus.short":"ca. {minutes} min","ui.cloudStatus.long":"ca. {minutes} min {seconds} sec","ui.cloudStatus.error":"Unable to fetch the status of the Composer Resolver Cloud. It might be down for maintenance or experience issues.","ui.cloudStatus.button":"Cloud Status","ui.cloudStatus.refresh":"Refresh Cloud Status"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[486],{8486:function(e){e.exports=JSON.parse('{"ui.app.title":"Contao eklentileri","ui.app.loading":"Eklenti listesi yükleniyor…","ui.discover.advertisement":"Eklenti listesinde duyuru","ui.discover.loading":"Yükleniyor…","ui.discover.offline":"Herhangi bir sonuç alınamadı.","ui.discover.offlineExplain":"İnternet bağlantınızı denetleyin ve tarayıcınızdaki JavaScript engelleyicileri etkisizleştirin.","ui.discover.offlineButton":"Yeniden dene","ui.discover.searchPlaceholder":"{count} eklentide ara…","ui.discover.empty":"{query} ile eşleşen bir sonuç bulunamadı","ui.discover.more":"Diğer sonuçlar","ui.discover.sortBy":"Sıralama","ui.discover.sortReleased":"Yayınlandı","ui.discover.sortReleasedTitle":"Sonuçlar yayınlanma tarihine göre sıralansın","ui.discover.sortLatest":"Güncellendi","ui.discover.sortLatestTitle":"Sonuçlar güncellenme tarihine göre sıralansın","ui.discover.sortDownloads":"İndirmeler","ui.discover.sortDownloadsTitle":"Sonuçlar indirme sayılarına göre sıralansın","ui.discover.sortFavers":"Değerlendirme","ui.discover.sortFaversTitle":"Sonuçlar değerlendirmeye göre sıralansın","ui.discover.detailsButton":"Ayrıntılar","ui.discover.latestPackages":"Yeni ve güncellenmiş eklentiler","ui.discover.faversPackages":"İyi değerlendirilmiş eklentiler","ui.discover.downloadsPackages":"En çok indirilen eklentiler","ui.package.homepage":"Proje sitesi","ui.package.private":"Özel paket","ui.package.privateTitle":"Özel paketler yalnızca üretici tarafından sağlanabilir (ZIP indirmesi gibi). Ayrıntılı bilgi almak için siteye bakabilirsiniz.","ui.package.abandoned":"kullanımdan kaldırıldı","ui.package.abandonedText":"Bu paket kullanımdan kaldırıldı ve artık geliştirilmiyor.","ui.package.abandonedReplace":"Bu paket kullanımdan kaldırıldı ve artık geliştirilmiyor. Geliştirici bunun yerine  {replacement} paketinin kullanılmasını öneriyor.","ui.package-details.previous":"Önceki eklenti bilgileri","ui.package-details.close":"Eklenti bilgilerini kapat","ui.package-details.loading":"Yükleniyor…","ui.package-details.tabDescription":"Açıklama","ui.package-details.tabRequire":"Gereksinimler","ui.package-details.tabFeatures":"Özellikler","ui.package-details.tabSuggest":"Öneriler","ui.package-details.tabConflict":"Çakışmalar","ui.package-details.tabDependents":"Bağımlılar","ui.package-details.linkRequires":"gereksinimi","ui.package-details.linkReplaces":"değişikliği","ui.package-details.linkProvides":"sundukları","ui.package-details.linkConflicts":"çakışması","ui.package-details.funding":"Paketin geliştirilmesine destek olun!","ui.package-details.latest":"Son sürüm","ui.package-details.released":"yayınlanma tarihi","ui.package-details.license":"Lisanslar","ui.package-details.authors":"geliştiren","ui.package-details.more":"Ayrıntılar","ui.package-details.packagist":"Paket bilgileri","ui.package-details.metadata":"Üst verileri düzenle","ui.package-details.support_docs":"Belgeler","ui.package-details.support_wiki":"Viki","ui.package-details.support_forum":"Destek forumu","ui.package-details.support_issues":"Sorunlar / Hata bildirimi","ui.package-details.support_source":"Kaynak kodu","ui.package-details.support_irc":"IRC / Sohbet","ui.package-details.support_email":"Destek e-postası","ui.package-details.support_rss":"RSS akışı"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[638],{3638:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Niebezpieczne połączenie !!","ui.app.httpsDescription":"Bez HTTPS twoje poufne dane będą wysyłane bez szyfrowania.","ui.app.httpsLink":"Więcej informacji","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Bezpieczny Tryb włączony !!","ui.app.safeModeDescription":"Niektóre funkcje Contao Manager nie są dostępne.","ui.app.safeModeExit":"Wyłącz Bezpieczny Tryb","ui.app.loading":"Ładowanie Contao Manager …","ui.app.apiError":"Nieoczekiwany status API","ui.app.configSecurity1":"ALERT BEZPIECZEŃSTWA !!! Wykryto niezabezpieczony folder konfiguracji","ui.app.configSecurity2":"Contao Manager wykrył, że pliki konfiguracji są dostępne publicznie. Wszystkie operacje zostały zablokowane do czasu, aż folder zostanie zabezpieczony. W przeciwnym wypadku atakujący mógłby uzyskać dostęp do wrażliwych danych twojej instalacji.\\n\\nAby naprawić ten problem, zabezpiecz dostęp do katalogu \\"contao-manager\\" na serwerze. Jeśli nie wiesz jak to zrobić, odwołaj się dokumentacji twojego serwera lub skontaktuj z dostawcą usług.","ui.account.welcome":"Witaj","ui.account.intro1":"Witaj w Contao Manager, uniwersalnym narzędziu do instalacji i zarządzania Contao Open Source CMS. Jeśli jesteś tu nowy, proszę {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual}, żeby zacząć","ui.account.introManual":"przeczytaj instrukcję","ui.account.intro2":"Jeśli masz jakiekolwiek problemy, sprawdź {ourGithubIssues} i utwórz nowe zgłoszenie na dowolny temat, który nie był jeszcze raportowany.","ui.account.introIssues":"naszą listę problemów na GitHub","ui.account.headline":"Konto użytkownika","ui.account.description":"Aby zarządzać twoją instalacją, utwórz konto w Contao Manager. Uwaga – to konto nie jest powiązane z kontem w backendzie ani frontendzie Contao!","ui.account.username":"Nazwa użytkownika","ui.account.password":"Hasło","ui.account.passwordPlaceholder":"min 8 znaków","ui.account.passwordLength":"Wprowadź przynajmniej 8 znaków.","ui.account.submit":"Utwórz konto","ui.account.contribute1":"Contao i Contao Manager są sponsorowane przez charytatywną organizację Contao Association.","ui.account.contribute2":"Rozważ uczestnictwo w projektach open source poprzez {donate}.","ui.account.contributeDonate":"przekazanie darowizny","ui.login.headline":"Zaloguj się","ui.login.description":"Zaloguj się, aby zarządzać instalacją.","ui.login.username":"Nazwa użytkownika","ui.login.password":"Hasło","ui.login.forgotPassword":"Zapomniałeś hasła?","ui.login.button":"Zaloguj się","ui.login.locked":"Odmówiono dostępu, ponieważ Contao Manager jest zablokowany. Aby odblokować, usuń plik {lockFile} w folderze głównym instalacji Contao.","ui.logout.headline":"Limit czasu sesji","ui.logout.warning":"Byłeś nieaktywny przez więcej niż 25 minut. Z powodu bezpieczeństwa twoja sesja zostanie wkrótce zakończona.","ui.logout.expired":"Twoja sesja została zakończona, ponieważ byłeś nieaktywny przez więcej niż 30 minut.","ui.logout.renew":"Nie wylogowuj się","ui.logout.logout":"Wyloguj","ui.logout.login":"Powrót do logowania","ui.oauth.error":"Nieudana próba OAuth. Sprawdź parametry żądania.","ui.oauth.https":"URI przekierowania MUSI używać bezpiecznego protokołu (https:), aby nie przesyłać tokena poświadczenia otwartym tekstem.","ui.oauth.headline":"Zdalne Poświadczenie","ui.oauth.description":"Następująca aplikacja lub usługa żąda zdalnego dostępu do twojej instancji Contao Manager.","ui.oauth.domain":"Zanim zezwolisz na dostęp, upewnij się, że znasz ten adres URL i ufasz jego właścicielowi!","ui.oauth.allow":"Zezwól na dostęp","ui.oauth.deny":"Odmów dostępu","ui.boot.headline":"Sprawdzenie Systemu","ui.boot.description":"Proszę czekać, analizujemy twój serwer …","ui.boot.issue1":"Wykryto nieprawidłowości instalacji","ui.boot.issue2":"Twoja instalacja zawiera błędy, które muszą być rozwiązane, zanim zaczniesz używać Contao Manager.","ui.boot.run":"Otwórz Contao Manager","ui.boot.safeMode":"Uruchom w Bezpiecznym Trybie","ui.recovery.headline":"Odzyskiwanie Systemu","ui.recovery.description":"Contao Manager wykrył pliki, które wyglądają jak z Contao, ale interfejs linii komend (CLI) nie działa tak jak powinien.","ui.recovery.console":"Wyjście Konsolie","ui.recovery.repairOptions":"Wybierz opcję naprawy twojej instalacji.","ui.recovery.repairHeadline":"Automatyczna Naprawa","ui.recovery.repairDescription":"Próba automatycznego naprawienia instalacji poprzez przebudowanie pamięci cache aplikacji i ponownej instalacji pakietów Composera.","ui.recovery.repairWarning":"Jakakolwiek modyfikacja plików vendor może zostać skasowana podczas tego procesu!","ui.recovery.repairFailed":"Automatyczna naprawa nie zakończyła się sukcesem. Spróbuj Bezpiecznego Trybu w celu naprawy instalacji.","ui.recovery.repairButton":"Uruchom naprawę systemu","ui.recovery.safeModeHeadline":"Bezpieczny Tryb","ui.recovery.safeModeDescription":"Uruchamianie Contao Managera w Bezpiecznym Trybie pozwala na zarządzanie pakietami i wykonywanie określonych czynności konserwacyjnych, ale funkcje, które wymagają działającego Contao będą niedostępne.","ui.recovery.safeModeButton":"Uruchom w Bezpiecznym Trybie","ui.server.pending":"Czekam …","ui.server.running":"Analizuję …","ui.server.error":"Sprawdzenie nie powiodło się z powodu niespodziewanej odpowiedzi serwera.","ui.server.details":"Szczegóły","ui.server.prerequisite":"Sprawdzenie anulowane z powodu brakującego warunku wstępnego.","ui.server.selfUpdate.title":"Aktualizacje Contao Managera","ui.server.selfUpdate.update":"Nowa wersja Contao Managera {latest} jest dostępna.","ui.server.selfUpdate.manualUpdate":"Nowa wersja Contao Managera {latest} jest dostępna. Twój serwer nie wspiera automatycznych aktualizacji, nową wersję możesz pobrać z {download}.","ui.server.selfUpdate.latest":"Używasz najnowszej wersji {current}.","ui.server.selfUpdate.dev":"Buildy deweloperskie nie wspierają automatycznych aktualizacji.","ui.server.selfUpdate.unsupported":"Nowa wersja jest dostępna, ale nie wspiera ona twojej wersji PHP.","ui.server.selfUpdate.button":"Uruchom Aktualizację","ui.server.selfUpdate.continue":"Kontynuuj","ui.server.config.title":"Konfiguracja Serwera","ui.server.config.setup":"Konfiguruj","ui.server.config.change":"Zmień","ui.server.config.save":"Zapisz","ui.server.config.cancel":"Anuluj","ui.server.config.customOption":"Inne …","ui.server.config.description":"Aby zadania w tle poprawnie działały, Contao Manager musi wiedzieć, gdzie znaleźć wykonywalny plik PHP linii komend i jak uruchamiać działania niezależnie od procesów serwera www.","ui.server.config.formTitle":"Konfiguracja Serwera","ui.server.config.formText":"Wprowadź ścieżkę do PHP binary. Upewnij się, że wersja PHP binary jest taka sama jak w procesie web.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud pozwala na instalowanie pakietów Composera nawet jeśli twój serwer nie posiada wystarczającej ilości pamięci. Informacja o twoich pakietach będzie przesłana na serwer operowany przez Contao Association.","ui.server.config.cloud":"Użyj Composer Resolver Cloud","ui.server.config.cli":"Plik binarny PHP","ui.server.config.stateErrorCli":"Nie znaleziono poprawnego pliku binarnego PHP na serwerze.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud jest niewspierany.","ui.server.config.stateSuccess":"Plik binarny PHP pod {php_cli}.","ui.server.php_web.title":"PHP Web Process","ui.server.php_web.below7":"Znaleziono wersję PHP {version}. Zaktualizuj ją do PHP 7 tak szybko, jak to możliwe!","ui.server.php_web.success":"Znaleziono wersję PHP {version}, brak nieprawidłowości.","ui.server.php_cli.title":"PHP Command Line Interface","ui.server.php_cli.success":"Znaleziono wersję PHP {version}, brak nieprawidłowości.","ui.server.composer.title":"Środowisko Composera","ui.server.composer.success":"Brak nieprawidłowości.","ui.server.composer.install":"Pakiety Composera nie są zainstalowane.","ui.server.composer.button":"Instalacja","ui.server.contao.title":"Instalacja Contao","ui.server.contao.setup":"Instalacja","ui.server.contao.check":"Sprawdź bazę danych","ui.server.contao.empty":"Nie znaleziono instalacji Contao.","ui.server.contao.old":"Wersja Contao {version} jest niekompatybilna z Contao Manager, aktualizuj swoją instalację ręcznie.","ui.server.contao.found":"Znaleziono Contao {version} (wersja API {api}).","ui.server.contao.connectionError":"Brak połączenia z serwerem bazy danych.","ui.server.contao.connectionProblem":"Problem z bazą danych został znaleziony.","ui.server.contao.missingUser":"Nie znaleziono konta administratora.","ui.setup.continue":"Kontynuuj","ui.setup.manager":"Otwórz Contao Manager","ui.setup.cancel":"Anuluj","ui.setup.welcome":"Witaj","ui.setup.welcome1":"Ten kreator przeprowadzi Cię przez niezbędne kroki, aby skonfigurować instalację Contao Open Source CMS.","ui.setup.welcome2":"Jeśli masz jakieś pytania, odwiedź dokumentację, fora, kanał Slack i więcej na stronie {support}.","ui.setup.support":"wsparcie społeczności","ui.setup.start":"Rozpocznij","ui.setup.complete":"Gratulacje!","ui.setup.complete1":"Contao {version} zostało zainstalowane pomyślnie.","ui.setup.complete2":"Aby zakończyć proces konfiguracji, otwórz narzędzie instalacyjne, aby skonfigurować połączenie z bazą danych i utworzyć użytkownika.","ui.setup.complete3":"Możesz teraz rozpocząć tworzenie swojej strony internetowej w Contao. Jeśli potrzebujesz dodatkowych rozszerzeń, przejdź dalej do Contao Manager.","ui.setup.installTool":"Otwórz instalator","ui.setup.login":"Zaloguj się do Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". An Open Source project like Contao requires amounts of money that can\'t be raised by a single person or company.\\nIf you have a website or sell websites built with Contao, we would love to see you contribute back financially to the product your business relies upon.","ui.setup.fundingLink":"Dowiedz się więcej","ui.setup.document-root.headline":"Konfiguracja serwera www","ui.setup.document-root.warning":"Aby zainstalować Contao przez Contao Manager, musisz poprawić ustawienie katalogu głównego - document root - w konfiguracji serwera www.","ui.setup.document-root.description1":"Contao używa osobnego folderu dla plików publicznych, a pliki aplikacji są instalowane w folderze nadrzędnym. Contao nie może być zainstalowany, jeśli struktura folderów nie jest poprawna lub foldery nie są puste.","ui.setup.document-root.description2":"Jeśli wiesz, jak skonfigurować katalog główny - document root, zapoznaj się z dokumentacją Contao lub skontaktuj się z administratorem serwera.","ui.setup.document-root.documentation":"Przeczytaj Dokumentację","ui.setup.document-root.conflictsTitle":"Katalog instalacyjny nie jest pusty","ui.setup.document-root.conflictsDirectory":"Katalog główny Twojej przyszłej instalacji Contao nie jest pusty, znaleźliśmy {count} plik(i), które mogą zostać nadpisane przez proces instalacji. Zaleca się utworzenie pustej struktury katalogów dla Contao, ale możesz również usunąć następujące pliki i sprawdzić ponownie, jeśli jesteś pewien, że są one nieużywane.","ui.setup.document-root.ignoreConflicts":"Chcę zainstalować Contao w katalogu, który nie jest pusty. Rozumiem, że może to spowodować nadpisanie wszelkich istniejących plików na mojej przestrzeni dyskowej.","ui.setup.document-root.check":"Sprawdź ponownie","ui.setup.document-root.create":"Utwórz katalogi","ui.setup.document-root.change":"Zmień katalogi","ui.setup.document-root.formTitle":"Konfiguracja Katalogu","ui.setup.document-root.formText1":"Contao Manager może automatycznie utworzyć nową strukturę katal