/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ide;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.taskdefs.optional.ide.VAJAntTool;
import org.apache.tools.ant.taskdefs.optional.ide.VAJBuildInfo;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.ant.util.StringUtils;

public class VAJAntToolGUI
extends Frame {
    private VAJBuildLogger logger = new VAJBuildLogger();
    private static final String lineSeparator = "\r\n";
    private PrivateEventHandler iEventHandler = new PrivateEventHandler();
    private VAJBuildInfo iBuildInfo = null;
    private MenuBar iAntMakeMenuBar = null;
    private Menu iFileMenu = null;
    private MenuItem iSaveMenuItem = null;
    private MenuItem iMenuSeparator = null;
    private MenuItem iShowLogMenuItem = null;
    private Menu iHelpMenu = null;
    private MenuItem iAboutMenuItem = null;
    private Panel iContentsPane = null;
    private Panel iOptionenPanel = null;
    private Panel iCommandButtonPanel = null;
    private FlowLayout iCommandButtonPanelFlowLayout = null;
    private Label iProjectLabel = null;
    private Label iProjectText = null;
    private Label iBuildFileLabel = null;
    private TextField iBuildFileTextField = null;
    private boolean iConnPtoP2Aligning = false;
    private Button iBrowseButton = null;
    private FileDialog iFileDialog = null;
    private Choice iMessageOutputLevelChoice = null;
    private Label iMessageOutputLevelLabel = null;
    private Label iTargetLabel = null;
    private List iTargetList = null;
    private Button iBuildButton = null;
    private Button iReloadButton = null;
    private Button iCloseButton = null;
    private Frame iMessageFrame = null;
    private Panel iMessageCommandPanel = null;
    private Panel iMessageContentPanel = null;
    private TextArea iMessageTextArea = null;
    private Button iMessageOkButton = null;
    private Button iMessageClearLogButton = null;
    private Dialog iAboutDialog = null;
    private Panel iAboutDialogContentPanel = null;
    private Panel iAboutInfoPanel = null;
    private Panel iAboutCommandPanel = null;
    private Label iAboutTitleLabel = null;
    private Label iAboutDevLabel = null;
    private Label iAboutContactLabel = null;
    private Button iAboutOkButton = null;
    private Button iStopButton = null;

    private VAJAntToolGUI() {
        this.initialize();
    }

    public VAJAntToolGUI(VAJBuildInfo newBuildInfo) {
        this.setBuildInfo(newBuildInfo);
        this.initialize();
    }

    public static void centerDialog(Dialog dialog) {
        ((Component)dialog).setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - dialog.getSize().width / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - dialog.getSize().height / 2);
    }

    private void connectBuildFileNameToTextField() {
        try {
            if (!this.iConnPtoP2Aligning) {
                this.iConnPtoP2Aligning = true;
                if (this.getBuildInfo() != null) {
                    this.getBuildFileTextField().setText(this.getBuildInfo().getBuildFileName());
                }
                this.iConnPtoP2Aligning = false;
            }
        }
        catch (Throwable iExc) {
            this.iConnPtoP2Aligning = false;
            this.handleException(iExc);
        }
    }

    private void connectProjectNameToLabel() {
        try {
            if (this.getBuildInfo() != null) {
                this.getProjectText().setText(this.getBuildInfo().getVAJProjectName());
            }
        }
        catch (Throwable iExc) {
            this.handleException(iExc);
        }
    }

    private void connectTextFieldToBuildFileName() {
        try {
            if (!this.iConnPtoP2Aligning) {
                this.iConnPtoP2Aligning = true;
                if (this.getBuildInfo() != null) {
                    this.getBuildInfo().setBuildFileName(this.getBuildFileTextField().getText());
                }
                this.iConnPtoP2Aligning = false;
            }
        }
        catch (Throwable iExc) {
            this.iConnPtoP2Aligning = false;
            this.handleException(iExc);
        }
    }

    private void executeTarget() {
        try {
            this.getMessageFrame().show();
            this.getBuildInfo().executeProject(this.logger);
        }
        catch (Throwable exc) {
            this.logger.logException(exc);
        }
    }

    private void fillList() {
        this.getTargetList().removeAll();
        Vector targets = this.getBuildInfo().getProjectTargets();
        for (int i = 0; i < targets.size(); ++i) {
            this.getTargetList().add(targets.elementAt(i).toString());
        }
        this.getTargetList().select(this.iBuildInfo.getProjectTargets().indexOf(this.iBuildInfo.getTarget()));
        if (this.getTargetList().getSelectedIndex() >= 0) {
            this.getBuildButton().setEnabled(true);
        }
    }

    private Panel getAboutCommandPanel() {
        if (this.iAboutCommandPanel == null) {
            try {
                this.iAboutCommandPanel = new Panel();
                this.iAboutCommandPanel.setName("AboutCommandPanel");
                this.iAboutCommandPanel.setLayout(new FlowLayout());
                this.getAboutCommandPanel().add((Component)this.getAboutOkButton(), this.getAboutOkButton().getName());
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iAboutCommandPanel;
    }

    private Label getAboutContactLabel() {
        if (this.iAboutContactLabel == null) {
            try {
                this.iAboutContactLabel = new Label();
                this.iAboutContactLabel.setName("AboutContactLabel");
                this.iAboutContactLabel.setAlignment(1);
                this.iAboutContactLabel.setText("contact: wolf.siberski@tui.de or christoph.wilhelms@tui.de");
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iAboutContactLabel;
    }

    private Label getAboutDevLabel() {
        if (this.iAboutDevLabel == null) {
            try {
                this.iAboutDevLabel = new Label();
                this.iAboutDevLabel.setName("AboutDevLabel");
                this.iAboutDevLabel.setAlignment(1);
                this.iAboutDevLabel.setText("developed by Wolf Siberski & Christoph Wilhelms");
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iAboutDevLabel;
    }

    private Dialog getAboutDialog() {
        if (this.iAboutDialog == null) {
            try {
                this.iAboutDialog = new Dialog(this);
                this.iAboutDialog.setName("AboutDialog");
                this.iAboutDialog.setResizable(false);
                this.iAboutDialog.setLayout(new BorderLayout());
                ((Component)this.iAboutDialog).setBounds(550, 14, 383, 142);
                this.iAboutDialog.setModal(true);
                this.iAboutDialog.setTitle("About...");
                this.getAboutDialog().add((Component)this.getAboutDialogContentPanel(), "Center");
                this.iAboutDialog.pack();
                VAJAntToolGUI.centerDialog(this.iAboutDialog);
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iAboutDialog;
    }

    private Panel getAboutDialogContentPanel() {
        if (this.iAboutDialogContentPanel == null) {
            try {
                this.iAboutDialogContentPanel = new Panel();
                this.iAboutDialogContentPanel.setName("AboutDialogContentPanel");
                this.iAboutDialogContentPanel.setLayout(new BorderLayout());
                this.getAboutDialogContentPanel().add((Component)this.getAboutCommandPanel(), "South");
                this.getAboutDialogContentPanel().add((Component)this.getAboutInfoPanel(), "Center");
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iAboutDialogContentPanel;
    }

    private Panel getAboutInfoPanel() {
        if (this.iAboutInfoPanel == null) {
            try {
                this.iAboutInfoPanel = new Panel();
                this.iAboutInfoPanel.setName("AboutInfoPanel");
                this.iAboutInfoPanel.setLayout(new GridBagLayout());
                GridBagConstraints constraintsAboutTitleLabel = new GridBagConstraints();
                constraintsAboutTitleLabel.gridx = 0;
                constraintsAboutTitleLabel.gridy = 0;
                constraintsAboutTitleLabel.fill = 2;
                constraintsAboutTitleLabel.weightx = 1.0;
                constraintsAboutTitleLabel.weighty = 1.0;
                constraintsAboutTitleLabel.insets = new Insets(4, 0, 4, 0);
                this.getAboutInfoPanel().add((Component)this.getAboutTitleLabel(), constraintsAboutTitleLabel);
                GridBagConstraints constraintsAboutDevLabel = new GridBagConstraints();
                constraintsAboutDevLabel.gridx = 0;
                constraintsAboutDevLabel.gridy = 1;
                constraintsAboutDevLabel.fill = 2;
                constraintsAboutDevLabel.weightx = 1.0;
                constraintsAboutDevLabel.insets = new Insets(4, 0, 0, 0);
                this.getAboutInfoPanel().add((Component)this.getAboutDevLabel(), constraintsAboutDevLabel);
                GridBagConstraints constraintsAboutContactLabel = new GridBagConstraints();
                constraintsAboutContactLabel.gridx = 0;
                constraintsAboutContactLabel.gridy = 2;
                constraintsAboutContactLabel.fill = 2;
                constraintsAboutContactLabel.weightx = 1.0;
                constraintsAboutContactLabel.insets = new Insets(2, 0, 4, 0);
                this.getAboutInfoPanel().add((Component)this.getAboutContactLabel(), constraintsAboutContactLabel);
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iAboutInfoPanel;
    }

    private MenuItem getAboutMenuItem() {
        if (this.iAboutMenuItem == null) {
            try {
                this.iAboutMenuItem = new MenuItem();
                this.iAboutMenuItem.setLabel("About...");
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iAboutMenuItem;
    }

    private Button getAboutOkButton() {
        if (this.iAboutOkButton == null) {
            try {
                this.iAboutOkButton = new Button();
                this.iAboutOkButton.setName("AboutOkButton");
                this.iAboutOkButton.setLabel("OK");
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iAboutOkButton;
    }

    private Label getAboutTitleLabel() {
        if (this.iAboutTitleLabel == null) {
            try {
                this.iAboutTitleLabel = new Label();
                this.iAboutTitleLabel.setName("AboutTitleLabel");
                this.iAboutTitleLabel.setFont(new Font("Arial", 1, 12));
                this.iAboutTitleLabel.setAlignment(1);
                this.iAboutTitleLabel.setText("Ant VisualAge for Java Tool-Integration");
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iAboutTitleLabel;
    }

    private MenuBar getAntMakeMenuBar() {
        if (this.iAntMakeMenuBar == null) {
            try {
                this.iAntMakeMenuBar = new MenuBar();
                this.iAntMakeMenuBar.add(this.getFileMenu());
                this.iAntMakeMenuBar.add(this.getHelpMenu());
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iAntMakeMenuBar;
    }

    private Button getBrowseButton() {
        if (this.iBrowseButton == null) {
            try {
                this.iBrowseButton = new Button();
                this.iBrowseButton.setName("BrowseButton");
                this.iBrowseButton.setLabel("...");
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iBrowseButton;
    }

    private Button getBuildButton() {
        if (this.iBuildButton == null) {
            try {
                this.iBuildButton = new Button();
                this.iBuildButton.setName("BuildButton");
                this.iBuildButton.setLabel("Execute");
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iBuildButton;
    }

    private Label getBuildFileLabel() {
        if (this.iBuildFileLabel == null) {
            try {
                this.iBuildFileLabel = new Label();
                this.iBuildFileLabel.setName("BuildFileLabel");
                this.iBuildFileLabel.setText("Ant-Buildfile:");
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iBuildFileLabel;
    }

    private TextField getBuildFileTextField() {
        if (this.iBuildFileTextField == null) {
            try {
                this.iBuildFileTextField = new TextField();
                this.iBuildFileTextField.setName("BuildFileTextField");
                this.iBuildFileTextField.setBackground(SystemColor.textHighlightText);
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iBuildFileTextField;
    }

    private VAJBuildInfo getBuildInfo() {
        return this.iBuildInfo;
    }

    private Button getCloseButton() {
        if (this.iCloseButton == null) {
            try {
                this.iCloseButton = new Button();
                this.iCloseButton.setName("CloseButton");
                this.iCloseButton.setLabel("Close");
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iCloseButton;
    }

    private Panel getCommandButtonPanel() {
        if (this.iCommandButtonPanel == null) {
            try {
                this.iCommandButtonPanel = new Panel();
                this.iCommandButtonPanel.setName("CommandButtonPanel");
                this.iCommandButtonPanel.setLayout(this.getCommandButtonPanelFlowLayout());
                this.iCommandButtonPanel.setBackground(SystemColor.control);
                this.iCommandButtonPanel.add(this.getReloadButton());
                this.iCommandButtonPanel.add(this.getBuildButton());
                this.iCommandButtonPanel.add(this.getStopButton());
                this.iCommandButtonPanel.add(this.getCloseButton());
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iCommandButtonPanel;
    }

    private FlowLayout getCommandButtonPanelFlowLayout() {
        FlowLayout iCommandButtonPanelFlowLayout = null;
        try {
            iCommandButtonPanelFlowLayout = new FlowLayout();
            iCommandButtonPanelFlowLayout.setAlignment(2);
        }
        catch (Throwable iExc) {
            this.handleException(iExc);
        }
        return iCommandButtonPanelFlowLayout;
    }

    private Panel getContentsPane() {
        if (this.iContentsPane == null) {
            try {
                this.iContentsPane = new Panel();
                this.iContentsPane.setName("ContentsPane");
                this.iContentsPane.setLayout(new BorderLayout());
                this.getContentsPane().add((Component)this.getCommandButtonPanel(), "South");
                this.getContentsPane().add((Component)this.getOptionenPanel(), "Center");
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iContentsPane;
    }

    private FileDialog getFileDialog() {
        if (this.iFileDialog == null) {
            try {
                this.iFileDialog = new FileDialog(this);
                this.iFileDialog.setName("FileDialog");
                this.iFileDialog.setLayout(null);
                VAJAntToolGUI.centerDialog(this.iFileDialog);
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iFileDialog;
    }

    private Menu getFileMenu() {
        if (this.iFileMenu == null) {
            try {
                this.iFileMenu = new Menu();
                this.iFileMenu.setLabel("File");
                this.iFileMenu.add(this.getSaveMenuItem());
                this.iFileMenu.add(this.getMenuSeparator());
                this.iFileMenu.add(this.getShowLogMenuItem());
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iFileMenu;
    }

    private Menu getHelpMenu() {
        if (this.iHelpMenu == null) {
            try {
                this.iHelpMenu = new Menu();
                this.iHelpMenu.setLabel("Help");
                this.iHelpMenu.add(this.getAboutMenuItem());
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iHelpMenu;
    }

    private MenuItem getMenuSeparator() {
        if (this.iMenuSeparator == null) {
            try {
                this.iMenuSeparator = new MenuItem();
                this.iMenuSeparator.setLabel("-");
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iMenuSeparator;
    }

    private Button getMessageClearLogButton() {
        if (this.iMessageClearLogButton == null) {
            try {
                this.iMessageClearLogButton = new Button();
                this.iMessageClearLogButton.setName("MessageClearLogButton");
                this.iMessageClearLogButton.setLabel("Clear Log");
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iMessageClearLogButton;
    }

    private Panel getMessageCommandPanel() {
        if (this.iMessageCommandPanel == null) {
            try {
                this.iMessageCommandPanel = new Panel();
                this.iMessageCommandPanel.setName("MessageCommandPanel");
                this.iMessageCommandPanel.setLayout(new FlowLayout());
                this.getMessageCommandPanel().add((Component)this.getMessageClearLogButton(), this.getMessageClearLogButton().getName());
                this.getMessageCommandPanel().add((Component)this.getMessageOkButton(), this.getMessageOkButton().getName());
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iMessageCommandPanel;
    }

    private Panel getMessageContentPanel() {
        if (this.iMessageContentPanel == null) {
            try {
                this.iMessageContentPanel = new Panel();
                this.iMessageContentPanel.setName("MessageContentPanel");
                this.iMessageContentPanel.setLayout(new BorderLayout());
                this.iMessageContentPanel.setBackground(SystemColor.control);
                this.getMessageContentPanel().add((Component)this.getMessageTextArea(), "Center");
                this.getMessageContentPanel().add((Component)this.getMessageCommandPanel(), "South");
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iMessageContentPanel;
    }

    private Frame getMessageFrame() {
        if (this.iMessageFrame == null) {
            try {
                this.iMessageFrame = new Frame();
                this.iMessageFrame.setName("MessageFrame");
                this.iMessageFrame.setLayout(new BorderLayout());
                ((Component)this.iMessageFrame).setBounds(0, 0, 750, 250);
                this.iMessageFrame.setTitle("Message Log");
                this.iMessageFrame.add((Component)this.getMessageContentPanel(), "Center");
                ((Component)this.iMessageFrame).setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.iMessageFrame.getSize().width / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2);
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iMessageFrame;
    }

    private Button getMessageOkButton() {
        if (this.iMessageOkButton == null) {
            try {
                this.iMessageOkButton = new Button();
                this.iMessageOkButton.setName("MessageOkButton");
                this.iMessageOkButton.setLabel("Close");
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iMessageOkButton;
    }

    private Choice getMessageOutputLevelChoice() {
        if (this.iMessageOutputLevelChoice == null) {
            try {
                this.iMessageOutputLevelChoice = new Choice();
                this.iMessageOutputLevelChoice.setName("MessageOutputLevelChoice");
                this.iMessageOutputLevelChoice.add("Error");
                this.iMessageOutputLevelChoice.add("Warning");
                this.iMessageOutputLevelChoice.add("Info");
                this.iMessageOutputLevelChoice.add("Verbose");
                this.iMessageOutputLevelChoice.add("Debug");
                this.iMessageOutputLevelChoice.select(2);
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iMessageOutputLevelChoice;
    }

    private Label getMessageOutputLevelLabel() {
        if (this.iMessageOutputLevelLabel == null) {
            try {
                this.iMessageOutputLevelLabel = new Label();
                this.iMessageOutputLevelLabel.setName("MessageOutputLevelLabel");
                this.iMessageOutputLevelLabel.setText("Message Level:");
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iMessageOutputLevelLabel;
    }

    private TextArea getMessageTextArea() {
        if (this.iMessageTextArea == null) {
            try {
                this.iMessageTextArea = new TextArea();
                this.iMessageTextArea.setName("MessageTextArea");
                this.iMessageTextArea.setFont(new Font("monospaced", 0, 12));
                this.iMessageTextArea.setText("");
                this.iMessageTextArea.setEditable(false);
                this.iMessageTextArea.setEnabled(true);
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iMessageTextArea;
    }

    private Panel getOptionenPanel() {
        if (this.iOptionenPanel == null) {
            try {
                this.iOptionenPanel = new Panel();
                this.iOptionenPanel.setName("OptionenPanel");
                this.iOptionenPanel.setLayout(new GridBagLayout());
                this.iOptionenPanel.setBackground(SystemColor.control);
                GridBagConstraints constraintsProjectLabel = new GridBagConstraints();
                constraintsProjectLabel.gridx = 0;
                constraintsProjectLabel.gridy = 0;
                constraintsProjectLabel.anchor = 17;
                constraintsProjectLabel.insets = new Insets(4, 4, 4, 4);
                this.getOptionenPanel().add((Component)this.getProjectLabel(), constraintsProjectLabel);
                GridBagConstraints constraintsBuildFileLabel = new GridBagConstraints();
                constraintsBuildFileLabel.gridx = 0;
                constraintsBuildFileLabel.gridy = 1;
                constraintsBuildFileLabel.anchor = 17;
                constraintsBuildFileLabel.insets = new Insets(4, 4, 4, 4);
                this.getOptionenPanel().add((Component)this.getBuildFileLabel(), constraintsBuildFileLabel);
                GridBagConstraints constraintsTargetLabel = new GridBagConstraints();
                constraintsTargetLabel.gridx = 0;
                constraintsTargetLabel.gridy = 2;
                constraintsTargetLabel.anchor = 18;
                constraintsTargetLabel.insets = new Insets(4, 4, 4, 4);
                this.getOptionenPanel().add((Component)this.getTargetLabel(), constraintsTargetLabel);
                GridBagConstraints constraintsProjectText = new GridBagConstraints();
                constraintsProjectText.gridx = 1;
                constraintsProjectText.gridy = 0;
                constraintsProjectText.gridwidth = 2;
                constraintsProjectText.fill = 2;
                constraintsProjectText.anchor = 17;
                constraintsProjectText.insets = new Insets(4, 4, 4, 4);
                this.getOptionenPanel().add((Component)this.getProjectText(), constraintsProjectText);
                GridBagConstraints constraintsBuildFileTextField = new GridBagConstraints();
                constraintsBuildFileTextField.gridx = 1;
                constraintsBuildFileTextField.gridy = 1;
                constraintsBuildFileTextField.fill = 2;
                constraintsBuildFileTextField.anchor = 17;
                constraintsBuildFileTextField.weightx = 1.0;
                constraintsBuildFileTextField.insets = new Insets(4, 4, 4, 4);
                this.getOptionenPanel().add((Component)this.getBuildFileTextField(), constraintsBuildFileTextField);
                GridBagConstraints constraintsBrowseButton = new GridBagConstraints();
                constraintsBrowseButton.gridx = 2;
                constraintsBrowseButton.gridy = 1;
                constraintsBrowseButton.insets = new Insets(4, 4, 4, 4);
                this.getOptionenPanel().add((Component)this.getBrowseButton(), constraintsBrowseButton);
                GridBagConstraints constraintsTargetList = new GridBagConstraints();
                constraintsTargetList.gridx = 1;
                constraintsTargetList.gridy = 2;
                constraintsTargetList.gridheight = 2;
                constraintsTargetList.fill = 1;
                constraintsTargetList.weightx = 1.0;
                constraintsTargetList.weighty = 1.0;
                constraintsTargetList.insets = new Insets(4, 4, 4, 4);
                this.getOptionenPanel().add((Component)this.getTargetList(), constraintsTargetList);
                GridBagConstraints constraintsMessageOutputLevelLabel = new GridBagConstraints();
                constraintsMessageOutputLevelLabel.gridx = 0;
                constraintsMessageOutputLevelLabel.gridy = 4;
                constraintsMessageOutputLevelLabel.anchor = 17;
                constraintsMessageOutputLevelLabel.insets = new Insets(4, 4, 4, 4);
                this.getOptionenPanel().add((Component)this.getMessageOutputLevelLabel(), constraintsMessageOutputLevelLabel);
                GridBagConstraints constraintsMessageOutputLevelChoice = new GridBagConstraints();
                constraintsMessageOutputLevelChoice.gridx = 1;
                constraintsMessageOutputLevelChoice.gridy = 4;
                constraintsMessageOutputLevelChoice.fill = 2;
                constraintsMessageOutputLevelChoice.anchor = 17;
                constraintsMessageOutputLevelChoice.weightx = 1.0;
                constraintsMessageOutputLevelChoice.insets = new Insets(4, 4, 4, 4);
                this.getOptionenPanel().add((Component)this.getMessageOutputLevelChoice(), constraintsMessageOutputLevelChoice);
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iOptionenPanel;
    }

    private Label getProjectLabel() {
        if (this.iProjectLabel == null) {
            try {
                this.iProjectLabel = new Label();
                this.iProjectLabel.setName("ProjectLabel");
                this.iProjectLabel.setText("Projectname:");
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iProjectLabel;
    }

    private Label getProjectText() {
        if (this.iProjectText == null) {
            try {
                this.iProjectText = new Label();
                this.iProjectText.setName("ProjectText");
                this.iProjectText.setText(" ");
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iProjectText;
    }

    private Button getReloadButton() {
        if (this.iReloadButton == null) {
            try {
                this.iReloadButton = new Button();
                this.iReloadButton.setName("ReloadButton");
                this.iReloadButton.setLabel("(Re)Load");
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iReloadButton;
    }

    private MenuItem getSaveMenuItem() {
        if (this.iSaveMenuItem == null) {
            try {
                this.iSaveMenuItem = new MenuItem();
                this.iSaveMenuItem.setLabel("Save BuildInfo To Repository");
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iSaveMenuItem;
    }

    private MenuItem getShowLogMenuItem() {
        if (this.iShowLogMenuItem == null) {
            try {
                this.iShowLogMenuItem = new MenuItem();
                this.iShowLogMenuItem.setLabel("Log");
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iShowLogMenuItem;
    }

    private Label getTargetLabel() {
        if (this.iTargetLabel == null) {
            try {
                this.iTargetLabel = new Label();
                this.iTargetLabel.setName("TargetLabel");
                this.iTargetLabel.setText("Target:");
                this.iTargetLabel.setEnabled(true);
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iTargetLabel;
    }

    private List getTargetList() {
        if (this.iTargetList == null) {
            try {
                this.iTargetList = new List();
                this.iTargetList.setName("TargetList");
                this.iTargetList.setEnabled(true);
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iTargetList;
    }

    private void handleException(Throwable exception) {
        String trace = StringUtils.getStackTrace((Throwable)exception);
        this.getMessageTextArea().append("\r\n\r\n" + trace);
        this.getMessageFrame().show();
    }

    private void initConnections() throws Exception {
        this.addWindowListener(this.iEventHandler);
        this.getBrowseButton().addActionListener(this.iEventHandler);
        this.getCloseButton().addActionListener(this.iEventHandler);
        this.getBuildButton().addActionListener(this.iEventHandler);
        this.getStopButton().addActionListener(this.iEventHandler);
        this.getSaveMenuItem().addActionListener(this.iEventHandler);
        this.getAboutOkButton().addActionListener(this.iEventHandler);
        this.getAboutMenuItem().addActionListener(this.iEventHandler);
        this.getMessageOkButton().addActionListener(this.iEventHandler);
        this.getMessageClearLogButton().addActionListener(this.iEventHandler);
        this.getMessageOkButton().addActionListener(this.iEventHandler);
        this.getShowLogMenuItem().addActionListener(this.iEventHandler);
        this.getAboutDialog().addWindowListener(this.iEventHandler);
        this.getMessageFrame().addWindowListener(this.iEventHandler);
        this.getReloadButton().addActionListener(this.iEventHandler);
        this.getTargetList().addItemListener(this.iEventHandler);
        this.getMessageOutputLevelChoice().addItemListener(this.iEventHandler);
        this.getBuildFileTextField().addTextListener(this.iEventHandler);
        this.connectProjectNameToLabel();
        this.connectBuildFileNameToTextField();
    }

    private void initialize() {
        try {
            this.setName("AntMake");
            this.setMenuBar(this.getAntMakeMenuBar());
            this.setLayout(new BorderLayout());
            ((Component)this).setSize(389, 222);
            this.setTitle("Ant VisualAge for Java Tool-Integration");
            this.add((Component)this.getContentsPane(), "Center");
            this.initConnections();
        }
        catch (Throwable iExc) {
            this.handleException(iExc);
        }
        ((Component)this).setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.getSize().width / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - this.getSize().height);
        if (this.getTargetList().getItemCount() == 0 || this.getTargetList().getSelectedIndex() < 0) {
            this.getBuildButton().setEnabled(false);
        }
    }

    private void saveBuildInfo() {
        try {
            VAJAntTool.saveBuildData(this.getBuildInfo());
        }
        catch (Throwable exc) {
            this.handleException(exc);
        }
    }

    private void setBuildInfo(VAJBuildInfo newValue) {
        if (this.iBuildInfo != newValue) {
            try {
                if (this.iBuildInfo != null) {
                    this.iBuildInfo.removePropertyChangeListener(this.iEventHandler);
                }
                this.iBuildInfo = newValue;
                if (this.iBuildInfo != null) {
                    this.iBuildInfo.addPropertyChangeListener(this.iEventHandler);
                }
                this.connectProjectNameToLabel();
                this.connectBuildFileNameToTextField();
                this.getMessageOutputLevelChoice().select(this.iBuildInfo.getOutputMessageLevel());
                this.fillList();
                if (this.iBuildInfo.getVAJProjectName() == null || this.iBuildInfo.getVAJProjectName().equals("")) {
                    this.getSaveMenuItem().setEnabled(false);
                }
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
    }

    private Button getStopButton() {
        if (this.iStopButton == null) {
            try {
                this.iStopButton = new Button();
                this.iStopButton.setName("StopButton");
                this.iStopButton.setLabel("Stop");
                this.iStopButton.setEnabled(false);
            }
            catch (Throwable iExc) {
                this.handleException(iExc);
            }
        }
        return this.iStopButton;
    }

    private class PrivateEventHandler
    implements ActionListener,
    ItemListener,
    TextListener,
    WindowListener,
    PropertyChangeListener {
        private PrivateEventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (e.getSource() == VAJAntToolGUI.this.getBrowseButton()) {
                    VAJAntToolGUI.this.getFileDialog().setDirectory(VAJAntToolGUI.this.getBuildFileTextField().getText().substring(0, VAJAntToolGUI.this.getBuildFileTextField().getText().lastIndexOf(92) + 1));
                    VAJAntToolGUI.this.getFileDialog().setFile("*.xml");
                    VAJAntToolGUI.this.getFileDialog().show();
                    if (!VAJAntToolGUI.this.getFileDialog().getFile().equals("")) {
                        VAJAntToolGUI.this.getBuildFileTextField().setText(VAJAntToolGUI.this.getFileDialog().getDirectory() + VAJAntToolGUI.this.getFileDialog().getFile());
                    }
                }
                if (e.getSource() == VAJAntToolGUI.this.getCloseButton()) {
                    VAJAntToolGUI.this.dispose();
                    System.exit(0);
                }
                if (e.getSource() == VAJAntToolGUI.this.getBuildButton()) {
                    VAJAntToolGUI.this.executeTarget();
                }
                if (e.getSource() == VAJAntToolGUI.this.getStopButton()) {
                    VAJAntToolGUI.this.getBuildInfo().cancelBuild();
                }
                if (e.getSource() == VAJAntToolGUI.this.getReloadButton()) {
                    try {
                        VAJAntToolGUI.this.getBuildInfo().updateTargetList();
                        VAJAntToolGUI.this.fillList();
                    }
                    catch (Throwable fileNotFound) {
                        VAJAntToolGUI.this.handleException(fileNotFound);
                        VAJAntToolGUI.this.getTargetList().removeAll();
                        VAJAntToolGUI.this.getBuildButton().setEnabled(false);
                    }
                }
                if (e.getSource() == VAJAntToolGUI.this.getSaveMenuItem()) {
                    VAJAntToolGUI.this.saveBuildInfo();
                }
                if (e.getSource() == VAJAntToolGUI.this.getAboutMenuItem()) {
                    VAJAntToolGUI.this.getAboutDialog().show();
                }
                if (e.getSource() == VAJAntToolGUI.this.getShowLogMenuItem()) {
                    VAJAntToolGUI.this.getMessageFrame().show();
                }
                if (e.getSource() == VAJAntToolGUI.this.getAboutOkButton()) {
                    VAJAntToolGUI.this.getAboutDialog().dispose();
                }
                if (e.getSource() == VAJAntToolGUI.this.getMessageOkButton()) {
                    VAJAntToolGUI.this.getMessageFrame().dispose();
                }
                if (e.getSource() == VAJAntToolGUI.this.getMessageClearLogButton()) {
                    VAJAntToolGUI.this.getMessageTextArea().setText("");
                }
                if (e.getSource() == VAJAntToolGUI.this.getMessageOkButton()) {
                    VAJAntToolGUI.this.getMessageFrame().dispose();
                }
            }
            catch (Throwable exc) {
                VAJAntToolGUI.this.handleException(exc);
            }
        }

        public void itemStateChanged(ItemEvent e) {
            try {
                if (e.getSource() == VAJAntToolGUI.this.getTargetList()) {
                    VAJAntToolGUI.this.getBuildButton().setEnabled(true);
                }
                if (e.getSource() == VAJAntToolGUI.this.getMessageOutputLevelChoice()) {
                    VAJAntToolGUI.this.getBuildInfo().setOutputMessageLevel(VAJAntToolGUI.this.getMessageOutputLevelChoice().getSelectedIndex());
                }
                if (e.getSource() == VAJAntToolGUI.this.getTargetList()) {
                    VAJAntToolGUI.this.getBuildInfo().setTarget(VAJAntToolGUI.this.getTargetList().getSelectedItem());
                }
            }
            catch (Throwable exc) {
                VAJAntToolGUI.this.handleException(exc);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == VAJAntToolGUI.this.getBuildInfo() && evt.getPropertyName().equals("projectName")) {
                VAJAntToolGUI.this.connectProjectNameToLabel();
            }
            if (evt.getSource() == VAJAntToolGUI.this.getBuildInfo() && evt.getPropertyName().equals("buildFileName")) {
                VAJAntToolGUI.this.connectBuildFileNameToTextField();
            }
        }

        public void textValueChanged(TextEvent e) {
            if (e.getSource() == VAJAntToolGUI.this.getBuildFileTextField()) {
                VAJAntToolGUI.this.connectTextFieldToBuildFileName();
            }
        }

        public void windowClosing(WindowEvent e) {
            try {
                if (e.getSource() == VAJAntToolGUI.this) {
                    VAJAntToolGUI.this.dispose();
                    System.exit(0);
                }
                if (e.getSource() == VAJAntToolGUI.this.getAboutDialog()) {
                    VAJAntToolGUI.this.getAboutDialog().dispose();
                }
                if (e.getSource() == VAJAntToolGUI.this.getMessageFrame()) {
                    VAJAntToolGUI.this.getMessageFrame().dispose();
                }
            }
            catch (Throwable exc) {
                VAJAntToolGUI.this.handleException(exc);
            }
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }
    }

    private class VAJBuildLogger
    implements BuildListener {
        private long startTime = System.currentTimeMillis();

        public void buildFinished(BuildEvent event) {
            VAJAntToolGUI.this.getStopButton().setEnabled(false);
            VAJAntToolGUI.this.getBuildButton().setEnabled(true);
            VAJAntToolGUI.this.getBuildButton().requestFocus();
            Throwable error = event.getException();
            if (error == null) {
                VAJAntToolGUI.this.getMessageTextArea().append("\r\nBUILD SUCCESSFUL");
            } else {
                this.logException(error);
            }
            VAJAntToolGUI.this.getMessageTextArea().append("\r\nTotal time: " + DateUtils.formatElapsedTime((long)(System.currentTimeMillis() - this.startTime)));
        }

        public void logException(Throwable error) {
            VAJAntToolGUI.this.getMessageTextArea().append("\r\nBUILD FAILED\r\n");
            if (error instanceof BuildException) {
                VAJAntToolGUI.this.getMessageTextArea().append(error.toString());
                Throwable nested = ((BuildException)error).getException();
                if (nested != null) {
                    nested.printStackTrace(System.err);
                }
            } else {
                error.printStackTrace(System.err);
            }
        }

        public void buildStarted(BuildEvent event) {
            VAJAntToolGUI.this.getStopButton().setEnabled(true);
            VAJAntToolGUI.this.getBuildButton().setEnabled(false);
            VAJAntToolGUI.this.getStopButton().requestFocus();
            this.startTime = System.currentTimeMillis();
            VAJAntToolGUI.this.getMessageTextArea().append(VAJAntToolGUI.lineSeparator);
        }

        public void messageLogged(BuildEvent event) {
            if (event.getPriority() <= VAJAntToolGUI.this.getBuildInfo().getOutputMessageLevel()) {
                String msg = "";
                if (event.getTask() != null) {
                    msg = "[" + event.getTask().getTaskName() + "] ";
                }
                VAJAntToolGUI.this.getMessageTextArea().append(VAJAntToolGUI.lineSeparator + msg + event.getMessage());
            }
        }

        public void targetFinished(BuildEvent event) {
        }

        public void targetStarted(BuildEvent event) {
            if (VAJAntToolGUI.this.getBuildInfo().getOutputMessageLevel() <= 2) {
                VAJAntToolGUI.this.getMessageTextArea().append(VAJAntToolGUI.lineSeparator + event.getTarget().getName() + ":");
            }
        }

        public void taskFinished(BuildEvent event) {
        }

        public void taskStarted(BuildEvent event) {
        }
    }
}

