/* gimp-3.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Gimp", gir_namespace = "Gimp", gir_version = "3.0", lower_case_cprefix = "gimp_")]
namespace Gimp {
	[CCode (cheader_filename = "libgimp/gimp.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gimp_array_get_type ()")]
	[Compact]
	public class Array {
		[CCode (array_length_cname = "length", array_length_type = "gsize")]
		public weak uint8[] data;
		public size_t length;
		public bool static_data;
		[CCode (has_construct_function = false)]
		public Array ([CCode (array_length_cname = "length", array_length_pos = 1.5, array_length_type = "gsize")] uint8[] data, bool static_data);
		public Gimp.Array copy ();
		public void free ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_batch_procedure_get_type ()")]
	public class BatchProcedure : Gimp.Procedure {
		[CCode (has_construct_function = false, type = "GimpProcedure*")]
		[Version (since = "3.0")]
		public BatchProcedure (Gimp.PlugIn plug_in, string name, string interpreter_name, Gimp.PDBProcType proc_type, owned Gimp.BatchFunc run_func);
		[Version (since = "3.0")]
		public unowned string get_interpreter_name ();
		[Version (since = "3.0")]
		public void set_interpreter_name (string interpreter_name);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_brush_get_type ()")]
	public class Brush : Gimp.Resource, Gimp.ConfigInterface {
		[CCode (has_construct_function = false)]
		[Version (since = "2.2")]
		public Brush (string name);
		[Version (since = "2.4")]
		public bool get_angle (out double angle);
		[Version (since = "2.4")]
		public bool get_aspect_ratio (out double aspect_ratio);
		public Gegl.Buffer get_buffer (int max_width, int max_height, Babl.Object format);
		[Version (since = "3.0")]
		public static unowned Gimp.Brush? get_by_name (string name);
		[Version (since = "2.4")]
		public bool get_hardness (out double hardness);
		[Version (since = "2.2")]
		public bool get_info (out int width, out int height, out int mask_bpp, out int color_bpp);
		public Gegl.Buffer get_mask (int max_width, int max_height, Babl.Object format);
		[Version (since = "2.4")]
		public bool get_radius (out double radius);
		[Version (since = "2.4")]
		public bool get_shape (out Gimp.BrushGeneratedShape shape);
		[Version (since = "2.2")]
		public int get_spacing ();
		[Version (since = "2.4")]
		public bool get_spikes (out int spikes);
		[Version (since = "2.4")]
		public bool is_generated ();
		[Version (since = "2.4")]
		public bool set_angle (double angle_in, out double angle_out);
		[Version (since = "2.4")]
		public bool set_aspect_ratio (double aspect_ratio_in, out double aspect_ratio_out);
		[Version (since = "2.4")]
		public bool set_hardness (double hardness_in, out double hardness_out);
		[Version (since = "2.4")]
		public bool set_radius (double radius_in, out double radius_out);
		[Version (since = "2.4")]
		public bool set_shape (Gimp.BrushGeneratedShape shape_in, out Gimp.BrushGeneratedShape shape_out);
		[Version (since = "2.4")]
		public bool set_spacing (int spacing);
		[Version (since = "2.4")]
		public bool set_spikes (int spikes_in, out int spikes_out);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_channel_get_type ()")]
	public class Channel : Gimp.Drawable {
		[CCode (has_construct_function = false)]
		public Channel (Gimp.Image image, string name, int width, int height, double opacity, Gegl.Color color);
		public bool combine_masks (Gimp.Channel channel2, Gimp.ChannelOps operation, int offx, int offy);
		public unowned Gimp.Channel copy ();
		[CCode (has_construct_function = false)]
		[Version (since = "2.4")]
		public Channel.from_component (Gimp.Image image, Gimp.ChannelType component, string name);
		[Version (since = "3.0")]
		public static unowned Gimp.Channel? get_by_id (int32 channel_id);
		public Gegl.Color get_color ();
		public double get_opacity ();
		public bool get_show_masked ();
		public bool set_color (Gegl.Color color);
		public bool set_opacity (double opacity);
		public bool set_show_masked (bool show_masked);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_choice_get_type ()")]
	public class Choice : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "3.0")]
		public Choice ();
		[Version (since = "3.0")]
		public void add (string nick, int id, string label, string help);
		[Version (since = "3.0")]
		public bool get_documentation (string nick, string label, string help);
		[Version (since = "3.0")]
		public unowned string get_help (string nick);
		[Version (since = "3.0")]
		public int get_id (string nick);
		[Version (since = "3.0")]
		public unowned string get_label (string nick);
		[Version (since = "3.0")]
		public bool is_valid (string nick);
		[Version (since = "3.0")]
		public unowned GLib.List<string> list_nicks ();
		[Version (since = "3.0")]
		public void set_sensitive (string nick, bool sensitive);
		public signal void sensitivity_changed (string object);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gegl_color_get_type ()")]
	public class ColorArray : Gegl.Color {
		[CCode (has_construct_function = false)]
		protected ColorArray ();
		public Gimp.ColorArray copy ();
		public void free ();
		public int get_length ();
		public static GLib.Type get_type ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_color_config_get_type ()")]
	public class ColorConfig : GLib.Object, Gimp.ConfigInterface {
		[CCode (has_construct_function = false)]
		protected ColorConfig ();
		[Version (since = "2.10")]
		public Gimp.ColorProfile get_cmyk_color_profile () throws GLib.Error;
		[Version (since = "2.10")]
		public bool get_display_bpc ();
		[Version (since = "2.10")]
		public Gimp.ColorProfile get_display_color_profile () throws GLib.Error;
		[Version (since = "2.10")]
		public Gimp.ColorRenderingIntent get_display_intent ();
		[Version (since = "2.10")]
		public bool get_display_optimize ();
		[Version (since = "2.10")]
		public bool get_display_profile_from_gdk ();
		[Version (since = "2.10")]
		public Gimp.ColorProfile get_gray_color_profile () throws GLib.Error;
		[Version (since = "2.10")]
		public Gimp.ColorManagementMode get_mode ();
		[Version (since = "3.0")]
		public Gegl.Color get_out_of_gamut_color ();
		[Version (since = "2.10")]
		public Gimp.ColorProfile get_rgb_color_profile () throws GLib.Error;
		[Version (since = "2.10")]
		public bool get_simulation_bpc ();
		[Version (since = "2.10")]
		public Gimp.ColorProfile get_simulation_color_profile () throws GLib.Error;
		[Version (since = "2.10")]
		public bool get_simulation_gamut_check ();
		[Version (since = "2.10")]
		public Gimp.ColorRenderingIntent get_simulation_intent ();
		[Version (since = "2.10")]
		public bool get_simulation_optimize ();
		[NoAccessorMethod]
		public Gimp.ConfigPath cmyk_profile { owned get; set construct; }
		[NoAccessorMethod]
		public bool display_optimize { get; set construct; }
		[NoAccessorMethod]
		public Gimp.ConfigPath display_profile { owned get; set construct; }
		[NoAccessorMethod]
		public bool display_profile_from_gdk { get; set construct; }
		[NoAccessorMethod]
		public Gimp.ColorRenderingIntent display_rendering_intent { get; set construct; }
		[NoAccessorMethod]
		public bool display_use_black_point_compensation { get; set construct; }
		[NoAccessorMethod]
		public Gimp.ConfigPath gray_profile { owned get; set construct; }
		[NoAccessorMethod]
		public Gimp.ColorManagementMode mode { get; set construct; }
		[NoAccessorMethod]
		public Gegl.Color out_of_gamut_color { owned get; set; }
		[NoAccessorMethod]
		public Gimp.ConfigPath rgb_profile { owned get; set construct; }
		[NoAccessorMethod]
		public bool show_hsv { get; set construct; }
		[NoAccessorMethod]
		public bool show_rgb_u8 { get; set construct; }
		[NoAccessorMethod]
		public bool simulation_gamut_check { get; set construct; }
		[NoAccessorMethod]
		public bool simulation_optimize { get; set construct; }
		[NoAccessorMethod]
		public Gimp.ConfigPath simulation_profile { owned get; set construct; }
		[NoAccessorMethod]
		public Gimp.ColorRenderingIntent simulation_rendering_intent { get; set construct; }
		[NoAccessorMethod]
		public bool simulation_use_black_point_compensation { get; set construct; }
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_color_profile_get_type ()")]
	public class ColorProfile : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ColorProfile ();
		[CCode (has_construct_function = false)]
		[Version (since = "2.10")]
		public ColorProfile.d50_gray_lab_trc ();
		[CCode (has_construct_function = false)]
		public ColorProfile.d65_gray_linear ();
		[CCode (has_construct_function = false)]
		[Version (since = "2.10")]
		public ColorProfile.d65_gray_srgb_trc ();
		[CCode (has_construct_function = false)]
		[Version (since = "2.10")]
		public ColorProfile.from_file (GLib.File file) throws GLib.Error;
		[CCode (has_construct_function = false)]
		[Version (since = "2.10")]
		public ColorProfile.from_icc_profile ([CCode (array_length_cname = "length", array_length_pos = 1.1, array_length_type = "gsize")] uint8[] data) throws GLib.Error;
		[CCode (has_construct_function = false)]
		[Version (since = "2.10")]
		public ColorProfile.from_lcms_profile (void* lcms_profile) throws GLib.Error;
		[Version (since = "2.10")]
		public unowned string get_copyright ();
		[Version (since = "2.10")]
		public unowned string get_description ();
		[Version (since = "2.10")]
		public unowned Babl.Object? get_format (Babl.Object format, Gimp.ColorRenderingIntent intent) throws GLib.Error;
		[CCode (array_length_pos = 0.1, array_length_type = "gsize")]
		[Version (since = "2.10")]
		public unowned uint8[] get_icc_profile ();
		[Version (since = "2.10")]
		public unowned string get_label ();
		[Version (since = "2.10")]
		public static unowned Babl.Object? get_lcms_format (Babl.Object format, out uint32 lcms_format);
		[Version (since = "2.10")]
		public void* get_lcms_profile ();
		[Version (since = "2.10")]
		public unowned string get_manufacturer ();
		[Version (since = "2.10")]
		public unowned string get_model ();
		[Version (since = "2.10.6")]
		public unowned Babl.Object? get_space (Gimp.ColorRenderingIntent intent) throws GLib.Error;
		[Version (since = "2.10")]
		public unowned string get_summary ();
		[Version (since = "2.10")]
		public bool is_cmyk ();
		[Version (since = "2.10")]
		public bool is_equal (Gimp.ColorProfile profile2);
		[Version (since = "2.10")]
		public bool is_gray ();
		[Version (since = "2.10")]
		public bool is_linear ();
		[Version (since = "2.10")]
		public bool is_rgb ();
		[Version (since = "2.10")]
		public Gimp.ColorProfile? new_linear_from_color_profile ();
		[Version (since = "2.10")]
		public Gimp.ColorProfile? new_srgb_trc_from_color_profile ();
		[CCode (has_construct_function = false)]
		[Version (since = "2.10")]
		public ColorProfile.rgb_adobe ();
		[CCode (has_construct_function = false)]
		[Version (since = "2.10")]
		public ColorProfile.rgb_srgb ();
		[CCode (has_construct_function = false)]
		[Version (since = "2.10")]
		public ColorProfile.rgb_srgb_linear ();
		[Version (since = "2.10")]
		public bool save_to_file (GLib.File file) throws GLib.Error;
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_color_transform_get_type ()")]
	public class ColorTransform : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "2.10")]
		public ColorTransform (Gimp.ColorProfile src_profile, Babl.Object src_format, Gimp.ColorProfile dest_profile, Babl.Object dest_format, Gimp.ColorRenderingIntent rendering_intent, Gimp.ColorTransformFlags flags);
		[Version (since = "2.10")]
		public static bool can_gegl_copy (Gimp.ColorProfile src_profile, Gimp.ColorProfile dest_profile);
		[Version (since = "2.10")]
		public void process_buffer (Gegl.Buffer src_buffer, Gegl.Rectangle src_rect, Gegl.Buffer dest_buffer, Gegl.Rectangle dest_rect);
		[Version (since = "2.10")]
		public void process_pixels (Babl.Object src_format, void* src_pixels, Babl.Object dest_format, void* dest_pixels, size_t length);
		[CCode (has_construct_function = false)]
		[Version (since = "2.10")]
		public ColorTransform.proofing (Gimp.ColorProfile src_profile, Babl.Object src_format, Gimp.ColorProfile dest_profile, Babl.Object dest_format, Gimp.ColorProfile proof_profile, Gimp.ColorRenderingIntent proof_intent, Gimp.ColorRenderingIntent display_intent, Gimp.ColorTransformFlags flags);
		public signal void progress (double object);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", has_type_id = false)]
	[Compact]
	public class Config {
		[Version (replacement = "ConfigInterface.build_data_path", since = "2.4")]
		public static string build_data_path (string name);
		[Version (replacement = "ConfigInterface.build_plug_in_path", since = "2.4")]
		public static string build_plug_in_path (string name);
		[Version (replacement = "ConfigInterface.build_system_path", since = "2.10.6")]
		public static string build_system_path (string name);
		[Version (replacement = "ConfigInterface.build_writable_path", since = "2.4")]
		public static string build_writable_path (string name);
		[Version (since = "2.6")]
		public bool copy (Gimp.Config dest, GLib.ParamFlags flags);
		[Version (since = "2.8")]
		public bool deserialize (GLib.Scanner scanner, int nest_level, void* data);
		[Version (since = "2.10")]
		public bool deserialize_file (GLib.File file, void* data) throws GLib.Error;
		[Version (since = "3.0")]
		public bool deserialize_parasite (Gimp.Parasite parasite, void* data) throws GLib.Error;
		[Version (since = "2.4")]
		public bool deserialize_properties (GLib.Scanner scanner, int nest_level);
		[Version (since = "2.4")]
		public GLib.TokenType deserialize_property (GLib.Scanner scanner, int nest_level);
		[Version (replacement = "ConfigInterface.deserialize_return", since = "2.4")]
		public static bool deserialize_return (GLib.Scanner scanner, GLib.TokenType expected_token, int nest_level);
		[Version (since = "2.10")]
		public bool deserialize_stream (GLib.InputStream input, void* data) throws GLib.Error;
		[Version (since = "2.4")]
		public bool deserialize_string ([CCode (array_length_cname = "text_len", array_length_pos = 1.5)] char[] text, void* data) throws GLib.Error;
		[Version (replacement = "ConfigInterface.diff", since = "2.4")]
		public static GLib.List<weak GLib.ParamSpec> diff (GLib.Object a, GLib.Object b, GLib.ParamFlags flags);
		[Version (since = "2.4")]
		public void* duplicate ();
		[Version (since = "2.4")]
		public bool is_equal_to (Gimp.Config b);
		[Version (replacement = "ConfigInterface.param_spec_duplicate", since = "3.0")]
		public static GLib.ParamSpec param_spec_duplicate (GLib.ParamSpec pspec);
		[Version (since = "2.4")]
		public void reset ();
		[Version (replacement = "ConfigInterface.reset_properties", since = "2.4")]
		public static void reset_properties (GLib.Object object);
		[Version (replacement = "ConfigInterface.reset_property", since = "2.4")]
		public static void reset_property (GLib.Object object, string property_name);
		[Version (since = "2.8")]
		public bool serialize (Gimp.ConfigWriter writer, void* data);
		[Version (since = "2.4")]
		public bool serialize_changed_properties (Gimp.ConfigWriter writer);
		[Version (since = "2.4")]
		public bool serialize_properties (Gimp.ConfigWriter writer);
		[Version (since = "2.4")]
		public bool serialize_property (GLib.ParamSpec param_spec, Gimp.ConfigWriter writer);
		[Version (since = "2.6")]
		public bool serialize_property_by_name (string prop_name, Gimp.ConfigWriter writer);
		[Version (since = "2.4")]
		public bool serialize_to_fd (int fd, void* data);
		[Version (since = "2.10")]
		public bool serialize_to_file (GLib.File file, string? header, string? footer, void* data) throws GLib.Error;
		[Version (since = "3.0")]
		public Gimp.Parasite serialize_to_parasite (string parasite_name, uint parasite_flags, void* data);
		[Version (since = "2.10")]
		public bool serialize_to_stream (GLib.OutputStream output, string? header, string? footer, void* data) throws GLib.Error;
		[Version (since = "2.4")]
		public string serialize_to_string (void* data);
		[Version (replacement = "ConfigInterface.serialize_value", since = "2.4")]
		public static bool serialize_value (GLib.Value value, GLib.StringBuilder str, bool escaped);
		[Version (replacement = "ConfigInterface.string_append_escaped", since = "2.4")]
		public static void string_append_escaped (GLib.StringBuilder string, string val);
		[Version (replacement = "ConfigInterface.sync", since = "2.4")]
		public static bool sync (GLib.Object src, GLib.Object dest, GLib.ParamFlags flags);
		[Version (replacement = "ConfigInterface.type_register", since = "3.0")]
		public static GLib.Type type_register (GLib.Type parent_type, string type_name, [CCode (array_length_cname = "n_pspecs", array_length_pos = 3.1)] GLib.ParamSpec[] pspecs);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_config_path_get_type ()")]
	public class ConfigPath {
		[CCode (has_construct_function = false)]
		protected ConfigPath ();
		[Version (since = "2.4")]
		public static string expand (string path, bool recode) throws GLib.Error;
		[Version (since = "2.10")]
		public static GLib.List<GLib.File> expand_to_files (string path) throws GLib.Error;
		[Version (since = "2.10")]
		public static string unexpand (string path, bool recode) throws GLib.Error;
	}
	[CCode (cheader_filename = "libgimp/gimp.h", ref_function = "gimp_config_writer_ref", type_id = "gimp_config_writer_get_type ()", unref_function = "gimp_config_writer_unref")]
	[Compact]
	public class ConfigWriter {
		[Version (since = "2.4")]
		public void close ();
		[Version (since = "2.4")]
		public void comment (global::string comment);
		[Version (since = "2.4")]
		public void comment_mode (bool enable);
		[Version (since = "2.4")]
		public void data ([CCode (array_length_cname = "length", array_length_pos = 0.5)] uint8[] data);
		[Version (since = "2.4")]
		public bool finish (global::string footer) throws GLib.Error;
		[CCode (has_construct_function = false)]
		[Version (since = "2.4")]
		public ConfigWriter.from_fd (int fd);
		[CCode (has_construct_function = false)]
		[Version (since = "2.10")]
		public ConfigWriter.from_file (GLib.File file, bool atomic, global::string header) throws GLib.Error;
		[CCode (has_construct_function = false)]
		[Version (since = "2.10")]
		public ConfigWriter.from_stream (GLib.OutputStream output, global::string header) throws GLib.Error;
		[CCode (has_construct_function = false)]
		[Version (since = "2.4")]
		public ConfigWriter.from_string (GLib.StringBuilder string);
		[Version (since = "2.4")]
		public void identifier (global::string identifier);
		public void linefeed ();
		[Version (since = "2.4")]
		public void open (global::string name);
		[Version (since = "2.4")]
		public void print (global::string string, int len);
		[Version (since = "3.0")]
		public Gimp.ConfigWriter @ref ();
		[Version (since = "2.4")]
		public void revert ();
		[Version (since = "2.4")]
		public void string (global::string string);
		[Version (since = "3.0")]
		public void unref ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public class CoreObjectArray : GLib.Object {
		[CCode (has_construct_function = false)]
		protected CoreObjectArray ();
		public static size_t get_length (GLib.Object array);
		public static GLib.Type get_type ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_display_get_type ()")]
	public class Display : GLib.Object {
		[CCode (has_construct_function = false)]
		public Display (Gimp.Image image);
		public bool @delete ();
		[Version (since = "3.0")]
		public static unowned Gimp.Display? get_by_id (int32 display_id);
		[Version (since = "3.0")]
		public int32 get_id ();
		[Version (since = "2.4")]
		public GLib.Bytes get_window_handle ();
		[Version (since = "3.0")]
		public static bool id_is_valid (int display_id);
		[Version (since = "2.4")]
		public bool is_valid ();
		public static unowned string name ();
		[Version (since = "3.0")]
		public bool present ();
		public int id { get; construct; }
	}
	[CCode (cheader_filename = "libgimp/gimp.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gimp_double_array_get_type ()")]
	[Compact]
	public class DoubleArray {
		[CCode (array_length_pos = 1.1, array_length_type = "gsize")]
		public static unowned double[] get_values (Gimp.Array array);
		public static void set_values (Gimp.Array array, [CCode (array_length_cname = "length", array_length_pos = 2.5, array_length_type = "gsize")] double[] values, bool static_data);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_drawable_get_type ()")]
	public abstract class Drawable : Gimp.Item {
		[CCode (has_construct_function = false)]
		protected Drawable ();
		[Version (since = "2.10")]
		public bool brightness_contrast (double brightness, double contrast);
		[Version (since = "2.10")]
		public bool color_balance (Gimp.TransferMode transfer_mode, bool preserve_lum, double cyan_red, double magenta_green, double yellow_blue);
		[Version (since = "2.10")]
		public bool colorize_hsl (double hue, double saturation, double lightness);
		[Version (since = "2.10")]
		public bool curves_explicit (Gimp.HistogramChannel channel, [CCode (array_length_cname = "num_values", array_length_pos = 1.5, array_length_type = "gsize")] double[] values);
		[Version (since = "2.10")]
		public bool curves_spline (Gimp.HistogramChannel channel, [CCode (array_length_cname = "num_points", array_length_pos = 1.5, array_length_type = "gsize")] double[] points);
		[Version (since = "2.10")]
		public bool desaturate (Gimp.DesaturateMode desaturate_mode);
		[Version (since = "2.10")]
		public bool edit_bucket_fill (Gimp.FillType fill_type, double x, double y);
		public bool edit_clear ();
		public bool edit_fill (Gimp.FillType fill_type);
		[Version (since = "2.10")]
		public bool edit_gradient_fill (Gimp.GradientType gradient_type, double offset, bool supersample, int supersample_max_depth, double supersample_threshold, bool dither, double x1, double y1, double x2, double y2);
		[Version (since = "2.10")]
		public bool edit_stroke_item (Gimp.Item item);
		public bool edit_stroke_selection ();
		[Version (since = "2.10")]
		public bool equalize (bool mask_only);
		[Version (since = "2.10.34")]
		public bool extract_component (int component, bool invert, bool linear);
		public bool fill (Gimp.FillType fill_type);
		[Version (since = "2.4")]
		public bool foreground_extract (Gimp.ForegroundExtractMode mode, Gimp.Drawable mask);
		[Version (since = "2.6")]
		public bool free_shadow ();
		public int get_bpp ();
		[Version (since = "2.10")]
		public Gegl.Buffer get_buffer ();
		[Version (since = "3.0")]
		public static unowned Gimp.Drawable? get_by_id (int32 drawable_id);
		[Version (since = "2.10")]
		public unowned Babl.Object? get_format ();
		public int get_height ();
		public bool get_offsets (out int offset_x, out int offset_y);
		public Gegl.Color get_pixel (int x_coord, int y_coord);
		[Version (since = "2.10")]
		public Gegl.Buffer get_shadow_buffer ();
		[Version (since = "2.2")]
		public Gdk.Pixbuf get_sub_thumbnail (int src_x, int src_y, int src_width, int src_height, int dest_width, int dest_height, Gimp.PixbufTransparency alpha);
		public GLib.Bytes get_sub_thumbnail_data (int src_x, int src_y, int src_width, int src_height, int dest_width, int dest_height, out int actual_width, out int actual_height, out int bpp);
		[Version (since = "2.2")]
		public Gdk.Pixbuf get_thumbnail (int width, int height, Gimp.PixbufTransparency alpha);
		public GLib.Bytes? get_thumbnail_data (int width, int height, out int actual_width, out int actual_height, out int bpp);
		[Version (since = "2.10.14")]
		public unowned Babl.Object? get_thumbnail_format ();
		public int get_width ();
		public bool has_alpha ();
		[Version (since = "2.10")]
		public bool histogram (Gimp.HistogramChannel channel, double start_range, double end_range, out double mean, out double std_dev, out double median, out double pixels, out double count, out double percentile);
		[Version (since = "2.10")]
		public bool hue_saturation (Gimp.HueRange hue_range, double hue_offset, double lightness, double saturation, double overlap);
		[Version (since = "2.10")]
		public bool invert (bool linear);
		public bool is_gray ();
		public bool is_indexed ();
		public bool is_rgb ();
		[Version (since = "2.10")]
		public bool levels (Gimp.HistogramChannel channel, double low_input, double high_input, bool clamp_input, double gamma, double low_output, double high_output, bool clamp_output);
		[Version (since = "2.10")]
		public bool levels_stretch ();
		public bool mask_bounds (out int x1, out int y1, out int x2, out int y2);
		[Version (since = "2.2")]
		public bool mask_intersect (out int x, out int y, out int width, out int height);
		public bool merge_filters ();
		public bool merge_shadow (bool undo);
		public bool offset (bool wrap_around, Gimp.OffsetType fill_type, int offset_x, int offset_y);
		[Version (since = "2.10")]
		public bool posterize (int levels);
		public bool set_pixel (int x_coord, int y_coord, Gegl.Color color);
		[Version (since = "2.10.34")]
		public bool shadows_highlights (double shadows, double highlights, double whitepoint, double radius, double compress, double shadows_ccorrect, double highlights_ccorrect);
		[Version (since = "2.10")]
		public bool threshold (Gimp.HistogramChannel channel, double low_threshold, double high_threshold);
		public Gimp.ImageType type ();
		public Gimp.ImageType type_with_alpha ();
		public bool update (int x, int y, int width, int height);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_export_options_get_type ()")]
	public class ExportOptions : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ExportOptions ();
		[Version (since = "3.0")]
		public Gimp.ExportReturn get_image (ref unowned Gimp.Image image);
		[NoAccessorMethod]
		[Version (since = "3.0.0")]
		public Gimp.ExportCapabilities capabilities { get; set construct; }
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_export_procedure_get_type ()")]
	public class ExportProcedure : Gimp.FileProcedure {
		[CCode (has_construct_function = false, type = "GimpProcedure*")]
		[Version (since = "3.0")]
		public ExportProcedure (Gimp.PlugIn plug_in, string name, Gimp.PDBProcType proc_type, bool export_metadata, owned Gimp.RunExportFunc run_func);
		[Version (since = "3.0")]
		public bool get_support_comment ();
		[Version (since = "3.0")]
		public bool get_support_exif ();
		[Version (since = "3.0")]
		public bool get_support_iptc ();
		[Version (since = "3.0")]
		public bool get_support_profile ();
		[Version (since = "3.0")]
		public bool get_support_thumbnail ();
		[Version (since = "3.0")]
		public bool get_support_xmp ();
		[Version (since = "3.0")]
		public void set_capabilities (Gimp.ExportCapabilities capabilities, owned Gimp.ExportGetCapabilitiesFunc? get_capabilities_func);
		[Version (since = "3.0")]
		public void set_support_comment (bool supports);
		[Version (since = "3.0")]
		public void set_support_exif (bool supports);
		[Version (since = "3.0")]
		public void set_support_iptc (bool supports);
		[Version (since = "3.0")]
		public void set_support_profile (bool supports);
		[Version (since = "3.0")]
		public void set_support_thumbnail (bool supports);
		[Version (since = "3.0")]
		public void set_support_xmp (bool supports);
		[NoAccessorMethod]
		[Version (since = "3.0.0")]
		public Gimp.ExportCapabilities capabilities { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "3.0.0")]
		public bool supports_comment { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "3.0.0")]
		public bool supports_exif { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "3.0.0")]
		public bool supports_iptc { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "3.0.0")]
		public bool supports_profile { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "3.0.0")]
		public bool supports_thumbnail { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "3.0.0")]
		public bool supports_xmp { get; set construct; }
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_file_procedure_get_type ()")]
	public abstract class FileProcedure : Gimp.Procedure {
		[CCode (has_construct_function = false)]
		protected FileProcedure ();
		[Version (since = "3.0")]
		public unowned string get_extensions ();
		[Version (since = "3.0")]
		public unowned string get_format_name ();
		[Version (since = "3.0")]
		public bool get_handles_remote ();
		[Version (since = "3.0")]
		public unowned string get_magics ();
		[Version (since = "3.0")]
		public unowned string get_mime_types ();
		[Version (since = "3.0")]
		public unowned string get_prefixes ();
		[Version (since = "3.0")]
		public int get_priority ();
		[Version (since = "3.0")]
		public void set_extensions (string extensions);
		[Version (since = "3.0")]
		public void set_format_name (string format_name);
		[Version (since = "3.0")]
		public void set_handles_remote (bool handles_remote);
		[Version (since = "3.0")]
		public void set_magics (string magics);
		[Version (since = "3.0")]
		public void set_mime_types (string mime_types);
		[Version (since = "3.0")]
		public void set_prefixes (string prefixes);
		[Version (since = "3.0")]
		public void set_priority (int priority);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_font_get_type ()")]
	public class Font : Gimp.Resource, Gimp.ConfigInterface {
		[CCode (has_construct_function = false)]
		protected Font ();
		[Version (since = "3.0")]
		public static unowned Gimp.Font? get_by_name (string name);
		[Version (since = "3.0")]
		public Pango.FontDescription get_pango_font_description ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_gradient_get_type ()")]
	public class Gradient : Gimp.Resource, Gimp.ConfigInterface {
		[CCode (has_construct_function = false)]
		[Version (since = "2.2")]
		public Gradient (string name);
		[Version (since = "3.0")]
		public static unowned Gimp.Gradient? get_by_name (string name);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "2.2")]
		public Gegl.Color[] get_custom_samples ([CCode (array_length_cname = "num_samples", array_length_pos = 0.5, array_length_type = "gsize")] double[] positions, bool reverse);
		[Version (since = "2.6")]
		public int get_number_of_segments ();
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "2.2")]
		public Gegl.Color[] get_uniform_samples (int num_samples, bool reverse);
		[Version (since = "2.2")]
		public bool segment_get_blending_function (int segment, out Gimp.GradientSegmentType blend_func);
		[Version (since = "2.2")]
		public bool segment_get_coloring_type (int segment, out Gimp.GradientSegmentColor coloring_type);
		[Version (since = "2.2")]
		public Gegl.Color segment_get_left_color (int segment);
		[Version (since = "2.2")]
		public bool segment_get_left_pos (int segment, out double pos);
		[Version (since = "2.2")]
		public bool segment_get_middle_pos (int segment, out double pos);
		[Version (since = "2.2")]
		public Gegl.Color segment_get_right_color (int segment);
		[Version (since = "2.2")]
		public bool segment_get_right_pos (int segment, out double pos);
		[Version (since = "2.2")]
		public bool segment_range_blend_colors (int start_segment, int end_segment);
		[Version (since = "2.2")]
		public bool segment_range_blend_opacity (int start_segment, int end_segment);
		[Version (since = "2.2")]
		public bool segment_range_delete (int start_segment, int end_segment);
		[Version (since = "2.2")]
		public bool segment_range_flip (int start_segment, int end_segment);
		[Version (since = "2.2")]
		public double segment_range_move (int start_segment, int end_segment, double delta, bool control_compress);
		[Version (since = "2.2")]
		public bool segment_range_redistribute_handles (int start_segment, int end_segment);
		[Version (since = "2.2")]
		public bool segment_range_replicate (int start_segment, int end_segment, int replicate_times);
		[Version (since = "2.2")]
		public bool segment_range_set_blending_function (int start_segment, int end_segment, Gimp.GradientSegmentType blending_function);
		[Version (since = "2.2")]
		public bool segment_range_set_coloring_type (int start_segment, int end_segment, Gimp.GradientSegmentColor coloring_type);
		[Version (since = "2.2")]
		public bool segment_range_split_midpoint (int start_segment, int end_segment);
		[Version (since = "2.2")]
		public bool segment_range_split_uniform (int start_segment, int end_segment, int split_parts);
		[Version (since = "2.2")]
		public bool segment_set_left_color (int segment, Gegl.Color color);
		[Version (since = "2.2")]
		public bool segment_set_left_pos (int segment, double pos, out double final_pos);
		[Version (since = "2.2")]
		public bool segment_set_middle_pos (int segment, double pos, out double final_pos);
		[Version (since = "2.2")]
		public bool segment_set_right_color (int segment, Gegl.Color color);
		[Version (since = "2.2")]
		public bool segment_set_right_pos (int segment, double pos, out double final_pos);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_group_layer_get_type ()")]
	public class GroupLayer : Gimp.Layer {
		[CCode (has_construct_function = false)]
		[Version (since = "3.0")]
		public GroupLayer (Gimp.Image image, string? name);
		[Version (since = "3.0")]
		public static unowned Gimp.GroupLayer? get_by_id (int32 layer_id);
		[Version (since = "2.10.14")]
		public unowned Gimp.Layer merge ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_image_get_type ()")]
	public class Image : GLib.Object {
		[CCode (has_construct_function = false)]
		public Image (int width, int height, Gimp.ImageBaseType type);
		public uint add_hguide (int yposition);
		[Version (since = "2.10")]
		public uint add_sample_point (int position_x, int position_y);
		public uint add_vguide (int xposition);
		[Version (since = "2.8")]
		public bool attach_parasite (Gimp.Parasite parasite);
		public bool clean_all ();
		[Version (since = "2.10")]
		public bool convert_color_profile (Gimp.ColorProfile profile, Gimp.ColorRenderingIntent intent, bool bpc);
		[Version (since = "2.10")]
		public bool convert_color_profile_from_file (GLib.File file, Gimp.ColorRenderingIntent intent, bool bpc);
		public bool convert_grayscale ();
		public bool convert_indexed (Gimp.ConvertDitherType dither_type, Gimp.ConvertPaletteType palette_type, int num_cols, bool alpha_dither, bool remove_unused, string palette);
		[Version (since = "2.10")]
		public bool convert_precision (Gimp.Precision precision);
		public bool convert_rgb ();
		[Version (since = "2.4")]
		public static bool convert_set_dither_matrix (int width, int height, GLib.Bytes matrix);
		public bool crop (int new_width, int new_height, int offx, int offy);
		public bool @delete ();
		public bool delete_guide (uint guide);
		[Version (since = "2.10")]
		public bool delete_sample_point (uint sample_point);
		[Version (since = "2.8")]
		public bool detach_parasite (string name);
		public unowned Gimp.Image duplicate ();
		[Version (since = "2.6")]
		public bool export_path_to_file (GLib.File file, Gimp.Path? path);
		[Version (since = "2.6")]
		public string export_path_to_string (Gimp.Path? path);
		public uint find_next_guide (int guide);
		[Version (since = "2.10")]
		public uint find_next_sample_point (uint sample_point);
		public unowned Gimp.Layer flatten ();
		public bool flip (Gimp.OrientationType flip_type);
		public unowned Gimp.Drawable floating_sel_attached_to ();
		[Version (since = "2.10.2")]
		public bool freeze_channels ();
		[Version (since = "2.10.2")]
		public bool freeze_layers ();
		[Version (since = "2.10.2")]
		public bool freeze_paths ();
		public Gimp.ImageBaseType get_base_type ();
		[Version (since = "3.0")]
		public static unowned Gimp.Image? get_by_id (int32 image_id);
		[Version (since = "2.8")]
		public unowned Gimp.Channel get_channel_by_name (string name);
		public unowned Gimp.Channel get_channel_by_tattoo (uint tattoo);
		[CCode (array_length = false, array_null_terminated = true)]
		public (unowned Gimp.Channel)[] get_channels ();
		[Version (since = "2.10")]
		public Gimp.ColorProfile get_color_profile ();
		public bool get_component_active (Gimp.ChannelType component);
		public bool get_component_visible (Gimp.ChannelType component);
		[Version (since = "2.10")]
		public Gimp.LayerMode get_default_new_layer_mode ();
		[Version (since = "2.10")]
		public Gimp.ColorProfile get_effective_color_profile ();
		[Version (since = "2.8")]
		public GLib.File get_exported_file ();
		[Version (since = "2.8")]
		public GLib.File get_file ();
		public unowned Gimp.Layer get_floating_sel ();
		public Gimp.OrientationType get_guide_orientation (uint guide);
		public int get_guide_position (uint guide);
		public int get_height ();
		[Version (since = "3.0")]
		public int32 get_id ();
		[Version (since = "2.8")]
		public GLib.File get_imported_file ();
		[Version (since = "2.8")]
		public int get_item_position (Gimp.Item item);
		[Version (since = "2.8")]
		public unowned Gimp.Layer get_layer_by_name (string name);
		public unowned Gimp.Layer get_layer_by_tattoo (uint tattoo);
		[CCode (array_length = false, array_null_terminated = true)]
		public (unowned Gimp.Layer)[] get_layers ();
		[Version (since = "2.10")]
		public Gimp.Metadata? get_metadata ();
		public string get_name ();
		[Version (since = "3.0")]
		public unowned Gimp.Palette get_palette ();
		[Version (since = "2.8")]
		public Gimp.Parasite get_parasite (string name);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "2.8")]
		public string[] get_parasite_list ();
		[Version (since = "2.8")]
		public unowned Gimp.Path get_path_by_name (string name);
		[Version (since = "2.6")]
		public unowned Gimp.Path get_path_by_tattoo (uint tattoo);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "2.4")]
		public (unowned Gimp.Path)[] get_paths ();
		[Version (since = "2.10")]
		public Gimp.Precision get_precision ();
		public bool get_resolution (out double xresolution, out double yresolution);
		[Version (since = "2.10")]
		public int get_sample_point_position (uint sample_point, out int position_y);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "3.0.0")]
		public (unowned Gimp.Channel)[] get_selected_channels ();
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "3.0.0")]
		public (unowned Gimp.Drawable)[] get_selected_drawables ();
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "3.0.0")]
		public (unowned Gimp.Layer)[] get_selected_layers ();
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "3.0.0")]
		public (unowned Gimp.Path)[] get_selected_paths ();
		public unowned Gimp.Selection get_selection ();
		[Version (since = "3.0")]
		public bool get_simulation_bpc ();
		[Version (since = "3.0")]
		public Gimp.ColorRenderingIntent get_simulation_intent ();
		[Version (since = "3.0")]
		public Gimp.ColorProfile get_simulation_profile ();
		public uint get_tattoo_state ();
		[Version (since = "2.2")]
		public Gdk.Pixbuf get_thumbnail (int width, int height, Gimp.PixbufTransparency alpha);
		public GLib.Bytes get_thumbnail_data (ref int width, ref int height, out int bpp);
		public unowned Gimp.Unit get_unit ();
		public int get_width ();
		[Version (since = "2.8")]
		public GLib.File get_xcf_file ();
		[Version (since = "2.4")]
		public Gegl.Color grid_get_background_color ();
		[Version (since = "2.4")]
		public Gegl.Color grid_get_foreground_color ();
		[Version (since = "2.4")]
		public bool grid_get_offset (out double xoffset, out double yoffset);
		[Version (since = "2.4")]
		public bool grid_get_spacing (out double xspacing, out double yspacing);
		[Version (since = "2.4")]
		public Gimp.GridStyle grid_get_style ();
		[Version (since = "2.4")]
		public bool grid_set_background_color (Gegl.Color bgcolor);
		[Version (since = "2.4")]
		public bool grid_set_foreground_color (Gegl.Color fgcolor);
		[Version (since = "2.4")]
		public bool grid_set_offset (double xoffset, double yoffset);
		[Version (since = "2.4")]
		public bool grid_set_spacing (double xspacing, double yspacing);
		[Version (since = "2.4")]
		public bool grid_set_style (Gimp.GridStyle style);
		[Version (since = "3.0")]
		public static bool id_is_valid (int image_id);
		[Version (since = "2.4")]
		public bool import_paths_from_file (GLib.File file, bool merge, bool scale, [CCode (array_length = false, array_null_terminated = true)] out (unowned Gimp.Path)[] paths);
		[Version (since = "2.4")]
		public bool import_paths_from_string (string string, int length, bool merge, bool scale, [CCode (array_length = false, array_null_terminated = true)] out (unowned Gimp.Path)[] paths);
		public bool insert_channel (Gimp.Channel channel, Gimp.Channel? parent, int position);
		public bool insert_layer (Gimp.Layer layer, Gimp.Layer? parent, int position);
		public bool insert_path (Gimp.Path path, Gimp.Path? parent, int position);
		public bool is_dirty ();
		[Version (since = "2.4")]
		public bool is_valid ();
		[Version (since = "2.8")]
		public bool lower_item (Gimp.Item item);
		[Version (since = "2.8")]
		public bool lower_item_to_bottom (Gimp.Item item);
		public unowned Gimp.Layer merge_down (Gimp.Layer merge_layer, Gimp.MergeType merge_type);
		public unowned Gimp.Layer merge_visible_layers (Gimp.MergeType merge_type);
		[Version (since = "2.10")]
		public static unowned Gimp.Image? metadata_load_thumbnail (GLib.File file) throws GLib.Error;
		[Version (since = "3.0")]
		public Gimp.Metadata metadata_save_filter (string mime_type, Gimp.Metadata metadata, Gimp.MetadataSaveFlags flags, GLib.File file) throws GLib.Error;
		[Version (since = "2.10")]
		public Gimp.Metadata metadata_save_prepare (string mime_type, Gimp.MetadataSaveFlags suggested_flags);
		public bool pick_color ([CCode (array_length = false, array_null_terminated = true)] Gimp.Drawable[] drawables, double x, double y, bool sample_merged, bool sample_average, double average_radius, out Gegl.Color color);
		public unowned Gimp.Layer pick_correlate_layer (int x, int y);
		[Version (since = "3.0")]
		public bool policy_color_profile (bool interactive);
		[Version (since = "3.0")]
		public bool policy_rotate (bool interactive);
		[Version (since = "2.8")]
		public bool raise_item (Gimp.Item item);
		[Version (since = "2.8")]
		public bool raise_item_to_top (Gimp.Item item);
		public bool remove_channel (Gimp.Channel channel);
		public bool remove_layer (Gimp.Layer layer);
		[Version (since = "2.4")]
		public bool remove_path (Gimp.Path path);
		[Version (since = "2.8")]
		public bool reorder_item (Gimp.Item item, Gimp.Item? parent, int position);
		public bool resize (int new_width, int new_height, int offx, int offy);
		[Version (since = "2.2")]
		public bool resize_to_layers ();
		public bool rotate (Gimp.RotationType rotate_type);
		public bool scale (int new_width, int new_height);
		[Version (since = "2.8")]
		public bool select_color (Gimp.ChannelOps operation, Gimp.Drawable drawable, Gegl.Color color);
		[Version (since = "2.8")]
		public bool select_contiguous_color (Gimp.ChannelOps operation, Gimp.Drawable drawable, double x, double y);
		[Version (since = "2.8")]
		public bool select_ellipse (Gimp.ChannelOps operation, double x, double y, double width, double height);
		[Version (since = "2.8")]
		public bool select_item (Gimp.ChannelOps operation, Gimp.Item item);
		[Version (since = "2.8")]
		public bool select_polygon (Gimp.ChannelOps operation, [CCode (array_length_cname = "num_segs", array_length_pos = 1.5, array_length_type = "gsize")] double[] segs);
		[Version (since = "2.8")]
		public bool select_rectangle (Gimp.ChannelOps operation, double x, double y, double width, double height);
		[Version (since = "2.8")]
		public bool select_round_rectangle (Gimp.ChannelOps operation, double x, double y, double width, double height, double corner_radius_x, double corner_radius_y);
		[Version (since = "2.10")]
		public bool set_color_profile (Gimp.ColorProfile? profile);
		[Version (since = "2.10")]
		public bool set_color_profile_from_file (GLib.File file);
		public bool set_component_active (Gimp.ChannelType component, bool active);
		public bool set_component_visible (Gimp.ChannelType component, bool visible);
		public bool set_file (GLib.File file);
		[Version (since = "2.10")]
		public bool set_metadata (Gimp.Metadata metadata);
		[Version (since = "3.0")]
		public unowned Gimp.Palette set_palette (Gimp.Palette new_palette);
		public bool set_resolution (double xresolution, double yresolution);
		[Version (since = "3.0.0")]
		public bool set_selected_channels ([CCode (array_length = false, array_null_terminated = true)] Gimp.Channel[] channels);
		[Version (since = "3.0.0")]
		public bool set_selected_layers ([CCode (array_length = false, array_null_terminated = true)] Gimp.Layer[] layers);
		[Version (since = "3.0.0")]
		public bool set_selected_paths ([CCode (array_length = false, array_null_terminated = true)] Gimp.Path[] paths);
		[Version (since = "3.0")]
		public bool set_simulation_bpc (bool bpc);
		[Version (since = "3.0")]
		public bool set_simulation_intent (Gimp.ColorRenderingIntent intent);
		[Version (since = "3.0")]
		public bool set_simulation_profile (Gimp.ColorProfile? profile);
		[Version (since = "3.0")]
		public bool set_simulation_profile_from_file (GLib.File file);
		public bool set_tattoo_state (uint tattoo_state);
		public bool set_unit (Gimp.Unit unit);
		[Version (since = "3.0")]
		public bool take_selected_channels (owned GLib.List<weak Gimp.Channel> channels);
		[Version (since = "3.0")]
		public bool take_selected_layers (owned GLib.List<weak Gimp.Layer> layers);
		[Version (since = "3.0")]
		public bool take_selected_paths (owned GLib.List<weak Gimp.Path> paths);
		[Version (since = "2.10.2")]
		public bool thaw_channels ();
		[Version (since = "2.10.2")]
		public bool thaw_layers ();
		[Version (since = "2.10.2")]
		public bool thaw_paths ();
		public bool undo_disable ();
		public bool undo_enable ();
		public bool undo_freeze ();
		public bool undo_group_end ();
		public bool undo_group_start ();
		public bool undo_is_enabled ();
		public bool undo_thaw ();
		public bool unset_active_channel ();
		[CCode (has_construct_function = false)]
		[Version (since = "2.10")]
		public Image.with_precision (int width, int height, Gimp.ImageBaseType type, Gimp.Precision precision);
		public int id { get; construct; }
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_image_procedure_get_type ()")]
	public class ImageProcedure : Gimp.Procedure {
		[CCode (has_construct_function = false, type = "GimpProcedure*")]
		[Version (since = "3.0")]
		public ImageProcedure (Gimp.PlugIn plug_in, string name, Gimp.PDBProcType proc_type, owned Gimp.RunImageFunc run_func);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gimp_int32_array_get_type ()")]
	[Compact]
	public class Int32Array {
		[CCode (array_length_pos = 1.1, array_length_type = "gsize")]
		public static unowned int32[] get_values (Gimp.Array array);
		public static void set_values (Gimp.Array array, [CCode (array_length_cname = "length", array_length_pos = 2.5, array_length_type = "gsize")] int32[] values, bool static_data);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_item_get_type ()")]
	public abstract class Item : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Item ();
		[Version (since = "2.8")]
		public bool attach_parasite (Gimp.Parasite parasite);
		[Version (since = "2.8")]
		public bool @delete ();
		[Version (since = "2.8")]
		public bool detach_parasite (string name);
		[Version (since = "3.0")]
		public static unowned Gimp.Item? get_by_id (int32 item_id);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "2.8")]
		public (unowned Gimp.Item)[] get_children ();
		[Version (since = "2.10")]
		public Gimp.ColorTag get_color_tag ();
		[Version (since = "2.10")]
		public bool get_expanded ();
		[Version (since = "3.0")]
		public int32 get_id ();
		[Version (since = "2.8")]
		public unowned Gimp.Image get_image ();
		[Version (since = "2.8")]
		public bool get_lock_content ();
		[Version (since = "2.10")]
		public bool get_lock_position ();
		[Version (since = "3.0")]
		public bool get_lock_visibility ();
		[Version (since = "2.8")]
		public string get_name ();
		[Version (since = "2.8")]
		public Gimp.Parasite get_parasite (string name);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "2.8")]
		public string[] get_parasite_list ();
		[Version (since = "2.8")]
		public unowned Gimp.Item get_parent ();
		[Version (since = "2.8")]
		public uint get_tattoo ();
		[Version (since = "2.8")]
		public bool get_visible ();
		[Version (since = "3.0")]
		public static bool id_is_channel (int item_id);
		[Version (since = "3.0")]
		public static bool id_is_drawable (int item_id);
		[Version (since = "3.0")]
		public static bool id_is_group_layer (int item_id);
		[Version (since = "3.0")]
		public static bool id_is_layer (int item_id);
		[Version (since = "3.0")]
		public static bool id_is_layer_mask (int item_id);
		[Version (since = "3.0")]
		public static bool id_is_path (int item_id);
		[Version (since = "3.0")]
		public static bool id_is_selection (int item_id);
		[Version (since = "3.0")]
		public static bool id_is_text_layer (int item_id);
		[Version (since = "3.0")]
		public static bool id_is_valid (int item_id);
		[Version (since = "2.8")]
		public bool is_channel ();
		[Version (since = "2.8")]
		public bool is_drawable ();
		[Version (since = "2.8")]
		public bool is_group ();
		[Version (since = "3.0")]
		public bool is_group_layer ();
		[Version (since = "2.8")]
		public bool is_layer ();
		[Version (since = "2.8")]
		public bool is_layer_mask ();
		[Version (since = "2.8")]
		public bool is_path ();
		[Version (since = "2.8")]
		public bool is_selection ();
		[Version (since = "2.8")]
		public bool is_text_layer ();
		[Version (since = "2.8")]
		public bool is_valid ();
		[Version (since = "2.10")]
		public bool set_color_tag (Gimp.ColorTag color_tag);
		[Version (since = "2.10")]
		public bool set_expanded (bool expanded);
		[Version (since = "2.8")]
		public bool set_lock_content (bool lock_content);
		[Version (since = "2.10")]
		public bool set_lock_position (bool lock_position);
		[Version (since = "3.0")]
		public bool set_lock_visibility (bool lock_visibility);
		[Version (since = "2.8")]
		public bool set_name (string name);
		[Version (since = "2.8")]
		public bool set_tattoo (uint tattoo);
		[Version (since = "2.8")]
		public bool set_visible (bool visible);
		[Version (since = "2.8")]
		public unowned Gimp.Item transform_2d (double source_x, double source_y, double scale_x, double scale_y, double angle, double dest_x, double dest_y);
		[Version (since = "2.8")]
		public unowned Gimp.Item transform_flip (double x0, double y0, double x1, double y1);
		[Version (since = "2.2")]
		public unowned Gimp.Item transform_flip_simple (Gimp.OrientationType flip_type, bool auto_center, double axis);
		[Version (since = "2.8")]
		public unowned Gimp.Item transform_matrix (double coeff_0_0, double coeff_0_1, double coeff_0_2, double coeff_1_0, double coeff_1_1, double coeff_1_2, double coeff_2_0, double coeff_2_1, double coeff_2_2);
		[Version (since = "2.8")]
		public unowned Gimp.Item transform_perspective (double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3);
		[Version (since = "2.8")]
		public unowned Gimp.Item transform_rotate (double angle, bool auto_center, double center_x, double center_y);
		[Version (since = "2.8")]
		public unowned Gimp.Item transform_rotate_simple (Gimp.RotationType rotate_type, bool auto_center, double center_x, double center_y);
		[Version (since = "2.8")]
		public unowned Gimp.Item transform_scale (double x0, double y0, double x1, double y1);
		[Version (since = "2.8")]
		public unowned Gimp.Item transform_shear (Gimp.OrientationType shear_type, double magnitude);
		[Version (since = "2.10")]
		public unowned Gimp.Item transform_translate (double off_x, double off_y);
		public int id { get; construct; }
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_layer_get_type ()")]
	public class Layer : Gimp.Drawable {
		[CCode (has_construct_function = false)]
		[Version (since = "3.0")]
		public Layer (Gimp.Image image, string? name, int width, int height, Gimp.ImageType type, double opacity, Gimp.LayerMode mode);
		public bool add_alpha ();
		public bool add_mask (Gimp.LayerMask mask);
		[Version (since = "3.0")]
		public virtual unowned Gimp.Layer copy ();
		public unowned Gimp.LayerMask create_mask (Gimp.AddMaskType mask_type);
		[Version (since = "2.4")]
		public bool flatten ();
		[CCode (has_construct_function = false)]
		public Layer.from_drawable (Gimp.Drawable drawable, Gimp.Image dest_image);
		[Version (since = "2.2")]
		public static unowned Gimp.Layer from_mask (Gimp.LayerMask mask);
		[CCode (has_construct_function = false)]
		[Version (since = "2.2")]
		public Layer.from_pixbuf (Gimp.Image image, string name, Gdk.Pixbuf pixbuf, double opacity, Gimp.LayerMode mode, double progress_start, double progress_end);
		[CCode (has_construct_function = false)]
		[Version (since = "2.8")]
		public Layer.from_surface (Gimp.Image image, string name, Cairo.Surface surface, double progress_start, double progress_end);
		[CCode (has_construct_function = false)]
		[Version (since = "2.6")]
		public Layer.from_visible (Gimp.Image image, Gimp.Image dest_image, string name);
		public bool get_apply_mask ();
		[Version (since = "2.10")]
		public Gimp.LayerColorSpace get_blend_space ();
		[Version (since = "3.0")]
		public static unowned Gimp.Layer? get_by_id (int32 layer_id);
		[Version (since = "2.10")]
		public Gimp.LayerCompositeMode get_composite_mode ();
		[Version (since = "2.10")]
		public Gimp.LayerColorSpace get_composite_space ();
		public bool get_edit_mask ();
		public bool get_lock_alpha ();
		public unowned Gimp.LayerMask get_mask ();
		public Gimp.LayerMode get_mode ();
		public double get_opacity ();
		public bool get_show_mask ();
		public bool is_floating_sel ();
		public bool remove_mask (Gimp.MaskApplyMode mode);
		public bool resize (int new_width, int new_height, int offx, int offy);
		public bool resize_to_image_size ();
		public bool scale (int new_width, int new_height, bool local_origin);
		public bool set_apply_mask (bool apply_mask);
		[Version (since = "2.10")]
		public bool set_blend_space (Gimp.LayerColorSpace blend_space);
		[Version (since = "2.10")]
		public bool set_composite_mode (Gimp.LayerCompositeMode composite_mode);
		[Version (since = "2.10")]
		public bool set_composite_space (Gimp.LayerColorSpace composite_space);
		public bool set_edit_mask (bool edit_mask);
		public bool set_lock_alpha (bool lock_alpha);
		public bool set_mode (Gimp.LayerMode mode);
		public bool set_offsets (int offx, int offy);
		public bool set_opacity (double opacity);
		public bool set_show_mask (bool show_mask);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_layer_mask_get_type ()")]
	public class LayerMask : Gimp.Channel {
		[CCode (has_construct_function = false)]
		protected LayerMask ();
		[Version (since = "3.0")]
		public static unowned Gimp.LayerMask? get_by_id (int32 layer_mask_id);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_load_procedure_get_type ()")]
	public class LoadProcedure : Gimp.FileProcedure {
		[CCode (has_construct_function = false, type = "GimpProcedure*")]
		[Version (since = "3.0")]
		public LoadProcedure (Gimp.PlugIn plug_in, string name, Gimp.PDBProcType proc_type, owned Gimp.RunLoadFunc run_func);
		[Version (since = "3.0")]
		public bool get_handles_raw ();
		[Version (since = "3.0")]
		public unowned string get_thumbnail_loader ();
		[Version (since = "3.0")]
		public void set_handles_raw (bool handles_raw);
		[Version (since = "3.0")]
		public void set_thumbnail_loader (string thumbnail_proc);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gimp_matrix2_get_type ()")]
	[Compact]
	public class Matrix2 {
		[CCode (array_length = false)]
		public weak double coeff[4];
		[Version (since = "2.10.16")]
		public double determinant ();
		public void identity ();
		[Version (since = "2.10.16")]
		public void invert ();
		public void mult (Gimp.Matrix2 right);
		[Version (since = "2.10.16")]
		public void transform_point (double x, double y, out double newx, out double newy);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gimp_matrix3_get_type ()")]
	[Compact]
	public class Matrix3 {
		[CCode (array_length = false)]
		public weak double coeff[9];
		public void affine (double a, double b, double c, double d, double e, double f);
		public double determinant ();
		[Version (since = "2.10.16")]
		public bool equal (Gimp.Matrix3 matrix2);
		public void identity ();
		public void invert ();
		[Version (since = "2.4")]
		public bool is_affine ();
		public bool is_diagonal ();
		public bool is_identity ();
		public bool is_simple ();
		public void mult (Gimp.Matrix3 right);
		public void rotate (double theta);
		public void scale (double x, double y);
		public void transform_point (double x, double y, double newx, double newy);
		public void translate (double x, double y);
		public void xshear (double amount);
		public void yshear (double amount);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_memsize_get_type ()")]
	public class Memsize {
		[CCode (has_construct_function = false)]
		protected Memsize ();
		[Version (since = "2.2")]
		public static bool deserialize (string string, out uint64 memsize);
		[Version (since = "2.2")]
		public static string serialize (uint64 memsize);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_metadata_get_type ()")]
	public class Metadata : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "2.10")]
		public Metadata ();
		public void add_xmp_history (string state_status);
		[Version (since = "2.10")]
		public static Gimp.Metadata deserialize (string metadata_xml);
		[Version (since = "2.10")]
		public Gimp.Metadata duplicate ();
		[Version (since = "2.10")]
		public Gimp.MetadataColorspace get_colorspace ();
		[Version (since = "2.10")]
		public static string get_guid ();
		[Version (since = "2.10")]
		public bool get_resolution (out double xres, out double yres, out Gimp.Unit unit);
		[Version (since = "2.10")]
		public static bool is_tag_supported (string tag, string mime_type);
		[Version (since = "2.10")]
		public static Gimp.Metadata load_from_file (GLib.File file) throws GLib.Error;
		[Version (since = "2.10")]
		public bool save_to_file (GLib.File file) throws GLib.Error;
		[Version (since = "2.10")]
		public string serialize ();
		[Version (since = "2.10")]
		public void set_bits_per_sample (int bits_per_sample);
		[Version (since = "2.10")]
		public void set_colorspace (Gimp.MetadataColorspace colorspace);
		[Version (since = "2.10")]
		public bool set_from_exif ([CCode (array_length_cname = "exif_data_length", array_length_pos = 1.1)] uint8[] exif_data) throws GLib.Error;
		[Version (since = "2.10")]
		public bool set_from_iptc ([CCode (array_length_cname = "iptc_data_length", array_length_pos = 1.1)] uint8[] iptc_data) throws GLib.Error;
		[Version (since = "2.10")]
		public bool set_from_xmp ([CCode (array_length_cname = "xmp_data_length", array_length_pos = 1.1)] uint8[] xmp_data) throws GLib.Error;
		[Version (since = "2.10")]
		public void set_pixel_size (int width, int height);
		[Version (since = "2.10")]
		public void set_resolution (double xres, double yres, Gimp.Unit unit);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_module_get_type ()")]
	public class Module : GLib.TypeModule, GLib.TypePlugin {
		[CCode (has_construct_function = false)]
		public Module (GLib.File file, bool auto_load, bool verbose);
		[Version (since = "2.8")]
		public static GLib.Quark error_quark ();
		[Version (since = "3.0")]
		public bool get_auto_load ();
		[Version (since = "3.0")]
		public unowned GLib.File get_file ();
		[Version (since = "3.0")]
		public unowned Gimp.ModuleInfo? get_info ();
		[Version (since = "3.0")]
		public unowned string get_last_error ();
		[Version (since = "3.0")]
		public Gimp.ModuleState get_state ();
		[Version (since = "3.0")]
		public bool is_loaded ();
		[Version (since = "3.0")]
		public bool is_on_disk ();
		[NoWrapper]
		public virtual void modified ();
		public static unowned Gimp.ModuleInfo? query (GLib.TypeModule module);
		public bool query_module ();
		public static bool register (GLib.TypeModule module);
		[Version (since = "3.0")]
		public void set_auto_load (bool auto_load);
		public bool auto_load { get; set; }
		[NoAccessorMethod]
		public bool on_disk { get; }
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_module_db_get_type ()")]
	public class ModuleDB : GLib.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		public ModuleDB (bool verbose);
		public unowned string get_load_inhibit ();
		[Version (since = "3.0")]
		public bool get_verbose ();
		public void load (string module_path);
		public void refresh (string module_path);
		public void set_load_inhibit (string load_inhibit);
		[Version (since = "3.0")]
		public void set_verbose (bool verbose);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_pdb_get_type ()")]
	public class PDB : GLib.Object {
		[CCode (has_construct_function = false)]
		protected PDB ();
		[Version (since = "3.0")]
		public bool dump_to_file (GLib.File file);
		[Version (since = "3.0")]
		public unowned string get_last_error ();
		[Version (since = "3.0")]
		public Gimp.PDBStatusType get_last_status ();
		[Version (since = "3.0")]
		public unowned Gimp.Procedure? lookup_procedure (string procedure_name);
		[Version (since = "3.0")]
		public bool procedure_exists (string procedure_name);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "3.0")]
		public string[] query_procedures (string name, string blurb, string help, string help_id, string authors, string copyright, string date, string proc_type);
		[Version (since = "3.0")]
		public string temp_procedure_name ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_palette_get_type ()")]
	public class Palette : Gimp.Resource, Gimp.ConfigInterface {
		[CCode (has_construct_function = false)]
		[Version (since = "2.2")]
		public Palette (string name);
		[Version (since = "2.2")]
		public bool add_entry (string entry_name, Gegl.Color color, out int entry_num);
		[Version (since = "2.2")]
		public bool delete_entry (int entry_num);
		[Version (since = "3.0")]
		public static unowned Gimp.Palette? get_by_name (string name);
		[Version (since = "2.2")]
		public int get_color_count ();
		[CCode (array_length_pos = 2.1, array_length_type = "gsize")]
		[Version (since = "3.0")]
		public uint8[] get_colormap (Babl.Object format, out int num_colors);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "2.6")]
		public Gegl.Color[] get_colors ();
		[Version (since = "2.4")]
		public int get_columns ();
		[Version (since = "2.2")]
		public Gegl.Color get_entry_color (int entry_num);
		[Version (since = "2.2")]
		public bool get_entry_name (int entry_num, out string entry_name);
		[Version (since = "3.0")]
		public bool set_colormap (Babl.Object format, uint8 colormap, size_t num_bytes);
		[Version (since = "2.4")]
		public bool set_columns (int columns);
		[Version (since = "2.2")]
		public bool set_entry_color (int entry_num, Gegl.Color color);
		[Version (since = "2.2")]
		public bool set_entry_name (int entry_num, string entry_name);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_array_get_type ()")]
	public class ParamArray : GLib.ParamSpecBoxed {
		[CCode (has_construct_function = false)]
		protected ParamArray ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_brush_get_type ()")]
	public class ParamBrush : Gimp.ParamResource {
		[CCode (has_construct_function = false)]
		protected ParamBrush ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_channel_get_type ()")]
	public class ParamChannel : Gimp.ParamDrawable {
		[CCode (has_construct_function = false)]
		protected ParamChannel ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_choice_get_type ()")]
	public class ParamChoice : GLib.ParamSpecString {
		[CCode (has_construct_function = false)]
		protected ParamChoice ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_color_get_type ()")]
	public class ParamColor : Gimp.ParamObject {
		[CCode (has_construct_function = false)]
		protected ParamColor ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_config_path_get_type ()")]
	public class ParamConfigPath : GLib.ParamSpecString {
		[CCode (has_construct_function = false)]
		protected ParamConfigPath ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_core_object_array_get_type ()")]
	public class ParamCoreObjectArray : GLib.ParamSpecBoxed {
		[CCode (has_construct_function = false)]
		protected ParamCoreObjectArray ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_display_get_type ()")]
	public class ParamDisplay : GLib.ParamSpecObject {
		[CCode (has_construct_function = false)]
		protected ParamDisplay ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_double_array_get_type ()")]
	public class ParamDoubleArray : Gimp.ParamArray {
		[CCode (has_construct_function = false)]
		protected ParamDoubleArray ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_drawable_get_type ()")]
	public class ParamDrawable : Gimp.ParamItem {
		[CCode (has_construct_function = false)]
		protected ParamDrawable ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_export_options_get_type ()")]
	public class ParamExportOptions : GLib.ParamSpecObject {
		[CCode (has_construct_function = false)]
		protected ParamExportOptions ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_font_get_type ()")]
	public class ParamFont : Gimp.ParamResource {
		[CCode (has_construct_function = false)]
		protected ParamFont ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_gradient_get_type ()")]
	public class ParamGradient : Gimp.ParamResource {
		[CCode (has_construct_function = false)]
		protected ParamGradient ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_group_layer_get_type ()")]
	public class ParamGroupLayer : Gimp.ParamLayer {
		[CCode (has_construct_function = false)]
		protected ParamGroupLayer ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_image_get_type ()")]
	public class ParamImage : GLib.ParamSpecObject {
		[CCode (has_construct_function = false)]
		protected ParamImage ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_int32_array_get_type ()")]
	public class ParamInt32Array : Gimp.ParamArray {
		[CCode (has_construct_function = false)]
		protected ParamInt32Array ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_item_get_type ()")]
	public class ParamItem : GLib.ParamSpecObject {
		[CCode (has_construct_function = false)]
		protected ParamItem ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_layer_get_type ()")]
	public class ParamLayer : Gimp.ParamDrawable {
		[CCode (has_construct_function = false)]
		protected ParamLayer ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_layer_mask_get_type ()")]
	public class ParamLayerMask : Gimp.ParamChannel {
		[CCode (has_construct_function = false)]
		protected ParamLayerMask ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_matrix2_get_type ()")]
	public class ParamMatrix2 : GLib.ParamSpecBoxed {
		[CCode (has_construct_function = false)]
		protected ParamMatrix2 ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_matrix3_get_type ()")]
	public class ParamMatrix3 : GLib.ParamSpecBoxed {
		[CCode (has_construct_function = false)]
		protected ParamMatrix3 ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_memsize_get_type ()")]
	public class ParamMemsize : GLib.ParamSpecUInt64 {
		[CCode (has_construct_function = false)]
		protected ParamMemsize ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_object_get_type ()")]
	public abstract class ParamObject : GLib.ParamSpecObject {
		[CCode (has_construct_function = false)]
		protected ParamObject ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_palette_get_type ()")]
	public class ParamPalette : Gimp.ParamResource {
		[CCode (has_construct_function = false)]
		protected ParamPalette ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_parasite_get_type ()")]
	public class ParamParasite : GLib.ParamSpecBoxed {
		[CCode (has_construct_function = false)]
		protected ParamParasite ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_path_get_type ()")]
	public class ParamPath : Gimp.ParamItem {
		[CCode (has_construct_function = false)]
		protected ParamPath ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_pattern_get_type ()")]
	public class ParamPattern : Gimp.ParamResource {
		[CCode (has_construct_function = false)]
		protected ParamPattern ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_resource_get_type ()")]
	public class ParamResource : Gimp.ParamObject {
		[CCode (has_construct_function = false)]
		protected ParamResource ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_selection_get_type ()")]
	public class ParamSelection : Gimp.ParamChannel {
		[CCode (has_construct_function = false)]
		protected ParamSelection ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", has_type_id = false)]
	[Compact]
	public class ParamSpecColor {
		public static GLib.ParamSpec from_string (string name, string nick, string blurb, bool has_alpha, string default_color_string, GLib.ParamFlags flags);
		[Version (since = "2.4")]
		public static bool has_alpha (GLib.ParamSpec pspec);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_text_layer_get_type ()")]
	public class ParamTextLayer : Gimp.ParamLayer {
		[CCode (has_construct_function = false)]
		protected ParamTextLayer ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_unit_get_type ()")]
	public class ParamUnit : Gimp.ParamObject {
		[CCode (has_construct_function = false)]
		protected ParamUnit ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_param_value_array_get_type ()")]
	public class ParamValueArray : GLib.ParamSpecBoxed {
		[CCode (has_construct_function = false)]
		protected ParamValueArray ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gimp_parasite_get_type ()")]
	[Compact]
	public class Parasite {
		[CCode (array_length_cname = "size", array_length_type = "guint32")]
		public weak void*[] data;
		public uint32 flags;
		public weak string name;
		public uint32 size;
		[CCode (has_construct_function = false)]
		public Parasite (string name, uint32 flags, [CCode (array_length_cname = "size", array_length_pos = 2.5, array_length_type = "guint32")] char[]? data);
		public bool compare (Gimp.Parasite b);
		public Gimp.Parasite copy ();
		public void free ();
		[CCode (array_length_pos = 0.1, array_length_type = "guint32")]
		public unowned char[] get_data ();
		public ulong get_flags ();
		public unowned string get_name ();
		public bool has_flag (ulong flag);
		public bool is_persistent ();
		public bool is_type (string name);
		public bool is_undoable ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_path_get_type ()")]
	public class Path : Gimp.Item {
		[CCode (has_construct_function = false)]
		[Version (since = "2.4")]
		public Path (Gimp.Image image, string name);
		[Version (since = "2.4")]
		public bool bezier_stroke_conicto (int stroke_id, double x0, double y0, double x1, double y1);
		[Version (since = "2.4")]
		public bool bezier_stroke_cubicto (int stroke_id, double x0, double y0, double x1, double y1, double x2, double y2);
		[Version (since = "2.4")]
		public bool bezier_stroke_lineto (int stroke_id, double x0, double y0);
		[Version (since = "2.4")]
		public int bezier_stroke_new_ellipse (double x0, double y0, double radius_x, double radius_y, double angle);
		[Version (since = "2.4")]
		public int bezier_stroke_new_moveto (double x0, double y0);
		[Version (since = "2.6")]
		public unowned Gimp.Path copy ();
		public static void free (GLib.List<string> path);
		[CCode (has_construct_function = false)]
		[Version (since = "2.6")]
		public Path.from_text_layer (Gimp.Image image, Gimp.Layer layer);
		[Version (since = "3.0")]
		public static unowned Gimp.Path? get_by_id (int32 path_id);
		[CCode (array_length_pos = 0.1, array_length_type = "gsize")]
		[Version (since = "2.4")]
		public int32[] get_strokes ();
		public static string get_user_writable_dir (GLib.List<string> path);
		public static GLib.List<string> parse (string path, int max_paths, bool check, out GLib.List<string> check_failed);
		[Version (since = "2.4")]
		public bool remove_stroke (int stroke_id);
		[Version (since = "2.4")]
		public bool stroke_close (int stroke_id);
		[Version (since = "2.4")]
		public bool stroke_flip (int stroke_id, Gimp.OrientationType flip_type, double axis);
		[Version (since = "2.4")]
		public bool stroke_flip_free (int stroke_id, double x1, double y1, double x2, double y2);
		[Version (since = "2.4")]
		public double stroke_get_length (int stroke_id, double precision);
		[Version (since = "2.4")]
		public bool stroke_get_point_at_dist (int stroke_id, double dist, double precision, out double x_point, out double y_point, out double slope, out bool valid);
		[Version (since = "2.4")]
		public Gimp.PathStrokeType stroke_get_points (int stroke_id, [CCode (array_length_cname = "num_points", array_length_pos = 1.5, array_length_type = "gsize")] out double[] controlpoints, out bool closed);
		[CCode (array_length_pos = 2.5, array_length_type = "gsize")]
		[Version (since = "2.4")]
		public double[] stroke_interpolate (int stroke_id, double precision, out bool closed);
		[Version (since = "2.4")]
		public int stroke_new_from_points (Gimp.PathStrokeType type, [CCode (array_length_cname = "num_points", array_length_pos = 1.5, array_length_type = "gsize")] double[] controlpoints, bool closed);
		[Version (since = "3.0")]
		public bool stroke_reverse (int stroke_id);
		[Version (since = "2.4")]
		public bool stroke_rotate (int stroke_id, double center_x, double center_y, double angle);
		[Version (since = "2.4")]
		public bool stroke_scale (int stroke_id, double scale_x, double scale_y);
		[Version (since = "2.4")]
		public bool stroke_translate (int stroke_id, double off_x, double off_y);
		public static string to_str (GLib.List<string> path);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_pattern_get_type ()")]
	public class Pattern : Gimp.Resource, Gimp.ConfigInterface {
		[CCode (has_construct_function = false)]
		protected Pattern ();
		public Gegl.Buffer get_buffer (int max_width, int max_height, Babl.Object format);
		[Version (since = "3.0")]
		public static unowned Gimp.Pattern? get_by_name (string name);
		[Version (since = "2.2")]
		public bool get_info (out int width, out int height, out int bpp);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_plug_in_get_type ()")]
	[Version (since = "3.0")]
	public class PlugIn : GLib.Object {
		[CCode (has_construct_function = false)]
		protected PlugIn ();
		public void add_menu_branch (string menu_path, string menu_label);
		public void add_temp_procedure (Gimp.Procedure procedure);
		[NoWrapper]
		public virtual Gimp.Procedure create_procedure (string procedure_name);
		public static unowned string directory ();
		public static GLib.Quark error_quark ();
		public Gimp.PDBErrorHandler get_pdb_error_handler ();
		public unowned Gimp.Procedure? get_temp_procedure (string procedure_name);
		public unowned GLib.List<Gimp.Procedure> get_temp_procedures ();
		[NoWrapper]
		public virtual GLib.List<string> init_procedures ();
		public void persistent_enable ();
		public void persistent_process (uint timeout);
		[NoWrapper]
		public virtual GLib.List<string> query_procedures ();
		[NoWrapper]
		public virtual void quit ();
		public void remove_temp_procedure (string procedure_name);
		public void set_help_domain (string domain_name, GLib.File domain_uri);
		[NoWrapper]
		public virtual bool set_i18n (string procedure_name, out string? gettext_domain, out string? catalog_dir);
		public void set_pdb_error_handler (Gimp.PDBErrorHandler handler);
		[NoAccessorMethod]
		public string program_name { construct; }
		[NoAccessorMethod]
		public GLib.IOChannel read_channel { owned get; construct; }
		[NoAccessorMethod]
		public GLib.IOChannel write_channel { owned get; construct; }
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_procedure_get_type ()")]
	public class Procedure : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "3.0")]
		public Procedure (Gimp.PlugIn plug_in, string name, Gimp.PDBProcType proc_type, owned Gimp.RunFunc run_func);
		[Version (since = "3.0")]
		public void add_boolean_argument (string name, string nick, string blurb, bool value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_boolean_aux_argument (string name, string nick, string blurb, bool value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_boolean_return_value (string name, string nick, string blurb, bool value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_brush_argument (string name, string nick, string blurb, bool none_ok, Gimp.Brush? default_value, bool default_to_context, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_brush_aux_argument (string name, string nick, string blurb, Gimp.Brush? default_value, bool default_to_context, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_brush_return_value (string name, string nick, string blurb, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_bytes_argument (string name, string nick, string blurb, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_bytes_aux_argument (string name, string nick, string blurb, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_bytes_return_value (string name, string nick, string blurb, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_channel_argument (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_channel_aux_argument (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_channel_return_value (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_choice_argument (string name, string nick, string blurb, owned Gimp.Choice choice, string value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_choice_aux_argument (string name, string nick, string blurb, Gimp.Choice choice, string value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_choice_return_value (string name, string nick, string blurb, Gimp.Choice choice, string value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_color_argument (string name, string nick, string blurb, bool has_alpha, Gegl.Color value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_color_aux_argument (string name, string nick, string blurb, bool has_alpha, Gegl.Color value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_color_from_string_argument (string name, string nick, string blurb, bool has_alpha, string value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_color_from_string_aux_argument (string name, string nick, string blurb, bool has_alpha, string value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_color_from_string_return_value (string name, string nick, string blurb, bool has_alpha, string value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_color_return_value (string name, string nick, string blurb, bool has_alpha, Gegl.Color value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_core_object_array_argument (string name, string nick, string blurb, GLib.Type object_type, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_core_object_array_aux_argument (string name, string nick, string blurb, GLib.Type object_type, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_core_object_array_return_value (string name, string nick, string blurb, GLib.Type object_type, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_display_argument (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_display_aux_argument (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_display_return_value (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_double_argument (string name, string nick, string blurb, double min, double max, double value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_double_array_argument (string name, string nick, string blurb, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_double_array_aux_argument (string name, string nick, string blurb, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_double_array_return_value (string name, string nick, string blurb, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_double_aux_argument (string name, string nick, string blurb, double min, double max, double value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_double_return_value (string name, string nick, string blurb, double min, double max, double value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_drawable_argument (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_drawable_aux_argument (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_drawable_return_value (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_enum_argument (string name, string nick, string blurb, GLib.Type enum_type, int value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_enum_aux_argument (string name, string nick, string blurb, GLib.Type enum_type, int value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_enum_return_value (string name, string nick, string blurb, GLib.Type enum_type, int value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_file_argument (string name, string nick, string blurb, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_file_aux_argument (string name, string nick, string blurb, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_file_return_value (string name, string nick, string blurb, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_font_argument (string name, string nick, string blurb, bool none_ok, Gimp.Font? default_value, bool default_to_context, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_font_aux_argument (string name, string nick, string blurb, Gimp.Font? default_value, bool default_to_context, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_font_return_value (string name, string nick, string blurb, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_gradient_argument (string name, string nick, string blurb, bool none_ok, Gimp.Gradient? default_value, bool default_to_context, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_gradient_aux_argument (string name, string nick, string blurb, Gimp.Gradient? default_value, bool default_to_context, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_gradient_return_value (string name, string nick, string blurb, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_group_layer_argument (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_group_layer_aux_argument (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_group_layer_return_value (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_image_argument (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_image_aux_argument (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_image_return_value (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_int32_array_argument (string name, string nick, string blurb, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_int32_array_aux_argument (string name, string nick, string blurb, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_int32_array_return_value (string name, string nick, string blurb, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_int_argument (string name, string nick, string blurb, int min, int max, int value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_int_aux_argument (string name, string nick, string blurb, int min, int max, int value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_int_return_value (string name, string nick, string blurb, int min, int max, int value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_item_argument (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_item_aux_argument (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_item_return_value (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_layer_argument (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_layer_aux_argument (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_layer_mask_argument (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_layer_mask_aux_argument (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_layer_mask_return_value (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_layer_return_value (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_menu_path (string menu_path);
		[Version (since = "3.0")]
		public void add_palette_argument (string name, string nick, string blurb, bool none_ok, Gimp.Palette? default_value, bool default_to_context, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_palette_aux_argument (string name, string nick, string blurb, Gimp.Palette? default_value, bool default_to_context, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_palette_return_value (string name, string nick, string blurb, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_param_argument (string name, string nick, string blurb, GLib.Type param_type, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_param_aux_argument (string name, string nick, string blurb, GLib.Type param_type, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_param_return_value (string name, string nick, string blurb, GLib.Type param_type, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_parasite_argument (string name, string nick, string blurb, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_parasite_aux_argument (string name, string nick, string blurb, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_parasite_return_value (string name, string nick, string blurb, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_path_argument (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_path_aux_argument (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_path_return_value (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_pattern_argument (string name, string nick, string blurb, bool none_ok, Gimp.Pattern? default_value, bool default_to_context, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_pattern_aux_argument (string name, string nick, string blurb, Gimp.Pattern? default_value, bool default_to_context, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_pattern_return_value (string name, string nick, string blurb, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_resource_argument (string name, string nick, string blurb, bool none_ok, Gimp.Resource? default_value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_resource_aux_argument (string name, string nick, string blurb, Gimp.Resource? default_value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_resource_return_value (string name, string nick, string blurb, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_selection_argument (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_selection_aux_argument (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_selection_return_value (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_string_argument (string name, string nick, string blurb, string value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_string_array_argument (string name, string nick, string blurb, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_string_array_aux_argument (string name, string nick, string blurb, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_string_array_return_value (string name, string nick, string blurb, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_string_aux_argument (string name, string nick, string blurb, string value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_string_return_value (string name, string nick, string blurb, string value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_text_layer_argument (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_text_layer_aux_argument (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_text_layer_return_value (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_uint_argument (string name, string nick, string blurb, uint min, uint max, uint value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_uint_aux_argument (string name, string nick, string blurb, uint min, uint max, uint value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_uint_return_value (string name, string nick, string blurb, uint min, uint max, uint value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_unit_argument (string name, string nick, string blurb, bool show_pixels, bool show_percent, Gimp.Unit value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_unit_aux_argument (string name, string nick, string blurb, bool show_pixels, bool show_percent, Gimp.Unit value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public void add_unit_return_value (string name, string nick, string blurb, bool show_pixels, bool show_percent, Gimp.Unit value, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public Gimp.ProcedureConfig create_config ();
		[Version (since = "3.0")]
		public unowned GLib.ParamSpec find_argument (string name);
		[Version (since = "3.0")]
		public unowned GLib.ParamSpec find_aux_argument (string name);
		[Version (since = "3.0")]
		public unowned GLib.ParamSpec find_return_value (string name);
		[Version (since = "3.0")]
		public Gimp.ArgumentSync get_argument_sync (string arg_name);
		[CCode (array_length_pos = 0.1)]
		[Version (since = "3.0")]
		public unowned GLib.ParamSpec[] get_arguments ();
		[Version (since = "3.0")]
		public unowned string get_authors ();
		[CCode (array_length_pos = 0.1)]
		[Version (since = "3.0")]
		public unowned GLib.ParamSpec[] get_aux_arguments ();
		[Version (since = "3.0")]
		public unowned string get_blurb ();
		[Version (since = "3.0")]
		public unowned string get_copyright ();
		[Version (since = "3.0")]
		public unowned string get_date ();
		[Version (since = "3.0")]
		public unowned string get_help ();
		[Version (since = "3.0")]
		public unowned string get_help_id ();
		[Version (since = "3.0")]
		public unowned GLib.File? get_icon_file ();
		[Version (since = "3.0")]
		public unowned string? get_icon_name ();
		[Version (since = "3.0")]
		public unowned Gdk.Pixbuf? get_icon_pixbuf ();
		[Version (since = "3.0")]
		public Gimp.IconType get_icon_type ();
		[Version (since = "3.0")]
		public unowned string get_image_types ();
		[Version (since = "3.0")]
		public unowned string get_menu_label ();
		[Version (since = "3.0")]
		public unowned GLib.List<string> get_menu_paths ();
		[Version (since = "3.0")]
		public unowned string get_name ();
		[Version (since = "3.0")]
		public unowned Gimp.PlugIn get_plug_in ();
		[Version (since = "3.0")]
		public Gimp.PDBProcType get_proc_type ();
		[CCode (array_length_pos = 0.1)]
		[Version (since = "3.0")]
		public unowned GLib.ParamSpec[] get_return_values ();
		[Version (since = "3.0")]
		public int get_sensitivity_mask ();
		[NoWrapper]
		public virtual void install ();
		[Version (since = "3.0")]
		public Gimp.ValueArray new_return_values (Gimp.PDBStatusType status, owned GLib.Error? error);
		[Version (since = "3.0")]
		public void persistent_ready ();
		[NoWrapper]
		public virtual Gimp.ValueArray run (Gimp.ValueArray args);
		[Version (since = "3.0")]
		public Gimp.ValueArray run_config (Gimp.ProcedureConfig? config);
		[Version (since = "3.0")]
		public void set_argument_sync (string arg_name, Gimp.ArgumentSync sync);
		[Version (since = "3.0")]
		public void set_attribution (string authors, string copyright, string date);
		[Version (since = "3.0")]
		public void set_documentation (string blurb, string? help, string? help_id);
		[Version (since = "3.0")]
		public void set_icon_file (GLib.File? file);
		[Version (since = "3.0")]
		public void set_icon_name (string? icon_name);
		[Version (since = "3.0")]
		public void set_icon_pixbuf (Gdk.Pixbuf? pixbuf);
		[Version (since = "3.0")]
		public void set_image_types (string image_types);
		[Version (since = "3.0")]
		public void set_menu_label (string menu_label);
		[NoWrapper]
		public virtual bool set_sensitivity (int sensitivity_mask);
		[Version (since = "3.0")]
		public void set_sensitivity_mask (int sensitivity_mask);
		[NoWrapper]
		public virtual void uninstall ();
		public string name { get; construct; }
		public Gimp.PlugIn plug_in { get; construct; }
		[NoAccessorMethod]
		public Gimp.PDBProcType procedure_type { get; construct; }
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_procedure_config_get_type ()")]
	[Version (since = "3.0")]
	public abstract class ProcedureConfig : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ProcedureConfig ();
		public int get_choice_id (string property_name);
		[CCode (array_length = false, array_null_terminated = true)]
		public Gegl.Color[] get_color_array (string property_name);
		[CCode (array_length = false, array_null_terminated = true)]
		public (unowned GLib.Object)[] get_core_object_array (string property_name);
		public unowned Gimp.Procedure get_procedure ();
		public void save_metadata (Gimp.Image exported_image, GLib.File file);
		public void set_color_array (string property_name, [CCode (array_length_cname = "n_colors", array_length_pos = 2.1, array_length_type = "gsize")] Gegl.Color[] colors);
		public void set_core_object_array (string property_name, [CCode (array_length_cname = "n_objects", array_length_pos = 2.1, array_length_type = "gsize")] GLib.Object[] objects);
		public Gimp.Procedure procedure { get; construct; }
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_resource_get_type ()")]
	public abstract class Resource : GLib.Object, Gimp.ConfigInterface {
		[CCode (has_construct_function = false)]
		protected Resource ();
		[Version (since = "3.0")]
		public bool @delete ();
		[Version (since = "3.0")]
		public unowned Gimp.Resource duplicate ();
		[Version (since = "3.0")]
		public static unowned Gimp.Resource? get_by_id (int32 resource_id);
		[Version (since = "3.0")]
		public static unowned Gimp.Resource? get_by_name (GLib.Type resource_type, string resource_name);
		[Version (since = "3.0")]
		public int32 get_id ();
		[Version (since = "3.0")]
		public string get_name ();
		[Version (since = "3.0")]
		public static bool id_is_brush (int resource_id);
		[Version (since = "3.0")]
		public static bool id_is_font (int resource_id);
		[Version (since = "3.0")]
		public static bool id_is_gradient (int resource_id);
		[Version (since = "3.0")]
		public static bool id_is_palette (int resource_id);
		[Version (since = "3.0")]
		public static bool id_is_pattern (int resource_id);
		[Version (since = "3.0")]
		public static bool id_is_valid (int resource_id);
		[Version (since = "3.0")]
		public bool is_brush ();
		[Version (since = "3.0")]
		public bool is_editable ();
		[Version (since = "3.0")]
		public bool is_font ();
		[Version (since = "3.0")]
		public bool is_gradient ();
		[Version (since = "3.0")]
		public bool is_palette ();
		[Version (since = "3.0")]
		public bool is_pattern ();
		[Version (since = "3.0")]
		public bool is_valid ();
		[Version (since = "3.0")]
		public bool rename (string new_name);
		public int id { get; construct; }
	}
	[CCode (cheader_filename = "libgimp/gimp.h", ref_function = "gimp_scanner_ref", type_id = "gimp_scanner_get_type ()", unref_function = "gimp_scanner_unref")]
	[Compact]
	public class Scanner {
		[CCode (has_construct_function = false)]
		[Version (since = "2.10")]
		public Scanner.file (GLib.File file) throws GLib.Error;
		[Version (since = "2.4")]
		public bool parse_boolean (out bool dest);
		[Version (since = "2.4")]
		public bool parse_color (out Gegl.Color color);
		[Version (since = "2.4")]
		public bool parse_data ([CCode (array_length_cname = "length", array_length_pos = 0.5)] out uint8[] dest);
		[Version (since = "2.4")]
		public bool parse_double (out double dest);
		[Version (since = "2.4")]
		public bool parse_identifier (out global::string identifier);
		[Version (since = "2.4")]
		public bool parse_int (out int dest);
		[Version (since = "2.8")]
		public bool parse_int64 (out int64 dest);
		[Version (since = "2.4")]
		public bool parse_matrix2 (out unowned Gimp.Matrix2 dest);
		[Version (since = "2.4")]
		public bool parse_string (out global::string dest);
		[Version (since = "2.4")]
		public bool parse_string_no_validate (out global::string dest);
		[Version (since = "2.4")]
		public bool parse_token (GLib.TokenType token);
		[Version (since = "3.0")]
		public Gimp.Scanner @ref ();
		[CCode (has_construct_function = false)]
		[Version (since = "2.10")]
		public Scanner.stream (GLib.InputStream input) throws GLib.Error;
		[CCode (has_construct_function = false)]
		[Version (since = "2.4")]
		public Scanner.string ([CCode (array_length_cname = "text_len", array_length_pos = 1.1)] char[] text) throws GLib.Error;
		[Version (since = "3.0")]
		public void unref ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_selection_get_type ()")]
	public class Selection : Gimp.Channel {
		[CCode (has_construct_function = false)]
		protected Selection ();
		public static bool all (Gimp.Image image);
		public static bool border (Gimp.Image image, int radius);
		public static bool bounds (Gimp.Image image, out bool non_empty, out int x1, out int y1, out int x2, out int y2);
		public static bool feather (Gimp.Image image, double radius);
		public static unowned Gimp.Layer float (Gimp.Image image, [CCode (array_length = false, array_null_terminated = true)] Gimp.Drawable[] drawables, int offx, int offy);
		[Version (since = "2.10")]
		public static bool flood (Gimp.Image image);
		[Version (since = "3.0")]
		public static unowned Gimp.Selection? get_by_id (int32 selection_id);
		public static bool grow (Gimp.Image image, int steps);
		public static bool invert (Gimp.Image image);
		public static bool is_empty (Gimp.Image image);
		public static bool none (Gimp.Image image);
		public static unowned Gimp.Channel save (Gimp.Image image);
		public static bool sharpen (Gimp.Image image);
		public static bool shrink (Gimp.Image image, int steps);
		public static bool translate (Gimp.Image image, int offx, int offy);
		public static int value (Gimp.Image image, int x, int y);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_text_layer_get_type ()")]
	public class TextLayer : Gimp.Layer {
		[CCode (has_construct_function = false)]
		[Version (since = "3.0")]
		public TextLayer (Gimp.Image image, string text, Gimp.Font font, double size, Gimp.Unit unit);
		[Version (since = "2.6")]
		public bool get_antialias ();
		[Version (since = "2.6")]
		public Gimp.TextDirection get_base_direction ();
		[Version (since = "3.0")]
		public static unowned Gimp.TextLayer? get_by_id (int32 layer_id);
		[Version (since = "2.6")]
		public Gegl.Color get_color ();
		[Version (since = "2.6")]
		public unowned Gimp.Font get_font ();
		[Version (since = "2.6")]
		public double get_font_size (out unowned Gimp.Unit unit);
		[Version (since = "2.8")]
		public Gimp.TextHintStyle get_hint_style ();
		[Version (since = "2.6")]
		public double get_indent ();
		[Version (since = "2.6")]
		public Gimp.TextJustification get_justification ();
		[Version (since = "2.6")]
		public bool get_kerning ();
		[Version (since = "2.6")]
		public string get_language ();
		[Version (since = "2.6")]
		public double get_letter_spacing ();
		[Version (since = "2.6")]
		public double get_line_spacing ();
		[Version (since = "2.8")]
		public string get_markup ();
		[Version (since = "2.6")]
		public string get_text ();
		[Version (since = "2.8")]
		public bool resize (double width, double height);
		[Version (since = "2.6")]
		public bool set_antialias (bool antialias);
		[Version (since = "2.6")]
		public bool set_base_direction (Gimp.TextDirection direction);
		[Version (since = "2.6")]
		public bool set_color (Gegl.Color color);
		[Version (since = "2.6")]
		public bool set_font (Gimp.Font font);
		[Version (since = "2.6")]
		public bool set_font_size (double font_size, Gimp.Unit unit);
		[Version (since = "2.8")]
		public bool set_hint_style (Gimp.TextHintStyle style);
		[Version (since = "2.6")]
		public bool set_indent (double indent);
		[Version (since = "2.6")]
		public bool set_justification (Gimp.TextJustification justify);
		[Version (since = "2.6")]
		public bool set_kerning (bool kerning);
		[Version (since = "2.6")]
		public bool set_language (string language);
		[Version (since = "2.6")]
		public bool set_letter_spacing (double letter_spacing);
		[Version (since = "2.6")]
		public bool set_line_spacing (double line_spacing);
		[Version (since = "3.0")]
		public bool set_markup (string markup);
		[Version (since = "2.6")]
		public bool set_text (string text);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_thumbnail_procedure_get_type ()")]
	public class ThumbnailProcedure : Gimp.Procedure {
		[CCode (has_construct_function = false, type = "GimpProcedure*")]
		[Version (since = "3.0")]
		public ThumbnailProcedure (Gimp.PlugIn plug_in, string name, Gimp.PDBProcType proc_type, owned Gimp.RunThumbnailFunc run_func);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_unit_get_type ()")]
	public class Unit : GLib.Object {
		[CCode (has_construct_function = false)]
		public Unit (string name, double factor, int digits, string symbol, string abbreviation);
		[Version (since = "2.8")]
		public static string format_string (string format, Gimp.Unit unit);
		public unowned string get_abbreviation ();
		[Version (since = "3.0")]
		public static unowned Gimp.Unit get_by_id (int unit_id);
		public bool get_deletion_flag ();
		public int get_digits ();
		public double get_factor ();
		public int32 get_id ();
		public unowned string get_name ();
		public int get_scaled_digits (double resolution);
		public unowned string get_symbol ();
		[Version (since = "3.0")]
		public static unowned Gimp.Unit inch ();
		[Version (since = "3.0")]
		public bool is_built_in ();
		[Version (since = "2.10")]
		public bool is_metric ();
		[Version (since = "3.0")]
		public static unowned Gimp.Unit mm ();
		[Version (since = "3.0")]
		public static unowned Gimp.Unit percent ();
		[Version (since = "3.0")]
		public static unowned Gimp.Unit pica ();
		[Version (since = "3.0")]
		public static unowned Gimp.Unit pixel ();
		[Version (since = "3.0")]
		public static unowned Gimp.Unit point ();
		public void set_deletion_flag (bool deletion_flag);
		public string abbreviation { get; construct; }
		public int digits { get; construct; }
		public double factor { get; construct; }
		public int id { get; construct; }
		public string name { get; construct; }
		public string symbol { get; construct; }
	}
	[CCode (cheader_filename = "libgimp/gimp.h", ref_function = "gimp_value_array_ref", type_id = "gimp_value_array_get_type ()", unref_function = "gimp_value_array_unref")]
	[Compact]
	[Version (since = "2.10")]
	public class ValueArray {
		[CCode (has_construct_function = false)]
		public ValueArray (int n_prealloced);
		public unowned Gimp.ValueArray append (GLib.Value? value);
		[Version (since = "3.0")]
		public Gimp.ValueArray copy ();
		[CCode (has_construct_function = false)]
		[Version (since = "3.0")]
		public ValueArray.from_values ([CCode (array_length_cname = "n_values", array_length_pos = 1.1)] GLib.Value[] values);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "3.0")]
		public unowned Gegl.Color[] get_color_array (int index);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "3.0")]
		public unowned GLib.Object[] get_core_object_array (int index);
		public unowned GLib.Value? index (int index);
		public unowned Gimp.ValueArray insert (int index, GLib.Value? value);
		public int length ();
		public unowned Gimp.ValueArray prepend (GLib.Value? value);
		public Gimp.ValueArray @ref ();
		public unowned Gimp.ValueArray remove (int index);
		public void truncate (int n_values);
		public void unref ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gimp_vector2_get_type ()")]
	[Compact]
	public class Vector2 {
		public double x;
		public double y;
		[CCode (has_construct_function = false, type = "GimpVector2")]
		public Vector2 (double x, double y);
		public void add (Gimp.Vector2 vector1, Gimp.Vector2 vector2);
		public Gimp.Vector2 add_val (Gimp.Vector2 vector2);
		public Gimp.Vector2 cross_product (Gimp.Vector2 vector2);
		public Gimp.Vector2 cross_product_val (Gimp.Vector2 vector2);
		public double inner_product (Gimp.Vector2 vector2);
		public double inner_product_val (Gimp.Vector2 vector2);
		public double length ();
		public double length_val ();
		public void mul (double factor);
		public Gimp.Vector2 mul_val (double factor);
		public void neg ();
		public Gimp.Vector2 neg_val ();
		[Version (since = "2.8")]
		public Gimp.Vector2 normal ();
		[Version (since = "2.8")]
		public Gimp.Vector2 normal_val ();
		public void normalize ();
		public Gimp.Vector2 normalize_val ();
		public void rotate (double alpha);
		public Gimp.Vector2 rotate_val (double alpha);
		public void @set (double x, double y);
		public void sub (Gimp.Vector2 vector1, Gimp.Vector2 vector2);
		public Gimp.Vector2 sub_val (Gimp.Vector2 vector2);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gimp_vector3_get_type ()")]
	[Compact]
	public class Vector3 {
		public double x;
		public double y;
		public double z;
		[CCode (has_construct_function = false, type = "GimpVector3")]
		public Vector3 (double x, double y, double z);
		public void add (Gimp.Vector3 vector1, Gimp.Vector3 vector2);
		public Gimp.Vector3 add_val (Gimp.Vector3 vector2);
		public Gimp.Vector3 cross_product (Gimp.Vector3 vector2);
		public Gimp.Vector3 cross_product_val (Gimp.Vector3 vector2);
		public double inner_product (Gimp.Vector3 vector2);
		public double inner_product_val (Gimp.Vector3 vector2);
		public double length ();
		public double length_val ();
		public void mul (double factor);
		public Gimp.Vector3 mul_val (double factor);
		public void neg ();
		public Gimp.Vector3 neg_val ();
		public void normalize ();
		public Gimp.Vector3 normalize_val ();
		public void rotate (double alpha, double beta, double gamma);
		public Gimp.Vector3 rotate_val (double alpha, double beta, double gamma);
		public void @set (double x, double y, double z);
		public void sub (Gimp.Vector3 vector1, Gimp.Vector3 vector2);
		public Gimp.Vector3 sub_val (Gimp.Vector3 vector2);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_id = "gimp_vector_load_procedure_get_type ()")]
	public sealed class VectorLoadProcedure : Gimp.LoadProcedure {
		[CCode (has_construct_function = false, type = "GimpProcedure*")]
		[Version (since = "3.0")]
		public VectorLoadProcedure (Gimp.PlugIn plug_in, string name, Gimp.PDBProcType proc_type, [CCode (delegate_target_pos = 4.33333, destroy_notify_pos = 4.66667)] owned Gimp.ExtractVectorFunc extract_func, owned Gimp.RunVectorLoadFunc run_func);
		public bool extract_dimensions (GLib.File file, out Gimp.VectorLoadData data) throws GLib.Error;
	}
	[CCode (cheader_filename = "libgimp/gimp.h", type_cname = "GimpColorManagedInterface", type_id = "gimp_color_managed_get_type ()")]
	public interface ColorManaged : GLib.Object {
		[Version (since = "2.10")]
		public abstract Gimp.ColorProfile get_color_profile ();
		[CCode (array_length_pos = 0.1, array_length_type = "gsize")]
		[Version (since = "2.4")]
		public abstract unowned uint8[] get_icc_profile ();
		[Version (since = "3.0")]
		public abstract bool get_simulation_bpc ();
		[Version (since = "3.0")]
		public abstract Gimp.ColorRenderingIntent get_simulation_intent ();
		[Version (since = "3.0")]
		public abstract Gimp.ColorProfile get_simulation_profile ();
		[HasEmitter]
		public virtual signal void profile_changed ();
		[HasEmitter]
		public virtual signal void simulation_bpc_changed ();
		[HasEmitter]
		public virtual signal void simulation_intent_changed ();
		[HasEmitter]
		public virtual signal void simulation_profile_changed ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", lower_case_csuffix = "config", type_id = "gimp_config_get_type ()")]
	public interface ConfigInterface : GLib.Object {
		[Version (since = "2.4")]
		public static string build_data_path (string name);
		[Version (since = "2.4")]
		public static string build_plug_in_path (string name);
		[Version (since = "2.10.6")]
		public static string build_system_path (string name);
		[Version (since = "2.4")]
		public static string build_writable_path (string name);
		[Version (since = "2.4")]
		public static bool deserialize_return (GLib.Scanner scanner, GLib.TokenType expected_token, int nest_level);
		[Version (since = "2.4")]
		public static GLib.List<weak GLib.ParamSpec> diff (GLib.Object a, GLib.Object b, GLib.ParamFlags flags);
		[Version (since = "2.4")]
		public static GLib.Quark error_quark ();
		[Version (since = "3.0")]
		public static GLib.ParamSpec param_spec_duplicate (GLib.ParamSpec pspec);
		[Version (since = "2.4")]
		public static void reset_properties (GLib.Object object);
		[Version (since = "2.4")]
		public static void reset_property (GLib.Object object, string property_name);
		[Version (since = "2.4")]
		public static bool serialize_value (GLib.Value value, GLib.StringBuilder str, bool escaped);
		[Version (since = "2.4")]
		public static void string_append_escaped (GLib.StringBuilder string, string val);
		[Version (since = "2.4")]
		public static bool sync (GLib.Object src, GLib.Object dest, GLib.ParamFlags flags);
		[Version (since = "3.0")]
		public static GLib.Type type_register (GLib.Type parent_type, string type_name, [CCode (array_length_cname = "n_pspecs", array_length_pos = 3.1)] GLib.ParamSpec[] pspecs);
	}
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public struct BablFormat : Babl.Object {
		public static GLib.Type get_type ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", has_type_id = false)]
	public struct EnumDesc {
		public int value;
		public weak string value_desc;
		public weak string value_help;
	}
	[CCode (cheader_filename = "libgimp/gimp.h", has_type_id = false)]
	public struct FlagsDesc {
		public uint value;
		public weak string value_desc;
		public weak string value_help;
	}
	[CCode (cheader_filename = "libgimp/gimp.h", has_type_id = false)]
	public struct Matrix4 {
		[CCode (array_length = false)]
		public weak double coeff[16];
		[Version (since = "2.10.16")]
		public void identity ();
		[Version (since = "2.10.16")]
		public void mult (Gimp.Matrix4 right);
		public void to_deg (out double a, out double b, out double c);
		[Version (since = "2.10.16")]
		public double transform_point (double x, double y, double z, out double newx, out double newy, out double newz);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", has_type_id = false)]
	public struct ModuleInfo {
		public uint32 abi_version;
		public weak string purpose;
		public weak string author;
		public weak string version;
		public weak string copyright;
		public weak string date;
	}
	[CCode (cheader_filename = "libgimp/gimp.h", has_type_id = false)]
	public struct ParamSpecChoice {
		public weak GLib.ParamSpecString parent_instance;
		public weak Gimp.Choice choice;
	}
	[CCode (cheader_filename = "libgimp/gimp.h", has_type_id = false)]
	public struct ParamSpecCoreObjectArray {
		public weak GLib.ParamSpecBoxed parent_instance;
		public GLib.Type object_type;
	}
	[CCode (cheader_filename = "libgimp/gimp.h", has_type_id = false)]
	public struct ParamSpecDisplay {
		public weak GLib.ParamSpecObject parent_instance;
		public bool none_ok;
	}
	[CCode (cheader_filename = "libgimp/gimp.h", has_type_id = false)]
	public struct ParamSpecImage {
		public weak GLib.ParamSpecObject parent_instance;
		public bool none_ok;
	}
	[CCode (cheader_filename = "libgimp/gimp.h", has_type_id = false)]
	public struct ParamSpecItem {
		public weak GLib.ParamSpecObject parent_instance;
		public bool none_ok;
	}
	[CCode (cheader_filename = "libgimp/gimp.h", has_type_id = false)]
	public struct ParamSpecObject {
		public weak GLib.ParamSpecObject parent_instance;
		public static unowned GLib.ParamSpec duplicate (GLib.ParamSpec pspec);
		public static unowned GLib.Object get_default (GLib.ParamSpec pspec);
		public static bool has_default (GLib.ParamSpec pspec);
		public static void set_default (GLib.ParamSpec pspec, GLib.Object? default_value);
	}
	[CCode (cheader_filename = "libgimp/gimp.h", has_type_id = false)]
	public struct ParamSpecObjectClass {
	}
	[CCode (cheader_filename = "libgimp/gimp.h", has_type_id = false)]
	public struct ParamSpecResource {
		public Gimp.ParamSpecObject parent_instance;
		public bool none_ok;
		public bool default_to_context;
	}
	[CCode (cheader_filename = "libgimp/gimp.h", has_type_id = false)]
	public struct ParamSpecUnit {
		public Gimp.ParamSpecObject parent_instance;
		public bool allow_pixel;
		public bool allow_percent;
		public weak Gimp.Unit default_value;
	}
	[CCode (cheader_filename = "libgimp/gimp.h", has_type_id = false)]
	public struct ParamSpecValueArray {
		public weak GLib.ParamSpec parent_instance;
		public weak GLib.ParamSpec element_spec;
		public int fixed_n_elements;
	}
	[CCode (cheader_filename = "libgimp/gimp.h", has_type_id = false)]
	public struct PixPipeParams {
		public int step;
		public int ncells;
		public int dim;
		public int cols;
		public int rows;
		public int cellwidth;
		public int cellheight;
		public weak string placement;
		[CCode (array_length = false)]
		public weak int rank[4];
		[CCode (array_length = false)]
		public weak string selection[4];
	}
	[CCode (cheader_filename = "libgimp/gimp.h", has_type_id = false)]
	public struct ProgressVtable {
		public weak Gimp.ProgressVtableStartFunc start;
		public weak Gimp.ProgressVtableEndFunc end;
		public weak Gimp.ProgressVtableSetTextFunc set_text;
		public weak Gimp.ProgressVtableSetValueFunc set_value;
		public weak Gimp.ProgressVtablePulseFunc pulse;
		public weak Gimp.ProgressVtableGetWindowFunc get_window_handle;
	}
	[CCode (cheader_filename = "libgimp/gimp.h", has_type_id = false)]
	public struct Vector4 {
		public double x;
		public double y;
		public double z;
		public double w;
	}
	[CCode (cheader_filename = "libgimp/gimp.h", has_type_id = false)]
	public struct VectorLoadData {
		public double width;
		public weak Gimp.Unit width_unit;
		public bool exact_width;
		public double height;
		public weak Gimp.Unit height_unit;
		public bool exact_height;
		public bool correct_ratio;
		public double pixel_density;
		public weak Gimp.Unit density_unit;
		public bool exact_density;
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_ADD_MASK_", type_id = "gimp_add_mask_type_get_type ()")]
	public enum AddMaskType {
		WHITE,
		BLACK,
		ALPHA,
		ALPHA_TRANSFER,
		SELECTION,
		COPY,
		CHANNEL
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_ARGUMENT_SYNC_", has_type_id = false)]
	[Version (since = "3.0")]
	public enum ArgumentSync {
		NONE,
		PARASITE
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_BRUSH_", type_id = "gimp_brush_application_mode_get_type ()")]
	public enum BrushApplicationMode {
		HARD,
		SOFT
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_BRUSH_GENERATED_", type_id = "gimp_brush_generated_shape_get_type ()")]
	public enum BrushGeneratedShape {
		CIRCLE,
		SQUARE,
		DIAMOND
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_CAP_", type_id = "gimp_cap_style_get_type ()")]
	public enum CapStyle {
		BUTT,
		ROUND,
		SQUARE
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_CHANNEL_OP_", type_id = "gimp_channel_ops_get_type ()")]
	public enum ChannelOps {
		ADD,
		SUBTRACT,
		REPLACE,
		INTERSECT
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_CHANNEL_", type_id = "gimp_channel_type_get_type ()")]
	public enum ChannelType {
		RED,
		GREEN,
		BLUE,
		GRAY,
		INDEXED,
		ALPHA
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_CHECK_SIZE_", type_id = "gimp_check_size_get_type ()")]
	public enum CheckSize {
		SMALL_CHECKS,
		MEDIUM_CHECKS,
		LARGE_CHECKS
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_CHECK_TYPE_", type_id = "gimp_check_type_get_type ()")]
	public enum CheckType {
		LIGHT_CHECKS,
		GRAY_CHECKS,
		DARK_CHECKS,
		WHITE_ONLY,
		GRAY_ONLY,
		BLACK_ONLY,
		CUSTOM_CHECKS
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_CLONE_", type_id = "gimp_clone_type_get_type ()")]
	public enum CloneType {
		IMAGE,
		PATTERN
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_COLOR_MANAGEMENT_", type_id = "gimp_color_management_mode_get_type ()")]
	public enum ColorManagementMode {
		OFF,
		DISPLAY,
		SOFTPROOF
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_COLOR_RENDERING_INTENT_", type_id = "gimp_color_rendering_intent_get_type ()")]
	public enum ColorRenderingIntent {
		PERCEPTUAL,
		RELATIVE_COLORIMETRIC,
		SATURATION,
		ABSOLUTE_COLORIMETRIC
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_COLOR_TAG_", type_id = "gimp_color_tag_get_type ()")]
	[Version (since = "2.10")]
	public enum ColorTag {
		NONE,
		BLUE,
		GREEN,
		YELLOW,
		ORANGE,
		BROWN,
		RED,
		VIOLET,
		GRAY
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_COLOR_TRANSFORM_FLAGS_", has_type_id = false)]
	public enum ColorTransformFlags {
		NOOPTIMIZE,
		GAMUT_CHECK,
		BLACK_POINT_COMPENSATION
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_COMPONENT_TYPE_", type_id = "gimp_component_type_get_type ()")]
	[Version (since = "2.10")]
	public enum ComponentType {
		U8,
		U16,
		U32,
		HALF,
		FLOAT,
		DOUBLE
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_CONFIG_PATH_", has_type_id = false)]
	public enum ConfigPathType {
		FILE,
		FILE_LIST,
		DIR,
		DIR_LIST
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_CONVERT_DITHER_", type_id = "gimp_convert_dither_type_get_type ()")]
	public enum ConvertDitherType {
		NONE,
		FS,
		FS_LOWBLEED,
		FIXED
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_CONVERT_PALETTE_", type_id = "gimp_convert_palette_type_get_type ()")]
	public enum ConvertPaletteType {
		GENERATE,
		WEB,
		MONO,
		CUSTOM
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_CONVOLVE_", type_id = "gimp_convolve_type_get_type ()")]
	public enum ConvolveType {
		BLUR,
		SHARPEN
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_CPU_ACCEL_", has_type_id = false)]
	public enum CpuAccelFlags {
		NONE,
		X86_MMX,
		X86_3DNOW,
		X86_MMXEXT,
		X86_SSE,
		X86_SSE2,
		X86_SSE3,
		X86_SSSE3,
		X86_SSE4_1,
		X86_SSE4_2,
		X86_AVX,
		PPC_ALTIVEC
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_DESATURATE_", type_id = "gimp_desaturate_mode_get_type ()")]
	public enum DesaturateMode {
		LIGHTNESS,
		LUMA,
		AVERAGE,
		LUMINANCE,
		VALUE
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_DODGE_BURN_TYPE_", type_id = "gimp_dodge_burn_type_get_type ()")]
	public enum DodgeBurnType {
		DODGE,
		BURN
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_EXPORT_", type_id = "gimp_export_capabilities_get_type ()")]
	[Flags]
	public enum ExportCapabilities {
		CAN_HANDLE_RGB,
		CAN_HANDLE_GRAY,
		CAN_HANDLE_INDEXED,
		CAN_HANDLE_BITMAP,
		CAN_HANDLE_ALPHA,
		CAN_HANDLE_LAYERS,
		CAN_HANDLE_LAYERS_AS_ANIMATION,
		CAN_HANDLE_LAYER_MASKS,
		CAN_HANDLE_LAYER_EFFECTS,
		NEEDS_ALPHA,
		NEEDS_CROP
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_EXPORT_", has_type_id = false)]
	public enum ExportReturn {
		IGNORE,
		EXPORT
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_FILL_", type_id = "gimp_fill_type_get_type ()")]
	public enum FillType {
		FOREGROUND,
		BACKGROUND,
		CIELAB_MIDDLE_GRAY,
		WHITE,
		TRANSPARENT,
		PATTERN
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_FOREGROUND_EXTRACT_", type_id = "gimp_foreground_extract_mode_get_type ()")]
	public enum ForegroundExtractMode {
		MATTING
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_GRADIENT_BLEND_", type_id = "gimp_gradient_blend_color_space_get_type ()")]
	[Version (since = "2.10")]
	public enum GradientBlendColorSpace {
		RGB_PERCEPTUAL,
		RGB_LINEAR,
		CIE_LAB
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_GRADIENT_SEGMENT_", type_id = "gimp_gradient_segment_color_get_type ()")]
	public enum GradientSegmentColor {
		RGB,
		HSV_CCW,
		HSV_CW
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_GRADIENT_SEGMENT_", type_id = "gimp_gradient_segment_type_get_type ()")]
	public enum GradientSegmentType {
		LINEAR,
		CURVED,
		SINE,
		SPHERE_INCREASING,
		SPHERE_DECREASING,
		STEP
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_GRADIENT_", type_id = "gimp_gradient_type_get_type ()")]
	public enum GradientType {
		LINEAR,
		BILINEAR,
		RADIAL,
		SQUARE,
		CONICAL_SYMMETRIC,
		CONICAL_ASYMMETRIC,
		SHAPEBURST_ANGULAR,
		SHAPEBURST_SPHERICAL,
		SHAPEBURST_DIMPLED,
		SPIRAL_CLOCKWISE,
		SPIRAL_ANTICLOCKWISE
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_GRID_", type_id = "gimp_grid_style_get_type ()")]
	public enum GridStyle {
		DOTS,
		INTERSECTIONS,
		ON_OFF_DASH,
		DOUBLE_DASH,
		SOLID
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_HISTOGRAM_", type_id = "gimp_histogram_channel_get_type ()")]
	public enum HistogramChannel {
		VALUE,
		RED,
		GREEN,
		BLUE,
		ALPHA,
		LUMINANCE
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_HUE_RANGE_", type_id = "gimp_hue_range_get_type ()")]
	public enum HueRange {
		ALL,
		RED,
		YELLOW,
		GREEN,
		CYAN,
		BLUE,
		MAGENTA
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_ICON_TYPE_", type_id = "gimp_icon_type_get_type ()")]
	public enum IconType {
		ICON_NAME,
		PIXBUF,
		IMAGE_FILE
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_", type_id = "gimp_image_base_type_get_type ()")]
	public enum ImageBaseType {
		RGB,
		GRAY,
		INDEXED
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_", type_id = "gimp_image_type_get_type ()")]
	public enum ImageType {
		RGB_IMAGE,
		RGBA_IMAGE,
		GRAY_IMAGE,
		GRAYA_IMAGE,
		INDEXED_IMAGE,
		INDEXEDA_IMAGE
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_INK_BLOB_TYPE_", type_id = "gimp_ink_blob_type_get_type ()")]
	public enum InkBlobType {
		CIRCLE,
		SQUARE,
		DIAMOND
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_INTERPOLATION_", type_id = "gimp_interpolation_type_get_type ()")]
	public enum InterpolationType {
		NONE,
		LINEAR,
		CUBIC,
		NOHALO,
		LOHALO
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_JOIN_", type_id = "gimp_join_style_get_type ()")]
	public enum JoinStyle {
		MITER,
		ROUND,
		BEVEL
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_LAYER_COLOR_SPACE_", type_id = "gimp_layer_color_space_get_type ()")]
	public enum LayerColorSpace {
		AUTO,
		RGB_LINEAR,
		RGB_PERCEPTUAL
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_LAYER_COMPOSITE_", type_id = "gimp_layer_composite_mode_get_type ()")]
	public enum LayerCompositeMode {
		AUTO,
		UNION,
		CLIP_TO_BACKDROP,
		CLIP_TO_LAYER,
		INTERSECTION
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_LAYER_MODE_", type_id = "gimp_layer_mode_get_type ()")]
	public enum LayerMode {
		NORMAL_LEGACY,
		DISSOLVE,
		BEHIND_LEGACY,
		MULTIPLY_LEGACY,
		SCREEN_LEGACY,
		OVERLAY_LEGACY,
		DIFFERENCE_LEGACY,
		ADDITION_LEGACY,
		SUBTRACT_LEGACY,
		DARKEN_ONLY_LEGACY,
		LIGHTEN_ONLY_LEGACY,
		HSV_HUE_LEGACY,
		HSV_SATURATION_LEGACY,
		HSL_COLOR_LEGACY,
		HSV_VALUE_LEGACY,
		DIVIDE_LEGACY,
		DODGE_LEGACY,
		BURN_LEGACY,
		HARDLIGHT_LEGACY,
		SOFTLIGHT_LEGACY,
		GRAIN_EXTRACT_LEGACY,
		GRAIN_MERGE_LEGACY,
		COLOR_ERASE_LEGACY,
		OVERLAY,
		LCH_HUE,
		LCH_CHROMA,
		LCH_COLOR,
		LCH_LIGHTNESS,
		NORMAL,
		BEHIND,
		MULTIPLY,
		SCREEN,
		DIFFERENCE,
		ADDITION,
		SUBTRACT,
		DARKEN_ONLY,
		LIGHTEN_ONLY,
		HSV_HUE,
		HSV_SATURATION,
		HSL_COLOR,
		HSV_VALUE,
		DIVIDE,
		DODGE,
		BURN,
		HARDLIGHT,
		SOFTLIGHT,
		GRAIN_EXTRACT,
		GRAIN_MERGE,
		VIVID_LIGHT,
		PIN_LIGHT,
		LINEAR_LIGHT,
		HARD_MIX,
		EXCLUSION,
		LINEAR_BURN,
		LUMA_DARKEN_ONLY,
		LUMA_LIGHTEN_ONLY,
		LUMINANCE,
		COLOR_ERASE,
		ERASE,
		MERGE,
		SPLIT,
		PASS_THROUGH
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_MASK_", type_id = "gimp_mask_apply_mode_get_type ()")]
	public enum MaskApplyMode {
		APPLY,
		DISCARD
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_", type_id = "gimp_merge_type_get_type ()")]
	public enum MergeType {
		EXPAND_AS_NECESSARY,
		CLIP_TO_IMAGE,
		CLIP_TO_BOTTOM_LAYER,
		FLATTEN_IMAGE
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_", type_id = "gimp_message_handler_type_get_type ()")]
	public enum MessageHandlerType {
		MESSAGE_BOX,
		CONSOLE,
		ERROR_CONSOLE
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_METADATA_COLORSPACE_", has_type_id = false)]
	public enum MetadataColorspace {
		UNSPECIFIED,
		UNCALIBRATED,
		SRGB,
		ADOBERGB
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_METADATA_LOAD_", has_type_id = false)]
	[Flags]
	public enum MetadataLoadFlags {
		NONE,
		COMMENT,
		RESOLUTION,
		ORIENTATION,
		COLORSPACE,
		ALL
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_METADATA_SAVE_", has_type_id = false)]
	[Flags]
	public enum MetadataSaveFlags {
		EXIF,
		XMP,
		IPTC,
		THUMBNAIL,
		COLOR_PROFILE,
		COMMENT,
		ALL
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_MODULE_", has_type_id = false)]
	public enum ModuleError {
		[CCode (cname = "GIMP_MODULE_FAILED")]
		MODULE_FAILED
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_MODULE_STATE_", has_type_id = false)]
	public enum ModuleState {
		ERROR,
		LOADED,
		LOAD_FAILED,
		NOT_LOADED
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_OFFSET_", type_id = "gimp_offset_type_get_type ()")]
	public enum OffsetType {
		BACKGROUND,
		TRANSPARENT,
		WRAP_AROUND
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_ORIENTATION_", type_id = "gimp_orientation_type_get_type ()")]
	public enum OrientationType {
		HORIZONTAL,
		VERTICAL,
		UNKNOWN
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_PDB_ERROR_HANDLER_", type_id = "gimp_pdb_error_handler_get_type ()")]
	public enum PDBErrorHandler {
		INTERNAL,
		PLUGIN
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_PDB_PROC_TYPE_", type_id = "gimp_pdb_proc_type_get_type ()")]
	public enum PDBProcType {
		INTERNAL,
		PLUGIN,
		PERSISTENT,
		TEMPORARY
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_PDB_", type_id = "gimp_pdb_status_type_get_type ()")]
	public enum PDBStatusType {
		EXECUTION_ERROR,
		CALLING_ERROR,
		PASS_THROUGH,
		SUCCESS,
		CANCEL
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_PAINT_", type_id = "gimp_paint_application_mode_get_type ()")]
	public enum PaintApplicationMode {
		CONSTANT,
		INCREMENTAL
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_PATH_STROKE_TYPE_", type_id = "gimp_path_stroke_type_get_type ()")]
	public enum PathStrokeType {
		BEZIER
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_PIXBUF_", has_type_id = false)]
	public enum PixbufTransparency {
		KEEP_ALPHA,
		SMALL_CHECKS,
		LARGE_CHECKS
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_PRECISION_", type_id = "gimp_precision_get_type ()")]
	[Version (since = "2.10")]
	public enum Precision {
		U8_LINEAR,
		U8_NON_LINEAR,
		U8_PERCEPTUAL,
		U16_LINEAR,
		U16_NON_LINEAR,
		U16_PERCEPTUAL,
		U32_LINEAR,
		U32_NON_LINEAR,
		U32_PERCEPTUAL,
		HALF_LINEAR,
		HALF_NON_LINEAR,
		HALF_PERCEPTUAL,
		FLOAT_LINEAR,
		FLOAT_NON_LINEAR,
		FLOAT_PERCEPTUAL,
		DOUBLE_LINEAR,
		DOUBLE_NON_LINEAR,
		DOUBLE_PERCEPTUAL
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_PROCEDURE_SENSITIVE_", type_id = "gimp_procedure_sensitivity_mask_get_type ()")]
	[Flags]
	public enum ProcedureSensitivityMask {
		DRAWABLE,
		DRAWABLES,
		NO_DRAWABLES,
		NO_IMAGE,
		ALWAYS
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_PROGRESS_COMMAND_", type_id = "gimp_progress_command_get_type ()")]
	public enum ProgressCommand {
		START,
		END,
		SET_TEXT,
		SET_VALUE,
		PULSE,
		GET_WINDOW
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_REPEAT_", type_id = "gimp_repeat_mode_get_type ()")]
	public enum RepeatMode {
		NONE,
		TRUNCATE,
		SAWTOOTH,
		TRIANGULAR
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_ROTATE_", type_id = "gimp_rotation_type_get_type ()")]
	public enum RotationType {
		DEGREES90,
		DEGREES180,
		DEGREES270
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_RUN_", type_id = "gimp_run_mode_get_type ()")]
	public enum RunMode {
		INTERACTIVE,
		NONINTERACTIVE,
		WITH_LAST_VALS
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_SELECT_CRITERION_", type_id = "gimp_select_criterion_get_type ()")]
	public enum SelectCriterion {
		COMPOSITE,
		RGB_RED,
		RGB_GREEN,
		RGB_BLUE,
		HSV_HUE,
		HSV_SATURATION,
		HSV_VALUE,
		LCH_LIGHTNESS,
		LCH_CHROMA,
		LCH_HUE,
		ALPHA
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_", type_id = "gimp_size_type_get_type ()")]
	public enum SizeType {
		PIXELS,
		POINTS
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_STACK_TRACE_", type_id = "gimp_stack_trace_mode_get_type ()")]
	public enum StackTraceMode {
		NEVER,
		QUERY,
		ALWAYS
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_STROKE_", type_id = "gimp_stroke_method_get_type ()")]
	public enum StrokeMethod {
		LINE,
		PAINT_METHOD
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_TEXT_DIRECTION_", type_id = "gimp_text_direction_get_type ()")]
	public enum TextDirection {
		LTR,
		RTL,
		TTB_RTL,
		TTB_RTL_UPRIGHT,
		TTB_LTR,
		TTB_LTR_UPRIGHT
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_TEXT_HINT_STYLE_", type_id = "gimp_text_hint_style_get_type ()")]
	public enum TextHintStyle {
		NONE,
		SLIGHT,
		MEDIUM,
		FULL
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_TEXT_JUSTIFY_", type_id = "gimp_text_justification_get_type ()")]
	public enum TextJustification {
		LEFT,
		RIGHT,
		CENTER,
		FILL
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_TRANSFER_", type_id = "gimp_transfer_mode_get_type ()")]
	public enum TransferMode {
		SHADOWS,
		MIDTONES,
		HIGHLIGHTS
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_TRANSFORM_", type_id = "gimp_transform_direction_get_type ()")]
	public enum TransformDirection {
		FORWARD,
		BACKWARD
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_TRANSFORM_RESIZE_", type_id = "gimp_transform_resize_get_type ()")]
	public enum TransformResize {
		ADJUST,
		CLIP,
		CROP,
		CROP_WITH_ASPECT
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_UNIT_", has_type_id = false)]
	public enum UnitID {
		PIXEL,
		INCH,
		MM,
		POINT,
		PICA,
		END,
		PERCENT
	}
	[CCode (cheader_filename = "libgimp/gimp.h", cprefix = "GIMP_CONFIG_ERROR_", has_type_id = false)]
	public errordomain ConfigError {
		OPEN,
		OPEN_ENOENT,
		WRITE,
		PARSE,
		VERSION;
		[Version (replacement = "ConfigInterface.error_quark", since = "2.4")]
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libgimp/gimp.h", instance_pos = 4.9)]
	[Version (since = "3.0")]
	public delegate Gimp.ValueArray BatchFunc (Gimp.Procedure procedure, Gimp.RunMode run_mode, string command, Gimp.ProcedureConfig config);
	[CCode (cheader_filename = "libgimp/gimp.h", instance_pos = 3.9)]
	[Version (since = "3.0")]
	public delegate Gimp.ExportCapabilities ExportGetCapabilitiesFunc (Gimp.Procedure procedure, Gimp.ProcedureConfig config, Gimp.ExportOptions options);
	[CCode (cheader_filename = "libgimp/gimp.h", instance_pos = 8.9)]
	[Version (since = "3.0")]
	public delegate bool ExtractVectorFunc (Gimp.Procedure procedure, Gimp.RunMode run_mode, GLib.File file, Gimp.Metadata metadata, Gimp.ProcedureConfig? config, out Gimp.VectorLoadData extracted_data, out void* data_for_run, out unowned GLib.DestroyNotify? data_for_run_destroy) throws GLib.Error;
	[CCode (cheader_filename = "libgimp/gimp.h", has_target = false)]
	public delegate unowned Gimp.ModuleInfo? ModuleQueryFunc (GLib.TypeModule module);
	[CCode (cheader_filename = "libgimp/gimp.h", has_target = false)]
	public delegate bool ModuleRegisterFunc (GLib.TypeModule module);
	[CCode (cheader_filename = "libgimp/gimp.h", instance_pos = 3.9)]
	public delegate void ProgressFunc (int min, int max, int current);
	[CCode (cheader_filename = "libgimp/gimp.h", instance_pos = 0.9)]
	public delegate void ProgressVtableEndFunc ();
	[CCode (cheader_filename = "libgimp/gimp.h", instance_pos = 0.9)]
	public delegate GLib.Bytes ProgressVtableGetWindowFunc ();
	[CCode (cheader_filename = "libgimp/gimp.h", instance_pos = 0.9)]
	public delegate void ProgressVtablePulseFunc ();
	[CCode (cheader_filename = "libgimp/gimp.h", instance_pos = 1.9)]
	public delegate void ProgressVtableSetTextFunc (string message);
	[CCode (cheader_filename = "libgimp/gimp.h", instance_pos = 1.9)]
	public delegate void ProgressVtableSetValueFunc (double percentage);
	[CCode (cheader_filename = "libgimp/gimp.h", instance_pos = 2.9)]
	public delegate void ProgressVtableStartFunc (string message, bool cancelable);
	[CCode (cheader_filename = "libgimp/gimp.h", instance_pos = 3.9)]
	public delegate void PutPixelFunc (int x, int y, double color);
	[CCode (cheader_filename = "libgimp/gimp.h", instance_pos = 3.9)]
	public delegate void RenderFunc (double x, double y, out double color);
	[CCode (cheader_filename = "libgimp/gimp.h", instance_pos = 7.9)]
	[Version (since = "3.0")]
	public delegate Gimp.ValueArray RunExportFunc (Gimp.Procedure procedure, Gimp.RunMode run_mode, Gimp.Image image, GLib.File file, Gimp.ExportOptions options, Gimp.Metadata metadata, Gimp.ProcedureConfig config);
	[CCode (cheader_filename = "libgimp/gimp.h", instance_pos = 2.9)]
	[Version (since = "3.0")]
	public delegate Gimp.ValueArray RunFunc (Gimp.Procedure procedure, Gimp.ProcedureConfig config);
	[CCode (cheader_filename = "libgimp/gimp.h", instance_pos = 5.9)]
	[Version (since = "3.0")]
	public delegate Gimp.ValueArray RunImageFunc (Gimp.Procedure procedure, Gimp.RunMode run_mode, Gimp.Image image, [CCode (array_length = false, array_null_terminated = true)] Gimp.Drawable[] drawables, Gimp.ProcedureConfig config);
	[CCode (cheader_filename = "libgimp/gimp.h", instance_pos = 6.9)]
	[Version (since = "3.0")]
	public delegate Gimp.ValueArray RunLoadFunc (Gimp.Procedure procedure, Gimp.RunMode run_mode, GLib.File file, Gimp.Metadata metadata, ref Gimp.MetadataLoadFlags flags, Gimp.ProcedureConfig config);
	[CCode (cheader_filename = "libgimp/gimp.h", instance_pos = 4.9)]
	[Version (since = "3.0")]
	public delegate Gimp.ValueArray RunThumbnailFunc (Gimp.Procedure procedure, GLib.File file, int size, Gimp.ProcedureConfig config);
	[CCode (cheader_filename = "libgimp/gimp.h", instance_pos = 9.9)]
	[Version (since = "3.0")]
	public delegate Gimp.ValueArray RunVectorLoadFunc (Gimp.Procedure procedure, Gimp.RunMode run_mode, GLib.File file, int width, int height, Gimp.VectorLoadData extracted_data, Gimp.Metadata metadata, ref Gimp.MetadataLoadFlags flags, Gimp.ProcedureConfig config);
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_API_VERSION")]
	[Version (since = "2.2")]
	public const string API_VERSION;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_CHECK_DARK")]
	public const double CHECK_DARK;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_CHECK_LIGHT")]
	public const double CHECK_LIGHT;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_CHECK_SIZE")]
	public const int CHECK_SIZE;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_CHECK_SIZE_SM")]
	public const int CHECK_SIZE_SM;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_CONFIG_PARAM_AGGREGATE")]
	public const int CONFIG_PARAM_AGGREGATE;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_CONFIG_PARAM_CONFIRM")]
	public const int CONFIG_PARAM_CONFIRM;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_CONFIG_PARAM_DEFAULTS")]
	public const int CONFIG_PARAM_DEFAULTS;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_CONFIG_PARAM_DONT_COMPARE")]
	public const int CONFIG_PARAM_DONT_COMPARE;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_CONFIG_PARAM_FLAGS")]
	public const int CONFIG_PARAM_FLAGS;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_CONFIG_PARAM_FLAG_SHIFT")]
	public const int CONFIG_PARAM_FLAG_SHIFT;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_CONFIG_PARAM_IGNORE")]
	public const int CONFIG_PARAM_IGNORE;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_CONFIG_PARAM_RESTART")]
	public const int CONFIG_PARAM_RESTART;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_CONFIG_PARAM_SERIALIZE")]
	public const int CONFIG_PARAM_SERIALIZE;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_MAJOR_VERSION")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_MAX_IMAGE_SIZE")]
	public const int MAX_IMAGE_SIZE;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_MAX_MEMSIZE")]
	public const int MAX_MEMSIZE;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_MAX_RESOLUTION")]
	public const double MAX_RESOLUTION;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_MICRO_VERSION")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_MINOR_VERSION")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_MIN_IMAGE_SIZE")]
	public const int MIN_IMAGE_SIZE;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_MIN_RESOLUTION")]
	public const double MIN_RESOLUTION;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_MODULE_ABI_VERSION")]
	public const int MODULE_ABI_VERSION;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_PARAM_DONT_SERIALIZE")]
	public const int PARAM_DONT_SERIALIZE;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_PARAM_FLAG_SHIFT")]
	public const int PARAM_FLAG_SHIFT;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_PARAM_NO_VALIDATE")]
	public const int PARAM_NO_VALIDATE;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_PARAM_READABLE")]
	[Version (since = "2.4")]
	public const int PARAM_READABLE;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_PARAM_READWRITE")]
	[Version (since = "2.4")]
	public const int PARAM_READWRITE;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_PARAM_STATIC_STRINGS")]
	[Version (since = "2.4")]
	public const int PARAM_STATIC_STRINGS;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_PARAM_WRITABLE")]
	[Version (since = "2.4")]
	public const int PARAM_WRITABLE;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_PARASITE_ATTACH_GRANDPARENT")]
	public const int PARASITE_ATTACH_GRANDPARENT;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_PARASITE_ATTACH_PARENT")]
	public const int PARASITE_ATTACH_PARENT;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_PARASITE_GRANDPARENT_PERSISTENT")]
	public const int PARASITE_GRANDPARENT_PERSISTENT;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_PARASITE_GRANDPARENT_UNDOABLE")]
	public const int PARASITE_GRANDPARENT_UNDOABLE;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_PARASITE_PARENT_PERSISTENT")]
	public const int PARASITE_PARENT_PERSISTENT;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_PARASITE_PARENT_UNDOABLE")]
	public const int PARASITE_PARENT_UNDOABLE;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_PARASITE_PERSISTENT")]
	public const int PARASITE_PERSISTENT;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_PARASITE_UNDOABLE")]
	public const int PARASITE_UNDOABLE;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_PIXPIPE_MAXDIM")]
	public const int PIXPIPE_MAXDIM;
	[CCode (cheader_filename = "libgimp/gimp.h", cname = "GIMP_VERSION")]
	public const string VERSION;
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static ulong adaptive_supersample_area (int x1, int y1, int x2, int y2, int max_depth, double threshold, [CCode (delegate_target_pos = 7.5)] Gimp.RenderFunc render_func, [CCode (delegate_target_pos = 8.5)] Gimp.PutPixelFunc put_pixel_func, Gimp.ProgressFunc progress_func);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool airbrush (Gimp.Drawable drawable, double pressure, [CCode (array_length_cname = "num_strokes", array_length_pos = 2.5, array_length_type = "gsize")] double[] strokes);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool airbrush_default (Gimp.Drawable drawable, [CCode (array_length_cname = "num_strokes", array_length_pos = 1.5, array_length_type = "gsize")] double[] strokes);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool attach_parasite (Gimp.Parasite parasite);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static double bilinear (double x, double y, [CCode (array_length = false)] double values[4]);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static uint16 bilinear_16 (double x, double y, [CCode (array_length = false)] uint16 values[4]);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static uint32 bilinear_32 (double x, double y, [CCode (array_length = false)] uint32 values[4]);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static uint8 bilinear_8 (double x, double y, [CCode (array_length = false)] uint8 values[4]);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static void bilinear_rgb (double x, double y, [CCode (array_length = false)] double values[16], bool has_alpha, [CCode (array_length = false)] double retvalues[4]);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static void bind_text_domain (string domain_name, string dir_name);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool brushes_close_popup (string brush_callback);
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "libgimp/gimp.h")]
	public static (unowned Gimp.Brush)[] brushes_get_list (string filter);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool brushes_popup (string brush_callback, string popup_title, Gimp.Brush initial_brush, GLib.Bytes parent_window);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool brushes_refresh ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool brushes_set_popup (string brush_callback, Gimp.Brush brush);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static bool buffer_delete (string buffer_name);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static int buffer_get_bytes (string buffer_name);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static int buffer_get_height (string buffer_name);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static Gimp.ImageType buffer_get_image_type (string buffer_name);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static int buffer_get_width (string buffer_name);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static string buffer_rename (string buffer_name, string new_name);
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static string[] buffers_get_name_list (string filter);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10.10")]
	public static unowned string cache_directory ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.6")]
	public static Cairo.Pattern cairo_checkerboard_create (Cairo.Context cr, int size, Gegl.Color light, Gegl.Color dark);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static Gegl.Buffer cairo_surface_create_buffer (Cairo.Surface surface, Babl.Object format);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static unowned Babl.Object? cairo_surface_get_format (Cairo.Surface surface);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static string canonicalize_identifier (string identifier);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned Gegl.Color check_custom_color1 ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned Gegl.Color check_custom_color2 ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static Gimp.CheckSize check_size ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static Gimp.CheckType check_type ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static void checks_get_colors (Gimp.CheckType type, ref Gegl.Color color1, ref Gegl.Color color2);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool clone (Gimp.Drawable drawable, Gimp.Drawable src_drawable, Gimp.CloneType clone_type, double src_x, double src_y, [CCode (array_length_cname = "num_strokes", array_length_pos = 5.5, array_length_type = "gsize")] double[] strokes);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool clone_default (Gimp.Drawable drawable, [CCode (array_length_cname = "num_strokes", array_length_pos = 1.5, array_length_type = "gsize")] double[] strokes);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static bool color_is_out_of_gamut (Gegl.Color color, Babl.Object space);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static bool color_is_out_of_self_gamut (Gegl.Color color);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static bool color_is_perceptually_identical (Gegl.Color color1, Gegl.Color color2);
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static (unowned string)[] color_list_names ([CCode (array_length = false, array_null_terminated = true)] out Gegl.Color[] colors);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static Gegl.Color color_parse_css (string css);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static Gegl.Color color_parse_hex (string hex);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static Gegl.Color color_parse_name (string name);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static void color_set_alpha (Gegl.Color color, double alpha);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static bool context_are_dynamics_enabled ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static bool context_enable_dynamics (bool enable);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_get_antialias ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static Gegl.Color context_get_background ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static unowned Gimp.Brush context_get_brush ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static double context_get_brush_angle ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static double context_get_brush_aspect_ratio ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static double context_get_brush_force ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static double context_get_brush_hardness ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static double context_get_brush_size ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static double context_get_brush_spacing ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_get_diagonal_neighbors ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static Gegl.DistanceMetric context_get_distance_metric ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static string context_get_dynamics_name ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static bool context_get_emulate_brush_dynamics ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_get_feather ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_get_feather_radius (out double feather_radius_x, out double feather_radius_y);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static unowned Gimp.Font context_get_font ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static Gegl.Color context_get_foreground ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static unowned Gimp.Gradient context_get_gradient ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static Gimp.GradientBlendColorSpace context_get_gradient_blend_color_space ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static Gimp.RepeatMode context_get_gradient_repeat_mode ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_get_gradient_reverse ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static double context_get_ink_angle ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static double context_get_ink_blob_angle ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static double context_get_ink_blob_aspect_ratio ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static Gimp.InkBlobType context_get_ink_blob_type ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static double context_get_ink_size ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static double context_get_ink_size_sensitivity ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static double context_get_ink_speed_sensitivity ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static double context_get_ink_tilt_sensitivity ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static Gimp.InterpolationType context_get_interpolation ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static Gimp.CapStyle context_get_line_cap_style ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static double context_get_line_dash_offset ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_get_line_dash_pattern ([CCode (array_length_cname = "num_dashes", array_length_pos = 0.5, array_length_type = "gsize")] out double[] dashes);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static Gimp.JoinStyle context_get_line_join_style ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static double context_get_line_miter_limit ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static double context_get_line_width ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static unowned Gimp.Unit context_get_line_width_unit ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static string context_get_mypaint_brush ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static double context_get_opacity ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static string context_get_paint_method ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static Gimp.LayerMode context_get_paint_mode ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static unowned Gimp.Palette context_get_palette ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static unowned Gimp.Pattern context_get_pattern ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static Gimp.SelectCriterion context_get_sample_criterion ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_get_sample_merged ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static double context_get_sample_threshold ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static int context_get_sample_threshold_int ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_get_sample_transparent ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static Gimp.StrokeMethod context_get_stroke_method ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static Gimp.TransformDirection context_get_transform_direction ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static Gimp.TransformResize context_get_transform_resize ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static bool context_list_paint_methods ([CCode (array_length = false, array_null_terminated = true)] out string[] paint_methods);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static bool context_pop ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static bool context_push ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_antialias (bool antialias);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static bool context_set_background (Gegl.Color background);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static bool context_set_brush (Gimp.Brush brush);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_brush_angle (double angle);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_brush_aspect_ratio (double aspect);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_set_brush_default_hardness ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_brush_default_size ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_set_brush_default_spacing ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_set_brush_force (double force);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_set_brush_hardness (double hardness);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_brush_size (double size);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_set_brush_spacing (double spacing);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static bool context_set_default_colors ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_defaults ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_set_diagonal_neighbors (bool diagonal_neighbors);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_set_distance_metric (Gegl.DistanceMetric metric);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_dynamics_name (string name);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static bool context_set_emulate_brush_dynamics (bool emulate_dynamics);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_feather (bool feather);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_feather_radius (double feather_radius_x, double feather_radius_y);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static bool context_set_font (Gimp.Font font);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static bool context_set_foreground (Gegl.Color foreground);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static bool context_set_gradient (Gimp.Gradient gradient);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_set_gradient_blend_color_space (Gimp.GradientBlendColorSpace blend_color_space);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_set_gradient_fg_bg_hsv_ccw ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_set_gradient_fg_bg_hsv_cw ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_set_gradient_fg_bg_rgb ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_set_gradient_fg_transparent ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_set_gradient_repeat_mode (Gimp.RepeatMode repeat_mode);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_set_gradient_reverse (bool reverse);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_ink_angle (double angle);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_ink_blob_angle (double angle);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_ink_blob_aspect_ratio (double aspect);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_ink_blob_type (Gimp.InkBlobType type);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_ink_size (double size);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_ink_size_sensitivity (double size);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_ink_speed_sensitivity (double speed);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_ink_tilt_sensitivity (double tilt);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_interpolation (Gimp.InterpolationType interpolation);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_set_line_cap_style (Gimp.CapStyle cap_style);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_set_line_dash_offset (double dash_offset);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_set_line_dash_pattern ([CCode (array_length_cname = "num_dashes", array_length_pos = 0.5, array_length_type = "gsize")] double[] dashes);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_set_line_join_style (Gimp.JoinStyle join_style);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_set_line_miter_limit (double miter_limit);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_set_line_width (double line_width);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_set_line_width_unit (Gimp.Unit line_width_unit);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_set_mypaint_brush (string name);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static bool context_set_opacity (double opacity);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static bool context_set_paint_method (string name);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static bool context_set_paint_mode (Gimp.LayerMode paint_mode);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static bool context_set_palette (Gimp.Palette palette);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static bool context_set_pattern (Gimp.Pattern pattern);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_sample_criterion (Gimp.SelectCriterion sample_criterion);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_sample_merged (bool sample_merged);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_sample_threshold (double sample_threshold);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_sample_threshold_int (int sample_threshold);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_sample_transparent (bool sample_transparent);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool context_set_stroke_method (Gimp.StrokeMethod stroke_method);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_transform_direction (Gimp.TransformDirection transform_direction);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool context_set_transform_resize (Gimp.TransformResize transform_resize);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static bool context_swap_colors ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool convolve (Gimp.Drawable drawable, double pressure, Gimp.ConvolveType convolve_type, [CCode (array_length_cname = "num_strokes", array_length_pos = 3.5, array_length_type = "gsize")] double[] strokes);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool convolve_default (Gimp.Drawable drawable, [CCode (array_length_cname = "num_strokes", array_length_pos = 1.5, array_length_type = "gsize")] double[] strokes);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static Gimp.CpuAccelFlags cpu_accel_get_support ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static unowned string data_directory ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static double debug_timer_end ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool debug_timer_start ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static unowned Gimp.Display default_display ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool detach_parasite (string name);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static unowned string directory ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool displays_flush ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool displays_reconnect (Gimp.Image old_image, Gimp.Image new_image);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool dodgeburn (Gimp.Drawable drawable, double exposure, Gimp.DodgeBurnType dodgeburn_type, Gimp.TransferMode dodgeburn_mode, [CCode (array_length_cname = "num_strokes", array_length_pos = 4.5, array_length_type = "gsize")] double[] strokes);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool dodgeburn_default (Gimp.Drawable drawable, [CCode (array_length_cname = "num_strokes", array_length_pos = 1.5, array_length_type = "gsize")] double[] strokes);
	[CCode (array_length_pos = 1.1, array_length_type = "gsize", cheader_filename = "libgimp/gimp.h")]
	[Version (replacement = "DoubleArray.get_values")]
	public static unowned double[] double_array_get_values (Gimp.Array array);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (replacement = "DoubleArray.set_values")]
	public static void double_array_set_values (Gimp.Array array, [CCode (array_length_cname = "length", array_length_pos = 2.5, array_length_type = "gsize")] double[] values, bool static_data);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool drawables_close_popup (string callback);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool drawables_popup (string callback, string popup_title, string drawable_type, Gimp.Drawable initial_drawable, GLib.Bytes parent_window);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool drawables_set_popup (string callback, Gimp.Drawable drawable);
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static string[] dynamics_get_name_list (string filter);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static bool dynamics_refresh ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool edit_copy ([CCode (array_length = false, array_null_terminated = true)] Gimp.Drawable[] drawables);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static bool edit_copy_visible (Gimp.Image image);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool edit_cut ([CCode (array_length = false, array_null_terminated = true)] Gimp.Drawable[] drawables);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static string edit_named_copy ([CCode (array_length = false, array_null_terminated = true)] Gimp.Drawable[] drawables, string buffer_name);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static string edit_named_copy_visible (Gimp.Image image, string buffer_name);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static string edit_named_cut ([CCode (array_length = false, array_null_terminated = true)] Gimp.Drawable[] drawables, string buffer_name);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static unowned Gimp.Layer edit_named_paste (Gimp.Drawable drawable, string buffer_name, bool paste_into);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static unowned Gimp.Image edit_named_paste_as_new_image (string buffer_name);
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "libgimp/gimp.h")]
	public static (unowned Gimp.Drawable)[] edit_paste (Gimp.Drawable drawable, bool paste_into);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static unowned Gimp.Image edit_paste_as_new_image ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static unowned Gimp.EnumDesc? enum_get_desc (GLib.EnumClass enum_class, int value);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static bool enum_get_value (GLib.Type enum_type, int value, out string value_name, out string value_nick, out string value_desc, out string value_help);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static unowned Gimp.EnumDesc? enum_get_value_descriptions (GLib.Type enum_type);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static void enum_set_value_descriptions (GLib.Type enum_type, Gimp.EnumDesc descriptions);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static unowned string enum_value_get_abbrev (GLib.EnumClass enum_class, GLib.EnumValue enum_value);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static unowned string enum_value_get_desc (GLib.EnumClass enum_class, GLib.EnumValue enum_value);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static unowned string enum_value_get_help (GLib.EnumClass enum_class, GLib.EnumValue enum_value);
	[CCode (array_length_pos = 0.1, cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static unowned string[] enums_get_type_names ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static void enums_init ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool eraser (Gimp.Drawable drawable, [CCode (array_length_cname = "num_strokes", array_length_pos = 1.5, array_length_type = "gsize")] double[] strokes, Gimp.BrushApplicationMode hardness, Gimp.PaintApplicationMode method);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool eraser_default (Gimp.Drawable drawable, [CCode (array_length_cname = "num_strokes", array_length_pos = 1.5, array_length_type = "gsize")] double[] strokes);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static string escape_uline (string? str);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10.4")]
	public static bool export_color_profile ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static bool export_comment ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool export_exif ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool export_iptc ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static bool export_thumbnail ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool export_xmp ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static string file_get_config_path (GLib.File file) throws GLib.Error;
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static unowned string file_get_utf8_name (GLib.File file);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool file_has_extension (GLib.File file, string extension);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static unowned Gimp.Image file_load (Gimp.RunMode run_mode, GLib.File file);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static unowned Gimp.Layer file_load_layer (Gimp.RunMode run_mode, Gimp.Image image, GLib.File file);
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static (unowned Gimp.Layer)[] file_load_layers (Gimp.RunMode run_mode, Gimp.Image image, GLib.File file);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static GLib.File? file_new_for_config_path (string path) throws GLib.Error;
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool file_save (Gimp.RunMode run_mode, Gimp.Image image, GLib.File file, Gimp.ExportOptions? options);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool file_save_thumbnail (Gimp.Image image, GLib.File file);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool file_show_in_file_manager (GLib.File file) throws GLib.Error;
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static unowned string filename_to_utf8 (string filename);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static unowned Gimp.FlagsDesc? flags_get_first_desc (GLib.FlagsClass flags_class, uint value);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static bool flags_get_first_value (GLib.Type flags_type, uint value, out string value_name, out string value_nick, out string value_desc, out string value_help);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static unowned Gimp.FlagsDesc? flags_get_value_descriptions (GLib.Type flags_type);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static void flags_set_value_descriptions (GLib.Type flags_type, Gimp.FlagsDesc descriptions);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static unowned string flags_value_get_abbrev (GLib.FlagsClass flags_class, GLib.FlagsValue flags_value);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static unowned string flags_value_get_desc (GLib.FlagsClass flags_class, GLib.FlagsValue flags_value);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static unowned string flags_value_get_help (GLib.FlagsClass flags_class, GLib.FlagsValue flags_value);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool floating_sel_anchor (Gimp.Layer floating_sel);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool floating_sel_attach (Gimp.Layer layer, Gimp.Drawable drawable);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool floating_sel_remove (Gimp.Layer floating_sel);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool floating_sel_to_layer (Gimp.Layer floating_sel);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool fonts_close_popup (string font_callback);
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "libgimp/gimp.h")]
	public static (unowned Gimp.Font)[] fonts_get_list (string filter);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool fonts_popup (string font_callback, string popup_title, Gimp.Font initial_font, GLib.Bytes parent_window);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool fonts_refresh ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool fonts_set_popup (string font_callback, Gimp.Font font);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static Gimp.ColorConfig get_color_configuration ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static string get_default_comment ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static unowned Gimp.Unit get_default_unit ();
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "libgimp/gimp.h")]
	public static (unowned Gimp.Image)[] get_images ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static string get_module_load_inhibit ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool get_monitor_resolution (out double xres, out double yres);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static int get_num_processors ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static Gimp.Parasite get_parasite (string name);
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static string[] get_parasite_list ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned Gimp.PDB? get_pdb ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned Gimp.PlugIn? get_plug_in ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static unowned string get_progname ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static int getpid ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static string gimprc_query (string token);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool gimprc_set (string token, string value);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool gradients_close_popup (string gradient_callback);
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "libgimp/gimp.h")]
	public static (unowned Gimp.Gradient)[] gradients_get_list (string filter);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool gradients_popup (string gradient_callback, string popup_title, Gimp.Gradient initial_gradient, GLib.Bytes parent_window);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool gradients_refresh ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool gradients_set_popup (string gradient_callback, Gimp.Gradient gradient);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static bool heal (Gimp.Drawable drawable, Gimp.Drawable src_drawable, double src_x, double src_y, [CCode (array_length_cname = "num_strokes", array_length_pos = 4.5, array_length_type = "gsize")] double[] strokes);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static bool heal_default (Gimp.Drawable drawable, [CCode (array_length_cname = "num_strokes", array_length_pos = 1.5, array_length_type = "gsize")] double[] strokes);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool help (string help_domain, string help_id);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10.4")]
	public static unowned string icon_theme_dir ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static unowned string installation_directory ();
	[CCode (array_length_pos = 1.1, array_length_type = "gsize", cheader_filename = "libgimp/gimp.h")]
	[Version (replacement = "Int32Array.get_values")]
	public static unowned int32[] int32_array_get_values (Gimp.Array array);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (replacement = "Int32Array.set_values")]
	public static void int32_array_set_values (Gimp.Array array, [CCode (array_length_cname = "length", array_length_pos = 2.5, array_length_type = "gsize")] int32[] values, bool static_data);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static bool is_canonical_identifier (string identifier);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static unowned string locale_directory ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static int main (GLib.Type plug_in_type, [CCode (array_length_cname = "argc", array_length_pos = 1.5)] string[] argv);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool message (string message);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static Gimp.MessageHandlerType message_get_handler ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool message_set_handler (Gimp.MessageHandlerType handler);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static int monitor_number ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool paintbrush (Gimp.Drawable drawable, double fade_out, [CCode (array_length_cname = "num_strokes", array_length_pos = 2.5, array_length_type = "gsize")] double[] strokes, Gimp.PaintApplicationMode method, double gradient_length);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool paintbrush_default (Gimp.Drawable drawable, [CCode (array_length_cname = "num_strokes", array_length_pos = 1.5, array_length_type = "gsize")] double[] strokes);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool palettes_close_popup (string palette_callback);
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "libgimp/gimp.h")]
	public static (unowned Gimp.Palette)[] palettes_get_list (string filter);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool palettes_popup (string palette_callback, string popup_title, Gimp.Palette initial_palette, GLib.Bytes parent_window);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool palettes_refresh ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool palettes_set_popup (string palette_callback, Gimp.Palette palette);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned GLib.ParamSpec param_spec_array (string name, string nick, string blurb, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned GLib.ParamSpec param_spec_brush (string name, string nick, string blurb, bool none_ok, Gimp.Brush? default_value, bool default_to_context, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned GLib.ParamSpec param_spec_channel (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned GLib.ParamSpec param_spec_choice (string name, string nick, string blurb, owned Gimp.Choice choice, string default_value, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static GLib.ParamSpec param_spec_color (string name, string nick, string blurb, bool has_alpha, Gegl.Color default_color, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (replacement = "ParamSpecColor.from_string")]
	public static GLib.ParamSpec param_spec_color_from_string (string name, string nick, string blurb, bool has_alpha, string default_color_string, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (replacement = "ParamSpecColor.has_alpha", since = "2.4")]
	public static bool param_spec_color_has_alpha (GLib.ParamSpec pspec);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static GLib.ParamSpec param_spec_config_path (string name, string nick, string blurb, Gimp.ConfigPathType type, string default_value, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static Gimp.ConfigPathType param_spec_config_path_type (GLib.ParamSpec pspec);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned GLib.ParamSpec param_spec_core_object_array (string name, string nick, string blurb, GLib.Type object_type, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned GLib.ParamSpec param_spec_display (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned GLib.ParamSpec param_spec_double_array (string name, string nick, string blurb, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned GLib.ParamSpec param_spec_drawable (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned GLib.ParamSpec param_spec_export_options (string name, string nick, string blurb, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned GLib.ParamSpec param_spec_font (string name, string nick, string blurb, bool none_ok, Gimp.Font? default_value, bool default_to_context, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned GLib.ParamSpec param_spec_gradient (string name, string nick, string blurb, bool none_ok, Gimp.Gradient? default_value, bool default_to_context, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned GLib.ParamSpec param_spec_group_layer (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned GLib.ParamSpec param_spec_image (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned GLib.ParamSpec param_spec_int32_array (string name, string nick, string blurb, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned GLib.ParamSpec param_spec_item (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned GLib.ParamSpec param_spec_layer (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned GLib.ParamSpec param_spec_layer_mask (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static GLib.ParamSpec param_spec_matrix2 (string name, string nick, string blurb, Gimp.Matrix2 default_value, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static GLib.ParamSpec param_spec_matrix3 (string name, string nick, string blurb, Gimp.Matrix3 default_value, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static GLib.ParamSpec param_spec_memsize (string name, string nick, string blurb, uint64 minimum, uint64 maximum, uint64 default_value, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (replacement = "ParamSpecObject.duplicate")]
	public static unowned GLib.ParamSpec param_spec_object_duplicate (GLib.ParamSpec pspec);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (replacement = "ParamSpecObject.get_default")]
	public static unowned GLib.Object param_spec_object_get_default (GLib.ParamSpec pspec);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (replacement = "ParamSpecObject.has_default")]
	public static bool param_spec_object_has_default (GLib.ParamSpec pspec);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (replacement = "ParamSpecObject.set_default")]
	public static void param_spec_object_set_default (GLib.ParamSpec pspec, GLib.Object? default_value);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned GLib.ParamSpec param_spec_palette (string name, string nick, string blurb, bool none_ok, Gimp.Palette? default_value, bool default_to_context, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static GLib.ParamSpec param_spec_parasite (string name, string nick, string blurb, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned GLib.ParamSpec param_spec_path (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned GLib.ParamSpec param_spec_pattern (string name, string nick, string blurb, bool none_ok, Gimp.Pattern? default_value, bool default_to_context, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned GLib.ParamSpec param_spec_resource (string name, string nick, string blurb, GLib.Type resource_type, bool none_ok, Gimp.Resource? default_value, bool default_to_context, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned GLib.ParamSpec param_spec_selection (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static unowned GLib.ParamSpec param_spec_text_layer (string name, string nick, string blurb, bool none_ok, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static GLib.ParamSpec param_spec_unit (string name, string nick, string blurb, bool allow_pixel, bool allow_percent, Gimp.Unit default_value, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "3.0")]
	public static GLib.ParamSpec param_spec_value_array (string name, string nick, string blurb, GLib.ParamSpec? element_spec, GLib.ParamFlags flags);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool patterns_close_popup (string pattern_callback);
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "libgimp/gimp.h")]
	public static (unowned Gimp.Pattern)[] patterns_get_list (string filter);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool patterns_popup (string pattern_callback, string popup_title, Gimp.Pattern initial_pattern, GLib.Bytes parent_window);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool patterns_refresh ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool patterns_set_popup (string pattern_callback, Gimp.Pattern pattern);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool pencil (Gimp.Drawable drawable, [CCode (array_length_cname = "num_strokes", array_length_pos = 1.5, array_length_type = "gsize")] double[] strokes);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static Gegl.Buffer pixbuf_create_buffer (Gdk.Pixbuf pixbuf);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static unowned Babl.Object? pixbuf_get_format (Gdk.Pixbuf pixbuf);
	[CCode (array_length_pos = 1.1, array_length_type = "gsize", cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static unowned uint8[]? pixbuf_get_icc_profile (Gdk.Pixbuf pixbuf);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static double pixels_to_units (double pixels, Gimp.Unit unit, double resolution);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static string pixpipe_params_build (Gimp.PixPipeParams @params);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static void pixpipe_params_free (Gimp.PixPipeParams @params);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static void pixpipe_params_init (Gimp.PixPipeParams @params);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static void pixpipe_params_parse (string parameters, Gimp.PixPipeParams @params);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static bool progress_cancel (string progress_callback);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static bool progress_end ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static GLib.Bytes progress_get_window_handle ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool progress_init (string message);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static unowned string progress_install_vtable (Gimp.ProgressVtable vtable, void* user_data, GLib.DestroyNotify? user_data_destroy);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static bool progress_pulse ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static bool progress_set_text (string message);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static void progress_uninstall (string progress_callback);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool progress_update (double percentage);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static void quit ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static void range_estimate_settings (double lower, double upper, out double step, out double page, out int digits);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.4")]
	public static bool rectangle_intersect (int x1, int y1, int width1, int height1, int x2, int y2, int width2, int height2, out int dest_x, out int dest_y, out int dest_width, out int dest_height);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static void rectangle_union (int x1, int y1, int width1, int height1, int x2, int y2, int width2, int height2, out int dest_x, out int dest_y, out int dest_width, out int dest_height);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static bool show_help_button ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool smudge (Gimp.Drawable drawable, double pressure, [CCode (array_length_cname = "num_strokes", array_length_pos = 2.5, array_length_type = "gsize")] double[] strokes);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool smudge_default (Gimp.Drawable drawable, [CCode (array_length_cname = "num_strokes", array_length_pos = 1.5, array_length_type = "gsize")] double[] strokes);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool stack_trace_available (bool optimal);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static bool stack_trace_print (string prog_name, void* stream, out string trace);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10")]
	public static void stack_trace_query (string prog_name);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static string strip_uline (string? str);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static unowned string sysconf_directory ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.10.10")]
	public static unowned string temp_directory ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static GLib.File temp_file (string extension);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static unowned Gimp.Layer? text_font (Gimp.Image image, Gimp.Drawable? drawable, double x, double y, string text, int border, bool antialias, double size, Gimp.Font font);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static bool text_get_extents_font (string text, double size, Gimp.Font font, out int width, out int height, out int ascent, out int descent);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static uint tile_height ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static uint tile_width ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static unowned string type_get_translation_context (GLib.Type type);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static unowned string type_get_translation_domain (GLib.Type type);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static void type_set_translation_context (GLib.Type type, string context);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.2")]
	public static void type_set_translation_domain (GLib.Type type, string domain);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static double units_to_pixels (double value, Gimp.Unit unit, double resolution);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.8")]
	public static double units_to_points (double value, Gimp.Unit unit, double resolution);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (since = "2.6")]
	public static uint32 user_time ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static string utf8_strtrim (string? str, int max_chars);
	[CCode (array_length_pos = 1.1, array_length_type = "gsize", cheader_filename = "libgimp/gimp.h")]
	public static double[] value_dup_double_array (GLib.Value value);
	[CCode (array_length_pos = 1.1, array_length_type = "gsize", cheader_filename = "libgimp/gimp.h")]
	public static int32[] value_dup_int32_array (GLib.Value value);
	[CCode (array_length_pos = 1.1, array_length_type = "gsize", cheader_filename = "libgimp/gimp.h")]
	public static unowned double[] value_get_double_array (GLib.Value value);
	[CCode (array_length_pos = 1.1, array_length_type = "gsize", cheader_filename = "libgimp/gimp.h")]
	public static unowned int32[] value_get_int32_array (GLib.Value value);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static void value_set_double_array (GLib.Value value, [CCode (array_length_cname = "length", array_length_pos = 2.1, array_length_type = "gsize")] double[] data);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static void value_set_int32_array (GLib.Value value, [CCode (array_length_cname = "length", array_length_pos = 2.1, array_length_type = "gsize")] int32[] data);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static void value_set_static_double_array (GLib.Value value, [CCode (array_length_cname = "length", array_length_pos = 2.1, array_length_type = "gsize")] double[] data);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static void value_set_static_int32_array (GLib.Value value, [CCode (array_length_cname = "length", array_length_pos = 2.1, array_length_type = "gsize")] int32[] data);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static void value_take_double_array (GLib.Value value, [CCode (array_length_cname = "length", array_length_pos = 2.1, array_length_type = "gsize")] owned double[] data);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static void value_take_int32_array (GLib.Value value, [CCode (array_length_cname = "length", array_length_pos = 2.1, array_length_type = "gsize")] owned int32[] data);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (replacement = "Vector2.add")]
	public static void vector2_add (out unowned Gimp.Vector2 result, Gimp.Vector2 vector1, Gimp.Vector2 vector2);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (replacement = "Vector2.sub")]
	public static void vector2_sub (out unowned Gimp.Vector2 result, Gimp.Vector2 vector1, Gimp.Vector2 vector2);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (replacement = "Vector3.add")]
	public static void vector3_add (out unowned Gimp.Vector3 result, Gimp.Vector3 vector1, Gimp.Vector3 vector2);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	[Version (replacement = "Vector3.sub")]
	public static void vector3_sub (out unowned Gimp.Vector3 result, Gimp.Vector3 vector1, Gimp.Vector3 vector2);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static void vector_2d_to_3d (int sx, int sy, int w, int h, int x, int y, Gimp.Vector3 vp, Gimp.Vector3 p);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static Gimp.Vector3 vector_2d_to_3d_val (int sx, int sy, int w, int h, int x, int y, Gimp.Vector3 vp, Gimp.Vector3 p);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static void vector_3d_to_2d (int sx, int sy, int w, int h, out double x, out double y, Gimp.Vector3 vp, Gimp.Vector3 p);
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static string version ();
	[CCode (cheader_filename = "libgimp/gimp.h")]
	public static unowned string wm_class ();
}
