/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.rsa;

import gnu.java.security.Registry;
import gnu.java.security.key.rsa.GnuRSAKey;
import gnu.java.security.key.rsa.RSAKeyPairPKCS8Codec;
import gnu.java.security.key.rsa.RSAKeyPairRawCodec;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;

public class GnuRSAPrivateKey
extends GnuRSAKey
implements PrivateKey,
RSAPrivateCrtKey {
    private final BigInteger p;
    private final BigInteger q;
    private final BigInteger d;
    private final BigInteger dP;
    private final BigInteger dQ;
    private final BigInteger qInv;

    public static GnuRSAPrivateKey valueOf(byte[] byArray) {
        if (byArray[0] == Registry.MAGIC_RAW_RSA_PRIVATE_KEY[0]) {
            try {
                return (GnuRSAPrivateKey)new RSAKeyPairRawCodec().decodePrivateKey(byArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return (GnuRSAPrivateKey)new RSAKeyPairPKCS8Codec().decodePrivateKey(byArray);
    }

    public BigInteger getPrimeP() {
        return this.p;
    }

    public BigInteger getPrimeQ() {
        return this.q;
    }

    public BigInteger getPrimeExponentP() {
        return this.dP;
    }

    public BigInteger getPrimeExponentQ() {
        return this.dQ;
    }

    public BigInteger getCrtCoefficient() {
        return this.qInv;
    }

    public BigInteger getPrivateExponent() {
        return this.d;
    }

    public byte[] getEncoded(int n) {
        byte[] byArray;
        switch (n) {
            case 1: {
                byArray = new RSAKeyPairRawCodec().encodePrivateKey(this);
                break;
            }
            case 3: {
                byArray = new RSAKeyPairPKCS8Codec().encodePrivateKey(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported encoding format: " + n);
            }
        }
        return byArray;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof RSAPrivateKey) {
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)object;
            boolean bl = false;
            if (super.equals(rSAPrivateKey) && this.d.equals(rSAPrivateKey.getPrivateExponent())) {
                bl = true;
            }
            return bl;
        }
        if (object instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)object;
            boolean bl = false;
            if (super.equals(rSAPrivateCrtKey) && this.p.equals(rSAPrivateCrtKey.getPrimeP()) && this.q.equals(rSAPrivateCrtKey.getPrimeQ()) && this.dP.equals(rSAPrivateCrtKey.getPrimeExponentP()) && this.dQ.equals(rSAPrivateCrtKey.getPrimeExponentQ()) && this.qInv.equals(rSAPrivateCrtKey.getCrtCoefficient())) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public GnuRSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this(1, bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }

    public GnuRSAPrivateKey(int n, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this(n, bigInteger.multiply(bigInteger2), bigInteger3, bigInteger4, bigInteger, bigInteger2, bigInteger3.modInverse(bigInteger.subtract(BigInteger.ONE)), bigInteger3.modInverse(bigInteger2.subtract(BigInteger.ONE)), bigInteger2.modInverse(bigInteger));
    }

    public GnuRSAPrivateKey(int n, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        super(n == 4 ? 3 : n, bigInteger, bigInteger2);
        this.d = bigInteger3;
        this.p = bigInteger4;
        this.q = bigInteger5;
        this.dP = bigInteger6;
        this.dQ = bigInteger7;
        this.qInv = bigInteger8;
    }
}

