##
# HtmlAttributes is a set of attributes to be attached to an
# HtmlElement.

class Borges::HtmlAttributes

  ##
  # Create an empty attribute set.

  def initialize
    @attributes = ""
  end

  ##
  # Set +attr+ to true.  THIS WILL NOT RETRIEVE THE VALUE OF AN ATTRIBUTE. 

  def [](attr)
    @attributes << " #{attr}=\"#{attr}\""
  end

  ##
  # Set +attr+ to +value+.

  def []=(attr, value)
    @attributes << " #{attr}=\"#{value}\""
  end

  ##
  # Set an attribute to a value (or true).  #method_missing
  # handles one or two arguments, setting the value to true if
  # given one argument, and to the value if given two.
  # #method_missing also strips an '=' on the message sent.

  def method_missing(attr, value = nil)
    attr = attr.to_s
    attr = attr.chop! if attr =~ /=$/

    if value.nil? then
      @attributes << " #{attr}=\"#{attr}\""
    else
      @attributes << " #{attr}=\"#{value}\""
    end
  end

  def to_s
    @attributes
  end

end # class Borges::HtmlAttributes

