/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.perspective.persist.xml;

import org.flexdock.perspective.Layout;
import org.flexdock.perspective.LayoutSequence;
import org.flexdock.perspective.Perspective;
import org.flexdock.perspective.persist.xml.ISerializer;
import org.flexdock.perspective.persist.xml.SerializerRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PerspectiveSerializer
implements ISerializer {
    public Element serialize(Document document, Object object) {
        Perspective perspective = (Perspective)object;
        Element perspectiveElement = document.createElement("Perspective");
        perspectiveElement.setAttribute("id", perspective.getPersistentId());
        perspectiveElement.setAttribute("name", perspective.getName());
        ISerializer layoutSerializer = SerializerRegistry.getSerializer(Layout.class);
        Element layoutElement = layoutSerializer.serialize(document, perspective.getLayout());
        perspectiveElement.appendChild(layoutElement);
        ISerializer layoutSequenceSerializer = SerializerRegistry.getSerializer(LayoutSequence.class);
        if (perspective.getInitialSequence() != null) {
            Element layoutSequenceElement = layoutSequenceSerializer.serialize(document, perspective.getInitialSequence());
            perspectiveElement.appendChild(layoutSequenceElement);
        }
        return perspectiveElement;
    }

    public Object deserialize(Element element) {
        String perspectiveId = element.getAttribute("id");
        String perspectiveName = element.getAttribute("name");
        Perspective perspective = new Perspective(perspectiveId, perspectiveName);
        NodeList layoutNodeList = element.getElementsByTagName("Layout");
        ISerializer layoutSerializer = SerializerRegistry.getSerializer(Layout.class);
        if (layoutNodeList.getLength() > 0 && layoutNodeList.item(0) instanceof Element) {
            Element layoutElement = (Element)layoutNodeList.item(0);
            Layout layout = (Layout)layoutSerializer.deserialize(layoutElement);
            perspective.setLayout(layout);
        }
        NodeList layoutSequenceNodeList = element.getElementsByTagName("LayoutSequence");
        ISerializer layoutSequenceSerializer = SerializerRegistry.getSerializer(LayoutSequence.class);
        if (layoutSequenceNodeList.getLength() > 0 && layoutSequenceNodeList.item(0) instanceof Element) {
            Element layoutSequenceElement = (Element)layoutSequenceNodeList.item(0);
            LayoutSequence layoutSequence = (LayoutSequence)layoutSequenceSerializer.deserialize(layoutSequenceElement);
            perspective.setInitialSequence(layoutSequence);
        }
        return perspective;
    }
}

