/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.problems.internal.DefaultProblemBuilder;
import org.gradle.api.problems.internal.InternalProblemBuilder;
import org.gradle.api.problems.internal.Problem;
import org.gradle.api.problems.internal.TypeValidationDataSpec;
import org.gradle.internal.reflect.validation.DefaultTypeAwareProblemBuilder;
import org.gradle.internal.reflect.validation.TypeAwareProblemBuilder;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.plugin.use.PluginId;
import org.gradle.problems.buildtree.ProblemStream;

public abstract class ProblemRecordingTypeValidationContext
implements TypeValidationContext {
    private final Class<?> rootType;
    private final Supplier<Optional<PluginId>> pluginId;

    public ProblemRecordingTypeValidationContext(@Nullable Class<?> rootType, Supplier<Optional<PluginId>> pluginId) {
        this.rootType = rootType;
        this.pluginId = pluginId;
    }

    @Override
    public void visitTypeProblem(Action<? super TypeAwareProblemBuilder> problemSpec) {
        this.recordProblem(ProblemRecordingTypeValidationContext.getDefaultTypeAwareProblemBuilder(problemSpec).build());
    }

    private Optional<PluginId> pluginId() {
        return this.pluginId.get();
    }

    @Override
    public void visitPropertyProblem(Action<? super TypeAwareProblemBuilder> problemSpec) {
        DefaultTypeAwareProblemBuilder problemBuilder = ProblemRecordingTypeValidationContext.getDefaultTypeAwareProblemBuilder(problemSpec);
        problemBuilder.withAnnotationType(this.rootType);
        this.pluginId().map(PluginId::getId).ifPresent(id -> problemBuilder.additionalData(TypeValidationDataSpec.class, data -> data.pluginId(id)));
        this.recordProblem(problemBuilder.build());
    }

    @Nonnull
    private static DefaultTypeAwareProblemBuilder getDefaultTypeAwareProblemBuilder(Action<? super TypeAwareProblemBuilder> problemSpec) {
        DefaultTypeAwareProblemBuilder problemBuilder = new DefaultTypeAwareProblemBuilder((InternalProblemBuilder)new DefaultProblemBuilder((ProblemStream)null));
        problemSpec.execute((Object)problemBuilder);
        return problemBuilder;
    }

    protected abstract void recordProblem(Problem var1);
}

