/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefaultTableColumnModel
implements TableColumnModel,
PropertyChangeListener,
ListSelectionListener,
Serializable {
    private static final long serialVersionUID = 6580012493508960512L;
    protected Vector tableColumns;
    protected ListSelectionModel selectionModel;
    protected int columnMargin;
    protected EventListenerList listenerList;
    protected transient ChangeEvent changeEvent;
    protected boolean columnSelectionAllowed;
    protected int totalColumnWidth;
    static /* synthetic */ Class class$javax$swing$event$TableColumnModelListener;

    public void addColumn(TableColumn tableColumn) {
        if (tableColumn == null) {
            throw new IllegalArgumentException("Null 'col' argument.");
        }
        this.tableColumns.add(tableColumn);
        this.invalidateWidthCache();
        this.fireColumnAdded(new TableColumnModelEvent(this, 0, this.tableColumns.size() - 1));
    }

    public void removeColumn(TableColumn tableColumn) {
        int n = this.tableColumns.indexOf(tableColumn);
        if (n < 0) {
            return;
        }
        this.fireColumnRemoved(new TableColumnModelEvent(this, n, 0));
        this.tableColumns.remove(tableColumn);
        this.invalidateWidthCache();
    }

    public void moveColumn(int n, int n2) {
        int n3 = this.getColumnCount();
        if (n < 0 || n >= n3) {
            throw new IllegalArgumentException("Index 'i' out of range.");
        }
        if (n2 < 0 || n2 >= n3) {
            throw new IllegalArgumentException("Index 'j' out of range.");
        }
        Object object = this.tableColumns.remove(n);
        this.tableColumns.add(n2, object);
        this.fireColumnAdded(new TableColumnModelEvent(this, n, n2));
    }

    public void setColumnMargin(int n) {
        this.columnMargin = n;
        this.fireColumnMarginChanged();
    }

    public int getColumnCount() {
        return this.tableColumns.size();
    }

    public Enumeration getColumns() {
        return this.tableColumns.elements();
    }

    public int getColumnIndex(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Null identifier.");
        }
        int n = this.tableColumns.size();
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = (TableColumn)this.tableColumns.get(n2);
            if (object.equals(tableColumn.getIdentifier())) {
                return n2;
            }
            ++n2;
        }
        throw new IllegalArgumentException("No TableColumn with that identifier.");
    }

    public TableColumn getColumn(int n) {
        return (TableColumn)this.tableColumns.get(n);
    }

    public int getColumnMargin() {
        return this.columnMargin;
    }

    public int getColumnIndexAtX(int n) {
        int n2 = 0;
        while (n2 < this.tableColumns.size()) {
            int n3 = ((TableColumn)this.tableColumns.get(n2)).getWidth();
            if (n >= 0 && n < n3) {
                return n2;
            }
            n -= n3;
            ++n2;
        }
        return -1;
    }

    public int getTotalColumnWidth() {
        if (this.totalColumnWidth == -1) {
            this.recalcWidthCache();
        }
        return this.totalColumnWidth;
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            throw new IllegalArgumentException();
        }
        this.selectionModel = listSelectionModel;
        this.selectionModel.addListSelectionListener(this);
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setColumnSelectionAllowed(boolean bl) {
        this.columnSelectionAllowed = bl;
    }

    public boolean getColumnSelectionAllowed() {
        return this.columnSelectionAllowed;
    }

    public int[] getSelectedColumns() {
        ListSelectionModel listSelectionModel = this.selectionModel;
        int n = this.getSelectedColumnCount();
        int[] nArray = new int[n];
        int n2 = listSelectionModel.getMinSelectionIndex();
        int n3 = listSelectionModel.getMaxSelectionIndex();
        int n4 = 0;
        ArrayList arrayList = new ArrayList();
        if (n2 != -1 && n3 != -1) {
            switch (listSelectionModel.getSelectionMode()) {
                case 0: {
                    nArray[0] = n2;
                    break;
                }
                case 1: {
                    int n5 = n2;
                    while (n5 <= n3) {
                        nArray[n4++] = n5++;
                    }
                    break;
                }
                case 2: {
                    int n6 = n2;
                    while (n6 <= n3) {
                        if (listSelectionModel.isSelectedIndex(n6)) {
                            nArray[n4++] = n6;
                        }
                        ++n6;
                    }
                    break;
                }
            }
        }
        return nArray;
    }

    public int getSelectedColumnCount() {
        ListSelectionModel listSelectionModel = this.selectionModel;
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        int n3 = 0;
        if (n != -1 && n2 != -1) {
            switch (listSelectionModel.getSelectionMode()) {
                case 0: {
                    n3 = 1;
                    break;
                }
                case 1: {
                    n3 = n2 - n + 1;
                    break;
                }
                case 2: {
                    int n4 = n;
                    while (n4 <= n2) {
                        if (listSelectionModel.isSelectedIndex(n4)) {
                            ++n3;
                        }
                        ++n4;
                    }
                    break;
                }
            }
        }
        return n3;
    }

    public void addColumnModelListener(TableColumnModelListener tableColumnModelListener) {
        Class clazz = class$javax$swing$event$TableColumnModelListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TableColumnModelListener = DefaultTableColumnModel.class("[Ljavax.swing.event.TableColumnModelListener;", false);
        }
        this.listenerList.add(clazz, tableColumnModelListener);
    }

    public void removeColumnModelListener(TableColumnModelListener tableColumnModelListener) {
        Class clazz = class$javax$swing$event$TableColumnModelListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TableColumnModelListener = DefaultTableColumnModel.class("[Ljavax.swing.event.TableColumnModelListener;", false);
        }
        this.listenerList.remove(clazz, tableColumnModelListener);
    }

    public TableColumnModelListener[] getColumnModelListeners() {
        Class clazz = class$javax$swing$event$TableColumnModelListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TableColumnModelListener = DefaultTableColumnModel.class("[Ljavax.swing.event.TableColumnModelListener;", false);
        }
        return (TableColumnModelListener[])this.listenerList.getListeners(clazz);
    }

    protected void fireColumnAdded(TableColumnModelEvent tableColumnModelEvent) {
        TableColumnModelListener[] tableColumnModelListenerArray = this.getColumnModelListeners();
        int n = 0;
        while (n < tableColumnModelListenerArray.length) {
            tableColumnModelListenerArray[n].columnAdded(tableColumnModelEvent);
            ++n;
        }
    }

    protected void fireColumnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        TableColumnModelListener[] tableColumnModelListenerArray = this.getColumnModelListeners();
        int n = 0;
        while (n < tableColumnModelListenerArray.length) {
            tableColumnModelListenerArray[n].columnRemoved(tableColumnModelEvent);
            ++n;
        }
    }

    protected void fireColumnMoved(TableColumnModelEvent tableColumnModelEvent) {
        TableColumnModelListener[] tableColumnModelListenerArray = this.getColumnModelListeners();
        int n = 0;
        while (n < tableColumnModelListenerArray.length) {
            tableColumnModelListenerArray[n].columnMoved(tableColumnModelEvent);
            ++n;
        }
    }

    protected void fireColumnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        Class clazz = class$javax$swing$event$TableColumnModelListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TableColumnModelListener = DefaultTableColumnModel.class("[Ljavax.swing.event.TableColumnModelListener;", false);
        }
        EventListener[] eventListenerArray = this.getListeners(clazz);
        int n = 0;
        while (n < eventListenerArray.length) {
            ((TableColumnModelListener)eventListenerArray[n]).columnSelectionChanged(listSelectionEvent);
            ++n;
        }
    }

    protected void fireColumnMarginChanged() {
        Class clazz = class$javax$swing$event$TableColumnModelListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TableColumnModelListener = DefaultTableColumnModel.class("[Ljavax.swing.event.TableColumnModelListener;", false);
        }
        EventListener[] eventListenerArray = this.getListeners(clazz);
        int n = 0;
        while (n < eventListenerArray.length) {
            ((TableColumnModelListener)eventListenerArray[n]).columnMarginChanged(this.changeEvent);
            ++n;
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("columWidth")) {
            this.invalidateWidthCache();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.fireColumnSelectionChanged(listSelectionEvent);
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }

    protected void recalcWidthCache() {
        if (this.totalColumnWidth == -1) {
            this.totalColumnWidth = 0;
            int n = 0;
            while (n < this.tableColumns.size()) {
                this.totalColumnWidth += ((TableColumn)this.tableColumns.get(n)).getWidth();
                ++n;
            }
        }
    }

    private final void invalidateWidthCache() {
        this.totalColumnWidth = -1;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.listenerList = new EventListenerList();
        this.changeEvent = new ChangeEvent(this);
    }

    public DefaultTableColumnModel() {
        this.this();
        this.tableColumns = new Vector();
        this.setSelectionModel(this.createSelectionModel());
        this.columnMargin = 1;
        this.columnSelectionAllowed = false;
    }
}

