/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.hsqldb.lib.FileUtil;

public class SimpleLog {
    private PrintWriter writer;
    private int level;

    public SimpleLog(String string, int n, boolean bl) {
        this.level = n;
        if (n != 0) {
            if (bl) {
                File file = new File(string);
                this.makeLog(file);
            } else {
                this.writer = new PrintWriter(System.out);
            }
        }
    }

    private void makeLog(File file) {
        try {
            FileUtil.makeParentDirectories(file);
            this.writer = new PrintWriter((Writer)new FileWriter(file.getPath(), true), true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getLevel() {
        return this.level;
    }

    public PrintWriter getPrintWriter() {
        return this.writer;
    }

    public synchronized void sendLine(String string) {
        if (this.level != 0) {
            this.writer.println(string);
        }
    }

    public synchronized void logContext(String string) {
        if (this.level == 0) {
            return;
        }
        String string2 = "";
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (stackTraceElementArray.length > 1) {
            string2 = stackTraceElementArray[1].getClassName() + "." + stackTraceElementArray[1].getMethodName();
        }
        this.writer.println(string2 + " " + string);
    }

    public synchronized void logContext(Throwable throwable) {
        if (this.level == 0) {
            return;
        }
        String string = throwable.getClass().getName();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (stackTraceElementArray.length > 0) {
            string = stackTraceElementArray[0].getClassName() + "." + stackTraceElementArray[0].getMethodName();
        }
        this.writer.println(string + " " + throwable.getMessage());
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
        }
    }
}

