<?php
SOY2::import("action.asp.NewAccountForm");
class NewAccountAction extends SOY2Action{

	protected function execute(SOY2ActionRequest &$request,SOY2ActionForm &$form,SOY2ActionResponse &$response){
    	
    	$this->setAttribute("failedSendRegistrationCode",$this->getFlashSession()->getAttribute("failedSendRegistrationCode"));
    	
    	if(empty($_POST)){
    		$form = ($this->getUserSession()->getAttribute("NewAccount")) ? $this->getUserSession()->getAttribute("NewAccount")
    				: new NewAccountForm();
		}

    	$this->getUserSession()->setAttribute("NewAccount",$form);
    	$this->setAttribute("NewAccount",$form);
    	
    	//パスワード一致チェック
    	if($form->getPassword() != $form->getPasswordConfirm()){
    		$form->setError("passwordConfirm",new ActionFormError("","","","","パスワードが一致しません。"));
    	}
    	
    	//有効なサイトIDかチェック
    	$logic = SOY2Logic::createInstance("logic.asp.ASPSiteLogic");
    	if($logic->checkValidSiteId($form->getSiteId()) != true){
    		$form->setError("siteId",new ActionFormError("","","","","このサイトIDは使えません。"));
    	}
    	
    	//メールアドレスのチェック
    	$logic = SOY2Logic::createInstance("logic.asp.ASPSiteLogic");
    	if($logic->checkValidEmail($form->getEmail()) != true){
    		$form->setError("email",new ActionFormError("","","","","このメールアドレスは既に登録されているか、使用することが出来ません。"));
    	}
    	
    	if($form->hasError()){
			return SOY2Action::FAILED;
		}
		
    	return SOY2Action::SUCCESS;
    }
    
	function getActionFormName(){
    	return "NewAccountForm";
    }
}
?>