/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AudioFileWriter {
    public abstract void close() throws IOException;

    public abstract void open(String var1) throws IOException;

    public abstract void writeHeader(String var1) throws IOException;

    public abstract void writePacket(byte[] var1, int var2, int var3) throws IOException;

    public static void writeShort(DataOutput dataOutput, short s) throws IOException {
        dataOutput.writeByte(0xFF & s);
        dataOutput.writeByte(0xFF & s >>> 8);
    }

    public static void writeInt(DataOutput dataOutput, int n) throws IOException {
        dataOutput.writeByte(0xFF & n);
        dataOutput.writeByte(0xFF & n >>> 8);
        dataOutput.writeByte(0xFF & n >>> 16);
        dataOutput.writeByte(0xFF & n >>> 24);
    }

    public static void writeShort(OutputStream outputStream, short s) throws IOException {
        outputStream.write(0xFF & s);
        outputStream.write(0xFF & s >>> 8);
    }

    public static void writeInt(OutputStream outputStream, int n) throws IOException {
        outputStream.write(0xFF & n);
        outputStream.write(0xFF & n >>> 8);
        outputStream.write(0xFF & n >>> 16);
        outputStream.write(0xFF & n >>> 24);
    }

    public static void writeLong(OutputStream outputStream, long l) throws IOException {
        outputStream.write((int)(0xFFL & l));
        outputStream.write((int)(0xFFL & l >>> 8));
        outputStream.write((int)(0xFFL & l >>> 16));
        outputStream.write((int)(0xFFL & l >>> 24));
        outputStream.write((int)(0xFFL & l >>> 32));
        outputStream.write((int)(0xFFL & l >>> 40));
        outputStream.write((int)(0xFFL & l >>> 48));
        outputStream.write((int)(0xFFL & l >>> 56));
    }
}

