/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans.bounds;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import uk.ac.ic.doc.scenebeans.CompositeNode;
import uk.ac.ic.doc.scenebeans.Input;
import uk.ac.ic.doc.scenebeans.Primitive;
import uk.ac.ic.doc.scenebeans.SceneGraph;
import uk.ac.ic.doc.scenebeans.Style;
import uk.ac.ic.doc.scenebeans.Transform;
import uk.ac.ic.doc.scenebeans.bounds.Bounds;
import uk.ac.ic.doc.scenebeans.bounds.LastDrawnBounds;

public class DirtyBounds
extends Bounds {
    public static Rectangle2D getBounds(SceneGraph sceneGraph, Graphics2D graphics2D) {
        DirtyBounds dirtyBounds = new DirtyBounds(graphics2D);
        try {
            sceneGraph.accept(dirtyBounds);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        return dirtyBounds.getBounds();
    }

    public DirtyBounds(Graphics2D graphics2D) {
        super(graphics2D);
    }

    public DirtyBounds(Graphics2D graphics2D, AffineTransform affineTransform) {
        super(graphics2D, affineTransform);
    }

    public void process(Primitive primitive) {
        if (primitive.isDirty()) {
            this.addBoundsOf(primitive);
        }
    }

    public void process(Transform transform) {
        if (transform.isDirty()) {
            this.addBoundsOf(transform);
        } else {
            super.process(transform);
        }
    }

    public void process(Input input) {
        if (input.isDirty()) {
            this.addBoundsOf(input);
        } else {
            super.process(input);
        }
    }

    public void process(Style style) {
        if (style.isDirty()) {
            this.addBoundsOf(style);
        } else {
            super.process(style);
        }
    }

    public void process(CompositeNode compositeNode) {
        if (compositeNode.isDirty()) {
            this.addBoundsOf(compositeNode);
        } else {
            super.process(compositeNode);
        }
    }

    private void addBoundsOf(SceneGraph sceneGraph) {
        this.addOldBoundsOf(sceneGraph);
        this.addNewBoundsOf(sceneGraph);
    }

    private void addOldBoundsOf(SceneGraph sceneGraph) {
        LastDrawnBounds lastDrawnBounds = new LastDrawnBounds(this.getGraphics(), this.getTransform());
        sceneGraph.accept(lastDrawnBounds);
        this.addBounds(lastDrawnBounds.getBounds());
    }

    private void addNewBoundsOf(SceneGraph sceneGraph) {
        Bounds bounds = new Bounds(this.getGraphics(), this.getTransform());
        sceneGraph.accept(bounds);
        this.addBounds(bounds.getBounds());
    }
}

