<?php

/**
 * BaseScreenPermission
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int               $id                        Type: integer, primary key
 * @property int               $user_role_id              Type: integer
 * @property int               $screen_id                 Type: integer
 * @property bool              $can_read                  Type: boolean
 * @property bool              $can_create                Type: boolean
 * @property bool              $can_update                Type: boolean
 * @property bool              $can_delete                Type: boolean
 * @property UserRole          $UserRole                  
 * @property Screen            $Screen                    
 *  
 * @method int                 getId()                    Type: integer, primary key
 * @method int                 getUserRoleId()            Type: integer
 * @method int                 getScreenId()              Type: integer
 * @method bool                getCanRead()               Type: boolean
 * @method bool                getCanCreate()             Type: boolean
 * @method bool                getCanUpdate()             Type: boolean
 * @method bool                getCanDelete()             Type: boolean
 * @method UserRole            getUserRole()              
 * @method Screen              getScreen()                
 *  
 * @method ScreenPermission    setId(int $val)            Type: integer, primary key
 * @method ScreenPermission    setUserRoleId(int $val)    Type: integer
 * @method ScreenPermission    setScreenId(int $val)      Type: integer
 * @method ScreenPermission    setCanRead(bool $val)      Type: boolean
 * @method ScreenPermission    setCanCreate(bool $val)    Type: boolean
 * @method ScreenPermission    setCanUpdate(bool $val)    Type: boolean
 * @method ScreenPermission    setCanDelete(bool $val)    Type: boolean
 * @method ScreenPermission    setUserRole(UserRole $val) 
 * @method ScreenPermission    setScreen(Screen $val)     
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseScreenPermission extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_user_role_screen');
        $this->hasColumn('id', 'integer', null, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             ));
        $this->hasColumn('user_role_id', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('screen_id', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('can_read', 'boolean', null, array(
             'type' => 'boolean',
             'default' => false,
             ));
        $this->hasColumn('can_create', 'boolean', null, array(
             'type' => 'boolean',
             'default' => false,
             ));
        $this->hasColumn('can_update', 'boolean', null, array(
             'type' => 'boolean',
             'default' => false,
             ));
        $this->hasColumn('can_delete', 'boolean', null, array(
             'type' => 'boolean',
             'default' => false,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('UserRole', array(
             'local' => 'user_role_id',
             'foreign' => 'id'));

        $this->hasOne('Screen', array(
             'local' => 'screen_id',
             'foreign' => 'id'));
    }
}