<?php
/**
 * File containing the ezcDocumentRstContentsDirective class
 *
 * @package Document
 * @version 1.3.1
 * @copyright Copyright (C) 2005-2010 eZ Systems AS. All rights reserved.
 * @license http://ez.no/licenses/new_bsd New BSD License
 */

/**
 * Visitor for RST contents directives
 *
 * @package Document
 * @version 1.3.1
 */
class ezcDocumentRstContentsDirective extends ezcDocumentRstDirective implements ezcDocumentRstXhtmlDirective
{
    /**
     * Transform directive to docbook
     *
     * Create a docbook XML structure at the directives position in the
     * document.
     *
     * @param DOMDocument $document
     * @param DOMElement $root
     * @return void
     */
    public function toDocbook( DOMDocument $document, DOMElement $root )
    {
        // Table of contents are normally automatically generated by the
        // presentation system from the docbook source, even there is an
        // element availabale for this in docbook:
        //
        // http://docbook.org/tdg5/en/html/toc.html
    }

    /**
     * Generate XHtml TOC
     *
     * Recursively generate a XHtml table of contents from the given section
     * with the specified depth. Use -1 as depth to display the complete
     * section tree.
     *
     * @param ezcDocumentRstSectionNode $node
     * @param DOMElement $root
     * @param int $depth
     * @return void
     */
    protected function generateTocList( ezcDocumentRstNode $node, DOMElement $root, $depth )
    {
        if ( $depth === 0 )
        {
            // We reached the specified maximum depth of the table of contents.
            return;
        }

        $list = null;
        foreach ( $node->nodes as $child )
        {
            if ( $child->type === ezcDocumentRstNode::SECTION )
            {
                if ( $list === null )
                {
                    $list = new DOMElement( 'ul' );
                    $root->appendChild( $list );
                }

                $item = new DOMElement( 'li' );
                $list->appendChild( $item );

                $link = new DOMElement( 'a', htmlspecialchars( $title = $this->visitor->nodeToString( $child->title ) ) );
                $item->appendChild( $link );

                // Force getting the reference target, as we don't care for
                // duplicate titles in the TOC.
                $target = $this->visitor->hasReferenceTarget( $title, $this->node, true );
                $link->setAttribute( 'href', '#' . htmlspecialchars( $this->visitor->escapeUrl( $target ) ) );

                $this->generateTocList( $child, $item, $depth - 1 );
            }
        }
    }

    /**
     * Transform directive to HTML
     *
     * Create a XHTML structure at the directives position in the document.
     *
     * @param DOMDocument $document
     * @param DOMElement $root
     * @return void
     */
    public function toXhtml( DOMDocument $document, DOMElement $root )
    {
        $depth = isset( $this->node->options['depth'] ) ? (int) $this->node->options['depth'] : -1;

        $div = $document->createElement( 'div' );
        $div->setAttribute( 'class', 'toc' );
        $root->appendChild( $div );

        $header = $document->createElement( 'div', htmlspecialchars(
            empty( $this->node->parameters ) ? 'Contents' : $this->node->parameters
        ) );
        $header->setAttribute( 'class', 'toc-header' );
        $div->appendChild( $header );

        foreach ( $this->ast->nodes as $node )
        {
            if ( $node->type === ezcDocumentRstNode::SECTION )
            {
                $this->generateTocList( $node, $div, $depth );
            }
        }
    }
}

?>
