/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class ThreadCheckingRepaintManager
extends RepaintManager {
    private boolean completeCheck = true;
    private boolean checkIsShowing = false;

    public ThreadCheckingRepaintManager() {
    }

    public ThreadCheckingRepaintManager(boolean checkIsShowing) {
        this.checkIsShowing = checkIsShowing;
    }

    public boolean isCompleteCheck() {
        return this.completeCheck;
    }

    public void setCompleteCheck(boolean completeCheck) {
        this.completeCheck = completeCheck;
    }

    public synchronized void addInvalidComponent(JComponent jComponent) {
        this.checkThreadViolations(jComponent);
        super.addInvalidComponent(jComponent);
    }

    public synchronized void addDirtyRegion(JComponent jComponent, int i, int i1, int i2, int i3) {
        this.checkThreadViolations(jComponent);
        super.addDirtyRegion(jComponent, i, i1, i2, i3);
    }

    private void checkThreadViolations(JComponent c) {
        if (!SwingUtilities.isEventDispatchThread() && (this.completeCheck || this.checkIsShowing(c))) {
            StackTraceElement[] stackTrace;
            Exception exception = new Exception();
            boolean repaint = false;
            boolean fromSwing = false;
            for (StackTraceElement st : stackTrace = exception.getStackTrace()) {
                if (repaint && st.getClassName().startsWith("javax.swing.")) {
                    fromSwing = true;
                }
                if (!"repaint".equals(st.getMethodName())) continue;
                repaint = true;
            }
            if (repaint && !fromSwing) {
                return;
            }
            System.out.println("----------Wrong Thread START");
            System.out.println(this.getStrackTraceAsString(exception));
            System.out.println("----------Wrong Thread END");
        }
    }

    private boolean checkIsShowing(JComponent c) {
        if (this.checkIsShowing) {
            return c.isShowing();
        }
        return true;
    }

    private String getStrackTraceAsString(Exception e) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        e.printStackTrace(printStream);
        printStream.flush();
        return byteArrayOutputStream.toString();
    }
}

