#ifndef __STK_SOUND
#define __STK_SOUND


#include <stdlib.h>
#include <string.h>
#include <list>
using namespace std;

#include <SDL/SDL.h>
#include <smpeg/smpeg.h>


#include "../kernel/stk_debug.h"
#include "../kernel/stk_looper.h"




// Constants
#define STK_MP3_STOPPED  3
#define STK_MP3_ERROR    2
#define STK_MP3_PLAYING  1
#define STK_MP3_UNKOWN   0


/** This class manage exceptions of sound */
class Ex_Sound
{
public:
};





class Stk_Sound
{
public:
        /// The constructor
    Stk_Sound();
        /// The destructor
    ~Stk_Sound();
    
        /// Load a MP3 file
    int LoadMP3(char *filename);

        /// Play
    void Play();
        /// Pause
    void Pause();
        /// Stop
    void Stop();
    
        /// Status
    int Status();
        /// Sound on
    void SoundOn();
        /// Sound off
    void SoundOff();
        /// Loop On
    void LoopOn();
        /// Loop Off
    void LoopOff();
    
private:
    SMPEG *mpeg;
    SMPEG_Info info;
};




/* ------------------------- Corba like ---------------------------- */
class Stk_ISound;
class Stk_CSound;
class Stk_PSound;


/** The interface class (like the idl file in corba):
    All functions are virtual.
*/
class Stk_ISound
{
public:
    virtual void Play(char *Mp3Filename) {};
};

/** The class to transport message */
class Stk_MessagePlay:public Stk2_Message
{
public:
    Stk_MessagePlay(char *filename);
    ~Stk_MessagePlay();
    char *Mp3Filename;
};




/** The command class */
class Stk_CSound : public Stk_ISound
{
public:
    Stk_CSound(Stk_PSound *s){
        server=s;
    };
    virtual ~Stk_CSound(){};
    void Play(char *);
private:
    Stk_PSound *server;
};


/** The program class */
class Stk_PSound : public Stk_ISound , public Stk2_Looper
{
public:
        // Constructor
    Stk_PSound(int freq=25);
        // Destructor
    virtual ~Stk_PSound();

        /// Loop function
    virtual void Loop();

    virtual void Play(char *filename);
private:
    Stk_Sound *sound;
    char *lastsing;
};

#endif
