;; Firepower map editing tools
;; Joe Rumsey

;; Just do M-x firepower-new-map and follow the prompts
;; Once you have a blank map, you will be in picture-mode, 
;; plus pressing C-t will place a random tree.  Hold ^t down
;; for a while to scatter 'em all over.
;; 
;; Note:  You will still need to place exactly one starting point
;; for both teams ('1' for team one, '2' for team 2) and at least one
;; flag for each team ('O' for team one, 'T' for team 2)
;;

(defun random-point (arg1 arg2)
  "Move point to a random location between ARG1 and ARG2"
  (interactive)
  (set-window-point (selected-window) 
		    (+ arg2 (mod (random) (- arg1 arg2)))))

(defun firepower-plant-tree ()
  "plant a tree at a random spot on a firepower map"
  (interactive)
  (set-window-point (selected-window) 0)
  (forward-line 2)
  (random-point (point) (point-max))
  (if (char-equal ?. (char-after (point)))
      (progn (insert-char ?t 1)
	     (delete-char 1))))

(defun firepower-new-map (file w h)
  "Ask for a file name, width, and height, then create a new map"
  (interactive (list 
		(read-string "File name: " default-directory)
		(read-number "Width: ")
		(read-number "Height: ")))
  (find-file file)
  (set-window-point (selected-window) 0)
  (insert (file-name-nondirectory file) "\n")
  (insert (number-to-string w) " " (number-to-string h) "\n")
  (setq y 0)
  (while (< y h)
    (progn
      (insert-char ?. w)
      (insert-char ?\n 1)
      (setq y (+ y 1))))
  (picture-mode)
  (local-set-key "\C-t" 'firepower-plant-tree))




