/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.UnicastServer;
import gnu.java.rmi.server.UnicastServerRef;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.Remote;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RemoteStub;

public class RMIObjectOutputStream
extends ObjectOutputStream {
    protected void setAnnotation(String string) throws IOException {
        this.writeObject(string);
    }

    protected void annotateClass(Class clazz) throws IOException {
        this.setAnnotation(RMIClassLoader.getClassAnnotation(clazz));
    }

    protected void annotateProxyClass(Class clazz) throws IOException {
        this.annotateClass(clazz);
    }

    protected Object replaceObject(Object object) throws IOException {
        UnicastServerRef unicastServerRef;
        if (object instanceof Remote && !(object instanceof RemoteStub) && (unicastServerRef = UnicastServer.getExportedRef((Remote)object)) != null) {
            return unicastServerRef.getStub();
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeValue(Object object, Class clazz) throws IOException {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                this.writeBoolean((Boolean)object);
                return;
            } else if (clazz == Byte.TYPE) {
                this.writeByte(((Byte)object).byteValue());
                return;
            } else if (clazz == Character.TYPE) {
                this.writeChar(((Character)object).charValue());
                return;
            } else if (clazz == Short.TYPE) {
                this.writeShort(((Short)object).shortValue());
                return;
            } else if (clazz == Integer.TYPE) {
                this.writeInt((Integer)object);
                return;
            } else if (clazz == Long.TYPE) {
                this.writeLong((Long)object);
                return;
            } else if (clazz == Float.TYPE) {
                this.writeFloat(((Float)object).floatValue());
                return;
            } else {
                if (clazz != Double.TYPE) throw new Error("Unsupported primitive class: " + clazz);
                this.writeDouble((Double)object);
            }
            return;
        } else {
            this.writeObject(object);
        }
    }

    public RMIObjectOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
        this.enableReplaceObject(true);
    }
}

