/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPDecoder;
import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class DecodeRGB24
extends BMPDecoder {
    public BufferedImage decode(ImageInputStream imageInputStream) throws IOException, BMPException {
        this.skipToImage(imageInputStream);
        Dimension dimension = this.infoHeader.getSize();
        int n = (int)dimension.getHeight();
        int n2 = (int)dimension.getWidth();
        BufferedImage bufferedImage = new BufferedImage(n2, n, 1);
        int n3 = (n2 * 3 & 3) != 0 ? n2 * 3 + 4 - (n2 * 3 & 3) : n2 * 3;
        int[] nArray = new int[n2 * n];
        int n4 = n - 1;
        while (n4 >= 0) {
            byte[] byArray = new byte[n3];
            if (imageInputStream.read(byArray) != n3) {
                throw new IOException("Couldn't read image data.");
            }
            int n5 = 0;
            while (n5 < n2) {
                nArray[n5 + n4 * n2] = byArray[n5 * 3] + (byArray[n5 * 3 + 1] << 8) + (byArray[n5 * 3 + 2] << 16);
                ++n5;
            }
            --n4;
        }
        bufferedImage.setRGB(0, 0, n2, n, nArray, 0, n2);
        return bufferedImage;
    }

    public DecodeRGB24(BMPFileHeader bMPFileHeader, BMPInfoHeader bMPInfoHeader) {
        super(bMPFileHeader, bMPInfoHeader);
    }
}

