/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Float
extends Number
implements Comparable {
    private static final long serialVersionUID = -2671257302660747028L;
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final float MIN_VALUE = 1.4E-45f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NaN = 0.0f / 0.0f;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('F');
    public static final int SIZE = 32;
    private final float value;

    public static final String toString(float f) {
        return VMDouble.toString(f, true);
    }

    public static final String toHexString(float f) {
        int n;
        if (Float.isNaN(f)) {
            return "NaN";
        }
        if (Float.isInfinite(f)) {
            return f < 0.0f ? "-Infinity" : "Infinity";
        }
        int n2 = Float.floatToIntBits(f);
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 < 0) {
            stringBuilder.append('-');
        }
        stringBuilder.append("0x");
        int n3 = 0x7FFFFF;
        int n4 = n2 & n3;
        int n5 = 255;
        int n6 = n2 >>> 23 & n5;
        int n7 = 0;
        if (n6 == 0) {
            n7 = 1;
        }
        stringBuilder.append(49 - n7);
        stringBuilder.append('.');
        stringBuilder.append(Integer.toHexString(n4 <<= 1));
        if (n6 == 0 && n4 != 0) {
            int n8 = 0;
            if (n2 < 0) {
                n8 = 1;
            }
            n = 4 + n8;
            int n9 = n + 6;
            while (stringBuilder.length() < n9) {
                stringBuilder.insert(n, '0');
            }
        }
        stringBuilder.append('p');
        if (n6 != 0 || n4 != 0) {
            int n10 = 0;
            if (n6 == 0) {
                n10 = 1;
            }
            n = n10;
            n6 -= 127;
            if (n != 0) {
                ++n6;
            }
        }
        stringBuilder.append(Integer.toString(n6));
        return stringBuilder.toString();
    }

    public static final Float valueOf(String string) {
        return new Float(Float.parseFloat(string));
    }

    public static final Float valueOf(float f) {
        return new Float(f);
    }

    public static final float parseFloat(String string) {
        return (float)Double.parseDouble(string);
    }

    public static final boolean isNaN(float f) {
        boolean bl = false;
        if (f != f) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isInfinite(float f) {
        boolean bl = false;
        if (f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY) {
            bl = true;
        }
        return bl;
    }

    public final boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public final boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public final String toString() {
        return Float.toString(this.value);
    }

    public final byte byteValue() {
        return (byte)this.value;
    }

    public final short shortValue() {
        return (short)this.value;
    }

    public final int intValue() {
        return (int)this.value;
    }

    public final long longValue() {
        return (long)this.value;
    }

    public final float floatValue() {
        return this.value;
    }

    public final double doubleValue() {
        return this.value;
    }

    public final int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Float)) {
            return false;
        }
        float f = ((Float)object).value;
        if (this.value == f) {
            boolean bl = false;
            if (this.value != 0.0f || 1.0f / this.value == 1.0f / f) {
                bl = true;
            }
            return bl;
        }
        boolean bl = false;
        if (Float.isNaN(this.value) && Float.isNaN(f)) {
            bl = true;
        }
        return bl;
    }

    public static final int floatToIntBits(float f) {
        return VMFloat.floatToIntBits(f);
    }

    public static final int floatToRawIntBits(float f) {
        return VMFloat.floatToRawIntBits(f);
    }

    public static final float intBitsToFloat(int n) {
        return VMFloat.intBitsToFloat(n);
    }

    public final int compareTo(Float f) {
        return Float.compare(this.value, f.value);
    }

    public final int compareTo(Object object) {
        return Float.compare(this.value, ((Float)object).value);
    }

    public static final int compare(float f, float f2) {
        if (Float.isNaN(f)) {
            return 1 - Float.isNaN(f2);
        }
        if (Float.isNaN(f2)) {
            return -1;
        }
        if (f == 0.0f && f2 == 0.0f) {
            return (int)(1.0f / f - 1.0f / f2);
        }
        if (f == f2) {
            return 0;
        }
        return f > f2 ? 1 : -1;
    }

    public Float(float f) {
        this.value = f;
    }

    public Float(double d) {
        this.value = (float)d;
    }

    public Float(String string) {
        this.value = Float.parseFloat(string);
    }
}

