/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.dom.bootstrap;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DOMImplementationList;
import org.w3c.dom.DOMImplementationSource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DOMImplementationRegistry {
    public static final String PROPERTY = "org.w3c.dom.DOMImplementationSourceList";
    private static final int DEFAULT_LINE_LENGTH = 80;
    private Vector sources;
    static /* synthetic */ Class class$org$w3c$dom$bootstrap$DOMImplementationRegistry;

    public static final DOMImplementationRegistry newInstance() throws ClassNotFoundException, InstantiationException, IllegalAccessException, ClassCastException {
        Vector vector = new Vector();
        ClassLoader classLoader = DOMImplementationRegistry.getClassLoader();
        String string = DOMImplementationRegistry.getSystemProperty(PROPERTY);
        if (string == null) {
            string = DOMImplementationRegistry.getServiceValue(classLoader);
        }
        if (string == null) {
            string = "gnu.xml.dom.ImplementationSource";
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                Class clazz = null;
                clazz = classLoader != null ? classLoader.loadClass(string2) : Class.forName(string2);
                DOMImplementationSource dOMImplementationSource = (DOMImplementationSource)clazz.newInstance();
                vector.addElement(dOMImplementationSource);
            }
        }
        return new DOMImplementationRegistry(vector);
    }

    public final DOMImplementation getDOMImplementation(String string) {
        int n = this.sources.size();
        Object var3_3 = null;
        int n2 = 0;
        while (n2 < n) {
            DOMImplementationSource dOMImplementationSource = (DOMImplementationSource)this.sources.elementAt(n2);
            DOMImplementation dOMImplementation = dOMImplementationSource.getDOMImplementation(string);
            if (dOMImplementation != null) {
                return dOMImplementation;
            }
            ++n2;
        }
        return null;
    }

    public final DOMImplementationList getDOMImplementationList(String string) {
        final Vector vector = new Vector();
        int n = this.sources.size();
        int n2 = 0;
        while (n2 < n) {
            DOMImplementationSource dOMImplementationSource = (DOMImplementationSource)this.sources.elementAt(n2);
            DOMImplementationList dOMImplementationList = dOMImplementationSource.getDOMImplementationList(string);
            int n3 = 0;
            while (n3 < dOMImplementationList.getLength()) {
                DOMImplementation dOMImplementation = dOMImplementationList.item(n3);
                vector.addElement(dOMImplementation);
                ++n3;
            }
            ++n2;
        }
        return new DOMImplementationList(){

            public final DOMImplementation item(int n) {
                if (n >= 0 && n < vector.size()) {
                    try {
                        return (DOMImplementation)vector.elementAt(n);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        return null;
                    }
                }
                return null;
            }

            public final int getLength() {
                return vector.size();
            }
        };
    }

    public final void addSource(DOMImplementationSource dOMImplementationSource) {
        if (dOMImplementationSource == null) {
            throw new NullPointerException();
        }
        if (!this.sources.contains(dOMImplementationSource)) {
            this.sources.addElement(dOMImplementationSource);
        }
    }

    private static final ClassLoader getClassLoader() {
        try {
            ClassLoader classLoader = DOMImplementationRegistry.getContextClassLoader();
            if (classLoader != null) {
                return classLoader;
            }
        }
        catch (Exception exception) {
            Class clazz = class$org$w3c$dom$bootstrap$DOMImplementationRegistry;
            if (clazz == null) {
                clazz = class$org$w3c$dom$bootstrap$DOMImplementationRegistry = DOMImplementationRegistry.class("[Lorg.w3c.dom.bootstrap.DOMImplementationRegistry;", false);
            }
            return clazz.getClassLoader();
        }
        Class clazz = class$org$w3c$dom$bootstrap$DOMImplementationRegistry;
        if (clazz == null) {
            clazz = class$org$w3c$dom$bootstrap$DOMImplementationRegistry = DOMImplementationRegistry.class("[Lorg.w3c.dom.bootstrap.DOMImplementationRegistry;", false);
        }
        return clazz.getClassLoader();
    }

    private static final String getServiceValue(ClassLoader classLoader) {
        block5: {
            String string = "META-INF/services/org.w3c.dom.DOMImplementationSourceList";
            try {
                BufferedReader bufferedReader;
                InputStream inputStream = DOMImplementationRegistry.getResourceAsStream(classLoader, string);
                if (inputStream == null) break block5;
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"), 80);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream), 80);
                }
                String string2 = bufferedReader.readLine();
                bufferedReader.close();
                if (string2 != null && string2.length() > 0) {
                    return string2;
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    private static final boolean isJRE11() {
        try {
            Class clazz = Class.forName("java.security.AccessController");
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    private static final ClassLoader getContextClassLoader() {
        return DOMImplementationRegistry.isJRE11() ? null : (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public final Object run() {
                ClassLoader classLoader = null;
                try {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {}
                return classLoader;
            }
        });
    }

    private static final String getSystemProperty(final String string) {
        return DOMImplementationRegistry.isJRE11() ? System.getProperty(string) : (String)AccessController.doPrivileged(new PrivilegedAction(){

            public final Object run() {
                return System.getProperty(string);
            }
        });
    }

    private static final InputStream getResourceAsStream(final ClassLoader classLoader, final String string) {
        if (DOMImplementationRegistry.isJRE11()) {
            InputStream inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string) : classLoader.getResourceAsStream(string);
            return inputStream;
        }
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public final Object run() {
                InputStream inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string) : classLoader.getResourceAsStream(string);
                return inputStream;
            }
        });
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private DOMImplementationRegistry(Vector vector) {
        this.sources = vector;
    }
}

