/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Message;
import org.xbill.DNS.Mnemonic;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SIGRecord;

public class DNSSEC {
    public static final int RSAMD5 = 1;
    public static final int RSA = 1;
    public static final int DH = 2;
    public static final int DSA = 3;
    public static final int RSASHA1 = 5;
    public static final int Failed = -1;
    public static final int Insecure = 0;
    public static final int Secure = 1;
    private static Comparator byteArrayComparator = new ByteArrayComparator();

    private static final void digestSIG(DNSOutput dNSOutput, SIGRecord sIGRecord) {
        dNSOutput.writeU16(sIGRecord.getTypeCovered());
        dNSOutput.writeU8(sIGRecord.getAlgorithm());
        dNSOutput.writeU8(sIGRecord.getLabels());
        dNSOutput.writeU32(sIGRecord.getOrigTTL());
        dNSOutput.writeU32(sIGRecord.getExpire().getTime() / 1000L);
        dNSOutput.writeU32(sIGRecord.getTimeSigned().getTime() / 1000L);
        dNSOutput.writeU16(sIGRecord.getFootprint());
        sIGRecord.getSigner().toWireCanonical(dNSOutput);
    }

    public static byte[] digestRRset(SIGRecord sIGRecord, RRset rRset) {
        DNSOutput dNSOutput = new DNSOutput();
        DNSSEC.digestSIG(dNSOutput, sIGRecord);
        int n = rRset.size();
        byte[][] byArrayArray = new byte[n][];
        Iterator iterator = rRset.rrs();
        Name name = rRset.getName();
        Name name2 = null;
        int n2 = sIGRecord.getLabels() + 1;
        if (name.labels() > n2) {
            name2 = name.wild(name.labels() - n2);
        }
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (name2 != null) {
                record = record.withName(name2);
            }
            byArrayArray[--n] = record.toWireCanonical();
        }
        Arrays.sort((Object[])byArrayArray, byteArrayComparator);
        int n3 = 0;
        while (n3 < byArrayArray.length) {
            dNSOutput.writeByteArray(byArrayArray[n3]);
            ++n3;
        }
        return dNSOutput.toByteArray();
    }

    public static byte[] digestMessage(SIGRecord sIGRecord, Message message, byte[] byArray) {
        DNSOutput dNSOutput = new DNSOutput();
        DNSSEC.digestSIG(dNSOutput, sIGRecord);
        if (byArray != null) {
            dNSOutput.writeByteArray(byArray);
        }
        message.toWire(dNSOutput);
        return dNSOutput.toByteArray();
    }

    private DNSSEC() {
    }

    private static class ByteArrayComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            byte[] byArray = (byte[])object;
            byte[] byArray2 = (byte[])object2;
            int n = Math.min(byArray.length, byArray2.length);
            int n2 = 0;
            while (n2 < n) {
                int n3 = (byArray[n2] & 0xFF) - (byArray2[n2] & 0xFF);
                if (n3 != 0) {
                    return n3;
                }
                ++n2;
            }
            return byArray.length - byArray2.length;
        }

        private ByteArrayComparator() {
        }
    }

    public static class Algorithm {
        public static final int RSAMD5 = 1;
        public static final int DH = 2;
        public static final int DSA = 3;
        public static final int ECC = 4;
        public static final int RSASHA1 = 5;
        public static final int INDIRECT = 252;
        public static final int PRIVATEDNS = 253;
        public static final int PRIVATEOID = 254;
        private static Mnemonic algs = new Mnemonic("DNSSEC algorithm", 2);

        public static String string(int n) {
            return algs.getText(n);
        }

        public static int value(String string) {
            return algs.getValue(string);
        }

        private Algorithm() {
        }

        static {
            algs.setMaximum(255);
            algs.setNumericAllowed(true);
            algs.add(1, "RSAMD5");
            algs.add(2, "DH");
            algs.add(3, "DSA");
            algs.add(4, "ECC");
            algs.add(5, "RSASHA1");
            algs.add(252, "INDIRECT");
            algs.add(253, "PRIVATEDNS");
            algs.add(254, "PRIVATEOID");
        }
    }
}

