/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.xbill.DNS.Address;
import org.xbill.DNS.Name;
import org.xbill.DNS.TextParseException;

public final class ReverseMap {
    private static Name inaddr4 = Name.fromConstantString("in-addr.arpa.");
    private static Name inaddr6 = Name.fromConstantString("ip6.arpa.");

    public static final Name fromAddress(byte[] byArray) {
        if (byArray.length != 4 && byArray.length != 16) {
            throw new IllegalArgumentException("array must contain 4 or 16 elements");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray.length == 4) {
            int n = byArray.length - 1;
            while (n >= 0) {
                stringBuffer.append(byArray[n] & 0xFF);
                if (n > 0) {
                    stringBuffer.append(".");
                }
                --n;
            }
        } else {
            int[] nArray = new int[2];
            int n = byArray.length - 1;
            while (n >= 0) {
                nArray[0] = (byArray[n] & 0xFF) >> 4;
                nArray[1] = byArray[n] & 0xFF & 0xF;
                int n2 = nArray.length - 1;
                while (n2 >= 0) {
                    stringBuffer.append(Integer.toHexString(nArray[n2]));
                    if (n > 0 || n2 > 0) {
                        stringBuffer.append(".");
                    }
                    --n2;
                }
                --n;
            }
        }
        try {
            if (byArray.length == 4) {
                return Name.fromString(stringBuffer.toString(), inaddr4);
            }
            return Name.fromString(stringBuffer.toString(), inaddr6);
        }
        catch (TextParseException textParseException) {
            throw new IllegalStateException("name cannot be invalid");
        }
    }

    public static final Name fromAddress(int[] nArray) {
        byte[] byArray = new byte[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] < 0 || nArray[n] > 255) {
                throw new IllegalArgumentException("array must contain values between 0 and 255");
            }
            byArray[n] = (byte)nArray[n];
            ++n;
        }
        return ReverseMap.fromAddress(byArray);
    }

    public static final Name fromAddress(InetAddress inetAddress) {
        return ReverseMap.fromAddress(inetAddress.getAddress());
    }

    public static final Name fromAddress(String string, int n) throws UnknownHostException {
        byte[] byArray = Address.toByteArray(string, n);
        if (byArray == null) {
            throw new UnknownHostException("Invalid IP address");
        }
        return ReverseMap.fromAddress(byArray);
    }

    public static final Name fromAddress(String string) throws UnknownHostException {
        return ReverseMap.fromAddress(string, 1);
    }

    private ReverseMap() {
    }
}

