class SushiNet::StoreSearchTask < Borges::Task

  def initialize(search_string)
    @search = search_string
  end

  def go
    results = session.find_item(@search)

    if results.size == 0 then
      no_results

    elsif results.size == 1 then
      one_result results.first

    else 
      many_results results

    end
  end

  def many_results(items)
    call SushiNet::StoreItemList.new(items)
  end

  def no_results
    inform "Sorry, no results were found matching #{@search}"
  end

  def one_result(item)
    call SushiNet::StoreItemView.new(item)
  end

end # class SushiNet::StoreSearchTask

