/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.Serializable;
import java.util.ResourceBundle;

public class Level
implements Serializable {
    public static final Level OFF = new Level("OFF", Integer.MAX_VALUE);
    public static final Level SEVERE = new Level("SEVERE", 1000);
    public static final Level WARNING = new Level("WARNING", 900);
    public static final Level INFO = new Level("INFO", 800);
    public static final Level CONFIG = new Level("CONFIG", 700);
    public static final Level FINE = new Level("FINE", 500);
    public static final Level FINER = new Level("FINER", 400);
    public static final Level FINEST = new Level("FINEST", 300);
    public static final Level ALL = new Level("ALL", Integer.MIN_VALUE);
    private static final Level[] knownLevels = new Level[]{ALL, FINEST, FINER, FINE, CONFIG, INFO, WARNING, SEVERE, OFF};
    static final long serialVersionUID = -8176160795706313070L;
    private String name;
    private int value;
    private String resourceBundleName;

    private final Object readResolve() {
        int i = 0;
        while (i < knownLevels.length) {
            if (this.value == knownLevels[i].intValue()) {
                return knownLevels[i];
            }
            ++i;
        }
        return this;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public String getName() {
        return this.name;
    }

    public String getLocalizedName() {
        String localizedName = null;
        if (this.resourceBundleName != null) {
            try {
                ResourceBundle b = ResourceBundle.getBundle(this.resourceBundleName);
                localizedName = b.getString(this.name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (localizedName != null) {
            return localizedName;
        }
        return this.name;
    }

    public final String toString() {
        return this.getName();
    }

    public final int intValue() {
        return this.value;
    }

    public static Level parse(String name) throws IllegalArgumentException {
        name = name.intern();
        int i = 0;
        while (i < knownLevels.length) {
            if (name == Level.knownLevels[i].name) {
                return knownLevels[i];
            }
            ++i;
        }
        try {
            int num = Integer.parseInt(name);
            int i2 = 0;
            while (i2 < knownLevels.length) {
                if (num == Level.knownLevels[i2].value) {
                    return knownLevels[i2];
                }
                ++i2;
            }
        }
        catch (NumberFormatException msg) {
            // empty catch block
        }
        String msg = "Not the name of a standard logging level: \"" + name + '\"';
        throw new IllegalArgumentException(msg);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Level)) {
            return false;
        }
        boolean bl = false;
        if (this.value == ((Level)other).value) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        return this.value;
    }

    final boolean isStandardLevel() {
        int i = 0;
        while (i < knownLevels.length) {
            if (knownLevels[i] == this) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Level(String name, int value) {
        this(name, value, null);
    }

    protected Level(String name, int value, String resourceBundleName) {
        this.name = name;
        this.value = value;
        this.resourceBundleName = resourceBundleName;
    }
}

