/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.pad;

import gnu.javax.crypto.pad.BasePad;
import gnu.javax.crypto.pad.WrongPaddingException;

public class TLS1
extends BasePad {
    public void setup() {
        if (this.blockSize <= 0 || this.blockSize > 255) {
            throw new IllegalArgumentException("invalid block size: " + this.blockSize);
        }
    }

    public byte[] pad(byte[] byArray, int n, int n2) {
        int n3 = this.blockSize - n2 % this.blockSize;
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        while (n4 < n3) {
            byArray2[n4] = (byte)(n3 - 1);
            ++n4;
        }
        return byArray2;
    }

    public int unpad(byte[] byArray, int n, int n2) throws WrongPaddingException {
        int n3 = byArray[n + n2 - 1] & 0xFF;
        int n4 = n + (n2 - n3 - 1);
        while (n4 < n + n2 - 1) {
            if ((byArray[n4] & 0xFF) != n3) {
                throw new WrongPaddingException();
            }
            ++n4;
        }
        return n3 + 1;
    }

    public TLS1() {
        super("tls1");
    }
}

